﻿function OvaleFrame_OnLoad(self)
	self.icone = CreateFrame("Frame",nil,self,"OvaleIcone");
	self.icone:SetAllPoints(self)
	self.icone:Show();
	
	--self.cases = {}
	--local case = CreateFrame("Button", "OvaleCheck", self)
	--case:SetPoint("TOPLEFT", 0, 0)
	--self.cases[#self.cases] = case
	self.checkBoxes = {}
end

function OvaleFrame_Update(self)
	for v,k in pairs(self.checkBoxes) do
		k:Hide()
	end
	
	for v,k in pairs(Ovale.casesACocher) do
		if (not self.checkBoxes[v]) then
			self.checkBoxes[v] = OvaleFrame_CreateCheckBox(self, v)
		end
		self.checkBoxes[v]:Show()
		self.checkBoxes[v].text:SetText(k)
	end
end

-- Lâchement pompé sur AceGUI
local function CheckBox_OnEnter(self)
	self.highlight:Show()
end

local function CheckBox_OnLeave(self)
	self.highlight:Hide()
end

local function CheckBox_OnMouseUp(self)
	self:ToggleChecked()
	self.text:SetPoint("LEFT",self.check,"RIGHT",0,0)
	self.down = nil
end

local function CheckBox_OnMouseDown(self)
	self.text:SetPoint("LEFT",self.check,"RIGHT",1,-1)
	self.down = true
end

local function SetValue(self,value)
	local check = self.check
	self.checked = value
	if value then
		self.check:Show()
	else
		self.check:Hide()
	end
end

local function ToggleChecked(self)
	self:SetValue(not self.checked)
end

function OvaleFrame_CreateCheckBox(self, y)
	local button
	button = CreateFrame("Button", nil, self)
	button:SetPoint("TOPLEFT",self,"TOPRIGHT",0,-(y-1)*20)
	
	local text = button:CreateFontString(nil,"OVERLAY","GameFontHighlight")
	button.text = text
	
	button:SetScript("OnEnter",CheckBox_OnEnter)
	button:SetScript("OnLeave",CheckBox_OnLeave)
	button:SetScript("OnMouseUp",CheckBox_OnMouseUp)
	button:SetScript("OnMouseDown",CheckBox_OnMouseDown)
	button.ToggleChecked = ToggleChecked
	button.SetValue = SetValue

	button:EnableMouse()
	local checkbg = button:CreateTexture(nil,"ARTWORK")
	button.checkbg = checkbg
	checkbg:SetWidth(24)
	checkbg:SetHeight(24)
	checkbg:SetPoint("LEFT",button,"LEFT",0,0)
	checkbg:SetTexture("Interface\\Buttons\\UI-CheckBox-Up")
	local check = button:CreateTexture(nil,"OVERLAY")
	button.checked = true
	button.check = check
	check:SetWidth(24)
	check:SetHeight(24)
	check:SetPoint("CENTER",checkbg,"CENTER",0,0)
	check:SetTexture("Interface\\Buttons\\UI-CheckBox-Check")

	local highlight = button:CreateTexture(nil, "BACKGROUND")
	button.highlight = highlight
	highlight:SetTexture("Interface\\Buttons\\UI-CheckBox-Highlight")
	highlight:SetBlendMode("ADD")
	highlight:SetAllPoints(checkbg)
	highlight:Hide()
	
	text:SetJustifyH("LEFT")
	button:SetHeight(24)
	button:SetWidth(24)
	text:SetHeight(18)
	text:SetPoint("LEFT",check,"RIGHT",0,0)
	text:SetPoint("RIGHT",frame,"RIGHT",0,0)
	text:SetText("Test")
	
	return button
end

function OvaleFrame_OnUpdate(self)

end
function OvaleFrame_OnMouseDown(self,button)
	if ( button == "LeftButton") then
		self:StartMoving();
	end
end

function OvaleFrame_OnMouseUp(self, button)
	if ( button == "LeftButton" ) then	
		self:StopMovingOrSizing();
	end
end

function OvaleFrame_SetAOE()

end