local L = LibStub("AceLocale-3.0"):GetLocale("Ovale")

Ovale = LibStub("AceAddon-3.0"):NewAddon("Ovale", "AceEvent-3.0", "AceConsole-3.0")

Ovale.action = {}
Ovale.listeSorts = {}
Ovale.casesACocher = {}
Ovale.actionSort = {}
Ovale.listeFormes = {}
Ovale.listeTalents = {}
Ovale.pointsTalent = {}
Ovale.talentIdToName = {}
Ovale.talentNameToId = {}
Ovale.firstInit = false
Ovale.Inferieur = 1
Ovale.Superieur = 2
Ovale.retourPriorite = 0
Ovale.retourAction = nil
Ovale.listeTalentsRemplie = false

Ovale.arbre = {}

-- Ovale.trace=true
local nouvelleCondition
local nouveauSort
local options = { 
    type='group',
    args = {
        casesACocher = {
			type = 'group',
			name = "Cases à cocher",
			desc = "La liste des cases à cocher",
			args = {	
				ajouter = {
					type = 'execute',
					name = "Ajouter",
					desc = "Rajoute une case à cocher",
					func = function() 
						local nouvelle = "Nouvelle"
						local id = #Ovale.casesACocher+1
						Ovale.casesACocher[id] = nouvelle
						Ovale:AjouterCaseACocher(id,nouvelle)
					end
				},
			}
		},
		
    },
}

function Ovale:OnInitialize()
	self.AceConfig = LibStub("AceConfig-3.0");
	self.AceConfigDialog = LibStub("AceConfigDialog-3.0");
	self.AceConfig:RegisterOptionsTable("Ovale", options, "Ovale")
	self.optFrame = self.AceConfigDialog:AddToBlizOptions("Ovale", "Ovale")
	
end

function Ovale:CHARACTER_POINTS_CHANGED()
	self:RemplirListeTalents()
	self:InitEcranOption();
end

function Ovale:SPELLS_CHANGED()
	self:RemplirListeSorts();
	self:RemplirListeFormes()
	self:RemplirActionIndexes()
	self:RemplirListeTalents()
	self:InitEcranOption();
end

function Ovale:FirstInit()
	self:RemplirListeConditions()
	self:RemplirListeSorts()
	self:RemplirListeFormes()
	self:RemplirActionIndexes()
	self:RemplirListeTalents()
	self:ChargerDefaut()
	self:InitEcranOption()
	
	local playerClass, englishClass = UnitClass("player")
	if (englishClass == "ROGUE") then
		self.gcd = 1
	else
		self.gcd = 1.5
	end
	OvaleFrame_Update(OvaleFrame)
	OvaleFrame:Show()
	self.firstInit = true
end

function Ovale:OnEnable()
    -- Called when the addon is enabled
    self:RegisterEvent("PLAYER_REGEN_ENABLED");
    self:RegisterEvent("PLAYER_REGEN_DISABLED");
    self:RegisterEvent("SPELLS_CHANGED")
    self:RegisterEvent("CHARACTER_POINTS_CHANGED")
	
	if (not self.firstInit) then
		self:FirstInit()
	end
	
end

function Ovale:PLAYER_REGEN_ENABLED()
end

function Ovale:PLAYER_REGEN_DISABLED()
end

function Ovale:OnDisable()
    -- Called when the addon is disabled
    self:UnregisterEvent("PLAYER_REGEN_ENABLED")
    self:UnregisterEvent("PLAYER_REGEN_DISABLED")
    OvaleFrame:Hide()
end

function Ovale:GetMessage()
    return self.db.profile.message
end

function Ovale:SetMessage(newValue)
    self.db.profile.message = newValue
end

function Ovale_GetNomAction(i)
	local actionText = GetActionText(i);
	local text;
	if (actionText) then
		text = "Macro "..actionText;
	else
		local type, id = GetActionInfo(i);
		if (type=="spell") then
			local spellName, spellRank = GetSpellName(id, BOOKTYPE_SPELL);
			text = "Sort ".. spellName;
			if (spellRank and spellRank~="") then
				text = text .. " ("..spellRank..")"
			end
		elseif (type =="item") then
			local itemName = GetItemInfo(id)
			text = "Objet "..itemName
		else 
			if (type) then
				text = type;
				if (id) then
					text = text.." "..id;
				end
			end
		end
	end
	return text
end

function Ovale:ChercherShortcut(id)
-- ACTIONBUTTON1..12 => principale (1..12, 13..24, 73..108)
-- MULTIACTIONBAR1BUTTON1..12 => bas gauche (61..72)
-- MULTIACTIONBAR2BUTTON1..12 => bas droite (49..60)
-- MULTIACTIONBAR3BUTTON1..12 => haut droit (25..36)
-- MULTIACTIONBAR4BUTTON1..12 => haut gauche (37..48)
	local name;
	if (id<=24 or id>72) then
		name = "ACTIONBUTTON"..(((id-1)%12)+1);
	elseif (id<=36) then
		name = "MULTIACTIONBAR3BUTTON"..(id-24);
	elseif (id<=48) then
		name = "MULTIACTIONBAR4BUTTON"..(id-36);
	elseif (id<=60) then
		name = "MULTIACTIONBAR2BUTTON"..(id-48);
	else
		name = "MULTIACTIONBAR1BUTTON"..(id-60);
	end
	local key = GetBindingKey(name);
--[[	if (not key) then
		DEFAULT_CHAT_FRAME:AddMessage(id.."=>"..name.." introuvable")
	else
		DEFAULT_CHAT_FRAME:AddMessage(id.."=>"..name.."="..key)
	end]]
	return key;
end

function Ovale:GetSpellInfoOrNil(spell)
	if (spell) then
		return GetSpellInfo(spell)
	else
		return nil
	end
end

function Ovale:GetSpellIdByName(name)
	if (not name) then
		return nil
	end
	local link = GetSpellLink(name);
	if (not link) then
		-- self:Print(name.." introuvable");
		return nil;
	end
	local a, b, spellId = string.find(link, "spell:(%d+)");
	return tonumber(spellId);
end

function Ovale:GetSpellIdRangMax(spellId)
	return self:GetSpellIdByName(GetSpellInfo(spellId))
end

function Ovale:GetSpellIdByNameAndRank(name,rank)
	if (not name or not rank) then
		return nil
	end
	local link = GetSpellLink(name.."("..rank..")");
	if (not link) then
		-- self:Print(name.."("..rank..")".." introuvable");
		return nil;
	end
	local a, b, spellId = string.find(link, "spell:(%d+)");
	return tonumber(spellId);
end
function Ovale:AjouterCaseACocher(id, case)
	local nouveau
		
	nouveau = 
	{
		type = "group",
		name = Ovale.casesACocher[id],
		args =
		{
			nom =
			{	
				type = "input",
				name = "Nom",
				desc = "Nom de la case à cocher",
				set = function(info, value) 
					Ovale.casesACocher[id] = value; 
					nouveau.name = value 
					OvaleFrame_Update(OvaleFrame)
				end,
				get = function(info) return Ovale.casesACocher[id] end
			}
		}
	}
	options.args.casesACocher.args[""..id] = nouveau
end

function Ovale:RemplirActionIndexes()
	self.actionSort = {}
	self.actionMacro = {}
	self.actionObjet = {}
	self.shortCut = {}
	
	for i=1,120 do
		self.shortCut[i] = self:ChercherShortcut(i)
		local actionText = GetActionText(i);
		if (actionText) then
			self.actionMacro[actionText] = i
		else
			local type, id = GetActionInfo(i);
			if (type=="spell") then
				local spellName, spellRank = GetSpellName(id, BOOKTYPE_SPELL);
				self.actionSort[Ovale:GetSpellIdByNameAndRank(spellName, spellRank)] = i
			elseif (type =="item") then
				self.actionObjet[id] = i
			end
		end
	end
	
--[[	for k,v in pairs(self.actionSort) do
		self:Print(k.."="..v)
	end]]
end

function Ovale:RemplirListeConditions()
	self.nomsCondition = {}
	for k,v in pairs(self.conditions) do
		self.nomsCondition[k] = v.nom
	end
end

function Ovale:RemplirListeFormes()
	self.listeFormes[0] = "Humanoïde";
	local index=1;
	while true do
		local icon, name, active, castable = GetShapeshiftFormInfo(index);
		if not icon then
			break;
		end
		Ovale.listeFormes[index] = name;
		index = index + 1
	end
end

function Ovale:RemplirListeSorts()
	local sorts = {};
	local name, texture, offset, numSpells = GetSpellTabInfo(1);
	local i=numSpells+1;
	while true do
		local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
		if not spellName then
			break
		end
		-- DEFAULT_CHAT_FRAME:AddMessage(spellName);
		local nom = spellName;
		local a, b, numeroRang = string.find(spellRank, "(%d+)");
		--if (not numeroRang or tonumber(numeroRang)==1) then
			Ovale.listeSorts[nom] = nom;
		--else
		--end
		i = i+1;
	end
end

function Ovale:RemplirListeTalents()
	local numTabs = GetNumTalentTabs();
	self.listeTalents = {}
	for t=1, numTabs do
		local numTalents = GetNumTalents(t);
		for i=1, numTalents do
			local nameTalent, icon, tier, column, currRank, maxRank= GetTalentInfo(t,i);
			self.listeTalents[nameTalent] = nameTalent
			local link = GetTalentLink(t,i)
			local a, b, talentId = string.find(link, "talent:(%d+)");
			-- self:Print("talent = "..nameTalent.." id = ".. talentId)
			talentId = tonumber(talentId)
			self.talentIdToName[talentId] = nameTalent
			self.talentNameToId[nameTalent] = talentId
			self.pointsTalent[talentId] = currRank
			self.listeTalentsRemplie = true
		end
	end
end

function Ovale:ChercherBouton(sort)
	if (not sort) then
		return nil
	end
	local nom = GetSpellInfo(tonumber(sort))
	for i=1,120 do
		local type, id = GetActionInfo(i);
		if (type=="spell") then
			local spellName, spellRank = GetSpellName(id, BOOKTYPE_SPELL);
			if (spellName == nom) then
				return i
			end
		end
	end
end

function Ovale:CalculerMeilleureAction(element)
	if (element.type == "sort" or element.type=="macro" or element.type=="objet") then
		local action
		if (element.type == "sort") then
			action = self.actionSort[element.sort]
		elseif (element.type == "macro") then
			action = self.actionMacro[element.macro]
		elseif (element.type == "objet") then
			action = self.actionObjet[element.objet]
		end
		if (not action) then
			if (Ovale.trace) then
				self:Print("action introuvable")
			end
			return nil
		end
		if (element.utilisable and not IsUsableAction(action)) then
			return nil
		end
		if (element.nePasRepeter and IsCurrentAction(action)) then
			return nil
		end
		local start, duration, enable = GetActionCooldown(action)
		local restant
		if (enable>0) then
			if (not duration or start==0) then
				restant = 0
			else
				restant = duration - (self.maintenant - start);
			end
			if (Ovale.trace) then
				self:Print("action "..action.." = "..restant)
			end
			self.retourAction = action
			self.retourPriorite = element.priorite
			return restant
		else
			if (Ovale.trace) then
				self:Print("action "..action.." enable = 0")
			end
			return nil
		end	
	end
	
	local temps
	if (element.type == "condition") then
		local classe = Ovale.conditions[element.classe]
		temps = classe.Tester(element)
		if (temps == nil) then
			if (Ovale.trace) then
				self:Print("condition "..classe.nom.." non vérifiée")
			end
			return nil
		end
	end
	
	local meilleurFils
	local meilleurTempsFils
	local meilleurePrioriteFils
	 
	for k, v in ipairs(element.fils) do
		local nouveauTemps = Ovale:CalculerMeilleureAction(v)
		local action = self.retourAction
		local priorite = self.retourPriorite
		if (nouveauTemps) then
			local remplacer
			if (not meilleurTempsFils) then
				remplacer = true
			else
				-- temps maximum entre le nouveau sort et le précédent
				local maxEcart
				if (priorite > meilleurePrioriteFils) then
					-- Si le nouveau sort est plus prioritaire que le précédent, on le lance
					-- même si on doit attendre jusqu'à gcd secondes de plus
					maxEcart = self.gcd
				elseif (priorite < meilleurePrioriteFils) then
					-- A l'inverse, si il est moins prioritaire que le précédent, on ne le lance
					-- que si il se lance au moins 1,5s avant
					maxEcart = -self.gcd
				else
					maxEcart = 0
				end
				if (nouveauTemps-meilleurTempsFils < maxEcart) then
					remplacer = true
				end
			end
			if (remplacer) then
				meilleurTempsFils = nouveauTemps
				meilleurFils = action
				meilleurePrioriteFils = priorite
			end
		end
	end
	
	if (meilleurFils) then
		if (not temps or meilleurTempsFils>temps) then
			temps = meilleurTempsFils
		end
		
		if (Ovale.trace) then
			self:Print("condition "..meilleurFils.." = "..temps)
		end
		self.retourPriorite = meilleurePrioriteFils
		self.retourAction = meilleurFils
		return temps
	else
		return nil
	end
end

function Ovale:ChargerDefaut()
	local localizedClass, englishClass = UnitClass("player")
	if (englishClass == "PRIEST") then
		self:ChargerDefautPretre();
	elseif (englishClass == "DRUID") then
		self:ChargerDefautDruide();
	elseif (englishClass == "ROGUE") then
		self:ChargerDefautVoleur();
	elseif (englishClass == "WARRIOR") then
		self:ChargerDefautGuerrier();
	elseif (englishClass == "WARLOCK") then
		self:ChargerDefautDemoniste();
	else
		self.arbre = 
		{
			type = 'racine',
			fils =	{}
		}
		self.casesACocher = {}
	end
end

function Ovale:GetNomSort(sort)
	if (sort) then
		return GetSpellInfo(sort)
	else
		return "Sort indéfini"
	end
end


function Ovale:CreerListeSorts(objet)
	local liste =
	{
		name = "Le sort",
		type = "select",
		values = Ovale.listeSorts,
		get = function(info) return Ovale:GetSpellInfoOrNil(objet.sort) end,
		set = function(info,v) objet.sort = Ovale:GetSpellIdByName(v) end,
		width = "full"
	}
	return liste
end

function Ovale:CreerListeTalents(objet)
	local liste =
	{
		name = "Le talent",
		type = "select",
		values = Ovale.listeTalents,
		get = function(info) return Ovale.talentIdToName[objet.talent] end,
		set = function(info,v) objet.talent = Ovale.talentNameToId[v] end,
		width = "full"
	}
	return liste
end

function Ovale:CreerComparaison(condition)
	local liste = 
	{
		type = "select",
		name = "Comparaison",
		values = {"<",">"},
		get = function(info) return condition.comparaison end,
		set = function(info,v) condition.comparaison = v end
	}
	return liste
end

function Ovale:EnleverPage(node, i)
	local max=0
	for j, val in pairs(node) do
		if (tonumber(j)) then
			if (tonumber(j)>i) then
				local newName = ""..(tonumber(j)-1)
				node[newName]=val
				val.name = newName
			end
			if (tonumber(j)>max) then
				max = tonumber(j)
			end
		end
	end
	node[""..max]=nil
end

function Ovale:CreerListeRangs(nomSort)
	local listeRangs = {}
	local name, texture, offset, numSpells = GetSpellTabInfo(1);
	local i = numSpells +1;
	while true do
		local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
		if not spellName then
			break
		end
		if (spellName == nomSort) then
			listeRangs[spellRank] = spellRank;
		end
		i = i+1;
	end
	return listeRangs;
end
		
function Ovale:AjouterEcranElement(idElement, element, elementPere, pageFilsPere)
	local pageElement
	
	if (element.type=="sort") then
		pageElement =
		{
			type="group",
			name=Ovale:GetNomSort(element.sort),
			args = 
			{
				sort =
				{
					type = "select",
					name = "Sort",
					values = Ovale.listeSorts,
					get = function(info) return Ovale:GetSpellInfoOrNil(element.sort) end,
					set = function(info,v)
						local ancienNom = Ovale:GetSpellInfoOrNil(element.sort)
						if (ancienNom~=v) then
							pageElement.args.rang.values = self:CreerListeRangs(v)
							element.sort = Ovale:GetSpellIdByName(v); 
							pageElement.name= v
						end
					end,
					width = "full"
				},
				rang =
				{
					type = "select",
					name = "Rang",
					values = self:CreerListeRangs(Ovale:GetSpellInfoOrNil(element.sort)),
					get = function(info)
						local nom, rang = Ovale:GetSpellInfoOrNil(element.sort)
						return rang
					end,
					set = function(info, v)
						element.sort = Ovale:GetSpellIdByNameAndRank(Ovale:GetSpellInfoOrNil(element.sort), v)
					end
				},
				priorite =
				{
					name = "Priorité",
					type="select",
					desc = "Un sort ne sera pas lancé s'il risque de retarder le lancement d'un sort de priorité plus élevée",
					values = {"Basse","Moyenne","Haute"},
					get = function(info) return element.priorite end,
					set = function(info, v) element.priorite = v end
				},
				utilisable =
				{
					name = "Tester si utilisable",
					type = "toggle",
					desc = "Ne lance le sort que si il est utilisable (à portée, etc.)",
					get = function(info) return element.utilisable end,
					set = function(info, v) element.utilisable = v end
				}
			}
		}
	elseif (element.type=="condition") then
		local classe = Ovale.conditions[element.classe]
		pageElement =
		{
			type="group",
			name = classe.nom,
		}
		classe.AjouterOption(element, pageElement)		
	else
		pageElement = 
		{
			type="group",
			name = "Arbre de décision",
			args = {}
		}
	end
	
	if (elementPere) then
		pageElement.args.supprimer = 
		{
			type = "execute",
			name = "Supprimer",
			desc = "Supprimer cet élément",
			func = function()
				table.tremove(elementPere, idElement)
				Ovale:EnleverPage(pageFilsPere.args, idElement)
			end
		}
	end
	
	pageElement.order = idElement
	
	if (element.type=="condition" or element.type=="racine") then
		pageElement.args.fils =
		{
			type="group",
			name="Enfants",
			desc="Les actions à lancer et les conditions supplémentaires à tester quand cette condition est vérifiée",
			args =
			{
				nouveauSort =
				{
					type="execute",
					name="Ajouter un sort",
					order=100,
					func = function()
						local elementFils = 
						{
							type = "sort",
							priorite = 2
						}
						element.fils[#element.fils+1] = elementFils
						self:AjouterEcranElement(#element.fils, elementFils, element, pageElement.args.fils)
					end
				},
				listeConditions =
				{
					name = "Nouvelle condition",
					type = "select",
					order=101,
					values = Ovale.nomsCondition,
					get = function(info) return nouvelleCondition end,
					set = function(info,v) nouvelleCondition=v end,
					width = "full"
				},
				ajouterCondition =
				{
					name = "Ajouter une condition",
					type = "execute",
					order = 102,
					func = function()
						local classe = Ovale.conditions[nouvelleCondition]
						local condition = 
						{
							type = "condition",
							classe = nouvelleCondition,
							fils = {}
						}
						classe.SetDefaut(condition)
						element.fils[#element.fils+1] = condition
						self:AjouterEcranElement(#element.fils, condition, element, pageElement.args.fils)
					end						
				}
			}
		}
		for k,v in pairs(element.fils) do
			self:AjouterEcranElement(k, v, element, pageElement.args.fils)
		end	
	end
	pageFilsPere.args[""..idElement] = pageElement
end

function Ovale:InitEcranOption()
	options.args[1] = nil;
	self:AjouterEcranElement(1, self.arbre, nil, options )
	
	for k,v in pairs(self.casesACocher) do
		self:AjouterCaseACocher(k,v)
	end
end

function Ovale:AfficherConfig()
	self.AceConfigDialog:SetDefaultSize("Ovale", 500, 550)
	self.AceConfigDialog:Open("Ovale", configFrame)
end