Ovale.conditions=
{
	vieCible =
	{
		nom = "Comparer à la vie de la cible",
		AjouterOption = function(condition, node)
			node.args = 
			{
				vie =
				{
					type = "range",
					name = "Vie de la cible en %",
					get = function(info) return condition.vie end,
					set = function(info,v) condition.vie = v end,
					min = 0,
					max = 100,
					step = 1
				},
				comparaison = Ovale:CreerComparaison(condition)
			}			
		end,
		Tester = function(condition)
			if (condition.comparaison == 1) then
				if (UnitHealth("target")/UnitHealthMax("target")<condition.vie/100) then
					return 0
				else
					return nil
				end
			else
				if (UnitHealth("target")/UnitHealthMax("target")>condition.vie/100) then
					return 0
				else
					return nil
				end
			end
		end,
		SetDefaut = function(condition)
			condition.vie = 20
			condition.comparaison = 1
		end
	},
	vieJoueur =
	{
		nom = "Comparer à la vie du joueur",
		AjouterOption = function(condition, node)
			node.args = 
			{
				vie =
				{
					type = "range",
					name = "Vie du joueur en %",
					get = function(info) return condition.vie end,
					set = function(info,v) condition.vie = v end,
					min = 0,
					max = 100,
					step = 1
				},
				comparaison = Ovale:CreerComparaison(condition)
			}			
		end,
		Tester = function(condition)
			if (condition.comparaison == 1) then
				if (UnitHealth("player")/UnitHealthMax("player")<condition.vie/100) then
					return 0
				else
					return nil
				end
			else
				if (UnitHealth("player")/UnitHealthMax("player")>condition.vie/100) then
					return 0
				else
					return nil
				end
			end
		end,
		SetDefaut = function(condition)
			condition.vie = 20
			condition.comparaison = 1
		end
	},
	buff =
	{
		nom = "Un buff est-il présent sur le joueur",
		AjouterOption = function(condition, node)
			node.args =
			{
				sort = Ovale:CreerListeSorts(condition),
				expiration =
				{
					name = "Expiration",
					desc = "Temps en secondes minimal avant l'expiration du buff. 0 si le buff doit être absent.",
					type = "range",
					min = 0,
					max = 30,
					step = 1,
					get = function(info) return condition.expiration end,
					set = function(info,v) condition.expiration = v end					
				}				
			}
		end,
		Tester = function(condition)
			if (not condition.sort) then
				return
			end
			local buffName = GetSpellInfo(condition.sort)
			i=1;
			while (true) do
				local name, rank, iconTexture, count, duration, timeLeft =  UnitBuff("player", i);
				if (not name) then
					break
				end
				if (name == buffName) then
					if (not timeLeft or not duration) then
						return nil
					elseif (timeLeft<condition.expiration) then
						return 0
					else
						return timeLeft-condition.expiration
					end
				end
				i = i + 1;
			end
			return 0
		end,
		SetDefaut = function(condition)
			condition.expiration = 5
		end
	},
	debuff =
	{
		nom = "Un debuff est-il présent sur la cible",
		AjouterOption = function(condition, node)
			node.args =
			{
				sort = Ovale:CreerListeSorts(condition),
				expiration =
				{
					name = "Expiration",
					desc = "Temps en secondes minimal avant l'expiration du debuff. 0 si le debuff doit être absent.",
					type = "range",
					min = 0,
					max = 30,
					step = 1,
					get = function(info) return condition.expiration end,
					set = function(info,v) condition.expiration = v end					
				},
				stacks =
				{
					name = "Empilement",
					desc = "Nombre maximal d'empilements. 0 si le debuff ne s'empile pas.",
					type = "range",
					min = 0,
					max = 5,
					step = 1,
					get = function(info) return condition.stacks end,
					set = function(info,v) condition.stacks = v end
				},
				amoi =
				{
					name = "Posé par moi",
					desc = "Le debuff doit avoir été posé par moi",
					type = "toggle",
					get = function(info) return condition.amoi end,
					set = function(info,v) condition.amoi = v end
				}
			}
		end,
		Tester = function(condition)
			if (not condition.sort) then
				return
			end
			local debuffName = GetSpellInfo(condition.sort)
			i=1;
			while (true) do
				local name, rank, texture, count, debuffType, duration, timeLeft  =  UnitDebuff("target", i);
				if (not name) then
					break
				end
				if (not condition.amoi or timeLeft~=nil) then
					if (name == debuffName) then
						if (not timeLeft or not duration) then
							return nil
						elseif (timeLeft<condition.expiration) then
							return 0
						elseif (count~=0 and count<condition.stacks) then
							return 0
						else
							return timeLeft-condition.expiration
						end
					end
				end
				i = i + 1;
			end
			return 0
		end,
		SetDefaut = function(condition)
			condition.expiration = 5
			condition.stacks = 1
			condition.amoi = false
		end
	},
	caseOn =
	{
		nom = "Cases sont cochées",
		AjouterOption = function(condition, node)
			node.args = 
			{
				cases =
				{
					type = "multiselect",
					name = "Les cases qui doivent être cochées",
					values = Ovale.casesACocher,
					get = function(info, clef) return condition.case[clef] end,
					set = function(info, clef, v) condition.case[clef] = v end
				}
			}			
		end,
		Tester = function(condition)
			for k,v in pairs(condition.case) do
				if (v) then
					if (not OvaleFrame.checkBoxes
						or not OvaleFrame.checkBoxes[k]
						or not OvaleFrame.checkBoxes[k].checked) then
						return nil
					end
				end
				return 0
			end
		end,
		SetDefaut = function(condition)
			condition.case = {}
		end
	},
	caseOff =
	{
		nom = "Cases non cochées",
		AjouterOption = function(condition, node)
			node.args = 
			{
				cases =
				{
					type = "multiselect",
					name = "Les cases qui ne doivent pas être cochées",
					values = Ovale.casesACocher,
					get = function(info, clef) return condition.case[clef] end,
					set = function(info, clef, v) condition.case[clef] = v end
				}
			}			
		end,
		Tester = function(condition)
			for k,v in pairs(condition.case) do
				if (v) then
					if (not OvaleFrame.checkBoxes
						or not OvaleFrame.checkBoxes[k]
						or OvaleFrame.checkBoxes[k].checked) then
						return nil
					end
				end
				return 0
			end
		end,
		SetDefaut = function(condition)
			condition.case = {}
		end
	},
	mana = 
	{
		nom = "Comparer à la mana/énergie/rage du joueur",
		AjouterOption = function(condition, node)
			node.args = 
			{
				mana =
				{
					type = "input",
					name = "Mana/énergie/rage",
					get = function(info) return tostring(condition.mana) end,
					set = function(info,v) condition.mana = tonumber(v) end,
				},
				comparaison = Ovale:CreerComparaison(condition)				
			}			
		end,
		Tester = function(condition)
			if (condition.comparaison == 1) then
				if (UnitMana("player")<condition.mana) then
					return 0
				else
					return nil
				end
			else
				if (UnitMana("player")>condition.mana) then
					return 0
				else
					return nil
				end
			end
		end,
		SetDefaut = function(condition)
			condition.mana = 20
			condition.comparaison = 2
		end
	},
	posture =
	{
		nom = "Posture/forme du joueur",
		AjouterOption = function(condition, node)
			node.args = 
			{
				forme =
				{
					type = "select",
					name = "Posture/forme",
					values = Ovale.listeFormes,
					get = function(info) return condition.forme end,
					set = function(info,v) condition.forme = v end,
				}
			}			
		end,
		Tester = function(condition)
			if (GetShapeshiftForm(true) == condition.forme) then
				return 0
			else
				return nil
			end
		end,
		SetDefaut = function(condition)
			condition.forme = 0
		end
	},
	classification =
	{
		nom = "Classification de la cible",
		AjouterOption = function(condition, node)
			node.args = 
			{
				forme =
				{
					type = "select",
					name = "Classification",
					values = {"Normal","Élite","World boss"},
					get = function(info) return condition.classification end,
					set = function(info,v) condition.classification = v end,
				}
			}			
		end,
		Tester = function(condition)
			local classification = UnitClassification("target");

			if ((condition.classification==3 and classification=="worldboss") or
				(condition.classification==2 and (classification=="rareelite" or classification=="elite")) or
				(condition.classification==1 and (classification=="normal" or classificiation=="rare" or classification=="trivial"))) then
				return 0
			else
				return nil
			end
		end,
		SetDefaut = function(condition)
			condition.classification = 1
		end
	},
	niveau =
	{
		nom = "Niveau de la cible",
		AjouterOption = function(condition, node)
			node.args = 
			{
				forme =
				{
					type = "range",
					name = "Niveaux de plus que le joueur",
					get = function(info) return condition.difference end,
					set = function(info,v) condition.difference = v end,
					min = 0,
					max = 3,
					step = 1
				},
				comparaison = Ovale:CreerComparaison(condition)
			}			
		end,
		Tester = function(condition)
			local difference
			if (UnitLevel("target") == -1) then
				difference = 3
			else
				difference = UnitLevel("target") - UnitLevel("player")
			end

			if (condition.comparaison==1) then
				if (difference<condition.difference) then
					return 0
				else
					return nil
				end
			else
				if (difference>condition.difference) then
					return 0
				else
					return nil
				end
			end
		end,
		SetDefaut = function(condition)
			condition.difference = 1
			condition.comparaison = 2
		end
	},
	cible =
	{
		nom = "Le joueur est ciblé",
		AjouterOption = function(condition, node)
			node.args = 
			{
				forme =
				{
					type = "toggle",
					name = "La cible cible le joueur",
					get = function(info) return condition.cible end,
					set = function(info,v) condition.cible = v end
				},
				comparaison = Ovale:CreerComparaison(condition)
			}			
		end,
		Tester = function(condition)
			if (condition.cible) then
				if (UnitIsUnit("player","targettarget")) then
					return 0
				else
					return nil
				end
			else
				if (not UnitIsUnit("player","targettarget")) then
					return 0
				else
					return nil
				end
			end
		end,
		SetDefaut = function(condition)
			condition.cible = true
		end
	},
	talent =
	{
		nom = "Points de talent",
		AjouterOption = function(condition, node)
			node.args = 
			{
				talent = Ovale:CreerListeTalents(condition),
				comparaison = Ovale:CreerComparaison(condition),
				points =
				{
					type = "range",
					name = "Nombre de points alloués",
					get = function(info) return condition.points end,
					set = function(info,v) condition.points = v end,
					min = 0,
					max = 5,
					step = 1
				}
			}			
		end,
		Tester = function(condition)
			if (not Ovale.listeTalentsRemplie) then
				Ovale:RemplirListeTalents()
				Ovale:InitEcranOption()
				return nil
			end
			if (condition.comparaison==2) then
				if (Ovale.pointsTalent[condition.talent]>condition.points) then
					return 0
				else
					return nil
				end
			else
				if (not Ovale.pointsTalent[condition.talent] or Ovale.pointsTalent[condition.talent]<condition.points) then
					return 0
				else
					return nil
				end
			end 
		end,
		SetDefaut = function(condition)
			condition.comparaison = 2
			condition.points = 0
		end
	},
	coupBlanc =
	{
		nom = "Après un coup blanc",
		AjouterOption = function(condition, node)
			node.args = 
			{
				max =
				{
					type = "range",
					name = "Temps maximal après un coup blanc",
					get = function(info) return condition.max end,
					set = function(info,v) condition.max = v end,
					min = 0.1,
					max = 3.0,
					step = 0.1
				}
			}			
		end,
		Tester = function(condition)
			local debut = OvaleSwing.starttime
			local fin = OvaleSwing.duration + debut
			local maintenant = GetTime()
			if (maintenant-debut<condition.max) then
				return 0
			elseif (maintenant<fin-0.1) then
				return fin-maintenant
			else 
				return 0.1
			end 
		end,
		SetDefaut = function(condition)
			condition.max = 0.2
		end
	},
	petPresent =
	{
		nom = "Familier présent et en vie",
		AjouterOption = function(condition, node)
			node.args = 
			{
				present =
				{
					type = "toggle",
					name = "Le familier est présent et en vie",
					get = function(info) return condition.present end,
					set = function(info,v) condition.present = v end
				}
			}			
		end,
		Tester = function(condition)
			local present = UnitExists("pet") and not UnitIsDead("pet")
			if (condition.present) then
				if (present) then
					return 0
				else
					return nil
				end				
			else
				if (not present) then
					return 0
				else
					return nil
				end
			end 
		end,
		SetDefaut = function(condition)
			condition.present = true
		end
	},
	combo =
	{
		nom = "Points de combo",
		AjouterOption = function(condition, node)
			node.args = 
			{
				nombre =
				{
					type = "range",
					name = "Nombre de points de combo",
					get = function(info) return condition.nombre end,
					set = function(info,v) condition.nombre = v end,
					min = 0,
					max = 5,
					step = 1
				},
				comparaison = Ovale:CreerComparaison(condition)
			}			
		end,
		Tester = function(condition)
			local points = GetComboPoints()
			if (condition.comparaison == Ovale.Inferieur) then
				if (points < condition.nombre) then
					return 0;
				else
					return nil;
				end
			else
				if (points > condition.nombre) then
					return 0;
				else
					return nil;
				end
			end 
		end,
		SetDefaut = function(condition)
			condition.present = true
		end
	},
	sets =
	{
		nom = "Pièces de set",
		AjouterOption = function(condition, node)
			node.args = 
			{
				set =
				{
					type = "select",
					name = "Ensemble d'objet",
					values = {["T4"]="Raid 4",["T5"]="Raid 5",["T6"]="Raid 6"},
					get = function(info) return condition.set end,
					set = function(info,v) condition.set = v end					
				},
				nombre =
				{
					type = "range",
					name = "Nombre minimal de pièces (ou 0, pas de pièce)",
					get = function(info) return condition.nombre end,
					set = function(info,v) condition.nombre = v end,
					min = 0,
					max = 9,
					step = 1
				}
			}			
		end,
		Tester = function(condition)
			local nombre = 0
			if (OvaleEquipement.nombre[condition.set]) then
				nombre = OvaleEquipement.nombre[condition.set]
			end
			if ((condition.nombre==0 and nombre==0) or (condition.nombre>0 and nombre>=condition.nombre)) then
				return 0;
			else
				return nil;
			end
		end,
		SetDefaut = function(condition)
			condition.set = "T4"
			condition.nombre = 2
		end
	}
}