--	///////////////////////////////////////////////////////////////////////////////////////////

-- Code to display Explorer POI within OmegaMap
-- This is modified code taken from Explorer.lua from Explorer! (1.1A)
-- Explorer! is written and maintained by the KnappyM @ http://www.curse.com/addons/wow/explorer-markers

--	///////////////////////////////////////////////////////////////////////////////////////////

if (IsAddOnLoaded("Explorer")) then

local PinFrame
local Overlays ={}
local Pins = {} -- this is just to recycle textures

--Creating a Frame to display Explorer Points in OmegaMap
if not ExplorerOmegaMapOverlayParent then
	 PinFrame = CreateFrame("Frame", "ExplorerOmegaMapOverlayParent", OmegaMapNoteFrame)
	PinFrame:SetAllPoints(true)
end

local function HidePins()
	for i, pin in pairs(Pins) do
		pin:Hide()
	end
end

local EXPLORE_S = 'Explore: %s'
local CLICK_WAYPOINT = 'Ctrl-Click to set a TomTom waypoint.'
if GetLocale() == 'deDE' then
	EXPLORE_S = 'Erkundet: %s'
	CLICK_WAYPOINT = 'Strg-Klick, um einen Zielpunkt mit TomTom zu setzen.'
elseif GetLocale():match('es') then
	EXPLORE_S = 'Explora: %s'
	CLICK_WAYPOINT = 'Ctrl-Clic para establecer un waypoint con TomTom.'
end

local function Pin_OnMouseUp(self)
	if TomTom and IsControlKeyDown() then
		local mapID, mapFloor = GetCurrentMapAreaID()
		local width, height = OmegaMapDetailFrame:GetWidth(), OmegaMapDetailFrame:GetHeight()
		local _, _, _, x, y = self:GetPoint()
		x = x / width
		y = -y / height
		TomTom:AddMFWaypoint(mapID, mapFloor, x, y, {
			title = format(EXPLORE_S, self.text),
			persistent = false,
		})
	end
end

local function Pin_OnEnter(self)
	if self.text then
		OmegaMapPOIFrame.allowBlobTooltip = false
		OmegaMapTooltip:SetOwner(self, 'ANCHOR_BOTTOMLEFT')
		OmegaMapTooltip:ClearLines()
		OmegaMapTooltip:AddLine(self.text)
		if TomTom then
			WorldMapTooltip:AddLine(CLICK_WAYPOINT, 1, 1, 1, true)
		end
		OmegaMapTooltip:Show()
	end
end

local function Pin_OnLeave()
	OmegaMapPOIFrame.allowBlobTooltip = true
	OmegaMapTooltip:Hide()
end

local function GetPin()
	for i, pin in pairs(Pins) do
		if not pin:IsShown() then
			return pin
		end
	end
	
	local pin = CreateFrame('frame', nil, PinFrame)
	pin:SetSize(18, 18)
	
	pin.texture = pin:CreateTexture()
	pin.texture:SetAllPoints()
	pin.texture:SetTexture('interface\\addons\\Explorer\\images\\coordicon')
	
	pin:EnableMouse(true)
	pin:SetScript('OnMouseUp', Pin_OnMouseUp)
	pin:SetScript('OnEnter', Pin_OnEnter)
	pin:SetScript('OnLeave', Pin_OnLeave)
	
	tinsert(Pins, pin)
	return pin
end

local function GetPinInfo(achievementID, criteriaID) 
	for i = 1, GetAchievementNumCriteria(achievementID) do
		local name, _, completed, _, _, _, _, zoneID = GetAchievementCriteriaInfo(achievementID, i)
		if zoneID == criteriaID then
			return name, completed
		end
	end
end

hooksecurefunc('OmegaMapFrame_Update', function()
	HidePins()
	
	local areaID = GetCurrentMapAreaID()
	local mapName, _, _, isMicroDungeon, microDungeonPath = GetMapInfo()

	local info = Overlays[areaID]
	if not isMicroDungeon and info then
		local achievementID = info[1]
		for i = 2, #info, 3 do
			local criteriaID, x, y = info[i], info[i + 1], info[i + 2]
			local name, completed = GetPinInfo(achievementID, criteriaID)
			if name and not completed then
				local pin = GetPin()
				pin:SetPoint('CENTER', OmegaMapDetailFrame, 'TOPLEFT', x, -y)
				pin.text = name or (achievementID .. ', ' .. criteriaID)
				pin:Show()
			end
		end
	end

end)

Overlays = {
[4]={728,242,445,415,244,561,505,248,663,554,250,580,403,252,536,290,254,448,339,256,403,165,258,525,163,260,539,61,262,455,56,2472,485,528,2473,405,267,3126,437,201,3127,578,71,3128,589,176,3195,455,56},
[9]={736,2705,324,338,2706,479,391,2707,356,409,2708,543,321,2709,509,533,2710,600,133,2711,329,79,2712,541,209,2713,657,412,2714,628,285,2715,407,188,2716,449,291,2717,432,96,2718,511,101,2719,538,446,3167,459,515,3168,498,126,3169,536,527},
[11]={750,461,674,80,462,559,124,464,431,237,465,257,213,466,369,307,468,549,275,469,667,282,470,588,334,471,503,383,472,558,524,473,665,479,474,704,562,2442,396,94,2443,340,480,3113,411,448,3114,778,599,3115,623,99},
[16]={761,561,188,204,562,270,182,563,276,296,565,165,428,566,238,547,567,301,398,568,413,608,569,491,528,570,398,310,572,616,470,573,565,385,574,500,276,575,594,220,576,695,249,2426,474,344,2427,130,243},
[17]={765,2643,461,397,2644,404,163,2645,126,242,2647,168,423,2648,600,137,2649,486,185,2650,694,323,2651,264,245,2652,440,80,2690,340,351,2994,512,344,2995,166,289,3029,664,235,3240,903,240},
[19]={766,821,396,87,823,645,105,824,605,190,826,371,177,827,472,268,828,323,306,829,451,179,2444,533,99,2445,692,224,2446,508,473,2447,446,575,2448,545,354,2449,659,522,2450,343,483},
[20]={768,222,872,316,224,786,180,225,792,366,226,738,402,227,685,301,229,570,239,230,598,341,231,539,392,232,452,437,234,457,221,235,385,327,236,323,427,2586,463,344,2587,618,492,2588,871,178,2589,850,464,3069,881,193,3070,516,447,3071,651,394,3072,302,313},
[21]={769,304,348,83,306,692,179,308,450,268,309,594,304,310,461,341,311,613,417,312,422,423,314,480,594,315,600,493,2537,622,58,2538,450,126,2539,374,187,2540,287,172,2541,462,532,2542,566,232,2543,510,446,2544,533,172,3059,528,98},
[22]={770,961,756,511,962,698,494,963,445,558,965,271,386,966,365,365,968,550,443,969,473,224,970,450,114,971,641,389,972,645,269,973,688,218,2617,436,452,2618,452,342,2619,431,277,3088,417,572,3089,528,570},
[23]={771,2653,877,310,2654,464,291,2655,558,421,2656,357,458,2657,351,563,2658,624,279,2659,576,496,2660,769,361,2661,537,356,2662,663,167,2663,506,138,2664,308,166,2665,482,88,2666,873,524,2667,267,67,2668,125,176,2669,362,300,2670,474,508,2671,226,441,2672,783,240,2673,683,396,2674,240,527,2675,131,363,2676,758,541,2677,666,69,3035,184,195},
[24]={772,2730,340,493,2731,683,221,2732,497,313,2733,530,163,2734,305,243,2735,449,62,2736,498,359,2737,636,565,2738,684,401,2739,528,213,2740,401,318,2741,433,258,2742,342,389,2743,338,311,2744,400,126,2745,587,494,2746,270,572,2747,453,194,2748,487,115,2749,557,257,2750,295,425,2751,495,469,2752,585,157,2753,568,314,2754,442,324,2755,525,85,2990,376,402,3235,354,346,3237,616,443},
[26]={773,601,139,302,602,231,224,604,333,306,605,346,482,606,406,397,607,472,262,608,491,348,609,485,448,610,628,162,611,577,286,612,734,363,613,632,496,614,799,467,2490,265,396,3039,249,440,3040,319,389,3041,790,534,3042,660,305},
[27]={627,104,316,347,107,766,382,108,842,347,109,715,309,113,537,339,114,484,353,117,439,432,1041,586,173,2465,347,506,2466,582,423,2467,204,186,2468,781,163,2471,482,249,2627,484,254,2628,415,269,2629,666,430,2630,904,252,3033,916,338,3034,635,370,3241,299,227,3242,611,183},
[28]={774,2756,213,535,2757,399,554,2758,719,180,2759,239,214,2760,751,374,2762,528,332,2763,377,194,2883,595,479,3055,400,451,3056,413,262,3057,720,345,3058,351,288},
[29]={775,2720,93,184,2721,207,196,2722,568,463,2723,323,244,2724,181,452,2725,698,272,2726,735,455,2727,455,352,2728,567,250,2996,828,201,2997,362,358,3030,202,429,3031,148,339,3032,735,362},
[30]={776,122,422,432,124,395,537,125,505,284,126,486,574,127,647,464,128,697,531,129,837,448,130,849,531,131,529,443,132,741,345,2482,256,210,2483,245,491,3036,326,567,3037,417,581,3038,254,632},
[32]={777,941,452,240,1061,587,432,1062,427,460},
[34]={778,421,100,297,422,214,467,424,196,276,425,359,486,427,510,495,428,648,253,429,639,481,431,747,309,432,773,241,433,547,142,2474,198,369,2475,798,442,2476,469,258,3234,874,235},
[35]={779,317,711,160,318,505,318,319,349,145,320,175,144,321,825,435,322,695,437,323,380,406,324,352,319,325,325,524,326,203,525,2513,481,77,3043,159,383,3044,228,91,3045,710,506},
[36]={780,361,197,396,362,383,457,363,419,352,364,255,290,365,302,175,366,352,87,367,473,262,369,647,476,370,683,393,371,788,231,2517,535,365,2518,811,417,2519,610,351,3046,205,179,3047,617,240,3048,706,303},
[37]={781,513,591,369,514,462,354,515,378,324,516,671,340,518,533,209,519,423,257,520,343,243,521,258,320,523,265,135,524,442,133,525,468,64,526,603,133,527,840,218,2565,647,265,2566,534,441,2568,193,172,2704,616,481,3060,113,203,3061,411,199,3062,174,223,3063,554,216},
[38]={782,2678,725,87,2679,186,456,2680,685,239,2681,801,334,2682,147,239,2683,703,352,2684,843,261,2685,223,331,2686,679,501,2687,471,363,2688,289,215,2689,477,204,3064,786,568,3065,591,282},
[39]={802,281,578,106,282,511,144,284,545,216,285,454,234,286,312,296,287,616,396,288,559,330,289,424,438,290,382,350,291,340,492,292,301,580,293,449,549,294,635,485,2620,449,160,2989,392,290,3090,701,509,3091,442,486},
[40]={841,381,102,390,382,187,356,383,191,226,384,359,327,385,259,184,387,436,173,388,470,111,389,486,321,390,523,411,392,620,378,394,680,233,2622,603,175,2623,500,511,2624,580,272,2625,343,141,2626,585,474,3092,128,187,3093,796,316},
[41]={842,84,463,333,85,305,335,87,448,451,88,551,409,89,419,381,91,585,221,92,659,329,93,401,180,94,445,231,2573,487,558,2574,508,255,3006,556,343,3190,557,591,3191,560,178},
[42]={844,341,640,147,346,438,405,349,404,576,2451,429,360,2452,513,129,2453,321,562,2454,380,295,2455,727,116,2456,661,48,2457,437,474,2458,469,243,3116,468,507,3117,377,545,3118,386,413,3119,435,294,3120,526,218},
[43]={845,741,131,195,742,203,275,744,371,220,747,360,336,749,327,439,751,533,219,752,598,334,753,665,545,754,683,321,755,806,332,756,936,262,757,876,392,758,852,483,2428,275,253,2429,261,132,2430,489,441,2431,215,370,2432,490,311,3094,135,103,3095,112,236,3096,69,92,3097,386,280,3098,186,151,3099,533,304,3100,854,539,3101,828,290,3102,763,505,3103,729,547,3104,686,592,3105,255,417},
[61]={846,2631,338,260,2632,471,338,2633,131,252,2634,518,201,2636,926,527,2637,884,320,2638,322,123,2639,796,462,2640,551,424,2641,311,393,2642,134,70,3192,192,319,3193,785,474,3194,848,607,3248,595,650},
[81]={847,921,410,133,922,539,266,923,316,478,924,495,424,925,671,330,927,636,593,928,601,439,929,730,616,2556,365,337,2557,452,202,2558,763,558,2559,670,442,2560,490,510,2561,358,211,2562,769,507,2563,573,486,2564,591,386,3183,322,404,3184,537,278,3185,766,303,3186,388,320},
[101]={848,762,804,530,764,515,524,765,362,593,766,243,473,767,509,395,768,354,382,772,546,169,773,784,145,774,668,59,775,516,67,2459,562,315,2460,748,305,2461,288,61,2462,707,500,2463,300,198,2464,366,467,3121,285,404,3122,390,188,3123,449,186,3124,707,217,3125,636,597},
[121]={849,984,464,120,985,472,495,986,604,238,989,587,488,991,766,298,993,757,199,997,832,274,2484,649,391,2485,459,331,2486,552,370,2487,688,270,2488,286,329,2489,760,418,3139,571,366,3140,514,317,3141,787,380,3142,408,117,3143,391,66,3144,705,482,3145,531,130,3146,634,76,3147,516,67,3148,881,317,3149,536,500},
[141]={850,661,673,334,662,563,176,666,534,505,667,762,118,2477,415,82,2478,363,205,2479,468,309,2480,417,503,2481,297,328,3129,545,376,3130,471,162,3131,561,173,3132,596,274,3133,329,148,3134,311,437},
[161]={851,641,304,443,643,409,472,644,537,613,645,473,433,646,538,452,647,574,382,648,411,372,649,345,305,650,524,304,651,424,245,657,643,334,658,506,182,659,411,183,660,374,97,2569,514,203,2570,716,330,2571,377,521,3187,336,517,3188,419,519,3189,659,155},
[181]={852,842,436,331,844,645,159,845,804,196,854,345,345,856,661,544,857,341,498,858,590,606,2433,247,249,2434,601,333,2435,320,218,2436,492,167,2437,205,368,2438,244,537,2439,713,221,2440,510,519,2441,436,504,3106,706,88,3107,562,81,3108,424,162,3109,296,439,3110,515,500,3111,111,481,3112,223,466},
[182]={853,861,613,78,862,627,179,863,505,174,864,437,125,865,433,275,866,392,327,867,371,395,868,381,483,869,418,571,870,524,523,871,481,596,872,566,580,3135,356,337,3136,437,209,3137,562,77,3138,453,422},
[201]={854,621,517,321,622,315,362,623,334,473,624,512,517,625,680,365,626,804,312,627,515,171,2590,659,96,2591,541,407,2592,422,279,2593,694,230,2594,290,240,3205,815,321,3206,431,51},
[241]={855,701,526,371,2514,483,254,2515,364,260,2516,679,361},
[261]={856,1021,309,108,1022,495,151,1023,654,317,1025,314,360,1026,601,480,1027,290,561,2535,545,229,2536,814,119,3010,447,287,3170,279,493,3171,333,221,3172,695,101,3173,717,150,3174,382,600,3175,209,588,3176,692,416},
[281]={857,2764,601,327,2765,319,330,2766,455,104,2767,599,572,2768,680,430,2769,512,369,2770,549,421,2771,647,516,2772,478,262,2773,628,165,2774,365,380,2775,682,324,3207,569,494,3208,218,298},
[462]={859,1127,314,107,1128,430,263,1129,353,385,1130,294,463,1132,427,337,1134,523,489,1135,612,426,1137,558,377,1138,733,381,1140,440,492,1142,543,481,1143,721,531,1145,363,575,1175,525,264,1356,717,303,1357,647,489,1358,334,519,1359,660,525,1360,442,573,1361,558,563,1362,383,492,1380,235,501,1381,622,357,1382,285,387,1383,624,530,1384,510,461,1409,695,351,1414,296,201},
[463]={858,1148,472,219,1150,605,79,1151,249,102,1152,180,277,1153,335,215,1155,562,321,1157,787,125,1158,724,214,1162,412,333,1163,332,534,1164,663,408,1165,774,431,1174,136,373,1177,342,312,1225,582,128,1240,696,48,1241,482,564,1431,620,189},
[464]={860,1363,614,359,1364,777,292,1365,493,339,1366,265,436,1367,588,118,1368,477,46,1369,584,448,1370,528,280,1371,467,484,1372,370,391,1373,528,410,1374,354,84,1375,127,525,1376,461,135,1377,293,235,1378,237,362,1379,320,531,1385,536,115,1386,860,436,1387,705,428,1388,191,564,1389,133,572},
[465]={862,1200,544,564,1201,269,410,1202,473,354,1203,549,432,1208,314,181,1215,412,219,1216,133,397,1217,236,268,1218,702,337,1219,879,337,1220,554,259,1221,621,120,1222,702,492,1281,275,515,1282,142,274,1283,590,210,1285,791,488,1286,454,552,1321,448,490,1322,652,208,1323,535,182,1324,657,292,1325,335,404,1410,793,228,1411,618,553},
[467]={863,1125,180,155,1126,812,423,1133,448,443,1136,336,237,1139,217,265,1141,290,407,1146,686,329,1147,828,251,1149,587,414,1154,479,346,1156,836,548,1178,178,332,1234,186,55,1236,627,275,1237,449,169,1238,145,415,1239,318,350,1279,724,540,1320,231,445,1399,436,275,1400,504,272,1401,749,475,1402,861,356,1404,252,158,1432,708,534},
[473]={864,1101,454,176,1103,450,447,1104,241,263,1105,709,573,1107,294,175,1110,778,272,1112,397,265,1116,499,276,1118,574,335,1121,355,403,1273,615,175,1274,299,350,1275,682,436,1418,587,250,1419,586,476,1420,642,391,1421,530,171,1422,542,152,1423,703,413,1424,582,473,1425,425,302,1426,564,390,1429,459,381,1438,404,206},
[475]={865,1288,518,112,1289,751,275,1290,408,355,1291,556,176,1292,464,515,1293,861,237,1294,536,294,1295,642,408,1297,747,280,1298,291,542,1299,335,275,1300,396,133,1301,678,157,1302,574,541,1303,740,419,1304,319,184,1305,661,500,1307,613,244,1308,801,199,1309,370,437,1310,681,73,1311,532,365,1312,364,526,1313,652,212,1314,772,503,1315,305,397,1407,603,460,1408,612,512,1412,677,395,1430,620,265},
[476]={861,1328,189,207,1329,409,221,1330,333,604,1331,460,302,1332,856,353,1333,548,371,1334,671,523,1335,620,602,1336,517,513,1337,439,566,1338,379,507,1339,561,234,1340,617,302,1341,735,141,1342,245,276,1343,811,135,1344,388,147,1345,627,170,1346,386,398,1347,292,246,1348,328,133,1349,575,542,1350,180,357,1351,542,114,1352,745,51,1353,302,309,1354,691,446,1355,722,198},
[477]={866,1189,206,344,1190,562,243,1191,426,294,1192,690,534,1193,470,127,1194,424,501,1195,335,299,1196,529,463,1197,659,361,1198,609,141,1199,297,164,1226,752,447,1227,625,431,1228,260,248,1229,499,373,1230,108,262,1231,725,243,1232,743,354,1233,339,123,1415,362,476},
[478]={867,1161,572,379,1166,179,437,1167,439,136,1168,718,232,1169,396,264,1170,590,510,1171,467,289,1173,531,196,1176,292,156,1276,607,269,1277,224,71,1280,601,114,1316,666,349,1390,375,551,1391,505,400,1392,376,332,1393,396,439,1394,313,351,1395,449,564,1396,473,364,1397,350,490,1398,545,455,1405,709,560,1406,542,467,1427,637,280,1428,698,297,1434,241,473,1435,306,281,1436,504,105,1437,591,159,1440,641,443,1445,735,578,1446,691,551,1447,632,541,1448,665,525,1449,390,356,3251,313,508},
[479]={843,1179,336,441,1180,236,488,1181,488,565,1182,596,456,1183,269,264,1184,617,256,1185,545,143,1186,758,417,1187,284,518,1260,398,491,1261,726,259,1262,398,122,1263,571,591,1265,496,114,1266,330,367,1267,560,520,1268,508,383,1269,451,240,1270,232,374,1317,461,65,1318,552,291,1319,300,107,1326,376,177,1327,455,358},
[486]={1264,1462,877,168,1464,502,163,1467,475,542,1469,663,342,1473,299,346,1475,826,311,1476,258,257,1480,503,70,1483,462,233,1484,435,356,1485,580,463,1486,365,314,1487,664,191,1488,765,110,1621,267,169,1622,776,241,1623,506,620,1624,364,418,1625,463,421,1626,691,100,1640,786,183},
[488]={1265,1489,474,325,1490,385,214,1491,712,502,1492,890,295,1494,837,172,1497,397,448,1499,250,262,1501,549,219,1504,636,486,1506,501,118,1514,361,101,1516,369,319,1519,598,333,1521,139,309,1523,772,401,1525,826,473,1528,619,131,1529,728,172,1611,192,402,1612,552,441,1635,269,332},
[490]={1266,1463,213,437,1465,175,157,1466,719,187,1468,781,396,1470,159,331,1471,482,283,1472,503,382,1474,683,99,1477,145,564,1478,290,511,1479,314,387,1481,361,254,1482,651,305,1558,568,190,1615,859,165,1616,793,242,1617,668,396,1618,181,252,1619,256,219,1620,393,333,1636,338,330,1637,271,310,1639,521,128},
[491]={1263,1493,578,240,1495,479,81,1496,265,143,1498,782,183,1500,314,174,1502,344,524,1503,680,353,1505,367,63,1507,752,419,1508,399,339,1509,687,178,1510,608,86,1512,783,309,1513,502,362,1515,529,462,1517,452,222,1518,543,113,1520,584,307,1522,303,278,1524,426,430,1526,726,477,1527,667,262,1559,249,386,1630,516,182,1631,610,157,1633,518,181,1634,611,153},
[492]={1270,1561,484,472,1562,271,261,1563,542,574,1564,89,287,1565,785,403,1566,741,252,1568,693,431,1570,332,444,1571,444,151,1572,529,205,1573,365,162,1574,796,462,1575,549,377,1594,437,378,1596,638,295,1613,860,501,1614,638,415,1638,739,145},
[493]={1268,1544,481,423,1545,469,175,1546,360,503,1547,811,371,1548,297,268,1549,333,349,1550,538,351,1551,660,402,1552,746,231,1553,496,243,1555,242,546,1556,245,224,1607,440,355,1608,532,540,1609,664,290,1610,558,469},
[495]={1269,1576,644,396,1577,648,299,1579,479,456,1580,354,460,1581,240,405,1582,414,117,1583,729,324,1584,505,300,1585,329,388,1587,352,562,1588,274,281,1589,239,335,1590,323,265,1591,472,546,1592,294,494,1593,409,383},
[496]={1267,1530,838,112,1531,418,514,1532,482,377,1533,405,260,1534,534,245,1535,770,397,1536,734,305,1537,646,461,1538,595,387,1539,212,503,1540,282,302,1541,169,383,1542,320,511,1543,621,519,1627,661,230,1628,146,490,1629,283,578},
[499]={868,1454,508,460,1455,507,260,1456,413,201,1457,378,305,1458,580,168,1459,638,347,1460,532,494},
[510]={1457,1597,265,410,1598,161,103,1599,770,310,1600,431,285,1601,752,555,1602,146,295,1603,131,227,1604,649,404,1632,773,407},
[606]={4863,2492,218,358,2493,842,363,2495,726,513,2496,635,141,2497,314,568,2498,286,185,2499,330,343,2500,534,368,2501,527,523,3017,438,283,3018,452,174,3019,455,155,3020,455,155,3150,117,220,3151,193,233,3152,443,284,3154,892,399,3155,926,325,3156,487,525,3157,775,305},
[607]={4996,2545,508,561,2546,466,431,2547,522,325,2548,410,523,2550,395,150,2551,688,329,2553,450,363,2554,479,226,2555,425,295,3008,366,74,3009,380,598,3177,380,611,3178,400,461,3179,514,435,3180,451,564,3181,438,229,3182,377,333},
[610]={4825,2604,615,394,2605,533,376,2606,589,543,2607,504,162,2608,398,198,2999,535,274,3000,638,322,3083,553,237,3239,622,414},
[614]={4825,2595,221,536,2596,717,199,2597,423,468,2598,394,130,2599,464,235,2600,541,427,2601,323,362,2602,549,291,3079,599,526,3080,614,364,3081,429,219,3082,501,120},
[615]={4825,2610,554,554,2611,437,324,2612,593,378,2613,665,279,2614,337,484,2615,510,145,2616,479,253,3084,472,401,3085,487,461},
[640]={4864,2691,744,273,2692,629,391,2693,268,218,2694,218,319,2695,706,143,2696,263,465,2697,558,505,2698,492,319,2699,399,125,2700,566,73,2701,353,537,2702,684,520,2703,392,462,3209,556,583,3210,403,395,3211,568,163,3212,626,243,3213,612,321,3236,698,163},
[673]={4995,2575,398,474,2576,625,188,2577,464,151,2579,609,545,2580,506,389,2581,431,328,2582,623,292,2583,545,203,2584,579,98,2585,435,545,2998,342,217,3066,558,265,3067,371,334,3068,354,427},
[700]={4866,2884,541,286,2885,508,380,2886,462,516,2887,263,253,2888,762,355,2889,497,460,2890,613,379,2891,383,195,2892,627,308,2893,188,344,2894,808,514,2895,601,446,2896,415,159,2897,579,95,2898,644,527,2899,437,122,2900,721,269,2901,580,203,2902,380,252,2903,770,98,2904,400,311,2905,314,485,2906,503,196,2907,740,446,2908,253,141,2909,404,385,2910,300,331,2911,479,72,2992,401,458,3073,424,553,3074,349,602,3075,465,581},
[720]={4865,2941,544,349,2942,438,470,2943,733,305,2944,646,108,2945,640,490,2946,490,256,2947,673,272,2948,513,549,2949,408,154,2950,647,212,2951,456,376,2952,404,265,2953,549,217,2954,462,104,2955,321,438,2956,208,414,2957,620,272,2958,338,208,2959,849,353,2960,727,133,2961,760,451,2962,769,577,2963,554,287,2988,355,563,3196,778,414,3197,345,119,3198,716,334,3199,597,317,3200,276,70},
[748]={4865,2964,544,349,2965,438,470,2966,733,305,2967,646,108,2968,640,490,2969,490,256,2970,673,272,2971,514,549,2972,408,154,2973,647,212,2974,456,376,2975,404,265,2976,549,217,2977,462,104,2978,321,438,2979,211,414,2980,620,272,2981,338,208,2982,849,353,2983,727,133,2984,760,451,2985,769,577,2986,355,563,2987,554,287,3201,778,414,3202,345,119,3203,716,334,3204,276,70},
[770]={4866,2912,541,286,2913,508,380,2914,462,516,2915,263,253,2916,762,355,2917,497,460,2918,606,355,2919,383,195,2920,627,308,2921,188,344,2922,808,514,2923,601,446,2924,415,159,2925,579,95,2926,644,527,2927,437,122,2928,721,269,2929,580,203,2930,380,252,2931,770,98,2932,400,311,2933,314,485,2934,401,458,2935,503,196,2936,740,446,2937,253,141,2938,404,385,2939,479,72,2940,300,331,2993,409,455,3076,424,553,3077,349,602,3078,465,581},
[806]={6351,3295,413,155,3296,442,283,3297,583,594,3298,531,123,3299,664,513,3300,308,328,3301,279,158,3302,518,217,3303,399,458,3304,298,253,3305,414,79,3306,483,407,3307,517,506,3308,600,400,3309,602,320,3310,455,575,3311,664,217,3393,289,70,3394,242,207,3395,255,253,3396,310,281,3397,401,277,3398,317,345,3399,394,515,3400,541,542,3401,498,614,3402,561,614,3403,664,548,3404,544,246,3405,483,232,3406,515,175,3515,404,541},
[807]={6969,3340,470,536,3341,104,497,3342,542,187,3343,491,431,3344,541,299,3345,135,364,3346,323,226,3347,676,269,3348,228,497,3349,148,228,3350,619,181,3351,657,382,3352,720,423,3353,257,275,3354,355,524,3355,396,271,3356,812,158,3357,850,275,3436,333,136,3437,322,187,3438,296,238,3439,258,305,3440,221,450,3441,196,512,3442,530,335,3443,446,182,3444,706,140,3445,606,242,3446,684,238,3447,686,288,3448,756,233,3449,833,135,3450,755,158,3451,820,173},
[809]={6976,3282,727,569,3283,434,582,3284,579,587,3285,359,488,3286,588,515,3287,384,368,3288,717,444,3289,476,201,3290,280,284,3291,712,300,3292,553,448,3293,565,311,3294,651,173,3358,731,120,3376,764,55,3377,642,143,3378,573,316,3379,722,383,3380,709,421,3381,730,458,3382,726,548,3383,680,490,3384,601,588,3385,438,577,3386,296,427,3387,490,537,3388,449,338,3389,461,426,3390,592,483,3391,628,454,3392,640,404,3562,607,372,3563,326,168},
[810]={6977,3312,722,568,3313,547,343,3314,540,557,3315,361,420,3316,679,333,3317,833,515,3318,519,470,3319,275,123,3320,436,550,3321,239,333,3322,680,471,3418,412,329,3419,351,339,3420,505,328,3421,615,279,3422,559,402,3423,280,365,3424,321,484,3425,309,529,3426,598,585,3427,765,510,3428,730,472,3429,659,458},
[811]={6979,3323,255,177,3324,355,515,3325,815,214,3326,175,448,3327,449,143,3328,779,446,3329,580,358,3330,482,470,3331,631,141,3332,411,310,3333,184,273,3430,220,114,3431,307,136,3432,91,391,3433,272,358},
[857]={6975,3267,677,302,3268,312,501,3269,608,144,3270,325,273,3271,765,102,3272,697,166,3273,466,493,3274,423,195,3275,546,235,3276,230,285,3277,409,344,3278,491,265,3279,128,229,3280,149,423,3281,459,583,3334,149,423,3335,844,153,3360,744,97,3361,824,175,3362,693,148,3363,637,205,3364,560,310,3365,379,282,3366,502,177,3367,458,456,3368,526,501,3369,469,604,3370,237,313,3371,292,254,3372,136,248,3373,365,504,3374,319,466,3375,350,550,3508,121,401},
[858]={6978,3476,476,109,3477,376,446,3478,445,284,3479,598,418,3480,322,268,3482,602,321,3483,576,213,3484,647,95,3486,345,125,3487,584,526,3488,697,209,3489,307,526,3493,517,88,3494,602,157,3495,266,262,3496,588,124,3498,462,253,3499,618,477,3500,462,351,3501,455,520,3502,511,471,3503,605,564,3504,303,599,3505,237,572,3506,385,345,3507,507,389,3510,511,142},
[907]={850,3516,759,121,3517,371,91,3518,325,183,3519,497,319,3520,325,488,3521,295,303,3522,694,346,3523,577,518,3524,563,176},
[910]={6975,3528,319,466,3529,718,299,3530,312,501,3531,423,195,3532,608,144,3533,637,205,3534,350,550,3535,325,273,3536,292,254,3537,458,456,3538,824,175,3539,379,282,3540,526,501,3541,466,493,3542,365,504,3543,546,235,3544,237,313,3545,230,285,3546,560,310,3547,136,248,3548,409,344,3549,502,177,3550,491,265,3551,128,229,3552,697,166,3553,693,148,3554,121,401,3555,137,431,3556,137,431,3557,848,165,3558,459,583,3559,469,604,3560,744,97,3561,765,102},
}
print(OMEGAMAP_EXPLORER_LOADED_MESSAGE)

end