--	///////////////////////////////////////////////////////////////////////////////////////////

--	Listing of Battlegrounds and POI
--	the wmData and omData allow the positioning of Player/Party/Raid dots on the map and relate GetPlayerCoordinates to frame coordinates on the map
--	wmData is the coordinates on the world map, omData is the coordiantes as they would be on the alternate map
--	Zones are localized via Libbabble-Zone & Libbabble-Subzone

--	///////////////////////////////////////////////////////////////////////////////////////////

local LibStub = _G.LibStub
OM_ZONE = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
OM_SUBZONE = LibStub("LibBabble-SubZone-3.0"):GetLookupTable()
OM_TYP_EXTERIORS = "Exteriors";

OMEGAMAP_EXTERIORS_LIST = {

--Kalimdor 
--No area map in Mists
		{	name = OM_ZONE["Blackfathom Deeps"],
			type = OM_TYP_EXTERIORS,
			continent = OM_ZONE["Kalimdor"],
			location = "Ashenvale",
			zoneName = OM_ZONE["Blackfathom Deeps"],
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\BlackfathomDeepsExt",
			wmData = { minX = .12189769744873, maxX = .18213260173798, minY =  .083228528499603, maxY = .145922660822764 },
			omData = { minX = 0.045, maxX = 0.975, minY = 0.14, maxY = 0.81 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {35, 80} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1, toWorldMap = OM_ZONE["Ashenvale"], },
			note2  = { text = OM_ZONE["Blackfathom Deeps"], color = OM_ORANGE, coords = { {70, 43.8} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = OM_ZONE["Blackfathom Deeps"], leaveGap = 1 },
		},
--[[  Removed due to Blizzard adding zone map for area
		{	name = OM_ZONE["Caverns of Time"],
			type = OM_TYP_EXTERIORS,
			continent = OM_ZONE["Kalimdor"],
			location = "Tanaris",
			zoneName = OM_ZONE["Caverns of Time"],
			subZones = OM_ZONE["Caverns of Time"],
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\CoTExt",
			wmData = { minX = 0.53913325071335, maxX = .672760373949, minY =  0.47434741258621, maxY = 0.62782263755798 },
			omData = { minX = 0.04797, maxX = 0.91615, minY = 0.1972, maxY = 0.82602},
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {75,28} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "tlrds", leaveGap = 1, toWorldMap = "Tanaris", },
			note2  = { text = OM_ZONE["Old Hillsbrad Foothills"], color = OM_ORANGE, coords = { {8,40} }, symbol = { "A" },
					tooltiptxt = "", toMap = "Old Hillsbrad Foothills" },
			note3  = { text = OM_ZONE["The Black Morass"], color = OM_ORANGE, coords = { {20,84} }, symbol = { "B" },
					tooltiptxt = "", toMap = "Black Morass" },
			note4  = { text = OM_ZONE["Mount Hyjal"], color = OM_ORANGE, coords = { {25,28} }, symbol = { "C" },
					tooltiptxt = "", toMap = "Battle for Mount Hyjal",special = "Raid" },
			note5  = { text = OM_ZONE["The Culling of Stratholme"], color = OM_ORANGE, coords = { {51, 79} }, symbol = { "D" },
					tooltiptxt = "", toMap = "The Culling of Stratholme", leaveGap = 1 },
			note6  = { text = OM_ZONE["End Time"], color = OM_ORANGE, coords = { {49,39} }, symbol = { "E" },
					tooltiptxt = "", toMap = "", leaveGap = 1 },	
			note7  = { text = OM_ZONE["Hour of Twilight"], color = OM_ORANGE, coords = { {62, 38} }, symbol = { "F" },
					tooltiptxt = "", toMap = "Hour of Twilight", leaveGap = 1 },
			note8  = { text = OM_ZONE["Well of Eternity"], color = OM_ORANGE, coords = { {09,65} }, symbol = { "G" },
					tooltiptxt = "", toMap = "Well of Eternity", leaveGap = 1 },
			note9   = { text = OM_ZONE["Dragon Soul"], color = OM_ORANGE, coords = { {54,31} }, symbol = { "H" },
					tooltiptxt = "", toMap = "", leaveGap = 1, special = "Raid" },
			note10  = { text = "Steward of Time", color = OM_GREEN, coords = { {75,28} }, symbol = { "X" },
					tooltiptxt = "" },
			note11  = { text = "Alexston Chrome", color = OM_GREEN, coords = { {87,30} }, symbol = { "1" },
					tooltiptxt = "" },
			note12  = { text = "GraveYard", color = OM_GREEN, coords = { {52, 62} }, symbol = { "2" },
					tooltiptxt = "" },
			note13  = { text = "Yarley", color = OM_GREEN, coords = { {63,54} }, symbol = { "3" },
					tooltiptxt = "" },
			note14 = { text = "Bortega", color = OM_GREEN, coords = { {64,62} }, symbol = { "4" },
					tooltiptxt = "" },
			note15 = { text = "Galgrom", color = OM_GREEN, coords = { {64,62} }, symbol = { " " },
					tooltiptxt = "" },
			note16 = { text = "Alurmi", color = OM_GREEN, coords = { {64,62} }, symbol = { " " },
					tooltiptxt = "" },
			note17 = { text = "Zaladormu", color = OM_GREEN, coords = { {37, 56} }, symbol = { "5" },
					tooltiptxt = "" },
			note18 = { text = "Soridormi", color = OM_GREEN, coords = { {37, 56} }, symbol = { " " },
					tooltiptxt = "", special = OM_WANDERS },
			note19 = { text = "Arazmodu", color = OM_GREEN, coords = { {37, 56} }, symbol = { " " },
					tooltiptxt = "", special = OM_WANDERS },
			note20 = { text = "MoonWell", color = OM_GREEN, coords = { {37, 33} }, symbol = { "6" },
					tooltiptxt = "" },
			note21 = { text = "Andormu", color = OM_GREEN, coords = { {31, 45} }, symbol = { "7" },
					tooltiptxt = "", special = "(Child)" },
			note22 = { text = "Nozari", color = OM_GREEN, coords = { {31, 45} }, symbol = { " " },
					tooltiptxt = "", special = "(Child)" },
			note23 = { text = "Andormu", color = OM_GREEN, coords = { {25, 67} }, symbol = { "8" },
					tooltiptxt = "", special = "(Adult)" },
			note24 = { text = "Nozari", color = OM_GREEN, coords = { {25, 67} }, symbol = { " " },
					tooltiptxt = "", special = "(Adult)" },
		},
--]]
		{	name = OM_ZONE["Dire Maul"],
			type = OM_TYP_EXTERIORS,
			continent = OM_ZONE["Kalimdor"],
			location = "Feralas",	
			zoneName = OM_ZONE["Dire Maul"],
			subZones = OM_SUBZONE["Eldreth Row"]..OM_SUBZONE ["The Maul"],
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\DireMaulExt",
			wmData = { minX = 0.5859169960022, maxX = 0.65901774168015, minY =  0.25329810380936, maxY = 0.4103399515152 },
			omData = { minX = 0.28, maxX = 0.92, minY =  0.06, maxY = 0.97 },
			note1  = { text = "Entrance", color = OM_GREEN, coords = { {32, 97}  }, symbol = { "X" },
					tooltiptxt = "", toWorldMap = "Feralas", leaveGap = 1 },
			note2  = { text = OM_SUBZONE["Eldreth Row"], color = OM_BLUE, coords = { {57, 73} }, symbol = { "1" },
					tooltiptxt = "" },
			note3  = { text = OM_SUBZONE["Broken Commons"], color = OM_BLUE, coords = { {62, 50} }, symbol = { "2" },
					tooltiptxt = "" },
			note4  = { text = "Skarr the Unbreakable", color = OM_RED, coords = { {62, 33} }, symbol = { "3" },
					tooltiptxt = "Lvl58 Elite Humanoid" },
			note5  = { text = OM_SUBZONE ["The Maul"], color = OM_RED, coords = { {62, 26} }, symbol = { "4" },
					tooltiptxt = "PvP Area" },	
			note6  = { text = "Path to The Maul", color = OM_BLUE, coords = { {44, 47}, {58, 33} }, symbol = { "P" },
					tooltiptxt = "Sleeping Hyena Guards" },
			note7  = { text = "Chamber with roof Exit from DM East", color = OM_BLUE, coords = { {85, 19.4} }, symbol = { "5" },
					tooltiptxt = "", leaveGap = 1 },
			note8  = { text = OM_ZONE["Dire Maul (East)"], color = OM_GREEN, coords = { {84, 32}, {96, 62} }, symbol = { "E" },
					tooltiptxt = "Click to Open Dire Maul East Map", toMap = "Dire Maul East" },
			note9  = { text = OM_ZONE["Dire Maul (North)"], color = OM_GREEN, coords = { {62, 4} }, symbol = { "N" },
					tooltiptxt = "Click to Open Dire Maul North Map", toMap = "Dire Maul North" },
			note10 = { text = OM_ZONE["Dire Maul (West)"], color = OM_GREEN, coords = { {42, 40} }, symbol = { "W" },
					tooltiptxt = "Click to Open Dire Maul West Map", toMap = "Dire Maul West", leaveGap = 1 }
		},
--[[  Removed due to Blizzard adding zone map for area
		{	name = OM_ZONE["Maraudon"],
			type = OM_TYP_EXTERIORS,
			continent = OM_ZONE["Kalimdor"],
			location = "Desolace",
			zoneName = OM_ZONE["Maraudon"],
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\MaraudonExt",
			wmData = { minX = .26340276002884, maxX = .36817133426666, minY =  .53087019920349, maxY = .69066041707993 },
			omData = { minX = 0.02, maxX = 0.92, minY = 0.01, maxY = 0.98 },
			note1  = { text = "Entrance", color = OM_GREEN, coords = { {23, 59}  }, symbol = { "X" },
					tooltiptxt = "", leaveGap = 1, toWorldMap = "Desolace", },
			note2  = { text = "First Khan", color = OM_RED, coords = { {31, 45} }, symbol = { "1" },
					tooltiptxt = "" },
			note3  = { text = "Second Khan", color = OM_RED, coords = { {24, 29} }, symbol = { "2" },
					tooltiptxt = "Mid level between pools" },
			note4  = { text = "Third Khan", color = OM_RED, coords = { {80, 46} }, symbol = { "3" },
					tooltiptxt = "" },
			note5  = { text = "Cavindra", color = OM_GREEN, coords = { {48, 64} }, symbol = { "4" },
					tooltiptxt = "Quest Giver", leaveGap = 1 },
			note6  = { text = OM_SUBZONE["Maruadon - The Wicked Grotto Entrance"], color = OM_BLUE, coords = { {24, 47} }, symbol = { "P" },
					tooltiptxt = "Requires Scepter of Celebras" },
			note7  = { text = OM_ZONE["Maraudon"].." (Orange)", color = OM_ORANGE, coords = { {84, 71} }, symbol = { "X1" },
					tooltiptxt = "Click to Open Maraudon Instance Map", toMap = OM_ZONE["Maraudon"] },
			note8  = { text = OM_ZONE["Maraudon"].." (Purple)", color = OM_PURPLE, coords = { {39, 12.4} }, symbol = { "X2" },
					tooltiptxt = "Click to Open Maraudon Instance Map", toMap = OM_ZONE["Maraudon"] }
		},
  Removed due to Blizzard adding zone map for area
		{	name = OM_ZONE["Wailing Caverns"],
			type = OM_TYP_EXTERIORS,
			continent = OM_ZONE["Kalimdor"],
			location = "Barrens",  --Northern
			zoneName = OM_SUBZONE["The Wailing Caverns"],
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\WailingCavernsExt",
			wmData = { minX = .38171780109406, maxX =.45261985063353, minY =  .6114901304245, maxY = .69204878808068 },
			omData = { minX = 0.04261, maxX = 0.97868, minY = 0.12281, maxY = 0.81173 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {14.2, 81.5}  }, symbol = { "X" },
					tooltiptxt = "", leaveGap = 1, toWorldMap = OM_ZONE["Northern Barrens"], },
			note2  = { text = OM_ZONE["Wailing Caverns"], color = OM_ORANGE, coords = { {55.1, 62.2} }, symbol = { "W" },
					tooltiptxt = "Click to Open Wailing Caverns Instance Map", toMap = "Wailing Caverns", leaveGap = 1 }
		},
--]]

-- East kingdom
--[[
--Blackrock Moutain is split into 2 parts due to straddling zones

		{	name = OM_ZONE["Blackrock Mountain"],-- Blackrock Mountain North
			type = OM_TYP_EXTERIORS,
			continent = "" ,
			location = "SearingGorge",
			zoneName = OM_ZONE["Blackrock Mountain"],
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\BRMExt",
			wmData = { minX = .23935377597809, maxX = .35616987943649, minY = .7195826768875, maxY = .94094699621201},
			omData = { minX = 0.10853, maxX = 0.49812, minY = 0.04940, maxY = 0.54902 },
			note1  = { text = OM_ZONE["Searing Gorge"], color = OM_BLUE, coords = { {50.0, 38.0} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toWorldMap = "SearingGorge", },
			note2  = { text = OM_ZONE["Burning Steppes"], color = OM_BLUE, coords = { {53.2, 98.2} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1, toWorldMap = "BurningSteppes", },
			note3  = { text = "LBRS/UBRS/BWL", color = OM_ORANGE, coords = { {71, 59.4} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Blackrock Spire", leaveGap = 1 },
			note4  = { text = "Lothos Riftwalker", color = OM_BLUE, coords = { {40, 57} }, symbol = { "1" },
					tooltiptxt = "Attunement to Core\nTeleport to Molten Core", toMap = "Molten Core", leaveGap = 1 },
			note5  = { text = "Overmaster Pyron", color = OM_RED, coords = { {21.1, 15.0} }, symbol = { "2" },
					tooltiptxt = "Lvl52 Elite Elemental", special = OM_WANDERS, leaveGap = 1 },
			note6  = { text = "BRD/MC", color = OM_ORANGE, coords = { {25, 9} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Blackrock Depths", leaveGap = 1 },
								note7  = { text = "BRC", color = OM_ORANGE, coords = { {75,69} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Blackrock Caverns", leaveGap = 1 },
		},

		{	name = OM_ZONE["Blackrock Mountain"],-- Blackrock Mountain South
			type = OM_TYP_EXTERIORS,
			continent = "" ,
			location = "BurningSteppes",
			zoneName = OM_ZONE["Blackrock Mountain"],
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\BRMExt",
			wmData = { minX = .13565695285797	, maxX = 0.27397221326828, minY = .15523391962051, maxY = .37359362840652 },
			omData = { minX = 0.18263, maxX = 0.74513, minY = 0.26721, maxY = 0.96839 },
			note1  = { text = OM_ZONE["Searing Gorge"], color = OM_BLUE, coords = { {50.0, 38.0} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toWorldMap = "SearingGorge", },
			note2  = { text = OM_ZONE["Burning Steppes"], color = OM_BLUE, coords = { {48,96} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1, toWorldMap = "BurningSteppes", },
			note3  = { text = "LBRS/UBRS/BWL", color = OM_ORANGE, coords = { {71, 59.4} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Blackrock Spire", leaveGap = 1 },
			note4  = { text = "Lothos Riftwalker", color = OM_BLUE, coords = { {40, 57} }, symbol = { "1" },
					tooltiptxt = "Attunement to Core\nTeleport to Molten Core", toMap = "Molten Core", leaveGap = 1 },
			note5  = { text = "Overmaster Pyron", color = OM_RED, coords = { {21.1, 15.0} }, symbol = { "2" },
					tooltiptxt = "Lvl52 Elite Elemental", special = OM_WANDERS, leaveGap = 1 },
			note6  = { text = "BRD/MC", color = OM_ORANGE, coords = { {22, 6} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Blackrock Depths", leaveGap = 1 },
			note7  = { text = OM_ZONE["Blackrock Caverns"], color = OM_ORANGE, coords = { {75,69} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Blackrock Caverns", leaveGap = 1 },
		},

		{	name = OM_ZONE["Gnomeregan"], --"Now Gnome Starting Zone",
			type = OM_TYP_EXTERIORS,
			continent = "",
			location = "DunMorogh",
			zoneName = "",
			subZones = OM_ZONE["Gnomeregan"]..OM_SUBZONE["Loading Room"]..OM_SUBZONE["Train Depot"]..OM_SUBZONE["Workshop Entrance"]..OM_SUBZONE["The Old Dormitory"],
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\GnomereganExt",			
			wmData = { minX = 0.2532029747963, maxX = 0.31219710840454, minY = .29589283466339, maxY = 0.38333570957184 },
			omData = { minX = 0.24804, maxX = 0.97689, minY = 0.19900, maxY = 0.91177 },
			note1  = { text = "Outside", color = OM_GREEN, coords = { {97,88} }, symbol = { "O" },
					tooltiptxt = "", toWorldMap = "DunMorogh", },
			note2  = { text = "Elevator", color = OM_GREEN, coords = { {83,88} }, symbol = { "L" },
					tooltiptxt = "" },
			note3  = { text = "Main Instance Entrance", color = OM_ORANGE, coords = { {23,78} }, symbol = { "I" },
					tooltiptxt = "", toMap = "Gnomeregan" },
			note4  = { text = "Workshop Instance Entrance", color = OM_ORANGE, coords = { {42,21} }, symbol = { "W" },
					tooltiptxt = "", toMap = "Gnomeregan", leaveGap = 1  }
		},
		--]]
--No area map in Mists
		{	name = OM_ZONE["Karazhan"],
			type = OM_TYP_EXTERIORS,
			continent = "" ,
			location = "DeadwindPass",
			zoneName = OM_ZONE["Karazhan"],
			subZones = OM_ZONE["Karazhan"],
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\KarazhanExt",
			wmData = { minX = 0.41501, maxX = 0.5179492, minY =  0.6651555, maxY = 0.822 },	--8172344
			omData = { minX = 0.02, maxX = 1.0, minY = 0.0, maxY = 0.98 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_ORANGE, coords = { {53, 50} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Karazhan", special = "(Front)", },
			note2  = { text = OM_INSTANCE_ENTRANCES, color = OM_ORANGE, coords = { {73, 8} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Karazhan", special = "(Back)", leaveGap = 1 },
			note3  = { text = "Meeting Stone", color = OM_BLUE, coords = { {44, 57} }, symbol = { "A" },
					tooltiptxt = "" },
			note4  = { text = "Graveyard & Crypt", color = OM_BLUE, coords = { {0, 62} }, symbol = { "B" },
					tooltiptxt = "", leaveGap = 1 },
			note5  = { text = "Archmage Leryda", color = OM_GREEN, coords = { {58, 51} }, symbol = { "1" },
					tooltiptxt = "" },
			note6  = { text = "Apprentice Darius", color = OM_GREEN, coords = { {53, 56} }, symbol = { "2" },
					tooltiptxt = "" },
			note7  = { text = "Archmage Alturus", color = OM_GREEN, coords = { {54, 61} }, symbol = { "3" },
					tooltiptxt = "" },
			note8  = { text = "Stairs to Underground Pond", color = OM_GREEN, coords = { {59, 75} }, symbol = { "4" },
					tooltiptxt = "" },
			note9  = { text = "Stairs to Underground Well", color = OM_GREEN, coords = { {72, 77} }, symbol = { "5" },
					tooltiptxt = "" },
			note10 = { text = "Charred Bone Fragment", color = OM_GREEN, coords = { {31, 76} }, symbol = { "6" },
					tooltiptxt = "" },
			note11 = { text = OM_INSTANCE_EXITS, color = OM_BLUE, coords = { {1, 1} }, symbol = { "<-" },
					tooltiptxt = "", toWorldMap = "DeadwindPass", },
		},
--[[  Removed due to Bliz adding area map
		{	name = OM_ZONE["Scarlet Monastery"],
			type = OM_TYP_EXTERIORS,
			continent = "" ,
			location = "Tirisfal",
			zoneName = OM_ZONE["Scarlet Monastery"],
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\SMExt",
			wmData = { minX = 0.82315838336945, maxX = .85421311855316, minY =  .30507516860962, maxY = .33259654045105 },
			omData = { minX = 0.03176, maxX = 0.84472, minY = 0.33252	, maxY = 0.80676},
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {5, 76}, {9, 71} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1, toWorldMap = "Tirisfal", },
			note2  = { text = "Graveyard", color = OM_ORANGE, coords = { {70,29} }, symbol = { "1" },
					tooltiptxt = "", toMap = "Scarlet Monastery" },
			note3  = { text = "Cathedral", color = OM_ORANGE, coords = { {83,30} }, symbol = { "2" },
					tooltiptxt = "", toMap = "Scarlet Monastery" },
			note4  = { text = "Armory", color = OM_ORANGE, coords = { {93,51} }, symbol = { "3" },
					tooltiptxt = "", toMap = "Scarlet Monastery" },
			note5  = { text = "Library", color = OM_ORANGE, coords = { {83,60} }, symbol = { "4" },
					tooltiptxt = "", toMap = "Scarlet Monastery" },
		},
--]]
--No area map in Mists
		{	name = OM_ZONE["The Temple of Atal'Hakkar"],
			type = OM_TYP_EXTERIORS,
 			continent = "" ,
			location = "SwampOfSorrows",
			zoneName = OM_ZONE["The Temple of Atal'Hakkar"],
			subZones = OM_ZONE["The Temple of Atal'Hakkar"],
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\SunkenTempleExt",
			wmData = { minX = 0.6906280517581, maxX = .80286765098572, minY = 0.39707148075104, maxY = 0.554072121019363 },
			omData = { minX = 0.08, maxX = 0.815, minY = 0.28830, maxY = 0.91 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {12, 89} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", special = "", leaveGap = 1, toWorldMap = "SwampOfSorrows", },
			note2  = { text = "Proestess Udum'bra", color = OM_RED, coords = { {46, 70} }, symbol = { "1" },
					tooltiptxt = "", special = "" },
			note3 = { text = "Jammal'an the Prophet", color = OM_RED, coords = { {58, 38} }, symbol = { "2" },
					tooltiptxt = "", special ="" },
			note4 = { text = "Gomora the Bloodletter", color = OM_RED, coords = { {63, 54} }, symbol = { "3" },
					tooltiptxt = "", special = "", leaveGap = 1 },
			note5 = { text = "Captain Wyrmak", color = OM_RED, coords = { {46, 51} }, symbol = {"4"},
					tooltiptxt = "", special = OM_RARE, leaveGap = 1  },
			note6 = { text = OM_ZONE["Sunken Temple"], color = OM_ORANGE, coords = { {54, 53} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "The Temple of Atal'Hakkar", leaveGap = 1 },
		},
--[[
		{	name = OM_ZONE["The Deadmines"],
			type = OM_TYP_EXTERIORS,
			continent = "" ,
			location = "Westfall",
			zoneName = OM_ZONE["The Deadmines"],
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\TheDeadminesExt",	
			wmData = { minX = .38265603780746, maxX = .44435775279999, minY =  0.7180300951004, maxY = 0.83542853593826 },
			omData = { minX = 0.15, maxX = 0.89, minY = 0.01, maxY = 0.965 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {68, 1} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1, toWorldMap = "Westfall", },
			note2  = { text = "Marisa du'Paige", color = OM_RED, coords = { {40, 70}, {86, 39} }, symbol = { "1" },
					tooltiptxt = "", special = OM_RARE.."(Varies)" },
			note3  = { text = "Brainwashed Noble", color = OM_RED, coords = { { 42, 76 } }, symbol = { "2" },
					tooltiptxt = "", special = OM_RARE },
			note4  = { text = "Foreman Thistlenettle", color = OM_RED, coords = { {60, 86.8} }, symbol = { "3" },
					tooltiptxt = "", leaveGap = 1 },
			note5  = { text = "The Deadmines", color = OM_ORANGE, coords = { {15, 48} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "The Deadmines", leaveGap = 1 },
		},

		{	name = OM_ZONE["Uldaman"],
			type = OM_TYP_EXTERIORS,
			continent = OM_ZONE["Eastern Kingdoms"] ,
			location = "Badlands",
			zoneName = "",
			subZones = OM_SUBZONE["Uldaman"]..OM_SUBZONE["Excavation Center"]..OM_SUBZONE["Dig One"].. OM_SUBZONE["The Sealed Hall"]..OM_SUBZONE["North Common Hall"]..OM_SUBZONE["South Common Hall"], --need
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\UldamanExt",
			wmData = { minX = 0.31672316789627, maxX = 0.41350817680359, minY =  .1024078130722, maxY = .21717876195908 },
			omData = { minX = 0.05688, maxX = 0.95284, minY = 0.24476, maxY = 0.9341 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_GREEN, coords = { {95, 33}  }, symbol = { "X" },
					tooltiptxt = "", leaveGap = 1, toWorldMap = "Badlands", },
			note2  = { text = OM_INSTANCE_CHESTS, color = OM_BLUE, coords = { {23, 64}, {33, 88} }, symbol = { OM_CHEST_SYMBOL },
					tooltiptxt = "Quest Related", leaveGap = 1 },
			note3  = { text = "Uldaman", color = OM_ORANGE, coords = { {30.5, 23} }, symbol = { "U" },
					tooltiptxt = "Click to Open Uldaman Instance Map", toMap = "Uldaman", leaveGap = 1 }
		},	
--]]
-- Outland 
--No area map in Mists
		{	name = OM_ZONE["Auchindoun"],
			type = OM_TYP_EXTERIORS,
			continent = OM_ZONE["Outland"] ,
			location = "TerokkarForest",
			zoneName = "",
			subZones = OM_ZONE["Auchindoun"]..OM_SUBZONE["Ring of Observance"]..OM_ZONE["Auchenai Crypts"]..OM_ZONE["Mana-Tombs"]..OM_ZONE["Sethekk Halls"]..OM_ZONE["Shadow Labyrinth"],
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\AuchindounExt",
			wmData = { minX = 0.34323, maxX = 0.44944, minY =  0.57638, maxY = 0.73592 },
			omData = { minX = 0.11, maxX = 0.89, minY = 0.10, maxY = 0.88 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {21, 20}, {81, 20}, {21, 78}, {81, 78} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1, toWorldMap = "TerokkarForest", },
			note2  = { text = OM_ZONE["Auchenai Crypts"], color = OM_ORANGE, coords = { {8, 49.5} }, symbol = { "A" },
					tooltiptxt = "", toMap = "Auchenai Crypts" },
			note3  = { text = OM_ZONE["Mana-Tombs"], color = OM_ORANGE, coords = { {50, 7} }, symbol = { "B" },
					tooltiptxt = "", toMap = "Mana-Tombs" },
			note4  = { text = OM_ZONE["Sethekk Halls"], color = OM_ORANGE, coords = { {92, 49.5} }, symbol = { "C" },
					tooltiptxt = "", toMap = "Sethekk Halls" },
			note5  = { text = OM_ZONE["Shadow Labyrinth"], color = OM_ORANGE, coords = { {50, 92} }, symbol = { "D" },
					tooltiptxt = "", toMap = "Shadow Labyrinth", leaveGap = 1 },
			note6  = { text = "Meeting Stone", color = OM_GREEN, coords = { {50, 44} }, symbol = { "1" },
					tooltiptxt = "", leaveGap = 1 },
			note7  = { text = "Ha'Lei", color = OM_GREEN, coords = { {18, 49.5} }, symbol = { "2" },
					tooltiptxt = "" },
			note8  = { text = "Greatfather Aldrimus", color = OM_GREEN, coords = { {18, 49.5} }, symbol = { " " },
					tooltiptxt = "" },
			note9  = { text = "Clarissa", color = OM_GREEN, coords = { {18, 49.5} }, symbol = { " " },
					tooltiptxt = "" },
			note10 = { text = "Ramdor the Mad", color = OM_GREEN, coords = { {18, 49.5} }, symbol = { " " },
					tooltiptxt = "" },
			note11 = { text = "Horvon the Armorer", color = OM_GREEN, coords = { {18, 49.5} }, symbol = { " " },
					tooltiptxt = "" },
			note12 = { text = "Nexus-Prince Haramad", color = OM_GREEN, coords = { {50, 16} }, symbol = { "3" },
					tooltiptxt = "" },
			note13 = { text = "Artificer Morphalius", color = OM_GREEN, coords = { {50, 16} }, symbol = { " " },
					tooltiptxt = "" },
			note14 = { text = "Mamdy the \"Ologist\"", color = OM_GREEN, coords = { {50, 16} }, symbol = { " " },
					tooltiptxt = "" },
			note15 = { text = "\"Slim\"", color = OM_GREEN, coords = { {50, 16} }, symbol = { " " },
					tooltiptxt = "" },
			note16 = { text = "\"Captain\" Kaftiz", color = OM_GREEN, coords = { {50, 16} }, symbol = { " " },
					tooltiptxt = "" },
			note17 = { text = "Isfar", color = OM_GREEN, coords = { {83, 49.5} }, symbol = { "4" },
					tooltiptxt = "" },
			note18 = { text = "Field Commander Mahfuun", color = OM_GREEN, coords = { {50, 80} }, symbol = { "5" },
					tooltiptxt = "" },
			note19 = { text = "Spy Grik'tha", color = OM_GREEN, coords = { {50, 80} }, symbol = { " " },
					tooltiptxt = "" },
			note20 = { text = "Provisioner Tsaalt", color = OM_GREEN, coords = { {50, 80} }, symbol = { " " },
					tooltiptxt = "" },
			note21 = { text = "Dealer Tariq", color = OM_GREEN, coords = { {50, 80} }, symbol = { " " },
					tooltiptxt = "" },
		},
--No area map in Mists
		{	name = OM_ZONE["Coilfang Reservoir"],
			type = OM_TYP_EXTERIORS,
			continent = OM_ZONE["Outland"] ,
			location = "Zangarmarsh",
			zoneName = OM_ZONE["Coilfang Reservoir"],  --
			subZones = OM_ZONE["Coilfang Reservoir"],
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\CoilfangExt",
			wmData = { minX = 0.48742, maxX = 0.54289, minY =  0.33097, maxY = 0.38282 },  --.4137616535782
			omData = { minX = 0.14, maxX = 0.73, minY = 0.43, maxY = 0.80 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {48.24, 77.34} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "(Underwater)", leaveGap = 1, toWorldMap = "Zangarmarsh", },
			note2  = { text = OM_ZONE["The Slave Pens"], color = OM_ORANGE, coords = { {16.41, 62.89} }, symbol = { "A" },
					tooltiptxt = "", toMap = "The Slave Pens" },
			note3  = { text = OM_ZONE["The Steamvault"], color = OM_ORANGE, coords = { {31.05, 45.70} }, symbol = { "B" },
					tooltiptxt = "", toMap = "The Steamvault" },
			note4  = { text = OM_ZONE["Serpentshrine Cavern"], color = OM_ORANGE, coords = { {48.05, 46.48} }, symbol = { "C" },
					tooltiptxt = "", toMap = "Serpentshrine Cavern" },
			note5  = { text = OM_ZONE["The Underbog"], color = OM_ORANGE, coords = { {68.95, 59.375} }, symbol = { "D" },
					tooltiptxt = "", toMap = "The Underbog", leaveGap = 1 },
			note6  = { text = "Watcher Jhang", color = OM_GREEN, coords = { {49.8, 64.26} }, symbol = { "1" },
					tooltiptxt = "", special = "Meeting Stone" },
			note7  = { text = "Mortog Steamhead", color = OM_GREEN, coords = { {44.14, 59.96} }, symbol = { "2" },
					tooltiptxt = "" },
		},
--Molten Front
	{	name = OM_SUBZONE["The Molten Flow"],
			type = OM_TYP_EXTERIORS,
			continent = "" ,
			location = "MoltenFront",
			zoneName = "",  
			subZones = OM_SUBZONE["The Molten Flow"],
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\MoltenFlow",
			mapEdge = 1,
			wmData = { minX = 0.31960934400558, maxX = .54395878314972, minY =  .30657162821354, maxY = .70988100767136 },  --.4137616535782
			omData = { minX = 0.10, maxX = 0.82, minY = 0.11, maxY = 0.97 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {15,90} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1,},
			note2  = { text = "Thisalee Crow", color = OM_ORANGE, coords = { {43,72} }, symbol = { "A" },
					tooltiptxt = "",  },
		},
--Deepholm
	{	name = OM_SUBZONE["Temple of Earth"],
			type = OM_TYP_EXTERIORS,
			continent = "" ,
			location = "Deepholm",
			zoneName = "",  
			subZones = OM_SUBZONE["Temple of Earth"]..OM_SUBZONE["Deepholm"],
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\TempleofEarth",
			mapEdge = 1,
			wmData = { minX = 0.47330528497696, maxX = .51652371883392, minY =  .4936683779944, maxY = .54699563980103 },  --.4137616535782
			omData = { minX = 0.03, maxX = 0.94, minY = 0.11, maxY = 0.88 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {57,87} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1,},
			note2  = { text = "Portal to Stormwind", color = OM_ORANGE, coords = { {30,75} }, symbol = { "A" },
					tooltiptxt = "",  },
			note3  = { text = "Portal to "..OM_SUBZONE["Therazane's Throne"], color = OM_ORANGE, coords = { {45,29} }, symbol = { "B" },
					tooltiptxt = "",  },
			note4  = { text = "Portal to Orgamar", color = OM_ORANGE, coords = { {78,66} }, symbol = { "C" },
					tooltiptxt = "",  },
		},

		{	name = OM_SUBZONE["Crumbling Depths"],
			type = OM_TYP_EXTERIORS,
			continent = "" ,
			location = "Deepholm",
			zoneName = OM_SUBZONE["Crumbling Depths"],  
			subZones = OM_SUBZONE["Crumbling Depths"],
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\ExtMaps\\CrumblingDepths",
			mapEdge = 1,
			wmData = { minX = 0.59300410747528, maxX = .68250423669815, minY =  .14795410633087, maxY = .29718202352524 },  --.4137616535782
			omData = { minX = 0.06, maxX = 0.91, minY = .02, maxY = 0.98 },
			note1  = { text = OM_INSTANCE_ENTRANCES, color = OM_BLUE, coords = { {6,77} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1,},
			note2  = { text = "Ricket", color = OM_ORANGE, coords = { {25,75} }, symbol = { "A" },
					tooltiptxt = "",  },
		},
};