--	///////////////////////////////////////////////////////////////////////////////////////////

--	Listing of Battlegrounds and POI
--	the wmData and omData allow the positioning of Player/Party/Raid dots on the map and relate GetPlayerCoordinates to frame coordinates on the map
--	wmData is the coordinates on the world map, omData is the coordiantes as they would be on the alternate map

--	///////////////////////////////////////////////////////////////////////////////////////////

OM_TYP_BG = "BattleGrounds";	-- Register the Type of map

OMEGAMAP_BATTLEGROUNDS_LIST = {
		{ 	name = "Alterac Valley",
			mapNumber = 401,
			type = OM_TYP_BG,
			continent = "" ,
			location = "AlteracValley",
			zoneName = "",  --
			subZones = "",
			displayname = "Alterac Valley",
			displayshort = "AV",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\AlteracValley",
			mapEdge = .4,
			wmData = { minX = 0.395, maxX = 0.586, minY =  0.08, maxY = 0.9187 },
			omData = { minX = 0.0672, maxX = 0.42, minY = 0.02, maxY = 0.98 },
			note1  = { text = FACTION_ALLIANCE.." Entrance", color = OM_BLUE, coords = { {31,3} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "" },
			note2  = { text = FACTION_HORDE.." Entrance", color = OM_RED, coords = { {36,92} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
				},

		{ 	name = "Arathi Basin",
			mapNumber = 461,
			type = OM_TYP_BG,
			continent = "" ,
			location = "", --"ArathiBasin",
			zoneName = "",  
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\ArathiBasin",
			mapEdge = 1,
			wmData = { minX = 0.23, maxX = 0.71, minY =  0.09, maxY = 0.76 },
			omData = { minX = 0.10, maxX = 0.97, minY = 0.05, maxY = 0.87 },
			note1  = { text = FACTION_ALLIANCE.." Start", color = OM_BLUE, coords = { {21.8, 12.98} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = FACTION_ALLIANCE.." players start here", bgBase = "A" },
			note2  = { text = FACTION_HORDE.." Start", color = OM_RED, coords = { {91.89, 80.63} }, symbol = { OM_ENTRANCE_SYMBOL },
					tooltiptxt = FACTION_HORDE.." players start here", bgBase = "H", leaveGap = 1 },
		},

		{ 	name = "Eye of the Storm",
			mapNumber = 813,
			type = OM_TYP_BG,
			continent = "" ,
			location = "NetherstormArena",
			zoneName = "",  --
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\NetherstormBG",			-- NetherstormBG
			mapEdge = .75,
			wmData = { minX = 0.347, maxX = 0.614, minY =  0.164, maxY = 0.835 },
			omData = { minX = 0.245, maxX = 0.685, minY = 0.10, maxY = 0.86 },
		},

		{ 	name = "Isle of Conquest",
			mapNumber = 540,
			type = OM_TYP_BG,
			continent = "" ,
			location = "IsleofConquest",
			zoneName = "",
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\IoC",
			mapEdge = 1,
			wmData = { minX = 0.24, maxX = 0.75, minY =  0.10, maxY = 0.93 },
			omData = { minX = 0.06, maxX = 0.91, minY = 0.045, maxY = 0.9746 },
		},

		{ 	name = "Strand of the Ancients",
			mapNumber = 512,
			type = OM_TYP_BG,
			continent = "" ,
			location = "StrandoftheAncients",
			zoneName = "",
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\SotA",
			mapEdge = .85,
			wmData = { minX = 0.34, maxX = 0.64, minY =  0.15, maxY = 0.97 },
			omData = { minX = 0.28, maxX = 0.76, minY = 0.04, maxY = 0.92 },
		},

		{ 	name = "The Battle for Gilneas",
			mapNumber = 736,
			type = OM_TYP_BG,
			continent = "" ,
			location = "GilneasBattleground2",
			zoneName = "",
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\BattleforGilenas",
			mapEdge = .85,
			wmData = { minX = 0.20, maxX = 0.70, minY =  0.17, maxY = 0.90 },
			omData = { minX = 0.13, maxX = 0.85, minY = 0.13, maxY = 0.87 },
		},

		{ 	name = "Twin Peaks",
			mapNumber = 626,
			type = OM_TYP_BG,
			continent = "" ,
			location = "TwinPeaks",
			zoneName = "",  --
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\TwinPeaks",
			mapEdge = .65,
			wmData = { minX = 0.36, maxX = 0.62, minY =  0.09, maxY = 0.89 },
			omData = { minX = 0.07, maxX = 0.48, minY = 0.08, maxY = 0.88 },
			note1  = { text = FACTION_ALLIANCE.." Flag Room", color = OM_BLUE, coords = { {43,16} }, symbol = { "F" },
					tooltiptxt = FACTION_ALLIANCE.." players start here" },
			note2  = { text = FACTION_HORDE.." Flag Room", color = OM_RED, coords = { {26,82} }, symbol = { "F" },
					tooltiptxt = FACTION_HORDE.." players start here" },
			note3  = { text = FACTION_ALLIANCE.." Flag Carrier", color = OM_BLUE, coords = { {60, 16} }, symbol = { "FC" },
					tooltiptxt = "", bgFlag = "A" },
			note4  = { text = FACTION_HORDE.." Flag Carrier", color = OM_RED, coords = { {60,82} }, symbol = { "FC" },
					tooltiptxt = "", bgFlag = "H", leaveGap = 2 },
		},

		{ 	name = "Warsong Gulch",
			mapNumber = 443,
			typeB = OM_TYP_G,
			continent = "" ,
			location = "WarsongGulch",
			zoneName = "",
			subZones = "",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\WarsongGulch",
			mapEdge = .7,
			wmData = { minX = 0.30, maxX = 0.66, minY =  0.09, maxY = 0.93 },
			omData = { minX = 0.05, maxX = 0.60, minY = 0.06, maxY = 0.93 },
			note1  = { text = FACTION_ALLIANCE.." Flag Room", color = OM_BLUE, coords = { {33,10} }, symbol = { "F" },
					tooltiptxt = "Alliance players start here",bgFlag = "A" },
			note2  = { text = FACTION_HORDE.." Flag Room", color = OM_RED, coords = { {37,89} }, symbol = { "F" },
					tooltiptxt = "Horde players start here", bgFlag = "H" },
			note3  = { text = FACTION_ALLIANCE.." Flag Carrier", color = OM_BLUE, coords = { {64,10} }, symbol = { "FC" },
					tooltiptxt = "", bgFlag = "A" },
			note4  = { text = FACTION_HORDE.." Flag Carrier", color = OM_RED, coords = { {65,89} }, symbol = { "FC" },
					tooltiptxt = "", bgFlag = "H", leaveGap = 2 },
		},

		--Mists
		{ 	name = "Silvershard Mine", 
			mapNumber = 860,
			type = OM_TYP_BG,
			continent = "" ,
			location = "STVDiamondMineBG",
			zoneName = "",  --
			subZones = "",
			displayname = "",
			displayshort = "SSM",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\SilverShard",
			mapEdge = 1,
			wmData = { minX = 0.15, maxX = 0.78, minY =  0.10, maxY = 0.90 },
			omData = { minX = 0.01, maxX = 0.90, minY = 0.11, maxY = 0.86 },
			note1  = { text = FACTION_ALLIANCE.." Flag Room", color = OM_BLUE, coords = { {68,29} }, symbol = { "F" },
					tooltiptxt = "Alliance players start here",bgFlag = "A" },
			note2  = { text = FACTION_HORDE.." Flag Room", color = OM_RED, coords = { {54,63} }, symbol = { "F" },
					tooltiptxt = "Horde players start here", bgFlag = "H" },
			note3  = { text = " Cart Elevator", color = OM_BLUE, coords = { {59,45} }, symbol = { "E" },
					tooltiptxt = "", bgFlag = "A" },
	},
		{ 	name = "Temple of Kotmogu",  --Not Fully Tested
			mapNumber = 856,
			type = OM_TYP_BG,
			continent = "" ,
			location = "ValleyOfPowerScenario",
			zoneName = "",  --
			subZones = "",
			displayname = "",
			displayshort = "ToK",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\TempofKotMogu",
			mapEdge = 1,
			wmData = { minX = 0.15, maxX = 0.81, minY =  0.22, maxY = 0.85 }, 
			omData = { minX = 0.02, maxX = 0.96, minY = 0.22, maxY = 0.80 }, 
		},

		
		{ 	name = "Deepwind Gorge", 
			mapNumber = 935,
			type = OM_TYP_BG,
			continent = "" ,
			location = "", --"Deepwind Gorge",
			zoneName = "",  
			subZones = "",
			displayname = "",
			displayshort = "DG",
			filename = "Interface\\AddOns\\OmegaMap\\AltMaps\\BGMaps\\GoldRush",
			mapEdge = 1,
			wmData = { minX = 0.16, maxX = 0.86, minY =  0.09, maxY = 0.90 },
			omData = { minX = 0.06, maxX = 0.96, minY = 0.15, maxY = 0.85 },
		},
};
