--	///////////////////////////////////////////////////////////////////////////////////////////

-- Code for Gatherer Integration within OmegaMap
-- Code is a modified version of GatherMapNotes.lua from Gatherer (v3.2.4)
-- Gatherer is written and maintained by the folks @ http://www.gathereraddon.com/

--	///////////////////////////////////////////////////////////////////////////////////////////


if IsAddOnLoaded("Gatherer") then

--Creating a Frame to display Gatherer nodes in Omega Map
if not GathererOmegaMapOverlay then
	local overlay = CreateFrame("Frame", "GathererOmegaMapOverlay", OmegaMapNoteFrame)
	overlay:SetAllPoints(true)
end


local Astrolabe = DongleStub(Gatherer.AstrolabeVersion)
local _tr = Gatherer.Locale.Tr
local _trC = Gatherer.Locale.TrClient
local _trL= Gatherer.Locale.TrLocale
local UpdateWorldMap = -1


function OmegaMap_DrawGathererPOI()
	local setting = Gatherer.Config.GetSetting
	local maxNotes = setting("mainmap.count", 600)
	local noteCount = 0

	local h, w = GathererOmegaMapOverlay:GetHeight(), GathererOmegaMapOverlay:GetWidth();

	--prevent the function from running twice at the same time.
	if (UpdateWorldMap == 0 ) then return; end
	UpdateWorldMap = 0
	
	local showType, showObject
	local mapContinent = GetCurrentMapContinent()
	local mapZone = GetCurrentMapZone()
	local mapID, mapFloor = Gatherer.ZoneTokens.GetZoneMapIDAndFloor(Gatherer.ZoneTokens.GetZoneToken(mapContinent, mapZone))
	
	if ( Gatherer.Storage.HasDataOnZone(mapContinent, mapZone) ) then
		for _, gatherType in pairs(Gatherer.Constants.SupportedGatherTypes) do
			for index, xPos, yPos in Gatherer.Storage.ZoneGatherNodes(mapContinent, mapZone, gatherType) do
				local displayNode = false
				for _, gatherID, count in Gatherer.Storage.GetNodeGatherNames(mapContinent, mapZone, gatherType, index) do
					if ( Gatherer.Config.DisplayFilter_MainMap(gatherID) ) then
						displayNode = true
						break
					end
				end
				if ( displayNode ) then
					if ( noteCount < maxNotes ) then
						noteCount = noteCount + 1
		local mainNote = OmegaMap_CreateGathererPOI(noteCount)

						xPos = xPos * w;
						yPos = yPos * h;
						mainNote:ClearAllPoints();
						mainNote:SetPoint("CENTER", "GathererOmegaMapOverlay", "TOPLEFT", xPos, -yPos);
						
						mainNote:SetAlpha(setting("mainmap.opacity", 80) / 100)
						
						local texture = Gatherer.Util.GetNodeTexture(mapContinent, mapZone, gatherType, index)
						_G["OmegaMapGathererPOI"..noteCount.."Texture"]:SetTexture(texture)
						
						local iconsize = setting("mainmap.iconsize", 16)
						mainNote:SetWidth(iconsize)
						mainNote:SetHeight(iconsize)
						
						mainNote.continent = mapContinent
						mainNote.zone = mapZone
						mainNote.index = index
						mainNote.gType = gatherType
						mainNote:Show();

					else -- reached note limit
						break
					end
				end
			end
		end
	end
	noteCount = noteCount + 1;
	mainNote = _G["OmegaMapGathererPOI"..noteCount];
	while ( mainNote ) do
		mainNote:Hide();
		noteCount = noteCount + 1;
		mainNote = _G["OmegaMapGathererPOI"..noteCount];
	end
	UpdateWorldMap = -1
end


function OmegaMap_CreateGathererPOI( noteNumber )
	local button = _G["OmegaMapGathererPOI"..noteNumber]
	if not ( button ) then
		button = CreateFrame("Button" ,"OmegaMapGathererPOI"..noteNumber, GathererOmegaMapOverlay, "GatherMainTemplate")
		button:SetID(noteNumber)
		button:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL);
		button:SetScript("OnEnter", OmegaMap_GathererOnEnter)

	end
	return button
end

function OmegaMap_GathererOnEnter(frame)
	local setting = Gatherer.Config.GetSetting
	
	local enabled = setting("mainmap.tooltip.enable")
	if (not enabled) then 
		return
	end
	
	local showcount = setting("mainmap.tooltip.count")
	local showsource = setting("mainmap.tooltip.source")
	local showseen = setting("mainmap.tooltip.seen")
	local showrate = setting("mainmap.tooltip.rate")
	
	local cont = frame.continent
	local zone = frame.zone
	local index = frame.index
	local gType = frame.gType
	local inspected = Gatherer.Storage.GetNodeInspected(cont, zone, gType, index)
	
	local numTooltips = 0
	for id, gatherID, count, harvested, who in Gatherer.Storage.GetNodeGatherNames(cont, zone, gType, index) do
		local tooltip = Gatherer.Tooltip.GetTooltip(id)
		tooltip:ClearLines()
		tooltip:SetParent(OmegaMapFrame)
		tooltip:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL + 5)
		if ( id == 1 ) then
			tooltip:SetOwner(frame, "ANCHOR_BOTTOMLEFT")
		else
			tooltip:SetOwner(frame, "ANCHOR_PRESERVE")
			tooltip:SetPoint("TOPLEFT", Gatherer.Tooltip.GetTooltip(id - 1),"BOTTOMLEFT")
		end
		
		local name = Gatherer.Util.GetNodeName(gatherID)
		local last = inspected or harvested
		
		tooltip:AddLine(name)
		if (count > 0 and showcount) then
			tooltip:AddLine(_tr("NOTE_COUNT", count))
		end
		if (who and showsource) then
			if (who == "REQUIRE") then
				tooltip:AddLine(_tr("NOTE_UNSKILLED"))
			elseif (who == "IMPORTED") then
				tooltip:AddLine(_tr("NOTE_IMPORTED"))
			else
				tooltip:AddLine(_tr("NOTE_SOURCE", who:gsub(",", ", ")))
			end
		end
		if (last and last > 0 and showseen) then
			tooltip:AddLine(_tr("NOTE_LASTVISITED", Gatherer.Util.SecondsToTime(time()-last)))
		end
		
		if ( showrate ) then
			local num = Gatherer.Config.GetSetting("mainmap.tooltip.rate.num")
			Gatherer.Tooltip.AddDropRates(tooltip, gatherID, frame.continent, frame.zone, num)
		end
		tooltip:Show()
		numTooltips = id
	end
	Gatherer.Tooltip.SetClamps(numTooltips)
end

end