--	///////////////////////////////////////////////////////////////////////////////////////////
--
--	OmegaMap	v1.0
--	Author: Gathirer

--	OmegaMap: A worldmap frame that is transparent and allows character manipulation
--
--	Contributions: Part of the code for this is adapted from the WorldMapFrame.lua(v4.3)
--		of the original Blizzard(tm) Entertainment distribution.  OmegaMap is bassed off of the AlphaMap addon
--		which I used from Vanilla WOW untill it stoped being maintined/updated during Cataclysm.
--
--	3rd Party Components: Part of the code is taken from MapNotes, Gatherer, Gathermate2, CTMapMod, TomTom, Routes, \
--		_NPCScan.Overlay.  This is done to provide optional support for those addons.
--
--	Special Thanks: Special thanks to Jeremy Walsh, Telic, Alchemys Indomane,  Kesitah, AnonDev, dalewake and all others
--		who maintained AlphaMap over the years.  Without their efforts there would have been no inspiration for OmegaMap
--
--	License: You are hereby authorized to freely modify and/or distribute all files of this add-on, in whole or in part,
--		providing that this header stays intact, and that you do not claim ownership of this Add-on.
--
--		Additionally, the original owner wishes to be notified by email if you make any improvements to this add-on.
--		Any positive alterations will be added to a future release, and any contributing authors will be
--		identified in the section above.
--
--	SEE CHANGELOG.TXT FOR LATEST PATCH NOTES
--
--	///////////////////////////////////////////////////////////////////////////////////////////


--OmegaMap = LibStub("AceAddon-3.0"):NewAddon("OmegaMap","AceConsole-3.0","AceEvent-3.0")
LoadAddOn("Blizzard_EncounterJournal") --preloads Blizzard's Encounter Journal so it can be opened from Omega Map without errors

--Colors
OM_RED	= "|c00FF1010";
OM_GREEN	= "|c0000FF00";
OM_BLUE	= "|c005070FF";
OM_GOLD	= "|c00FFD200";
OM_PURPLE	= "|c00FF35A3";
OM_ORANGE	= "|c00FF7945";
OM_YELLOW	= "|c00FFFF00";
OM_CYAN	= "|cff008888";

NUM_OMEGAMAP_POIS = 0;
NUM_OMEGAMAP_GRAVEYARDS = 0;
NUM_OMEGAMAP_POI_COLUMNS = 14;
OMEGAMAP_POI_TEXTURE_WIDTH = 256;
NUM_OMEGAMAP_OVERLAYS = 0;
NUM_OMEGAMAP_FLAGS = 2;
QUESTFRAME_MINHEIGHT = 34;
QUESTFRAME_PADDING = 19;			-- needs to be one the highest frames in the MEDIUM strata
OMEGAMAP_FULLMAP_SIZE = 1.0;
OMEGAMAP_POI_FRAMELEVEL = 100;	-- needs to be one the highest frames in the MEDIUM strata

OMEGAMAP_ALTMAP = false

local OMEGAMAP_DEFAULT_SCALE = 1.0;
local OMEGAMAP_POI_MIN_X = 12;
local OMEGAMAP_POI_MIN_Y = -12;
local OMEGAMAP_POI_MAX_X;		-- changes based on current scale, see OmegaMapFrame_SetPOIMaxBounds
local OMEGAMAP_POI_MAX_Y;		-- changes based on current scale, see OmegaMapFrame_SetPOIMaxBounds
local EJ_QUEST_POI_MINDIS_SQR = 2500;


local Update_Timer_P = 0;
local Main_Update_Timer = 0;
local incombat = false
--local playercombatclose = false

OmegaMapPins = {}
BAD_BOY_UNITS = {};
BAD_BOY_COUNT = 0;

 OMEGAMAP_SETTINGS = {
	size = OMEGAMAP_FULLMAP_SIZE
};
OmegaMapConfig = {
	opacity = 0,
	scale = OMEGAMAP_DEFAULT_SCALE,
	showQuest = false,  --Show Quest Objectives
	showArch = false,	--Show Arch dig sites
	showBoss = false,	--Show EJ Boss Icons
	showObjectives = false,	--Hide quest objectives
	showGatherer = false,	--Show gathering POI
	showTomTom = false,		--Show Tomtom poi
	showRoutes = false,		--Show Routes
	showCTMap = false,		--Show CT Map
	showMapNotes = false,	--Show MapNotes
	showGatherMate = false,	--Show Gathermate POI
	showNPCScanOverlay = false,  --Show NPCScan.Overlay 
	showCoords = true,		--Show Coords on map
	coordsLocX = 60,
	coordsLocY= 60,
	showAlpha = true,		--Show transparency slider
	alphaLocX = 60,
	alphaLocY = 175,
	clearMap = false,		--Hide all optional POI
	solidify = false,		--Make map able to be clicked
	showExteriors = true,	--Show dungeon exteriros when available
	showBattlegrounds = true,	--Show alt battleground maps when available
	showAltMapNotes = true,		--Show notes on Exteriors & alt battlegrounds
	interactiveHotKey = "None",	--Hotkey for making the map interactive
	keepInteractive = false, -- Keeps map interactive between viewings
};


local OmegaMapConfigDefaults = OmegaMapConfig
function omegareset()
	OmegaMapConfig = OmegaMapConfigDefaults
end

local EJ_QUEST_POI_MINDIS_SQR = 2500;

function OmegaMapFrame_OnLoad(self)
	self:RegisterEvent("PLAYER_ENTERING_WORLD");
	self:RegisterEvent("WORLD_MAP_UPDATE");
	self:RegisterEvent("CLOSE_WORLD_MAP");
	self:RegisterEvent("WORLD_MAP_NAME_UPDATE");
	self:RegisterEvent("VARIABLES_LOADED");
	self:RegisterEvent("PARTY_MEMBERS_CHANGED");
	self:RegisterEvent("RAID_ROSTER_UPDATE");
	self:RegisterEvent("DISPLAY_SIZE_CHANGED");
	self:RegisterEvent("QUEST_LOG_UPDATE");
	self:RegisterEvent("QUEST_POI_UPDATE");
	self:RegisterEvent("SKILL_LINES_CHANGED");
	self:RegisterEvent("REQUEST_CEMETERY_LIST_RESPONSE");
	self:RegisterEvent("UNIT_PORTRAIT_UPDATE");
	-- added events
	self:RegisterEvent("MODIFIER_STATE_CHANGED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")

	self:SetClampRectInsets(0, 0, 0, -60);				-- don't overlap the xp/rep bars
	self.poiHighlight = nil;
	self.areaName = nil;
	--CreateWorldMapArrowFrame(OmegaMapFrame);
	--WorldMapFrameTexture18:SetVertexColor(0, 0, 0);		-- this texture just needs to be a black line
	InitWorldMapPing(OmegaMapFrame);
	OmegaMapFrame_Update();

	-- setup the zone minimap button
	OmegaMapLevelDropDown_Update();

	-- PlayerArrowEffectFrame is created in code: COmegaMap::CreateArrowFrame()
	--PlayerArrowEffectFrame:SetAlpha(0.65);

	-- font stuff for objectives text
	local refFrame = OmegaMapFrame_GetQuestFrame(0);
	local _, fontHeight = refFrame.objectives:GetFont();
	refFrame.lineSpacing = refFrame.objectives:GetSpacing();
	refFrame.lineHeight = fontHeight + refFrame.lineSpacing;
	
	OmegaMapFrame_ResetFrameLevels();
	OmegaMapDetailFrame:SetScale(OMEGAMAP_FULLMAP_SIZE);

	OmegaMapButton:SetScale(OMEGAMAP_FULLMAP_SIZE);
	OmegaMapFrame_SetPOIMaxBounds();
	OmegaMapQuestDetailScrollChildFrame:SetScale(0.9);
	OmegaMapQuestRewardScrollChildFrame:SetScale(0.9);
	OmegaMapFrame.numQuests = 0;
	WatchFrame.showObjectives = WorldMapQuestShowObjectives:GetChecked();
	OmegaMapPOIFrame.allowBlobTooltip = true;
	-- scrollframes
	OmegaMapQuestDetailScrollFrame.scrollBarHideable = true;
	OmegaMapQuestRewardScrollFrame.scrollBarHideable = true;
	ScrollBar_AdjustAnchors(OmegaMapQuestDetailScrollFrameScrollBar, 1, -2);
	OmegaMapQuestDetailScrollFrameScrollBarTrack:SetAlpha(0.4);
	ScrollBar_AdjustAnchors(OmegaMapQuestRewardScrollFrameScrollBar, 1, -2);
	OmegaMapQuestRewardScrollFrameScrollBarTrack:SetAlpha(0.4);

	OmegaMapButton:EnableMouse(false); --set to false to enable click trhough

	--Register to close on ESC	
	tinsert(UISpecialFrames, self:GetName());
end

function OmegaMapFrame_OnShow(self)
	SetupFullscreenScale(self);
	OmegaMap_LoadTextures();
		--if ( not WatchFrame.showObjectives and WORLDMAP_SETTINGS.size ~= WORLDMAP_FULLMAP_SIZE ) then
		OmegaMapFrame_SetFullMapView();
		--end		
		
	UpdateMicroButtons();
	SetMapToCurrentZone();
	PlaySound("igQuestLogOpen");
	CloseDropDownMenus();
	OmegaMapFrame_PingPlayerPosition();	
	OmegaMapFrame_UpdateUnits("OmegaMapRaid", "OmegaMapParty");
	DoEmote("READ", nil, true);
	OmegaMapFrame_Update();

	if (OmegaMapConfig.clearMap) then
		OmegaMapNoteFrame:Hide()
	end
end

function OmegaMapFrame_OnHide(self)
	if ( OpacityFrame:IsShown() and OpacityFrame.saveOpacityFunc and OpacityFrame.saveOpacityFunc == OmegaMapFrame_SaveOpacity ) then
		OmegaMapFrame_SaveOpacity();
		OpacityFrame.saveOpacityFunc = nil;
		OpacityFrame:Hide();
	end
	
	UpdateMicroButtons();
	CloseDropDownMenus();
	PlaySound("igQuestLogClose");
	OmegaMap_ClearTextures();
	if ( self.showOnHide ) then
		ShowUIPanel(self.showOnHide);
		self.showOnHide = nil;
	end

	--Hide Options window if shown
	if (OmegaMapOptionsFrame.Frame:IsShown()) then
		OmegaMapOptionsFrame.Frame:Hide()
	end 
	OmegaMapConfig.showObjectives = false

	--Clears Blobs from map
	OmegaMapFrame:Hide()
	OmegaMapBlobFrame:DrawBlob(WORLDMAP_SETTINGS.selectedQuestId, false);
	OmegaMapArchaeologyDigSites:DrawNone();
	local numEntries = ArchaeologyMapUpdateAll();
	for i = 1, numEntries do
		local blobID = ArcheologyGetVisibleBlobID(i);
		OmegaMapArchaeologyDigSites:DrawBlob(blobID, false);
	end
	OmegaMapSolidify("Off")

	-- forces WatchFrame event via the WORLD_MAP_UPDATE event, needed to restore the POIs in the tracker to the current zone
	SetMapToCurrentZone();
	CancelEmote();
end

function OmegaMapFrame_OnEvent(self, event, ...)
	if ( event == "PLAYER_ENTERING_WORLD" ) then
		if ( self:IsShown() ) then
			HideUIPanel(OmegaMapFrame);
		end
	elseif ( event == "WORLD_MAP_UPDATE" or event == "REQUEST_CEMETERY_LIST_RESPONSE" ) then
		if ( not self.blockOmegaMapUpdate and self:IsShown() ) then
			OmegaMapFrame_UpdateMap();
		end
	elseif ( event == "CLOSE_WORLD_MAP" ) then
		HideUIPanel(self);
	elseif ( event == "VARIABLES_LOADED" ) then
		--OmegaMapZoneMinimapDropDown_Update();
		--WORLDMAP_SETTINGS.locked = GetCVarBool("lockedOmegaMap");
		--WORLDMAP_SETTINGS.opacity = (tonumber(GetCVar("worldMapOpacity")));
		--OmegaMapQuestShowObjectives:SetChecked(GetCVarBool("questPOI"));

		OmegaMapSliderFrame:SetValue(OmegaMapConfig.opacity);
		OmegaMapQuestShowObjectives_Toggle();
		OmegaMapMasterFrame:SetScale(OmegaMapConfig.scale);
		OmegaMapOptionsFrame_init();

	elseif ( event == "PARTY_MEMBERS_CHANGED" or event == "RAID_ROSTER_UPDATE" ) then
		if ( self:IsShown() ) then
			OmegaMapFrame_UpdateUnits("OmegaMapRaid", "OmegaMapParty");
		end
	elseif ( ( event == "QUEST_LOG_UPDATE" or event == "QUEST_POI_UPDATE" ) and self:IsShown() ) then
		OmegaMapFrame_DisplayQuests();
		OmegaMapQuestFrame_UpdateMouseOver();
	elseif  ( event == "SKILL_LINES_CHANGED" ) then
		local _, _, arch = GetProfessions();
		if arch then
			OmegaMapTrackDigsButton:Show();
			local showDig = GetCVarBool("digSites");
			--OmegaMapShowDigSites:SetChecked(showDig);
			if showDig and not InCombatLockdown() then
				OmegaMapArchaeologyDigSites:Show();
			else
				OmegaMapArchaeologyDigSites:Hide();
			end
		else
			OmegaMapTrackDigsButton:Hide();
		end
	elseif ( event == "UNIT_PORTRAIT_UPDATE" ) then
		OmegaMapJournal_UpdateMapButtonPortraits();
	elseif ( event == "MODIFIER_STATE_CHANGED" ) then
OmegaMapSolidifyCheck(self,...)
		
	end
end

function OmegaMapFrame_OnUpdate(self)
	RequestBattlefieldPositions();

	local nextBattleTime = GetOutdoorPVPWaitTime();
	if ( nextBattleTime and not IsInInstance()) then
		local battleSec = mod(nextBattleTime, 60);
		local battleMin = mod(floor(nextBattleTime / 60), 60);
		local battleHour = floor(nextBattleTime / 3600);
		OmegaMapZoneInfo:SetFormattedText(NEXT_BATTLE, battleHour, battleMin, battleSec);
		OmegaMapZoneInfo:Show();
	else
		OmegaMapZoneInfo:Hide();
	end
end

function OmegaMapFrame_OnKeyDown(self, key)
end

function OmegaMapFrame_Update()
	local mapFileName, textureHeight = GetMapInfo();
	local activeFrame = OmegaMapButton
	
	if ( not mapFileName ) then
		if ( GetCurrentMapContinent() == WORLDMAP_COSMIC_ID ) then
			mapFileName = "Cosmic";
			OmegaMapOutlandButton:Show();
			OmegaMapAzerothButton:Show();
		else
			-- Temporary Hack (Temporary meaning 6 yrs, haha)
			mapFileName = "World";
			OmegaMapOutlandButton:Hide();
			OmegaMapAzerothButton:Hide();
		end
		OmegaMapDeepholmButton:Hide();
		OmegaMapKezanButton:Hide();
		OmegaMapLostIslesButton:Hide();
		OmegaMapTheMaelstromButton:Hide();
	else
		OmegaMapOutlandButton:Hide();
		OmegaMapAzerothButton:Hide();
		if ( GetCurrentMapContinent() == WORLDMAP_MAELSTROM_ID and GetCurrentMapZone() == 0 ) then
			OmegaMapDeepholmButton:Show();
			OmegaMapKezanButton:Show();
			OmegaMapLostIslesButton:Show();
			OmegaMapTheMaelstromButton:Show();
		else
			OmegaMapDeepholmButton:Hide();
			OmegaMapKezanButton:Hide();
			OmegaMapLostIslesButton:Hide();
			OmegaMapTheMaelstromButton:Hide();
		end
	end

	local texName;
	local dungeonLevel = GetCurrentMapDungeonLevel();
	if (DungeonUsesTerrainMap()) then
		dungeonLevel = dungeonLevel - 1;
	end
	local completeMapFileName;
	if ( dungeonLevel > 0 ) then
		completeMapFileName = mapFileName..dungeonLevel.."_";
	else
		completeMapFileName = mapFileName;
	end
	local numOfDetailTiles = GetNumberOfDetailTiles();
	for i=1, numOfDetailTiles do

		texName = "Interface\\WorldMap\\"..mapFileName.."\\"..completeMapFileName..i;
		_G["OmegaMapDetailTile"..i]:SetTexture(texName);
	end		
	--OmegaMapHighlight:Hide();

	-- Enable/Disable zoom out button
	if ( IsZoomOutAvailable() ) then
		OmegaMapZoomOutButton:Enable();
	else
		OmegaMapZoomOutButton:Disable();
	end

	-- Setup the POI's
	local numPOIs = GetNumMapLandmarks();
	if ( NUM_OMEGAMAP_POIS < numPOIs ) then
		for i=NUM_OMEGAMAP_POIS+1, numPOIs do
			OmegaMap_CreatePOI(i);
		end
		NUM_OMEGAMAP_POIS = numPOIs;
	end
	local numGraveyards = 0;
	local currentGraveyard = GetCemeteryPreference();
	for i=1, NUM_OMEGAMAP_POIS do
		local omegaMapPOIName = "OmegaMapFramePOI"..i;
		local omegaMapPOI = _G[omegaMapPOIName];
		if ( i <= numPOIs ) then
			local name, description, textureIndex, x, y, mapLinkID, inBattleMap, graveyardID, areaID = GetMapLandmarkInfo(i);
			if( (GetCurrentMapAreaID() ~= WORLDMAP_WINTERGRASP_ID) and (areaID == WORLDMAP_WINTERGRASP_POI_AREAID) ) then
				omegaMapPOI:Hide();
			else
				local x1, x2, y1, y2 = OmegaMap_GetPOITextureCoords(textureIndex);
				_G[omegaMapPOIName.."Texture"]:SetTexCoord(x1, x2, y1, y2);
--alt map code

	if (OMEGAMAP_ALTMAP) then
		activeFrame = OmegaMapAltMapFrame
	else
		activeFrame = OmegaMapButton
	end
	x, y = OmegaMapOffsetAltMapCoords(x,y)
				x = x * activeFrame:GetWidth();
				y = -y * activeFrame:GetHeight();
			--	omegaMapPOI:SetPoint("CENTER", "OmegaMapButton", "TOPLEFT", x, y );
				omegaMapPOI:SetPoint("CENTER", activeFrame, "TOPLEFT", x, y );
				omegaMapPOI.name = name;
				omegaMapPOI.description = description;
				omegaMapPOI.mapLinkID = mapLinkID;
				if ( graveyardID and graveyardID > 0 ) then
					omegaMapPOI.graveyard = graveyardID;
					numGraveyards = numGraveyards + 1;
					local graveyard = OmegaMap_GetGraveyardButton(numGraveyards);
					graveyard:SetPoint("CENTER", omegaMapPOI);
					graveyard:SetFrameLevel(omegaMapPOI:GetFrameLevel() - 1);
					graveyard:Show();
					if ( currentGraveyard == graveyardID ) then
						graveyard.texture:SetTexture("Interface\\WorldMap\\GravePicker-Selected");
					else
						graveyard.texture:SetTexture("Interface\\WorldMap\\GravePicker-Unselected");
					end
					omegaMapPOI:Hide();		-- lame way to force tooltip redraw
				else
					omegaMapPOI.graveyard = nil;
				end
				omegaMapPOI:Show();	
			end
		else
			omegaMapPOI:Hide();
		end
	end

	if ( numGraveyards > NUM_OMEGAMAP_GRAVEYARDS ) then
		NUM_OMEGAMAP_GRAVEYARDS = numGraveyards;
	else
		for i = numGraveyards + 1, NUM_OMEGAMAP_GRAVEYARDS do
			_G["OmegaMapFrameGraveyard"..i]:Hide();
		end
	end
	
	-- Setup the overlays
	local textureCount = 0;
	for i=1, GetNumMapOverlays() do
		local textureName, textureWidth, textureHeight, offsetX, offsetY = GetMapOverlayInfo(i);
		if ( textureName and textureName ~= "" ) then
			local numTexturesWide = ceil(textureWidth/256);
			local numTexturesTall = ceil(textureHeight/256);
			local neededTextures = textureCount + (numTexturesWide * numTexturesTall);
			if ( neededTextures > NUM_OMEGAMAP_OVERLAYS ) then
				for j=NUM_OMEGAMAP_OVERLAYS+1, neededTextures do
					OmegaMapDetailFrame:CreateTexture("OmegaMapOverlay"..j, "ARTWORK");
				end
				NUM_OMEGAMAP_OVERLAYS = neededTextures;
			end
			local texturePixelWidth, textureFileWidth, texturePixelHeight, textureFileHeight;
			for j=1, numTexturesTall do
				if ( j < numTexturesTall ) then
					texturePixelHeight = 256;
					textureFileHeight = 256;
				else
					texturePixelHeight = mod(textureHeight, 256);
					if ( texturePixelHeight == 0 ) then
						texturePixelHeight = 256;
					end
					textureFileHeight = 16;
					while(textureFileHeight < texturePixelHeight) do
						textureFileHeight = textureFileHeight * 2;
					end
				end
				for k=1, numTexturesWide do
					textureCount = textureCount + 1;
					local texture = _G["OmegaMapOverlay"..textureCount];
					if ( k < numTexturesWide ) then
						texturePixelWidth = 256;
						textureFileWidth = 256;
					else
						texturePixelWidth = mod(textureWidth, 256);
						if ( texturePixelWidth == 0 ) then
							texturePixelWidth = 256;
						end
						textureFileWidth = 16;
						while(textureFileWidth < texturePixelWidth) do
							textureFileWidth = textureFileWidth * 2;
						end
					end
					texture:SetWidth(texturePixelWidth);
					texture:SetHeight(texturePixelHeight);
					texture:SetTexCoord(0, texturePixelWidth/textureFileWidth, 0, texturePixelHeight/textureFileHeight);
					texture:SetPoint("TOPLEFT", offsetX + (256 * (k-1)), -(offsetY + (256 * (j - 1))));
					texture:SetTexture(textureName..(((j - 1) * numTexturesWide) + k));
					texture:Show();
				end
			end
		end
	end
	for i=textureCount+1, NUM_OMEGAMAP_OVERLAYS do
		_G["OmegaMapOverlay"..i]:Hide();
	end
	
	OmegaMapJournal_AddMapButtons();

-- sets up Gatherer POI
	if (GathererOmegaMapOverlay) then
		if (OmegaMapConfig.showGatherer) then
			GathererOmegaMapOverlay:Show()
			OmegaMap_DrawGathererPOI();
		elseif ( OmegaMapGathererPOI1 ) then
			OmegaMapGathererPOI1:Hide();
			local i = 2;
			local GathererPOI = _G[ "OmegaMapGathererPOI"..i ];
			while ( GathererPOI ) do
				GathererPOI:Hide();
				i = i + 1;
				GathererPOI = _G[ "OmegaMapGathererPOI"..i ];
			end
			GathererOmegaMapOverlay:Hide()

		end
	end
--CTMapmod POI
	if (CTMapOmegaMapOverlay) then
		if (OmegaMapConfig.showCTMap) then
			--CT_MapMod_UpdateMap();
			CTMapOmegaMapOverlay:Show()
		else
			CTMapOmegaMapOverlay:Hide()
		end
	end
--TomTom POI
	if  (TomTomOmegaMapOverlay) then
		if ((OmegaMapConfig.showTomTom) and (TomTom.profile)) then
			TomTomOmegaMapOverlay:Show()
			OmegaMap_DrawTomToms();	
		else
			TomTomOmegaMapOverlay:Hide()
		end
	end
--Routes POI
	if (RoutesOmegaMapOverlay) then
		if (OmegaMapConfig.showRoutes) then
			RoutesOmegaMapOverlay:Show()
			OmegaMapDrawWorldmapLines();
		else
			RoutesOmegaMapOverlay:Hide()
		end
	end
--Gathermate POI
	if (GatherMateOmegaMapOverlay) then
		if (OmegaMapConfig.showGatherMate) then
			GatherMateOmegaMapOverlay:Show() 
		else
			GatherMateOmegaMapOverlay:Hide()
		end
	end
--MapNotes
	if  (MapNotesOmegaMapOverlay) then
		if (OmegaMapConfig.showMapNotes) then
			MapNotesOmegaMapOverlay:Show()
		else
			MapNotesOmegaMapOverlay:Hide()
		end
	end
--NPCScan.Overlay\
	if  (NPCScanOmegaMapOverlay) then
		if (OmegaMapConfig.showNPCScanOverlay) then
			NPCScanOmegaMapOverlay:Show()
		else
			NPCScanOmegaMapOverlay:Hide()
		end
	end

--Shows Alternate map if avaliable
	if OmegaMapConfig.showExteriors then
		OmegaMap_LoadAltMapNotes()
	else 
		OmegaMap_HideAltMap()
	end

-- Hides map blobs if an alt map is displayed
	if  not InCombatLockdown() then
		if OMEGAMAP_ALTMAP then
			OmegaMapSpecialFrame:Hide()
		else
			OmegaMapSpecialFrame:Show()
		end
	end
end

function OmegaMapFrame_UpdateUnits(raidUnitPrefix, partyUnitPrefix)
	for i=1, MAX_RAID_MEMBERS do
		local partyMemberFrame = _G["OmegaMapRaid"..i];
		if ( partyMemberFrame:IsShown() ) then
			OmegaMapUnit_Update(partyMemberFrame);
		end
	end
	for i=1, MAX_PARTY_MEMBERS do
		local partyMemberFrame = _G["OmegaMapParty"..i];
		if ( partyMemberFrame:IsShown() ) then
			OmegaMapUnit_Update(partyMemberFrame);
		end
	end
end

function OmegaMapPOI_OnEnter(self)
	OmegaMapFrame.poiHighlight = 1;
	if ( self.description and strlen(self.description) > 0 ) then
		OmegaMapFrameAreaLabel:SetText(self.name);
		OmegaMapFrameAreaDescription:SetText(self.description);
	else
		OmegaMapFrameAreaLabel:SetText(self.name);
		OmegaMapFrameAreaDescription:SetText("");
		-- need localization
		if ( self.graveyard ) then
			OmegaMapTooltip:SetOwner(self, "ANCHOR_RIGHT");
			if ( self.graveyard == GetCemeteryPreference() ) then
				OmegaMapTooltip:SetText(GRAVEYARD_SELECTED);
				OmegaMapTooltip:AddLine(GRAVEYARD_SELECTED_TOOLTIP, 1, 1, 1, 1);
				OmegaMapTooltip:Show();
			else
				OmegaMapTooltip:SetText(GRAVEYARD_ELIGIBLE);
				OmegaMapTooltip:AddLine(GRAVEYARD_ELIGIBLE_TOOLTIP, 1, 1, 1, 1);
				OmegaMapTooltip:Show();
			end			
		end
	end
end

function OmegaMapPOI_OnLeave()
	OmegaMapFrame.poiHighlight = nil;
	OmegaMapFrameAreaLabel:SetText(OmegaMapFrame.areaName);
	OmegaMapFrameAreaDescription:SetText("");
	OmegaMapTooltip:Hide();
end

function OmegaMapPOI_OnClick(self, button)
	if ( self.mapLinkID ) then
		ClickLandmark(self.mapLinkID);
	elseif ( self.graveyard ) then
		SetCemeteryPreference(self.graveyard);
		OmegaMapFrame_Update();
	else
		if OmegaMapConfig.solidify then
			OmegaMapButton_OnClick(OmegaMapButton, button);
		else
			return
		end
	end
end

function OmegaMap_CreatePOI(index)
	local button = CreateFrame("Button", "OmegaMapFramePOI"..index, OmegaMapButton);
	button:SetWidth(32);
	button:SetHeight(32);
	button:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	button:SetScript("OnEnter", OmegaMapPOI_OnEnter);
	button:SetScript("OnLeave", OmegaMapPOI_OnLeave);
	button:SetScript("OnClick", OmegaMapPOI_OnClick);

	local texture = button:CreateTexture(button:GetName().."Texture", "BACKGROUND");
	texture:SetWidth(16);
	texture:SetHeight(16);
	texture:SetPoint("CENTER", 0, 0);
	texture:SetTexture("Interface\\Minimap\\POIIcons");
end

function OmegaMap_GetGraveyardButton(index)
	-- everything here is temp
	local frameName = "OmegaMapFrameGraveyard"..index;
	local button = _G[frameName];
	if ( not button ) then
		button = CreateFrame("Button", frameName, OmegaMapButton);
		button:SetWidth(32);
		button:SetHeight(32);
		button:RegisterForClicks("LeftButtonUp", "RightButtonUp");
		button:SetScript("OnEnter", nil);
		button:SetScript("OnLeave", nil);
		button:SetScript("OnClick", nil);
		
		local texture = button:CreateTexture(button:GetName().."Texture", "ARTWORK");
		texture:SetWidth(24);
		texture:SetHeight(24);
		texture:SetPoint("CENTER", 0, 0);
		button.texture = texture;
	end
	return button;
end

function OmegaMap_GetPOITextureCoords(index)
	local worldMapPixelsPerIcon = 18;
	local worldMapIconDimension = 16;
	
	local offsetPixelsPerSide = (worldMapPixelsPerIcon - worldMapIconDimension)/2;
	local normalizedOffsetPerSide = offsetPixelsPerSide * 1/OMEGAMAP_POI_TEXTURE_WIDTH;
	local xCoord1, xCoord2, yCoord1, yCoord2; 
	local coordIncrement = worldMapPixelsPerIcon / OMEGAMAP_POI_TEXTURE_WIDTH;
	local xOffset = mod(index, NUM_OMEGAMAP_POI_COLUMNS);
	local yOffset = floor(index / NUM_OMEGAMAP_POI_COLUMNS);
	
	xCoord1 = xOffset * coordIncrement + normalizedOffsetPerSide;
	xCoord2 = xCoord1 + coordIncrement - normalizedOffsetPerSide;
	yCoord1 = yOffset * coordIncrement + normalizedOffsetPerSide;
	yCoord2 = yCoord1 + coordIncrement - normalizedOffsetPerSide;
	
	return xCoord1, xCoord2, yCoord1, yCoord2;
end

function OmegaMapContinentsDropDown_Update()
	UIDropDownMenu_Initialize(OmegaMapContinentDropDown, OmegaMapContinentsDropDown_Initialize);
	UIDropDownMenu_SetWidth(OmegaMapContinentDropDown, 130);

	if ( (GetCurrentMapContinent() == WORLDMAP_WORLD_ID) or (GetCurrentMapContinent() == WORLDMAP_COSMIC_ID) ) then
		UIDropDownMenu_ClearAll(OmegaMapContinentDropDown);
	else
		UIDropDownMenu_SetSelectedID(OmegaMapContinentDropDown,GetCurrentMapContinent());
	end
end

function OmegaMapContinentsDropDown_Initialize()
	OmegaMapFrame_LoadContinents(GetMapContinents());
end

function OmegaMapFrame_LoadContinents(...)
	local info = UIDropDownMenu_CreateInfo();
	for i=1, select("#", ...), 1 do
		info.text = select(i, ...);
		info.func = OmegaMapContinentButton_OnClick;
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function OmegaMapZoneDropDown_Update()
	UIDropDownMenu_Initialize(OmegaMapZoneDropDown, OmegaMapZoneDropDown_Initialize);
	UIDropDownMenu_SetWidth(OmegaMapZoneDropDown, 130);

	if ( (GetCurrentMapContinent() == WORLDMAP_WORLD_ID) or (GetCurrentMapContinent() == WORLDMAP_COSMIC_ID) ) then
		UIDropDownMenu_ClearAll(OmegaMapZoneDropDown);
	else
		UIDropDownMenu_SetSelectedID(OmegaMapZoneDropDown, GetCurrentMapZone());
	end
end

function OmegaMapZoneDropDown_Initialize()
	OmegaMapFrame_LoadZones(GetMapZones(GetCurrentMapContinent()));
end

function OmegaMapFrame_LoadZones(...)
	local info = UIDropDownMenu_CreateInfo();
	for i=1, select("#", ...), 1 do
		info.text = select(i, ...);
		info.func = OmegaMapZoneButton_OnClick;
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function OmegaMapLevelDropDown_Update()
	UIDropDownMenu_Initialize(OmegaMapLevelDropDown, OmegaMapLevelDropDown_Initialize);
	UIDropDownMenu_SetWidth(OmegaMapLevelDropDown, 130);

	if ( (GetNumDungeonMapLevels() == 0) ) then
		UIDropDownMenu_ClearAll(OmegaMapLevelDropDown);
		OmegaMapLevelDropDown:Hide();
		OmegaMapLevelUpButton:Hide();
		OmegaMapLevelDownButton:Hide();
	else
		UIDropDownMenu_SetSelectedID(OmegaMapLevelDropDown, GetCurrentMapDungeonLevel());
		OmegaMapLevelDropDown:Show();
		OmegaMapLevelUpButton:Show();
		OmegaMapLevelDownButton:Show();
	end
end

function OmegaMapLevelDropDown_Initialize()
	local info = UIDropDownMenu_CreateInfo();
	local level = GetCurrentMapDungeonLevel();
	
	local mapname = strupper(GetMapInfo() or "");
	
	local usesTerrainMap = DungeonUsesTerrainMap();

	for i=1, GetNumDungeonMapLevels() do
		local floorNum = i;
		if (usesTerrainMap) then
			floorNum = i - 1;
		end
		local floorname =_G["DUNGEON_FLOOR_" .. mapname .. floorNum];
		info.text = floorname or string.format(FLOOR_NUMBER, i);
		info.func = OmegaMapLevelButton_OnClick;
		info.checked = (i == level);
		UIDropDownMenu_AddButton(info);
	end
end

function OmegaMapLevelButton_OnClick(self)
	UIDropDownMenu_SetSelectedID(OmegaMapLevelDropDown, self:GetID());
	SetDungeonMapLevel(self:GetID());
end

function OmegaMapLevelUp_OnClick(self)
	CloseDropDownMenus();
	local currMapLevel = GetCurrentMapDungeonLevel();
	SetDungeonMapLevel(currMapLevel - 1);
	local newMapLevel = GetCurrentMapDungeonLevel();
	if ( currMapLevel ~= newMapLevel ) then
		UIDropDownMenu_SetSelectedID(OmegaMapLevelDropDown, newMapLevel);
	end
	PlaySound("UChatScrollButton");
end

function OmegaMapLevelDown_OnClick(self)
	CloseDropDownMenus();
	local currMapLevel = GetCurrentMapDungeonLevel();
	SetDungeonMapLevel(currMapLevel + 1);
	local newMapLevel = GetCurrentMapDungeonLevel();
	if ( currMapLevel ~= newMapLevel ) then
		UIDropDownMenu_SetSelectedID(OmegaMapLevelDropDown, newMapLevel);
	end
	PlaySound("UChatScrollButton");
end

function OmegaMapContinentButton_OnClick(self)
	UIDropDownMenu_SetSelectedID(OmegaMapContinentDropDown, self:GetID());
	SetMapZoom(self:GetID());
end

function OmegaMapZoneButton_OnClick(self)
	UIDropDownMenu_SetSelectedID(OmegaMapZoneDropDown, self:GetID());
	SetMapZoom(GetCurrentMapContinent(), self:GetID());
end

function OmegaMapZoomOutButton_OnClick()
	OmegaMapTooltip:Hide();
	
	-- check if code needs to zoom out before going to the continent map
	if ( ZoomOut() ~= nil ) then
		return;
	elseif ( GetCurrentMapZone() ~= WORLDMAP_WORLD_ID ) then
		SetMapZoom(GetCurrentMapContinent());
	elseif ( GetCurrentMapContinent() == WORLDMAP_WORLD_ID ) then
		SetMapZoom(WORLDMAP_COSMIC_ID);
	elseif ( GetCurrentMapContinent() == WORLDMAP_OUTLAND_ID ) then
		SetMapZoom(WORLDMAP_COSMIC_ID);
	else
		SetMapZoom(WORLDMAP_WORLD_ID);
	end
end

function OmegaMapButton_OnClick(button, mouseButton)
	CloseDropDownMenus();
	if ( mouseButton == "LeftButton" ) then
		local x, y = GetCursorPosition();
		x = x / button:GetEffectiveScale();
		y = y / button:GetEffectiveScale();

		local centerX, centerY = button:GetCenter();
		local width = button:GetWidth();
		local height = button:GetHeight();
		local adjustedY = (centerY + (height/2) - y) / height;
		local adjustedX = (x - (centerX - (width/2))) / width;
		ProcessMapClick( adjustedX, adjustedY);
	elseif ( mouseButton == "RightButton" ) then
	--Map Notes  plugin click register

			OmegaMapZoomOutButton_OnClick();

	elseif ( GetBindingFromClick(mouseButton) ==  "TOGGLEWORLDMAP" ) then
		ToggleFrame(OmegaMapFrame);
	end
end

local BLIP_TEX_COORDS = {
["WARRIOR"] = { 0, 0.125, 0, 0.25 },
["PALADIN"] = { 0.125, 0.25, 0, 0.25 },
["HUNTER"] = { 0.25, 0.375, 0, 0.25 },
["ROGUE"] = { 0.375, 0.5, 0, 0.25 },
["PRIEST"] = { 0.5, 0.625, 0, 0.25 },
["DEATHKNIGHT"] = { 0.625, 0.75, 0, 0.25 },
["SHAMAN"] = { 0.75, 0.875, 0, 0.25 },
["MAGE"] = { 0.875, 1, 0, 0.25 },
["WARLOCK"] = { 0, 0.125, 0.25, 0.5 },
["DRUID"] = { 0.25, 0.375, 0.25, 0.5 }
}

local BLIP_RAID_Y_OFFSET = 0.5;

function OmegaMapButton_OnUpdate(self, elapsed)
	local x, y = GetCursorPosition();
	x = x / self:GetEffectiveScale();
	y = y / self:GetEffectiveScale();

	local centerX, centerY = self:GetCenter();
	local width = self:GetWidth();
	local height = self:GetHeight();
	local adjustedY = (centerY + (height/2) - y ) / height;
	local adjustedX = (x - (centerX - (width/2))) / width;
	
	local name, fileName, texPercentageX, texPercentageY, textureX, textureY, scrollChildX, scrollChildY
	if ( self:IsMouseOver() ) then
		name, fileName, texPercentageX, texPercentageY, textureX, textureY, scrollChildX, scrollChildY, minLevel, maxLevel = UpdateMapHighlight( adjustedX, adjustedY );
	end

	OmegaMapFrame.areaName = name;
	if ( not OmegaMapFrame.poiHighlight ) then
		if ( OmegaMapFrame.maelstromZoneText ) then
			OmegaMapFrameAreaLabel:SetText(OmegaMapFrame.maelstromZoneText);
			name = OmegaMapFrame.maelstromZoneText;
			minLevel = OmegaMapFrame.minLevel;
			maxLevel = OmegaMapFrame.maxLevel;

		else
			OmegaMapFrameAreaLabel:SetText(name);
		end

		if (name and minLevel and maxLevel and minLevel > 0 and maxLevel > 0) then
			local playerLevel = UnitLevel("player");
			local color;
			if (playerLevel < minLevel) then
				color = GetQuestDifficultyColor(minLevel);
			elseif (playerLevel > maxLevel) then
				--subtract 2 from the maxLevel so zones entirely below the player's level won't be yellow
				color = GetQuestDifficultyColor(maxLevel - 2); 
			else
				color = QuestDifficultyColors["difficult"];
			end
			color = ConvertRGBtoColorString(color);
			OmegaMapFrameAreaLabel:SetText(OmegaMapFrameAreaLabel:GetText()..color.." ("..minLevel.."-"..maxLevel..")");
		end

	end
	if ( fileName ) then
		OmegaMapHighlight:SetTexCoord(0, texPercentageX, 0, texPercentageY);
		OmegaMapHighlight:SetTexture("Interface\\WorldMap\\"..fileName.."\\"..fileName.."Highlight");
		textureX = textureX * width;
		textureY = textureY * height;
		scrollChildX = scrollChildX * width;
		scrollChildY = -scrollChildY * height;
		if ( (textureX > 0) and (textureY > 0) ) then
			OmegaMapHighlight:SetWidth(textureX);
			OmegaMapHighlight:SetHeight(textureY);
			OmegaMapHighlight:SetPoint("TOPLEFT", "OmegaMapDetailFrame", "TOPLEFT", scrollChildX, scrollChildY);
			OmegaMapHighlight:Show();
			--OmegaMapFrameAreaLabel:SetPoint("TOP", "OmegaMapHighlight", "TOP", 0, 0);
		end
		
	else
		OmegaMapHighlight:Hide();
	end
	--Position player
	local playerX, playerY = OmegaMapOffsetAltMapCoords( GetPlayerMapPosition("player"));
	local activeFrame = OmegaMapDetailFrame

	if ( (playerX == 0 and playerY == 0) ) then
		OmegaMapPing:Hide();
		OmegaMapPlayer:Hide();
	else
-- Code for exterior swtich
	local uX, uY = OmegaMapOffsetAltMapCoords( playerX, playerY)

	if (OMEGAMAP_ALTMAP) then
		activeFrame = OmegaMapAltMapFrame
	else
		activeFrame = OmegaMapDetailFrame
	end

	playerX = playerX  * activeFrame:GetWidth();
	playerY = -playerY  * activeFrame:GetHeight();
	
	OmegaMapPlayer:SetPoint("CENTER", activeFrame, "TOPLEFT", playerX, playerY);


		-- Position clear button to detect mouseovers
		OmegaMapPlayer:Show();

		--OmegaMapPlayer:SetPoint("CENTER", "OmegaMapDetailFrame", "TOPLEFT", playerX, playerY);
		local angle = GetPlayerFacing() + 2.356;
		local cos, sin = math.cos(angle), math.sin(angle);
		OM_pArrow:SetTexCoord(	0.5-sin, 0.5+cos,
							0.5+cos, 0.5+sin,
							0.5-cos, 0.5-sin,
							0.5+sin, 0.5-cos);

		-- Position player ping if its shown
		if ( OmegaMapPing:IsShown() ) then
			OmegaMapPing:SetPoint("CENTER", activeFrame, "TOPLEFT", playerX, playerY);
			UIFrameFlash(OmegaMapPing, 0.25, 0.25, 20, false, 0.15, 0.15);
			-- If ping has a timer greater than 0 count it down, otherwise fade it out
			if ( OmegaMapPing.timer > 0 ) then
				OmegaMapPing.timer = OmegaMapPing.timer - elapsed;
				if ( OmegaMapPing.timer <= 0 ) then
					OmegaMapPing.fadeOut = 1;
					OmegaMapPing.fadeOutTimer = MINIMAPPING_FADE_TIMER;
				end
			elseif ( OmegaMapPing.fadeOut ) then
				OmegaMapPing.fadeOutTimer = OmegaMapPing.fadeOutTimer - elapsed;
				if ( OmegaMapPing.fadeOutTimer > 0 ) then
					OmegaMapPing:SetAlpha(255 * (OmegaMapPing.fadeOutTimer/MINIMAPPING_FADE_TIMER))
				else
					OmegaMapPing.fadeOut = nil;
					OmegaMapPing:Hide();
					UIFrameFlashStop(OmegaMapPing);

				end
			end
		end
	end

	--Position groupmates
	local playerCount = 0;
	if ( GetNumRaidMembers() > 0 ) then
		for i=1, MAX_PARTY_MEMBERS do
			local partyMemberFrame = _G["OmegaMapParty"..i];
			partyMemberFrame:Hide();
		end
		for i=1, MAX_RAID_MEMBERS do
			local unit = "raid"..i;
			local partyX, partyY = OmegaMapOffsetAltMapCoords(GetPlayerMapPosition(unit));
			local partyMemberFrame = _G["OmegaMapRaid"..(playerCount + 1)];
			if ( (partyX == 0 and partyY == 0) or UnitIsUnit(unit, "player") ) then
				partyMemberFrame:Hide();
			else
				partyX = partyX * activeFrame:GetWidth();
				partyY = -partyY * activeFrame:GetHeight();
				partyMemberFrame:SetPoint("CENTER", activeFrame, "TOPLEFT", partyX, partyY);
				local class = select(2, UnitClass(unit));
				if ( class ) then
					if ( UnitInParty(unit) ) then
						partyMemberFrame.icon:SetTexCoord(
							BLIP_TEX_COORDS[class][1],
							BLIP_TEX_COORDS[class][2],
							BLIP_TEX_COORDS[class][3],
							BLIP_TEX_COORDS[class][4]
						);
					else
						partyMemberFrame.icon:SetTexCoord(
							BLIP_TEX_COORDS[class][1],
							BLIP_TEX_COORDS[class][2],
							BLIP_TEX_COORDS[class][3] + BLIP_RAID_Y_OFFSET,
							BLIP_TEX_COORDS[class][4] + BLIP_RAID_Y_OFFSET
						);
					end
				end
				partyMemberFrame.name = nil;
				partyMemberFrame.unit = unit;
				partyMemberFrame:Show();
				playerCount = playerCount + 1;
			end
		end
	else
		for i=1, MAX_PARTY_MEMBERS do
			local unit = "party"..i;
			local partyX, partyY = OmegaMapOffsetAltMapCoords(GetPlayerMapPosition(unit));
			local partyMemberFrame = _G["OmegaMapParty"..i];
			if ( partyX == 0 and partyY == 0 ) then
				partyMemberFrame:Hide();
			else
				partyX = partyX * activeFrame:GetWidth();
				partyY = -partyY * activeFrame:GetHeight();
				partyMemberFrame:SetPoint("CENTER", activeFrame, "TOPLEFT", partyX, partyY);
				local class = select(2, UnitClass(unit));
				if ( class ) then
					partyMemberFrame.icon:SetTexCoord(
						BLIP_TEX_COORDS[class][1],
						BLIP_TEX_COORDS[class][2],
						BLIP_TEX_COORDS[class][3],
						BLIP_TEX_COORDS[class][4]
					);
				end
				partyMemberFrame:Show();
			end
		end
	end
	-- Position Team Members
	local numTeamMembers = GetNumBattlefieldPositions();
	for i=playerCount+1, MAX_RAID_MEMBERS do
		local partyX, partyY, name = OmegaMapOffsetAltMapCoords(GetBattlefieldPosition(i - playerCount));
		local partyMemberFrame = _G["OmegaMapRaid"..i];
		if ( partyX == 0 and partyY == 0 ) then
			partyMemberFrame:Hide();
		else
			partyX = partyX * activeFrame:GetWidth();
			partyY = -partyY * activeFrame:GetHeight();
			partyMemberFrame:SetPoint("CENTER", activeFrame, "TOPLEFT", partyX, partyY);
			partyMemberFrame.name = name;
			partyMemberFrame.unit = nil;
			partyMemberFrame:Show();
		end
	end

	-- Position flags
	local numFlags = GetNumBattlefieldFlagPositions();
	for i=1, numFlags do
		local flagX, flagY, flagToken = OmegaMapOffsetAltMapCoords(GetBattlefieldFlagPosition(i));
		local flagFrameName = "OmegaMapFlag"..i;
		local flagFrame = _G[flagFrameName];
		if ( flagX == 0 and flagY == 0 ) then
			flagFrame:Hide();
		else
			flagX = flagX * activeFrame:GetWidth();
			flagY = -flagY * activeFrame:GetHeight();
			flagFrame:SetPoint("CENTER", activeFrame, "TOPLEFT", flagX, flagY);
			local flagTexture = _G[flagFrameName.."Texture"];
			flagTexture:SetTexture("Interface\\WorldStateFrame\\"..flagToken);
			flagFrame:Show();
		end
	end
	for i=numFlags+1, NUM_OMEGAMAP_FLAGS do
		local flagFrame = _G["OmegaMapFlag"..i];
		flagFrame:Hide();
	end

	-- Position corpse
	local corpseX, corpseY = OmegaMapOffsetAltMapCoords(GetCorpseMapPosition());
	if ( corpseX == 0 and corpseY == 0 ) then
		OmegaMapCorpse:Hide();
	else
		corpseX = corpseX * activeFrame:GetWidth();
		corpseY = -corpseY * activeFrame:GetHeight();
		
		OmegaMapCorpse:SetPoint("CENTER", activeFrame, "TOPLEFT", corpseX, corpseY);
		OmegaMapCorpse:Show();
	end

	-- Position Death Release marker
	local deathReleaseX, deathReleaseY = OmegaMapOffsetAltMapCoords(GetDeathReleasePosition());
	if ((deathReleaseX == 0 and deathReleaseY == 0) or UnitIsGhost("player")) then
		OmegaMapDeathRelease:Hide();
	else
		deathReleaseX = deathReleaseX * activeFrame:GetWidth();
		deathReleaseY = -deathReleaseY * activeFrame:GetHeight();
		
		OmegaMapDeathRelease:SetPoint("CENTER", activeFrame, "TOPLEFT", deathReleaseX, deathReleaseY);
		OmegaMapDeathRelease:Show();
	end
	
	-- position vehicles
	local numVehicles;
	if ( GetCurrentMapContinent() == WORLDMAP_WORLD_ID or (GetCurrentMapContinent() ~= -1 and GetCurrentMapZone() == 0) ) then
		-- Hide vehicles on the worldmap and continent maps
		numVehicles = 0;
	else
		numVehicles = GetNumBattlefieldVehicles();
	end
	local totalVehicles = #MAP_VEHICLES;
	local index = 0;
	for i=1, numVehicles do
		if (i > totalVehicles) then
			local vehicleName = "OmegaMapVehicles"..i;
			MAP_VEHICLES[i] = CreateFrame("FRAME", vehicleName, OmegaMapButton, "OmegaMapVehicleTemplate");
			MAP_VEHICLES[i].texture = _G[vehicleName.."Texture"];
		end
		local vehicleX, vehicleY, unitName, isPossessed, vehicleType, orientation, isPlayer, isAlive =OmegaMapOffsetAltMapCoords( GetBattlefieldVehicleInfo(i));
		if ( vehicleX and isAlive and not isPlayer and VEHICLE_TEXTURES[vehicleType]) then
			local mapVehicleFrame = MAP_VEHICLES[i];
			vehicleX = vehicleX * activeFrame:GetWidth();
			vehicleY = -vehicleY * activeFrame:GetHeight();
			mapVehicleFrame.texture:SetRotation(orientation);
			mapVehicleFrame.texture:SetTexture(WorldMap_GetVehicleTexture(vehicleType, isPossessed));
			mapVehicleFrame:SetPoint("CENTER", activeFrame, "TOPLEFT", vehicleX, vehicleY);
			mapVehicleFrame:SetWidth(VEHICLE_TEXTURES[vehicleType].width);
			mapVehicleFrame:SetHeight(VEHICLE_TEXTURES[vehicleType].height);
			mapVehicleFrame.name = unitName;
			mapVehicleFrame:Show();
			index = i;	-- save for later
		else
			MAP_VEHICLES[i]:Hide();
		end
	end
	if (index < totalVehicles) then
		for i=index+1, totalVehicles do
			MAP_VEHICLES[i]:Hide();
		end
	end	

	local continent = GetCurrentMapContinent()
	local zone = GetCurrentMapZone()
end

function OmegaMapFrame_PingPlayerPosition()
	OmegaMapPing:SetAlpha(255);
	OmegaMapPing:Show();
	--PlaySound("MapPing");
	OmegaMapPing.timer = 1;
end

function OmegaMap_GetVehicleTexture(vehicleType, isPossessed)
	if ( not vehicleType ) then
		return;
	end
	if ( not isPossessed ) then
		isPossessed = 1;
	else
		isPossessed = 2;
	end
	if ( not VEHICLE_TEXTURES[vehicleType]) then
		return;
	end
	return VEHICLE_TEXTURES[vehicleType][isPossessed];
end

function OmegaMap_LoadTextures()
end

function OmegaMap_ClearTextures()
	for i=1, NUM_OMEGAMAP_OVERLAYS do
		_G["OmegaMapOverlay"..i]:SetTexture(nil);
	end
	local numOfDetailTiles = GetNumberOfDetailTiles();
	for i=1, numOfDetailTiles do
		--_G["OmegaMapFrameTexture"..i]:SetTexture(nil);
		_G["OmegaMapDetailTile"..i]:SetTexture(nil);
	end

end


function OmegaMapUnit_OnLoad(self)
	self:SetFrameLevel(self:GetFrameLevel() + 1);
end

function OmegaMapUnit_OnEnter(self, motion)
	OmegaMapPOIFrame.allowBlobTooltip = false;
	-- Adjust the tooltip based on which side the unit button is on
	local x, y = self:GetCenter();
	local parentX, parentY = self:GetParent():GetCenter();
	if ( x > parentX ) then
		OmegaMapTooltip:SetOwner(self, "ANCHOR_LEFT");
	else
		OmegaMapTooltip:SetOwner(self, "ANCHOR_RIGHT");
	end

	-- See which POI's are in the same region and include their names in the tooltip
	local unitButton;
	local newLineString = "";
	local tooltipText = "";

	-- Check player
	if ( OmegaMapPlayer:IsMouseOver() ) then
		if ( PlayerIsPVPInactive(OmegaMapPlayer.unit) ) then
			tooltipText = format(PLAYER_IS_PVP_AFK, UnitName(OmegaMapPlayer.unit));
		else
			tooltipText = UnitName(OmegaMapPlayer.unit);
		end
		newLineString = "\n";
	end
	-- Check party
	for i=1, MAX_PARTY_MEMBERS do
		unitButton = _G["OmegaMapParty"..i];
		if ( unitButton:IsVisible() and unitButton:IsMouseOver() ) then
			if ( PlayerIsPVPInactive(unitButton.unit) ) then
				tooltipText = tooltipText..newLineString..format(PLAYER_IS_PVP_AFK, UnitName(unitButton.unit));
			else
				tooltipText = tooltipText..newLineString..UnitName(unitButton.unit);
			end
			newLineString = "\n";
		end
	end
	-- Check Raid
	for i=1, MAX_RAID_MEMBERS do
		unitButton = _G["OmegaMapRaid"..i];
		if ( unitButton:IsVisible() and unitButton:IsMouseOver() ) then
			if ( unitButton.name ) then
				-- Handle players not in your raid or party, but on your team
				if ( PlayerIsPVPInactive(unitButton.name) ) then
					tooltipText = tooltipText..newLineString..format(PLAYER_IS_PVP_AFK, unitButton.name);
				else
					tooltipText = tooltipText..newLineString..unitButton.name;		
				end
			else
				if ( PlayerIsPVPInactive(unitButton.unit) ) then
					tooltipText = tooltipText..newLineString..format(PLAYER_IS_PVP_AFK, UnitName(unitButton.unit));
				else
					tooltipText = tooltipText..newLineString..UnitName(unitButton.unit);
				end
			end
			newLineString = "\n";
		end
	end
	-- Check Vehicles
	local numVehicles = GetNumBattlefieldVehicles();
	for _, v in pairs(MAP_VEHICLES) do
		if ( v:IsVisible() and v:IsMouseOver() ) then
			if ( v.name ) then
				tooltipText = tooltipText..newLineString..v.name;
			end
			newLineString = "\n";
		end
	end
	OmegaMapTooltip:SetText(tooltipText);
	OmegaMapTooltip:Show();
end

function OmegaMapUnit_OnLeave(self, motion)
	OmegaMapPOIFrame.allowBlobTooltip = true;
	OmegaMapTooltip:Hide();
end

function OmegaMapUnit_OnEvent(self, event, ...)
	if ( event == "UNIT_AURA" ) then
		if ( self.unit ) then
			local unit = ...;
			if ( self.unit == unit ) then
				OmegaMapUnit_Update(self);
			end
		end
	end
end

function OmegaMapUnit_OnMouseUp(self, mouseButton, raidUnitPrefix, partyUnitPrefix)
	if ( GetCVar("enablePVPNotifyAFK") == "0" ) then
		return;
	end

	if ( mouseButton == "RightButton" ) then
		BAD_BOY_COUNT = 0;

		local inInstance, instanceType = IsInInstance();
		if ( instanceType == "pvp" ) then
			--Check Raid
			local unitButton;
			for i=1, MAX_RAID_MEMBERS do
				unitButton = _G[raidUnitPrefix..i];
				if ( unitButton.unit and unitButton:IsVisible() and unitButton:IsMouseOver() and
					 not PlayerIsPVPInactive(unitButton.unit) ) then
					BAD_BOY_COUNT = BAD_BOY_COUNT + 1;
					BAD_BOY_UNITS[BAD_BOY_COUNT] = unitButton.unit;
				end
			end
			if ( BAD_BOY_COUNT > 0 ) then
				-- Check party
				for i=1, MAX_PARTY_MEMBERS do
					unitButton = _G[partyUnitPrefix..i];
					if ( unitButton.unit and unitButton:IsVisible() and unitButton:IsMouseOver() and
						 not PlayerIsPVPInactive(unitButton.unit) ) then
						BAD_BOY_COUNT = BAD_BOY_COUNT + 1;
						BAD_BOY_UNITS[BAD_BOY_COUNT] = unitButton.unit;
					end
				end
			end
		end

		if ( BAD_BOY_COUNT > 0 ) then
			UIDropDownMenu_Initialize( OmegaMapUnitDropDown, OmegaMapUnitDropDown_Initialize, "MENU");
			ToggleDropDownMenu(1, nil, OmegaMapUnitDropDown, self:GetName(), 0, -5);
		end
	end
end

function OmegaMapUnit_OnShow(self)
	self:RegisterEvent("UNIT_AURA");
	OmegaMapUnit_Update(self);

end

function OmegaMapUnit_OnHide(self)
	self:UnregisterEvent("UNIT_AURA");
end

function OmegaMapUnit_Update(self)
	-- check for pvp inactivity (pvp inactivity is a debuff so make sure you call this when you get a UNIT_AURA event)
	local player = self.unit or self.name;
	if ( player and PlayerIsPVPInactive(player) ) then
		self.icon:SetVertexColor(0.5, 0.2, 0.8);
	else
		self.icon:SetVertexColor(1.0, 1.0, 1.0);
	end
end

function OmegaMapUnitDropDown_Initialize()
	local info = UIDropDownMenu_CreateInfo();
	info.text = PVP_REPORT_AFK;
	info.notClickable = 1;
	info.isTitle = 1;
	info.notCheckable = true;
	UIDropDownMenu_AddButton(info);

	if ( BAD_BOY_COUNT > 0 ) then
		for i=1, BAD_BOY_COUNT do
			info = UIDropDownMenu_CreateInfo();
			info.func = OmegaMapUnitDropDown_OnClick;
			info.arg1 = BAD_BOY_UNITS[i];
			info.text = UnitName( BAD_BOY_UNITS[i] );
			info.notCheckable = true;
			UIDropDownMenu_AddButton(info);
		end
		
		if ( BAD_BOY_COUNT > 1 ) then
			info = UIDropDownMenu_CreateInfo();
			info.func = OmegaMapUnitDropDown_ReportAll_OnClick;
			info.text = PVP_REPORT_AFK_ALL;
			info.notCheckable = true;
			UIDropDownMenu_AddButton(info);
		end
	end

	info = UIDropDownMenu_CreateInfo();
	info.text = CANCEL;
	info.notCheckable = true;
	UIDropDownMenu_AddButton(info);
end

function OmegaMapUnitDropDown_OnClick(self, unit)
	ReportPlayerIsPVPAFK(unit);
end

function OmegaMapUnitDropDown_ReportAll_OnClick()
	if ( BAD_BOY_COUNT > 0 ) then
		for i=1, BAD_BOY_COUNT do
			ReportPlayerIsPVPAFK(BAD_BOY_UNITS[i]);
		end
	end
end

function OmegaMapFrame_ResetFrameLevels()
	
OmegaMapMasterFrame:SetFrameStrata("HIGH")
	OmegaMapSpecialFrame:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL - 14);
	OmegaMapFrame:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL - 13);
	OmegaMapDetailFrame:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL - 12);
	OmegaMapBlobFrame:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL - 11);
	OmegaMapArchaeologyDigSites:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL - 11);
	OmegaMapButton:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL - 10);
	OmegaMapQuestScrollFrame:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL - 9);
	OmegaMapPOIFrame:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL);
	-- PlayerArrowEffectFrame is created in code: COmegaMap::CreateArrowFrame()
	PlayerArrowEffectFrame:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL + 100);
    for i=1, MAX_PARTY_MEMBERS do
        _G["OmegaMapParty"..i]:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL + 100 - 1);
    end
end

function OmegaMapQuestShowObjectives_Toggle()
	if ( not OmegaMapConfig.showObjectives ) then
		WatchFrame.showObjectives= true;
		QuestLogFrameShowMapButton:Show();		
	else
		WatchFrame.showObjectives = nil;
		WatchFrame_Update();
		QuestLogFrameShowMapButton:Hide();	
	end
end


function OmegaMapFrame_DisplayQuests(selectQuestId)
	if ( OmegaMapFrame_UpdateQuests() > 0 ) then
		if ( selectQuestId ) then
			-- select the requested quest
			OmegaMapFrame_SelectQuestById(selectQuestId);
		elseif ( WORLDMAP_SETTINGS.selectedQuestId ) then
			-- try to select previously selected quest
			OmegaMapFrame_SelectQuestById(WORLDMAP_SETTINGS.selectedQuestId);
		else
			-- select the first quest
			OmegaMapFrame_SelectQuestFrame(_G["OmegaMapQuestFrame1"]);
		end
		OmegaMapBlobFrame:Show();
		OmegaMapPOIFrame:Show();
		OmegaMapShowObjectivesButton:Show()
		--OmegaMapTrackQuest:Show();	
		if (OmegaMapConfig.showObjectives) then
			OmegaMapQuestScrollFrame:Show();
		else
			OmegaMapQuestScrollFrame:Hide();
		end
		--OmegaMapQuestDetailScrollFrame:Show();
		--OmegaMapQuestRewardScrollFrame:Show()
		--[[		--Used to hide the objective list, but keep POI on map
		if (OmegaMapConfig.showObjectives) and  OmegaMapDetailFrame:IsShown() then
			OmegaMapQuestScrollFrame:Show();
		else			OmegaMapShowObjectivesButton:Show();
		end --]]
	else
		OmegaMapBlobFrame:Hide();
		OmegaMapPOIFrame:Hide();
		OmegaMapTrackQuest:Hide();
		OmegaMapQuestScrollFrame:Hide()
		OmegaMapQuestDetailScrollFrame:Hide()
		OmegaMapQuestRewardScrollFrame:Hide()
		OmegaMapShowObjectivesButton:Hide()
	end
end

function OmegaMapFrame_SelectQuestById(questId)
	local questFrame;
	for i = 1, MAX_NUM_QUESTS do
		questFrame = _G["OmegaMapQuestFrame"..i];
		if ( not questFrame ) then
			break
		elseif ( questFrame.questId == questId ) then
			OmegaMapFrame_SelectQuestFrame(questFrame);
			return;
		end
	end
	-- failed to find quest by id
	OmegaMapFrame_SelectQuestFrame(_G["OmegaMapQuestFrame1"]);
end

function OmegaMapFrame_SetFullMapView()
	OMEGAMAP_SETTINGS.size = OMEGAMAP_FULLMAP_SIZE;
	OmegaMapDetailFrame:SetScale(OMEGAMAP_FULLMAP_SIZE);
	OmegaMapButton:SetScale(OMEGAMAP_FULLMAP_SIZE);
	OmegaMapFrameAreaFrame:SetScale(OMEGAMAP_FULLMAP_SIZE);
	OmegaMapDetailFrame:SetPoint("TOPLEFT", OmegaMapPositioningGuide, "TOP", -502, -69);
		
	local numOfDetailTiles = GetNumberOfDetailTiles();
	for i = numOfDetailTiles + 1, numOfDetailTiles + NUM_WORLDMAP_PATCH_TILES do
		_G["WorldMapFrameTexture"..i]:Show();
	end
	
	OmegaMapQuestDetailScrollFrame:Hide();
	OmegaMapQuestRewardScrollFrame:Hide();
	--OmegaMapQuestScrollFrame:Show();

	OmegaMapJournal_AddMapButtons();
end

function OmegaMapFrame_UpdateMap(questId)
	OmegaMapFrame_Update();
	OmegaMapContinentsDropDown_Update();
	OmegaMapZoneDropDown_Update();
	OmegaMapLevelDropDown_Update();
	if ( WatchFrame.showObjectives ) then
		OmegaMapFrame_DisplayQuests(questId);
	end
end

function ArchaeologyDigSiteFrame_OnUpdate()
	if (not OmegaMapFrame:IsVisible()) then return end

	OmegaMapArchaeologyDigSites:DrawNone();
	local numEntries = ArchaeologyMapUpdateAll();
	for i = 1, numEntries do
		local blobID = ArcheologyGetVisibleBlobID(i);
		OmegaMapArchaeologyDigSites:DrawBlob(blobID, true);
	end
end

function OmegaMapFrame_UpdateQuests()
	local title, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily;
	local questId, questLogIndex;
	local questFrame;
	local lastFrame;
	local refFrame = OmegaMapQuestFrame0;
	local questCount = 0;
	local numObjectives, requiredMoney;
	local text, _, finished;
	local playerMoney = GetMoney();
	
	local numPOINumeric = 0;
	local numPOICompleteSwap = 0;
	
	local numEntries = QuestMapUpdateAllQuests();
	OmegaMapFrame_ClearQuestPOIs();
	QuestPOIUpdateIcons();
	if ( OmegaMapQuestScrollFrame.highlightedFrame ) then
		OmegaMapQuestScrollFrame.highlightedFrame.ownPOI:UnlockHighlight();
	end
	QuestPOI_HideAllButtons("OmegaMapQuestScrollChildFrame");
	-- clear blobs
	OmegaMapBlobFrame:DrawNone();
	-- populate quest frames
	for i = 1, numEntries do
		questId, questLogIndex = QuestPOIGetQuestIDByVisibleIndex(i);
		if ( questLogIndex and questLogIndex > 0 ) then
			questCount = questCount + 1;
			title, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily, questID, startEvent = GetQuestLogTitle(questLogIndex);
			requiredMoney = GetQuestLogRequiredMoney(questLogIndex);
			numObjectives = GetNumQuestLeaderBoards(questLogIndex);
			if ( isComplete and isComplete < 0 ) then
				isComplete = false;
			elseif ( numObjectives == 0 and playerMoney >= requiredMoney and not startEvent) then
				isComplete = true;
			end
			questFrame = OmegaMapFrame_GetQuestFrame(questCount, isComplete);
			if ( lastFrame ) then
				questFrame:SetPoint("TOPLEFT", lastFrame, "BOTTOMLEFT", 0, 0);
			else
				questFrame:SetPoint("TOPLEFT", OmegaMapQuestScrollChildFrame, "TOPLEFT", 2, 0);
			end
			-- set up indexes
			questFrame.questId = questId;
			questFrame.questLogIndex = questLogIndex;
			questFrame.completed = isComplete;
			questFrame.level = level;		-- for difficulty color
			-- display map POI
			OmegaMapFrame_DisplayQuestPOI(questFrame, isComplete);
			-- set quest text
			questFrame.title:SetText(title);
			if ( IsQuestWatched(questLogIndex) ) then
				questFrame.title:SetWidth(224);
				questFrame.check:Show();
			else
				questFrame.title:SetWidth(240);
				questFrame.check:Hide();
			end
			numObjectives = GetNumQuestLeaderBoards(questLogIndex);
			if ( isComplete ) then
				numPOICompleteSwap = numPOICompleteSwap + 1;
				questFrame.objectives:SetText(GetQuestLogCompletionText(questLogIndex));
				questFrame.dashes:SetText(QUEST_DASH);
			else
				numPOINumeric = numPOINumeric + 1;
				local questText = "";
				local dashText = "";
				local reversedText;
				local numLines;
				for j = 1, numObjectives do
					text, objectiveType, finished = GetQuestLogLeaderBoard(j, questLogIndex);
					if ( text and not finished ) then
						reversedText = ReverseQuestObjective(text, objectiveType);
						questText = questText..reversedText.."|n";
						refFrame.objectives:SetText(reversedText);
						-- need to add 1 spacing's worth to height because for n number of lines there are n-1 spacings
						numLines = (refFrame.objectives:GetHeight() + refFrame.lineSpacing) / refFrame.lineHeight;
						-- round numLines to the closest integer
						numLines = floor(numLines + 0.5);
						dashText = dashText..QUEST_DASH..string.rep("|n", numLines);
					end
				end
				if ( requiredMoney > playerMoney ) then
					questText = questText.."- "..GetMoneyString(playerMoney).." / "..GetMoneyString(requiredMoney);
					dashText = dashText..QUEST_DASH;
				end				
				questFrame.objectives:SetText(questText);
				questFrame.dashes:SetText(dashText);
			end
			questFrame.title:SetTextColor(1,1,0)
			questFrame.objectives:SetTextColor(1,1,0)
			questFrame.dashes:SetTextColor(1,1,0)
			-- difficulty
			if ( MAP_QUEST_DIFFICULTY == "1" ) then
				local color = GetQuestDifficultyColor(level);
				questFrame.title:SetTextColor(color.r, color.g, color.b);
			end
			-- size and show
			questFrame:SetHeight(max(questFrame.title:GetHeight() + questFrame.objectives:GetHeight() + QUESTFRAME_PADDING, QUESTFRAME_MINHEIGHT));
			questFrame:Show();
			lastFrame = questFrame;
		end
	end
	OmegaMapFrame.numQuests = questCount;
	-- hide frames not being used for this map
	for i = questCount + 1, MAX_NUM_QUESTS do
		questFrame = _G["OmegaMapQuestFrame"..i];
		if ( not questFrame ) then
			break;
		end		
		questFrame:Hide();
		questFrame.questId = 0;
	end
	QuestPOI_HideButtons("OmegaMapPOIFrame", QUEST_POI_NUMERIC, numPOINumeric + 1);
	QuestPOI_HideButtons("OmegaMapPOIFrame", QUEST_POI_COMPLETE_SWAP, numPOICompleteSwap + 1);
	
	EncounterJournal_CheckQuestButtons();
	return questCount;
end

function OmegaMapFrame_SelectQuestFrame(questFrame)
	local poiIcon;
	local color;
	-- clear current selection	
	if ( WORLDMAP_SETTINGS.selectedQuest ) then
		local currentSelection = WORLDMAP_SETTINGS.selectedQuest;
		poiIcon = currentSelection.poiIcon;
		QuestPOI_DeselectButton(poiIcon);
		QuestPOI_DeselectButtonByParent("OmegaMapQuestScrollChildFrame");
		OmegaMapBlobFrame:DrawBlob(currentSelection.questId, false);
		if ( MAP_QUEST_DIFFICULTY == "1" ) then
			color = GetQuestDifficultyColor(currentSelection.level);
			currentSelection.title:SetTextColor(color.r, color.g, color.b);
		end
		poiIcon:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL);
	end
	WORLDMAP_SETTINGS.selectedQuest = questFrame;
	WORLDMAP_SETTINGS.selectedQuestId = questFrame.questId;
	SetSuperTrackedQuestID(WORLDMAP_SETTINGS.selectedQuestId);
	OmegaMapQuestSelectedFrame:SetPoint("TOPLEFT", questFrame, "TOPLEFT", -10, 0);
	OmegaMapQuestSelectedFrame:SetHeight(questFrame:GetHeight());
	OmegaMapQuestSelectedFrame:Show();
	poiIcon = questFrame.poiIcon;
	QuestPOI_SelectButton(poiIcon);
	QuestPOI_SelectButton(questFrame.ownPOI);
	poiIcon:SetFrameLevel(WORLDMAP_POI_FRAMELEVEL + 1);
	-- colors
	if ( MAP_QUEST_DIFFICULTY == "1" ) then
		questFrame.title:SetTextColor(1, 1, 1);
		color = GetQuestDifficultyColor(questFrame.level);
		OmegaMapQuestSelectBar:SetVertexColor(color.r, color.g, color.b);
	end
	-- only display quest info if omegamap frame is embiggened
		SelectQuestLogEntry(questFrame.questLogIndex);
		QuestInfo_Display(QUEST_TEMPLATE_MAP1, OmegaMapQuestDetailScrollChildFrame);
		OmegaMapQuestDetailScrollFrameScrollBar:SetValue(0);
		ScrollFrame_OnScrollRangeChanged(OmegaMapQuestDetailScrollFrame);
		QuestInfo_Display(QUEST_TEMPLATE_MAP2, OmegaMapQuestRewardScrollChildFrame);
		OmegaMapQuestRewardScrollFrameScrollBar:SetValue(0);
		ScrollFrame_OnScrollRangeChanged(OmegaMapQuestRewardScrollFrame);

	-- track quest checkbark
	OmegaMapTrackQuest:SetChecked(IsQuestWatched(questFrame.questLogIndex));
	-- quest blob
	if ( questFrame.completed ) then
		OmegaMapBlobFrame:DrawBlob(questFrame.questId, false);
	else
		OmegaMapBlobFrame:DrawBlob(questFrame.questId, true);
	end
end

local numCompletedQuests = 0;
function OmegaMapFrame_ClearQuestPOIs()
	QuestPOI_HideButtons("OmegaMapPOIFrame", QUEST_POI_NUMERIC, 1);
	QuestPOI_HideButtons("OmegaMapPOIFrame", QUEST_POI_COMPLETE_IN, 1);
	numCompletedQuests = 0;
end

function OmegaMapFrame_DisplayQuestPOI(questFrame, isComplete)
	local index = questFrame.index;
	local poiButton;
	if ( isComplete ) then
		poiButton = QuestPOI_DisplayButton("OmegaMapPOIFrame", QUEST_POI_COMPLETE_IN, questFrame.completedIndex, questFrame.questId);
	else
		poiButton = QuestPOI_DisplayButton("OmegaMapPOIFrame", QUEST_POI_NUMERIC, index - numCompletedQuests, questFrame.questId);
	end
	questFrame.poiIcon = poiButton;
	local _, posX, posY, objective = QuestPOIGetIconInfo(questFrame.questId);
	if ( posX and posY ) then
		local POIscale;
		POIscale = 1;
		posX = posX * OmegaMapDetailFrame:GetWidth() * POIscale;
		posY = -posY * OmegaMapDetailFrame:GetHeight() * POIscale;
		-- keep outlying POIs within map borders
		if ( posY > OMEGAMAP_POI_MIN_Y ) then
			posY = OMEGAMAP_POI_MIN_Y;
		elseif ( posY < OMEGAMAP_POI_MAX_Y ) then
			posY = OMEGAMAP_POI_MAX_Y
		end
		if ( posX < OMEGAMAP_POI_MIN_X ) then
			posX = OMEGAMAP_POI_MIN_X;
		elseif ( posX > OMEGAMAP_POI_MAX_X ) then
			posX = OMEGAMAP_POI_MAX_X;
		end
		poiButton:SetPoint("CENTER", "OmegaMapPOIFrame", "TOPLEFT", posX, posY);
		poiButton:SetScript("OnEnter", OmegaMapQuestPOI_OnEnter);
		poiButton:SetScript("OnLeave", OmegaMapQuestPOI_OnLeave);
		poiButton:SetScript("OnClick", OmegaMapQuestPOI_OnClick)
	end
	poiButton.quest = questFrame;
end

function OmegaMapFrame_SetPOIMaxBounds()
	OMEGAMAP_POI_MAX_Y = OmegaMapDetailFrame:GetHeight() * -OMEGAMAP_SETTINGS.size + 12;
	OMEGAMAP_POI_MAX_X = OmegaMapDetailFrame:GetWidth() * OMEGAMAP_SETTINGS.size + 12;
end

function OmegaMapFrame_GetQuestFrame(index, isComplete)
	local frame = _G["OmegaMapQuestFrame"..index];
	if ( not frame ) then
		frame = CreateFrame("Frame", "OmegaMapQuestFrame"..index, OmegaMapQuestScrollChildFrame, "OmegaMapQuestFrameTemplate");
		frame.index = index;
	end
	
	local poiButton;
	if ( isComplete ) then
		numCompletedQuests = numCompletedQuests + 1;
		poiButton = QuestPOI_DisplayButton("OmegaMapQuestScrollChildFrame", QUEST_POI_COMPLETE_IN, numCompletedQuests, 0);
		frame.completedIndex = numCompletedQuests;
	else
		poiButton = QuestPOI_DisplayButton("OmegaMapQuestScrollChildFrame", QUEST_POI_NUMERIC, index - numCompletedQuests, 0);
	end
	poiButton:SetPoint("TOPLEFT", frame, 4, 0);
	frame.ownPOI = poiButton;
	return frame;
end

function OmegaMapQuestFrame_OnEnter(self)
	self.ownPOI:LockHighlight();
	OmegaMapQuestScrollFrame.highlightedFrame = self;
	if ( WORLDMAP_SETTINGS.selectedQuest == self ) then
		return;
	end
	OmegaMapQuestHighlightedFrame:SetPoint("TOPLEFT", self, "TOPLEFT", -10, -1);
	OmegaMapQuestHighlightedFrame:SetHeight(self:GetHeight() - 2);
	if ( MAP_QUEST_DIFFICULTY == "1" ) then
		local color = GetQuestDifficultyColor(self.level);
		self.title:SetTextColor(1, 1, 1);
		OmegaMapQuestHighlightBar:SetVertexColor(color.r, color.g, color.b);
	end	
	OmegaMapQuestHighlightedFrame:Show();
	if ( not self.completed ) then
		OmegaMapBlobFrame:DrawBlob(self.questId, true);
	end
end

function OmegaMapQuestFrame_OnLeave(self)
	self.ownPOI:UnlockHighlight();
	OmegaMapQuestScrollFrame.highlightedFrame = nil;
	if ( WORLDMAP_SETTINGS.selectedQuest == self ) then
		return;
	end
	if ( MAP_QUEST_DIFFICULTY == "1" ) then
		local color = GetQuestDifficultyColor(self.level);
		self.title:SetTextColor(color.r, color.g, color.b);
	end		
	OmegaMapQuestHighlightedFrame:Hide();
	if ( not self.completed ) then
		OmegaMapBlobFrame:DrawBlob(self.questId, false);
	end
end

function OmegaMapQuestFrame_OnMouseDown(self)
	self.title:SetPoint("TOPLEFT", 35, -9);
	self.ownPOI:SetButtonState("PUSHED");
	QuestPOIButton_OnMouseDown(self.ownPOI);	
end

function OmegaMapQuestFrame_OnMouseUp(self)
	self.title:SetPoint("TOPLEFT", 34, -8);
	self.ownPOI:SetButtonState("NORMAL");
	QuestPOIButton_OnMouseUp(self.ownPOI);
	if ( self:IsMouseOver() ) then
		if ( WORLDMAP_SETTINGS.selectedQuest ~= self ) then
			OmegaMapQuestHighlightedFrame:Hide();
			PlaySound("igMainMenuOptionCheckBoxOn");
			OmegaMapFrame_SelectQuestFrame(self);
		end
		if ( IsShiftKeyDown() ) then
			local isChecked = not OmegaMapTrackQuest:GetChecked();
			OmegaMapTrackQuest:SetChecked(isChecked);		
			OmegaMapTrackQuest_Toggle(isChecked);
			OmegaMapQuestFrame_UpdateMouseOver();			
		end		
	end
end

function OmegaMapQuestFrame_UpdateMouseOver()
	if ( OmegaMapQuestScrollFrame:IsMouseOver() ) then
		for i = 1, OmegaMapFrame.numQuests do
			local questFrame = _G["OmegaMapQuestFrame"..i];
			if ( questFrame:IsMouseOver() ) then
				OmegaMapQuestFrame_OnEnter(questFrame);
				break;
			end
		end
	end
end

function OmegaMapQuestPOI_OnClick(self)
	PlaySound("igMainMenuOptionCheckBoxOn");
	if ( self.quest ~= WORLDMAP_SETTINGS.selectedQuest ) then
		if ( WORLDMAP_SETTINGS.selectedQuest ) then
			OmegaMapBlobFrame:DrawBlob(WORLDMAP_SETTINGS.selectedQuestId, false);
		end
		OmegaMapFrame_SelectQuestFrame(self.quest);
	end
	if ( IsShiftKeyDown() ) then
		local isChecked = not OmegaMapTrackQuest:GetChecked();
		OmegaMapTrackQuest:SetChecked(isChecked);		
		OmegaMapTrackQuest_Toggle(isChecked);
	end
end

function OmegaMapQuestPOI_OnEnter(self)
	OmegaMapPOIFrame.allowBlobTooltip = false;
	OmegaMapQuestPOI_SetTooltip(self, self.quest.questLogIndex);	
end

function OmegaMapQuestPOI_OnLeave(self)
	OmegaMapPOIFrame.allowBlobTooltip = true;
end

function OmegaMapQuestPOI_SetTooltip(poiButton, questLogIndex, numObjectives)
	local title = GetQuestLogTitle(questLogIndex);
	OmegaMapTooltip:SetOwner(OmegaMapFrame, "ANCHOR_CURSOR_RIGHT", 5, 2);
	OmegaMapTooltip:SetText(title);
	if ( poiButton and poiButton.type == QUEST_POI_COMPLETE_SWAP ) then
		if ( poiButton.type == QUEST_POI_COMPLETE_SWAP ) then
			OmegaMapTooltip:AddLine("- "..GetQuestLogCompletionText(questLogIndex), 1, 1, 1, 1);
		else
			local numObjectives = GetNumQuestLeaderBoards(questLogIndex);
			for i = 1, numObjectives do
				local text, objectiveType, finished = GetQuestLogLeaderBoard(i, questLogIndex);
				if ( text and not finished ) then
					OmegaMapTooltip:AddLine("- "..ReverseQuestObjective(text, objectiveType), 1, 1, 1, 1);
				end
			end
		end
	else
		local text, finished, objectiveType;
		local numItemDropTooltips = GetNumQuestItemDrops(questLogIndex);
		if(numItemDropTooltips and numItemDropTooltips > 0) then
			for i = 1, numItemDropTooltips do
				text, objectiveType, finished = GetQuestLogItemDrop(i, questLogIndex);
				if ( text and not finished ) then
					OmegaMapTooltip:AddLine("- "..ReverseQuestObjective(text, objectiveType), 1, 1, 1, 1);
				end
			end
		else
			local numPOITooltips = OmegaMapBlobFrame:GetNumTooltips();
			numObjectives = numObjectives or GetNumQuestLeaderBoards(questLogIndex);
			for i = 1, numObjectives do
				if(numPOITooltips and (numPOITooltips == numObjectives)) then
					local questPOIIndex = OmegaMapBlobFrame:GetTooltipIndex(i);
					text, objectiveType, finished = GetQuestPOILeaderBoard(questPOIIndex, questLogIndex);
				else
					text, objectiveType, finished = GetQuestLogLeaderBoard(i, questLogIndex);
				end
				if ( text and not finished ) then
					OmegaMapTooltip:AddLine("- "..ReverseQuestObjective(text, objectiveType), 1, 1, 1, 1);
				end
			end		
		end
	end	
	OmegaMapTooltip:Show();
end

function OmegaMapBlobFrame_OnLoad(self)
	self:SetFillTexture("Interface\\WorldMap\\UI-QuestBlob-Inside");
	self:SetBorderTexture("Interface\\WorldMap\\UI-QuestBlob-Outside");
	self:SetFillAlpha(128);
	self:SetBorderAlpha(192);
	self:SetBorderScalar(1.0);
end

function OmegaMapBlobFrame_OnUpdate(self)
	if ( not OmegaMapPOIFrame.allowBlobTooltip or not OmegaMapDetailFrame:IsMouseOver() ) then
		return;
	end
	if ( not self.xRatio ) then
		OmegaMapBlobFrame_CalculateHitTranslations();
	end
	local x, y = GetCursorPosition();
	local adjustedX = x / self.xRatio - self.xOffset;
	local adjustedY = self.yOffset - y / self.yRatio;
	local questLogIndex, numObjectives = self:UpdateMouseOverTooltip(adjustedX, adjustedY);
	if(numObjectives) then
		OmegaMapTooltip:SetOwner(OmegaMapFrame, "ANCHOR_CURSOR");
		OmegaMapQuestPOI_SetTooltip(nil, questLogIndex, numObjectives);
	elseif(not OmegaMapTooltip.EJ_using) then
		OmegaMapTooltip:Hide();
	end
end

function OmegaMapBlobFrame_CalculateHitTranslations()
	local self = OmegaMapBlobFrame;
	local centerX, centerY = self:GetCenter();
	local width = self:GetWidth();
	local height = self:GetHeight();
	local scale = self:GetEffectiveScale();
	self.yOffset = centerY / height + 0.5;
	self.yRatio = height * scale;
	self.xOffset = centerX / width - 0.5;
	self.xRatio = width * scale;
end

function OmegaMapFrame_ResetQuestColors()
	if ( MAP_QUEST_DIFFICULTY == "0" ) then
		OmegaMapQuestSelectBar:SetVertexColor(1, 0.824, 0);
		OmegaMapQuestHighlightBar:SetVertexColor(0.243, 0.570, 1);
		for i = 1, MAX_NUM_QUESTS do
			local questFrame = _G["OmegaMapQuestFrame"..i];
			if ( not questFrame ) then
				break;
			end
			questFrame.title:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);
		end
	end
end

function OmegaMap_OpenToQuest(questID, frameToShowOnClose)
	OmegaMapFrame.blockOmegaMapUpdate = true;
	ShowUIPanel(OmegaMapFrame);	
	local mapID, floorNumber = GetQuestOmegaMapAreaID(questID);
	if ( mapID ~= 0 ) then
		SetMapByID(mapID);
		if ( floorNumber ~= 0 ) then
			SetDungeonMapLevel(floorNumber);
		end
	end
	OmegaMapFrame.blockOmegaMapUpdate = nil;
	OmegaMapFrame_UpdateMap(questID);	
end


--- advanced options ---

function OmegaMapFrame_ChangeOpacity()
	OmegaMapConfig.opacity = OmegaMapSliderFrame:GetValue();
	OmegaMapFrame_SetOpacity(OmegaMapConfig.opacity);
end

--Sets the opacity of the various parts of themap
function OmegaMapFrame_SetOpacity(opacity)
	local alpha;
	-- set border alphas
	alpha = 0.5 + (1.0 - opacity) * 0.50;
	OmegaMapFrameCloseButton:SetAlpha(alpha);
	-- set map alpha
	alpha = 0.35 + (1.0 - opacity) * 0.65;
	OmegaMapDetailFrame:SetAlpha(alpha);
	if OmegaMapAltMapFrame then
		OmegaMapAltMapFrame:SetAlpha(alpha);
	end
	-- set blob alpha
	alpha = 0.65 + (1.0 - opacity) * 0.55;

	--OmegaMapPOIFrame:SetAlpha(alpha);
	OmegaMapBlobFrame:SetFillAlpha(128 * alpha);
	OmegaMapBlobFrame:SetBorderAlpha(192 * alpha);
	OmegaMapArchaeologyDigSites:SetFillAlpha(128 * alpha);
	OmegaMapArchaeologyDigSites:SetBorderAlpha(192 * alpha);
	--OmegaMapBossButtonFrame:SetAlpha(alpha);
end

function OmegaMapTrackQuest_Toggle(isChecked)
	local questIndex = WORLDMAP_SETTINGS.selectedQuest.questLogIndex;
	if ( isChecked ) then
		if ( GetNumQuestWatches() > MAX_WATCHABLE_QUESTS ) then
			UIErrorsFrame:AddMessage(format(QUEST_WATCH_TOO_MANY, MAX_WATCHABLE_QUESTS), 1.0, 0.1, 0.1, 1.0);
			OmegaMapTrackQuest:SetChecked(false);
			return;
		end
		if ( LOCAL_MAP_QUESTS["zone"] == GetCurrentMapZone() ) then
			LOCAL_MAP_QUESTS[WORLDMAP_SETTINGS.selectedQuestId] = true;
		end
		AddQuestWatch(questIndex);	
	else
		LOCAL_MAP_QUESTS[WORLDMAP_SETTINGS.selectedQuestId] = nil;
		RemoveQuestWatch(questIndex);
	end
	WatchFrame_Update();
	OmegaMapFrame_DisplayQuests(WORLDMAP_SETTINGS.selectedQuestId);	
end


--- For EJ boss butons
function OmegaMapJournal_AddMapButtons()
	local left = OmegaMapBossButtonFrame:GetLeft();
	local right = OmegaMapBossButtonFrame:GetRight();
	local top = OmegaMapBossButtonFrame:GetTop();
	local bottom = OmegaMapBossButtonFrame:GetBottom();

	if not left or not right or not top or not bottom then
		--This frame is resizing
		OmegaMapBossButtonFrame.ready = false;
		OmegaMapBossButtonFrame:SetScript("OnUpdate", OmegaMapJournal_AddMapButtons);
		return;
	else
		OmegaMapBossButtonFrame:SetScript("OnUpdate", nil);
	end
	
	local scale = OmegaMapDetailFrame:GetScale();
	local width = OmegaMapDetailFrame:GetWidth() * scale;
	local height = OmegaMapDetailFrame:GetHeight() * scale;
	local bossButton, questPOI, displayInfo, _;
	local index = 1;
	local x, y, instanceID, name, description, encounterID = EJ_GetMapEncounter(index);
	while name do
		bossButton = _G["EJOmegaMapButton"..index];
		if not bossButton then -- create button
			bossButton = CreateFrame("Button", "EJOmegaMapButton"..index, OmegaMapBossButtonFrame, "OmegaMapEncounterButtonTemplate");
	end
	
	bossButton.instanceID = instanceID;
	bossButton.encounterID = encounterID;
	bossButton.tooltipTitle = name;
	bossButton.tooltipText = description;
	bossButton:SetPoint("CENTER", OmegaMapBossButtonFrame, "BOTTOMLEFT", x*width, y*height);
	_, _, _, displayInfo = EJ_GetCreatureInfo(1, encounterID);
	bossButton.displayInfo = displayInfo;
	if ( displayInfo ) then
			SetPortraitTexture(bossButton.bgImage, displayInfo);
		else 
			bossButton.bgImage:SetTexture("DoesNotExist");
		end

	bossButton:Show();
	  -- bossButton:SetFrameLevel(100 - 5);
	index = index + 1;
	x, y, instanceID, name, description, encounterID = EJ_GetMapEncounter(index);

	end

 --   if (index == 1) then --not looking at dungeon map
		--OmegaMapQuestShowObjectives:Show();
		--OmegaMapShowDropDown:Hide();
	--else
	---- OmegaMapQuestShowObjectives:Hide();
	--   OmegaMapShowDropDown:Show();
	--end
	if (not GetCVarBool("showBosses")) then
		index = 1;
	end
	
	bossButton = _G["EJOmegaMapButton"..index];
	while bossButton do
		bossButton:Hide();
		index = index + 1;
		bossButton = _G["EJOmegaMapButton"..index];
	end
	
	OmegaMapBossButtonFrame.ready = true;
	OmegaMapJournal_CheckQuestButtons();
	
end

--- For EJ boss butons	
function OmegaMapJournal_UpdateMapButtonPortraits()
	if ( OmegaMapFrame:IsShown() ) then
		local index = 1;
		local bossButton = _G["EJOmegaMapButton"..index];
		while ( bossButton and bossButton:IsShown() ) do
			SetPortraitTexture(bossButton.bgImage, bossButton.displayInfo);
			index = index + 1;
			bossButton = _G["EJOmegaMapButton"..index];
		end
	end
end

--- For EJ boss butons	
function OmegaMapJournal_CheckQuestButtons()
	if not OmegaMapBossButtonFrame.ready then
		return;
	end

	--Validate that there are no quest button intersection
	local questI, bossI = 1, 1;
	bossButton = _G["EJOmegaMapButton"..bossI];
	questPOI = _G["poiOmegaMapPOIFrame1_"..questI];
	while bossButton and bossButton:IsShown() do
		while questPOI and questPOI:IsShown() do
			local qx,qy = questPOI:GetCenter();
			local bx,by = bossButton:GetCenter();
			if not qx or not qy or not bx or not by then
				_G["EJOmegaMapButton1"]:SetScript("OnUpdate", OmegaMapJournal_CheckQuestButtons);
				return;
			end
			 
			local xdis = abs(bx-qx);
			local ydis = abs(by-qy);
			local disSqr = xdis*xdis + ydis*ydis;
			 
			if EJ_QUEST_POI_MINDIS_SQR > disSqr then
				questPOI:SetPoint("CENTER", bossButton, "BOTTOMRIGHT",  -15, 15);
			end
			questI = questI + 1;
			questPOI = _G["poiOmegaMapPOIFrame1_"..questI];
		end
		questI = 1;
		bossI = bossI + 1;
		bossButton = _G["EJOmegaMapButton"..bossI];
		questPOI = _G["poiOmegaMapPOIFrame1_"..questI];
	end
	if _G["EEJOmegaMapButton1"] then
		_G["EJOmegaMapButton1"]:SetScript("OnUpdate", nil);
	end

end

-- functions to deal with map options dropdown that shows up when looking at a dungeon map
function OmegaMapShowDropDown_OnLoad(self)
	UIDropDownMenu_Initialize(self, OmegaMapShowDropDown_Initialize);
	UIDropDownMenu_SetText(self, MAP_OPTIONS_TEXT);
	UIDropDownMenu_SetWidth(self, 150);
end


function OmegaMapShowDropDown_Initialize()
	local info = UIDropDownMenu_CreateInfo();
	-- Show quests button
	info.text = SHOW_QUEST_OBJECTIVES_ON_MAP_TEXT;
	info.value = "quests";
	info.func = OmegaMapShowDropDown_OnClick;
	info.checked = GetCVarBool("questPOI");
	info.isNotRadio = true;
	info.keepShownOnClick = 1;
	UIDropDownMenu_AddButton(info);

	-- Show bosses button
	info.text = SHOW_BOSSES_ON_MAP_TEXT;
	info.value = "bosses";
	info.func = OmegaMapShowDropDown_OnClick;
	info.checked = GetCVarBool("showBosses");
	info.isNotRadio = true;
	info.keepShownOnClick = 1;
	UIDropDownMenu_AddButton(info);
end


function OmegaMapShowDropDown_OnClick(self)
	if (self.value == "quests") then
		OmegaMapQuestShowObjectives:Click()
	end
	if (self.value == "bosses") then
		if (self.checked) then
			SetCVar("showBosses", "1");
		else
			SetCVar("showBosses", "0");
		end
		OmegaMapFrame_Update();
	end
end

---  New Functions
function OmegaMapToggle()
	if ( OmegaMapFrame:IsVisible() ) then
		OmegaMapFrame:Hide()
		OmegaMapBlobFrame:DrawBlob(WORLDMAP_SETTINGS.selectedQuestId, false);
		OmegaMapArchaeologyDigSites:DrawNone();
		local numEntries = ArchaeologyMapUpdateAll();
		for i = 1, numEntries do
			local blobID = ArcheologyGetVisibleBlobID(i);
			OmegaMapArchaeologyDigSites:DrawBlob(blobID, false);
		end
	else
		OmegaMapFrame:Show()
	end
end

--Converts standard map cords to relative altmap cords
function OmegaMapOffsetAltMapCoords(pX, pY,...)
	if not OMEGAMAP_ALTMAP or (pX == 0 and pY == 0 ) then return pX,pY end

	local negX, negY = nil, nil;
	local wmDimension, wmOffset, relativeOffset, amDimension, amOffset;
	local wmData = OMEGAMAP_ALTMAP.wmData
	local omData = OMEGAMAP_ALTMAP.omData
	if ( pX < 0 ) then
		negX = true;
		pX = -(pX);
	end

	if ( pY < 0 ) then
		negY = true;
		pY = -(pY);
	end

	if ( pX < wmData.minX ) then
		pX = omData.minX;
	elseif ( pX > wmData.maxX ) then
		pX = omData.maxX;
	else
		wmDimension = wmData.maxX - wmData.minX;
		wmOffset = pX - wmData.minX;
		relativeOffset = wmOffset/wmDimension;
		amDimension = omData.maxX - omData.minX;
		amOffset = amDimension * relativeOffset;
		pX = omData.minX + amOffset;
	end

	if ( pY < wmData.minY ) then
		pY = omData.minY;
		elseif ( pY > wmData.maxY ) then
		pY = omData.maxY;
	else
		local wmDimension = wmData.maxY - wmData.minY;
		local wmOffset = pY - wmData.minY;
		local relativeOffset = wmOffset/wmDimension;
		local amDimension = omData.maxY - omData.minY;
		local amOffset = amDimension * relativeOffset;
		pY = omData.minY + amOffset;
	end

	if ( negX ) then
		pX = -(pX);
	end
	if ( negY ) then
		pY = -(pY);
	end

	return pX , pY,...;
end


--Solidifies Map to allow clicks & movement
function OmegaMapSolidify(state)
	if  (state == "Off")then
		OmegaMapButton:EnableMouse(false);
		OmegaMapMovementFrameTop:Hide();
		OmegaMapMovementFrameTop:EnableMouse(false)
		OmegaMapMovementFrameBottom:Hide();
		OmegaMapMovementFrameBottom:EnableMouse(false)
	elseif (state == "On") then
		OmegaMapButton:EnableMouse(true);
		--OmegaMapConfig.solidify = true
		OmegaMapMovementFrameTop:Show();
		OmegaMapMovementFrameTop:EnableMouse(true)
		OmegaMapMovementFrameBottom:Show();
		OmegaMapMovementFrameBottom:EnableMouse(true)
	end
end

function OmegaMapCoordsOnUpdate(self, elapsed)
	if ( not self.isMoving ) then
		if ( not self.timer ) then
			self.timer = 0;
		end

		self.timer = self.timer + elapsed;

		if ( self.timer > 0.1 ) then
			self.timer = 0;
			local cX, cY, cLoc = nil, nil, nil;
			local pX, pY = GetPlayerMapPosition("player");
			local fmtng = "%d, %d";

			local pLoc = OM_GREEN..(format( fmtng, pX * 100.0, pY * 100.0)).."|r\n";
			if ( OmegaMapFrame:IsVisible() ) then
				cX, cY = OmegaMapGetCLoc(OmegaMapFrame);
			else
				cX, cY = OmegaMapGetCLoc(OmegaMapFrame);
			end
			if ( ( cX ) and ( cY ) ) then
				cLoc = OM_YELLOW..( format( fmtng, cX, cY ) ).."|r";
			end
			OmegaMapLocationText:SetText( pLoc .. (cLoc or "") );

			OmegaMapCoordinates:SetWidth( OmegaMapLocationText:GetWidth() + 9 );
			if ( cLoc ) then
				OmegaMapCoordinates:SetHeight(48);
			else
				OmegaMapCoordinates:SetHeight(30);
			end

			--OmegaMapSetCoordsPos();
		end
	end
end

function OmegaMapSetCoordsPos()
	local x, y = OmegaMapConfig.coordsLocX, OmegaMapConfig.coordsLocY;

	local UnitScale = .8;
--[[
	OmegaMapCoordinates:ClearAllPoints();
	OmegaMapCoordinates:SetUserPlaced(0);
	OmegaMapCoordinates:SetParent(OmegaMapFrame);
	OmegaMapCoordinates:SetScale( UnitScale );
	OmegaMapCoordinates:SetPoint("CENTER", "OmegaMapFrame", "BOTTOMLEFT", x / UnitScale, y / UnitScale);
	OmegaMapCoordinates:SetFrameLevel( OmegaMapFrame:GetFrameLevel() + 3);
	OmegaMapCoordinates:Show();
	if ( not OmegaMapConfig.showCoords ) then
		OmegaMapCoordinates:Hide();
	end
	]]--
end

--Gets coords of cursor in relation to its positon over the map
function OmegaMapGetCLoc()
	local x, y = nil, nil;
	local activeFrame = nil

	if (OmegaMapAltMapFrame:IsShown()) then
		activeFrame = OmegaMapAltMapFrame
	else 
		activeFrame = OmegaMapDetailFrame
	end

	local x, y = GetCursorPosition()
	local left, top = activeFrame:GetLeft(), activeFrame:GetTop()
	local width = activeFrame:GetWidth()
	local height = activeFrame:GetHeight()
	local scale = activeFrame:GetEffectiveScale()
	local cx = (x/scale - left) / width
	local cy = (top - y/scale) / height

	if cx < 0 or cx > 1 or cy < 0 or cy > 1 then
		return nil, nil
	end

	return cx*100.000, cy*100.000;
end

--Solidifies the map is hot key is held
function OmegaMapSolidifyCheck(self,...)
	if (not OmegaMapButton:IsVisible()) then return end

	if (OmegaMapConfig.interactiveHotKey == nil) then return end

	local key, state = ...
	if string.match(key, string.upper(OmegaMapConfig.interactiveHotKey)) then
		if state==1 then
			OmegaMapSolidify("On")
			OmegaMapConfig.solidify = true
			OmegaMapLockButton:SetNormalTexture("Interface\\Buttons\\UI-MICROBUTTON-World-Up")
		elseif state==0 then
			if (OmegaMapConfig.keepInteractive) then
				return
			else
				OmegaMapLockButton:SetNormalTexture("Interface\\Buttons\\UI-MICROBUTTON-World-Disabled")
				OmegaMapSolidify("Off")
				OmegaMapConfig.solidify = false
			end
		end
	end
end