--[[
Name: LibBabble-Zone-3.0
Revision: $Rev: 347 $
Maintainers: ckknight, nevcairiel, Ackis
Website: http://www.wowace.com/projects/libbabble-zone-3-0/
Dependencies: None
License: MIT
]]

local MAJOR_VERSION = "LibBabble-Zone-3.0"
local MINOR_VERSION = 90000 + tonumber(("$Rev: 347 $"):match("%d+"))

if not LibStub then error(MAJOR_VERSION .. " requires LibStub.") end
local lib = LibStub("LibBabble-3.0"):New(MAJOR_VERSION, MINOR_VERSION)
if not lib then return end

local GAME_LOCALE = GetLocale()

lib:SetBaseTranslations {
	["Abyssal Depths"] = "Abyssal Depths",
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: The Old Kingdom",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Ahn'Qiraj: The Fallen Kingdom"] = "Ahn'Qiraj: The Fallen Kingdom",
	["Alliance Base"] = "Alliance Base",
	["Alterac Mountains"] = "Alterac Mountains",
	["Alterac Valley"] = "Alterac Valley",
	["Amani Pass"] = "Amani Pass",
	["Arathi Basin"] = "Arathi Basin",
	["Arathi Highlands"] = "Arathi Highlands",
	Armory = "Armory",
	Ashenvale = "Ashenvale",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Auchenai Crypts",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nerub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Azuremyst Isle",
	Badlands = "Badlands",
	["Baradin Hold"] = "Baradin Hold",
	["Bash'ir Landing"] = "Bash'ir Landing",
	["Battle for Gilneas"] = "Battle for Gilneas",
	["Blackfathom Deeps"] = "Blackfathom Deeps",
	["Blackrock Caverns"] = "Blackrock Caverns",
	["Blackrock Depths"] = "Blackrock Depths",
	["Blackrock Mountain"] = "Blackrock Mountain",
	["Blackrock Spire"] = "Blackrock Spire",
	["Black Temple"] = "Black Temple",
	["Blackwind Lake"] = "Blackwind Lake",
	["Blackwing Descent"] = "Blackwing Descent",
	["Blackwing Lair"] = "Blackwing Lair",
	["Blade's Edge Arena"] = "Blade's Edge Arena",
	["Blade's Edge Mountains"] = "Blade's Edge Mountains",
	["Blasted Lands"] = "Blasted Lands",
	["Bloodmyst Isle"] = "Bloodmyst Isle",
	["Booty Bay"] = "Booty Bay",
	["Borean Tundra"] = "Borean Tundra",
	["Burning Steppes"] = "Burning Steppes",
	Cathedral = "Cathedral",
	["Caverns of Time"] = "Caverns of Time",
	["Champions' Hall"] = "Champions' Hall",
	["Coilfang Reservoir"] = "Coilfang Reservoir",
	Coldarra = "Coldarra",
	["Cosmic map"] = "Cosmic map",
	["Crystalsong Forest"] = "Crystalsong Forest",
	["Crystal Spine"] = "Crystal Spine",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Dalaran Arena",
	["Dalaran Sewers"] = "Dalaran Sewers",
	["Darkmoon Faire"] = "Darkmoon Faire",
	["Darkmoon Island"] = "Darkmoon Island",
	Darkshore = "Darkshore",
	Darnassus = "Darnassus",
	Deadmines = "Deadmines",
	["Deadwind Pass"] = "Deadwind Pass",
	Deepholm = "Deepholm",
	["Deeprun Tram"] = "Deeprun Tram",
	Desolace = "Desolace",
	["Dire Maul"] = "Dire Maul",
	["Dire Maul (East)"] = "Dire Maul (East)",
	["Dire Maul (North)"] = "Dire Maul (North)",
	["Dire Maul (West)"] = "Dire Maul (West)",
	Dragonblight = "Dragonblight",
	["Dragon Soul"] = "Dragon Soul",
	["Drak'Tharon Keep"] = "Drak'Tharon Keep",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Duskwood",
	["Dustwallow Marsh"] = "Dustwallow Marsh",
	["Eastern Kingdoms"] = "Eastern Kingdoms",
	["Eastern Plaguelands"] = "Eastern Plaguelands",
	["Elwynn Forest"] = "Elwynn Forest",
	["End Time"] = "End Time",
	Everlook = "Everlook",
	["Eversong Woods"] = "Eversong Woods",
	["Eye of the Storm"] = "Eye of the Storm",
	Felwood = "Felwood",
	Feralas = "Feralas",
	Firelands = "Firelands",
	["Forge Camp: Terror"] = "Forge Camp: Terror",
	["Forge Camp: Wrath"] = "Forge Camp: Wrath",
	["Frostwyrm Lair"] = "Frostwyrm Lair",
	["Furywing's Perch"] = "Furywing's Perch",
	Gadgetzan = "Gadgetzan",
	["Gate of the Setting Sun"] = "Gate of the Setting Sun",
	["Gates of Ahn'Qiraj"] = "Gates of Ahn'Qiraj",
	Ghostlands = "Ghostlands",
	Gilneas = "Gilneas",
	["Gilneas City"] = "Gilneas City",
	Gnomeregan = "Gnomeregan",
	Graveyard = "Graveyard",
	["Grim Batol"] = "Grim Batol",
	["Grizzly Hills"] = "Grizzly Hills",
	["Grom'gol Base Camp"] = "Grom'gol Base Camp",
	["Gruul's Lair"] = "Gruul's Lair",
	Gundrak = "Gundrak",
	["Hall of Blackhand"] = "Hall of Blackhand",
	["Hall of Champions"] = "Hall of Champions",
	["Hall of Legends"] = "Hall of Legends",
	["Halls of Lightning"] = "Halls of Lightning",
	["Halls of Origination"] = "Halls of Origination",
	["Halls of Reflection"] = "Halls of Reflection",
	["Halls of Stone"] = "Halls of Stone",
	["Heart of Fear"] = "Heart of Fear",
	["Hellfire Citadel"] = "Hellfire Citadel",
	["Hellfire Peninsula"] = "Hellfire Peninsula",
	["Hellfire Ramparts"] = "Hellfire Ramparts",
	["Hillsbrad Foothills"] = "Hillsbrad Foothills",
	["Horde Encampment"] = "Horde Encampment",
	["Hour of Twilight"] = "Hour of Twilight",
	["Howling Fjord"] = "Howling Fjord",
	["Hrothgar's Landing"] = "Hrothgar's Landing",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "Hyjal Summit",
	Icecrown = "Icecrown",
	["Icecrown Citadel"] = "Icecrown Citadel",
	["Insidion's Perch"] = "Insidion's Perch",
	Ironforge = "Ironforge",
	["Isle of Conquest"] = "Isle of Conquest",
	["Isle of Quel'Danas"] = "Isle of Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Kelp'thar Forest"] = "Kelp'thar Forest",
	Kezan = "Kezan",
	["Krasus' Landing"] = "Krasus' Landing",
	Library = "Library",
	["Loch Modan"] = "Loch Modan",
	["Lost City of the Tol'vir"] = "Lost City of the Tol'vir",
	["Lower Blackrock Spire"] = "Lower Blackrock Spire",
	["Magisters' Terrace"] = "Magisters' Terrace",
	["Magtheridon's Lair"] = "Magtheridon's Lair",
	["Mana-Tombs"] = "Mana-Tombs",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Marshlight Lake",
	["Menethil Harbor"] = "Menethil Harbor",
	["Mogu'Shan Palace"] = "Mogu'Shan Palace",
	["Mogu'shan Vaults"] = "Mogu'shan Vaults",
	["Molten Core"] = "Molten Core",
	["Molten Front"] = "Molten Front",
	Moonglade = "Moonglade",
	["Mount Hyjal"] = "Mount Hyjal",
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Nagrand Arena",
	Naxxramas = "Naxxramas",
	Netherstorm = "Netherstorm",
	["Night Elf Village"] = "Night Elf Village",
	["Northern Barrens"] = "Northern Barrens",
	["Northern Stranglethorn"] = "Northern Stranglethorn",
	Northrend = "Northrend",
	["Obsidia's Perch"] = "Obsidia's Perch",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Old Hillsbrad Foothills",
	["Old Stratholme"] = "Old Stratholme",
	["Onyxia's Lair"] = "Onyxia's Lair",
	["Opening of the Dark Portal"] = "Opening of the Dark Portal",
	Orgrimmar = "Orgrimmar",
	Outland = "Outland",
	["Pit of Saron"] = "Pit of Saron",
	["Plaguelands: The Scarlet Enclave"] = "Plaguelands: The Scarlet Enclave",
	Plaguewood = "Plaguewood",
	["Quel'thalas"] = "Quel'thalas",
	["Ragefire Chasm"] = "Ragefire Chasm",
	Ratchet = "Ratchet",
	["Razorfen Downs"] = "Razorfen Downs",
	["Razorfen Kraul"] = "Razorfen Kraul",
	["Redridge Mountains"] = "Redridge Mountains",
	["Ring of Observance"] = "Ring of Observance",
	["Rivendark's Perch"] = "Rivendark's Perch",
	["Ruins of Ahn'Qiraj"] = "Ruins of Ahn'Qiraj",
	["Ruins of Gilneas"] = "Ruins of Gilneas",
	["Ruins of Gilneas City"] = "Ruins of Gilneas City",
	["Ruins of Lordaeron"] = "Ruins of Lordaeron",
	["Scalebeard's Cave"] = "Scalebeard's Cave",
	["Scarlet Monastery"] = "Scarlet Monastery",
	Scholomance = "Scholomance",
	["Searing Gorge"] = "Searing Gorge",
	["Serpent Lake"] = "Serpent Lake",
	["Serpentshrine Cavern"] = "Serpentshrine Cavern",
	["Sethekk Halls"] = "Sethekk Halls",
	["Shado-pan Monastery"] = "Shado-pan Monastery",
	["Shadowfang Keep"] = "Shadowfang Keep",
	["Shadow Labyrinth"] = "Shadow Labyrinth",
	["Shadowmoon Valley"] = "Shadowmoon Valley",
	["Shartuul's Transporter"] = "Shartuul's Transporter",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Shattrath City",
	["Shimmering Expanse"] = "Shimmering Expanse",
	["Sholazar Basin"] = "Sholazar Basin",
	["Siege of Niuzao Temple"] = "Siege of Niuzao Temple",
	Silithus = "Silithus",
	["Silvermoon City"] = "Silvermoon City",
	["Silverpine Forest"] = "Silverpine Forest",
	["Skyguard Outpost"] = "Skyguard Outpost",
	["Skysong Lake"] = "Skysong Lake",
	["Southern Barrens"] = "Southern Barrens",
	["Sporewind Lake"] = "Sporewind Lake",
	Stonard = "Stonard",
	["Stonetalon Mountains"] = "Stonetalon Mountains",
	["Stormstout Brewery"] = "Stormstout Brewery",
	Stormwind = "Stormwind",
	["Stormwind City"] = "Stormwind City",
	["Strand of the Ancients"] = "Strand of the Ancients",
	["Stranglethorn Vale"] = "Stranglethorn Vale",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "Sunken Temple",
	["Sunwell Plateau"] = "Sunwell Plateau",
	["Swamp of Sorrows"] = "Swamp of Sorrows",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "Tempest Keep",
	["Temple of Ahn'Qiraj"] = "Temple of Ahn'Qiraj",
	["Temple of the Jade Serpent"] = "Temple of the Jade Serpent",
	["Terokkar Forest"] = "Terokkar Forest",
	["Terokk's Rest"] = "Terokk's Rest",
	["Terrace of Endless Spring"] = "Terrace of Endless Spring",
	["The Arachnid Quarter"] = "The Arachnid Quarter",
	["The Arcatraz"] = "The Arcatraz",
	["The Argent Coliseum"] = "The Argent Coliseum",
	["The Barrens"] = "The Barrens",
	["The Bastion of Twilight"] = "The Bastion of Twilight",
	["The Battle for Gilneas"] = "The Battle for Gilneas",
	["The Black Morass"] = "The Black Morass",
	["The Blood Furnace"] = "The Blood Furnace",
	["The Bone Wastes"] = "The Bone Wastes",
	["The Botanica"] = "The Botanica",
	["The Cape of Stranglethorn"] = "The Cape of Stranglethorn",
	["The Construct Quarter"] = "The Construct Quarter",
	["The Culling of Stratholme"] = "The Culling of Stratholme",
	["The Dark Portal"] = "The Dark Portal",
	["The Deadmines"] = "The Deadmines",
	["The Descent into Madness"] = "The Descent into Madness",
	["The Dragon Wastes"] = "The Dragon Wastes",
	["The Escape From Durnholde"] = "The Escape From Durnholde",
	["The Exodar"] = "The Exodar",
	["The Eye"] = "The Eye",
	["The Eye of Eternity"] = "The Eye of Eternity",
	["The Forbidding Sea"] = "The Forbidding Sea",
	["The Forge of Souls"] = "The Forge of Souls",
	["The Frozen Halls"] = "The Frozen Halls",
	["The Frozen Sea"] = "The Frozen Sea",
	["The Great Sea"] = "The Great Sea",
	["The Halls of Winter"] = "The Halls of Winter",
	["The Hinterlands"] = "The Hinterlands",
	["The Lost Isles"] = "The Lost Isles",
	["The Maelstrom"] = "The Maelstrom",
	["The Mechanar"] = "The Mechanar",
	["The Military Quarter"] = "The Military Quarter",
	["The Molten Core"] = "The Molten Core",
	["The Nexus"] = "The Nexus",
	["The North Sea"] = "The North Sea",
	["The Obsidian Sanctum"] = "The Obsidian Sanctum",
	["The Oculus"] = "The Oculus",
	["The Plague Quarter"] = "The Plague Quarter",
	["The Prison of Yogg-Saron"] = "The Prison of Yogg-Saron",
	["Theramore Isle"] = "Theramore Isle",
	["The Ring of Valor"] = "The Ring of Valor",
	["The Ruby Sanctum"] = "The Ruby Sanctum",
	["The Scarlet Enclave"] = "The Scarlet Enclave",
	["The Shattered Halls"] = "The Shattered Halls",
	["The Slave Pens"] = "The Slave Pens",
	["The Spark of Imagination"] = "The Spark of Imagination",
	["The Steamvault"] = "The Steamvault",
	["The Stockade"] = "The Stockade",
	["The Stonecore"] = "The Stonecore",
	["The Storm Peaks"] = "The Storm Peaks",
	["The Temple of Atal'Hakkar"] = "The Temple of Atal'Hakkar",
	["The Underbog"] = "The Underbog",
	["The Veiled Sea"] = "The Veiled Sea",
	["The Violet Hold"] = "The Violet Hold",
	["The Vortex Pinnacle"] = "The Vortex Pinnacle",
	["Thousand Needles"] = "Thousand Needles",
	["Throne of the Four Winds"] = "Throne of the Four Winds",
	["Throne of the Tides"] = "Throne of the Tides",
	["Thunder Bluff"] = "Thunder Bluff",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Tirisfal Glades",
	["Tol Barad"] = "Tol Barad",
	["Tol Barad Peninsula"] = "Tol Barad Peninsula",
	["Trial of the Champion"] = "Trial of the Champion",
	["Trial of the Crusader"] = "Trial of the Crusader",
	["Twilight Highlands"] = "Twilight Highlands",
	["Twin Peaks"] = "Twin Peaks",
	["Twisting Nether"] = "Twisting Nether",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Uldum = "Uldum",
	Undercity = "Undercity",
	["Un'Goro Crater"] = "Un'Goro Crater",
	["Upper Blackrock Spire"] = "Upper Blackrock Spire",
	["Utgarde Keep"] = "Utgarde Keep",
	["Utgarde Pinnacle"] = "Utgarde Pinnacle",
	["Vashj'ir"] = "Vashj'ir",
	["Vault of Archavon"] = "Vault of Archavon",
	["Vortex Pinnacle"] = "Vortex Pinnacle",
	["Wailing Caverns"] = "Wailing Caverns",
	["Warsong Gulch"] = "Warsong Gulch",
	["Well of Eternity"] = "Well of Eternity",
	["Western Plaguelands"] = "Western Plaguelands",
	Westfall = "Westfall",
	Wetlands = "Wetlands",
	Wintergrasp = "Wintergrasp",
	Winterspring = "Winterspring",
	["Wyrmrest Temple"] = "Wyrmrest Temple",
	Zangarmarsh = "Zangarmarsh",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}


if GAME_LOCALE == "enUS" then
	lib:SetCurrentTranslations(true)
elseif GAME_LOCALE == "deDE" then
	lib:SetCurrentTranslations {
	["Abyssal Depths"] = "Abyssische Tiefen",
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: Das Alte Königreich",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Ahn'Qiraj: The Fallen Kingdom"] = "Ahn'Qiray: Das Gefallene Königreich",
	["Alliance Base"] = "Basis der Allianz",
	["Alterac Mountains"] = "Alteracgebirge",
	["Alterac Valley"] = "Alteractal",
	["Amani Pass"] = "Amanipass",
	["Arathi Basin"] = "Arathibecken",
	["Arathi Highlands"] = "Arathihochland",
	Armory = "Waffenkammer",
	Ashenvale = "Eschental",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Auchenaikrypta",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nerub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Azurmythosinsel",
	Badlands = "Ödland",
	["Baradin Hold"] = "Baradinfestung",
	["Bash'ir Landing"] = "Landeplatz von Bash'ir",
	["Battle for Gilneas"] = "Schlacht um Gilneas",
	["Blackfathom Deeps"] = "Tiefschwarze Grotte",
	["Blackrock Caverns"] = "Schwarzfelshöhlen",
	["Blackrock Depths"] = "Schwarzfelstiefen",
	["Blackrock Mountain"] = "Der Schwarzfels",
	["Blackrock Spire"] = "Schwarzfelsspitze",
	["Black Temple"] = "Der Schwarze Tempel",
	["Blackwind Lake"] = "Schattenwindsee",
	["Blackwing Descent"] = "Pechschwingenabstieg",
	["Blackwing Lair"] = "Pechschwingenhort",
	["Blade's Edge Arena"] = "Arena des Schergrats",
	["Blade's Edge Mountains"] = "Schergrat",
	["Blasted Lands"] = "Verwüstete Lande",
	["Bloodmyst Isle"] = "Blutmythosinsel",
	["Booty Bay"] = "Beutebucht",
	["Borean Tundra"] = "Boreanische Tundra",
	["Burning Steppes"] = "Brennende Steppe",
	Cathedral = "Kathedrale",
	["Caverns of Time"] = "Höhlen der Zeit",
	["Champions' Hall"] = "Halle der Champions",
	["Coilfang Reservoir"] = "Der Echsenkessel",
	Coldarra = "Kaltarra",
	["Cosmic map"] = "Kosmische Karte",
	["Crystalsong Forest"] = "Kristallsangwald",
	["Crystal Spine"] = "Kristallrücken",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Arena von Dalaran",
	["Dalaran Sewers"] = "Arena von Dalaran",
	["Darkmoon Faire"] = "Dunkelmond-Jahrmarkt",
	["Darkmoon Island"] = "Dunkelmondinsel",
	Darkshore = "Dunkelküste",
	Darnassus = "Darnassus",
	Deadmines = "Todesminen",
	["Deadwind Pass"] = "Gebirgspass der Totenwinde",
	Deepholm = "Tiefenheim",
	["Deeprun Tram"] = "Die Tiefenbahn",
	Desolace = "Desolace",
	["Dire Maul"] = "Düsterbruch",
	["Dire Maul (East)"] = "Düsterbruch (Ost)",
	["Dire Maul (North)"] = "Düsterbruch (Nord)",
	["Dire Maul (West)"] = "Düsterbruch (West)",
	Dragonblight = "Drachenöde",
	["Dragon Soul"] = "Drachenseele",
	["Drak'Tharon Keep"] = "Feste Drak'Tharon",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Dämmerwald",
	["Dustwallow Marsh"] = "Düstermarschen",
	["Eastern Kingdoms"] = "Östliche Königreiche",
	["Eastern Plaguelands"] = "Östliche Pestländer",
	["Elwynn Forest"] = "Wald von Elwynn",
	["End Time"] = "Die Endzeit",
	Everlook = "Ewige Warte",
	["Eversong Woods"] = "Immersangwald",
	["Eye of the Storm"] = "Auge des Sturms",
	Felwood = "Teufelswald",
	Feralas = "Feralas",
	Firelands = "Feuerlande",
	["Forge Camp: Terror"] = "Konstruktionslager: Terror",
	["Forge Camp: Wrath"] = "Konstruktionslager: Wut",
	["Frostwyrm Lair"] = "Frostwyrmbau",
	["Furywing's Perch"] = "Isidions Hort",
	Gadgetzan = "Gadgetzan",
	-- ["Gate of the Setting Sun"] = "",
	["Gates of Ahn'Qiraj"] = "Tore von Ahn'Qiraj",
	Ghostlands = "Geisterlande",
	Gilneas = "Gilneas",
	["Gilneas City"] = "Gilneas",
	Gnomeregan = "Gnomeregan",
	Graveyard = "Friedhof",
	["Grim Batol"] = "Grim Batol",
	["Grizzly Hills"] = "Grizzlyhügel",
	["Grom'gol Base Camp"] = "Basislager von Grom'gol",
	["Gruul's Lair"] = "Gruuls Unterschlupf",
	Gundrak = "Gundrak",
	["Hall of Blackhand"] = "Schwarzfausthalle",
	["Hall of Champions"] = "Halle der Champions",
	["Hall of Legends"] = "Halle der Legenden",
	["Halls of Lightning"] = "Die Hallen der Blitze",
	["Halls of Origination"] = "Hallen des Ursprungs",
	["Halls of Reflection"] = "Hallen der Reflexion",
	["Halls of Stone"] = "Die Hallen des Steins",
	-- ["Heart of Fear"] = "",
	["Hellfire Citadel"] = "Höllenfeuerzitadelle",
	["Hellfire Peninsula"] = "Höllenfeuerhalbinsel",
	["Hellfire Ramparts"] = "Höllenfeuerbollwerk",
	["Hillsbrad Foothills"] = "Vorgebirge des Hügellands",
	["Horde Encampment"] = "Lager der Horde",
	["Hour of Twilight"] = "Stunde des Zwielichts",
	["Howling Fjord"] = "Der Heulende Fjord",
	["Hrothgar's Landing"] = "Hrothgars Landestelle",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "Hyjalgipfel",
	Icecrown = "Eiskrone",
	["Icecrown Citadel"] = "Eiskronenzitadelle",
	["Insidion's Perch"] = "Isidions Hort",
	Ironforge = "Eisenschmiede",
	["Isle of Conquest"] = "Insel der Eroberung",
	["Isle of Quel'Danas"] = "Insel von Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Kelp'thar Forest"] = "Tang'tharwald",
	Kezan = "Kezan",
	["Krasus' Landing"] = "Krasus' Landeplatz",
	Library = "Bibliothek",
	["Loch Modan"] = "Loch Modan",
	["Lost City of the Tol'vir"] = "Die Verlorene Stadt der Tol'vir",
	["Lower Blackrock Spire"] = "Untere Schwarzfelsspitze",
	["Magisters' Terrace"] = "Terrasse der Magister",
	["Magtheridon's Lair"] = "Magtheridons Kammer",
	["Mana-Tombs"] = "Managruft",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Sumpflichtsee",
	["Menethil Harbor"] = "Hafen von Menethil",
	-- ["Mogu'Shan Palace"] = "",
	-- ["Mogu'shan Vaults"] = "",
	["Molten Core"] = "Geschmolzener Kern",
	["Molten Front"] = "Geschmolzene Front",
	Moonglade = "Mondlichtung",
	["Mount Hyjal"] = "Hyjal",
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Arena von Nagrand",
	Naxxramas = "Naxxramas",
	Netherstorm = "Nethersturm",
	["Night Elf Village"] = "Nachtelfen Dorf",
	["Northern Barrens"] = "Nördliches Brachland",
	["Northern Stranglethorn"] = "Nördliches Schlingendorntal",
	Northrend = "Nordend",
	["Obsidia's Perch"] = "Obsidias Hort",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Vorgebirge des Alten Hügellands",
	["Old Stratholme"] = "Alt-Stratholme",
	["Onyxia's Lair"] = "Onyxias Hort",
	["Opening of the Dark Portal"] = "Öffnung des Dunklen Portals",
	Orgrimmar = "Orgrimmar",
	Outland = "Scherbenwelt",
	["Pit of Saron"] = "Grube von Saron",
	["Plaguelands: The Scarlet Enclave"] = "Pestländer: Die Scharlachrote Enklave",
	Plaguewood = "Seuchenwald",
	["Quel'thalas"] = "Quel'Thalas",
	["Ragefire Chasm"] = "Der Flammenschlund",
	Ratchet = "Ratschet",
	["Razorfen Downs"] = "Hügel der Klingenhauer",
	["Razorfen Kraul"] = "Kral der Klingenhauer",
	["Redridge Mountains"] = "Rotkammgebirge",
	["Ring of Observance"] = "Ring der Beobachtung",
	["Rivendark's Perch"] = "Nachtreißers Hort",
	["Ruins of Ahn'Qiraj"] = "Ruinen von Ahn'Qiraj",
	["Ruins of Gilneas"] = "Ruinen von Gilneas",
	["Ruins of Gilneas City"] = "Ruinen von Gilneas",
	["Ruins of Lordaeron"] = "Ruinen von Lordaeron",
	["Scalebeard's Cave"] = "Schuppenbarts Höhle",
	["Scarlet Monastery"] = "Das Scharlachrote Kloster",
	Scholomance = "Scholomance",
	["Searing Gorge"] = "Sengende Schlucht",
	["Serpent Lake"] = "Schlangensee",
	["Serpentshrine Cavern"] = "Höhle des Schlangenschreins",
	["Sethekk Halls"] = "Sethekkhallen",
	-- ["Shado-pan Monastery"] = "",
	["Shadowfang Keep"] = "Burg Schattenfang",
	["Shadow Labyrinth"] = "Schattenlabyrinth",
	["Shadowmoon Valley"] = "Schattenmondtal",
	["Shartuul's Transporter"] = "Shartuuls Transporter",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Shattrath",
	["Shimmering Expanse"] = "Schimmernde Weiten",
	["Sholazar Basin"] = "Sholazarbecken",
	-- ["Siege of Niuzao Temple"] = "",
	Silithus = "Silithus",
	["Silvermoon City"] = "Silbermond",
	["Silverpine Forest"] = "Silberwald",
	["Skyguard Outpost"] = "Außenposten der Himmelswache",
	["Skysong Lake"] = "Himmelsweisensee",
	["Southern Barrens"] = "Südliches Brachland",
	["Sporewind Lake"] = "Sporenwindsee",
	Stonard = "Steinard",
	["Stonetalon Mountains"] = "Steinkrallengebirge",
	-- ["Stormstout Brewery"] = "",
	Stormwind = "Sturmwind",
	["Stormwind City"] = "Sturmwind",
	["Strand of the Ancients"] = "Strand der Uralten",
	["Stranglethorn Vale"] = "Schlingendorntal",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "Versunkener Tempel",
	["Sunwell Plateau"] = "Sonnenbrunnenplateau",
	["Swamp of Sorrows"] = "Sümpfe des Elends",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "Festung der Stürme",
	["Temple of Ahn'Qiraj"] = "Tempel von Ahn'Qiraj",
	-- ["Temple of the Jade Serpent"] = "",
	["Terokkar Forest"] = "Wälder von Terokkar",
	["Terokk's Rest"] = "Terokks Ruh",
	-- ["Terrace of Endless Spring"] = "",
	["The Arachnid Quarter"] = "Das Arachnidenviertel",
	["The Arcatraz"] = "Die Arkatraz",
	["The Argent Coliseum"] = "Das Kolosseum der Kreuzfahrer",
	["The Barrens"] = "Brachland",
	["The Bastion of Twilight"] = "Die Bastion des Zwielichts",
	["The Battle for Gilneas"] = "Die Schlacht um Gilneas",
	["The Black Morass"] = "Der schwarze Morast",
	["The Blood Furnace"] = "Der Blutkessel",
	["The Bone Wastes"] = "Die Knochenwüste",
	["The Botanica"] = "Die Botanika",
	["The Cape of Stranglethorn"] = "Das Schlingendornkap",
	["The Construct Quarter"] = "Das Konstruktviertel",
	["The Culling of Stratholme"] = "Das Ausmerzen von Stratholme",
	["The Dark Portal"] = "Das Dunkle Portal",
	["The Deadmines"] = "Die Todesminen",
	["The Descent into Madness"] = "Der Abstieg in den Wahnsinn",
	-- ["The Dragon Wastes"] = "",
	["The Escape From Durnholde"] = "Flucht aus Burg Durnholde",
	["The Exodar"] = "Die Exodar",
	["The Eye"] = "Festung der Stürme",
	["The Eye of Eternity"] = "Das Auge der Ewigkeit",
	["The Forbidding Sea"] = "Das verbotene Meer",
	["The Forge of Souls"] = "Die Schmiede der Seelen",
	["The Frozen Halls"] = "Die gefrorenen Hallen",
	["The Frozen Sea"] = "Die gefrorene See",
	["The Great Sea"] = "Das große Meer",
	["The Halls of Winter"] = "Die Hallen des Winters",
	["The Hinterlands"] = "Hinterland",
	["The Lost Isles"] = "Die Verlorenen Inseln",
	["The Maelstrom"] = "Der Mahlstrom",
	["The Mechanar"] = "Die Mechanar",
	["The Military Quarter"] = "Das Militärviertel",
	["The Molten Core"] = "Der Geschmolzene Kern", -- Needs review
	["The Nexus"] = "Der Nexus",
	["The North Sea"] = "Das nördliche Meer",
	["The Obsidian Sanctum"] = "Das Obsidiansanktum",
	["The Oculus"] = "Das Oculus",
	["The Plague Quarter"] = "Das Seuchenviertel",
	["The Prison of Yogg-Saron"] = "Das Gefängnis von Yogg-Saron",
	["Theramore Isle"] = "Insel Theramore",
	["The Ring of Valor"] = "Der Ring der Ehre",
	["The Ruby Sanctum"] = "Das Rubinsanktum",
	["The Scarlet Enclave"] = "Die Scharlachrote Enklave",
	["The Shattered Halls"] = "Die zerschmetterten Hallen",
	["The Slave Pens"] = "Die Sklavenunterkünfte",
	["The Spark of Imagination"] = "Der Funke der Imagination",
	["The Steamvault"] = "Die Dampfkammer",
	["The Stockade"] = "Das Verlies",
	["The Stonecore"] = "Der Steinerne Kern",
	["The Storm Peaks"] = "Die Sturmgipfel",
	["The Temple of Atal'Hakkar"] = "Der Tempel von Atal'Hakkar",
	["The Underbog"] = "Der Tiefensumpf",
	["The Veiled Sea"] = "Das verhüllte Meer",
	["The Violet Hold"] = "Die Violette Festung",
	["The Vortex Pinnacle"] = "Der Vortexgipfel",
	["Thousand Needles"] = "Tausend Nadeln",
	["Throne of the Four Winds"] = "Thron der Vier Winde",
	["Throne of the Tides"] = "Thron der Gezeiten",
	["Thunder Bluff"] = "Donnerfels",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Tirisfal",
	["Tol Barad"] = "Tol Barad",
	["Tol Barad Peninsula"] = "Halbinsel von Tol Barad",
	["Trial of the Champion"] = "Prüfung des Champions",
	["Trial of the Crusader"] = "Prüfung des Kreuzfahrers",
	["Twilight Highlands"] = "Schattenhochland",
	["Twin Peaks"] = "Zwillingsgipfel",
	["Twisting Nether"] = "Wirbelnder Nether",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Uldum = "Uldum",
	Undercity = "Unterstadt",
	["Un'Goro Crater"] = "Krater von Un'Goro",
	["Upper Blackrock Spire"] = "Obere Schwarzfelsspitze",
	["Utgarde Keep"] = "Burg Utgarde",
	["Utgarde Pinnacle"] = "Turm Utgarde",
	["Vashj'ir"] = "Vashj'ir",
	["Vault of Archavon"] = "Archavons Kammer",
	["Vortex Pinnacle"] = "Vortexgipfel",
	["Wailing Caverns"] = "Die Höhlen des Wehklagens",
	["Warsong Gulch"] = "Kriegshymnenschlucht",
	["Well of Eternity"] = "Brunnen der Ewigkeit",
	["Western Plaguelands"] = "Westliche Pestländer",
	Westfall = "Westfall",
	Wetlands = "Sumpfland",
	Wintergrasp = "Tausendwintersee",
	Winterspring = "Winterquell",
	["Wyrmrest Temple"] = "Wyrmruhtempel",
	Zangarmarsh = "Zangarmarschen",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}
elseif GAME_LOCALE == "frFR" then
	lib:SetCurrentTranslations {
	["Abyssal Depths"] = "Profondeurs Abyssales",
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet : l'Ancien royaume",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Ahn'Qiraj: The Fallen Kingdom"] = "Ahn'Qiraj : le royaume Déchu",
	["Alliance Base"] = "Base de l'Alliance",
	["Alterac Mountains"] = "Montagnes d'Alterac",
	["Alterac Valley"] = "Vallée d'Alterac",
	["Amani Pass"] = "Passage des Amani",
	["Arathi Basin"] = "Bassin Arathi",
	["Arathi Highlands"] = "Hautes-terres Arathies",
	Armory = "Armurerie",
	Ashenvale = "Orneval",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Cryptes Auchenaï",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nérub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Île de Brume-Azur",
	Badlands = "Terres Ingrates",
	["Baradin Hold"] = "Bastion de Baradin",
	["Bash'ir Landing"] = "Point d'ancrage de Bash'ir",
	["Battle for Gilneas"] = "Bataille de Gilnéas",
	["Blackfathom Deeps"] = "Profondeurs de Brassenoire",
	["Blackrock Caverns"] = "Cavernes de Rochenoire",
	["Blackrock Depths"] = "Profondeurs de Rochenoire",
	["Blackrock Mountain"] = "Mont Rochenoire",
	["Blackrock Spire"] = "Pic Rochenoire",
	["Black Temple"] = "Temple noir",
	["Blackwind Lake"] = "Lac Noirvent",
	["Blackwing Descent"] = "Descente de l'Aile noire",
	["Blackwing Lair"] = "Repaire de l'Aile noire",
	["Blade's Edge Arena"] = "Arène des Tranchantes",
	["Blade's Edge Mountains"] = "Les Tranchantes",
	["Blasted Lands"] = "Terres Foudroyées",
	["Bloodmyst Isle"] = "Île de Brume-Sang",
	["Booty Bay"] = "Baie-du-Butin",
	["Borean Tundra"] = "Toundra Boréenne",
	["Burning Steppes"] = "Steppes Ardentes",
	Cathedral = "Cathédrale",
	["Caverns of Time"] = "Grottes du temps",
	["Champions' Hall"] = "Hall des Champions",
	["Coilfang Reservoir"] = "Réservoir de Glissecroc",
	Coldarra = "Frimarra",
	["Cosmic map"] = "Carte cosmique",
	["Crystalsong Forest"] = "Forêt du Chant de cristal",
	["Crystal Spine"] = "Éperon de cristal",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Arène de Dalaran",
	["Dalaran Sewers"] = "Égouts de Dalaran",
	["Darkmoon Faire"] = "Foire de Sombrelune",
	["Darkmoon Island"] = "Île de Sombrelune",
	Darkshore = "Sombrivage",
	Darnassus = "Darnassus",
	Deadmines = "Mortemines",
	["Deadwind Pass"] = "Défilé de Deuillevent",
	Deepholm = "Le Tréfonds",
	["Deeprun Tram"] = "Tram des profondeurs",
	Desolace = "Désolace",
	["Dire Maul"] = "Hache-tripes",
	["Dire Maul (East)"] = "Hache-tripes (Est)",
	["Dire Maul (North)"] = "Hache-tripes (Nord)",
	["Dire Maul (West)"] = "Hache-tripes (Ouest)",
	Dragonblight = "Désolation des dragons",
	["Dragon Soul"] = "L’Âme des dragons",
	["Drak'Tharon Keep"] = "Donjon de Drak'Tharon",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Bois de la Pénombre",
	["Dustwallow Marsh"] = "Marécage d'Âprefange",
	["Eastern Kingdoms"] = "Royaumes de l'est",
	["Eastern Plaguelands"] = "Maleterres de l'Est",
	["Elwynn Forest"] = "Forêt d'Elwynn",
	["End Time"] = "La Fin des temps",
	Everlook = "Long-Guet",
	["Eversong Woods"] = "Bois des Chants éternels",
	["Eye of the Storm"] = "L'Œil du cyclone",
	Felwood = "Gangrebois",
	Feralas = "Féralas",
	Firelands = "Terres de Feu",
	["Forge Camp: Terror"] = "Camp de forge : Terreur",
	["Forge Camp: Wrath"] = "Camp de forge : Courroux",
	["Frostwyrm Lair"] = "Repaire du wyrm de givre",
	["Furywing's Perch"] = "Perchoir d'Aile-furie",
	Gadgetzan = "Gadgetzan",
	-- ["Gate of the Setting Sun"] = "",
	["Gates of Ahn'Qiraj"] = "Portes d'Ahn'Qiraj",
	Ghostlands = "Les terres Fantômes",
	Gilneas = "Gilnéas",
	["Gilneas City"] = "Gilnéas",
	Gnomeregan = "Gnomeregan",
	Graveyard = "Cimetière",
	["Grim Batol"] = "Grim Batol",
	["Grizzly Hills"] = "Les Grisonnes",
	["Grom'gol Base Camp"] = "Campement Grom'gol",
	["Gruul's Lair"] = "Repaire de Gruul",
	Gundrak = "Gundrak",
	["Hall of Blackhand"] = "Hall de Main-noire",
	["Hall of Champions"] = "Hall des Champions",
	["Hall of Legends"] = "Hall des Légendes",
	["Halls of Lightning"] = "Les salles de Foudre",
	["Halls of Origination"] = "Salles de l'Origine",
	["Halls of Reflection"] = "Les salles des Reflets",
	["Halls of Stone"] = "Les salles de Pierre",
	-- ["Heart of Fear"] = "",
	["Hellfire Citadel"] = "Citadelle des Flammes infernales",
	["Hellfire Peninsula"] = "Péninsule des Flammes infernales",
	["Hellfire Ramparts"] = "Remparts des Flammes infernales",
	["Hillsbrad Foothills"] = "Contreforts de Hautebrande",
	["Horde Encampment"] = "Campement de la Horde",
	["Hour of Twilight"] = "L'heure du Crépuscule",
	["Howling Fjord"] = "Fjord Hurlant",
	["Hrothgar's Landing"] = "Accostage de Hrothgar",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "Sommet d'Hyjal",
	Icecrown = "La Couronne de glace",
	["Icecrown Citadel"] = "Citadelle de la Couronne de glace",
	["Insidion's Perch"] = "Perchoir d'Insidion",
	Ironforge = "Forgefer",
	["Isle of Conquest"] = "Île des Conquérants",
	["Isle of Quel'Danas"] = "Île de Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Kelp'thar Forest"] = "Forêt de Varech'thar",
	Kezan = "Kezan",
	["Krasus' Landing"] = "Aire de Krasus",
	Library = "Bibliothèque",
	["Loch Modan"] = "Loch Modan",
	["Lost City of the Tol'vir"] = "Cité perdue des Tol'vir",
	["Lower Blackrock Spire"] = "Pic de Rochenoire inférieur",
	["Magisters' Terrace"] = "Terrasse des Magistères",
	["Magtheridon's Lair"] = "Le repaire de Magtheridon",
	["Mana-Tombs"] = "Tombes-mana",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Lac des furoles",
	["Menethil Harbor"] = "Port de Menethil",
	-- ["Mogu'Shan Palace"] = "",
	-- ["Mogu'shan Vaults"] = "",
	["Molten Core"] = "Cœur du Magma",
	["Molten Front"] = "Front du Magma",
	Moonglade = "Reflet-de-Lune",
	["Mount Hyjal"] = "Mont Hyjal",
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Arène de Nagrand",
	Naxxramas = "Naxxramas",
	Netherstorm = "Raz-de-Néant",
	["Night Elf Village"] = "Village elfe de la nuit",
	["Northern Barrens"] = "Tarides du Nord",
	["Northern Stranglethorn"] = "Strangleronce septentrionale",
	Northrend = "Norfendre",
	["Obsidia's Perch"] = "Perchoir d'Obsidia",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Contreforts de Hautebrande d'antan",
	["Old Stratholme"] = "L'Épuration de Stratholme",
	["Onyxia's Lair"] = "Repaire d'Onyxia",
	["Opening of the Dark Portal"] = "Ouverture de la Porte des ténèbres",
	Orgrimmar = "Orgrimmar",
	Outland = "Outreterre",
	["Pit of Saron"] = "Fosse de Saron",
	["Plaguelands: The Scarlet Enclave"] = "Maleterres : l'enclave Écarlate",
	Plaguewood = "Pestebois",
	["Quel'thalas"] = "Quel'thalas",
	["Ragefire Chasm"] = "Gouffre de Ragefeu",
	Ratchet = "Cabestan",
	["Razorfen Downs"] = "Souilles de Tranchebauge",
	["Razorfen Kraul"] = "Kraal de Tranchebauge",
	["Redridge Mountains"] = "Les Carmines",
	["Ring of Observance"] = "Cercle d'observance",
	["Rivendark's Perch"] = "Perchoir de Clivenuit",
	["Ruins of Ahn'Qiraj"] = "Ruines d'Ahn'Qiraj",
	["Ruins of Gilneas"] = "Ruines de Gilnéas",
	["Ruins of Gilneas City"] = "Ruines de Gilnéas (ville)",
	["Ruins of Lordaeron"] = "Ruines de Lordaeron",
	["Scalebeard's Cave"] = "Caverne de Barbe-d'écailles",
	["Scarlet Monastery"] = "Monastère écarlate",
	Scholomance = "Scholomance",
	["Searing Gorge"] = "Gorge des Vents brûlants",
	["Serpent Lake"] = "Lac des Serpents",
	["Serpentshrine Cavern"] = "Caverne du sanctuaire du Serpent",
	["Sethekk Halls"] = "Les salles des Sethekk",
	-- ["Shado-pan Monastery"] = "",
	["Shadowfang Keep"] = "Donjon d'Ombrecroc",
	["Shadow Labyrinth"] = "Labyrinthe des ombres",
	["Shadowmoon Valley"] = "Vallée d'Ombrelune",
	["Shartuul's Transporter"] = "Transporteur de Shartuul",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Shattrath",
	["Shimmering Expanse"] = "Étendues Chatoyantes",
	["Sholazar Basin"] = "Bassin de Sholazar",
	-- ["Siege of Niuzao Temple"] = "",
	Silithus = "Silithus",
	["Silvermoon City"] = "Lune-d'argent",
	["Silverpine Forest"] = "Forêt des Pins Argentés",
	["Skyguard Outpost"] = "Avant-poste de la Garde-ciel",
	["Skysong Lake"] = "Lac Chanteciel",
	["Southern Barrens"] = "Tarides du Sud",
	["Sporewind Lake"] = "Lac Ventespore",
	Stonard = "Pierrêche",
	["Stonetalon Mountains"] = "Les Serres-Rocheuses",
	-- ["Stormstout Brewery"] = "",
	Stormwind = "Hurlevent",
	["Stormwind City"] = "Hurlevent",
	["Strand of the Ancients"] = "Rivage des anciens",
	["Stranglethorn Vale"] = "Vallée de Strangleronce",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "Temple englouti",
	["Sunwell Plateau"] = "Plateau du Puits de soleil",
	["Swamp of Sorrows"] = "Marais des Chagrins",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "Donjon de la Tempête",
	["Temple of Ahn'Qiraj"] = "Le temple d'Ahn'Qiraj",
	-- ["Temple of the Jade Serpent"] = "",
	["Terokkar Forest"] = "Forêt de Terokkar",
	["Terokk's Rest"] = "Repos de Terokk",
	-- ["Terrace of Endless Spring"] = "",
	["The Arachnid Quarter"] = "Le quartier des Arachnides",
	["The Arcatraz"] = "L'Arcatraz",
	["The Argent Coliseum"] = "Le colisée d'Argent",
	["The Barrens"] = "Les Tarides",
	["The Bastion of Twilight"] = "Le bastion du Crépuscule",
	["The Battle for Gilneas"] = "La bataille de Gilnéas",
	["The Black Morass"] = "Le Noir Marécage",
	["The Blood Furnace"] = "La Fournaise du sang",
	["The Bone Wastes"] = "Le désert des Ossements",
	["The Botanica"] = "La Botanica",
	["The Cape of Stranglethorn"] = "Cap Strangleronce",
	["The Construct Quarter"] = "Le quartier des Assemblages",
	["The Culling of Stratholme"] = "L'Épuration de Stratholme",
	["The Dark Portal"] = "La Porte des ténèbres",
	["The Deadmines"] = "Les Mortemines",
	["The Descent into Madness"] = "La Descente dans la folie",
	["The Dragon Wastes"] = "Le Désert des Dragons", -- Needs review
	["The Escape From Durnholde"] = "L'évasion de Fort-de-Durn",
	["The Exodar"] = "L'Exodar",
	["The Eye"] = "L'Œil",
	["The Eye of Eternity"] = "L'Œil de l'éternité",
	["The Forbidding Sea"] = "La Mer interdite",
	["The Forge of Souls"] = "La Forge des Âmes",
	["The Frozen Halls"] = "Les salles Gelées",
	["The Frozen Sea"] = "La mer Gelée",
	["The Great Sea"] = "La Grande mer",
	["The Halls of Winter"] = "Les salles de l'Hiver",
	["The Hinterlands"] = "Les Hinterlands",
	["The Lost Isles"] = "Les îles Perdues",
	["The Maelstrom"] = "Le Maelström",
	["The Mechanar"] = "Le Méchanar",
	["The Military Quarter"] = "Le quartier Militaire",
	["The Molten Core"] = "Le Cœur du Magma",
	["The Nexus"] = "Le Nexus",
	["The North Sea"] = "La mer Boréale",
	["The Obsidian Sanctum"] = "Le sanctum Obsidien",
	["The Oculus"] = "L'Oculus",
	["The Plague Quarter"] = "Le quartier de la Peste",
	["The Prison of Yogg-Saron"] = "La prison de Yogg-Saron",
	["Theramore Isle"] = "Île de Theramore",
	["The Ring of Valor"] = "L'Arène des valeureux",
	["The Ruby Sanctum"] = "Le sanctum Rubis",
	["The Scarlet Enclave"] = "L'enclave Écarlate",
	["The Shattered Halls"] = "Les Salles brisées",
	["The Slave Pens"] = "Les enclos aux esclaves",
	["The Spark of Imagination"] = "L'Étincelle d'imagination",
	["The Steamvault"] = "Le Caveau de la vapeur",
	["The Stockade"] = "La Prison",
	["The Stonecore"] = "Le Cœur-de-pierre",
	["The Storm Peaks"] = "Les pics Foudroyés",
	["The Temple of Atal'Hakkar"] = "Le temple d'Atal'Hakkar",
	["The Underbog"] = "La Basse-tourbière",
	["The Veiled Sea"] = "La Mer voilée",
	["The Violet Hold"] = "Le fort Pourpre",
	["The Vortex Pinnacle"] = "La cime du Vortex",
	["Thousand Needles"] = "Mille pointes",
	["Throne of the Four Winds"] = "Trône des quatre vents",
	["Throne of the Tides"] = "Trône des marées",
	["Thunder Bluff"] = "Les Pitons-du-Tonnerre",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Clairières de Tirisfal",
	["Tol Barad"] = "Tol Barad",
	["Tol Barad Peninsula"] = "Péninsule de Tol Barad",
	["Trial of the Champion"] = "L'épreuve du champion",
	["Trial of the Crusader"] = "L'épreuve du croisé",
	["Twilight Highlands"] = "Hautes-terres du Crépuscule",
	["Twin Peaks"] = "Pics-Jumeaux",
	["Twisting Nether"] = "Le Néant distordu",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Uldum = "Uldum",
	Undercity = "Fossoyeuse",
	["Un'Goro Crater"] = "Cratère d'Un'Goro",
	["Upper Blackrock Spire"] = "Pic de Rochenoire supérieur",
	["Utgarde Keep"] = "Donjon d'Utgarde",
	["Utgarde Pinnacle"] = "Cime d'Utgarde",
	["Vashj'ir"] = "Vashj'ir",
	["Vault of Archavon"] = "Caveau d'Archavon",
	["Vortex Pinnacle"] = "La cime du Vortex",
	["Wailing Caverns"] = "Cavernes des lamentations",
	["Warsong Gulch"] = "Goulet des Chanteguerres",
	["Well of Eternity"] = "Puits d'Éternité",
	["Western Plaguelands"] = "Maleterres de l'Ouest",
	Westfall = "Marche de l'Ouest",
	Wetlands = "Les Paluns",
	Wintergrasp = "Joug-d'hiver",
	Winterspring = "Berceau-de-l'Hiver",
	["Wyrmrest Temple"] = "Temple du Repos du ver",
	Zangarmarsh = "Marécage de Zangar",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}
elseif GAME_LOCALE == "koKR" then
	lib:SetCurrentTranslations {
	["Abyssal Depths"] = "심연의 나락",
	["Ahn'kahet: The Old Kingdom"] = "안카헤트: 고대 왕국",
	["Ahn'Qiraj"] = "안퀴라즈",
	["Ahn'Qiraj: The Fallen Kingdom"] = "안퀴라즈: 무너진 왕국",
	["Alliance Base"] = "얼라이언스 주둔지",
	["Alterac Mountains"] = "알터랙 산맥",
	["Alterac Valley"] = "알터랙 계곡",
	["Amani Pass"] = "아마니 고개",
	["Arathi Basin"] = "아라시 분지",
	["Arathi Highlands"] = "아라시 고원",
	Armory = "무기고",
	Ashenvale = "잿빛 골짜기",
	Auberdine = "아우버다인",
	["Auchenai Crypts"] = "아키나이 납골당",
	Auchindoun = "아킨둔",
	Azeroth = "아제로스",
	["Azjol-Nerub"] = "아졸네룹",
	Azshara = "아즈샤라",
	["Azuremyst Isle"] = "하늘안개 섬",
	Badlands = "황야의 땅",
	["Baradin Hold"] = "바라딘 요새",
	["Bash'ir Landing"] = "바쉬르 영지",
	["Battle for Gilneas"] = "길니아스 전투",
	["Blackfathom Deeps"] = "검은심연의 나락",
	["Blackrock Caverns"] = "검은바위 동굴",
	["Blackrock Depths"] = "검은바위 나락",
	["Blackrock Mountain"] = "검은바위 산",
	["Blackrock Spire"] = "검은바위 첨탑",
	["Black Temple"] = "검은 사원",
	["Blackwind Lake"] = "검은바람 호수",
	["Blackwing Descent"] = "검은날개 강림지",
	["Blackwing Lair"] = "검은날개 둥지",
	["Blade's Edge Arena"] = "칼날 투기장",
	["Blade's Edge Mountains"] = "칼날 산맥",
	["Blasted Lands"] = "저주받은 땅",
	["Bloodmyst Isle"] = "핏빛안개 섬",
	["Booty Bay"] = "무법항",
	["Borean Tundra"] = "북풍의 땅",
	["Burning Steppes"] = "불타는 평원",
	Cathedral = "대성당",
	["Caverns of Time"] = "시간의 동굴",
	["Champions' Hall"] = "용사의 전당",
	["Coilfang Reservoir"] = "갈퀴송곳니 저수지",
	Coldarra = "콜다라",
	["Cosmic map"] = "세계 지도",
	["Crystalsong Forest"] = "수정노래 숲",
	["Crystal Spine"] = "수정 돌기",
	Dalaran = "달라란",
	["Dalaran Arena"] = "달라란 투기장",
	["Dalaran Sewers"] = "달라란 하수도",
	["Darkmoon Faire"] = "다크문 축제",
	["Darkmoon Island"] = "다크문 축제",
	Darkshore = "어둠의 해안",
	Darnassus = "다르나서스",
	Deadmines = "죽음의 폐광",
	["Deadwind Pass"] = "저승바람 고개",
	Deepholm = "심원의 영지",
	["Deeprun Tram"] = "깊은굴 지하철",
	Desolace = "잊혀진 땅",
	["Dire Maul"] = "혈투의 전장",
	["Dire Maul (East)"] = "혈투의 전장 동부",
	["Dire Maul (North)"] = "혈투의 전장 북부",
	["Dire Maul (West)"] = "혈투의 전장 서부",
	Dragonblight = "용의 안식처",
	["Dragon Soul"] = "용의 영혼",
	["Drak'Tharon Keep"] = "드락타론 성채",
	["Dun Morogh"] = "던 모로",
	Durotar = "듀로타",
	Duskwood = "그늘숲",
	["Dustwallow Marsh"] = "먼지진흙 습지대",
	["Eastern Kingdoms"] = "동부 왕국",
	["Eastern Plaguelands"] = "동부 역병지대",
	["Elwynn Forest"] = "엘윈 숲",
	["End Time"] = "시간의 끝",
	Everlook = "눈망루 마을",
	["Eversong Woods"] = "영원노래 숲",
	["Eye of the Storm"] = "폭풍의 눈",
	Felwood = "악령의 숲",
	Feralas = "페랄라스",
	Firelands = "불의 땅",
	["Forge Camp: Terror"] = "공포의 괴철로 기지",
	["Forge Camp: Wrath"] = "격노의 괴철로 기지",
	["Frostwyrm Lair"] = "서리고룡의 방",
	["Furywing's Perch"] = "퓨리윙의 둥지",
	Gadgetzan = "가젯잔",
	-- ["Gate of the Setting Sun"] = "",
	["Gates of Ahn'Qiraj"] = "안퀴라즈 성문",
	Ghostlands = "유령의 땅",
	Gilneas = "길니아스",
	["Gilneas City"] = "길니아스 시",
	Gnomeregan = "놈리건",
	Graveyard = "묘지",
	["Grim Batol"] = "그림 바톨",
	["Grizzly Hills"] = "회색 구릉지",
	["Grom'gol Base Camp"] = "그롬골 주둔지",
	["Gruul's Lair"] = "그룰의 둥지",
	Gundrak = "군드락",
	["Hall of Blackhand"] = "검은손 전당",
	["Hall of Champions"] = "용사의 전당",
	["Hall of Legends"] = "전설의 전당",
	["Halls of Lightning"] = "번개의 전당",
	["Halls of Origination"] = "시초의 전당",
	["Halls of Reflection"] = "투영의 전당",
	["Halls of Stone"] = "돌의 전당",
	-- ["Heart of Fear"] = "",
	["Hellfire Citadel"] = "지옥불 성채",
	["Hellfire Peninsula"] = "지옥불 반도",
	["Hellfire Ramparts"] = "지옥불 성루",
	["Hillsbrad Foothills"] = "언덕마루 구릉지",
	["Horde Encampment"] = "호드 야영지",
	["Hour of Twilight"] = "황혼의 시간",
	["Howling Fjord"] = "울부짖는 협만",
	["Hrothgar's Landing"] = "흐로스가르 상륙지",
	Hyjal = "하이잘",
	["Hyjal Summit"] = "하이잘 정상",
	Icecrown = "얼음왕관",
	["Icecrown Citadel"] = "얼음왕관 성채",
	["Insidion's Perch"] = "인시디온의 둥지",
	Ironforge = "아이언포지",
	["Isle of Conquest"] = "정복의 섬",
	["Isle of Quel'Danas"] = "쿠엘다나스 섬",
	Kalimdor = "칼림도어",
	Karazhan = "카라잔",
	["Kelp'thar Forest"] = "켈프타르 숲",
	Kezan = "케잔",
	["Krasus' Landing"] = "크라서스 착륙장",
	Library = "도서관",
	["Loch Modan"] = "모단 호수",
	["Lost City of the Tol'vir"] = "톨비르의 잃어버린 도시",
	["Lower Blackrock Spire"] = "검은바위 첨탑 하층",
	["Magisters' Terrace"] = "마법학자의 정원",
	["Magtheridon's Lair"] = "마그테리돈의 둥지",
	["Mana-Tombs"] = "마나 무덤",
	Maraudon = "마라우돈",
	["Marshlight Lake"] = "수렁등불 호수",
	["Menethil Harbor"] = "메네실 항구",
	-- ["Mogu'Shan Palace"] = "",
	-- ["Mogu'shan Vaults"] = "",
	["Molten Core"] = "화산 심장부",
	["Molten Front"] = "녹아내린 전초지",
	Moonglade = "달의 숲",
	["Mount Hyjal"] = "하이잘 산",
	Mulgore = "멀고어",
	Nagrand = "나그란드",
	["Nagrand Arena"] = "나그란드 투기장",
	Naxxramas = "낙스라마스",
	Netherstorm = "황천의 폭풍",
	["Night Elf Village"] = "나이트 엘프 마을",
	["Northern Barrens"] = "북부 불모의 땅",
	["Northern Stranglethorn"] = "북부 가시덤불",
	Northrend = "노스렌드",
	["Obsidia's Perch"] = "옵시디아의 둥지",
	["Ogri'la"] = "오그릴라",
	["Old Hillsbrad Foothills"] = "옛 힐스브래드 구릉지",
	["Old Stratholme"] = "옛 스트라솔름",
	["Onyxia's Lair"] = "오닉시아의 둥지",
	["Opening of the Dark Portal"] = "어둠의 문 열기",
	Orgrimmar = "오그리마",
	Outland = "아웃랜드",
	["Pit of Saron"] = "사론의 구덩이",
	["Plaguelands: The Scarlet Enclave"] = "동부 역병지대: 붉은십자군 초소",
	Plaguewood = "역병의 숲",
	["Quel'thalas"] = "쿠엘탈라스",
	["Ragefire Chasm"] = "성난불길 협곡",
	Ratchet = "톱니항",
	["Razorfen Downs"] = "가시덩굴 구릉",
	["Razorfen Kraul"] = "가시덩굴 우리",
	["Redridge Mountains"] = "붉은마루 산맥",
	["Ring of Observance"] = "규율의 광장",
	["Rivendark's Perch"] = "리븐다크의 둥지",
	["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허",
	["Ruins of Gilneas"] = "길니아스 폐허",
	["Ruins of Gilneas City"] = "길니아스 시 폐허",
	["Ruins of Lordaeron"] = "로데론의 폐허",
	["Scalebeard's Cave"] = "비늘수염 동굴",
	["Scarlet Monastery"] = "붉은십자군 수도원",
	Scholomance = "스칼로맨스",
	["Searing Gorge"] = "이글거리는 협곡",
	["Serpent Lake"] = "물갈퀴 호수",
	["Serpentshrine Cavern"] = "불뱀 제단",
	["Sethekk Halls"] = "세데크 전당",
	-- ["Shado-pan Monastery"] = "",
	["Shadowfang Keep"] = "그림자송곳니 성채",
	["Shadow Labyrinth"] = "어둠의 미궁",
	["Shadowmoon Valley"] = "어둠달 골짜기",
	["Shartuul's Transporter"] = "샤툴의 순간이동기",
	Shattrath = "샤트라스",
	["Shattrath City"] = "샤트라스",
	["Shimmering Expanse"] = "흐린빛 벌판",
	["Sholazar Basin"] = "숄라자르 분지",
	-- ["Siege of Niuzao Temple"] = "",
	Silithus = "실리더스",
	["Silvermoon City"] = "실버문",
	["Silverpine Forest"] = "은빛소나무 숲",
	["Skyguard Outpost"] = "하늘경비대 전초기지",
	["Skysong Lake"] = "하늘노래 호수",
	["Southern Barrens"] = "남부 불모의 땅",
	["Sporewind Lake"] = "포자바람 호수",
	Stonard = "스토나드",
	["Stonetalon Mountains"] = "돌발톱 산맥",
	-- ["Stormstout Brewery"] = "",
	Stormwind = "스톰윈드",
	["Stormwind City"] = "스톰윈드",
	["Strand of the Ancients"] = "고대의 해안",
	["Stranglethorn Vale"] = "가시덤불 골짜기",
	Stratholme = "스트라솔름",
	["Sunken Temple"] = "가라앉은 사원",
	["Sunwell Plateau"] = "태양샘 고원",
	["Swamp of Sorrows"] = "슬픔의 늪",
	Tanaris = "타나리스",
	Teldrassil = "텔드랏실",
	["Tempest Keep"] = "폭풍우 요새",
	["Temple of Ahn'Qiraj"] = "안퀴라즈 사원",
	-- ["Temple of the Jade Serpent"] = "",
	["Terokkar Forest"] = "테로카르 숲",
	["Terokk's Rest"] = "테로크의 안식처",
	-- ["Terrace of Endless Spring"] = "",
	["The Arachnid Quarter"] = "거미 지구",
	["The Arcatraz"] = "알카트라즈",
	["The Argent Coliseum"] = "십자군 원형경기장",
	["The Barrens"] = "불모의 땅",
	["The Bastion of Twilight"] = "황혼의 요새",
	["The Battle for Gilneas"] = "길니아스 전투지",
	["The Black Morass"] = "검은늪",
	["The Blood Furnace"] = "피의 용광로",
	["The Bone Wastes"] = "해골 무덤",
	["The Botanica"] = "신록의 정원",
	["The Cape of Stranglethorn"] = "가시덤불 곶",
	["The Construct Quarter"] = "피조물 지구",
	["The Culling of Stratholme"] = "옛 스트라솔름",
	["The Dark Portal"] = "어둠의 문",
	["The Deadmines"] = "죽음의 폐광",
	["The Descent into Madness"] = "광기의 내리막길",
	-- ["The Dragon Wastes"] = "",
	["The Escape From Durnholde"] = "던홀드 탈출",
	["The Exodar"] = "엑소다르",
	["The Eye"] = "눈",
	["The Eye of Eternity"] = "영원의 눈",
	["The Forbidding Sea"] = "성난폭풍 해안",
	["The Forge of Souls"] = "영혼의 제련소",
	["The Frozen Halls"] = "얼어붙은 전당",
	["The Frozen Sea"] = "얼어붙은 바다",
	["The Great Sea"] = "대해",
	["The Halls of Winter"] = "겨울의 전당",
	["The Hinterlands"] = "동부 내륙지",
	["The Lost Isles"] = "잃어버린 섬",
	["The Maelstrom"] = "혼돈의 소용돌이",
	["The Mechanar"] = "메카나르",
	["The Military Quarter"] = "군사 지구",
	-- ["The Molten Core"] = "",
	["The Nexus"] = "마력의 탑",
	["The North Sea"] = "북해",
	["The Obsidian Sanctum"] = "흑요석 성소",
	["The Oculus"] = "마력의 눈",
	["The Plague Quarter"] = "역병 지구",
	["The Prison of Yogg-Saron"] = "요그사론의 감옥",
	["Theramore Isle"] = "테라모어 섬",
	["The Ring of Valor"] = "용맹의 투기장",
	["The Ruby Sanctum"] = "루비 성소",
	["The Scarlet Enclave"] = "진홍빛 전당",
	["The Shattered Halls"] = "으스러진 손의 전당",
	["The Slave Pens"] = "강제 노역소",
	["The Spark of Imagination"] = "상상의 작업실",
	["The Steamvault"] = "증기 저장고",
	["The Stockade"] = "스톰윈드 지하감옥",
	["The Stonecore"] = "바위심장부",
	["The Storm Peaks"] = "폭풍우 봉우리",
	["The Temple of Atal'Hakkar"] = "아탈학카르 신전",
	["The Underbog"] = "지하수렁",
	["The Veiled Sea"] = "장막의 바다",
	["The Violet Hold"] = "보랏빛 요새",
	["The Vortex Pinnacle"] = "소용돌이 누각",
	["Thousand Needles"] = "버섯구름 봉우리",
	["Throne of the Four Winds"] = "네 바람의 왕좌",
	["Throne of the Tides"] = "파도의 왕좌",
	["Thunder Bluff"] = "썬더 블러프",
	Tirisfal = "티리스팔",
	["Tirisfal Glades"] = "티리스팔 숲",
	["Tol Barad"] = "톨 바라드",
	["Tol Barad Peninsula"] = "톨 바라드 반도",
	["Trial of the Champion"] = "용사의 시험장",
	["Trial of the Crusader"] = "십자군의 시험장",
	["Twilight Highlands"] = "황혼의 고원",
	["Twin Peaks"] = "쌍둥이 봉우리",
	["Twisting Nether"] = "뒤틀린 황천",
	Uldaman = "울다만",
	Ulduar = "울두아르",
	Uldum = "울둠",
	Undercity = "언더시티",
	["Un'Goro Crater"] = "운고로 분화구",
	["Upper Blackrock Spire"] = "검은바위 첨탑 상층",
	["Utgarde Keep"] = "우트가드 성채",
	["Utgarde Pinnacle"] = "우트가드 첨탑",
	["Vashj'ir"] = "바쉬르",
	["Vault of Archavon"] = "아카본 석실",
	["Vortex Pinnacle"] = "소용돌이 누각 ",
	["Wailing Caverns"] = "통곡의 동굴",
	["Warsong Gulch"] = "전쟁노래 협곡",
	["Well of Eternity"] = "영원의 샘",
	["Western Plaguelands"] = "서부 역병지대",
	Westfall = "서부 몰락지대",
	Wetlands = "저습지",
	Wintergrasp = "겨울손아귀 호수",
	Winterspring = "여명의 설원",
	["Wyrmrest Temple"] = "고룡쉼터 사원",
	Zangarmarsh = "장가르 습지대",
	["Zul'Aman"] = "줄아만",
	["Zul'Drak"] = "줄드락",
	["Zul'Farrak"] = "줄파락",
	["Zul'Gurub"] = "줄구룹",
}
elseif GAME_LOCALE == "esES" then
	lib:SetCurrentTranslations {
	["Abyssal Depths"] = "Profundidades Abisales",
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: El Antiguo Reino",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Ahn'Qiraj: The Fallen Kingdom"] = "Ahn'Qiraj: El Reino Caído",
	["Alliance Base"] = "Base de la Alianza",
	["Alterac Mountains"] = "Montañas de Alterac",
	["Alterac Valley"] = "Valle de Alterac",
	["Amani Pass"] = "Paso de Amani",
	["Arathi Basin"] = "Cuenca de Arathi",
	["Arathi Highlands"] = "Tierras Altas de Arathi",
	Armory = "Armería",
	Ashenvale = "Vallefresno",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Criptas Auchenai",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nerub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Isla Bruma Azur",
	Badlands = "Tierras Inhóspitas",
	["Baradin Hold"] = "Bastión de Baradin",
	["Bash'ir Landing"] = "Zona de aterrizaje Bash'ir",
	["Battle for Gilneas"] = "La Batalla por Gilneas",
	["Blackfathom Deeps"] = "Cavernas de Brazanegra",
	["Blackrock Caverns"] = "Cavernas Roca Negra",
	["Blackrock Depths"] = "Profundidades de Roca Negra",
	["Blackrock Mountain"] = "Montaña Roca Negra",
	["Blackrock Spire"] = "Cumbre de Roca Negra",
	["Black Temple"] = "El Templo Oscuro",
	["Blackwind Lake"] = "Lago Vientonegro",
	["Blackwing Descent"] = "Descenso de Alanegra",
	["Blackwing Lair"] = "Guarida Alanegra",
	["Blade's Edge Arena"] = "Arena Filospada",
	["Blade's Edge Mountains"] = "Montañas Filospada",
	["Blasted Lands"] = "Las Tierras Devastadas",
	["Bloodmyst Isle"] = "Isla Bruma de Sangre",
	["Booty Bay"] = "Bahía del Botín",
	["Borean Tundra"] = "Tundra Boreal",
	["Burning Steppes"] = "Las Estepas Ardientes",
	Cathedral = "Catedral",
	["Caverns of Time"] = "Cavernas del Tiempo",
	["Champions' Hall"] = "Sala de los Campeones",
	["Coilfang Reservoir"] = "Reserva Colmillo Torcido",
	Coldarra = "Gelidar",
	["Cosmic map"] = "Mapa cósmico",
	["Crystalsong Forest"] = "Bosque Canto de Cristal",
	["Crystal Spine"] = "Espina de Cristal",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Arena de Dalaran",
	["Dalaran Sewers"] = "Cloacas de Dalaran",
	["Darkmoon Faire"] = "Feria de la Luna Negra",
	["Darkmoon Island"] = "Isla Luna Negra", -- Needs review
	Darkshore = "Costa Oscura",
	Darnassus = "Darnassus",
	Deadmines = "Las Minas de la Muerte",
	["Deadwind Pass"] = "Paso de la Muerte",
	Deepholm = "Infralar",
	["Deeprun Tram"] = "Tranvía Subterráneo",
	Desolace = "Desolace",
	["Dire Maul"] = "La Masacre",
	["Dire Maul (East)"] = "La Masacre (Este)",
	["Dire Maul (North)"] = "La Masacre (Norte)",
	["Dire Maul (West)"] = "La Masacre (Oeste)",
	Dragonblight = "Cementerio de Dragones",
	["Dragon Soul"] = "Alma de Dragón",
	["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Bosque del Ocaso",
	["Dustwallow Marsh"] = "Marjal Revolcafango",
	["Eastern Kingdoms"] = "Reinos del Este",
	["Eastern Plaguelands"] = "Tierras de la Peste del Este",
	["Elwynn Forest"] = "Bosque de Elwynn",
	["End Time"] = "Fin de los Días",
	Everlook = "Vista Eterna",
	["Eversong Woods"] = "Bosque Canción Eterna",
	["Eye of the Storm"] = "Ojo de la Tormenta",
	Felwood = "Frondavil",
	Feralas = "Feralas",
	Firelands = "Tierras de Fuego",
	["Forge Camp: Terror"] = "Campamento forja: Terror",
	["Forge Camp: Wrath"] = "Campamento forja: Cólera",
	["Frostwyrm Lair"] = "Guarida de Vermis de Escarcha",
	["Furywing's Perch"] = "Nido de Alafuria",
	Gadgetzan = "Gadgetzan",
	-- ["Gate of the Setting Sun"] = "",
	["Gates of Ahn'Qiraj"] = "Puertas de Ahn'Qiraj",
	Ghostlands = "Tierras Fantasma",
	Gilneas = "Gilneas",
	["Gilneas City"] = "Ciudad de Gilneas",
	Gnomeregan = "Gnomeregan",
	Graveyard = "Cementerio",
	["Grim Batol"] = "Grim Batol",
	["Grizzly Hills"] = "Colinas Pardas",
	["Grom'gol Base Camp"] = "Campamento Grom'gol",
	["Gruul's Lair"] = "Guarida de Gruul",
	Gundrak = "Gundrak",
	["Hall of Blackhand"] = "Sala de Puño Negro",
	["Hall of Champions"] = "Sala de los Campeones",
	["Hall of Legends"] = "Sala de las Leyendas",
	["Halls of Lightning"] = "Cámaras de Relámpagos",
	["Halls of Origination"] = "Cámaras de los Orígenes",
	["Halls of Reflection"] = "Cámaras de Reflexión",
	["Halls of Stone"] = "Cámaras de Piedra",
	-- ["Heart of Fear"] = "",
	["Hellfire Citadel"] = "Ciudadela del Fuego Infernal",
	["Hellfire Peninsula"] = "Península del Fuego Infernal",
	["Hellfire Ramparts"] = "Murallas del Fuego Infernal",
	["Hillsbrad Foothills"] = "Laderas de Trabalomas",
	["Horde Encampment"] = "Campamento Horda",
	["Hour of Twilight"] = "Hora del Crepúsculo",
	["Howling Fjord"] = "Fiordo Aquilonal",
	["Hrothgar's Landing"] = "Desembarco de Hrothgar",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "Cima Hyjal",
	Icecrown = "Corona de Hielo",
	["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo",
	["Insidion's Perch"] = "Nido de Insidion",
	Ironforge = "Forjaz",
	["Isle of Conquest"] = "Isla de la Conquista",
	["Isle of Quel'Danas"] = "Isla de Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Kelp'thar Forest"] = "Bosque Kelp'thar",
	Kezan = "Kezan",
	["Krasus' Landing"] = "Krasus' Landing",
	Library = "Biblioteca",
	["Loch Modan"] = "Loch Modan",
	["Lost City of the Tol'vir"] = "Ciudad Perdida de los Tol'vir",
	["Lower Blackrock Spire"] = "Cumbre inferior de Roca Negra",
	["Magisters' Terrace"] = "Bancal del Magister",
	["Magtheridon's Lair"] = "Guarida de Magtheridon",
	["Mana-Tombs"] = "Tumbas de Maná",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Lago Luz Pantanosa",
	["Menethil Harbor"] = "Puerto de Menethil",
	-- ["Mogu'Shan Palace"] = "",
	-- ["Mogu'shan Vaults"] = "",
	["Molten Core"] = "Núcleo de Magma",
	["Molten Front"] = "Frente de Magma",
	Moonglade = "Claro de la Luna",
	["Mount Hyjal"] = "Monte Hyjal",
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Arena de Nagrand",
	Naxxramas = "Naxxramas",
	Netherstorm = "Tormenta Abisal",
	["Night Elf Village"] = "Poblado Elfo de la Noche",
	["Northern Barrens"] = "Los Baldíos del Norte",
	["Northern Stranglethorn"] = "Norte de la Vega de Tuercespina",
	Northrend = "Rasganorte",
	["Obsidia's Perch"] = "Nido de Obsidia",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas",
	["Old Stratholme"] = "Stratholme en el pasado",
	["Onyxia's Lair"] = "Guarida de Onyxia",
	["Opening of the Dark Portal"] = "Apertura de El Portal Oscuro", -- Needs review
	Orgrimmar = "Orgrimmar",
	Outland = "Terrallende",
	["Pit of Saron"] = "Foso de Saron",
	["Plaguelands: The Scarlet Enclave"] = "Tierras de la Peste del Este: El Enclave Escarlata",
	Plaguewood = "Bosque de la Plaga",
	["Quel'thalas"] = "Quel'thalas",
	["Ragefire Chasm"] = "Sima ígnea",
	Ratchet = "Trinquete",
	["Razorfen Downs"] = "Zahúrda Rajacieno",
	["Razorfen Kraul"] = "Horado Rajacieno",
	["Redridge Mountains"] = "Montañas Crestagrana",
	["Ring of Observance"] = "Círculo de la Observancia",
	["Rivendark's Perch"] = "Nido de Desgarro Oscuro",
	["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj",
	["Ruins of Gilneas"] = "Ruinas de Gilneas",
	["Ruins of Gilneas City"] = "Ruinas de la Ciudad de Gilneas",
	["Ruins of Lordaeron"] = "Ruinas de Lordaeron",
	["Scalebeard's Cave"] = "Cueva de Barbascamas",
	["Scarlet Monastery"] = "Monasterio Escarlata",
	Scholomance = "Scholomance",
	["Searing Gorge"] = "La Garganta de Fuego",
	["Serpent Lake"] = "Lago Serpiente",
	["Serpentshrine Cavern"] = "Caverna Santuario Serpiente",
	["Sethekk Halls"] = "Salas Sethekk",
	-- ["Shado-pan Monastery"] = "",
	["Shadowfang Keep"] = "Castillo de Colmillo Oscuro",
	["Shadow Labyrinth"] = "Laberinto de las Sombras",
	["Shadowmoon Valley"] = "Valle Sombraluna",
	["Shartuul's Transporter"] = "Transportador de Shartuul",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Ciudad de Shattrath",
	["Shimmering Expanse"] = "Extensión Bruñida",
	["Sholazar Basin"] = "Cuenca de Sholazar",
	-- ["Siege of Niuzao Temple"] = "",
	Silithus = "Silithus",
	["Silvermoon City"] = "Ciudad de Lunargenta",
	["Silverpine Forest"] = "Bosque de Argénteos",
	["Skyguard Outpost"] = "Puesto de la Guardia de Cielo",
	["Skysong Lake"] = "Lago Sol Celeste",
	["Southern Barrens"] = "Los Baldíos del Sur",
	["Sporewind Lake"] = "Lago Espora Volante",
	Stonard = "Rocal",
	["Stonetalon Mountains"] = "Sierra Espolón",
	-- ["Stormstout Brewery"] = "",
	Stormwind = "Ventormenta",
	["Stormwind City"] = "Ciudad de Ventormenta",
	["Strand of the Ancients"] = "Playa de los Ancestros",
	["Stranglethorn Vale"] = "Vega de Tuercespina",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "El Templo Sumergido",
	["Sunwell Plateau"] = "Meseta de la Fuente del Sol",
	["Swamp of Sorrows"] = "Pantano de las Penas",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "El Castillo de la Tempestad",
	["Temple of Ahn'Qiraj"] = "El Templo de Ahn'Qiraj",
	-- ["Temple of the Jade Serpent"] = "",
	["Terokkar Forest"] = "Bosque de Terokkar",
	["Terokk's Rest"] = "Sosiego de Terokk",
	-- ["Terrace of Endless Spring"] = "",
	["The Arachnid Quarter"] = "Ala Arácnida",
	["The Arcatraz"] = "El Alcatraz",
	["The Argent Coliseum"] = "El Coliseo Argenta",
	["The Barrens"] = "Los Baldíos",
	["The Bastion of Twilight"] = "El Bastión del Crepúsculo",
	["The Battle for Gilneas"] = "La Batalla por Gilneas",
	["The Black Morass"] = "La Ciénaga Negra",
	["The Blood Furnace"] = "El Horno de Sangre",
	["The Bone Wastes"] = "El Vertedero de Huesos",
	["The Botanica"] = "El Invernáculo",
	["The Cape of Stranglethorn"] = "El Cabo de Tuercespina",
	["The Construct Quarter"] = "Ala de Abominación",
	["The Culling of Stratholme"] = "La Matanza de Stratholme",
	["The Dark Portal"] = "El Portal Oscuro",
	["The Deadmines"] = "Las Minas de la Muerte",
	["The Descent into Madness"] = "Descenso a la Locura",
	-- ["The Dragon Wastes"] = "",
	["The Escape From Durnholde"] = "La Fuga de Durnholde", -- Needs review
	["The Exodar"] = "El Exodar",
	["The Eye"] = "El Ojo",
	["The Eye of Eternity"] = "El Ojo de la Eternidad",
	["The Forbidding Sea"] = "Mar Adusto",
	["The Forge of Souls"] = "La Forja de Almas",
	["The Frozen Halls"] = "Las Cámaras Heladas",
	["The Frozen Sea"] = "El Mar Gélido",
	["The Great Sea"] = "Mare Magnum",
	["The Halls of Winter"] = "Las Cámaras del Invierno",
	["The Hinterlands"] = "Tierras del Interior",
	["The Lost Isles"] = "Las Islas Perdidas",
	["The Maelstrom"] = "La Vorágine",
	["The Mechanar"] = "El Mechanar",
	["The Military Quarter"] = "Ala Militar",
	-- ["The Molten Core"] = "",
	["The Nexus"] = "El Nexo",
	["The North Sea"] = "El Mar del Norte",
	["The Obsidian Sanctum"] = "El Sagrario Obsidiana",
	["The Oculus"] = "El Oculus",
	["The Plague Quarter"] = "Ala de la Plaga",
	["The Prison of Yogg-Saron"] = "La Prisión de Yogg-Saron",
	["Theramore Isle"] = "Isla Theramore",
	["The Ring of Valor"] = "El Anillo del Valor",
	["The Ruby Sanctum"] = "El Sagrario Rubí",
	["The Scarlet Enclave"] = "Tierras de la Peste: El Enclave Escarlata",
	["The Shattered Halls"] = "Las Salas Arrasadas",
	["The Slave Pens"] = "Recinto de los Esclavos",
	["The Spark of Imagination"] = "Cámaras de la Invención",
	["The Steamvault"] = "La Cámara de Vapor",
	["The Stockade"] = "Las Mazmorras",
	["The Stonecore"] = "El Núcleo Pétreo",
	["The Storm Peaks"] = "Las Cumbres Tormentosas",
	["The Temple of Atal'Hakkar"] = "El Templo de Atal'Hakkar",
	["The Underbog"] = "La Sotiénaga",
	["The Veiled Sea"] = "Mar de la Bruma",
	["The Violet Hold"] = "El Bastión Violeta",
	["The Vortex Pinnacle"] = "La Cumbre del Vórtice",
	["Thousand Needles"] = "Las Mil Agujas",
	["Throne of the Four Winds"] = "Trono de los Cuatro Vientos",
	["Throne of the Tides"] = "Trono de las Mareas",
	["Thunder Bluff"] = "Cima del Trueno",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Claros de Tirisfal",
	["Tol Barad"] = "Tol Barad",
	["Tol Barad Peninsula"] = "Península de Tol Barad",
	["Trial of the Champion"] = "Prueba del Cruzado",
	["Trial of the Crusader"] = "Prueba del Cruzado",
	["Twilight Highlands"] = "Tierras Altas Crepusculares",
	["Twin Peaks"] = "Cumbres Gemelas",
	["Twisting Nether"] = "El Vacío Abisal",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Uldum = "Uldum",
	Undercity = "Entrañas",
	["Un'Goro Crater"] = "Cráter de Un'Goro",
	["Upper Blackrock Spire"] = "Cumbre de Roca Negra",
	["Utgarde Keep"] = "Fortaleza de Utgarde",
	["Utgarde Pinnacle"] = "Pináculo de Utgarde",
	["Vashj'ir"] = "Vashj'ir",
	["Vault of Archavon"] = "La Cámara de Archavon",
	["Vortex Pinnacle"] = "La Cumbre del Vórtice",
	["Wailing Caverns"] = "Cuevas de los Lamentos",
	["Warsong Gulch"] = "Garganta Grito de Guerra",
	["Well of Eternity"] = "Pozo de la Eternidad",
	["Western Plaguelands"] = "Tierras de la Peste del Oeste",
	Westfall = "Páramos de Poniente",
	Wetlands = "Los Humedales",
	Wintergrasp = "Conquista del Invierno",
	Winterspring = "Cuna del Invierno",
	["Wyrmrest Temple"] = "Templo del Reposo del Dragón",
	Zangarmarsh = "Marisma de Zangar",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}
elseif GAME_LOCALE == "esMX" then
	lib:SetCurrentTranslations {
	["Abyssal Depths"] = "Profundidades Abisales", -- Needs review
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: El Antiguo Reino",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Ahn'Qiraj: The Fallen Kingdom"] = "Ahn'Qiraj: El Reino Caído", -- Needs review
	["Alliance Base"] = "Base de la Alianza",
	["Alterac Mountains"] = "Montañas de Alterac",
	["Alterac Valley"] = "Valle de Alterac",
	["Amani Pass"] = "Paso de Amani",
	["Arathi Basin"] = "Cuenca de Arathi",
	["Arathi Highlands"] = "Tierras Altas de Arathi",
	Armory = "Armería",
	Ashenvale = "Vallefresno",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Criptas Auchenai",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nerub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Isla Bruma Azur",
	Badlands = "Tierras Inhóspitas",
	["Baradin Hold"] = "Bastión de Baradin", -- Needs review
	["Bash'ir Landing"] = "Alto Bash'ir",
	["Battle for Gilneas"] = "La Batalla por Gilneas", -- Needs review
	["Blackfathom Deeps"] = "Cavernas de Brazanegra",
	["Blackrock Caverns"] = "Cavernas Roca Negra", -- Needs review
	["Blackrock Depths"] = "Profundidades de Roca Negra",
	["Blackrock Mountain"] = "Montaña Roca Negra",
	["Blackrock Spire"] = "Cumbre de Roca Negra",
	["Black Temple"] = "Templo Oscuro",
	["Blackwind Lake"] = "Lago Vientonegro",
	["Blackwing Descent"] = "Descenso de Alanegra", -- Needs review
	["Blackwing Lair"] = "Guarida de Alanegra",
	["Blade's Edge Arena"] = "Arena Filospada",
	["Blade's Edge Mountains"] = "Montañas Filospada",
	["Blasted Lands"] = "Las Tierras Devastadas",
	["Bloodmyst Isle"] = "Isla Bruma de Sangre",
	["Booty Bay"] = "Bahía del Botín",
	["Borean Tundra"] = "Tundra Boreal",
	["Burning Steppes"] = "Las Estepas Ardientes",
	Cathedral = "Catedral",
	["Caverns of Time"] = "Cavernas del Tiempo",
	["Champions' Hall"] = "Sala de los Campeones",
	["Coilfang Reservoir"] = "Reserva Colmillo Torcido",
	Coldarra = "Gelidar",
	["Cosmic map"] = "Mapa cósmico",
	["Crystalsong Forest"] = "Bosque Canto de Cristal",
	["Crystal Spine"] = "Espina de Cristal",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Arena de Dalaran",
	["Dalaran Sewers"] = "Cloacas de Dalaran",
	["Darkmoon Faire"] = "Feria de la Luna Negra",
	["Darkmoon Island"] = "Isla Luna Negra",
	Darkshore = "Costa Oscura",
	Darnassus = "Darnassus",
	Deadmines = "Minas de la Muerte",
	["Deadwind Pass"] = "Paso de la Muerte",
	Deepholm = "Infralar", -- Needs review
	["Deeprun Tram"] = "Tranvía Subterráneo",
	Desolace = "Desolace",
	["Dire Maul"] = "La Masacre",
	["Dire Maul (East)"] = "La Masacre (Este)",
	["Dire Maul (North)"] = "La Masacre (Norte)",
	["Dire Maul (West)"] = "La Masacre: Oeste",
	Dragonblight = "Cementerio de Dragones",
	["Dragon Soul"] = "Alma de Dragón",
	["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Bosque del Ocaso",
	["Dustwallow Marsh"] = "Marjal Revolcafango",
	["Eastern Kingdoms"] = "Reinos del Este",
	["Eastern Plaguelands"] = "Tierras de la Peste del Este",
	["Elwynn Forest"] = "Bosque de Elwynn",
	["End Time"] = "Fin de los Días",
	Everlook = "Vista Eterna",
	["Eversong Woods"] = "Bosque Canción Eterna",
	["Eye of the Storm"] = "Ojo de la Tormenta",
	Felwood = "Frondavil",
	Feralas = "Feralas",
	Firelands = "Tierras de Fuego", -- Needs review
	["Forge Camp: Terror"] = "Campamento Forja: Terror",
	["Forge Camp: Wrath"] = "Campamento Forja: Cólera",
	["Frostwyrm Lair"] = "Guarida de Vermis de Escarcha",
	["Furywing's Perch"] = "Nido de Alafuria",
	Gadgetzan = "Gadgetzan",
	-- ["Gate of the Setting Sun"] = "",
	["Gates of Ahn'Qiraj"] = "Puerta de Ahn'Qiraj",
	Ghostlands = "Tierras Fantasma",
	Gilneas = "Gilneas", -- Needs review
	["Gilneas City"] = "Ciudad de Gilneas", -- Needs review
	Gnomeregan = "Gnomeregan",
	Graveyard = "Cementerio",
	["Grim Batol"] = "Grim Batol", -- Needs review
	["Grizzly Hills"] = "Colinas Pardas",
	["Grom'gol Base Camp"] = "Campamento Grom'gol",
	["Gruul's Lair"] = "Guarida de Gruul",
	Gundrak = "Gundrak",
	["Hall of Blackhand"] = "Sala de Puño Negro",
	["Hall of Champions"] = "Sala de los Campeones",
	["Hall of Legends"] = "Sala de las Leyendas",
	["Halls of Lightning"] = "Cámaras de Relámpagos",
	["Halls of Origination"] = "Cámaras de los Orígenes", -- Needs review
	["Halls of Reflection"] = "Cámaras de Reflexión",
	["Halls of Stone"] = "Cámaras de Piedra",
	-- ["Heart of Fear"] = "",
	["Hellfire Citadel"] = "Ciudadela del Fuego Infernal",
	["Hellfire Peninsula"] = "Península del Fuego Infernal",
	["Hellfire Ramparts"] = "Murallas del Fuego Infernal",
	["Hillsbrad Foothills"] = "Laderas de Trabalomas",
	["Horde Encampment"] = "Campamento de la Horda",
	["Hour of Twilight"] = "Hora del Crepúsculo",
	["Howling Fjord"] = "Fiordo Aquilonal",
	["Hrothgar's Landing"] = "Desembarco de Hrothgar",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "La Cima Hyjal",
	Icecrown = "Corona de Hielo",
	["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo",
	["Insidion's Perch"] = "Nido de Insidion",
	Ironforge = "Forjaz",
	["Isle of Conquest"] = "Isla de la Conquista",
	["Isle of Quel'Danas"] = "Isla de Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Kelp'thar Forest"] = "Bosque Kelp'thar", -- Needs review
	Kezan = "Kezan", -- Needs review
	["Krasus' Landing"] = "Alto de Krasus",
	Library = "Biblioteca",
	["Loch Modan"] = "Loch Modan",
	["Lost City of the Tol'vir"] = "Ciudad Perdida de los Tol'vir", -- Needs review
	["Lower Blackrock Spire"] = "Cumbre inferior de Roca Negra",
	["Magisters' Terrace"] = "Bancal del Magister",
	["Magtheridon's Lair"] = "Guarida de Magtheridon",
	["Mana-Tombs"] = "Tumbas de Maná",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Lago Luz Pantanosa",
	["Menethil Harbor"] = "Puerto de Menethil",
	-- ["Mogu'Shan Palace"] = "",
	-- ["Mogu'shan Vaults"] = "",
	["Molten Core"] = "Núcleo de Magma",
	["Molten Front"] = "Frente de Magma", -- Needs review
	Moonglade = "Claro de la Luna",
	["Mount Hyjal"] = "Monte Hyjal", -- Needs review
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Arena de Nagrand",
	Naxxramas = "Naxxramas",
	Netherstorm = "Tormenta Abisal",
	["Night Elf Village"] = "Villa Elfo de la Noche",
	["Northern Barrens"] = "Los Baldíos del Norte", -- Needs review
	["Northern Stranglethorn"] = "Norte de la Vega de Tuercespina", -- Needs review
	Northrend = "Rasganorte",
	["Obsidia's Perch"] = "Nido de Obsidia",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas",
	["Old Stratholme"] = "Stratholme en el pasado",
	["Onyxia's Lair"] = "Guarida de Onyxia",
	["Opening of the Dark Portal"] = "Apertura de El Portal Oscuro",
	Orgrimmar = "Orgrimmar",
	Outland = "Terrallende",
	["Pit of Saron"] = "Foso de Saron",
	["Plaguelands: The Scarlet Enclave"] = "Tierras de la Peste: El Enclave Escarlata",
	Plaguewood = "Bosque de la Peste",
	["Quel'thalas"] = "Quel'thalas",
	["Ragefire Chasm"] = "Sima Ígnea",
	Ratchet = "Trinquete",
	["Razorfen Downs"] = "Zahúrda Rajacieno",
	["Razorfen Kraul"] = "Horado Rajacieno",
	["Redridge Mountains"] = "Montañas Crestagrana",
	["Ring of Observance"] = "Círculo de la Observancia",
	["Rivendark's Perch"] = "Nido de Desgarro Oscuro",
	["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj",
	["Ruins of Gilneas"] = "Ruinas de Gilneas", -- Needs review
	["Ruins of Gilneas City"] = "Ruinas de la Ciudad de Gilneas", -- Needs review
	["Ruins of Lordaeron"] = "Ruinas de Lordaeron",
	["Scalebeard's Cave"] = "Cueva de Barbaescamas",
	["Scarlet Monastery"] = "Monasterio Escarlata",
	Scholomance = "Scholomance",
	["Searing Gorge"] = "La Garganta de Fuego",
	["Serpent Lake"] = "Lago Serpiente",
	["Serpentshrine Cavern"] = "Caverna Santuario Serpiente",
	["Sethekk Halls"] = "Salas Sethekk",
	-- ["Shado-pan Monastery"] = "",
	["Shadowfang Keep"] = "Castillo de Colmillo Oscuro",
	["Shadow Labyrinth"] = "Laberinto de las Sombras",
	["Shadowmoon Valley"] = "Valle Sombraluna",
	["Shartuul's Transporter"] = "Transportador de Shartuul",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Ciudad de Shattrath",
	["Shimmering Expanse"] = "Extensión Bruñida", -- Needs review
	["Sholazar Basin"] = "Cuenca de Sholazar",
	-- ["Siege of Niuzao Temple"] = "",
	Silithus = "Silithus",
	["Silvermoon City"] = "Ciudad de Lunargenta",
	["Silverpine Forest"] = "Bosque de Argénteos",
	["Skyguard Outpost"] = "Avanzada de la Guardia del Cielo",
	["Skysong Lake"] = "Lago Son Celeste",
	["Southern Barrens"] = "Los Baldíos del Sur", -- Needs review
	["Sporewind Lake"] = "Lago Espora Volante",
	Stonard = "Rocal",
	["Stonetalon Mountains"] = "Sierra Espolón",
	-- ["Stormstout Brewery"] = "",
	Stormwind = "Ventormenta",
	["Stormwind City"] = "Ciudad de Ventormenta",
	["Strand of the Ancients"] = "Playa de los Ancestros",
	["Stranglethorn Vale"] = "Vega de Tuercespina",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "Templo Sumergido",
	["Sunwell Plateau"] = "Meseta de La Fuente del Sol",
	["Swamp of Sorrows"] = "Pantano de las Penas",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "El Castillo de la Tempestad",
	["Temple of Ahn'Qiraj"] = "El Templo de Ahn'Qiraj",
	-- ["Temple of the Jade Serpent"] = "",
	["Terokkar Forest"] = "Bosque de Terokkar",
	["Terokk's Rest"] = "Sosiego de Terokk",
	-- ["Terrace of Endless Spring"] = "",
	["The Arachnid Quarter"] = "El Arrabal Arácnido",
	["The Arcatraz"] = "El Arcatraz",
	["The Argent Coliseum"] = "El Coliseo Argenta",
	["The Barrens"] = "Los Baldíos",
	["The Bastion of Twilight"] = "El Bastión del Crepúsculo", -- Needs review
	["The Battle for Gilneas"] = "La Batalla por Gilneas", -- Needs review
	["The Black Morass"] = "La Ciénaga Negra",
	["The Blood Furnace"] = "El Horno de Sangre",
	["The Bone Wastes"] = "El Vertedero de Huesos",
	["The Botanica"] = "El Invernáculo",
	["The Cape of Stranglethorn"] = "El Cabo de Tuercespina", -- Needs review
	["The Construct Quarter"] = "El Arrabal de los Ensamblajes",
	["The Culling of Stratholme"] = "La Matanza de Stratholme",
	["The Dark Portal"] = "El Portal Oscuro",
	["The Deadmines"] = "Las Minas de la Muerte",
	["The Descent into Madness"] = "El Descenso a la Locura",
	-- ["The Dragon Wastes"] = "",
	["The Escape From Durnholde"] = "La Fuga de Durnholde",
	["The Exodar"] = "El Exodar",
	["The Eye"] = "El Ojo",
	["The Eye of Eternity"] = "El Ojo de la Eternidad",
	["The Forbidding Sea"] = "Mar Adusto",
	["The Forge of Souls"] = "La Forja de Almas",
	["The Frozen Halls"] = "Las Cámaras Heladas",
	["The Frozen Sea"] = "El Mar Gélido",
	["The Great Sea"] = "Mare Magnum",
	["The Halls of Winter"] = "Las Cámaras del Invierno",
	["The Hinterlands"] = "Tierras del Interior",
	["The Lost Isles"] = "Las Islas Perdidas", -- Needs review
	["The Maelstrom"] = "La Vorágine", -- Needs review
	["The Mechanar"] = "El Mechanar",
	["The Military Quarter"] = "El Arrabal Militar",
	-- ["The Molten Core"] = "",
	["The Nexus"] = "El Nexo",
	["The North Sea"] = "El Mar del Norte",
	["The Obsidian Sanctum"] = "El Sagrario Obsidiana",
	["The Oculus"] = "El Oculus",
	["The Plague Quarter"] = "El Arrabal de la Peste",
	["The Prison of Yogg-Saron"] = "La Prisión de Yogg-Saron",
	["Theramore Isle"] = "Isla Theramore",
	["The Ring of Valor"] = "El Círculo del Valor",
	["The Ruby Sanctum"] = "El Sagrario Rubí", -- Needs review
	["The Scarlet Enclave"] = "El Enclave Escarlata",
	["The Shattered Halls"] = "Las Salas Arrasadas",
	["The Slave Pens"] = "Recinto de los Esclavos",
	["The Spark of Imagination"] = "La Chispa de la Imaginación",
	["The Steamvault"] = "La Cámara de Vapor",
	["The Stockade"] = "Las Mazmorras",
	["The Stonecore"] = "El Núcleo Pétreo", -- Needs review
	["The Storm Peaks"] = "Las Cumbres Tormentosas",
	["The Temple of Atal'Hakkar"] = "El Templo de Atal'Hakkar",
	["The Underbog"] = "La Sotiénaga",
	["The Veiled Sea"] = "Mar de la Bruma",
	["The Violet Hold"] = "El Bastión Violeta",
	["The Vortex Pinnacle"] = "La Cumbre del Vórtice", -- Needs review
	["Thousand Needles"] = "Las Mil Agujas",
	["Throne of the Four Winds"] = "Trono de los Cuatro Vientos", -- Needs review
	["Throne of the Tides"] = "Trono de las Mareas", -- Needs review
	["Thunder Bluff"] = "Cima del Trueno",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Claros de Tirisfal",
	["Tol Barad"] = "Tol Barad", -- Needs review
	["Tol Barad Peninsula"] = "Península de Tol Barad", -- Needs review
	["Trial of the Champion"] = "Prueba del Campeón",
	["Trial of the Crusader"] = "Prueba del Cruzado",
	["Twilight Highlands"] = "Tierras Altas Crepusculares", -- Needs review
	["Twin Peaks"] = "Cumbres Gemelas", -- Needs review
	["Twisting Nether"] = "El Vacío Abisal",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Uldum = "Uldum", -- Needs review
	Undercity = "Entrañas",
	["Un'Goro Crater"] = "Cráter de Un'Goro",
	["Upper Blackrock Spire"] = "Cumbre de Roca Negra",
	["Utgarde Keep"] = "Fortaleza de Utgarde",
	["Utgarde Pinnacle"] = "Pináculo de Utgarde",
	["Vashj'ir"] = "Vashj'ir", -- Needs review
	["Vault of Archavon"] = "La Cámara de Archavon",
	["Vortex Pinnacle"] = "Cumbre del Vórtice",
	["Wailing Caverns"] = "Cuevas de los Lamentos",
	["Warsong Gulch"] = "Garganta Grito de Guerra",
	["Well of Eternity"] = "Pozo de la Eternidad",
	["Western Plaguelands"] = "Tierras de la Peste del Oeste",
	Westfall = "Páramos de Poniente",
	Wetlands = "Los Humedales",
	Wintergrasp = "Conquista del Invierno",
	Winterspring = "Cuna del Invierno",
	["Wyrmrest Temple"] = "Templo del Reposo del Dragón",
	Zangarmarsh = "Marisma de Zangar",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}
elseif GAME_LOCALE == "ptBR" then
	lib:SetCurrentTranslations {
	["Abyssal Depths"] = "Profundezas Abissais",
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: O Velho Reino",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Ahn'Qiraj: The Fallen Kingdom"] = "Ahn'Qiraj: O Reino Derrotado",
	["Alliance Base"] = "Base da Aliança",
	["Alterac Mountains"] = "Montanhas de Alterac",
	["Alterac Valley"] = "Vale Alterac",
	["Amani Pass"] = "Desfiladeiro Amani",
	["Arathi Basin"] = "Bacia Arathi",
	["Arathi Highlands"] = "Planalto Arathi",
	Armory = "Armaria",
	Ashenvale = "Vale Gris",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Catacumbas de Auchenai",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nerub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Ilha Névoa Lazúli",
	Badlands = "Ermos",
	["Baradin Hold"] = "Guarnição Baradin",
	["Bash'ir Landing"] = "Patamar de Bash'ir",
	["Battle for Gilneas"] = "Batalha por Guilnéas",
	["Blackfathom Deeps"] = "Profundezas Negras",
	["Blackrock Caverns"] = "Caverna Rocha Negra",
	["Blackrock Depths"] = "Abismo Rocha Negra",
	["Blackrock Mountain"] = "Montanha Rocha Negra",
	["Blackrock Spire"] = "Pico da Rocha Negra",
	["Black Temple"] = "Templo Negro",
	["Blackwind Lake"] = "Lago Ventonegro",
	["Blackwing Descent"] = "Descenso do Asa Negra",
	["Blackwing Lair"] = "Covil Asa Negra",
	["Blade's Edge Arena"] = "Arena da Lâmina Afiada",
	["Blade's Edge Mountains"] = "Montanhas da Lâmina Afiada",
	["Blasted Lands"] = "Barreira do Inferno",
	["Bloodmyst Isle"] = "Ilha Névoa Rubra",
	["Booty Bay"] = "Angra do Butim",
	["Borean Tundra"] = "Tundra Boreana",
	["Burning Steppes"] = "Estepes Ardentes",
	Cathedral = "Catedral",
	["Caverns of Time"] = "Cavernas do Tempo",
	["Champions' Hall"] = "Salão dos Campeões",
	["Coilfang Reservoir"] = "Reservatório Presacurva",
	Coldarra = "Gelarra",
	["Cosmic map"] = "Adaga de Corrahn",
	["Crystalsong Forest"] = "Floresta do Canto Cristalino",
	["Crystal Spine"] = "Serra dos Cristais",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Arena de Dalaran",
	["Dalaran Sewers"] = "Esgotos de Dalaran",
	["Darkmoon Faire"] = "Feira de Negraluna",
	["Darkmoon Island"] = "Ilha de Negraluna",
	Darkshore = "Costa Negra",
	Darnassus = "Darnassus",
	Deadmines = "Minas Mortas",
	["Deadwind Pass"] = "Trilha do Vento Morto",
	Deepholm = "Geodomo",
	["Deeprun Tram"] = "Metrô Correfundo",
	Desolace = "Desolação",
	["Dire Maul"] = "Gládio Cruel",
	["Dire Maul (East)"] = "Gládio Cruel (Leste)",
	["Dire Maul (North)"] = "Gládio Cruel (Norte)",
	["Dire Maul (West)"] = "Gládio Cruel (Oeste)",
	Dragonblight = "Ermo das Serpes",
	["Dragon Soul"] = "Alma Dragônica",
	["Drak'Tharon Keep"] = "Bastilha Drak'Tharon",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Floresta do Crepúsculo",
	["Dustwallow Marsh"] = "Pântano Vadeoso",
	["Eastern Kingdoms"] = "Reinos do Leste",
	["Eastern Plaguelands"] = "Terras Pestilentas Orientais",
	["Elwynn Forest"] = "Floresta de Elwynn ",
	["End Time"] = "Fim dos Tempos",
	Everlook = "Visteterna",
	["Eversong Woods"] = "Floresta do Canto Eterno",
	["Eye of the Storm"] = "Olho da Tormenta 2.0",
	Felwood = "Selva Maleva",
	Feralas = "Feralas",
	Firelands = "Terras do Fogo",
	["Forge Camp: Terror"] = "Campo-forja: Terror",
	["Forge Camp: Wrath"] = "Campo-forja: Ira",
	["Frostwyrm Lair"] = "Covil da Serpe Gélida",
	["Furywing's Perch"] = "Ninho do Furialada",
	Gadgetzan = "Geringontzan",
	-- ["Gate of the Setting Sun"] = "",
	["Gates of Ahn'Qiraj"] = "Portões de Ahn'Qiraj",
	Ghostlands = "Terra Fantasma",
	Gilneas = "Guilnéas",
	["Gilneas City"] = "Guilnéas",
	Gnomeregan = "Gnomeregan",
	Graveyard = "Cemitério",
	["Grim Batol"] = "Grim Batol",
	["Grizzly Hills"] = "Serra Gris",
	["Grom'gol Base Camp"] = "Acampamento Grom'gol",
	["Gruul's Lair"] = "Covil de Gruul",
	Gundrak = "Gundrak",
	["Hall of Blackhand"] = "Salão do Mão Negra",
	["Hall of Champions"] = "Salão dos Campeões",
	["Hall of Legends"] = "Salão dos Lendários",
	["Halls of Lightning"] = "Salões Relampejantes",
	["Halls of Origination"] = "Salões Primordiais",
	["Halls of Reflection"] = "Salões da Reflexão",
	["Halls of Stone"] = "Salões Rochosos",
	-- ["Heart of Fear"] = "",
	["Hellfire Citadel"] = "Cidadela Fogo do Inferno",
	["Hellfire Peninsula"] = "Península Fogo do Inferno",
	["Hellfire Ramparts"] = "Muralha Fogo do Inferno",
	["Hillsbrad Foothills"] = "Contraforte de Eira dos Montes",
	["Horde Encampment"] = "Acampamento da Horda",
	["Hour of Twilight"] = "Hora do Crepúsculo",
	["Howling Fjord"] = "Fiorde Uivante",
	["Hrothgar's Landing"] = "Porto de Hrothgar",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "Pico Hyjal",
	Icecrown = "Coroa de Gelo",
	["Icecrown Citadel"] = "Cidadela da Coroa de Gelo",
	["Insidion's Perch"] = "Ninho do Insidion",
	Ironforge = "Altaforja",
	["Isle of Conquest"] = "Ilha da Conquista",
	["Isle of Quel'Danas"] = "Ilha de Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Kelp'thar Forest"] = "Floresta Kelp'thar",
	Kezan = "Kezan",
	["Krasus' Landing"] = "Plataforma de Krasus",
	Library = "Biblioteca",
	["Loch Modan"] = "Loch Modan",
	["Lost City of the Tol'vir"] = "Cidade Perdida dos Tol'vir",
	["Lower Blackrock Spire"] = "Pico da Rocha Negra Inferior",
	["Magisters' Terrace"] = "Terraço dos Magísteres",
	["Magtheridon's Lair"] = "Covil de Magtheridon",
	["Mana-Tombs"] = "Tumbas de Mana",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Lago Pantanoso",
	["Menethil Harbor"] = "Porto de Menethil",
	-- ["Mogu'Shan Palace"] = "",
	-- ["Mogu'shan Vaults"] = "",
	["Molten Core"] = "Núcleo Derretido",
	["Molten Front"] = "Front Ígneo",
	Moonglade = "Clareira da Lua",
	["Mount Hyjal"] = "Monte Hyjal",
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Arena de Nagrand",
	Naxxramas = "Naxxramas",
	Netherstorm = "Eternévoa",
	["Night Elf Village"] = "Vila dos Elfos Noturnos",
	["Northern Barrens"] = "Sertões Setentrionais",
	["Northern Stranglethorn"] = "Selva do Espinhaço Setentrional",
	Northrend = "Nortúndria",
	["Obsidia's Perch"] = "Ninho de Obsídia",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Antigo Contraforte de Eira dos Montes",
	["Old Stratholme"] = "Antiga Altaforja",
	["Onyxia's Lair"] = "Covil da Onyxia",
	["Opening of the Dark Portal"] = "Abertura do Portal Negro",
	Orgrimmar = "Orgrimmar",
	Outland = "Terralém",
	["Pit of Saron"] = "Fosso de Saron",
	["Plaguelands: The Scarlet Enclave"] = "Terras Pestilentas: Enclave Escarlate",
	Plaguewood = "Bosque Pestilento",
	["Quel'thalas"] = "Quel'thalas",
	["Ragefire Chasm"] = "Cavernas Ígneas",
	Ratchet = "Vila Catraca",
	["Razorfen Downs"] = "Urzal dos Mortos",
	["Razorfen Kraul"] = "Urzal dos Tuscos",
	["Redridge Mountains"] = "Montanhas Cristarrubra",
	["Ring of Observance"] = "Círculo da Obediência",
	["Rivendark's Perch"] = "Ninho do Rivenegro",
	["Ruins of Ahn'Qiraj"] = "Ruínas de Ahn'Qiraj",
	["Ruins of Gilneas"] = "Ruínas de Guilnéas",
	["Ruins of Gilneas City"] = "Ruínas de Guilnéas",
	["Ruins of Lordaeron"] = "Ruínas de Lordaeron",
	["Scalebeard's Cave"] = "Caverna do Barbescama",
	["Scarlet Monastery"] = "Monastério Escarlate",
	Scholomance = "Scolomântia",
	["Searing Gorge"] = "Garganta Abrasadora",
	["Serpent Lake"] = "Lago Serpente",
	["Serpentshrine Cavern"] = "Caverna do Serpentário",
	["Sethekk Halls"] = "Salões dos Sethekk",
	-- ["Shado-pan Monastery"] = "",
	["Shadowfang Keep"] = "Bastilha da Presa Negra",
	["Shadow Labyrinth"] = "Labirinto Soturno",
	["Shadowmoon Valley"] = "Vale da Lua Negra",
	["Shartuul's Transporter"] = "Transporte de Shartuul",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Shattrath",
	["Shimmering Expanse"] = "Vastidão Cintilante",
	["Sholazar Basin"] = "Bacia Sholazar",
	-- ["Siege of Niuzao Temple"] = "",
	Silithus = "Silithus",
	["Silvermoon City"] = "Luaprata",
	["Silverpine Forest"] = "Floresta de Pinhaprata",
	["Skyguard Outpost"] = "Posto Avançado da Guarda Aérea",
	["Skysong Lake"] = "Lago Celicanto",
	["Southern Barrens"] = "Sertões Meridionais",
	["Sporewind Lake"] = "Lago dos Esporos",
	Stonard = "Pedregal",
	["Stonetalon Mountains"] = "Cordilheira das Torres de Pedra",
	-- ["Stormstout Brewery"] = "",
	Stormwind = "Ventobravo",
	["Stormwind City"] = "Ventobravo",
	["Strand of the Ancients"] = "Baía dos Ancestrais",
	["Stranglethorn Vale"] = "Selva do Espinhaço",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "Sunken Temple",
	["Sunwell Plateau"] = "Platô da Nascente do Sol",
	["Swamp of Sorrows"] = "Pântano das Mágoas",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "Bastilha da Tormenta",
	["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj",
	-- ["Temple of the Jade Serpent"] = "",
	["Terokkar Forest"] = "Mata Terokkar",
	["Terokk's Rest"] = "Repouso de Terokk",
	-- ["Terrace of Endless Spring"] = "",
	["The Arachnid Quarter"] = "O Distrito dos Aracnídeos",
	["The Arcatraz"] = "Arcatraz",
	["The Argent Coliseum"] = "Archivum",
	["The Barrens"] = "Sertões Meridionais",
	["The Bastion of Twilight"] = "Bastião do Crepúsculo",
	["The Battle for Gilneas"] = "A Batalha por Guilnéas",
	["The Black Morass"] = "Lamaçal Negro",
	["The Blood Furnace"] = "Fornalha de Sangue",
	["The Bone Wastes"] = "Deserto de Ossos",
	["The Botanica"] = "Jardim Botânico",
	["The Cape of Stranglethorn"] = "Cabo do Espinhaço",
	["The Construct Quarter"] = "O Distrito dos Constructos",
	["The Culling of Stratholme"] = "Expurgo de Stratholme",
	["The Dark Portal"] = "Portal Negro",
	["The Deadmines"] = "Minas Mortas",
	["The Descent into Madness"] = "A Espiral da Loucura",
	-- ["The Dragon Wastes"] = "",
	["The Escape From Durnholde"] = "A Fuga de Forte do Desterro",
	["The Exodar"] = "Exodar",
	["The Eye"] = "O Olho",
	["The Eye of Eternity"] = "Olho da Eternidade",
	["The Forbidding Sea"] = "O Mar Proibido",
	["The Forge of Souls"] = "Forja das Almas",
	["The Frozen Halls"] = "Salões Gelados",
	["The Frozen Sea"] = "Mar Congelado",
	["The Great Sea"] = "Grande Oceano",
	["The Halls of Winter"] = "Os Salões do Inverno",
	["The Hinterlands"] = "Terras Agrestes",
	["The Lost Isles"] = "Ilhas Perdidas",
	["The Maelstrom"] = "Voragem",
	["The Mechanar"] = "Mecanar",
	["The Military Quarter"] = "O Distrito Militar",
	-- ["The Molten Core"] = "",
	["The Nexus"] = "Nexus - Missão Lendária",
	["The North Sea"] = "Mar do Norte",
	["The Obsidian Sanctum"] = "Santuário Obsidiano",
	["The Oculus"] = "Óculus",
	["The Plague Quarter"] = "O Distrito da Peste",
	["The Prison of Yogg-Saron"] = "Prisão de Yogg-Saron",
	["Theramore Isle"] = "Ilha Theramore",
	["The Ring of Valor"] = "Ringue dos Valorosos",
	["The Ruby Sanctum"] = "Santuário Rubi",
	["The Scarlet Enclave"] = "Enclave Escarlate",
	["The Shattered Halls"] = "Salões Despedaçados",
	["The Slave Pens"] = "Pátio dos Escravos",
	["The Spark of Imagination"] = "Centelha da Imaginação",
	["The Steamvault"] = "Câmara dos Vapores",
	["The Stockade"] = "O Cárcere",
	["The Stonecore"] = "Litocerne",
	["The Storm Peaks"] = "Picos Tempestuosos",
	["The Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar",
	["The Underbog"] = "Brejo Oculto",
	["The Veiled Sea"] = "Mar Velado",
	["The Violet Hold"] = "Castelo Violeta",
	["The Vortex Pinnacle"] = "Pináculo do Vórtice",
	["Thousand Needles"] = "Mil Agulhas",
	["Throne of the Four Winds"] = "Trono dos Quatro Ventos",
	["Throne of the Tides"] = "Trono das Marés",
	["Thunder Bluff"] = "Penhasco do Trovão",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Clareiras de Tirisfal",
	["Tol Barad"] = "Tol Barad",
	["Tol Barad Peninsula"] = "Península de Tol Barad",
	["Trial of the Champion"] = "Prova do Campeão",
	["Trial of the Crusader"] = "Prova do Cruzado",
	["Twilight Highlands"] = "Planalto do Crepúsculo",
	["Twin Peaks"] = "Montes Gêmeos",
	["Twisting Nether"] = "Espiral Etérea",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Uldum = "Uldum",
	Undercity = "Cidade Baixa",
	["Un'Goro Crater"] = "Cratera Un'Goro",
	["Upper Blackrock Spire"] = "Pico da Rocha Negra Superior",
	["Utgarde Keep"] = "Bastilha Utgarde",
	["Utgarde Pinnacle"] = "Pináculo Utgarde",
	["Vashj'ir"] = "Vashj'ir",
	["Vault of Archavon"] = "Abóbada de Arcavon",
	["Vortex Pinnacle"] = "Pináculo do Vórtice",
	["Wailing Caverns"] = "Caverna Ululante",
	["Warsong Gulch"] = "Ravina Brado Guerreiro",
	["Well of Eternity"] = "Nascente da Eternidade",
	["Western Plaguelands"] = "Terras Pestilentas Ocidentais",
	Westfall = "Cerro Oeste",
	Wetlands = "Pantanal",
	Wintergrasp = "Invérnia",
	Winterspring = "Hibérnia",
	["Wyrmrest Temple"] = "Templo do Repouso das Serpes",
	Zangarmarsh = "Pântano Zíngaro",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}
elseif GAME_LOCALE == "ruRU" then
	lib:SetCurrentTranslations {
	["Abyssal Depths"] = "Бездонные глубины",
	["Ahn'kahet: The Old Kingdom"] = "Ан'кахет: Старое Королевство",
	["Ahn'Qiraj"] = "Ан'Кираж",
	["Ahn'Qiraj: The Fallen Kingdom"] = "Ан'Кираж: Павшее Королевство",
	["Alliance Base"] = "База Альянса",
	["Alterac Mountains"] = "Альтеракские горы",
	["Alterac Valley"] = "Альтеракская долина",
	["Amani Pass"] = "Перевал Амани",
	["Arathi Basin"] = "Низина Арати",
	["Arathi Highlands"] = "Нагорье Арати",
	Armory = "Оружейная",
	Ashenvale = "Ясеневый лес",
	Auberdine = "Аубердин",
	["Auchenai Crypts"] = "Аукенайские гробницы",
	Auchindoun = "Аукиндон",
	Azeroth = "Азерот",
	["Azjol-Nerub"] = "Азжол-Неруб",
	Azshara = "Азшара",
	["Azuremyst Isle"] = "Остров Лазурной Дымки",
	Badlands = "Бесплодные земли",
	["Baradin Hold"] = "Крепость Барадин",
	["Bash'ir Landing"] = "Лагерь Баш'ира",
	["Battle for Gilneas"] = "Битва за Гилнеас",
	["Blackfathom Deeps"] = "Непроглядная Пучина",
	["Blackrock Caverns"] = "Пещеры Черной горы",
	["Blackrock Depths"] = "Глубины Черной горы",
	["Blackrock Mountain"] = "Черная гора",
	["Blackrock Spire"] = "Пик Черной горы",
	["Black Temple"] = "Черный храм",
	["Blackwind Lake"] = "Озеро Черного Ветра",
	["Blackwing Descent"] = "Твердыня Крыла Тьмы",
	["Blackwing Lair"] = "Логово Крыла Тьмы",
	["Blade's Edge Arena"] = "Арена Острогорья",
	["Blade's Edge Mountains"] = "Острогорье",
	["Blasted Lands"] = "Выжженные земли",
	["Bloodmyst Isle"] = "Остров Кровавой Дымки",
	["Booty Bay"] = "Пиратская Бухта",
	["Borean Tundra"] = "Борейская тундра",
	["Burning Steppes"] = "Пылающие степи",
	Cathedral = "Собор",
	["Caverns of Time"] = "Пещеры Времени",
	["Champions' Hall"] = "Зал Защитника",
	["Coilfang Reservoir"] = "Резервуар Кривого Клыка",
	Coldarra = "Хладарра",
	["Cosmic map"] = "Карта Вселенной",
	["Crystalsong Forest"] = "Лес Хрустальной Песни",
	["Crystal Spine"] = "Хрустальное поле",
	Dalaran = "Даларан",
	["Dalaran Arena"] = "Арена Даларана",
	["Dalaran Sewers"] = "Арена Даларана",
	["Darkmoon Faire"] = "Ярмарка Новолуния",
	["Darkmoon Island"] = "Остров Новолуния",
	Darkshore = "Темные берега",
	Darnassus = "Дарнас",
	Deadmines = "Мертвые копи",
	["Deadwind Pass"] = "Перевал Мертвого Ветра",
	Deepholm = "Подземье",
	["Deeprun Tram"] = "Подземный поезд",
	Desolace = "Пустоши",
	["Dire Maul"] = "Забытый Город",
	["Dire Maul (East)"] = "Забытый Город: Восток",
	["Dire Maul (North)"] = "Забытый Город: Север",
	["Dire Maul (West)"] = "Забытый Город: Запад",
	Dragonblight = "Драконий Погост",
	["Dragon Soul"] = "Душа Дракона",
	["Drak'Tharon Keep"] = "Крепость Драк'Тарон",
	["Dun Morogh"] = "Дун Морог",
	Durotar = "Дуротар",
	Duskwood = "Сумеречный лес",
	["Dustwallow Marsh"] = "Пылевые топи",
	["Eastern Kingdoms"] = "Восточные королевства",
	["Eastern Plaguelands"] = "Восточные Чумные земли",
	["Elwynn Forest"] = "Элвиннский лес",
	["End Time"] = "Конец Времен",
	Everlook = "Круговзор",
	["Eversong Woods"] = "Леса Вечной Песни",
	["Eye of the Storm"] = "Око Бури",
	Felwood = "Оскверненный лес",
	Feralas = "Фералас",
	Firelands = "Огненные Просторы",
	["Forge Camp: Terror"] = "Лагерь Легиона: Ужас",
	["Forge Camp: Wrath"] = "Лагерь Легиона: Гнев",
	["Frostwyrm Lair"] = "Логово Ледяного змея",
	["Furywing's Perch"] = "Гнездовье Ярокрыла",
	Gadgetzan = "Прибамбасск",
	-- ["Gate of the Setting Sun"] = "",
	["Gates of Ahn'Qiraj"] = "Врата Ан'Киража",
	Ghostlands = "Призрачные земли",
	Gilneas = "Гилнеас",
	["Gilneas City"] = "Гилнеас",
	Gnomeregan = "Гномреган",
	Graveyard = "Кладбище",
	["Grim Batol"] = "Грим Батол",
	["Grizzly Hills"] = "Седые холмы",
	["Grom'gol Base Camp"] = "Лагерь Гром'гол",
	["Gruul's Lair"] = "Логово Груула",
	Gundrak = "Гундрак",
	["Hall of Blackhand"] = "Зал Чернорука",
	["Hall of Champions"] = "Чертог Защитников",
	["Hall of Legends"] = "Зал Легенд",
	["Halls of Lightning"] = "Чертоги Молний",
	["Halls of Origination"] = "Чертоги Созидания",
	["Halls of Reflection"] = "Залы Отражений",
	["Halls of Stone"] = "Чертоги Камня",
	-- ["Heart of Fear"] = "",
	["Hellfire Citadel"] = "Цитадель Адского Пламени",
	["Hellfire Peninsula"] = "Полуостров Адского Пламени",
	["Hellfire Ramparts"] = "Бастионы Адского Пламени",
	["Hillsbrad Foothills"] = "Предгорья Хилсбрада",
	["Horde Encampment"] = "Стоянка Орды",
	["Hour of Twilight"] = "Время Сумерек",
	["Howling Fjord"] = "Ревущий фьорд",
	["Hrothgar's Landing"] = "Лагерь Хротгара",
	Hyjal = "Хиджал",
	["Hyjal Summit"] = "Вершина Хиджала",
	Icecrown = "Ледяная Корона",
	["Icecrown Citadel"] = "Цитадель Ледяной Короны",
	["Insidion's Perch"] = "Гнездо Инсидиона",
	Ironforge = "Стальгорн",
	["Isle of Conquest"] = "Остров Завоеваний",
	["Isle of Quel'Danas"] = "Остров Кель'Данас",
	Kalimdor = "Калимдор",
	Karazhan = "Каражан",
	["Kelp'thar Forest"] = "Лес Келп’тар",
	Kezan = "Кезан",
	["Krasus' Landing"] = "Площадка Краса",
	Library = "Библиотека",
	["Loch Modan"] = "Лок Модан",
	["Lost City of the Tol'vir"] = "Затерянный город Тол'вир",
	["Lower Blackrock Spire"] = "Нижний ярус Черной горы",
	["Magisters' Terrace"] = "Терраса Магистров",
	["Magtheridon's Lair"] = "Логово Магтеридона",
	["Mana-Tombs"] = "Гробницы Маны",
	Maraudon = "Мародон",
	["Marshlight Lake"] = "Озеро Болотных Огоньков",
	["Menethil Harbor"] = "Гавань Менетилов",
	-- ["Mogu'Shan Palace"] = "",
	-- ["Mogu'shan Vaults"] = "",
	["Molten Core"] = "Огненные Недра",
	["Molten Front"] = "Огненная передовая",
	Moonglade = "Лунная поляна",
	["Mount Hyjal"] = "Хиджал",
	Mulgore = "Мулгор",
	Nagrand = "Награнд",
	["Nagrand Arena"] = "Арена Награнда",
	Naxxramas = "Наксрамас",
	Netherstorm = "Пустоверть",
	["Night Elf Village"] = "Деревня ночных эльфов",
	["Northern Barrens"] = "Северные Степи",
	["Northern Stranglethorn"] = "Северная Тернистая долина",
	Northrend = "Нордскол",
	["Obsidia's Perch"] = "Гнездо Обсидии",
	["Ogri'la"] = "Огри'ла",
	["Old Hillsbrad Foothills"] = "Старые предгорья Хилсбрада",
	["Old Stratholme"] = "Старый Стратхольм",
	["Onyxia's Lair"] = "Логово Ониксии",
	["Opening of the Dark Portal"] = "Открытие Темного портала",
	Orgrimmar = "Оргриммар",
	Outland = "Запределье",
	["Pit of Saron"] = "Яма Сарона",
	["Plaguelands: The Scarlet Enclave"] = "Чумные земли: Анклав Алого ордена",
	Plaguewood = "Проклятый лес",
	["Quel'thalas"] = "Кель'Талас",
	["Ragefire Chasm"] = "Огненная пропасть",
	Ratchet = "Кабестан",
	["Razorfen Downs"] = "Курганы Иглошкурых",
	["Razorfen Kraul"] = "Лабиринты Иглошкурых",
	["Redridge Mountains"] = "Красногорье",
	["Ring of Observance"] = "Ритуальный Круг",
	["Rivendark's Perch"] = "Гнездо Чернокрыла",
	["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража",
	["Ruins of Gilneas"] = "Руины Гилнеаса",
	["Ruins of Gilneas City"] = "Руины Гилнеаса",
	["Ruins of Lordaeron"] = "Руины Лордерона",
	["Scalebeard's Cave"] = "Пещера Чешуеборода",
	["Scarlet Monastery"] = "Монастырь Алого ордена",
	Scholomance = "Некроситет",
	["Searing Gorge"] = "Тлеющее ущелье",
	["Serpent Lake"] = "Змеиное озеро",
	["Serpentshrine Cavern"] = "Змеиное святилище",
	["Sethekk Halls"] = "Сетеккские залы",
	-- ["Shado-pan Monastery"] = "",
	["Shadowfang Keep"] = "Крепость Темного Клыка",
	["Shadow Labyrinth"] = "Темный лабиринт",
	["Shadowmoon Valley"] = "Долина Призрачной Луны",
	["Shartuul's Transporter"] = "Транспортер Шартуула",
	Shattrath = "Шаттрат",
	["Shattrath City"] = "Шаттрат",
	["Shimmering Expanse"] = "Мерцающий простор",
	["Sholazar Basin"] = "Низина Шолазар",
	-- ["Siege of Niuzao Temple"] = "",
	Silithus = "Силитус",
	["Silvermoon City"] = "Луносвет",
	["Silverpine Forest"] = "Серебряный бор",
	["Skyguard Outpost"] = "Застава Стражи Небес",
	["Skysong Lake"] = "Озеро Небесной Песни",
	["Southern Barrens"] = "Южные Степи",
	["Sporewind Lake"] = "Озеро Спороветра",
	Stonard = "Каменор",
	["Stonetalon Mountains"] = "Когтистые горы",
	-- ["Stormstout Brewery"] = "",
	Stormwind = "Штормград",
	["Stormwind City"] = "Штормград",
	["Strand of the Ancients"] = "Берег Древних",
	["Stranglethorn Vale"] = "Тернистая долина",
	Stratholme = "Стратхольм",
	["Sunken Temple"] = "Затонувший храм",
	["Sunwell Plateau"] = "Плато Солнечного Колодца",
	["Swamp of Sorrows"] = "Болото Печали",
	Tanaris = "Танарис",
	Teldrassil = "Тельдрассил",
	["Tempest Keep"] = "Крепость Бурь",
	["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж",
	-- ["Temple of the Jade Serpent"] = "",
	["Terokkar Forest"] = "Лес Тероккар",
	["Terokk's Rest"] = "Покой Терокка",
	-- ["Terrace of Endless Spring"] = "",
	["The Arachnid Quarter"] = "Паучий квартал",
	["The Arcatraz"] = "Аркатрац",
	["The Argent Coliseum"] = "Испытание крестоносца",
	["The Barrens"] = "Степи",
	["The Bastion of Twilight"] = "Сумеречный бастион",
	["The Battle for Gilneas"] = "Битва за Гилнеас",
	["The Black Morass"] = "Черные топи",
	["The Blood Furnace"] = "Кузня Крови",
	["The Bone Wastes"] = "Костяные пустоши",
	["The Botanica"] = "Ботаника",
	["The Cape of Stranglethorn"] = "Мыс Тернистой долины",
	["The Construct Quarter"] = "Квартал Мерзости",
	["The Culling of Stratholme"] = "Очищение Стратхольма",
	["The Dark Portal"] = "Темный портал",
	["The Deadmines"] = "Мертвые копи",
	["The Descent into Madness"] = "Провал Безумия",
	-- ["The Dragon Wastes"] = "",
	["The Escape From Durnholde"] = "Побег из Дарнхольда",
	["The Exodar"] = "Экзодар",
	["The Eye"] = "Око",
	["The Eye of Eternity"] = "Око Вечности",
	["The Forbidding Sea"] = "Зловещее море",
	["The Forge of Souls"] = "Кузня Душ",
	["The Frozen Halls"] = "Ледяные залы",
	["The Frozen Sea"] = "Ледяное море",
	["The Great Sea"] = "Великое море",
	["The Halls of Winter"] = "Залы Зимы",
	["The Hinterlands"] = "Внутренние земли",
	["The Lost Isles"] = "Затерянные острова",
	["The Maelstrom"] = "Водоворот",
	["The Mechanar"] = "Механар",
	["The Military Quarter"] = "Военный квартал",
	-- ["The Molten Core"] = "",
	["The Nexus"] = "Нексус",
	["The North Sea"] = "Северное море",
	["The Obsidian Sanctum"] = "Обсидиановое святилище",
	["The Oculus"] = "Окулус",
	["The Plague Quarter"] = "Чумной квартал",
	["The Prison of Yogg-Saron"] = "Темница Йогг-Сарона",
	["Theramore Isle"] = "Остров Терамор",
	["The Ring of Valor"] = "Круг Доблести",
	["The Ruby Sanctum"] = "Рубиновое святилище",
	["The Scarlet Enclave"] = "Анклав Алого ордена",
	["The Shattered Halls"] = "Разрушенные залы",
	["The Slave Pens"] = "Узилище",
	["The Spark of Imagination"] = "Искра Воображения",
	["The Steamvault"] = "Паровое подземелье",
	["The Stockade"] = "Тюрьма",
	["The Stonecore"] = "Каменные Недра",
	["The Storm Peaks"] = "Грозовая Гряда",
	["The Temple of Atal'Hakkar"] = "Храм Атал'Хаккара",
	["The Underbog"] = "Нижетопь",
	["The Veiled Sea"] = "Сокрытое Море",
	["The Violet Hold"] = "Аметистовая крепость",
	["The Vortex Pinnacle"] = "Вершина смерча",
	["Thousand Needles"] = "Тысяча Игл",
	["Throne of the Four Winds"] = "Трон Четырех Ветров",
	["Throne of the Tides"] = "Трон Приливов",
	["Thunder Bluff"] = "Громовой Утес",
	Tirisfal = "Тирисфальские леса",
	["Tirisfal Glades"] = "Тирисфальские леса",
	["Tol Barad"] = "Тол Барад",
	["Tol Barad Peninsula"] = "Полуостров Тол Барад",
	["Trial of the Champion"] = "Испытание чемпиона",
	["Trial of the Crusader"] = "Испытание крестоносца",
	["Twilight Highlands"] = "Сумеречное нагорье",
	["Twin Peaks"] = "Два Пика",
	["Twisting Nether"] = "Круговерть Пустоты",
	Uldaman = "Ульдаман",
	Ulduar = "Ульдуар",
	Uldum = "Ульдум",
	Undercity = "Подгород",
	["Un'Goro Crater"] = "Кратер Ун'Горо",
	["Upper Blackrock Spire"] = "Верхний ярус Черной горы",
	["Utgarde Keep"] = "Крепость Утгард",
	["Utgarde Pinnacle"] = "Вершина Утгард",
	["Vashj'ir"] = "Вайш'ир",
	["Vault of Archavon"] = "Склеп Аркавона",
	["Vortex Pinnacle"] = "Вершина смерча",
	["Wailing Caverns"] = "Пещеры Стенаний",
	["Warsong Gulch"] = "Ущелье Песни Войны",
	["Well of Eternity"] = "Источник Вечности",
	["Western Plaguelands"] = "Западные Чумные земли",
	Westfall = "Западный Край",
	Wetlands = "Болотина",
	Wintergrasp = "Озеро Ледяных Оков",
	Winterspring = "Зимние Ключи",
	["Wyrmrest Temple"] = "Храм Драконьего Покоя",
	Zangarmarsh = "Зангартопь",
	["Zul'Aman"] = "Зул'Аман",
	["Zul'Drak"] = "Зул'Драк",
	["Zul'Farrak"] = "Зул'Фаррак",
	["Zul'Gurub"] = "Зул'Гуруб",
}
elseif GAME_LOCALE == "zhCN" then
	lib:SetCurrentTranslations {
	["Abyssal Depths"] = "无底海渊",
	["Ahn'kahet: The Old Kingdom"] = "安卡赫特：古代王国",
	["Ahn'Qiraj"] = "安其拉",
	["Ahn'Qiraj: The Fallen Kingdom"] = "安其拉：堕落王国",
	["Alliance Base"] = "联盟基地",
	["Alterac Mountains"] = "奥特兰克山脉",
	["Alterac Valley"] = "奥特兰克山谷",
	["Amani Pass"] = "阿曼尼小径",
	["Arathi Basin"] = "阿拉希盆地",
	["Arathi Highlands"] = "阿拉希高地",
	Armory = "军械库",
	Ashenvale = "灰谷",
	Auberdine = "奥伯丁",
	["Auchenai Crypts"] = "奥金尼地穴",
	Auchindoun = "奥金顿",
	Azeroth = "艾泽拉斯",
	["Azjol-Nerub"] = "艾卓-尼鲁布",
	Azshara = "艾萨拉",
	["Azuremyst Isle"] = "秘蓝岛",
	Badlands = "荒芜之地",
	["Baradin Hold"] = "巴拉丁监狱",
	["Bash'ir Landing"] = "巴什伊尔码头",
	["Battle for Gilneas"] = "吉尔尼斯之战",
	["Blackfathom Deeps"] = "黑暗深渊",
	["Blackrock Caverns"] = "黑石岩窟",
	["Blackrock Depths"] = "黑石深渊",
	["Blackrock Mountain"] = "黑石山",
	["Blackrock Spire"] = "黑石塔",
	["Black Temple"] = "黑暗神殿",
	["Blackwind Lake"] = "黑风湖",
	["Blackwing Descent"] = "黑翼血环",
	["Blackwing Lair"] = "黑翼之巢",
	["Blade's Edge Arena"] = "刀锋山竞技场",
	["Blade's Edge Mountains"] = "刀锋山",
	["Blasted Lands"] = "诅咒之地",
	["Bloodmyst Isle"] = "秘血岛",
	["Booty Bay"] = "藏宝海湾",
	["Borean Tundra"] = "北风苔原",
	["Burning Steppes"] = "燃烧平原",
	Cathedral = "教堂",
	["Caverns of Time"] = "时光之穴",
	["Champions' Hall"] = "勇士大厅",
	["Coilfang Reservoir"] = "盘牙水库",
	Coldarra = "考达拉",
	["Cosmic map"] = "全部地图",
	["Crystalsong Forest"] = "晶歌森林",
	["Crystal Spine"] = "水晶之脊",
	Dalaran = "达拉然",
	["Dalaran Arena"] = "达拉然竞技场",
	["Dalaran Sewers"] = "达拉然下水道",
	["Darkmoon Faire"] = "暗月马戏团",
	["Darkmoon Island"] = "暗月岛",
	Darkshore = "黑海岸",
	Darnassus = "达纳苏斯",
	Deadmines = "死亡矿井",
	["Deadwind Pass"] = "逆风小径",
	Deepholm = "深岩之洲",
	["Deeprun Tram"] = "矿道地铁",
	Desolace = "凄凉之地",
	["Dire Maul"] = "厄运之槌",
	["Dire Maul (East)"] = "厄运之槌（东）",
	["Dire Maul (North)"] = "厄运之槌（北）",
	["Dire Maul (West)"] = "厄运之槌（西）",
	Dragonblight = "龙骨荒野",
	["Dragon Soul"] = "巨龙之魂",
	["Drak'Tharon Keep"] = "达克萨隆要塞",
	["Dun Morogh"] = "丹莫罗",
	Durotar = "杜隆塔尔",
	Duskwood = "暮色森林",
	["Dustwallow Marsh"] = "尘泥沼泽",
	["Eastern Kingdoms"] = "东部王国",
	["Eastern Plaguelands"] = "东瘟疫之地",
	["Elwynn Forest"] = "艾尔文森林",
	["End Time"] = "时光之末",
	Everlook = "永望镇",
	["Eversong Woods"] = "永歌森林",
	["Eye of the Storm"] = "风暴之眼",
	Felwood = "费伍德森林",
	Feralas = "菲拉斯",
	Firelands = "火焰之地",
	["Forge Camp: Terror"] = "铸魔营地：恐怖",
	["Forge Camp: Wrath"] = "铸魔营地：天罚",
	["Frostwyrm Lair"] = "冰霜巨龙的巢穴",
	["Furywing's Perch"] = "弗雷文栖木",
	Gadgetzan = "加基森",
	-- ["Gate of the Setting Sun"] = "",
	["Gates of Ahn'Qiraj"] = "安其拉之门",
	Ghostlands = "幽魂之地",
	Gilneas = "吉尔尼斯",
	["Gilneas City"] = "吉尔尼斯城",
	Gnomeregan = "诺莫瑞根",
	Graveyard = "墓地",
	["Grim Batol"] = "格瑞姆巴托",
	["Grizzly Hills"] = "灰熊丘陵",
	["Grom'gol Base Camp"] = "格罗姆高营地",
	["Gruul's Lair"] = "格鲁尔的巢穴",
	Gundrak = "古达克",
	["Hall of Blackhand"] = "黑手大厅",
	["Hall of Champions"] = "勇士大厅",
	["Hall of Legends"] = "传说大厅",
	["Halls of Lightning"] = "闪电大厅",
	["Halls of Origination"] = "起源大厅",
	["Halls of Reflection"] = "映像大厅",
	["Halls of Stone"] = "岩石大厅",
	-- ["Heart of Fear"] = "",
	["Hellfire Citadel"] = "地狱火堡垒",
	["Hellfire Peninsula"] = "地狱火半岛",
	["Hellfire Ramparts"] = "地狱火城墙",
	["Hillsbrad Foothills"] = "希尔斯布莱德丘陵",
	["Horde Encampment"] = "部落营地",
	["Hour of Twilight"] = "暮光审判",
	["Howling Fjord"] = "嚎风峡湾",
	["Hrothgar's Landing"] = "洛斯加尔登陆点",
	Hyjal = "海加尔山",
	["Hyjal Summit"] = "海加尔峰",
	Icecrown = "冰冠冰川",
	["Icecrown Citadel"] = "冰冠堡垒",
	["Insidion's Perch"] = "因斯迪安栖木",
	Ironforge = "铁炉堡",
	["Isle of Conquest"] = "征服之岛",
	["Isle of Quel'Danas"] = "奎尔丹纳斯岛",
	Kalimdor = "卡利姆多",
	Karazhan = "卡拉赞",
	["Kelp'thar Forest"] = "柯尔普萨之森",
	Kezan = "科赞",
	["Krasus' Landing"] = "克拉苏斯平台",
	Library = "图书馆",
	["Loch Modan"] = "洛克莫丹",
	["Lost City of the Tol'vir"] = "托维尔失落之城",
	["Lower Blackrock Spire"] = "下层黑石塔",
	["Magisters' Terrace"] = "魔导师平台",
	["Magtheridon's Lair"] = "玛瑟里顿的巢穴",
	["Mana-Tombs"] = "法力陵墓",
	Maraudon = "玛拉顿",
	["Marshlight Lake"] = "沼光湖",
	["Menethil Harbor"] = "米奈希尔港",
	-- ["Mogu'Shan Palace"] = "",
	-- ["Mogu'shan Vaults"] = "",
	["Molten Core"] = "熔火之心",
	["Molten Front"] = "熔火前线",
	Moonglade = "月光林地",
	["Mount Hyjal"] = "海加尔",
	Mulgore = "莫高雷",
	Nagrand = "纳格兰",
	["Nagrand Arena"] = "纳格兰竞技场",
	Naxxramas = "纳克萨玛斯",
	Netherstorm = "虚空风暴",
	["Night Elf Village"] = "暗夜精灵村庄",
	["Northern Barrens"] = "北贫瘠之地",
	["Northern Stranglethorn"] = "北荆棘谷",
	Northrend = "诺森德",
	["Obsidia's Perch"] = "欧比斯迪栖木",
	["Ogri'la"] = "奥格瑞拉",
	["Old Hillsbrad Foothills"] = "旧希尔斯布莱德丘陵",
	["Old Stratholme"] = "旧斯坦索姆",
	["Onyxia's Lair"] = "奥妮克希亚的巢穴",
	["Opening of the Dark Portal"] = "开启黑暗之门",
	Orgrimmar = "奥格瑞玛",
	Outland = "外域",
	["Pit of Saron"] = "萨隆矿坑",
	["Plaguelands: The Scarlet Enclave"] = "东瘟疫之地：血色领地",
	Plaguewood = "病木林",
	["Quel'thalas"] = "奎尔萨拉斯",
	["Ragefire Chasm"] = "怒焰裂谷",
	Ratchet = "棘齿城",
	["Razorfen Downs"] = "剃刀高地",
	["Razorfen Kraul"] = "剃刀沼泽",
	["Redridge Mountains"] = "赤脊山",
	["Ring of Observance"] = "仪式广场",
	["Rivendark's Perch"] = "雷文达克栖木",
	["Ruins of Ahn'Qiraj"] = "安其拉废墟",
	["Ruins of Gilneas"] = "吉尔尼斯废墟",
	["Ruins of Gilneas City"] = "吉尔尼斯城废墟",
	["Ruins of Lordaeron"] = "洛丹伦废墟",
	["Scalebeard's Cave"] = "鳞须海龟洞穴",
	["Scarlet Monastery"] = "血色修道院",
	Scholomance = "通灵学院",
	["Searing Gorge"] = "灼热峡谷",
	["Serpent Lake"] = "毒蛇湖",
	["Serpentshrine Cavern"] = "毒蛇神殿",
	["Sethekk Halls"] = "塞泰克大厅",
	-- ["Shado-pan Monastery"] = "",
	["Shadowfang Keep"] = "影牙城堡",
	["Shadow Labyrinth"] = "暗影迷宫",
	["Shadowmoon Valley"] = "影月谷",
	["Shartuul's Transporter"] = "沙图尔的传送器",
	Shattrath = "沙塔斯",
	["Shattrath City"] = "沙塔斯城",
	["Shimmering Expanse"] = "烁光海床",
	["Sholazar Basin"] = "索拉查盆地",
	-- ["Siege of Niuzao Temple"] = "",
	Silithus = "希利苏斯",
	["Silvermoon City"] = "银月城",
	["Silverpine Forest"] = "银松森林",
	["Skyguard Outpost"] = "天空卫队哨站",
	["Skysong Lake"] = "天歌湖",
	["Southern Barrens"] = "南贫瘠之地",
	["Sporewind Lake"] = "孢子湖",
	Stonard = "斯通纳德",
	["Stonetalon Mountains"] = "石爪山脉",
	-- ["Stormstout Brewery"] = "",
	Stormwind = "暴风城",
	["Stormwind City"] = "暴风城",
	["Strand of the Ancients"] = "远古海滩",
	["Stranglethorn Vale"] = "荆棘谷",
	Stratholme = "斯坦索姆",
	["Sunken Temple"] = "沉没的神庙",
	["Sunwell Plateau"] = "太阳之井高地",
	["Swamp of Sorrows"] = "悲伤沼泽",
	Tanaris = "塔纳利斯",
	Teldrassil = "泰达希尔",
	["Tempest Keep"] = "风暴要塞",
	["Temple of Ahn'Qiraj"] = "安其拉神殿",
	-- ["Temple of the Jade Serpent"] = "",
	["Terokkar Forest"] = "泰罗卡森林",
	["Terokk's Rest"] = "泰罗克之墓",
	-- ["Terrace of Endless Spring"] = "",
	["The Arachnid Quarter"] = "蜘蛛区",
	["The Arcatraz"] = "禁魔监狱",
	["The Argent Coliseum"] = "银色试炼场",
	["The Barrens"] = "贫瘠之地",
	["The Bastion of Twilight"] = "暮光堡垒",
	["The Battle for Gilneas"] = "吉尔尼斯之战",
	["The Black Morass"] = "黑色沼泽",
	["The Blood Furnace"] = "鲜血熔炉",
	["The Bone Wastes"] = "白骨荒野",
	["The Botanica"] = "生态船",
	["The Cape of Stranglethorn"] = "荆棘谷海角",
	["The Construct Quarter"] = "构造区",
	["The Culling of Stratholme"] = "净化斯坦索姆",
	["The Dark Portal"] = "黑暗之门",
	["The Deadmines"] = "死亡矿井",
	["The Descent into Madness"] = "疯狂阶梯",
	["The Dragon Wastes"] = "巨龙废土", -- Needs review
	["The Escape From Durnholde"] = "逃离敦霍尔德",
	["The Exodar"] = "埃索达",
	["The Eye"] = "风暴要塞",
	["The Eye of Eternity"] = "永恒之眼",
	["The Forbidding Sea"] = "禁忌之海",
	["The Forge of Souls"] = "灵魂洪炉",
	["The Frozen Halls"] = "冰封大殿",
	["The Frozen Sea"] = "冰冻之海",
	["The Great Sea"] = "无尽之海",
	["The Halls of Winter"] = "寒冬之厅",
	["The Hinterlands"] = "辛特兰",
	["The Lost Isles"] = "失落群岛",
	["The Maelstrom"] = "大漩涡",
	["The Mechanar"] = "能源舰",
	["The Military Quarter"] = "军事区",
	["The Molten Core"] = "熔火之心", -- Needs review
	["The Nexus"] = "魔枢",
	["The North Sea"] = "北海",
	["The Obsidian Sanctum"] = "黑曜石圣殿",
	["The Oculus"] = "魔环",
	["The Plague Quarter"] = "瘟疫区",
	["The Prison of Yogg-Saron"] = "尤格-萨隆的监狱",
	["Theramore Isle"] = "塞拉摩岛",
	["The Ring of Valor"] = "勇气竞技场",
	["The Ruby Sanctum"] = "红玉圣殿",
	["The Scarlet Enclave"] = "血色领地",
	["The Shattered Halls"] = "破碎大厅",
	["The Slave Pens"] = "奴隶围栏",
	["The Spark of Imagination"] = "思想火花",
	["The Steamvault"] = "蒸汽地窟",
	["The Stockade"] = "监狱",
	["The Stonecore"] = "巨石之核",
	["The Storm Peaks"] = "风暴峭壁",
	["The Temple of Atal'Hakkar"] = "阿塔哈卡神庙",
	["The Underbog"] = "幽暗沼泽",
	["The Veiled Sea"] = "迷雾之海",
	["The Violet Hold"] = "紫罗兰监狱",
	["The Vortex Pinnacle"] = "旋云之巅",
	["Thousand Needles"] = "千针石林",
	["Throne of the Four Winds"] = "风神王座",
	["Throne of the Tides"] = "潮汐王座",
	["Thunder Bluff"] = "雷霆崖",
	Tirisfal = "提里斯法林地",
	["Tirisfal Glades"] = "提瑞斯法林地",
	["Tol Barad"] = "托尔巴拉德",
	["Tol Barad Peninsula"] = "托尔巴拉德半岛",
	["Trial of the Champion"] = "冠军的试炼",
	["Trial of the Crusader"] = "十字军的试炼",
	["Twilight Highlands"] = "暮光高地",
	["Twin Peaks"] = "双子峰",
	["Twisting Nether"] = "扭曲虚空",
	Uldaman = "奥达曼",
	Ulduar = "奥杜尔",
	Uldum = "奥丹姆",
	Undercity = "幽暗城",
	["Un'Goro Crater"] = "安戈洛环形山",
	["Upper Blackrock Spire"] = "上层黑石塔",
	["Utgarde Keep"] = "乌特加德城堡",
	["Utgarde Pinnacle"] = "乌特加德之巅",
	["Vashj'ir"] = "瓦丝琪尔",
	["Vault of Archavon"] = "阿尔卡冯的宝库",
	["Vortex Pinnacle"] = "漩涡峰",
	["Wailing Caverns"] = "哀嚎洞穴",
	["Warsong Gulch"] = "战歌峡谷",
	["Well of Eternity"] = "永恒之井",
	["Western Plaguelands"] = "西瘟疫之地",
	Westfall = "西部荒野",
	Wetlands = "湿地",
	Wintergrasp = "冬拥湖",
	Winterspring = "冬泉谷",
	["Wyrmrest Temple"] = "龙眠神殿",
	Zangarmarsh = "赞加沼泽",
	["Zul'Aman"] = "祖阿曼",
	["Zul'Drak"] = "祖达克",
	["Zul'Farrak"] = "祖尔法拉克",
	["Zul'Gurub"] = "祖尔格拉布",
}
elseif GAME_LOCALE == "zhTW" then
	lib:SetCurrentTranslations {
	["Abyssal Depths"] = "地獄深淵",
	["Ahn'kahet: The Old Kingdom"] = "安卡罕特:古王國",
	["Ahn'Qiraj"] = "安其拉",
	["Ahn'Qiraj: The Fallen Kingdom"] = "安其拉: 沒落的王朝",
	["Alliance Base"] = "聯盟營地",
	["Alterac Mountains"] = "奧特蘭克山脈",
	["Alterac Valley"] = "奧特蘭克山谷",
	["Amani Pass"] = "阿曼尼小俓",
	["Arathi Basin"] = "阿拉希盆地",
	["Arathi Highlands"] = "阿拉希高地",
	Armory = "軍械庫",
	Ashenvale = "梣谷",
	Auberdine = "奧伯丁",
	["Auchenai Crypts"] = "奧奇奈地穴",
	Auchindoun = "奧齊頓",
	Azeroth = "艾澤拉斯",
	["Azjol-Nerub"] = "阿茲歐-奈幽",
	Azshara = "艾薩拉",
	["Azuremyst Isle"] = "藍謎島",
	Badlands = "荒蕪之地",
	["Baradin Hold"] = "巴拉丁堡",
	["Bash'ir Landing"] = "貝許爾平臺",
	["Battle for Gilneas"] = "吉爾尼斯之戰",
	["Blackfathom Deeps"] = "黑暗深淵",
	["Blackrock Caverns"] = "黑石洞穴",
	["Blackrock Depths"] = "黑石深淵",
	["Blackrock Mountain"] = "黑石山",
	["Blackrock Spire"] = "黑石塔",
	["Black Temple"] = "黑暗神廟",
	["Blackwind Lake"] = "黑風湖",
	["Blackwing Descent"] = "黑翼陷窟",
	["Blackwing Lair"] = "黑翼之巢",
	["Blade's Edge Arena"] = "劍刃競技場",
	["Blade's Edge Mountains"] = "劍刃山脈",
	["Blasted Lands"] = "詛咒之地",
	["Bloodmyst Isle"] = "血謎島",
	["Booty Bay"] = "藏寶海灣",
	["Borean Tundra"] = "北風凍原",
	["Burning Steppes"] = "燃燒平原",
	Cathedral = "教堂",
	["Caverns of Time"] = "時光之穴",
	["Champions' Hall"] = "勇士大廳",
	["Coilfang Reservoir"] = "盤牙洞穴",
	Coldarra = "凜懼島",
	["Cosmic map"] = "宇宙地圖",
	["Crystalsong Forest"] = "水晶之歌森林",
	["Crystal Spine"] = "水晶背脊",
	Dalaran = "達拉然",
	["Dalaran Arena"] = "達拉然競技場",
	["Dalaran Sewers"] = "達拉然下水道",
	["Darkmoon Faire"] = "暗月馬戲團",
	["Darkmoon Island"] = "暗月島",
	Darkshore = "黑海岸",
	Darnassus = "達納蘇斯",
	Deadmines = "死亡礦坑",
	["Deadwind Pass"] = "逆風小徑",
	Deepholm = "地深之源",
	["Deeprun Tram"] = "礦道地鐵",
	Desolace = "淒涼之地",
	["Dire Maul"] = "厄運之槌",
	["Dire Maul (East)"] = "厄運之槌 - 東",
	["Dire Maul (North)"] = "厄運之槌 - 北",
	["Dire Maul (West)"] = "厄運之槌 - 西",
	Dragonblight = "龍骨荒野",
	["Dragon Soul"] = "巨龍之魂",
	["Drak'Tharon Keep"] = "德拉克薩隆要塞",
	["Dun Morogh"] = "丹莫洛",
	Durotar = "杜洛塔",
	Duskwood = "暮色森林",
	["Dustwallow Marsh"] = "塵泥沼澤",
	["Eastern Kingdoms"] = "東部王國",
	["Eastern Plaguelands"] = "東瘟疫之地",
	["Elwynn Forest"] = "艾爾文森林",
	["End Time"] = "終焉之刻",
	Everlook = "永望鎮",
	["Eversong Woods"] = "永歌森林",
	["Eye of the Storm"] = "暴風之眼",
	Felwood = "費伍德森林",
	Feralas = "菲拉斯",
	Firelands = "火源之界",
	["Forge Camp: Terror"] = "煉冶場:驚駭",
	["Forge Camp: Wrath"] = "煉冶場:憤怒",
	["Frostwyrm Lair"] = "冰霜巨龍的巢穴",
	["Furywing's Perch"] = "狂怒之翼棲所",
	Gadgetzan = "加基森",
	-- ["Gate of the Setting Sun"] = "",
	["Gates of Ahn'Qiraj"] = "安其拉之門",
	Ghostlands = "鬼魂之地",
	Gilneas = "吉爾尼斯",
	["Gilneas City"] = "吉爾尼斯城",
	Gnomeregan = "諾姆瑞根",
	Graveyard = "墓地",
	["Grim Batol"] = "格瑞姆巴托",
	["Grizzly Hills"] = "灰白之丘",
	["Grom'gol Base Camp"] = "格羅姆高營地",
	["Gruul's Lair"] = "戈魯爾之巢",
	Gundrak = "剛德拉克",
	["Hall of Blackhand"] = "黑手大廳",
	["Hall of Champions"] = "勇士大廳",
	["Hall of Legends"] = "傳說大廳",
	["Halls of Lightning"] = "雷光大廳",
	["Halls of Origination"] = "起源大廳",
	["Halls of Reflection"] = "倒影大廳",
	["Halls of Stone"] = "石之大廳",
	-- ["Heart of Fear"] = "",
	["Hellfire Citadel"] = "地獄火堡壘",
	["Hellfire Peninsula"] = "地獄火半島",
	["Hellfire Ramparts"] = "地獄火壁壘",
	["Hillsbrad Foothills"] = "希爾斯布萊德丘陵",
	["Horde Encampment"] = "部落營地",
	["Hour of Twilight"] = "暮光之時",
	["Howling Fjord"] = "凜風峽灣",
	["Hrothgar's Landing"] = "赫魯斯加臺地",
	Hyjal = "海加爾山",
	["Hyjal Summit"] = "海加爾山",
	Icecrown = "寒冰皇冠",
	["Icecrown Citadel"] = "冰冠城塞",
	["Insidion's Perch"] = "印希迪恩棲所",
	Ironforge = "鐵爐堡",
	["Isle of Conquest"] = "征服之島",
	["Isle of Quel'Danas"] = "奎爾達納斯之島",
	Kalimdor = "卡林多",
	Karazhan = "卡拉贊",
	["Kelp'thar Forest"] = "凱波薩爾森林",
	Kezan = "凱贊",
	["Krasus' Landing"] = "卡薩斯平臺",
	Library = "圖書館",
	["Loch Modan"] = "洛克莫丹",
	["Lost City of the Tol'vir"] = "托維爾的失落之城",
	["Lower Blackrock Spire"] = "低階黑石塔",
	["Magisters' Terrace"] = "博學者殿堂",
	["Magtheridon's Lair"] = "瑪瑟里頓的巢穴",
	["Mana-Tombs"] = "法力墓地",
	Maraudon = "瑪拉頓",
	["Marshlight Lake"] = "沼澤光之湖",
	["Menethil Harbor"] = "米奈希爾港",
	-- ["Mogu'Shan Palace"] = "",
	-- ["Mogu'shan Vaults"] = "",
	["Molten Core"] = "熔火之心",
	["Molten Front"] = "熔岩前線",
	Moonglade = "月光林地",
	["Mount Hyjal"] = "海加爾山",
	Mulgore = "莫高雷",
	Nagrand = "納葛蘭",
	["Nagrand Arena"] = "納葛蘭競技場",
	Naxxramas = "納克薩瑪斯",
	Netherstorm = "虛空風暴",
	["Night Elf Village"] = "夜精靈村",
	["Northern Barrens"] = "北貧瘠之地",
	["Northern Stranglethorn"] = "北荊棘谷",
	Northrend = "北裂境",
	["Obsidia's Perch"] = "歐比希迪亞棲所",
	["Ogri'la"] = "歐格利拉",
	["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址",
	["Old Stratholme"] = "舊斯坦索姆",
	["Onyxia's Lair"] = "奧妮克希亞的巢穴",
	["Opening of the Dark Portal"] = "開啟黑暗之門",
	Orgrimmar = "奧格瑪",
	Outland = "外域",
	["Pit of Saron"] = "薩倫之淵",
	["Plaguelands: The Scarlet Enclave"] = "東瘟疫之地: 血色領區",
	Plaguewood = "病木林",
	["Quel'thalas"] = "奎爾薩拉斯",
	["Ragefire Chasm"] = "怒焰裂谷",
	Ratchet = "棘齒城",
	["Razorfen Downs"] = "剃刀高地",
	["Razorfen Kraul"] = "剃刀沼澤",
	["Redridge Mountains"] = "赤脊山",
	["Ring of Observance"] = "儀式競技場",
	["Rivendark's Perch"] = "瑞文達科棲所",
	["Ruins of Ahn'Qiraj"] = "安其拉廢墟",
	["Ruins of Gilneas"] = "吉爾尼斯廢墟",
	["Ruins of Gilneas City"] = "吉爾尼斯城廢墟",
	["Ruins of Lordaeron"] = "羅德隆廢墟",
	["Scalebeard's Cave"] = "鱗鬚洞穴",
	["Scarlet Monastery"] = "血色修道院",
	Scholomance = "通靈學院",
	["Searing Gorge"] = "灼熱峽谷",
	["Serpent Lake"] = "毒蛇之湖",
	["Serpentshrine Cavern"] = "毒蛇神殿洞穴",
	["Sethekk Halls"] = "塞司克大廳",
	-- ["Shado-pan Monastery"] = "",
	["Shadowfang Keep"] = "影牙城堡",
	["Shadow Labyrinth"] = "暗影迷宮",
	["Shadowmoon Valley"] = "影月谷",
	["Shartuul's Transporter"] = "夏圖歐的傳送門",
	Shattrath = "撒塔斯城",
	["Shattrath City"] = "撒塔斯城",
	["Shimmering Expanse"] = "閃光瀚洋",
	["Sholazar Basin"] = "休拉薩盆地",
	-- ["Siege of Niuzao Temple"] = "",
	Silithus = "希利蘇斯",
	["Silvermoon City"] = "銀月城",
	["Silverpine Forest"] = "銀松森林",
	["Skyguard Outpost"] = "禦天者崗哨",
	["Skysong Lake"] = "天歌湖",
	["Southern Barrens"] = "南貧瘠之地",
	["Sporewind Lake"] = "孢子風之湖",
	Stonard = "斯通納德",
	["Stonetalon Mountains"] = "石爪山脈",
	-- ["Stormstout Brewery"] = "",
	Stormwind = "暴風城",
	["Stormwind City"] = "暴風城",
	["Strand of the Ancients"] = "遠祖灘頭",
	["Stranglethorn Vale"] = "荊棘谷",
	Stratholme = "斯坦索姆",
	["Sunken Temple"] = "沉沒的神廟",
	["Sunwell Plateau"] = "太陽之井高地",
	["Swamp of Sorrows"] = "悲傷沼澤",
	Tanaris = "塔納利斯",
	Teldrassil = "泰達希爾",
	["Tempest Keep"] = "風暴要塞",
	["Temple of Ahn'Qiraj"] = "安其拉神廟",
	-- ["Temple of the Jade Serpent"] = "",
	["Terokkar Forest"] = "泰洛卡森林",
	["Terokk's Rest"] = "泰洛克之墓",
	-- ["Terrace of Endless Spring"] = "",
	["The Arachnid Quarter"] = "蜘蛛區",
	["The Arcatraz"] = "亞克崔茲",
	["The Argent Coliseum"] = "銀白大競技場",
	["The Barrens"] = "貧瘠之地",
	["The Bastion of Twilight"] = "暮光堡壘",
	["The Battle for Gilneas"] = "吉爾尼斯之戰",
	["The Black Morass"] = "黑色沼澤",
	["The Blood Furnace"] = "血熔爐",
	["The Bone Wastes"] = "白骨荒野",
	["The Botanica"] = "波塔尼卡",
	["The Cape of Stranglethorn"] = "荊棘谷海角",
	["The Construct Quarter"] = "傀儡區",
	["The Culling of Stratholme"] = "斯坦索姆的抉擇",
	["The Dark Portal"] = "黑暗之門",
	["The Deadmines"] = "死亡礦坑",
	["The Descent into Madness"] = "驟狂斜廊",
	["The Dragon Wastes"] = "龍墳荒原",
	["The Escape From Durnholde"] = "逃離敦霍爾德",
	["The Exodar"] = "艾克索達",
	["The Eye"] = "風暴要塞",
	["The Eye of Eternity"] = "永恆之眼",
	["The Forbidding Sea"] = "禁忌之海",
	["The Forge of Souls"] = "眾魂熔爐",
	["The Frozen Halls"] = "冰封大廳",
	["The Frozen Sea"] = "冰凍之海",
	["The Great Sea"] = "無盡之海",
	["The Halls of Winter"] = "凜冬之廳",
	["The Hinterlands"] = "辛特蘭",
	["The Lost Isles"] = "失落群島",
	["The Maelstrom"] = "大漩渦",
	["The Mechanar"] = "麥克納爾",
	["The Military Quarter"] = "軍事區",
	["The Molten Core"] = "熔火之心",
	["The Nexus"] = "奧核之心",
	["The North Sea"] = "北海",
	["The Obsidian Sanctum"] = "黑曜聖所",
	["The Oculus"] = "奧核之眼",
	["The Plague Quarter"] = "瘟疫區",
	["The Prison of Yogg-Saron"] = "尤格薩倫之獄",
	["Theramore Isle"] = "塞拉摩島",
	["The Ring of Valor"] = "勇武之環",
	["The Ruby Sanctum"] = "晶紅聖所",
	["The Scarlet Enclave"] = "血色領區",
	["The Shattered Halls"] = "破碎大廳",
	["The Slave Pens"] = "奴隸監獄",
	["The Spark of Imagination"] = "創思之廳",
	["The Steamvault"] = "蒸汽洞窟",
	["The Stockade"] = "監獄",
	["The Stonecore"] = "石岩之心",
	["The Storm Peaks"] = "風暴群山",
	["The Temple of Atal'Hakkar"] = "阿塔哈卡神廟",
	["The Underbog"] = "深幽泥沼",
	["The Veiled Sea"] = "迷霧之海",
	["The Violet Hold"] = "紫羅蘭堡",
	["The Vortex Pinnacle"] = "漩渦尖塔",
	["Thousand Needles"] = "千針石林",
	["Throne of the Four Winds"] = "四風王座",
	["Throne of the Tides"] = "海潮王座",
	["Thunder Bluff"] = "雷霆崖",
	Tirisfal = "提里斯法林地",
	["Tirisfal Glades"] = "提里斯法林地",
	["Tol Barad"] = "托巴拉德",
	["Tol Barad Peninsula"] = "托巴拉德半島",
	["Trial of the Champion"] = "勇士試煉",
	["Trial of the Crusader"] = "十字軍試煉",
	["Twilight Highlands"] = "暮光高地",
	["Twin Peaks"] = "雙子峰",
	["Twisting Nether"] = "扭曲虛空",
	Uldaman = "奧達曼",
	Ulduar = "奧杜亞",
	Uldum = "奧丹姆",
	Undercity = "幽暗城",
	["Un'Goro Crater"] = "安戈洛環形山",
	["Upper Blackrock Spire"] = "黑石塔上層",
	["Utgarde Keep"] = "俄特加德要塞",
	["Utgarde Pinnacle"] = "俄特加德之巔",
	["Vashj'ir"] = "瓦許伊爾",
	["Vault of Archavon"] = "亞夏梵穹殿",
	["Vortex Pinnacle"] = "漩渦尖塔",
	["Wailing Caverns"] = "哀嚎洞穴",
	["Warsong Gulch"] = "戰歌峽谷",
	["Well of Eternity"] = "永恆之井",
	["Western Plaguelands"] = "西瘟疫之地",
	Westfall = "西部荒野",
	Wetlands = "濕地",
	Wintergrasp = "冬握湖",
	Winterspring = "冬泉谷",
	["Wyrmrest Temple"] = "龍眠神殿",
	Zangarmarsh = "贊格沼澤",
	["Zul'Aman"] = "祖阿曼",
	["Zul'Drak"] = "祖爾德拉克",
	["Zul'Farrak"] = "祖爾法拉克",
	["Zul'Gurub"] = "祖爾格拉布",
}

else
	error(("%s: Locale %q not supported"):format(MAJOR_VERSION, GAME_LOCALE))
end
