local AddonName, NickAlert = ...


--[[ **************************************************************************
     * Add On Starts Here                                                     *
	 **************************************************************************
]]


local on = true
local off = false

-- Local text colors
local yel = "|cFFFFFF00"
local wht = "|cFFFFFFFF"
local blu = "|cFF00FFFF"
local red = "|cFFFF0000"
local grn = "|cFF00FF00"
local res = "|r"


NickAlert.Defaults = {
	Guild = on, -- Enable on guild channel
	Party = on, -- Enable on party channel
	Say = on,  -- Enable for people near you
	BGs = on,
	Raid = on,
	Yell = on,
	Emotes = on,
	Chats = off,
	WhisperList = on,
	BNet = on,
	ChatDebug = off,
	CustomMP3 = off,
	CustomOGG = off,
	Throttle = on,
	ThrottleTime = 30,
	ThrottleAmount = 3,
	FadeDelay = 15, --fade message frame text after
	--
	-- Addon Output Settings
	DisplayMode = off, -- Display the mode if trigger
	MSBT = off,  -- Output achievement to Mik's Scrolling Battle Text
	Sound = on, -- Enable Sound Output
	MF = on, -- Message frame
	FontSize = 10, -- MF FontSize
	--
	-- Addon State
	Enable = on, -- enable/disable the addon 
	AutoAdd = on -- Auto add char nicks to list
	}


NickAlert_Settings = {}
local NAS -- alias for above

NickAlert_ChatFilter = {}
local CF -- alias for above

NickAlert_NickNames = {} -- Nicknames
local NN -- Alias for NickAlert_NickNames[Realm]

NickAlert_WhisperList = {}
local WL -- Alias for NickAlert_WhisperList[Realm]

NickAlert_PC = {}
local PC

-- Throttle Variables
local LastAlertTime
local ThrottleTable = {}
local Throttled = false

-- Bill's Utils
local addOptionMt = BillsUtils.addOptionMt
local StatColor = BillsUtils.StatColor
local SJprint = BillsUtils.SJprint
local OptSaveTF = BillsUtils.OptSaveTF
local OptSaveVal = BillsUtils.OptSaveVal
local EventToggle = BillsUtils.EventToggle

BillsUtils.Locals[#BillsUtils.Locals +1] = function ()
	addOptionMt = BillsUtils.addOptionMt
	StatColor = BillsUtils.StatColor
	SJprint = BillsUtils.SJprint
	OptSaveTF = BillsUtils.OptSaveTF
	OptSaveVal = BillsUtils.OptSaveVal
	EventToggle = BillsUtils.EventToggle
end

NickAlert.Frame = CreateFrame("Frame")
NickAlert.Frame:RegisterEvent("ADDON_LOADED")

NickAlert.EventManager = function()
	local Table = NickAlert_Settings
	local Frame = NickAlert.Frame
	local Enable = Table.Enable -- true if addon is enabled (false unregisters no matter what)
	
	local Event = { "CHAT_MSG_BATTLEGROUND", "CHAT_MSG_BATTLEGROUND_LEADER", "CHAT_MSG_CHANNEL", "CHAT_MSG_EMOTE",
	"CHAT_MSG_TEXT_EMOTE", "CHAT_MSG_GUILD", "CHAT_MSG_OFFICER", "CHAT_MSG_PARTY", "CHAT_MSG_PARTY_LEADER", 
	"CHAT_MSG_RAID", "CHAT_MSG_RAID_LEADER", "CHAT_MSG_RAID_WARNING", "CHAT_MSG_SAY", "CHAT_MSG_YELL",
	"CHAT_MSG_WHISPER", "CHAT_MSG_BN_WHISPER", "CHAT_MSG_BN_CONVERSATION"}

	local Key = { "BGs", "BGs", "Chats", "Emotes", 
	"Emotes", "Guild", "Guild", "Party", "Party", 
	"Raid", "Raid", "Raid", "Say", "Yell", "WhisperList", "BNet", "BNet" }

	for x = 1, #Event do
		EventToggle( Frame, Table, Key[x], Event[x], Enable )
	end
	
end

-- ****************************************************************************
-- * Manage all the alert / filter lists
NickAlert.List = function( list, cmd, data )
	if type(cmd) == "string" then cmd = string.lower(cmd) end
	local StringTable = {}
	local Table
	if list == "NickList" then
		Table = NN
		StringTable.AddEntryError = " Nick Alert: trigger nickname entry error \n \"/nalert add NAME\""
		StringTable.AddGood = " Nick Alert: trigger nickname stored as NAME:"
		StringTable.RemEntryError = " Nick Alert: nickname entry error \n \"/nalert rem NAME \" or \"/nalert rem # \"  from /nalert display"
		StringTable.DisplayHeader = "Nickname Trigger List"
		StringTable.DisplayFooter = "Nicknames stored on this server"
		StringTable.HelpCmd = "/nanl cmd options"
		StringTable.HelpAdd = "Adds a nickname/trigger to scan chats for and alert you if found"
		StringTable.HelpRem = "Removes a stored trigger so it wont alert you anymore"
		StringTable.HelpDisplay = "Displays a list of stored Nicknames/Triggers"
		StringTable.TotalStored = "Nicknames stored for this server"
		StringTable.EndHint = "\"/nanl cfg\" will open the GUI config for the nick list"
	elseif list == "WhisperList" then
		Table = WL
		StringTable.AddEntryError = " Nick Alert: Whisper List name entry error \n \"/nawl add NAME\""
		StringTable.AddGood = " Nick Alert: Whisper List name stored as NAME:"
		StringTable.RemEntryError = " Nick Alert: Whisper List name entry error \n \"/nawl rem NAME \" or \"/nawl rem # \"  from /nawl display"
		StringTable.DisplayHeader = "Whisper Alert List"
		StringTable.DisplayFooter = "names stored for this server"
		StringTable.HelpCmd = "/nawl cmd options"
		StringTable.HelpAdd = "Adds a Name to alert you for when they whisper you \"/nawl add NAME\""
		StringTable.HelpRem = "Removes a Name from whisper alert list \"/nawl rem NAME\" or \"/nawl rem NUMBER\" (number from DISPLAY)"
		StringTable.HelpDisplay = "Displays a list of saved names to you if they whisper you"
		StringTable.TotalStored = "Characters stored for this server"
		StringTable.EndHint = "\"/nawl cfg\" will open the GUI config for the whisper alert list"
	elseif list == "Filter" then
		Table = CF
		StringTable.AddEntryError = " Nick Alert: Filter entry error \n \"/nalert filter add CHANNEL\"   CHANNEL = Channel name or part of name (e.g. \"Trade\")"
		StringTable.AddGood = " Nick Alert: Filter stored as:"
		StringTable.RemEntryError = " Nick Alert: Filter list entry error \n \"/nalert filter rem FILTER \" or \"/nalert filter rem # \"  from /nalert filter display"
		StringTable.DisplayHeader = "Filter List"
		StringTable.DisplayFooter = "Filters stored on this account"
		StringTable.HelpCmd = "/nalert filter cmd"
		StringTable.HelpAdd = "Adds a channel to listen to \"/nalert filter add CHANNEL\""
		StringTable.HelpRem = "Removes a channel \"/nalert filter rem CHANNEL\" or \"/nalert filter rem NUMBER\" (number from DISPLAY)"
		StringTable.HelpDisplay = "Displays a list of saved Channels to monitor if you are in them"
		StringTable.TotalStored = "Chat Filters stored for this account"
		StringTable.EndHint = "\"/nacf cfg\" will open the GUI config for the channel filter list"
	else return
	end
	
	if (cmd == "on" or cmd == "off") and list ~= "NickList" then
		NAS[list] = cmd == "on"
		SJprint(yel, "Nick Alert:", blu, list, yel, "is", StatColor( NAS[list] ), res)
		return
	end

	if cmd == "add" then
		if type(data) == "nil" then
			SJprint( yel, StringTable.AddEntryError , res)
			return
		end
	
		if #Table > 0 then
			for x = 1, #Table do
				if Table[x] == data then
					set = true
					break
				end
			end
		end
	
		if not(set) then
			local index
			if #Table == nil then
				index = 1
			else
				index = #Table + 1
			end
			Table[index] = data
		end

		SJprint( yel, StringTable.AddGood, data , res)
		table.sort( Table )
		return
	end
	
	if cmd == "rem" then
		local rem = false
		local number = tonumber(data)
		local vtype = type(data)
		local numtype = type(number)
	
		if vtype == "nil" then
			SJprint( yel, StringTable.RemEntryError , res)
			return
		end

		if vtype == "string" and numtype == "nil" then
			if #Table > 0 then
				for x = 1, #Table do
					if Table[x] == data then
						table.remove(Table, x)
						rem = true
					end
				end
			end
		end

		if vtype == "number" or numtype == "number" then
			if number > 0 and number <= #Table then
				data = Table[number]
				table.remove(Table, number)
				rem = true
			end
		end
	
		if not(rem) then
			SJprint( yel, " Nick Alert: Error \n Unable to find ", data, " to remove from list", res)
		else
			SJprint( yel, " Nick Alert: ", data, " removed from list", res)
		end
		return
	end
	
	if cmd == "display" then
		SJprint( yel, "________________________________________", res)
		SJprint( yel, "Nick Alert", res)
		SJprint( yel, "  ", StringTable.DisplayHeader, res)
		SJprint( yel, "#  DATA:", res)
		if #Table > 0 then
			local Mod 
			for x = 1, #Table do
				Mod = math.fmod(x, 3)
				if Mod == 0 then
					SJprint( "|cFFFFFF00", x, "  ", Table[x], "\n", res)
				elseif Mod == 1 then
					SJprint( "|cFFFFCC00", x, "  ", Table[x], "\n", res)
				elseif Mod == 2 then
					SJprint( "|cFFFF9900", x, "  ", Table[x], "\n", res)
				end
			end
			SJprint( yel, #Table, StringTable.DisplayFooter , res)
		else
			SJprint( yel, "ERROR: No items stored", res)
		end
		return
	end
	
	SJprint( yel, "\n\n________________________________________", res)
	SJprint( yel, "Nick Alert:", res)
	if list ~= "NickList" then
		SJprint(yel, "Nick Alert:", blu, list, yel, "is", StatColor( NAS[list] ), res)
	end
	SJprint( blu, "  ", StringTable.HelpCmd , res)
	SJprint( blu, "     add", yel, StringTable.HelpAdd, res)
	SJprint( blu, "     rem", yel, StringTable.HelpRem, res)
	SJprint( blu, "     display", yel, StringTable.HelpDisplay , res)
	SJprint( "\n", yel, tostring(#Table), StringTable.TotalStored, res)
	SJprint( yel, StringTable.EndHint, res )
end


-- ****************************************************************************
-- * OnUpdate function manages the throttle table
local e = 0
local FontSize = 0
local FadeDelay = 0
NickAlert.Frame:SetScript("OnUpdate", function(self, elapsed)
	e = e + elapsed
	if e < 1/5 then
		return
	end
	e = 0
	
	local CurrentTime = time()
	
	if #ThrottleTable > 0 then
		for x = #ThrottleTable, 1, -1 do
			if (CurrentTime - ThrottleTable[x]) > NAS.ThrottleTime then
				table.remove(ThrottleTable, x)
			end
		end
	end
	
	if Throttled then
		if #ThrottleTable < NAS.ThrottleAmount then
			Throttled = false
			if NAS.ChatDebug then
				SJprint(red, "Nick Alert: Throttle below threshold   Current:", #ThrottleTable, "   Max:", NAS.ThrottleAmount," over",NAS.ThrottleTime, "seconds", res)
			end
		end
	end
	
	if FontSize ~= NAS.FontSize then
		FontSize = NAS.FontSize
		NickAlert.MF:SetFont( STANDARD_TEXT_FONT, NAS.FontSize)
	end
	
	if FadeDelay ~= NAS.FadeDelay then
		FadeDelay = NAS.FadeDelay
		NickAlert.MF:SetTimeVisible( NAS.FadeDelay )
	end
end)

-- ****************************************************************************
-- * Event Handler
local LastMsgLine = ""
NickAlert.Frame:SetScript("OnEvent",function(self, event, ...)
	arg = ...
	if event == "ADDON_LOADED" and arg == AddonName then
		SJprint(grn, "Nick Alert v", GetAddOnMetadata( AddonName, "Version"), "loaded",  res)
		addOptionMt( NickAlert_Settings , NickAlert.Defaults )
		NAS = NickAlert_Settings
		
		NickAlert.EventManager()
		
		local realm = GetRealmName()
		
		if not NickAlert_NickNames[realm] then
			NickAlert_NickNames[realm] = {}
		end
		NN = NickAlert_NickNames[realm]
		
		if not NickAlert_WhisperList[realm] then
			NickAlert_WhisperList[realm] = {}
		end
		WL = NickAlert_WhisperList[realm]
		CF = NickAlert_ChatFilter
		
		if not NickAlert_PC[realm] then
			NickAlert_PC[realm] = {}
		end
		local player = UnitName("player")
		if not NickAlert_PC[realm][player] then
			NickAlert_PC[realm][player] = {}
		end
		PC = NickAlert_PC[realm][player]
		
		if not(PC.MsgFrameSet) and NAS.MF then
			PC.MsgFrameSet = true
			NickAlert.MsgFrameUnlock()
			NickAlert.MF:AddMessage("Move this frame to where you would like then type \"/namf lock\" to save the position", 1, 1, 1 )
		else
			NickAlert.MsgFrameLock()
		end
		
		if not(PC.NickAdded) and NAS.AutoAdd then
			PC.NickAdded = true
			NickAlert.List( "NickList", "add", player)
		end
		
		-- put the tables into addon table
		NickAlert.Settings = NAS
		NickAlert.NickNames = NN
		NickAlert.ChatFilter = CF
		NickAlert.WhisperList = WL
		
		NickAlert.MF:SetFont( STANDARD_TEXT_FONT, NAS.FontSize)
		
		return self, event, ...
	elseif event == "ADDON_LOADED" then 
		return 
	end
	
	if not(NAS.Enable) then
		return
	end
	
	local args = {...}
	local msg = args[1]
	local name = args[2]
	local MsgLine = args[11]
	local mode 
	local R,G,B 
	local match = false
	
	if LastMsgLine == MsgLine then return end
	LastMsgLine = MsgLine
	
	if name == UnitName("player") and not(NAS.ChatDebug) then
		return
	end
	
	if string.find(event, "CHAT_MSG_") then
		event = string.sub(event, 10)
	end
	
	-- ***************************************************************************
	-- * Find a reason to alert them here
	if event == "WHISPER" then
		if #WL > 0 then
			for x = 1, #WL do
				if string.find(string.lower(name), "^"..string.lower(WL[x])) then
					match = true
					break
				end
			end
		else
			return
		end
	elseif string.find(event, "BN") then
		local _, _, index = string.find(name, "|Kf(%d*)|k")
		index = tonumber(index)
		local _, _, _, _, _, _, _, _, _, _, _, noteText, _, _ = BNGetFriendInfoByID(index)
		if string.find( noteText, "NAlert") then
			match = true
		end
	else
		if #NN > 0 then
			local compstring = {string.split(" ", msg) }
			for x = 1, #NN do
				for y = 1, #compstring do
					if string.find(string.lower(compstring[y]), "^"..string.lower( NN[x]) ) then
						match = true
						break
					end
				end
			end
		else
			return
		end
	end
	
	if not(match) then
		return
	end

	if event == "CHANNEL" and #CF > 0 then
		local found = false
		for x = 1, #CF do
			if string.find( string.lower(mode) , string.lower(CF[x]) )then
				found = true
				break
			end
		end
		if not(found) then
			return
		end
	elseif event == "CHANNEL" then
		return
	end
	
-- Annoying people throttle
	if Throttled then
		if NAS.ChatDebug then
			SJprint(red, "Nick Alert: Alert Throttled ", #ThrottleTable, "/", NAS.ThrottleAmount, res)
		end
		return
	end
	
	if NAS.Throttle then
		local CurrentTime = time()
		if #ThrottleTable == 0 then --1st time you been mentioned in some time
			ThrottleTable[1] = CurrentTime
		else -- you have been mentioned before
			ThrottleTable[#ThrottleTable +1] = CurrentTime
			
			if #ThrottleTable > NAS.ThrottleAmount then
				Throttled = true
				if NAS.ChatDebug then
					SJprint(red, "Nick Alert: Alert Throttled ", #ThrottleTable, "/", NAS.ThrottleAmount, res)
				end
				return
			end
		end
	end
		
	if (event == "BATTLEGROUND" or event == "BATTLEGROUND_LEADER" ) and NAS.BGs then -- arg1 chat message arg2 author 
		mode = "BG"
	elseif event == "CHANNEL" and NAS.Chats then  -- arg9 channel name without number (this is _sometimes_ in lowercase) 
		mode = args[9]
	elseif (event == "EMOTE" or event == "TEXT_EMOTE") and NAS.Emotes then 
		mode = "EMOTE"
	elseif event == "GUILD" and NAS.Guild then
		mode = "/G"
	elseif event == "OFFICER" and NAS.Guild then
		mode = "/O"
	elseif ( event == "PARTY" or event == "PARTY_LEADER") and NAS.Party then 
		mode = "/P"
	elseif ( event == "RAID" or event == "RAID_LEADER") and NAS.Raid then
		mode = "RAID"
	elseif event == "RAID_WARNING" and NAS.Raid then
		mode = "RW"
	elseif event == "SAY" and NAS.Say then
		mode = "/S"
	elseif event == "YELL" and NAS.Yells then
		mode = "YELL"
	elseif event == "WHISPER" and NAS.WhisperList then
		mode = "TELL"
	elseif string.find(event, "BN") and NAS.BNet then
		mode = "BNet"
	else
		return
	end
	
	R, G, B = ChatTypeInfo[event].r , ChatTypeInfo[event].g , ChatTypeInfo[event].b 
	if R > 1 then R = 1 end
	if G > 1 then G = 1 end
	if B > 1 then B = 1 end
	
	local outtext
	if NAS.DisplayMode then
		outtext = string.join(" ", mode, name, ":", msg)
	else
		outtext = string.join(" ", name, ":", msg)
	end
	
	if NAS.ChatDebug then
		SJprint( yel, "Nick Alert: Chat Debug ", wht, outtext, res )
	end
		
	
	if NAS.MSBT and IsAddOnLoaded("MikScrollingBattleText") then
		if not(MikSBT.IsModDisabled()) then
			MikSBT.DisplayMessage( outtext , MikSBT.DISPLAYTYPE_NOTIFICATION, true, R*255 , G*255, B*255)
		end
	end

	if NAS.Sound then
		if NAS.CustomMP3 then
			PlaySoundFile("Interface\\AddOns\\NickAlert_CustomSounds\\alert.mp3")
		elseif NAS.CustomOGG then
			PlaySoundFile("Interface\\AddOns\\NickAlert_CustomSounds\\alert.ogg")
		else
			PlaySound("READYCHECK")
		end
	end
	
	if NAS.MF then
		NickAlert.MF:AddMessage(outtext, R, G, B )
	end
end)


NickAlert.CmdLine = function( msg )
	local cmd, arg, arg2 = string.split(" ", msg, 3)
	cmd = string.lower(cmd)
		
	if cmd == "config" then
		InterfaceOptionsFrame_OpenToCategory( NickAlert.panel )
		return
	end

	if not(NAS.Enable) and cmd ~= "enable" then
		SJprint( yel, "Nick Alert: The addon is disabled type \"", blu, "/nalert enable on", yel, "to enable", res)
		return
	end
	
	local Command = {"Enable", "AutoAdd", "Guild", "Party", "Say", "BGs", "Raid", "Yell", "Emotes", "Chats",
	"ChatDebug", "DisplayMode", "MSBT", "Sound", "CustomMP3", "CustomOGG", "Throttle" }

	for x = 1, #Command do
		if cmd == string.lower(Command[x]) then
			OptSaveTF( NAS, Command[x], arg)
			SJprint( yel, "Nick Alert:", Command[x],"is", StatColor( NAS[Command[x]] ), res)
			return
		end
	end
	
	if cmd == "mf" then
		if arg == "unlock" then
			NickAlert.MsgFrameUnlock()
			return
		elseif arg == "lock" then
			NickAlert.MsgFrameLock()
			return
		end
		OptSaveTF( NAS, "MF", arg)
		SJprint( yel, "Nick Alert:", blu, "MF", wht, "is", StatColor( NAS.MF ), res)
		return
	end
	
	if cmd == "whisperlist" then
		if arg == "cfg" then
			InterfaceOptionsFrame_OpenToCategory( NickAlert.panel3 )
			_G["NAlertSelectListButton3"]:Click("LeftButton")
			return
		end
		NickAlert.List("WhisperList", arg, arg2 )
		return
	end
	
	if cmd == "bnet" then
		if arg == "cfg" then
			InterfaceOptionsFrame_OpenToCategory( NickAlert.panel3 )
			_G["NAlertSelectListButton4"]:Click("LeftButton")
			return
		end
		
		OptSaveTF( NAS, "BNet", arg)
		SJprint( yel, "Nick Alert:", blu, "BNet", wht, "is", StatColor( NAS.BNet ), res)
		SJprint(yel, "Type: ", blu, "/nabn cfg", wht, "to manage the Read ID list", res)
		return
	end
			
	if cmd == "nicklist" then
		if arg == "cfg" then
			InterfaceOptionsFrame_OpenToCategory( NickAlert.panel3 )
			_G["NAlertSelectListButton1"]:Click("LeftButton")
			return
		end
		NickAlert.List("NickList", arg, arg2)
		return	
	end
	
	if cmd == "filter" then
		if arg == "cfg" then
			InterfaceOptionsFrame_OpenToCategory( NickAlert.panel3 )
			_G["NAlertSelectListButton2"]:Click("LeftButton")
			return
		end
		NickAlert.List( "Filter", arg, arg2 )
		return
	end
	
	if cmd == "fontsize" then
		OptSaveVal( NAS, "FontSize", arg, 7, 24 )
		SJprint( yel, "Nick Alert: FontSize is", grn, NAS.FontSize, res)
		return
	end
	
	if cmd == "fadedelay" then
		OptSaveVal( NAS, "FadeDelay", arg, 1, 60 )
		SJprint( yel, "Nick Alert: FadeDelay is", grn, NAS.FadeDelay, yel, "second(s).", res)
		return
	end
	
	if cmd == "throttletime" then
		OptSaveVal( NAS, "ThrottleTime", arg, 1, 60 )
		SJprint( yel, "Nick Alert: ThrottleTime is", grn, NAS.ThrottleTime, yel, "second(s).", res)
		return
	end
	
	if cmd == "throttleamount" then
		OptSaveVal( NAS, "ThrottleAmount", arg, 1, 60 )
		SJprint( yel, "NickAlert: ThrottleAmount is", grn, NAS.ThrottleAmount, res)
		return
	end

	if cmd == "" then
		SJprint( yel, "________________________________________", res)
		SJprint( yel, "Nick Alert:", res)
		SJprint( blu, "     Enable", wht, "is", StatColor( NAS.Enable ), res)
		SJprint( blu, "     AutoAdd", wht, "is", StatColor( NAS.AutoAdd ), res)
		SJprint( blu, "     Guild", wht, "is", StatColor( NAS.Guild ), res)
		SJprint( blu, "     Party", wht, "is", StatColor( NAS.Party ), res)
		SJprint( blu, "     Say", wht, "is", StatColor( NAS.Say ), res)
		SJprint( blu, "     BGs", wht, "is", StatColor( NAS.BGs ), res)
		SJprint( blu, "     Raid", wht, "is", StatColor( NAS.Raid ), res)
		SJprint( blu, "     Yell", wht, "is", StatColor( NAS.Yell ), res)
		SJprint( blu, "     Emotes", wht, "is", StatColor( NAS.Emotes ), res)
		SJprint( blu, "     Chats", wht, "is", StatColor( NAS.Chats ), res)
		SJprint( blu, "     WhisperList", wht, "is", StatColor( NAS.WhisperList ), res)
		SJprint( blu, "     BNet", wht, "is", StatColor( NAS.BNet ), res)
		SJprint( blu, "     ChatDebug", wht, "is", StatColor( NAS.ChatDebug ), res)
		SJprint( blu, "     DisplayMode", wht, "is", StatColor( NAS.DisplayMode ), res)
		SJprint( blu, "     MF", wht, "is", StatColor( NAS.MF ), res)
		SJprint( blu, "     FontSize", wht, "is", grn, NAS.FontSize, res)
		SJprint( blu, "     FadeDelay", wht, "is", grn, NAS.FadeDelay, res)
		SJprint( blu, "     MSBT", wht, "is", StatColor( NAS.MSBT ), res)
		SJprint( blu, "     Sound", wht, "is", StatColor( NAS.Sound ), res)
		SJprint( blu, "     CustomMP3", wht, "is", StatColor(NAS.CustomMP3), res)
		SJprint( blu, "     CustomOGG", wht, "is", StatColor(NAS.CustomOGG), res)
		SJprint( blu, "     Throttle", wht, "is", StatColor(NAS.Throttle), res)
		SJprint( blu, "     ThrottleTime", wht, "is", grn, NAS.ThrottleTime, res)
		SJprint( blu, "     ThrottleAmount", wht, "is", grn, NAS.ThrottleAmount, res)
		print(" ")
		SJprint("     ", yel, #NN, "nicknames are stored for this server.")
		SJprint("     ", yel, #WL, "whisper alerts are stored for this server.")
		SJprint("     ", yel, #CF, "Chat Filters are stored for this account.")
		return
	end
		
	SJprint( yel, "________________________________________", res)
	SJprint( yel, "Nick Alert:", res)
	SJprint( blu, "  /nalert cmd", res)
	SJprint( red, cmd, yel, "is not a valid command", res)
	SJprint( yel, "  Commands are:", res)
	SJprint( blu, "     Enable", yel, "Turns Nick Alert on and off [on / off]", res)
	SJprint( blu, "     AutoAdd", yel, "Add your char names to list automatically [on / off]", res)
	SJprint( blu, "     Guild", yel, "Enable nick scanning in guild channels [on / off]", res)
	SJprint( blu, "     Party", yel, "Enable nick scanning in party channel [on / off]", res)
	SJprint( blu, "     Say", yel, "Enable nick scanning in say channel [on / off]", res)
	SJprint( blu, "     BGs", yel, "Enable nick scanning in BattleGrounds [on / off]", res)
	SJprint( blu, "     Raid", yel, "Enable nick scanning in Raid Channels [on / off]", res)
	SJprint( blu, "     Yell", yel, "Enable nick scanning in Yells [on / off]", res)
	SJprint( blu, "     Emotes", yel, "Enable nick scanning in Emotes [on / off]", res)
	SJprint( blu, "     Chats", yel, "Enable nick scanning in general chat channels [on / off]", res)
	SJprint( blu, "     NickList", yel, "Manages nicknames for above alert types [submenu available]", res)
	SJprint( blu, "     WhisperList", yel, "Enable alerts for whispers from specified people [submenu available]", res)
	SJprint( blu, "     BNet", yel, "Enable alerts for messages from specified Real IDs [on/off/cfg]", res)
	SJprint( blu, "     Filter", yel, "Filter is a WHITELIST that filters all \"/1 /2 /3 ...\" channels not in the list [submenu available]", res)
	SJprint( blu, "     DisplayMode", yel, "Display mode of trigger (ie Party, Guild, BNet) [on/off]", res)
	SJprint( blu, "     MF", yel, "Enables output to the moveable Message Frame [on/off/lock/unlock]", res)
	SJprint( blu, "     FontSize", yel, "The size of the font in the message frame [7 - 24]", res)
	SJprint( blu, "     FadeDelay", yel, "How long before the text in the message frame fades [1-60 secs]", res)
	SJprint( blu, "     MSBT", yel, "Enable output to MikScrollingBattleText if installed [on / off]", res)
	SJprint( blu, "     Sound", yel, "Enable sound when a nick match is found [on / off]", res)
	SJprint( blu, "     CustomMP3", yel, "Enable custom alert.mp3 sound when a nick match is found [on / off]", res)
	SJprint( blu, "     CustomOGG", yel, "Enable custom alert.ogg sound when a nick match is found [on / off]", res)
	SJprint( blu, "     Throttle", yel, "Enable alert throttle to stop people from noise spamming you [on / off]", res)
	SJprint( blu, "     ThrottleTime", yel, "Amount of time to count alerts for [1-60 secs]", res)
	SJprint( blu, "     ThrottleAmount", yel, "Max number of alerts in above time frame [1-60]", grn, NAS.ThrottleAmount, res)
	SJprint( blu, "     /nanl", yel, "manage the nick alert list", res)
	SJprint( blu, "     /nawl", yel, "manage the whisper list", res)
	SJprint( blu, "     /nabn", yel, "manage the Real ID list", res)
	SJprint( blu, "     /nacf", yel, "manage the channel filter list", res)
	SJprint( blu, "     /namf", yel, "message frame [on/off/lock/unlock]", res)
	return
end

local Backdrop={
	bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
	edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border",
	tile = true,
	tileSize = 16,
	edgeSize = 16,
	insets = {
		left = 0,
		right = 0,
		top = 0,
		bottom = 0
	}
}

local OnMouseDown = function(self, button)
	if button == "LeftButton" then
		self:StartMoving()
		self.isMoving = true
		self.hasMoved = false
	elseif button == "RightButton" then
		self:StartSizing()
		self.isMoving = true
		self.hasMoved = false
	end
end

local OnMouseUp = function(self)
    if ( self.isMoving ) then
        self:StopMovingOrSizing();
        self.isMoving = false;
        self.hasMoved = true;
    end
end

NickAlert.MF = CreateFrame("MessageFrame", "NAMsgFrame")
local MF = NickAlert.MF
MF:SetFrameStrata("DIALOG")
MF:SetToplevel(true)
MF:SetSize(UIParent:GetWidth() / 4, 50)
MF:SetTimeVisible(15)
MF:SetFadeDuration(5)
MF:SetFading(true)
MF:SetClampedToScreen(true)
MF:SetInsertMode("BOTTOM")
MF:SetIndentedWordWrap(true)
MF:SetFont( STANDARD_TEXT_FONT, 10)
MF:SetJustifyH("LEFT")
MF:SetPoint("CENTER", UIParent, "CENTER" )
MF:Show()
MF:SetMovable(true)
MF:SetResizable(true)
MF:SetMinResize( 30, 30 )
MF:RegisterForDrag("LeftButton","RightButton")
MF:SetScript("OnMouseDown",OnMouseDown)
MF:SetScript("OnMouseUp",OnMouseUp)
MF.Title = MF:CreateFontString( nil , "OVERLAY", "GameFontHighlight")
MF.Title:SetPoint( "TOP", MF, "TOP", 0, -6 )
MF.Title:SetJustifyH( "CENTER" )
MF.Title:SetJustifyV( "MIDDLE" )
MF.Title:SetText("Nick Alert")

NickAlert.MsgFrameLock = function()
	MF:EnableMouse(false)
	MF:SetBackdrop( nil )
	MF.Title:Hide()
end

NickAlert.MsgFrameUnlock = function()
	MF:EnableMouse(true)
	MF:SetBackdrop( Backdrop )
	MF.Title:Show()
end




SLASH_NALERT1 = "/nalert"
SLASH_NALERT2 = "/nickalert"
SlashCmdList["NALERT"] = function(msg)
	NickAlert.CmdLine(msg)
end

SLASH_NANL1 = "/nanl"
SlashCmdList["NANL"] = function(msg)
	local cmd, data = string.split(" ", msg, 2)
	cmd = string.lower( cmd )
	if cmd == "cfg" then
		InterfaceOptionsFrame_OpenToCategory( NickAlert.panel3 )
		_G["NAlertSelectListButton1"]:Click("LeftButton")
		return
	end
	NickAlert.List("NickList", cmd , data )
end

SLASH_NAWL1 = "/nawl"
SlashCmdList["NAWL"] = function(msg)
	local cmd, data = string.split(" ", msg, 2)
	cmd = string.lower( cmd )
	if cmd == "cfg" then
		InterfaceOptionsFrame_OpenToCategory( NickAlert.panel3 )
		_G["NAlertSelectListButton3"]:Click("LeftButton")
		return
	end
	NickAlert.List("WhisperList", cmd , data )
end

SLASH_NACF1 = "/nacf"
SlashCmdList["NACF"] = function(msg)
	local cmd, data = string.split(" ", msg, 2)
	cmd = string.lower( cmd )
	if cmd == "cfg" then
		InterfaceOptionsFrame_OpenToCategory( NickAlert.panel3 )
		_G["NAlertSelectListButton2"]:Click("LeftButton")
		return
	end
	NickAlert.List("Filter", cmd , data )
end


SLASH_NABN1 = "/nabn"
SlashCmdList["NABN"] = function(msg)
	local cmd, data = string.split(" ", msg, 2)
	cmd = string.lower( cmd )
	if cmd == "cfg" then
		InterfaceOptionsFrame_OpenToCategory( NickAlert.panel3 )
		_G["NAlertSelectListButton4"]:Click("LeftButton")
		return
	end
		
	OptSaveTF( NAS, "BNet", arg)
	SJprint( yel, "Nick Alert:", blu, "BNet", wht, "is", StatColor( NAS.BNet ), res)
	SJprint(yel, "Type: ", blu, "/nabn cfg", wht, "to manage the alert list", res)
	return
end

SLASH_NAMF1 = "/namf"
SlashCmdList["NAMF"] = function(msg)
	local cmd, data = string.split(" ", msg, 2)
	cmd = string.lower( cmd )
	if cmd == "unlock" then
		NickAlert.MsgFrameUnlock()
		SJprint( yel, "Nick Alert", wht, "Left Button moves the frame, Right button resizes the frame" )
		return
	elseif cmd == "lock" then
		NickAlert.MsgFrameLock()
		return
	end
	OptSaveTF( NAS, "MF", cmd)
	SJprint( yel, "Nick Alert:", blu, "MF", wht, "is", StatColor( NAS.MF ), res)
	return
end