local AddonName, NickAlert = ...
local FriendlyAddonName = "Nick Alert"


-- Config Panel Text Strings
NickAlert.Text={
Title = "Nick Alert",
TitleSub = "Change how Nick Alert behaves by setting the options below",
Enable = "Enable the Add On to function",
AutoAdd = "Add your character names to the list automatically",
Guild = "Scan Guild channel",
Party = "Scan Party channel",
Say  = "Scan Say channel",
Yell = "Scan Yell channel",
Emotes = "Scan Emotes",
BGs = "Scan Battleground channel",
Raid = "Scan Raid channel",
Chats = "Scan Other channels",
WhisperList = "Alert you when specified people whisper you",
BNet = "Alert you when specified Real ID people msg you( no longer requires \"NA:nickname:\" tag in person's note",
ChatDebug = "Print all matches to default chat log",
DisplayMode = "Enable display of mode text in alert (ie Party, Guild, BNet)",
MF = "Enables output to the moveable message frame",
FontSize = "Font Size in message frame",
FadeDelay = "Fade message frame text after X seconds",
MSBT  = "Enable output to MSBT's notification frame",
Sound = "Enable sound to notify you of an alert",
CustomMP3 = "Enable custom alert.mp3 sound",
CustomOGG = "Enable custom alert.ogg sound",
Throttle = "Enable alert throttle",
ThrottleTime = "Amount of time to throttle over",
ThrottleAmount = "Max number of alerts in above time"
}

-- Local text colors
local yel = "|cFFFFFF00"
local wht = "|cFFFFFFFF"
local blu = "|cFF00FFFF"
local red = "|cFFFF0000"
local grn = "|cFF00FF00"
local res = "|r"



-- Bill's Utils
local Wait = BillsUtils.Wait
local ChkBox = BillsUtils.ChkBox
local ChkBoxSave = BillsUtils.ChkBoxSave
local CheckClick = BillsUtils.CheckClick
local SliderSave = BillsUtils.SliderSave
local SliderMW = BillsUtils.SliderMW
local Slider = BillsUtils.Slider
local SliderEditBox = BillsUtils.SliderEditBox
local SJprint = BillsUtils.SJprint


local X = 16 -- standard Horizontal Spacing
local Y = 35 -- standard Vertical spacing 26
local TxtY = 13



-- General Settings / functions
local NAS = NickAlert.Settings
local NAD = NickAlert.Defaults
local NN = NickAlert.NickNames
local CF = NickAlert.ChatFilter
local WL = NickAlert.WhisperList

NickAlert.ConfigFrame = CreateFrame("Frame")
NickAlert.ConfigFrame:RegisterEvent("ADDON_LOADED")

NickAlert.ConfigFrame:SetScript("OnEvent",function(self, event, ...)
	local arg = ...
	if event ~= "ADDON_LOADED" and arg ~= AddonName then return end
	NAS = NickAlert.Settings
	NAD = NickAlert.Defaults
	NN = NickAlert.NickNames
	CF = NickAlert.ChatFilter
	WL = NickAlert.WhisperList
end)

NickAlert.Checkclick = function()
	PlaySound( "GAMEGENERICBUTTONPRESS" )
end

--Panel
NickAlert.panel = CreateFrame( "Frame", "NAlertConfig", UIParent )
NickAlert.panel2 = CreateFrame( "Frame", "NAlertConfig2", NickAlert.panel )
local me = NickAlert.panel
local me2 = NickAlert.panel2
me:SetScript("OnLoad", function()
	NickAlert.init()
end)


me.name = "Nick Alert"
me2:SetSize(380, 475)
me2:SetPoint("BOTTOMRIGHT", me, "BOTTOMRIGHT")

-- Pane title
	local Title = me:CreateFontString( nil, "ARTWORK", "GameFontNormalLarge" )
	Title:SetPoint( "TOPLEFT", 16, -16 )
	Title:SetText( NickAlert.Text.Title )
	local SubText = me:CreateFontString( nil, "ARTWORK", "GameFontHighlightSmall" )
	SubText:SetPoint( "TOPLEFT", Title, "BOTTOMLEFT", 0, -8 )
	SubText:SetPoint( "RIGHT", -32, 0 )
	SubText:SetHeight( 32 )
	SubText:SetJustifyH( "LEFT" )
	SubText:SetJustifyV( "TOP" )
	SubText:SetText( NickAlert.Text.TitleSub )

-- Scroll Frame
	me.ScrollFrame = CreateFrame("ScrollFrame", "NAlertConfigScrollFrame", me, "UIPanelScrollFrameTemplate")
	me.ScrollFrame:SetScrollChild(me2)
	me.ScrollFrame:SetPoint("TOPRIGHT", me ,"TOPRIGHT", -30,- 64)
	me.ScrollFrame:SetPoint("BOTTOMRIGHT", me ,"BOTTOMRIGHT", -30, 10)
	me.ScrollFrame:SetPoint("BOTTOMLEFT", me ,"BOTTOMLEFT", 30, 10)

-- Check Boxes & Text
	local last = me2
	local Command = {"Enable", "AutoAdd", "Guild", "Party", "BGs", "Raid", "Say", "Yell", "Emotes",
	"Chats", "WhisperList", "BNet", "ChatDebug", "DisplayMode", "MF"} 

	for x = 1, #Command do
		me[ Command[x] ] = ChkBox( last , "NickAlertCfg", Command[x] , me2, CheckClick, NickAlert.Text )
		last = me[ Command[x] ]
	end
	local FontSizeDemo
	local SliderFontSize = function(self, delta)
		local min,max = self:GetMinMaxValues()
		local step = self:GetValueStep()
		local value = self:GetValue()
	
		if delta < 0 then 
			value = value - step
		elseif delta > 0 then
			value = (value + step)
		end
		if value < min then
			value = min
		elseif value > max then
			value = max
		end
		self:SetValue( value )
		FontSizeDemo:SetFont( STANDARD_TEXT_FONT, value )
		FontSizeDemo:SetText( "Font Size Demo "..tostring(value) )
	end
	
	me.FontSize = Slider( last , "NickAlertCfg", "FontSize", me2 , SliderFontSize , NickAlert.Text, 7, 24, 1 )
	me.FontSize:SetScript( "OnValueChanged", function( self )
		local val = self:GetValue()
		self.Val:SetNumber( val )
		FontSizeDemo:SetFont( STANDARD_TEXT_FONT, val )
		FontSizeDemo:SetText( "Font Size Demo "..tostring( val ) )
		PlaySound( "GAMEGENERICBUTTONPRESS" )
	end)
	
	last = me.FontSize
	me.FontSize.Val = SliderEditBox( last , "NickAlertCfg", "FontSizeDemo", me2 )
	
	FontSizeDemo = me:CreateFontString( "NalertFontSizeDemo", "ARTWORK") --, "GameFontHighlightSmall" )
	FontSizeDemo:SetFont( STANDARD_TEXT_FONT, 10 )
	--FontSizeDemo:SetFontHeight(NAS.FontSize)
	FontSizeDemo:SetPoint( "TOPLEFT", last, "BOTTOMLEFT", 0, -0 )
	FontSizeDemo:SetPoint( "RIGHT", -32, 0 )
	FontSizeDemo:SetHeight( 32 )
	FontSizeDemo:SetJustifyH( "LEFT" )
	FontSizeDemo:SetJustifyV( "CENTER" )
	FontSizeDemo:SetText( "Font Size Demo" )

	last = FontSizeDemo
	
	
	me.FadeDelay = Slider( last , "NickAlertCfg", "FadeDelay", me2 , SliderMW , NickAlert.Text, 1, 60, 1 )
	last = me.FadeDelay
	me.FadeDelay.Val = SliderEditBox( last , "NickAlertCfg", "FadeDelay", me2 )
	
	Command = {"MSBT", "Sound", "CustomMP3", "CustomOGG", "Throttle"}
	for x = 1, #Command do
		me[ Command[x] ] = ChkBox( last , "NickAlertCfg", Command[x] , me2, CheckClick, NickAlert.Text )
		last = me[ Command[x] ]
	end
	
-- Throttle Time Slider	and EditBox
	me.ThrottleTime = Slider( last , "NickAlertCfg", "ThrottleTime", me2 , SliderMW , NickAlert.Text, 1, 60, 1 )
	last = me.ThrottleTime
	me.ThrottleTime.Val = SliderEditBox( last , "NickAlertCfg", "ThrottleTime", me2 )
	
-- Throttle Amount Slider
	me.ThrottleAmount = Slider( last , "NickAlertCfg", "ThrottleAmount", me2 , SliderMW , NickAlert.Text, 1, 60, 1 )
	last = me.ThrottleAmount
	me.ThrottleAmount.Val = SliderEditBox( last , "NickAlertCfg", "ThrottleAmount", me2 )
	
--	End of frame



-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- X  Init / Reset the config panel to match current settings                                                     X
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
--


NickAlert.Init = function(...)
	me.Enable:SetChecked( NAS.Enable )
	me.AutoAdd:SetChecked(NAS.AutoAdd )
	me.Guild:SetChecked( NAS.Guild )
	me.Party:SetChecked( NAS.Party )
	me.BGs:SetChecked( NAS.BGs )
	me.Raid:SetChecked( NAS.Raid )
	me.Say:SetChecked( NAS.Say )
	me.Yell:SetChecked( NAS.Yell )
	me.Emotes:SetChecked( NAS.Emotes )
	me.Chats:SetChecked( NAS.Chats )
	me.WhisperList:SetChecked( NAS.WhisperList )
	me.BNet:SetChecked( NAS.BNet )
	me.ChatDebug:SetChecked( NAS.ChatDebug )
	me.DisplayMode:SetChecked( NAS.DisplayMode )
	me.MF:SetChecked( NAS.MF )
	me.FontSize:SetValue( NAS.FontSize)
	me.FontSize.Val:SetCursorPosition( 0 )
	me.FontSize.Val:SetNumber( NAS.FontSize )
	me.FadeDelay:SetValue( NAS.FadeDelay)
	me.FadeDelay.Val:SetCursorPosition( 0 )
	me.FadeDelay.Val:SetNumber( NAS.FadeDelay )
	me.MSBT:SetChecked( NAS.MSBT )
	me.Sound:SetChecked( NAS.Sound )
	me.CustomMP3:SetChecked( NAS.CustomMP3 )
	me.CustomOGG:SetChecked( NAS.CustomOGG )
	me.Throttle:SetChecked( NAS.Throttle )
	me.ThrottleTime:SetValue( NAS.ThrottleTime)
	me.ThrottleTime.Val:SetCursorPosition( 0 )
	me.ThrottleTime.Val:SetNumber( NAS.ThrottleTime )
	me.ThrottleAmount:SetValue( NAS.ThrottleAmount)
	me.ThrottleAmount.Val:SetCursorPosition( 0 )
	me.ThrottleAmount.Val:SetNumber( NAS.ThrottleAmount )
end

-- Reset config panel and settings to DEFAULT
NickAlert.Reset = function(...)
	local cmd = { "Enable", "AutoAdd", "Guild", "Party", "BGs", "Raid", "Say",
		"Yell", "Emotes", "Chats", "WhisperList", "BNet", "ChatDebug", "DisplayMode", 
		"MF", "FontSize", "FadeDelay", "MSBT", "Sound", "CustomMP3", "CustomOGG", 
		"Throttle", "ThrottleTime", "ThrottleAmount" }
	for x = 1, #cmd do
		NAS[cmd[x]] = NAD[cmd[x]]
	end	
	NickAlert.Init()
end



me.refresh = function(self)
	NickAlert.Init()
end

me.default = function (self)
	NickAlert.Reset()
end

me.cancel = function (self)
	NickAlert.Init()
end


-- Save settings from config panel
me.okay = function(self)
	local cmd = { "Enable", "AutoAdd", "Guild", "Party", "Say", "Yell", "Emotes", "BGs", "Chats", "WhisperList", "BNet",
		 "ChatDebug", "DisplayMode", "MF", "MSBT", "Sound", "CustomMP3", "CustomOGG", "Throttle"}
	for x = 1, #cmd do
		ChkBoxSave( me, cmd[x] , NAS)
	end
	SliderSave( me, "FontSize", NAS) -- Font Size Slider
	SliderSave( me, "FadeDelay", NAS) -- Throttle Time Slider
	SliderSave( me, "ThrottleTime", NAS) -- Throttle Time Slider
	SliderSave( me, "ThrottleAmount", NAS) -- Throttle Amount Slider

	NickAlert.EventManager()
end

-- Register the config panel
InterfaceOptions_AddCategory( me )

-- ****************************************************************************
-- * List Manager Child Panel                                                 *
-- ****************************************************************************

--Panel
NickAlert.panel3 = CreateFrame( "Frame", "NAlertConfig3", UIParent )
local me = NickAlert.panel3
me.ListButtons = {}

me.name = "List Manager"
me.parent = NickAlert.panel.name

-- Pane title
local Title = me:CreateFontString( nil, "ARTWORK", "GameFontNormalLarge" )
Title:SetPoint( "TOPLEFT", 16, -16 )
Title:SetText( "Nick Names" )
local SubText = me:CreateFontString( nil, "ARTWORK", "GameFontHighlightSmall" )
SubText:SetPoint( "TOPLEFT", Title, "BOTTOMLEFT", 0, -8 )
SubText:SetPoint( "RIGHT", -32, 0 )
SubText:SetHeight( 32 )
SubText:SetJustifyH( "LEFT" )
SubText:SetJustifyV( "TOP" )
SubText:SetText( "Manage your alert lists here"  )
	
local last = me
local width = _G["InterfaceOptionsFramePanelContainer"]:GetWidth() / 3 --150 --me:GetWidth() /2

me.SelectButton = {}

local Selected = 1
local SelectButtonWidth = 60 -- this value is temp it gets updated to me:GetWidth() / 5
local SelectedMultiplier = 1.75 -- this is how much larger the selected mode is

me.SelectButtonUpdate = function()
	for x = 1, 4 do
		if Selected == x then
			me.SelectButton[x]:SetSize( SelectButtonWidth * SelectedMultiplier , 20)
			me.SelectButton[x]:SetButtonState("PUSHED")
		else
			me.SelectButton[x]:SetSize( SelectButtonWidth , 20)
			me.SelectButton[x]:SetButtonState("NORMAL")
		end
	end
	NickAlert.ListDisplayUpdate()
	me.slider:SetValue(0)
end

local SelectButtonText = { "Nicknames", "Chan Filters", "Whispers", "Battle Net" }

for x = 1, 4 do
	me.SelectButton[x] = CreateFrame("Button", "NAlertSelectListButton"..tostring(x), me, "UIPanelButtonTemplate" )
	if x == 1 then
		me.SelectButton[x]:SetPoint("TOPLEFT", last, "TOPLEFT", 20, -60 )
	else
		me.SelectButton[x]:SetPoint("TOPLEFT", me.SelectButton[x-1], "TOPRIGHT" )
	end
	me.SelectButton[x]:SetText( SelectButtonText[x] )
	me.SelectButton[x].count = x
	me.SelectButton[x]:SetScript("OnClick", function(self, button, down)
		if (button ~= "LeftButton") then
			return
		end
		PlaySound( "GAMEGENERICBUTTONPRESS" )
		if Selected ~= self.count then
			me.EBox:SetText("")
		end
		Selected = self.count
		me.SelectButtonUpdate()
		return
	end)
	last = me.SelectButton[1]	
end

local ButtonSubText = me:CreateFontString( nil, "ARTWORK", "GameFontHighlightSmall" )
ButtonSubText:SetPoint( "TOPLEFT", me.SelectButton[1], "BOTTOMLEFT", 0, -8 )
ButtonSubText:SetPoint( "RIGHT", -32, 0 )
ButtonSubText:SetHeight( 32 )
ButtonSubText:SetJustifyH( "LEFT" )
ButtonSubText:SetJustifyV( "TOP" )
ButtonSubText:SetText( "Manage your alert lists here"  )

NickAlert.BNetToggle = function( ID )
	local _, _, _, _, _, _, _, _, _, _, _, noteText, _, _ = BNGetFriendInfoByID( ID )
	stringX, stringY = string.find( noteText, "NAlert") 
	
	local marked = type( stringX ) == "number"
		
	if marked then -- remove the mark
		noteText = string.gsub(noteText, "NAlert", " " )
		while string.find(noteText, "^%s") do
			noteText = string.sub(noteText, 2)
		end	
		while string.find(noteText, "%s$") do
			noteText = string.sub(noteText, 1, -2)
		end
		while string.find(noteText, "%s%s" ) do
			noteText = string.gsub(noteText, "%s%s", " ")
		end
	else
		if noteText == nil or noteText == "" then
			noteText = "NAlert"
		else
			noteText = noteText.." NAlert"
		end
	end
	BNSetFriendNote( ID, noteText)
	return
end

NickAlert.ListDisplayUpdate = function()
	local Table
	if Selected == 1 then
		Table = NN
		ButtonSubText:SetText( "Add / Remove nicknames/triggers to scan for here"  )
		me.EBox.Text:SetText( "Enter a nickname or click a button above" )
	elseif Selected == 2 then
		Table = CF
		ButtonSubText:SetText( "These are the /# channels to watch \n Channels you are watching / Channels you are currently in"  )
		me.EBox.Text:SetText( "Enter a channel name or click a button above" )
	elseif Selected == 3 then
		Table = WL
		ButtonSubText:SetText( "The addon will alert you if any of these people whisper you"  )
		me.EBox.Text:SetText( "Enter a nickname or click a button above" )
	elseif Selected == 4 then
		Table = {}
		local FriendCount = BNGetNumFriends()
		for x = 1, FriendCount do
			Table[x] = {}
			Table[x].presenceID, Table[x].givenName, Table[x].surname, _, _, _, _, _, _, _, _, Table[x].noteText, _, _ = BNGetFriendInfo( x )
			Table[x].fullName = BNTokenCombineGivenAndSurname( Table[x].givenName, Table[x].surname )
		end
		ButtonSubText:SetText( "A list nicknames so Real IDs can alert you if they message you\n Click the person's name to toggle \"***\" marked will alert you"  )
	end
	local maxcount = #Table
	local slider = me.slider:GetValue()
		
	for x = 1 , 10 do
		if x + slider > maxcount then
			me.ListButtons[x]:SetText( " " )
			me.ListButtons[x].val = ""
		else
			if Selected ~= 4 then
				me.ListButtons[x]:SetText( Table[x + slider] )
				me.ListButtons[x].val = Table[x + slider]
			else
				if string.find(Table[x + slider].noteText, "NAlert") then
					me.ListButtons[x]:SetText( "*** "..Table[x + slider].fullName.." ***" )
				else
					me.ListButtons[x]:SetText( Table[x + slider].fullName )
				end
				me.ListButtons[x].val = Table[x + slider].presenceID
			end
		end
	end
	me.slider:SetMinMaxValues( 0, (#Table > 10 and #Table - 10) or 1 )
	if #Table < 11 then
		me.slider:SetValue(0)
		me.slider:Disable(true)
	else
		me.slider:Enable(true)
	end
	-- ***************************************************************************
	-- * Chan List Buttons
	if Selected == 2 then
		local chanlist = { GetChannelList() }
		local chanmax = #chanlist / 2
		for x = 1, 10 do
			if x > chanmax then
				me.ListButtons2[x]:SetText(" ")
				me.ListButtons2[x].val = ""
			else
				me.ListButtons2[x]:SetText(chanlist[x * 2])
				me.ListButtons2[x].val = chanlist[x * 2]
			end
			me.ListButtons2[x]:Show()
		end
	else
		for x = 1, 10 do
			me.ListButtons2[x]:Hide()
		end
	end
	-- ***************************************************************************
	-- * Add / Delete Ebox buttons
	if Selected == 4 then
		me.AddButton:Hide()
		me.DeleteButton:Hide()
		me.EBox:Hide()
		me.EBox.Text:Hide()
	else
		me.AddButton:Show()
		me.DeleteButton:Show()
		me.EBox:Show()
		me.EBox.Text:Show()
	end
end
	
for x = 1, 10 do
	me.ListButtons[x] = CreateFrame("Button", "NAlertListButton"..tostring(x), me, "UIPanelButtonTemplate" )
	if x == 1 then
		me.ListButtons[x]:SetPoint("TOPLEFT", last, "TOPLEFT", 60, -60 )
	else
		me.ListButtons[x]:SetPoint("TOPLEFT", last, "BOTTOMLEFT" )
	end
	me.ListButtons[x]:SetSize( width , 20)
	me.ListButtons[x]:SetText( " " )
	me.ListButtons[x].val = ""
	me.ListButtons[x]:SetScript("OnClick", function(self, button, down)
		if (button ~= "LeftButton") then
			return
		end
		if self.val == "" then return end
		PlaySound( "GAMEGENERICBUTTONPRESS" )
		if Selected == 4 then
			NickAlert.BNetToggle( self.val )
			NickAlert.ListDisplayUpdate()
			return
		end
		me.EBox:SetText(self.val)
		return
	end)
	last = me.ListButtons[x]
end

me.ListButtons2={}
for x = 1, 10 do
	me.ListButtons2[x] = CreateFrame("Button", "NAlertListButton2-"..tostring(x), me, "UIPanelButtonTemplate" )
	me.ListButtons2[x]:SetPoint("TOPLEFT",me.ListButtons[x] , "TOPRIGHT", 40, 0 )
	me.ListButtons2[x]:SetSize( width , 20)
	me.ListButtons2[x]:SetText( " " )
	me.ListButtons2[x].count = x
	me.ListButtons2[x]:SetScript("OnClick", function(self, button, down)
		if (button ~= "LeftButton") then
			return
		end
		if self.val == "" then return end
		PlaySound( "GAMEGENERICBUTTONPRESS" )
		me.EBox:SetText(self.val)
		return
	end)
end

me.slider = CreateFrame( "Slider", "NAlertNNListSlider", me, "OptionsSliderTemplate" )
me.slider:SetMinMaxValues( 0, 1 )
me.slider:SetOrientation("VERTICAL")
me.slider:SetPoint("TOPLEFT", me.ListButtons[1] ,"TOPRIGHT", 5 , 0)
me.slider:SetPoint("BOTTOMLEFT", me.ListButtons[10] ,"BOTTOMRIGHT", 5 , 0)
me.slider:SetValueStep( 1 )
me.slider:SetWidth( 16 )	
me.slider:SetScript( "OnValueChanged", function( self )
	NickAlert.ListDisplayUpdate()
end)
getglobal(me.slider:GetName() .. 'Low'):SetText( " " )
getglobal(me.slider:GetName() .. 'High'):SetText( " " )
me.slider:SetScript("OnMouseWheel", function(self, delta)
	local number
	if Selected == 1 then
		number = #NN
	elseif Selected == 2 then
		number = #CF
	elseif Selected == 3 then
		number = #WL
	elseif Selected == 4 then
		number, _ = BNGetNumFriends()
	end
	if number < 11 then
		return
	end
	SliderMW(self, -delta)
end)

me.EBox = CreateFrame( "EditBox", "NAlertNNEditbox", me, "InputBoxTemplate" )
me.EBox:SetFontObject("ChatFontNormal")
me.EBox:SetTextInsets(0, 0, 3, 3)
me.EBox:SetPoint("BOTTOMLEFT", me , "BOTTOMLEFT", 30 , 50 )
me.EBox:SetPoint("RIGHT", -32, 0)
me.EBox:SetHeight(19)
me.EBox:SetWidth(50)
me.EBox:SetAutoFocus(false)
me.EBox:SetMaxLetters( 254 )
me.EBox:SetScript("OnEnterPressed" , function(self)
	self:ClearFocus()
end)
me.EBox:SetScript("OnEscapePressed", function(self)
	self:SetText( "" )
	self:ClearFocus()
end)

me.EBox.Text = me:CreateFontString( nil, "ARTWORK", "GameFontHighlightSmall" )
me.EBox.Text:SetPoint( "BOTTOMLEFT", me.EBox , "BOTTOMLEFT", 0 , Y/4 )
me.EBox.Text:SetPoint( "RIGHT", -32, 0 )
me.EBox.Text:SetHeight( 32 )
me.EBox.Text:SetJustifyH( "LEFT" )
me.EBox.Text:SetJustifyV( "TOP" )
me.EBox.Text:SetText( "Enter data or click a button above" )

me.AddButton = CreateFrame("Button", "NalertAddButton", me, "UIPanelButtonTemplate" )
me.AddButton:SetPoint("BOTTOMLEFT", me, "BOTTOMLEFT", 20 , 20 )
me.AddButton:SetSize( 150, 25)
me.AddButton:SetText("Add")
me.AddButton:SetScript("OnClick", function(self, button, down)
	if (button ~= "LeftButton") then
		return
	end
	local EBoxText = me.EBox:GetText()
	if EBoxText == "" or EBoxText == " " then
		return
	end
	PlaySound( "GAMEGENERICBUTTONPRESS" )
	local mode = { "NickList", "Filter", "WhisperList"}
	NickAlert.List(mode[Selected], "add", EBoxText )
	me.EBox:SetText("")
	me.EBox:ClearFocus()
	NickAlert.ListDisplayUpdate()
	return
end)

me.DeleteButton = CreateFrame("Button", "NAlertDeleteButton", me, "UIPanelButtonTemplate" )
me.DeleteButton:SetPoint("BOTTOMRIGHT", me, "BOTTOMRIGHT", -20 , 20 )
me.DeleteButton:SetSize( 150, 25)
me.DeleteButton:SetText("Delete")
me.DeleteButton:SetScript("OnClick", function(self, button, down)
	if (button ~= "LeftButton") then
		return
	end
	local EBoxText = me.EBox:GetText()
	if EBoxText == "" or EBoxText == " " then
		return
	end
	PlaySound( "GAMEGENERICBUTTONPRESS" )
	local mode = { "NickList", "Filter", "WhisperList"}
	NickAlert.List(mode[Selected], "rem", EBoxText )
	me.EBox:SetText("")
	me.EBox:ClearFocus()
	NickAlert.ListDisplayUpdate()
	return
end)

me.refresh= function( self )
	me.slider:SetValue(0)
	NickAlert.ListDisplayUpdate()
	me.init()
end


me.init = function(self)
	SelectButtonWidth = _G["InterfaceOptionsFramePanelContainer"]:GetWidth() / 5
	me.SelectButtonUpdate()
end


me.refresh = me.init

InterfaceOptions_AddCategory( me )

