-- MejLayout.lua
local NameOfLayout = "noBrainShift"
local Description
local version = 20;
local layerFrame

local debugging = false

local function Layout(mainFrame, cds)
	-- Update()
	-- CreateCastFrame( spellTexture, RTframe, height, width, relwhich, relto )
	-- createLayout()
	-- deleteLayout()

	RunScript(MoonTime_DB["Layout_noBrain"]["boxtext"])
	
	
	
	local time_newicon = GetTime();
	local oldcast = mynext(cds);
	local newcast;
	local dim;
	
	local SR_CD
	local Treants_CD
	local isLunar
	local isSolar
	local eclipseDirection
	local eclipsePower
	local MF_CD
	local SunF_CD
	local DoT_CD
	local IS_CD
	local FF_CD

	local MoonTimeNextCastframe
	local MoonTimeEclipseframe
	local MoonTimeDoTframe
	local MoonTimeStarrainframe
	local MoonTimeTreantsframe
	local MoonTimeFaerieFireframe
	local MoonTimeInsectSwarmframe

	local layerFrame = CreateFrame("Frame", "layerFrame", mainFrame )
	layerFrame:SetHeight( mainFrame:GetHeight() )
	layerFrame:SetWidth( mainFrame:GetWidth() )
	layerFrame:SetPoint("CENTER")
	layerFrame:Hide()
	


	
	

layerFrame.Update = function()
	SR_CD = cds:GetStarrainCD()
	Treants_CD = cds:GetTreantsCD()
	isLunar = cds:isLunar()
	isSolar = cds:isSolar()
	eclipseDirection, eclipsePower = cds:GetEclipseDirection()
	MF_CD = cds:GetMoonfireCD()
	SunF_CD = cds:GetSunfireCD()
	DoT_CD = max(MF_CD,SunF_CD)
	IS_CD = cds:GetInsectSwarmCD()
	FF_CD = cds:GetFaerieFireCD()	

	-- MoonTimeNextCastframe
if ( MoonTime_DB["Layout_noBrainShift"]["MoonTimeNextCastframe"]["active"] ) then 
	MoonTimeNextCastframe:Show()
	newcast = mynext(cds)
	
	if oldcast ~= newcast then
		time_newicon = GetTime();
	end
	oldcast = newcast

	dim = MoonTime_DB["Layout_noBrainShift"]["MoonTimeNextCastframe"]["xdim"];
	MoonTimeNextCastframe:SetIcon(newcast)
	if MoonTime_DB["Layout_noBrain"]["blinkspells"][newcast] then
	--GetTime-time_newicon -- wenn 0 volle gre
						--	wenn time_descale normale gre
		dim = max(MoonTime_DB["Layout_noBrainShift"]["MoonTimeNextCastframe"]["xdim"]*MoonTime_DB["Layout_noBrain"]["blink_factor"]*(1-((GetTime()-time_newicon)/MoonTime_DB["Layout_noBrain"]["blink_time_descale"])^5),MoonTime_DB["Layout_noBrainShift"]["MoonTimeNextCastframe"]["xdim"]);
		alpha = min( 0.75+((GetTime()-time_newicon)/MoonTime_DB["Layout_noBrain"]["blink_time_descale"])^5/2 , 1 )
	end
	
	MoonTimeNextCastframe:SetBackdropColor(1,1,1,alpha)
	MoonTimeNextCastframe:SetHeight(dim)
	MoonTimeNextCastframe:SetWidth(dim)
else
	MoonTimeNextCastframe:Hide()
end

-- MoonTimeEclipseframe
if ( MoonTime_DB["Layout_noBrainShift"]["MoonTimeEclipseframe"]["active"] ) then
	if ( eclipseDirection == "moon" ) then
		MoonTimeEclipseframe:SetIcon(Solar_icon)
	else
		MoonTimeEclipseframe:SetIcon(Lunar_icon)
	end
	MoonTimeEclipseframe:Show()
	
	if ( MoonTime_DB["Layout_noBrainShift"]["MoonTimeEclipseframe"]["text"] ) then
		if ( eclipsePower >= 0 ) then
			MoonTimeEclipseframe:SetText( "|cffffff00".. eclipsePower .."|r" )
		else
			MoonTimeEclipseframe:SetText( "|cff0088ff".. -eclipsePower .."|r" )
		end
	end
else
	MoonTimeEclipseframe:Hide()
end

-- MoonTimeDoTframe
if ( MoonTime_DB["Layout_noBrainShift"]["MoonTimeDoTframe"]["active"] ) then
	MoonTimeDoTframe:SetIcon(MF_icon)
	if ( SunF_CD > 0 ) then
		MoonTimeDoTframe:SetIcon(SunF_icon)
	end
	
	MoonTimeDoTframe:SetText( '' )
	MoonTimeDoTframe:Show()
	
	if ( DoT_CD > 0 ) then
		if MoonTime_DB["Layout_noBrainShift"]["MoonTimeDoTframe"]["text"] then
			MoonTimeDoTframe:SetText( '|cfff6ffff' .. math.ceil(DoT_CD) .. '|r' )
		elseif MoonTime_DB["Layout_noBrainShift"]["MoonTimeDoTframe"]["popup"] then
			MoonTimeDoTframe:Hide()
		else
			MoonTimeDoTframe:SetText( ' ' )
		end
	end
else
	MoonTimeDoTframe:Hide()
end	

-- MoonTimeStarrainframe
if ( MoonTime_DB["Layout_noBrainShift"]["MoonTimeStarrainframe"]["active"] ) then

	MoonTimeStarrainframe:SetText( '' )
	MoonTimeStarrainframe:Show()
	
	if ( SR_CD > 1.5 ) then
		if MoonTime_DB["Layout_noBrainShift"]["MoonTimeStarrainframe"]["text"] then
			MoonTimeStarrainframe:SetText( '|cfff6ffff' .. math.ceil(SR_CD) .. '|r' )
		elseif MoonTime_DB["Layout_noBrainShift"]["MoonTimeStarrainframe"]["popup"] then
			MoonTimeStarrainframe:Hide()
		else
			MoonTimeStarrainframe:SetText( ' ' )
		end
	end
else
	MoonTimeStarrainframe:Hide()
end
		
-- MoonTimeTreantsframe	
if ( MoonTime_DB["Layout_noBrainShift"]["MoonTimeTreantsframe"]["active"] ) then
	MoonTimeTreantsframe:SetText( '' )
	MoonTimeTreantsframe:Show()
	
	if ( Treants_CD > 1.5 ) then
		if MoonTime_DB["Layout_noBrainShift"]["MoonTimeTreantsframe"]["text"] then
			if Treants_CD > 99 then
				MoonTimeTreantsframe:SetText( '|cfff6ffff' .. math.ceil(Treants_CD/60) .. 'm|r' )
			else
				MoonTimeTreantsframe:SetText( '|cfff6ffff' .. math.ceil(Treants_CD) .. '|r' )
			end
		elseif MoonTime_DB["Layout_noBrainShift"]["MoonTimeTreantsframe"]["popup"] then
			MoonTimeTreantsframe:Hide()
		else
			MoonTimeTreantsframe:SetText( ' ' )
		end
	end
else
	MoonTimeTreantsframe:Hide()
end
	
-- MoonTimeFaerieFireframe
if ( MoonTime_DB["Layout_noBrainShift"]["MoonTimeFaerieFireframe"]["active"] ) then

	MoonTimeFaerieFireframe:SetText( '' )
	MoonTimeFaerieFireframe:Show()
	
	if ( FF_CD > 1.5 ) then
		if MoonTime_DB["Layout_noBrainShift"]["MoonTimeFaerieFireframe"]["text"] then
			if FF_CD > 99 then
				MoonTimeFaerieFireframe:SetText( '|cfff6ffff' .. math.ceil(FF_CD/60) .. 'm|r' )
			else
				MoonTimeFaerieFireframe:SetText( '|cfff6ffff' .. math.ceil(FF_CD) .. '|r' )
			end
		elseif MoonTime_DB["Layout_noBrainShift"]["MoonTimeFaerieFireframe"]["popup"] then
			MoonTimeFaerieFireframe:Hide()
		else
			MoonTimeFaerieFireframe:SetText( ' ' )
		end
	end
else
	MoonTimeFaerieFireframe:Hide()
end
	
-- MoonTimeInsectSwarmframe	
if ( MoonTime_DB["Layout_noBrainShift"]["MoonTimeInsectSwarmframe"]["active"] ) then

	MoonTimeInsectSwarmframe:SetText( '' )
	MoonTimeInsectSwarmframe:Show()
	
	if ( IS_CD > 0 ) then
		if MoonTime_DB["Layout_noBrainShift"]["MoonTimeInsectSwarmframe"]["text"] then
			MoonTimeInsectSwarmframe:SetText( '|cfff6ffff' .. math.ceil(IS_CD) .. '|r' )
		elseif MoonTime_DB["Layout_noBrainShift"]["MoonTimeInsectSwarmframe"]["popup"] then
			MoonTimeInsectSwarmframe:Hide()
		else
			MoonTimeInsectSwarmframe:SetText( ' ' )
		end
	end
else
	MoonTimeInsectSwarmframe:Hide()
end

end	
	
	
	
	
	
	
	
	
	layerFrame.CreateCastFrame = function( spellTexture, RTframe, height, width, relwhich, relto, xoff, yoff )
		if not xoff then xoff= 0 end
		if not yoff then yoff= 0 end

		local frame = CreateFrame( "Frame", "MTCastframe"..RTframe:GetName(), layerFrame )
		frame:SetBackdrop({
			bgFile = spellTexture,
			tile = false, tileSize = height, edgeSize = 0,
			insets = { left = 0, right = 0, top = 0, bottom = 0 }
		})
		frame:SetHeight(height)
		frame:SetWidth(width)
		frame:SetPoint(relwhich, RTframe, relto, xoff, yoff)

		local labelframe = frame:CreateFontString(nil,"ARTWORK","GameFontNormal")
		labelframe:SetPoint("TOPLEFT", frame, "TOPLEFT")
		labelframe:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT")
		labelframe:SetTextColor( 1, 1, 1, 1 );
		frame.SetText = function( self, msg )
			if( msg == '' ) then
				frame:SetBackdropColor(1,1,1,1)		
			else
				frame:SetBackdropColor(1,1,1,.5)	
			end
			labelframe:SetText(msg)
		end
		frame.SetIcon = function( self, icon )
			frame:SetBackdrop({bgFile = icon})
		end
		
		return frame
	end

	layerFrame.createLayout = function ()
		MoonTimeDoTframe = layerFrame.CreateCastFrame( "", layerFrame, MoonTime_DB["Layout_noBrainShift"]["MoonTimeDoTframe"]["xdim"], MoonTime_DB["Layout_noBrainShift"]["MoonTimeDoTframe"]["ydim"], "CENTER", "CENTER",MoonTime_DB["Layout_noBrainShift"]["MoonTimeDoTframe"]["xoffset"],MoonTime_DB["Layout_noBrainShift"]["MoonTimeDoTframe"]["yoffset"])
		MoonTimeStarrainframe = layerFrame.CreateCastFrame( SR_icon, layerFrame, MoonTime_DB["Layout_noBrainShift"]["MoonTimeStarrainframe"]["xdim"], MoonTime_DB["Layout_noBrainShift"]["MoonTimeStarrainframe"]["ydim"], "CENTER", "CENTER",MoonTime_DB["Layout_noBrainShift"]["MoonTimeStarrainframe"]["xoffset"],MoonTime_DB["Layout_noBrainShift"]["MoonTimeStarrainframe"]["yoffset"])
		MoonTimeTreantsframe = layerFrame.CreateCastFrame( Treants_icon, layerFrame, MoonTime_DB["Layout_noBrainShift"]["MoonTimeTreantsframe"]["xdim"], MoonTime_DB["Layout_noBrainShift"]["MoonTimeTreantsframe"]["ydim"], "CENTER", "CENTER",MoonTime_DB["Layout_noBrainShift"]["MoonTimeTreantsframe"]["xoffset"],MoonTime_DB["Layout_noBrainShift"]["MoonTimeTreantsframe"]["yoffset"])
		MoonTimeFaerieFireframe = layerFrame.CreateCastFrame( FF_icon, layerFrame, MoonTime_DB["Layout_noBrainShift"]["MoonTimeFaerieFireframe"]["xdim"], MoonTime_DB["Layout_noBrainShift"]["MoonTimeFaerieFireframe"]["ydim"], "CENTER", "CENTER",MoonTime_DB["Layout_noBrainShift"]["MoonTimeFaerieFireframe"]["xoffset"],MoonTime_DB["Layout_noBrainShift"]["MoonTimeFaerieFireframe"]["yoffset"])
		MoonTimeInsectSwarmframe = layerFrame.CreateCastFrame( IS_icon, layerFrame, MoonTime_DB["Layout_noBrainShift"]["MoonTimeInsectSwarmframe"]["xdim"], MoonTime_DB["Layout_noBrainShift"]["MoonTimeInsectSwarmframe"]["ydim"], "CENTER", "CENTER",MoonTime_DB["Layout_noBrainShift"]["MoonTimeInsectSwarmframe"]["xoffset"],MoonTime_DB["Layout_noBrainShift"]["MoonTimeInsectSwarmframe"]["yoffset"])
		MoonTimeEclipseframe = layerFrame.CreateCastFrame( "", layerFrame, MoonTime_DB["Layout_noBrainShift"]["MoonTimeEclipseframe"]["xdim"], MoonTime_DB["Layout_noBrainShift"]["MoonTimeEclipseframe"]["ydim"], "CENTER", "CENTER",MoonTime_DB["Layout_noBrainShift"]["MoonTimeEclipseframe"]["xoffset"],MoonTime_DB["Layout_noBrainShift"]["MoonTimeEclipseframe"]["yoffset"])
		MoonTimeNextCastframe = layerFrame.CreateCastFrame( "", layerFrame, MoonTime_DB["Layout_noBrainShift"]["MoonTimeNextCastframe"]["xdim"], MoonTime_DB["Layout_noBrainShift"]["MoonTimeNextCastframe"]["ydim"], "CENTER", "CENTER",MoonTime_DB["Layout_noBrainShift"]["MoonTimeNextCastframe"]["xoffset"],MoonTime_DB["Layout_noBrainShift"]["MoonTimeNextCastframe"]["yoffset"])
	end
	

	layerFrame.deleteLayout = function()
		MoonTimeNextCastframe:Hide()
		MoonTimeNextCastframe = nil
		MoonTimeEclipseframe:Hide()
		MoonTimeEclipseframe = nil
		MoonTimeDoTframe:Hide()
		MoonTimeDoTframe = nil
		MoonTimeStarrainframe:Hide()
		MoonTimeStarrainframe = nil
		MoonTimeTreantsframe:Hide()
		MoonTimeTreantsframe = nil
		MoonTimeFaerieFireframe:Hide()
		MoonTimeFaerieFireframe = nil
		
		layerFrame:Hide()
		layerFrame = nil
	end
	


	return layerFrame
end

-- ****************************************
--
-- DO NOT CHANGE ANYTHING BELOW THIS 
--
-- ****************************************

local function registerLayout( name )									-- Beginn initialize
	local LayoutFrame
	local frame = CreateFrame( "Frame", name, UIPARENT	)
	frame.ID = name
	frame:RegisterEvent("VARIABLES_LOADED");
	frame:SetScript("OnEvent", 
		function( self, event )
			if event=="VARIABLES_LOADED" then							-- falls das ausloesende Event VARIABLES_LOADED ist ...
																		-- werden die ausstehenden Events registriert
				if ( GetLocale() == "deDE" ) then
					frame.description = MoonTime_noBrainShift_Strings["deDE"]["description"]
				else
					frame.description = MoonTime_noBrainShift_Strings["enGB"]["description"]
				end
																		
				if ( not MoonTime_DB["Layout_noBrainShift"] or MoonTime_DB["Layout_noBrainShift"]["version"] < version ) then
					frame:UpdateDB()
				end

				MoonTimeDoorKeeper:RegisterLayout(self);
			end
		end
	)
	
	frame.createLayout = function( self ) 
		LayoutFrame = Layout(self.Mainframe, self.Objectframe)
		LayoutFrame:createLayout()
	end

	frame.Hide = function()
		LayoutFrame:Hide()
	end
	frame.Show = function()
		LayoutFrame:Show()
	end
	frame.Update = function()
		LayoutFrame:Update()
	end

	frame.deleteLayout = function()
		LayoutFrame:deleteLayout()
	end
	
	frame.UpdateDB = function()
		MoonTime_DB["Layout_noBrainShift"] = {
			["version"] = version,
			["MoonTimeNextCastframe"] = {
				["active"] = true,
				["xoffset"] = 0,
				["yoffset"] = -18,
				["xdim"] = 36,
				["ydim"] = 36,
			},
			["MoonTimeEclipseframe"] = {
				["active"] = true,
				["text"] = true,
				["xoffset"] = 27,
				["yoffset"] = -27,
				["xdim"] = 18,
				["ydim"] = 18,
			},
			["MoonTimeDoTframe"] = {
				["active"] = true,
				["text"] = false,
				["popup"] = true,
				["xoffset"] = -27,
				["yoffset"] = -9,
				["xdim"] = 18,
				["ydim"] = 18,
			},
			["MoonTimeStarrainframe"] = {
				["active"] = true,
				["text"] = true,
				["popup"] = true,
				["xoffset"] = -9,
				["yoffset"] = -45,
				["xdim"] = 18,
				["ydim"] = 18,
			},
			["MoonTimeTreantsframe"] = {
				["active"] = true,
				["text"] = true,
				["popup"] = true,
				["xoffset"] = 9,
				["yoffset"] = -45,
				["xdim"] = 18,
				["ydim"] = 18,
			},
			["MoonTimeFaerieFireframe"] = {
				["active"] = true,
				["text"] = false,
				["popup"] = true,
				["xoffset"] = 27,
				["yoffset"] = -9,
				["xdim"] = 18,
				["ydim"] = 18,
			},
			["MoonTimeInsectSwarmframe"] = {
				["active"] = true,
				["text"] = false,
				["popup"] = true,
				["xoffset"] = -27,
				["yoffset"] = -27,
				["xdim"] = 18,
				["ydim"] = 18,
			}
		}
	end
	
end																		-- Ende initialize

registerLayout(NameOfLayout)