-- MejLayout.lua
local NameOfLayout = "noBrain"
local Description;
local version = 7;
local layerFrame

local debugging = false

local function Layout(mainFrame, cds)
	-- Update()
	-- CreateCastFrame( spellTexture, RTframe, height, width, relwhich, relto )
	-- createLayout()
	-- deleteLayout()

	RunScript(MoonTime_DB["Layout_noBrain"]["boxtext"])
	
	
	
	local time_newicon = GetTime();
	local oldcast = mynext(cds);
	local newcast;
	local dim = 36;

	local MoonTimeNextCastframe
	local MoonTimeStarrainframe
	local MoonTimeTreeframe

	local layerFrame = CreateFrame("Frame", "layerFrame", mainFrame )
	layerFrame:SetHeight( mainFrame:GetHeight() )
	layerFrame:SetWidth( mainFrame:GetWidth() )
	layerFrame:SetPoint("CENTER")
	layerFrame:Hide()
	


	
	

	layerFrame.Update = function()
	
	
	newcast = mynext(cds)
		
	if oldcast ~= newcast then
		--MoonTime:echo("neuer cast")
		time_newicon = GetTime();
	end
	oldcast = newcast
	--MoonTime:echo(GetTime() - time_newicon)
	
	dim = 36;


	MoonTimeNextCastframe:SetIcon(newcast)
	if MoonTime_DB["Layout_noBrain"]["blinkspells"][newcast] then
	
	--GetTime-time_newicon -- wenn 0 volle gre
						--	wenn time_descale normale gre
		dim = max(36*MoonTime_DB["Layout_noBrain"]["blink_factor"]*(1-((GetTime()-time_newicon)/MoonTime_DB["Layout_noBrain"]["blink_time_descale"])^5),36);
		alpha = min( 0.75+((GetTime()-time_newicon)/MoonTime_DB["Layout_noBrain"]["blink_time_descale"])^5/2 , 1 )
	end
	
	MoonTimeNextCastframe:SetBackdropColor(1,1,1,alpha)
	MoonTimeNextCastframe:SetHeight(dim)
	MoonTimeNextCastframe:SetWidth(dim)
	
	


	
	
	if debugging then
		MoonTimeNextCastframe:SetText (W_Flying.." "..SF_Flying.." "..SS_Flying);
	end
		
	local SR_cd = cds:GetStarrainCD()
	local Treants_cd = cds:GetTreantsCD()
	local isLunar = cds:isLunar()
		
	if SR_cd > 1.5 then
		MoonTimeStarrainframe:SetText( '|cfff6ffff' .. math.ceil(SR_cd) .. '|r' )
	elseif isLunar then
		MoonTimeStarrainframe:SetText( '' )
	else
		MoonTimeStarrainframe:SetText( ' ' )
	end
		
		if Treants_cd > 99 then
			MoonTimeTreantsframe:SetText( '|cfff6ffff' .. math.ceil(Treants_cd/60) .. 'm|r' )
		elseif Treants_cd > 1.5 then
			MoonTimeTreantsframe:SetText( '|cfff6ffff' .. math.ceil(Treants_cd) .. '|r' )
		else
			MoonTimeTreantsframe:SetText( '' )
		end

	end

	layerFrame.CreateCastFrame = function( spellTexture, RTframe, height, width, relwhich, relto, xoff, yoff )
		if not xoff then xoff= 0 end
		if not yoff then yoff= 0 end

		local frame = CreateFrame( "Frame", "MTCastframe"..RTframe:GetName(), layerFrame )
		frame:SetBackdrop({
			bgFile = spellTexture,
			tile = false, tileSize = height, edgeSize = 0,
			insets = { left = 0, right = 0, top = 0, bottom = 0 }
		})
		frame:SetHeight(height)
		frame:SetWidth(width)
		frame:SetPoint(relwhich, RTframe, relto, xoff, yoff)

		local labelframe = frame:CreateFontString(nil,"ARTWORK","GameFontNormal")
		labelframe:SetPoint("TOPLEFT", frame, "TOPLEFT")
		labelframe:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT")
		labelframe:SetTextColor( 1, 1, 1, 1 );
		frame.SetText = function( self, msg )
			if( msg == '' ) then
				frame:SetBackdropColor(1,1,1,1)		
			else
				frame:SetBackdropColor(1,1,1,.5)	
			end
			labelframe:SetText(msg)
		end
		frame.SetIcon = function( self, icon )
			frame:SetBackdrop({bgFile = icon})
		end
		
		return frame
	end

	layerFrame.createLayout = function ()
		--mainFrame:SetHeight(100)
		--mainFrame:SetWidth(100)
		local castwidth = 48
		local castheight = 16

		MoonTimeStarrainframe = layerFrame.CreateCastFrame(SR_icon, layerFrame, 12, 18, "TOPRIGHT", "CENTER",0,-36)
		MoonTimeTreantsframe = layerFrame.CreateCastFrame(Treants_icon, layerFrame, 12, 18, "TOPLEFT", "CENTER",0,-36)
		MoonTimeNextCastframe = layerFrame.CreateCastFrame( "", layerFrame, 36, 36, "CENTER", "CENTER",0,-18)
	end
	

	layerFrame.deleteLayout = function()
		MoonTimeNextCastframe:Hide()
		MoonTimeNextCastframe = nil
		MoonTimeStarrainframe:Hide()
		MoonTimeStarrainframe = nil
		MoonTimeTreantsframe:Hide()
		MoonTimeTreantsframe = nil
		
		layerFrame:Hide()
		layerFrame = nil
	end
	


	return layerFrame
end

-- ****************************************
--
-- DO NOT CHANGE ANYTHING BELOW THIS 
--
-- ****************************************

local function registerLayout( name )									-- Beginn initialize

	local LayoutFrame
	local frame = CreateFrame( "Frame", name, UIPARENT	)
	frame.ID = NameOfLayout
	--frame.description = Description
	frame:RegisterEvent("VARIABLES_LOADED");
	frame:SetScript("OnEvent", 
		function( self, event, name, ... )
			if event=="VARIABLES_LOADED" then							-- falls das ausloesende Event VARIABLES_LOADED ist ...
																		-- werden die ausstehenden Events registriert
				if ( GetLocale() == "deDE" ) then
					frame.description = MoonTime_noBrainConfig_Strings["deDE"]["description"]
				else
					frame.description = MoonTime_noBrainConfig_Strings["enGB"]["description"]
				end

				if ( not MoonTime_DB["Layout_noBrain"] or MoonTime_DB["Layout_noBrain"]["version"] < version ) then
					frame:UpdateDB()
				end

				MoonTimeDoorKeeper:RegisterLayout(self);
			end
		end
	)
	
	frame.createLayout = function( self ) 
		LayoutFrame = Layout(self.Mainframe, self.Objectframe)
		LayoutFrame:createLayout()
	end

	frame.Hide = function()
		LayoutFrame:Hide()
	end
	frame.Show = function()
		LayoutFrame:Show()
	end
	frame.Update = function()
		LayoutFrame:Update()
	end

	frame.deleteLayout = function()
		LayoutFrame:deleteLayout()
	end
	
	frame.UpdateDB = function()
		MoonTime_DB["Layout_noBrain"] = {
			["version"] = version,
			["boxtext"] = "function nodot_next(frame)\n\n\nlocal spell, _, _, _, startTime, endTime, _, castID, _ = UnitCastingInfo(\"player\");\nlocal EDir, EPower = frame:GetEclipseDirection();\n\nlocal futurePower = EPower;\n\nlocal gcdstart, gcd = GetSpellCooldown(8921);\nlocal casttime = max(gcdstart+gcd-GetTime(),0);\n\nif (startTime) then\n  casttime = endTime/1000-GetTime();\nend\n\n\nif (EDir == \"moon\") then\n  futurePower = futurePower -13*W_Flying - 15*SS_Flying;\n  if (spell == W_name) then\n    futurePower = futurePower - 13;\n  end\n  if (spell == SS_name) then\n    futurePower = futurePower - 15;\n  end\nend\n\nif (EDir == \"sun\") then\n  futurePower = futurePower + 20*SF_Flying + 15*SS_Flying;\n  if (spell == SF_name) then\n    futurePower = futurePower + 20;\n  end\n\n  if (spell == SS_name) then\n    futurePower = futurePower + 15;\n  end\nend\n\nif (EDir == \"moon\" and futurePower < -99) then\n  EDir = \"sun\";\nend\nif (EDir == \"sun\" and futurePower > 99) then\n  EDir = \"moon\";\nend\n\n\nif ( frame:GetStarsurgeCD() <= casttime and spell ~= SS_name ) then\n    return SS_icon\nend\n\nif ( EDir == \"sun\" ) then\n    return SF_icon\nelse\n    return W_icon\nend\n        \nend\n\n\nfunction getCastTime(icon)\n\n_, _, _, _, _, _, W_castTime = GetSpellInfo(5176); -- Zorn\n_, _, _, _, _, _, SF_castTime = GetSpellInfo(2912);  -- Sternenfeuer\n\nif (icon == SF_icon) then\n  return SF_castTime/1000;\nelse\n  return W_castTime/1000;\nend\n\nend\n\n\nfunction mynext(frame)\n\n\nlocal spell, _, _, _, startTime, endTime, _, castID, _ = UnitCastingInfo(\"player\");\n        local EDir, EPower = frame:GetEclipseDirection();\n\n\n\nlocal gcdstart, gcd = GetSpellCooldown(8921);\nlocal casttime = max(gcdstart+gcd-GetTime(),0);\n\nif (startTime) then\n  casttime = endTime/1000-GetTime();\nend\n\n\n\nlocal futurePower = EPower;\n\n\nif (EDir == \"moon\") then\n  futurePower = futurePower -16*W_Flying - 15*SS_Flying;\n  if (spell == W_name) then\n    futurePower = futurePower - 16;\n  end\n  if (spell == SS_name) then\n    futurePower = futurePower - 15;\n  end\nend\n\nif (EDir == \"sun\") then\n  futurePower = futurePower + 25*SF_Flying + 15*SS_Flying;\n  if (spell == SF_name) then\n    futurePower = futurePower + 25;\n  end\n\n  if (spell == SS_name) then\n    futurePower = futurePower + 15;\n  end\nend\n\n\n\nif (EDir == \"moon\" and futurePower < -99) then\n  EDir = \"sun\";\nend\nif (EDir == \"sun\" and futurePower > 99) then\n  EDir = \"moon\";\nend\n\n_, _, _, _, _, _, W_castTime = GetSpellInfo(5176); -- Zorn\n_, _, _, _, _, _, SF_castTime = GetSpellInfo(2912);  -- Sternenfeuer\n_, _, _, _, _, _, SS_castTime = GetSpellInfo(78674);  -- Sternensog\n\n\nlocal IS_CD = frame:GetInsectSwarmCD();\nlocal DOT_CD = max(frame:GetMoonfireCD(),frame:GetSunfireCD());\n\n--MoonTime:echo(DOT_CD)\n\nlocal nextcasttime = getCastTime(nodot_next(frame));\n\n\n\nif (IS_CD < 0 and (frame:isSolar() or frame:isLunar()) ) then\nreturn IS_icon\nend\n\nif (IS_CD>casttime and IS_CD < casttime+nextcasttime and (frame:isSolar() or frame:isLunar()) ) then\nreturn IS_icon\nend\n\nif (DOT_CD < 0 and (frame:isSolar() or frame:isLunar())) then\n  if (frame:isSolar()) then\n    return SunF_icon\n  else\n    return MF_icon\n  end\nend\n\nif (DOT_CD>casttime and DOT_CD < casttime+nextcasttime and (frame:isSolar() or frame:isLunar())) then\n  if (frame:isSolar()) then\n    return MF_icon\n  else\n    return MF_icon\n  end\nend\n\n\nreturn nodot_next(frame)\nend",
			["boxtextposi"] = 0,
			["blink_factor"] = 8,
			["blink_time_descale"] = 0.15,
			["blinkspells"] = {
				[SS_icon] = true,
				[MF_icon] = true,
				[SunF_icon] = true,
				[W_icon] = false,
				[SF_icon] = false,
				[IS_icon] = true,
			},
		}
	end
	
end																		-- Ende initialize

registerLayout(NameOfLayout)
