-- MejLayout.lua
local NameOfLayout = "Mej"
local Description;
local version = 2;
local layerFrame


local function Layout(mainFrame, cds)
	-- Update()
	-- CreateCastFrame( spellTexture, RTframe, height, width, relwhich, relto )
	-- createLayout()
	-- deleteLayout()

	local MoonTimeNextCastframe
	local MoonTimeEclipseframe
	local MoonTimeMoonfireframe
	local MoonTimeInsectswarmframe
	local MoonTimeStarrainframe
	local MoonTimeStarsurgeframe
	
	RunScript(MoonTime_DB["Layout_Mej"]["boxtext"])
	
	
	local layerFrame = CreateFrame("Frame", "layerFrame", mainFrame )
	layerFrame:SetHeight( mainFrame:GetHeight() )
	layerFrame:SetWidth( mainFrame:GetWidth() )
	layerFrame:SetPoint("CENTER")
	layerFrame:Hide()
	
	layerFrame.Update = function()
		MoonTimeNextCastframe:SetIcon(mynext(cds))

		local EDir, Epower = cds:GetEclipseDirection()
		local MF = cds:GetMoonfireCD()
		local SunF = cds:GetSunfireCD()
		local IS = cds:GetInsectSwarmCD()
		local SS_CD = cds:GetStarsurgeCD()
		local SR_cd = cds:GetStarrainCD()
		local Treants_cd = cds:GetTreantsCD()

		if( EDir == "sun" ) then 
			MoonTimeEclipseframe:SetIcon( Lunar_icon )
			local color = "ffff00"
			local bool = false
			if ( Epower < 0 ) then 
				color = "0088ff" 
				Epower = -1 * Epower
				bool = true
			end
			MoonTimeEclipseframe:SetText( "|cff"..color..Epower.."|r", bool);
		end

		if( EDir == "moon" ) then 
			MoonTimeEclipseframe:SetIcon( Solar_icon )		
			local color = "ffff00"
			local bool = true
			if ( Epower < 0 ) then 
				color = "0088ff" 
				Epower = -1 * Epower
				bool = false
			end
			MoonTimeEclipseframe:SetText( "|cff"..color..Epower.."|r", bool);
		end
		
		if MF>=0 or SunF>=0 then
			if MF>=0 then
			MoonTimeMoonfireframe:SetText( string.format("%2.1f", (MF) ) , false)
			MoonTimeMoonfireframe:SetIcon(MF_icon)
			else
			MoonTimeMoonfireframe:SetText( string.format("%2.1f", (SunF) ) , false)
			MoonTimeMoonfireframe:SetIcon(SunF_icon)
			end
		else
			MoonTimeMoonfireframe:SetText( '', true )
		end
		
		if IS>=0 then
			MoonTimeInsectswarmframe:SetText( string.format("%2.1f", (IS) ), false )
		else
			MoonTimeInsectswarmframe:SetText( '', true )
		end

		if SS_CD>=0 then
			MoonTimeStarsurgeframe:SetText( string.format("%2.1f", (SS_CD) ), false )
		else
			MoonTimeStarsurgeframe:SetText( '', true )
		end

	end

	layerFrame.CreateCastFrame = function( spellTexture, RTframe, height, width, relwhich, relto )
		local frame = CreateFrame( "Frame", "MTCastframe"..RTframe:GetName(), layerFrame )
		frame:SetBackdrop({
			bgFile = "Interface\\TUTORIALFRAME\\TutorialFrameBackground",
			edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
			tile = true, tileSize = height, edgeSize = 10,
			insets = { left = 2, right = 2, top = 2, bottom = 2 }
		})
		frame:SetHeight(height)
		frame:SetWidth(width)
		frame:SetPoint(relwhich, RTframe, relto, 0, 0)

		local iconframe = CreateFrame( "Frame", "MTCastframe"..RTframe:GetName(), frame )
		iconframe:SetPoint("LEFT", frame, "LEFT")
		iconframe:SetBackdrop({
			bgFile = spellTexture,
			edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
			tile = false, tileSize = height, edgeSize = 10,
			insets = { left = 1, right = 1, top = 1, bottom = 1 }
		})
		iconframe:SetHeight(height)
		iconframe:SetWidth(height)
		
		local labelframe = frame:CreateFontString(nil,"ARTWORK","GameFontNormal")
		labelframe:SetPoint("TOPLEFT", iconframe, "TOPRIGHT")
		labelframe:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT")
		labelframe:SetTextColor( 1, 1, 0, 1 );
		frame.SetAlpha = function( self, bool )
			if bool then
				iconframe:SetBackdropColor(1,1,1,1)		
			else
				iconframe:SetBackdropColor(1,1,1,.5)		
			end
		end
		frame.SetText = function( self, msg, bool )
			self:SetAlpha(bool)
			labelframe:SetText(msg)
		end
		frame.SetIcon = function( self, icon )
			iconframe:SetBackdrop({
			bgFile = icon,
			edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
			tile = true, tileSize = height, edgeSize = 10,
			insets = { left = 1, right = 1, top = 1, bottom = 1 }
			})
		end
		
		return frame
	end

	layerFrame.createLayout = function ()
		mainFrame:SetHeight(96)
		mainFrame:SetWidth(64)
		local castwidth = 48
		local castheight = 16
		-- Layout fuer eliteFrame

		MoonTimeNextCastframe = layerFrame.CreateCastFrame( "", layerFrame, 32, 32, "TOP", "TOP")
		MoonTimeEclipseframe = layerFrame.CreateCastFrame( "Interface\\Icons\\Ability_Druid_Eclipse", MoonTimeNextCastframe, castheight, castwidth, "TOP", "BOTTOM")
		MoonTimeMoonfireframe = layerFrame.CreateCastFrame( "Interface\\Icons\\Spell_Nature_StarFall", MoonTimeEclipseframe, castheight, castwidth, "TOP", "BOTTOM")
		MoonTimeInsectswarmframe = layerFrame.CreateCastFrame( "Interface\\Icons\\Spell_Nature_InsectSwarm", MoonTimeMoonfireframe, castheight, castwidth, "TOP", "BOTTOM")
		MoonTimeStarsurgeframe = layerFrame.CreateCastFrame( SS_icon, MoonTimeInsectswarmframe, castheight, castwidth, "TOP", "BOTTOM")
--		MoonTimeMoonfireframe:Hide()
--		MoonTimeInsectswarmframe:Hide()
		MoonTimeStarsurgeframe:Hide()
	end
	

	layerFrame.deleteLayout = function()
		MoonTimeNextCastframe:Hide()
		MoonTimeNextCastframe = nil
		MoonTimeEclipseframe:Hide()
		MoonTimeEclipseframe = nil
		MoonTimeMoonfireframe:Hide()
		MoonTimeMoonfireframe = nil
		MoonTimeInsectswarmframe:Hide()
		MoonTimeInsectswarmframe = nil
		
		layerFrame:Hide()
		layerFrame = nil
	end

	return layerFrame
end

-- ****************************************
--
-- DO NOT CHANGE ANYTHING BELOW THIS 
--
-- ****************************************

local function registerLayout( name )									-- Beginn initialize
	local LayoutFrame
	local frame = CreateFrame( "Frame", name, UIPARENT	)
	frame.ID = name
	frame:RegisterEvent("VARIABLES_LOADED");
	frame:SetScript("OnEvent", 
		function( self, event )
			if event=="VARIABLES_LOADED" then							-- falls das ausloesende Event VARIABLES_LOADED ist ...
																		-- werden die ausstehenden Events registriert
				if ( GetLocale() == "deDE" ) then
					frame.description = MoonTime_Mej_Strings["deDE"]["description"]
				else
					frame.description = MoonTime_Mej_Strings["enGB"]["description"]
				end
				
				if ( not MoonTime_DB["Layout_Mej"] or MoonTime_DB["Layout_Mej"]["version"] < version ) then
					frame:UpdateDB()
				end
				
				MoonTimeDoorKeeper:RegisterLayout(self);
			end
		end
	)
	
	frame.createLayout = function( self ) 
		LayoutFrame = Layout(self.Mainframe, self.Objectframe)
		LayoutFrame:createLayout()
	end

	frame.Hide = function()
		LayoutFrame:Hide()
	end
	frame.Show = function()
		LayoutFrame:Show()
	end
	frame.Update = function()
		LayoutFrame:Update()
	end

	frame.deleteLayout = function()
		LayoutFrame:deleteLayout()
	end
	
	frame.UpdateDB = function()
		MoonTime_DB["Layout_Mej"] = {
			["version"] = version,
			["boxtext"] = "function nodot_next(frame)\n\n\nlocal spell, _, _, _, startTime, endTime, _, castID, _ = UnitCastingInfo(\"player\");\nlocal EDir, EPower = frame:GetEclipseDirection();\n\nlocal futurePower = EPower;\n\nlocal gcdstart, gcd = GetSpellCooldown(8921);\nlocal casttime = max(gcdstart+gcd-GetTime(),0);\n\nif (startTime) then\n  casttime = endTime/1000-GetTime();\nend\n\n\nif (EDir == \"moon\") then\n  futurePower = futurePower -13*W_Flying - 15*SS_Flying;\n  if (spell == W_name) then\n    futurePower = futurePower - 13;\n  end\n  if (spell == SS_name) then\n    futurePower = futurePower - 15;\n  end\nend\n\nif (EDir == \"sun\") then\n  futurePower = futurePower + 20*SF_Flying + 15*SS_Flying;\n  if (spell == SF_name) then\n    futurePower = futurePower + 20;\n  end\n\n  if (spell == SS_name) then\n    futurePower = futurePower + 15;\n  end\nend\n\nif (EDir == \"moon\" and futurePower < -99) then\n  EDir = \"sun\";\nend\nif (EDir == \"sun\" and futurePower > 99) then\n  EDir = \"moon\";\nend\n\n\nif ( frame:GetStarsurgeCD() <= casttime and spell ~= SS_name ) then\n    return SS_icon\nend\n\nif ( EDir == \"sun\" ) then\n    return SF_icon\nelse\n    return W_icon\nend\n        \nend\n\n\nfunction getCastTime(icon)\n\n_, _, _, _, _, _, W_castTime = GetSpellInfo(5176); -- Zorn\n_, _, _, _, _, _, SF_castTime = GetSpellInfo(2912);  -- Sternenfeuer\n\nif (icon == SF_icon) then\n  return SF_castTime/1000;\nelse\n  return W_castTime/1000;\nend\n\nend\n\n\nfunction mynext(frame)\n\n\nlocal spell, _, _, _, startTime, endTime, _, castID, _ = UnitCastingInfo(\"player\");\n        local EDir, EPower = frame:GetEclipseDirection();\n\n\n\nlocal gcdstart, gcd = GetSpellCooldown(8921);\nlocal casttime = max(gcdstart+gcd-GetTime(),0);\n\nif (startTime) then\n  casttime = endTime/1000-GetTime();\nend\n\n\n\nlocal futurePower = EPower;\n\n\nif (EDir == \"moon\") then\n  futurePower = futurePower -16*W_Flying - 15*SS_Flying;\n  if (spell == W_name) then\n    futurePower = futurePower - 16;\n  end\n  if (spell == SS_name) then\n    futurePower = futurePower - 15;\n  end\nend\n\nif (EDir == \"sun\") then\n  futurePower = futurePower + 25*SF_Flying + 15*SS_Flying;\n  if (spell == SF_name) then\n    futurePower = futurePower + 25;\n  end\n\n  if (spell == SS_name) then\n    futurePower = futurePower + 15;\n  end\nend\n\n\n\nif (EDir == \"moon\" and futurePower < -99) then\n  EDir = \"sun\";\nend\nif (EDir == \"sun\" and futurePower > 99) then\n  EDir = \"moon\";\nend\n\n_, _, _, _, _, _, W_castTime = GetSpellInfo(5176); -- Zorn\n_, _, _, _, _, _, SF_castTime = GetSpellInfo(2912);  -- Sternenfeuer\n_, _, _, _, _, _, SS_castTime = GetSpellInfo(78674);  -- Sternensog\n\n\nlocal IS_CD = frame:GetInsectSwarmCD();\nlocal DOT_CD = max(frame:GetMoonfireCD(),frame:GetSunfireCD());\n\n--MoonTime:echo(DOT_CD)\n\nlocal nextcasttime = getCastTime(nodot_next(frame));\n\n\n\nif (IS_CD < 0 and (frame:isSolar() or frame:isLunar()) ) then\nreturn IS_icon\nend\n\nif (IS_CD>casttime and IS_CD < casttime+nextcasttime and (frame:isSolar() or frame:isLunar()) ) then\nreturn IS_icon\nend\n\nif (DOT_CD < 0 and (frame:isSolar() or frame:isLunar())) then\n  if (frame:isSolar()) then\n    return SunF_icon\n  else\n    return MF_icon\n  end\nend\n\nif (DOT_CD>casttime and DOT_CD < casttime+nextcasttime and (frame:isSolar() or frame:isLunar())) then\n  if (frame:isSolar()) then\n    return MF_icon\n  else\n    return MF_icon\n  end\nend\n\n\nreturn nodot_next(frame)\nend",
			["boxtextposi"] = 0,
		}
	end
end																		-- Ende initialize

registerLayout(NameOfLayout)
