-- MoonTimeConfig.lua
local version = 2;


local function MejBuildConfig(MoonTimeConfigPanel)

if ( GetLocale() == "deDE" ) then
	L = MoonTime_Mej_Strings["deDE"]
else
	L = MoonTime_Mej_Strings["enGB"]
end

-- Make a child panel
local MoonTime_Layout_Mej_ConfigPanel = CreateFrame( "ScrollFrame", "MyAddonChild", MoonTimeConfigPanel);
MoonTime_Layout_Mej_ConfigPanel:SetBackdropColor(1,0,1,1)
MoonTime_Layout_Mej_ConfigPanel:SetWidth(200)
MoonTime_Layout_Mej_ConfigPanel:SetHeight(200)



MoonTime_Layout_Mej_ConfigPanel.name = "Mej";
 -- Specify childness of this panel (this puts it under the little red [+], instead of giving it a normal AddOn category)
MoonTime_Layout_Mej_ConfigPanel.parent = MoonTimeConfigPanel.name;
 
local MoonTime_Layout_Mej_ScrollPanel = CreateFrame( "Frame", "MyAddonScrollChild", MoonTimeConfigPanel);

MoonTime_Layout_Mej_ScrollPanel:SetHeight(500)
MoonTime_Layout_Mej_ScrollPanel:SetWidth(100)
 
MoonTime_Layout_Mej_ConfigPanel:SetScrollChild(MoonTime_Layout_Mej_ScrollPanel)
 -- Add the child to the Interface Options
InterfaceOptions_AddCategory(MoonTime_Layout_Mej_ConfigPanel);

 
 
local textbox = MoonTime:CreateFontString(MoonTime_Layout_Mej_ConfigPanel, "textbox", "ARTWORK", "GameFontNormalLarge", "TOPLEFT", MoonTime_Layout_Mej_ConfigPanel, "TOPLEFT", 10, -10, 200, 20, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox:SetText("|cffFFFF00".."Layout Mej".."|r")
	textbox:Show()	
local textbox = MoonTime:CreateFontString(MoonTime_Layout_Mej_ConfigPanel, "textbox", "ARTWORK", "GameFontNormal", "TOPLEFT", textbox, "BOTTOMLEFT", 0, 0, 500, 100, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox:SetText(L["description"])
	textbox:SetHeight(textbox:GetStringHeight())
	textbox:Show()	
 
 
local textbox = MoonTime:CreateFontString(MoonTime_Layout_Mej_ConfigPanel, "textbox", "ARTWORK", "GameFontNormal", "TOPLEFT", textbox, "BOTTOMLEFT", 0, -10, 500, 20, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox:SetText("Rotation:")
	textbox:Show()	
	

local editframe = CreateFrame("EditBox", "MoonTimeEditBox", MoonTime_Layout_Mej_ConfigPanel, "InputBoxTemplate")
	editframe:SetPoint("TOPLEFT", textbox, "BOTTOMLEFT", 0, 0)
	editframe:SetWidth(400)
	editframe:SetHeight(100)
	editframe:SetText("text")
	editframe:SetMultiLine()
	editframe:SetAutoFocus(false) 
	editframe:Hide() 
	editframe:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
		tile = true, tileSize = 16, edgeSize = 16, 
		insets = { left = 4, right = 4, top = 4, bottom = 4 }});

		
local aussen = CreateFrame("Frame","Aussenframe", MoonTime_Layout_Mej_ConfigPanel)
	aussen:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border",tile = true, tileSize = 16, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } });
	aussen:SetBackdropColor(0,0,0.2)
	aussen:SetPoint("TOPLEFT", textbox, "BOTTOMLEFT", 0, -10)
	aussen:SetSize(580,300)
	aussen:Show();

local MoonTime_Layout_Mej_ScrollFrame = CreateFrame("ScrollFrame", "MoonTime_Layout_Mej_ScrollFramereviewFrame", MoonTime_Layout_Mej_ConfigPanel, "UIPanelScrollFrameTemplate")
	MoonTime_Layout_Mej_ScrollFrame:SetPoint("TOPLEFT", aussen, "TOPLEFT", 10, -10)
	MoonTime_Layout_Mej_ScrollFrame.name = "Scrollframe";
 
local MoonTime_Layout_Mej_ScrollFrameScrollChild = CreateFrame("Frame", "MoonTime_Layout_Mej_ScrollFramereviewSC", MoonTime_Layout_Mej_ScrollFrame)
 
 
local PADDING = 5
local height = 280
local width = 538
 

 
local labelframe = CreateFrame("EditBox", "TestEditBox", MoonTime_Layout_Mej_ScrollFrame)
 
 labelframe:SetFont("Fonts\\ARIALN.TTF",14,"none")
 labelframe:SetPoint("TOPLEFT", MoonTime_Layout_Mej_ScrollFrame, "TOPLEFT", 0, 0)
	
 labelframe:SetWidth(width)
	
 labelframe:SetJustifyH("LEFT")
 labelframe:SetJustifyV("TOP")
 labelframe:SetTextColor( 1, 1, 1, 1 );
 labelframe:SetMultiLine()
 labelframe:SetText(MoonTime_DB["Layout_Mej"]["boxtext"])
 labelframe:SetAutoFocus(false)
 labelframe.h = 0;
 labelframe:SetScript("OnTextChanged",
	function (self)
	
		local x,y = labelframe:GetSize()

		if labelframe.h ~= MoonTime_Layout_Mej_ScrollFrame:GetVerticalScrollRange() then
			MoonTime_Layout_Mej_ScrollFrame:SetVerticalScroll(MoonTime_Layout_Mej_ScrollFrame:GetVerticalScroll() + MoonTime_Layout_Mej_ScrollFrame:GetVerticalScrollRange()-labelframe.h) 
			
			if MoonTime_Layout_Mej_ScrollFrame:GetVerticalScroll()<0 then
				MoonTime_Layout_Mej_ScrollFrame:SetVerticalScroll(0);
			end
			
			if labelframe.h == 0 then
				MoonTime_Layout_Mej_ScrollFrame:SetVerticalScroll(MoonTime_DB["Layout_Mej"]["boxtextposi"]);
			end

			labelframe.h = MoonTime_Layout_Mej_ScrollFrame:GetVerticalScrollRange();
		end

	end
)


-- Set the size of the scroll child
MoonTime_Layout_Mej_ScrollFrameScrollChild:SetSize(width, height)
 
-- Size and place the parent frame, and set the scrollchild to be the
-- frame of font strings we've created
MoonTime_Layout_Mej_ScrollFrame:SetSize(width, height)
MoonTime_Layout_Mej_ScrollFrame:SetScrollChild(labelframe)


MoonTime_Layout_Mej_ScrollFrameScrollChild:SetSize(width, height)

		MoonTime_Layout_Mej_ConfigPanel:SetScript("OnShow",
			function(self)
				labelframe:SetText(MoonTime_DB["Layout_Mej"]["boxtext"]);
			end
		)
		
MoonTime_Layout_Mej_ConfigPanel.okay = function()
	if ( MoonTime_Layout_Mej_ConfigPanel:IsShown() ) then
		MoonTime_DB["Layout_Mej"]["boxtext"]  = labelframe:GetText();
		MoonTime_DB["Layout_Mej"]["boxtextposi"] = MoonTime_Layout_Mej_ScrollFrame:GetVerticalScroll();

	
		MoonTime:setLayout(MoonTime_DB["layout"])
	end	
end
	
MoonTime_Layout_Mej_ConfigPanel:Hide()
return MoonTime_Layout_Mej_ConfigPanel

end


-- ****************************************
--
-- DO NOT CHANGE ANYTHING BELOW THIS 
--
-- ****************************************

local function registerConfig( )									-- Beginn initialize
	local configFrame
	local frame = CreateFrame( "Frame", "frame", UIPARENT	)
	frame:RegisterEvent("VARIABLES_LOADED");
	frame:SetScript("OnEvent", 
		function( self, event )
			if event=="VARIABLES_LOADED" then							-- falls das ausloesende Event VARIABLES_LOADED ist ...
																		-- werden die ausstehenden Events registriert
				if ( not MoonTime_DB["Layout_Mej"] or MoonTime_DB["Layout_Mej"]["version"] < version ) then
					frame:UpdateDB()
				end
				
				MoonTimeDoorKeeper:RegisterConfig( self );
			end
		end
	)
	
	frame.createConfig = function( MainConfigFrame )
		configFrame = MejBuildConfig( MainConfigFrame )
	end

	frame.UpdateDB = function()
		MoonTime_DB["Layout_Mej"] = {
			["version"] = version,
			["boxtext"] = "function nodot_next(frame)\n\n\nlocal spell, _, _, _, startTime, endTime, _, castID, _ = UnitCastingInfo(\"player\");\nlocal EDir, EPower = frame:GetEclipseDirection();\n\nlocal futurePower = EPower;\n\nlocal gcdstart, gcd = GetSpellCooldown(8921);\nlocal casttime = max(gcdstart+gcd-GetTime(),0);\n\nif (startTime) then\n  casttime = endTime/1000-GetTime();\nend\n\n\nif (EDir == \"moon\") then\n  futurePower = futurePower -13*W_Flying - 15*SS_Flying;\n  if (spell == W_name) then\n    futurePower = futurePower - 13;\n  end\n  if (spell == SS_name) then\n    futurePower = futurePower - 15;\n  end\nend\n\nif (EDir == \"sun\") then\n  futurePower = futurePower + 20*SF_Flying + 15*SS_Flying;\n  if (spell == SF_name) then\n    futurePower = futurePower + 20;\n  end\n\n  if (spell == SS_name) then\n    futurePower = futurePower + 15;\n  end\nend\n\nif (EDir == \"moon\" and futurePower < -99) then\n  EDir = \"sun\";\nend\nif (EDir == \"sun\" and futurePower > 99) then\n  EDir = \"moon\";\nend\n\n\nif ( frame:GetStarsurgeCD() <= casttime and spell ~= SS_name ) then\n    return SS_icon\nend\n\nif ( EDir == \"sun\" ) then\n    return SF_icon\nelse\n    return W_icon\nend\n        \nend\n\n\nfunction getCastTime(icon)\n\n_, _, _, _, _, _, W_castTime = GetSpellInfo(5176); -- Zorn\n_, _, _, _, _, _, SF_castTime = GetSpellInfo(2912);  -- Sternenfeuer\n\nif (icon == SF_icon) then\n  return SF_castTime/1000;\nelse\n  return W_castTime/1000;\nend\n\nend\n\n\nfunction mynext(frame)\n\n\nlocal spell, _, _, _, startTime, endTime, _, castID, _ = UnitCastingInfo(\"player\");\n        local EDir, EPower = frame:GetEclipseDirection();\n\n\n\nlocal gcdstart, gcd = GetSpellCooldown(8921);\nlocal casttime = max(gcdstart+gcd-GetTime(),0);\n\nif (startTime) then\n  casttime = endTime/1000-GetTime();\nend\n\n\n\nlocal futurePower = EPower;\n\n\nif (EDir == \"moon\") then\n  futurePower = futurePower -16*W_Flying - 15*SS_Flying;\n  if (spell == W_name) then\n    futurePower = futurePower - 16;\n  end\n  if (spell == SS_name) then\n    futurePower = futurePower - 15;\n  end\nend\n\nif (EDir == \"sun\") then\n  futurePower = futurePower + 25*SF_Flying + 15*SS_Flying;\n  if (spell == SF_name) then\n    futurePower = futurePower + 25;\n  end\n\n  if (spell == SS_name) then\n    futurePower = futurePower + 15;\n  end\nend\n\n\n\nif (EDir == \"moon\" and futurePower < -99) then\n  EDir = \"sun\";\nend\nif (EDir == \"sun\" and futurePower > 99) then\n  EDir = \"moon\";\nend\n\n_, _, _, _, _, _, W_castTime = GetSpellInfo(5176); -- Zorn\n_, _, _, _, _, _, SF_castTime = GetSpellInfo(2912);  -- Sternenfeuer\n_, _, _, _, _, _, SS_castTime = GetSpellInfo(78674);  -- Sternensog\n\n\nlocal IS_CD = frame:GetInsectSwarmCD();\nlocal DOT_CD = max(frame:GetMoonfireCD(),frame:GetSunfireCD());\n\n--MoonTime:echo(DOT_CD)\n\nlocal nextcasttime = getCastTime(nodot_next(frame));\n\n\n\nif (IS_CD < 0 and (frame:isSolar() or frame:isLunar()) ) then\nreturn IS_icon\nend\n\nif (IS_CD>casttime and IS_CD < casttime+nextcasttime and (frame:isSolar() or frame:isLunar()) ) then\nreturn IS_icon\nend\n\nif (DOT_CD < 0 and (frame:isSolar() or frame:isLunar())) then\n  if (frame:isSolar()) then\n    return SunF_icon\n  else\n    return MF_icon\n  end\nend\n\nif (DOT_CD>casttime and DOT_CD < casttime+nextcasttime and (frame:isSolar() or frame:isLunar())) then\n  if (frame:isSolar()) then\n    return MF_icon\n  else\n    return MF_icon\n  end\nend\n\n\nreturn nodot_next(frame)\nend",
			["boxtextposi"] = 0,
		}
	end
	
end																		-- Ende initialize





registerConfig(NameOfLayout)

