-- defaultLayout.lua
local NameOfLayout = "default"
local Description;
local layerFrame


local function Layout(mainFrame, cds)
	-- Update()
	-- CreateCastFrame( spellTexture, RTframe, height, width, relwhich, relto )
	-- createLayout()
	-- deleteLayout()

	--local MoonTimeNextCastframe
	local MoonTimeEclipseframe
	local MoonTimeMoonfireframe
	local MoonTimeInsectswarmframe
	local MoonTimeStarrainframe
	local MoonTimeTreantsframe

	local layerFrame = CreateFrame("Frame", "layerFrame", mainFrame )
	layerFrame:SetHeight( mainFrame:GetHeight() )
	layerFrame:SetWidth( mainFrame:GetWidth() )
	layerFrame:SetPoint("CENTER")
	layerFrame:Hide()
	
	layerFrame.Update = function()

		local EDir, Epower = cds:GetEclipseDirection()
		local DoT = max(cds:GetMoonfireCD(),cds:GetSunfireCD())
		local IS = cds:GetInsectSwarmCD()
		local SR_cd = cds:GetStarrainCD()
		local Treants_cd = cds:GetTreantsCD()

		--MoonTimeNextCastframe:SetIcon(cds:Next())
		

		if( EDir == "sun" ) then 
			MoonTimeEclipseframe:SetIcon( Lunar_icon )
			local color = "ffff00"
			local bool = false
			if ( Epower < 0 ) then 
				color = "0088ff" 
				Epower = -1 * Epower
				bool = true
			end
			MoonTimeEclipseframe:SetText( "|cff"..color..Epower.."|r", bool);
		end

		if( EDir == "moon" ) then 
			MoonTimeEclipseframe:SetIcon( Solar_icon )		
			local color = "ffff00"
			local bool = true
			if ( Epower < 0 ) then 
				color = "0088ff" 
				Epower = -1 * Epower
				bool = false
			end
			MoonTimeEclipseframe:SetText( "|cff"..color..Epower.."|r", bool);
		end
		
		if cds:isSolar() then
			MoonTimeMoonfireframe:SetIcon(SunF_icon)
		else
			MoonTimeMoonfireframe:SetIcon(MF_icon)
		end
		if DoT>=0 then
			MoonTimeMoonfireframe:SetText( string.format("%2.1f", (DoT) ) )
		else
			MoonTimeMoonfireframe:SetText( '' )
		end
		
		if IS>=0 then
			MoonTimeInsectswarmframe:SetText( string.format("%2.1f", (IS) ) )
		else
			MoonTimeInsectswarmframe:SetText( '' )
		end

		if SR_cd>1.5 then
			MoonTimeStarrainframe:SetText( '|cfff6ffff' .. math.ceil(SR_cd) .. '|r' )
		else
			MoonTimeStarrainframe:SetText( '' )
		end
		if Treants_cd > 99 then
			MoonTimeTreantsframe:SetText( '|cfff6ffff' .. math.ceil(Treants_cd/60) .. 'm|r' )
		elseif Treants_cd > 1.5 then
			MoonTimeTreantsframe:SetText( '|cfff6ffff' .. math.ceil(Treants_cd) .. '|r' )
		else
			MoonTimeTreantsframe:SetText( '' )
		end

	end

	layerFrame.CreateCastFrame = function( spellTexture, RTframe, height, width, relwhich, relto )
		local frame = CreateFrame( "Frame", "MTCastframe"..RTframe:GetName(), layerFrame )
		frame:SetBackdrop({
			bgFile = spellTexture,
			tile = false, tileSize = height, edgeSize = 0,
			insets = { left = 0, right = 0, top = 0, bottom = 0 }
		})
		frame:SetHeight(height)
		frame:SetWidth(width)
		frame:SetPoint(relwhich, RTframe, relto, 0, 0)

		local labelframe = frame:CreateFontString(nil,"ARTWORK","GameFontNormal")
		labelframe:SetPoint("TOPLEFT", frame, "TOPLEFT")
		labelframe:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT")
		labelframe:SetTextColor( 1, 1, 0, 1 );
		frame.SetText = function( self, msg )
			if( msg == '' ) then
				frame:SetBackdropColor(1,1,1,1)		
			else
				frame:SetBackdropColor(.3,.3,.3,.5)	
			end
			labelframe:SetText(msg)
		end
		frame.SetIcon = function( self, icon )
			frame:SetBackdrop({bgFile = icon})
		end
		
		return frame
	end

	layerFrame.createLayout = function ()
		mainFrame:SetHeight(96)
		mainFrame:SetWidth(64)
		local castwidth = 32
		local castheight = 16

		--MoonTimeNextCastframe = layerFrame.CreateCastFrame( "", layerFrame, 32, 32, "TOP", "TOP")
		MoonTimeEclipseframe = layerFrame.CreateCastFrame( SF_icon, mainFrame, castheight, castwidth, "TOP", "CENTER")
		MoonTimeMoonfireframe = layerFrame.CreateCastFrame( MF_icon, MoonTimeEclipseframe, castheight, castwidth, "TOP", "BOTTOM")
		MoonTimeInsectswarmframe = layerFrame.CreateCastFrame( IS_icon, MoonTimeMoonfireframe, castheight, castwidth, "TOP", "BOTTOM")
		MoonTimeStarrainframe = layerFrame.CreateCastFrame( SR_icon, MoonTimeInsectswarmframe, castheight, castwidth, "TOP", "BOTTOM")
		MoonTimeTreantsframe = layerFrame.CreateCastFrame( Treants_icon, MoonTimeStarrainframe, castheight, castwidth, "TOP", "BOTTOM")

	end
	

	layerFrame.deleteLayout = function()
		MoonTimeEclipseframe:Hide()
		MoonTimeEclipseframe = nil
		MoonTimeMoonfireframe:Hide()
		MoonTimeMoonfireframe = nil
		MoonTimeInsectswarmframe:Hide()
		MoonTimeInsectswarmframe = nil
		MoonTimeStarrainframe:Hide()
		MoonTimeStarrainframe = nil
		MoonTimeTreantsframe:Hide()
		MoonTimeTreantsframe = nil
		
		layerFrame:Hide()
		layerFrame = nil
	end

	return layerFrame
end

-- ****************************************
--
-- DO NOT CHANGE ANYTHING BELOW THIS 
--
-- ****************************************

local function registerLayout( name )									-- Beginn initialize
	local LayoutFrame
	local frame = CreateFrame( "Frame", name, UIPARENT	)
	frame.ID = name
	frame:RegisterEvent("VARIABLES_LOADED");
	frame:SetScript("OnEvent", 
		function( self, event )
			if event=="VARIABLES_LOADED" then							-- falls das ausloesende Event VARIABLES_LOADED ist ...
																		-- werden die ausstehenden Events registriert
				if ( GetLocale() == "deDE" ) then
					frame.description = MoonTime_Strings["deDE"]["description"]
				else
					frame.description = MoonTime_Strings["enGB"]["description"]
				end
				
				MoonTimeDoorKeeper:RegisterLayout(self);
			end
		end
	)
	
	frame.createLayout = function( self ) 
		LayoutFrame = Layout(self.Mainframe, self.Objectframe)
		LayoutFrame:createLayout()
	end

	frame.Hide = function()
		LayoutFrame:Hide()
	end
	frame.Show = function()
		LayoutFrame:Show()
	end
	frame.Update = function()
		LayoutFrame:Update()
	end

	frame.deleteLayout = function()
		LayoutFrame:deleteLayout()
	end
end																		-- Ende initialize

registerLayout(NameOfLayout)