-- MoonTimeMain.lua

-- Variablen
local NameOfProject = "MoonTime"										-- Name des Projekts
local version = "153"														-- Versionsangabe
local EventFrame														-- Frame, das auf Events reagiert
local TimeSinceLastUpdate = 0.0
local UpdateFrequency = 1/25;
local Layout
local MoonTimeObject													-- dummy fuer die Objects
local MoonTimeMainframe 												-- dummy fuer das Hauptframe
local _, playerclass = UnitClass("player");

MoonTime = {}
MoonTimeDoorKeeper = {}

local ConfigLayoutList


MoonTime_DB = {															-- default Konfiguration,
																		-- wird whrend des Variabelnladens
																		-- ueberschrieben

};


MoonTime_Layout_Liste = {}										-- enthaelt moegliche Layouts

local debugging = false


MF_id = 8921; -- Mondfeuer
SunF_id = 93402; -- Sonnenfeuer
IS_id = 5570; -- Insektenschwarm
W_id = 5176; -- Zorn
SF_id = 2912; -- Sternenfeuer
SS_id = 78674; -- Sternensog
Lunar_id = 48518; -- Lunar
Solar_id = 48517; -- Solar
SR_id = 48505; -- Sternenregen
Treants_id = 33831; -- Treants
WP_id = 88747; -- Wildpilz
FF_id = 770; -- Feenfeuer


MF_name, MF_rank, MF_icon, MF_cost, MF_isFunnel, MF_powerType, MF_castTime, MF_minRange, MF_maxRange = GetSpellInfo(MF_id); -- Mondfeuer
SunF_name, SunF_rank, SunF_icon, SunF_cost, SunF_isFunnel, SunF_powerType, SunF_castTime, SunF_minRange, SunF_maxRange = GetSpellInfo(SunF_id); -- Sonnenfeuer
IS_name, IS_rank, IS_icon, IS_cost, IS_isFunnel, IS_powerType, IS_castTime, IS_minRange, IS_maxRange = GetSpellInfo(IS_id); -- Insektenschwarm
W_name, W_rank, W_icon, W_cost, W_isFunnel, W_powerType, W_castTime, W_minRange, W_maxRange = GetSpellInfo(W_id); -- Zorn
SF_name, SF_rank, SF_icon, SF_cost, SF_isFunnel, SF_powerType, SF_castTime, SF_minRange, SF_maxRange = GetSpellInfo(SF_id); -- Sternenfeuer
SS_name, SS_rank, SS_icon, SS_cost, SS_isFunnel, SS_powerType, SS_castTime, SS_minRange, SS_maxRange = GetSpellInfo(SS_id); -- Sternensog
Lunar_name, Lunar_rank, Lunar_icon, Lunar_cost, Lunar_isFunnel, Lunar_powerType, Lunar_castTime, Lunar_minRange, Lunar_maxRange = GetSpellInfo(Lunar_id); -- Lunar
Solar_name, Solar_rank, Solar_icon, Solar_cost, Solar_isFunnel, Solar_powerType, Solar_castTime, Solar_minRange, Solar_maxRange = GetSpellInfo(Solar_id); -- Solar
SR_name, SR_rank, SR_icon, SR_cost, SR_isFunnel, SR_powerType, SR_castTime, SR_minRange, SR_maxRange = GetSpellInfo(SR_id); -- Sternenregen
Treants_name, Treants_rank, Treants_icon, Treants_cost, Treants_isFunnel, Treants_powerType, Treants_castTime, Treants_minRange, Treants_maxRange = GetSpellInfo(Treants_id); -- Treants
WP_name, WP_rank, WP_icon, WP_cost, WP_isFunnel, WP_powerType, WP_castTime, WP_minRange, WP_maxRange = GetSpellInfo(WP_id); -- Wildpilz
FF_name, FF_rank, FF_icon, FF_cost, FF_isFunnel, FF_powerType, FF_castTime, FF_minRange, FF_maxRange = GetSpellInfo(FF_id); -- Feenfeuer




function MoonTime.debug ( self, msg )							-- Beginn debug
	if debugging then 													-- falls debugging aktiv ist
		DEFAULT_CHAT_FRAME:AddMessage("|cff00FFFF"..NameOfProject.."(debug):|r "..msg)		
																		-- Einfache Routine zur Ausgabe von Informationen
	end
end																		-- Ende debug

function MoonTime.echo( self, msg )												-- Beginn echo
																		-- Einfache Routine zur Ausgabe von Nachrichten
	if not msg then
		msg = "Error: nil"
	end
	DEFAULT_CHAT_FRAME:AddMessage("|cff00FFFF"..NameOfProject..":|r "..msg)

end	

																-- Ende echo

																
																
function MoonTime.help( self )															-- Beginn help
	--InterfaceOptionsFrame_OpenToCategory("noBrainShift")
	InterfaceOptionsFrame_OpenToCategory("MoonTime")
--	MoonTime:echo("Version "..version.."")
--	MoonTime:echo("|cffFFFF00/moontime move|r makes the frame moveable")
--	MoonTime:echo("|cffFFFF00/moontime setlayout <name>|r sets the layout and the trashlayout")
--	MoonTime:echo("|cffFFFF00/moontime settrashlayout name|r sets the trashlayout")
--	MoonTime:echo("|cffFFFF00/moontime list|r gives a list of all layouts available")
--	MoonTime:echo("|cffFFFF00/moontime 4t11|r toggles between normal and 4-piece tier 11 rotation")
--	MoonTime:echo("|cffFFFF00/moontime toggletrash|r toggles visibility while fighting non elite mobs ")
--	MoonTime:echo("|cffFFFF00/moontime settrashhp <raidsize> <value>|r sets the mark for each raidsize (5,10,25) from where a mob is treated as a boss")
end			

function MoonTime.list( self )										-- lists the layouts
	MoonTime:echo ("Available layouts:")
	for index, value in pairs(MoonTime_Layout_Liste) do
		MoonTime:echo(index)
	end	
end	



function MoonTime.canuse( self)
	local name = GetSpellInfo(24858)
	local moonkin = UnitBuff("player", name) 
	
	if moonkin and UnitLevel("player")>=85 then
		return true
	else
		return false
	end
end



function MoonTime.registerMoonTimeLayout( self, frame )
	-- Die Moeglichkeit fr Layouts, sich einzutragen
	local _, playerclass = UnitClass("player");
	if playerclass == "DRUID" and frame.ID then
		MoonTime_Layout_Liste[frame.ID] = frame;
		frame.Mainframe = MoonTimeMainframe
		frame.Objectframe = MoonTimeObject
		MoonTime:debug("Layout \""..frame.ID.."\" has been registered.")
		MoonTime:CreateMoonTimeLayoutNow(frame.ID);

	end
end

function MoonTime.setLayout( self, layoutName )
	local oldLayout = MoonTime_DB["layout"]								-- altes Layout wird behalten wegen Loeschen
	if MoonTime_Layout_Liste[layoutName] then							-- falls es das Layout gibt
		MoonTime_DB["layout"] = layoutName
		MoonTimeMainframe:SetScript("OnUpdate", nil);					-- Update wird unterbunden waehrend des Wechsels
			if MoonTime_Layout_Liste[oldLayout] then						-- altes Layout loeschen, falls existent
				MoonTime_Layout_Liste[oldLayout]:deleteLayout()
			end
		MoonTime:CreateMoonTimeLayout(MoonTime_DB["layout"])						-- neues Layout erstellen
		
		if MoonTime:canuse() and UnitCanAttack("player","target") and not ( UnitIsDead("target") or UnitIsCorpse("target") or UnitInVehicle("player") ) then
			MoonTime_Layout_Liste[MoonTime_DB["layout"]]:Show()
			MoonTimeMainframe:Show();
		end

		
		MoonTime:debug( "Layout \"" .. layoutName .. "\" is set");
	else
		MoonTime:debug( "Layout \"" .. layoutName .. "\" is not known. Type |cffFFFF00/moontime list|r to get all available layouts");
	end
end



function MoonTime.CreateMoonTimeLayoutNow( self, name )
	if ( name == MoonTime_DB["layout"] ) then
		MoonTime:CreateMoonTimeLayout(MoonTime_DB["layout"])								-- Layout wird erstellt
	end
end

function MoonTime.OnEvent( self, event, name, ...)										-- Beginn OnEvent
	if event=="VARIABLES_LOADED" then									-- falls das ausloesende Event VARIABLES_LOADED ist ...
																		-- werden die ausstehenden Events registriert
																		
																		
		if ( not MoonTime_DB["version"] or MoonTime_DB["version"] < version ) then
			MoonTime:UpdateDB()
		end
		-- DB wird gebaut, falls es ne neue version gibt, muss noch rein
		-- 
																		
		MoonTimeObject = MoonTimeLayoutObj()
		--MoonTime:echo("mich gibts jetzt")
		ConfigLayoutList = MoonTimeBuildConfig()
		ConfigLayoutList.mainFrame = MoonTimeMainframe;
		
		
		--MoonTime:help()
		--MoonTime:echo("Config im Autostart")

																		
		EventFrame:RegisterEvent("PLAYER_REGEN_DISABLED");				-- Spieler beginnt Kampf
		EventFrame:RegisterEvent("PLAYER_REGEN_ENABLED");				-- Spieler verlaesst Kampf
		EventFrame:RegisterEvent("PLAYER_TARGET_CHANGED");
		EventFrame:RegisterEvent("UNIT_COMBAT");
		EventFrame:RegisterEvent("UNIT_TARGET");
																		-- MoonTimeMainframe wird positioniert
		MoonTimeMainframe:SetPoint(MoonTime_DB["position"]["point"], nil, MoonTime_DB["position"]["relativePoint"], MoonTime_DB["position"]["offsetX"], MoonTime_DB["position"]["offsetY"])
		

		
	elseif event=="PLAYER_TARGET_CHANGED" or event=="PLAYER_REGEN_DISABLED" or event=="UNIT_COMBAT" or event=="UNIT_TARGET" then	


		if MoonTime:canuse() and UnitCanAttack("player","target") and not ( UnitIsDead("target") or UnitIsCorpse("target") or UnitInVehicle("player") ) then
			
			EventFrame:UnregisterEvent("UNIT_COMBAT");
			EventFrame:UnregisterEvent("UNIT_TARGET");

			MoonTime_Layout_Liste[MoonTime_DB["layout"]]:Show()
			MoonTimeMainframe:Show();
		else
			MoonTime_Layout_Liste[MoonTime_DB["layout"]]:Hide()
			if not EventFrame:IsEventRegistered("UNIT_TARGET") then
				EventFrame:RegisterEvent("UNIT_COMBAT");
				EventFrame:RegisterEvent("UNIT_TARGET");
			end
		
			MoonTimeMainframe:Hide();
			W_Flying = 0;
			SF_Flying = 0;
			SS_Flying = 0;
		end		
	end
end																		-- Ende OnEvent


function MoonTime.UpdateDB ()
MoonTime_DB = {
	["version"] = version,
	["position"] = {	
		["point"] = "CENTER",
		["relativeTo"] = UIPARENT,
		["relativePoint"] = "CENTER",
		["offsetX"] = 0,
		["offsetY"] = 0,
	},
	["layout"] = "default",
	["enabled"] = true,
	
	["boxtext"] = "function nodot_next(frame)\n\n\nlocal spell, _, _, _, startTime, endTime, _, castID, _ = UnitCastingInfo(\"player\");\nlocal EDir, EPower = frame:GetEclipseDirection();\n\nlocal futurePower = EPower;\n\nlocal gcdstart, gcd = GetSpellCooldown(8921);\nlocal casttime = max(gcdstart+gcd-GetTime(),0);\n\nif (startTime) then\n  casttime = endTime/1000-GetTime();\nend\n\n\nif (EDir == \"moon\") then\n  futurePower = futurePower -13*W_Flying - 15*SS_Flying;\n  if (spell == W_name) then\n    futurePower = futurePower - 13;\n  end\n  if (spell == SS_name) then\n    futurePower = futurePower - 15;\n  end\nend\n\nif (EDir == \"sun\") then\n  futurePower = futurePower + 20*SF_Flying + 15*SS_Flying;\n  if (spell == SF_name) then\n    futurePower = futurePower + 20;\n  end\n\n  if (spell == SS_name) then\n    futurePower = futurePower + 15;\n  end\nend\n\nif (EDir == \"moon\" and futurePower < -99) then\n  EDir = \"sun\";\nend\nif (EDir == \"sun\" and futurePower > 99) then\n  EDir = \"moon\";\nend\n\n\nif ( frame:GetStarsurgeCD() <= casttime and spell ~= SS_name ) then\n    return SS_icon\nend\n\nif ( EDir == \"sun\" ) then\n    return SF_icon\nelse\n    return W_icon\nend\n        \nend\n\n\nfunction getCastTime(icon)\n\n_, _, _, _, _, _, W_castTime = GetSpellInfo(5176); -- Zorn\n_, _, _, _, _, _, SF_castTime = GetSpellInfo(2912);  -- Sternenfeuer\n\nif (icon == SF_icon) then\n  return SF_castTime/1000;\nelse\n  return W_castTime/1000;\nend\n\nend\n\n\nfunction mynext(frame)\n\n\nlocal spell, _, _, _, startTime, endTime, _, castID, _ = UnitCastingInfo(\"player\");\n        local EDir, EPower = frame:GetEclipseDirection();\n\n\n\nlocal gcdstart, gcd = GetSpellCooldown(8921);\nlocal casttime = max(gcdstart+gcd-GetTime(),0);\n\nif (startTime) then\n  casttime = endTime/1000-GetTime();\nend\n\n\n\nlocal futurePower = EPower;\n\n\nif (EDir == \"moon\") then\n  futurePower = futurePower -16*W_Flying - 15*SS_Flying;\n  if (spell == W_name) then\n    futurePower = futurePower - 16;\n  end\n  if (spell == SS_name) then\n    futurePower = futurePower - 15;\n  end\nend\n\nif (EDir == \"sun\") then\n  futurePower = futurePower + 25*SF_Flying + 15*SS_Flying;\n  if (spell == SF_name) then\n    futurePower = futurePower + 25;\n  end\n\n  if (spell == SS_name) then\n    futurePower = futurePower + 15;\n  end\nend\n\n\n\nif (EDir == \"moon\" and futurePower < -99) then\n  EDir = \"sun\";\nend\nif (EDir == \"sun\" and futurePower > 99) then\n  EDir = \"moon\";\nend\n\n_, _, _, _, _, _, W_castTime = GetSpellInfo(5176); -- Zorn\n_, _, _, _, _, _, SF_castTime = GetSpellInfo(2912);  -- Sternenfeuer\n_, _, _, _, _, _, SS_castTime = GetSpellInfo(78674);  -- Sternensog\n\n\nlocal IS_CD = frame:GetInsectSwarmCD();\nlocal DOT_CD = max(frame:GetMoonfireCD(),frame:GetSunfireCD());\n\n--MoonTime:echo(DOT_CD)\n\nlocal nextcasttime = getCastTime(nodot_next(frame));\n\n\n\nif (IS_CD < 0 and (frame:isSolar() or frame:isLunar()) ) then\nreturn IS_icon\nend\n\nif (IS_CD>casttime and IS_CD < casttime+nextcasttime and (frame:isSolar() or frame:isLunar()) ) then\nreturn IS_icon\nend\n\nif (DOT_CD < 0 and (frame:isSolar() or frame:isLunar())) then\n  if (frame:isSolar()) then\n    return SunF_icon\n  else\n    return MF_icon\n  end\nend\n\nif (DOT_CD>casttime and DOT_CD < casttime+nextcasttime and (frame:isSolar() or frame:isLunar())) then\n  if (frame:isSolar()) then\n    return MF_icon\n  else\n    return MF_icon\n  end\nend\n\n\nreturn nodot_next(frame)\nend",
	["boxtextposi"] = 0,
	["blink_factor"] = 8,
	["blinkspells"] = {
		["default"] = true,
	}
};

end



function MoonTime.enable()														-- Beginn enable
end																		-- Ende enable

function MoonTime.disable()														-- Beginn enable
end																		-- Ende enable

function MoonTime.move( self )															-- Beginn config
	MoonTimeMainframe:SetBackdropColor(1,0,0,1)
	MoonTimeMainframe:SetMovable(true)
	MoonTimeMainframe:EnableMouse(true)
	MoonTimeMainframe.isLocked = false
	MoonTimeMainframe:Show()
end																		-- Ende config

function MoonTime.setPosition( self )															-- Beginn config
	MoonTimeMainframe:SetMovable(false)
	MoonTimeMainframe:EnableMouse(false)
	MoonTimeMainframe.isLocked = true
	
	MoonTimeMainframe:ClearAllPoints()
	MoonTimeMainframe:SetPoint(MoonTime_DB["position"]["point"], UIPARRENT, MoonTime_DB["position"]["relativePoint"], MoonTime_DB["position"]["offsetX"], MoonTime_DB["position"]["offsetY"])
end	


function MoonTime.toggle(self, msg)													-- Beginn toggle
	origMsg = msg
	msg = strtrim( msg )												-- entferne ueberfluessige whitespaces
	msg = msg:lower()													-- in Kleinbuchstaben verwandeln
	if( msg == "help" ) then MoonTime:help()										-- rufe help auf
	elseif( msg == "move" ) then MoonTime:move()									-- rufe move auf
								-- rufe enable auf
	elseif( msg == "reset" ) then MoonTime_DB=""; ReloadUI()
	else
		MoonTime:help()
	end
end																		-- Ende toggle

function MoonTime.OnUpdate(self, elapsed)										-- Beginn OnUpdate
	TimeSinceLastUpdate = TimeSinceLastUpdate + elapsed; 	

  while (TimeSinceLastUpdate > UpdateFrequency) do
		-- wie bei create wird dies umgeschrieben, dass die jeweils zutreffende Function angesprochen wird
		--MoonTime_Layout_Liste[MoonTime_DB["layout"]]:Update()
		--echo (MoonTime_Layout_Liste[MoonTime_DB["layout"]].ID)
		MoonTime_Layout_Liste[MoonTime_DB["layout"]]:Update()
    TimeSinceLastUpdate = TimeSinceLastUpdate - UpdateFrequency;
  end

end																		-- Ende OnUpdate
function MoonTime.CreateMainFrame ( self )					
	
	local frame = CreateFrame( "Frame", "MTMainframe", UIPARENT )
	frame:SetMovable(false)
	frame:EnableMouse(false)
	frame:SetClampedToScreen(true)
	frame:SetBackdrop({
		bgFile = "",
		tile = true, tileSize = height, edgeSize = 10,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
	})
	frame.isLocked = true
	frame:SetScript("OnMouseDown", 
			function(self, button)
				if ( ( ( not self.isLocked ) or ( self.isLocked == 0 ) ) and ( button == "LeftButton" ) ) then
					self:StartMoving();
					self.isMoving = true;
				end
			end
		)
	frame:SetScript("OnMouseUp", 
			function(self)
				if ( self.isMoving ) then
					self:StopMovingOrSizing();
					self.isMoving = false;
					
																				-- falls die Position gespeichert werden soll
	p,_,pt,x,y = MoonTimeMainframe:GetPoint();																			
	local c = 0;
	local d = 0;
	local a = 0;
	local b = 0;
	
	if ( string.find(p, "LEFT") ) then
		a=1;
	elseif ( string.find(p, "RIGHT") ) then
		a=-1;
	end
	
	if ( string.find(p, "TOP") ) then
		b=-1;
	elseif ( string.find(p, "BOTTOM") ) then
		b=1;
	end
	
	while not ( p == "CENTER" or p == "TOP" or p == "BOTTOM" ) do
		MoonTimeMainframe:SetPoint(p, UIPARRENT, pt, x+a, y)
		self:StartMoving();
		self:StopMovingOrSizing();
		c = c+1;
	
		p,_,pt,x,y = MoonTimeMainframe:GetPoint();	
	end
	
	while not ( p == "CENTER" or p == "LEFT" or p == "RIGHT" ) do
		MoonTimeMainframe:SetPoint(p, UIPARRENT, pt, x, y+b)
		self:StartMoving();
		self:StopMovingOrSizing();
		d = d+1;
	
		p,_,pt,x,y = MoonTimeMainframe:GetPoint();	
	end

	MoonTimeMainframe:ClearAllPoints()
	MoonTimeMainframe:SetPoint("CENTER", UIPARRENT, "CENTER", x-a*c, y-b*d)
																				
					MoonTime_DB["position"]["point"], _, MoonTime_DB["position"]["relativePoint"], MoonTime_DB["position"]["offsetX"], MoonTime_DB["position"]["offsetY"] = frame:GetPoint(1)															
																				
																				
					self:SetMovable(false)
					self:EnableMouse(false)
					self.isLocked = true
					self:SetBackdropColor(1,0,0,0)
				end
			MoonTime_DB["position"]["offsetX"]= floor(MoonTime_DB["position"]["offsetX"])
			MoonTime_DB["position"]["offsetY"]= floor(MoonTime_DB["position"]["offsetY"])
			InterfaceOptionsFrame_OpenToCategory("MoonTime")
			end
		)
	
	frame:SetHeight(50)
	frame:SetWidth(50)
	frame:SetBackdrop({bgFile = "Interface\\DialogFrame\\UI-DialogBox-Gold-Background"})
	frame:SetBackdropColor(1,0,0,0)
	frame:EnableMouse(false)
	frame:SetPoint("CENTER", UIPARENT, "CENTER", 0, 0)
	return frame
	
end

function MoonTime.CreateMoonTimeLayout( self, which )											-- Beginn CreateFrame
	if MoonTime_Layout_Liste[which] then 
		MoonTime_Layout_Liste[which]:createLayout(MoonTimeMainframe);
		MoonTime:debug("Layout \""..which.."\" loaded.")
	end

	MoonTimeMainframe:SetScript("OnUpdate", function(self, event, ... ) MoonTime:OnUpdate(event, ...) end)					-- Seine UpdateRoutine wird angeworfen
																		-- Da die Updateroutine nur dann angeworfen wird, wenn das Fenster
																		-- sichtbar ist, wird OnUpdate auch nur dann aufgerufen, wenn es gebraucht
																		-- wird

end																		-- Ende CreateFrame


function MoonTime.initialize(self)													-- Beginn initialize

	SlashCmdList["MOONTIME"] = function( msg ) MoonTime:toggle( msg ) end
	SLASH_MOONTIME1 = "/moontime";
	SLASH_MOONTIME2 = "/moon";
	
	EventFrame = CreateFrame( "Frame", "MTEventframe", UIPARENT	)
	EventFrame:SetScript("OnEvent", function(self, event, ... ) MoonTime:OnEvent(event, ...) end)
	EventFrame:RegisterEvent("VARIABLES_LOADED");
	MoonTimeMainframe = MoonTime:CreateMainFrame()								-- Das Hauptfenster wird erzeugt
	MoonTimeMainframe:Show()
	--MoonTimeObject = MoonTimeLayoutObj()
	MoonTime:echo("initialized...")

end	

-- Ende initialize

	
MoonTimeDoorKeeper.RegisterLayout = function(self, frame, ... ) if playerclass == "DRUID" then MoonTime:registerMoonTimeLayout(frame, ...) end end
MoonTimeDoorKeeper.RegisterConfig = function(self, frame, ...) if playerclass == "DRUID" then frame.createConfig(ConfigLayoutList) end end




-- Hilfsfunktionen zum Erstellen von Frames

function MoonTime.CreateFrame(self, frameType, name, parent, template, point, relativeTo, relativePoint, xOffset, yOffset, width, height)
	local frame = CreateFrame(frameType, name, parent, template);
	frame:SetPoint(point, relativeTo, relativePoint, xOffset, yOffset);
	frame:SetWidth(width);
	frame:SetHeight(height);
	
	return frame
end

function MoonTime.CreateFontString(self, frame, name, layer, template, point, relativeTo, relativePoint, xOffset, yOffset, width, height, justifyH, justifyV, textColorR, textColorG, textColorB, textColorA)
	local fontstring = frame:CreateFontString(nil, layer, template)
		fontstring:SetPoint(point, relativeTo, relativePoint, xOffset, yOffset)
		fontstring:SetWidth(width)
		fontstring:SetHeight(height)
		fontstring:SetJustifyH(justifyH)
		fontstring:SetJustifyV(justifyV)
		fontstring:SetTextColor( textColorR, textColorG, textColorB, textColorA );
	
	return fontstring
end


if playerclass == "DRUID" then
	MoonTime:initialize()															-- make it so!
end
