-- MoonTimeLayoutObj.lua

function MoonTimeLayoutObj()
	-- dieses Frame besitzt die Funktionen:
	-- GetStarrainCD
	-- GetTreantsCD
	-- GetStarsurgeCD
	-- GetMoonfireCD
	-- GetInsectSwarmCD
	-- GetEclipseEndTimes
	-- Next()
	local frame = CreateFrame( "Frame" )
	
	W_Flying = 0;
	SF_Flying = 0;
	SS_Flying = 0;
	
	frame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	frame:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
	
	
	frame:SetScript("OnEvent", 
		function( self, event, ...)
		local EDir = frame:GetEclipseDirection();
			if (event=="UNIT_SPELLCAST_SUCCEEDED") then
				local sourceUnit, spellName = select(1,...);
				if (sourceUnit == "player") then
					if (spellName == W_name) then
						W_Flying = W_Flying+1;
					elseif (spellName == SF_name) then
						SF_Flying = SF_Flying+1;
					elseif (spellName == SS_name) then
						SS_Flying = SS_Flying+1;
					end
				end

			end  
  
			if (event=="COMBAT_LOG_EVENT_UNFILTERED") then
				local _, event, _, _, sourceName = select(1, ...)


				if (sourceName == UnitName("player")) then

					-- if (event=="SPELL_ENERGIZE") then
						-- local amount, powerType = select(15, ...)
							-- if (powerType==8) then
								-- if (abs(amount) == 15 and SS_Flying>0) then
									-- SS_Flying = SS_Flying-1;
								-- elseif (amount > 19 and SF_Flying>0) then
									-- SF_Flying = SF_Flying-1;
								-- elseif (amount < -12 and W_Flying>0) then
									-- W_Flying = W_Flying-1;
								-- end
							-- end
					-- end
		
					if (event =="SPELL_DAMAGE" or event=="SPELL_MISSED") then
						local spellName = select(13,...);
							if (spellName == W_name and W_Flying>0) then
								W_Flying = W_Flying-1;
							elseif (spellName == SF_name and SF_Flying>0) then
								SF_Flying = SF_Flying-1;
							elseif (spellName == SS_name and SS_Flying>0) then
								SS_Flying = SS_Flying-1;
							end
					end
			end
		
		
			-- if (type=="SPELL_DAMAGE" and sourceName == UnitName("player")) then
				-- local spellId, spellName, spellSchool = select(9, ...)
				-- DEFAULT_CHAT_FRAME:AddMessage(spellName .. " gezaubert " .. sourceName);
				-- ZornFlying = ZornFlying +1;
			-- end
		
  end
end

	)

	frame.GetStarrainCD = function()
		local start, duration, enabled = GetSpellCooldown(SR_id);
		
		return start+duration-GetTime();
	end
	
	frame.GetTreantsCD = function()
		local start, duration, enabled = GetSpellCooldown(Treants_id);
		
		return start+duration-GetTime();
	end

	frame.GetStarsurgeCD = function()
		local start, duration, enabled = GetSpellCooldown(SS_id);
		return start+duration-GetTime();
	end

	frame.GetMoonfireCD = function()
		local _, _, _, _, _, _, MF_expirationTime, MF_unitCaster = UnitDebuff("target", MF_name);
		
		
		if MF_unitCaster=="player" then
			return MF_expirationTime-GetTime();
		else
			return -1;
		end
	end

	frame.GetSunfireCD = function()
		local _, _, _, _, _, _, SunF_expirationTime, SunF_unitCaster = UnitDebuff("target", SunF_name);
		
		if SunF_unitCaster=="player" then
			return SunF_expirationTime-GetTime();
		else
			return -1;
		end
	end

	frame.GetInsectSwarmCD = function()
		local _, _, _, _, _, _, IS_expirationTime, IS_unitCaster = UnitDebuff("target", IS_name);
		
		if IS_unitCaster=="player" then
			return IS_expirationTime-GetTime();
		else
			return -1;
		end
	end
	
	frame.GetFaerieFireCD = function()
		local _, _, _, _, _, _, FF_expirationTime, FF_unitCaster = UnitDebuff("target", FF_name);
		
		if FF_unitCaster=="player" then
			return FF_expirationTime-GetTime();
		else
			return -1;
		end
	end
	
	

	
		local ttd = {
	
	["hp"] = 0,
	["timestamp"] = 0,
	["ttd"] = 0,
};
	
	frame.TimeTillDeath = function ()
	
		tmp = GetTime()
		
		if tmp - 1 > ttd["timestamp"] then
			local hpdiff = ttd["hp"]-UnitHealth("target")
			local timediff = tmp-ttd["timestamp"]
			local timetilldeath = UnitHealth("target")/hpdiff*timediff
			
			if timetilldeath then
				ttd["ttd"] = timetilldeath
			end
		
		
			ttd["hp"] = UnitHealth("target")
			ttd["timestamp"] = tmp
		
		end
		
		return ttd["ttd"] 
		
		
		
	end
	
	frame.GetEclipseDirection = function()
		local dir = GetEclipseDirection()
		
		--DEFAULT_CHAT_FRAME:AddMessage(dir)
		
		if ( dir == "none" ) then
			dir = "sun";
		end
		local power = UnitPower("player", 8)
		
		return dir, power
	end

	frame.isT11proc = function()
	local name, _, _, _, _, _, expirationTime, _, _, _, _ = UnitBuff("player", T11_name);
		if ( name ) then
			return expirationTime-GetTime();
		else
			return -1;
		end
	end		
	
	frame.isSolar = function()
		local name, _, _, _, _, _, solar_expirationTime, _, _, _, _ = UnitBuff("player", Solar_name);
		_, _, SunF_icon = GetSpellInfo(93402);
		if ( name ) then
			SF_Flying = 0;         -- Sicherungsreset
			return true
		else
			return false
		end
	end

	frame.isLunar = function()
		local name, _, _, _, _, _, solar_expirationTime, _, _, _, _ = UnitBuff("player", Lunar_name);
		_, _, MF_icon = GetSpellInfo(8921);
		if ( name ) then
			W_Flying = 0;     -- Sicherungsreset
			return true
		else
			return false
		end
	end	

	frame.isSolarSoon = function()
		local EDir, EPower = frame:GetEclipseDirection();
		
		if ( (EDir == "sun" and EPower > 79) or (EPower == 100 and not frame:isSolar()) ) then
			return true
		end
		return false
	end
	
	frame.isSolarOverSoon = function()
		local EDir, EPower = frame:GetEclipseDirection();
		
		if ( frame:isSolar() and EDir == "moon" and EPower < 15 and EPower > -1 ) then
			return true
		end
		return false
	end
	
	frame.isLunarSoon = function()
		local EDir, EPower = frame:GetEclipseDirection();
		
		if ( ( EDir == "moon" and EPower < -73 ) or (EPower == -100 and not frame:isLunar()) ) then
			return true
		end
		return false
	end

	frame.isLunarOverSoon = function()
		local EDir, EPower = frame:GetEclipseDirection();
		
		if ( frame:isLunar() and EDir == "sun" and EPower > -21 and EPower < 1 ) then
			return true
		end
		return false
	end	
	
	



		

function frame.destroy()
	MoonTime:echo("destroy()")
	frame:SetScript("OnEvent", nil)
	--	frame:Hide()
	frame = nil
	end



	return frame
end