-- MoonTimeConfig.lua



function MoonTimeBuildConfig()

if ( GetLocale() == "deDE" ) then
	L = MoonTime_Strings["deDE"]
else
	L = MoonTime_Strings["enGB"]
end


local MoonTimeConfigPanel = CreateFrame("FRAME", "MoonTimeConfigPanel", UIParent)

MoonTimeConfigPanel.name = "MoonTime"
MoonTimeConfigPanel:SetHeight(100)


local textbox = MoonTime:CreateFontString(MoonTimeConfigPanel, "textbox", "ARTWORK", "GameFontNormalLarge", "TOPLEFT", MoonTimeConfigPanel, "TOPLEFT", 10, -10, 200, 20, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox:SetText("|cffFFFF00".."MoonTime".."|r")
	textbox:Show()	
local textbox = MoonTime:CreateFontString(MoonTimeConfigPanel, "textbox", "ARTWORK", "GameFontNormal", "TOPLEFT", textbox, "BOTTOMLEFT", 0, 0, 500, 20, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox:SetText(L["ConfigurationText"])
	textbox:Show()	
	
local textbox = MoonTime:CreateFontString(MoonTimeConfigPanel, "textbox", "ARTWORK", "GameFontNormal", "TOPLEFT", textbox, "BOTTOMLEFT", 0, -10, 100, 20, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox:SetText(L["Position"])
	textbox:Show()

local textbox = MoonTime:CreateFontString(MoonTimeConfigPanel, "textbox", "ARTWORK", "GameFontNormalSmall", "TOPLEFT", textbox, "BOTTOMLEFT", 20, -30, 55, 16, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox:SetText("x offset")
	textbox:SetJustifyH("BOTTOM");
	textbox:SetJustifyV("CENTER");
	textbox:Show()
	
local editframe18 = MoonTime:CreateFrame("EditBox", "MoonTimeEditBox18", MoonTimeConfigPanel, "InputBoxTemplate", "TOP", textbox, "BOTTOM", 0, -3, 70, 12)
	editframe18:SetAutoFocus(false) 
	editframe18:SetJustifyH("CENTER");
	editframe18:SetJustifyV("CENTER");
	editframe18:Show()
	
local textbox = MoonTime:CreateFontString(MoonTimeConfigPanel, "textbox", "ARTWORK", "GameFontNormalSmall", "TOPLEFT", textbox, "TOPRIGHT", 33, 0, 55, 16, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox:SetText("y offset")
	textbox:SetJustifyH("BOTTOM");
	textbox:SetJustifyV("CENTER");
	textbox:Show()
		
local editframe19 = MoonTime:CreateFrame("EditBox", "MoonTimeEditBox19", MoonTimeConfigPanel, "InputBoxTemplate", "TOP", textbox, "BOTTOM", 0, -3, 70, 12)
		editframe19:SetAutoFocus(false) 
		editframe19:SetJustifyH("CENTER");
		editframe19:SetJustifyV("CENTER");
		editframe19:Show()
		
MoonTimeConfigPanel.button4 = CreateFrame("BUTTON", "MoonTimeMoveButton", MoonTimeConfigPanel, "UIPanelButtonTemplate2")
	MoonTimeConfigPanel.button4:SetText(L["UnlockPosition"])
	MoonTimeConfigPanel.button4:SetWidth(180)
	MoonTimeConfigPanel.button4:SetHeight(30)
	MoonTimeConfigPanel.button4:SetScript("OnClick", function(self) MoonTime.move() InterfaceOptionsFrame:Hide() end)
	MoonTimeConfigPanel.button4:SetPoint('TOPLEFT', MoonTimeConfigPanel, 'TOPLEFT', 10, -80)			


MoonTimeConfigPanel.button = CreateFrame("BUTTON", "MoonTimeOpenConfigButton", MoonTimeConfigPanel, "UIPanelButtonTemplate2")
MoonTimeConfigPanel.button:SetText(L["ResetPosition"])
MoonTimeConfigPanel.button:SetWidth(180)
MoonTimeConfigPanel.button:SetHeight(30)
MoonTimeConfigPanel.button:SetScript("OnClick", 
	function(self) 
		MoonTime_DB["position"]["offsetX"] = 0; 
		MoonTime_DB["position"]["offsetY"]= 0;
		MoonTime_DB["position"]["point"] = "CENTER";
		MoonTime_DB["position"]["relativeTo"] = UIPARENT;
		MoonTime_DB["position"]["relativePoint"] = "CENTER";
		MoonTime:setPosition() 
		InterfaceOptionsFrame:Hide()
		InterfaceOptionsFrame_OpenToCategory("MoonTime")
	end)
MoonTimeConfigPanel.button:SetPoint('TOPLEFT', MoonTimeConfigPanel.button4, 'TOPRIGHT', 10, 0)
	
		
		MoonTimeConfigPanel.button10 = CreateFrame("BUTTON", "MoonTimeOpenConfigButton10", MoonTimeConfigPanel, "UIPanelButtonTemplate2")
MoonTimeConfigPanel.button10:SetText(L["SetPosition"])
MoonTimeConfigPanel.button10:SetWidth(180)
MoonTimeConfigPanel.button10:SetHeight(30)
MoonTimeConfigPanel.button10:SetScript("OnClick", 
	function(self) 
		MoonTime_DB["position"]["offsetX"] = editframe18:GetNumber();
		MoonTime_DB["position"]["offsetY"] = editframe19:GetNumber();
		MoonTime:setPosition() 	
	
		InterfaceOptionsFrame:Hide()
		InterfaceOptionsFrame_OpenToCategory("MoonTime")
	end)
MoonTimeConfigPanel.button10:SetPoint('TOP', MoonTimeConfigPanel.button, 'BOTTOM', 0, -8)






local textbox = MoonTime:CreateFontString(MoonTimeConfigPanel, "textbox", "ARTWORK", "GameFontNormal", "TOPLEFT", MoonTimeConfigPanel, "TOPLEFT", 10, -160, 500, 20, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox:SetText(L["CurrentLayout"])
	textbox:Show()


local textbox2 = MoonTime:CreateFontString(MoonTimeConfigPanel, "textbox", "ARTWORK", "GameFontNormal", "TOPLEFT", MoonTimeConfigPanel, "TOPLEFT", 10, -240, 500, 20, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox2:SetText(L["LayoutsForSelection"])
	textbox2:Show()


	




local function BuildLayoutAuswahl()
local liste = MoonTime_Layout_Liste;
local test = {};


for name,k in pairs(MoonTime_Layout_Liste) do
	if not ( MoonTime_DB["layout"] == name ) then 
		tinsert(test, name);
	end
if not liste[name]["textbox"] then
	local setLayoutButton = CreateFrame("BUTTON", "MoonTimeOpenConfigButton"..name, MoonTimeConfigPanel, "UIPanelButtonTemplate2")
		setLayoutButton:SetText(name)
		setLayoutButton:SetWidth(180)
		setLayoutButton:SetHeight(30)
		setLayoutButton:SetScript("OnClick", 
			function(self) 
				MoonTime:setLayout( name );
				
				InterfaceOptionsFrame:Hide()
				InterfaceOptionsFrame_OpenToCategory("MoonTime")
			end)
		setLayoutButton:SetPoint("TOPLEFT", MoonTimeConfigPanel, "TOPLEFT", 10, -180)

	liste[name]["textbox"] = setLayoutButton; 	

	textbox = MoonTime:CreateFontString(MoonTimeConfigPanel, "textbox", "ARTWORK", "GameFontNormal", "TOPLEFT", setLayoutButton, "TOPRIGHT", 10, 0, 400, 50, "LEFT", "CENTER",  1, 1, 1, 1 );
	textbox:SetText(k.description)
	textbox:SetJustifyV("TOP");
	textbox:Show()	
end


end

-- Sortieren und anordnen

sort(test)
liste[MoonTime_DB["layout"]]["textbox"]:SetPoint("TOPLEFT", MoonTimeConfigPanel, "TOPLEFT", 10, -180)
for a=1, getn(test) do
	liste[test[a]]["textbox"]:SetPoint("TOPLEFT", MoonTimeConfigPanel, "TOPLEFT", 10, -260-(a-1)*60)
end 
if ( getn(test) > 1 )then  textbox2:Show()  else  textbox2:Hide()  end
end




--[[
 local function OnClick(self)
   UIDropDownMenu_SetSelectedID(MoonTimeConfigPanel.MoonTimeLayoutsDropDown, self:GetID())
   UIDropDownMenu_SetSelectedValue(MoonTimeConfigPanel.MoonTimeLayoutsDropDown, self:GetText())
 end

 local function initialize(self, level)
   local info = UIDropDownMenu_CreateInfo()
   for v,k in pairs(MoonTime_Layout_Liste) do
     info = UIDropDownMenu_CreateInfo()
     info.text = v
     info.value = v
     info.func = OnClick
     UIDropDownMenu_AddButton(info, level)
   end
 end


 --if not MoonTimeLayoutsDropDown then
   MoonTimeConfigPanel.MoonTimeLayoutsDropDown=CreateFrame("Frame", "MoonTimeLayoutsDropDown", MoonTimeConfigPanel, "UIDropDownMenuTemplate")
 --end

 MoonTimeConfigPanel.MoonTimeLayoutsDropDown:ClearAllPoints()
 MoonTimeConfigPanel.MoonTimeLayoutsDropDown:SetPoint('TOPLEFT', textbox, 'BOTTOMLEFT', 0, -5)
 MoonTimeConfigPanel.MoonTimeLayoutsDropDown:Show()
 MoonTimeConfigPanel.MoonTimeLayoutsDropDown:SetScript("OnShow", function(self)
 
 UIDropDownMenu_Initialize(MoonTimeConfigPanel.MoonTimeLayoutsDropDown, initialize)
 UIDropDownMenu_SetWidth(MoonTimeConfigPanel.MoonTimeLayoutsDropDown, 100);
 UIDropDownMenu_SetButtonWidth(MoonTimeConfigPanel.MoonTimeLayoutsDropDown, 124)
 UIDropDownMenu_SetSelectedValue(MoonTimeConfigPanel.MoonTimeLayoutsDropDown, MoonTime_DB["layout"])
 UIDropDownMenu_JustifyText(MoonTimeConfigPanel.MoonTimeLayoutsDropDown, "LEFT")
 
 end)


MoonTimeConfigPanel.button11 = CreateFrame("BUTTON", "MoonTimeOpenConfigButton11", MoonTimeConfigPanel, "UIPanelButtonTemplate2")
MoonTimeConfigPanel.button11:SetText("Set Layout")
MoonTimeConfigPanel.button11:SetWidth(180)
MoonTimeConfigPanel.button11:SetHeight(30)
MoonTimeConfigPanel.button11:SetScript("OnClick", 
	function(self) 
		MoonTime:setLayout( UIDropDownMenu_GetSelectedValue(MoonTimeConfigPanel.MoonTimeLayoutsDropDown) );
		
		InterfaceOptionsFrame:Hide()
		InterfaceOptionsFrame_OpenToCategory("MoonTime")
	end)
MoonTimeConfigPanel.button11:SetPoint('TOPLEFT', MoonTimeConfigPanel.MoonTimeLayoutsDropDown, 'TOPRIGHT', 10, 0)

 

 --]]
 
 
 
 
 
 
 
InterfaceOptions_AddCategory(MoonTimeConfigPanel)

MoonTimeConfigPanel:SetScript("OnShow",
	function(self)
		BuildLayoutAuswahl()
		
		editframe18:SetText(floor(MoonTime_DB["position"]["offsetX"]));
		editframe18:SetCursorPosition(0);
				
		editframe19:SetText(floor(MoonTime_DB["position"]["offsetY"]));
		editframe19:SetCursorPosition(0);

	end
)
	
	
function MoonTime:save()
	if not ( MoonTime_DB["layout"] == UIDropDownMenu_GetSelectedValue(MoonTimeConfigPanel.MoonTimeLayoutsDropDown) ) then
		MoonTime:setLayout( UIDropDownMenu_GetSelectedValue(MoonTimeConfigPanel.MoonTimeLayoutsDropDown) );
	end
	
	MoonTime_DB["position"]["offsetX"] = editframe18:GetNumber();
	MoonTime_DB["position"]["offsetY"] = editframe19:GetNumber();
end		


MoonTimeConfigPanel.okay = function()
	if ( MoonTimeConfigPanel:IsShown() ) then
		MoonTime:save()
	end
end		

MoonTimeConfigPanel:Hide()
return MoonTimeConfigPanel
end
