Minimalist_Automatic = {
  type = "group",
  desc = "Automations",
  args = {
    ["IGNOREDUELS"] = {
    name = "Auto-Ignore Duels",
    type = "toggle",
    desc = "Auto-Ignore Duel Requests",
    get = function() return Minimalist.db.char.IGNOREDUELS end,
    set = function(switch)
      Minimalist.db.char.IGNOREDUELS = switch
      if (switch) then
        Minimalist:RegisterEvent("DUEL_REQUESTED")
      else
        Minimalist:UnregisterEvent("DUEL_REQUESTED")
      end
      end
    },
    ["AUTOREPAIR"] = {
    name = "Auto-Repair",
    type = "toggle",
    desc = "Repair All Equipment and Inventory Automagically",
    get = function() return Minimalist.db.char.AUTOREPAIR end,
    set = function(switch)
      Minimalist.db.char.AUTOREPAIR = switch
    if (switch) then
      Minimalist:MHOn()
    else
      Minimalist:MHOff()
    end
  end

    },
    ["AUTOREZ"] = {
    name = "Auto-Resurrect",
    type = "toggle",
    desc = "Accept Resurrections Automatically",
    get = function() return Minimalist.db.char.AUTOREZ end,
    set = function(switch)
      Minimalist.db.char.AUTOREZ = switch
    if (switch) then
      Minimalist:RegisterEvent("RESURRECT_REQUEST")
    else
      Minimalist:UnregisterEvent("RESURRECT_REQUEST")
    end
  end

    },
    ["AUTOSELL"] = {
    name = "Auto-Sell Grey Items",
    type = "toggle",
    desc = "Sell Grey (Junk) Items in Your Bags Automatically",
    get = function() return Minimalist.db.char.AUTOSELL end,
    set = function(switch)
      Minimalist.db.char.AUTOSELL = switch
    if (switch) then
     Minimalist:MHOn() 
    else
     Minimalist:MHOff()
    end
  end

    },
    ["SMARTTAXI"] = {
    name = "Smart Taxi",
    type = "toggle",
    desc = "Auto-Dismount You at Flightmasters",
    get = function() return Minimalist.db.char.SMARTTAXI end,
    set = function(switch)
      Minimalist.db.char.SMARTTAXI = switch
    if (switch) then
      Minimalist:RegisterEvent("TAXIMAP_OPENED")
    else
      Minimalist:UnregisterEvent("TAXIMAP_OPENED")
    end 
  end
    },
    ["GOSSIPSKIP"] = {
    name = "Auto-Skip Useless Gossips",
    type = "toggle",
    desc = "Skip MC/BWL, Flightmaster, Banker, and Battlemaster Gossip",
    get = function() return Minimalist.db.char.GOSSIPSKIP end,
    set = function(switch)
      Minimalist.db.char.GOSSIPSKIP = switch
    if (switch) then
     Minimalist:GHOn() 
    else
     Minimalist:GHOff()
    end
  end
    }
  }
}

Minimalist_Interface = {
  type = "group",
  desc = "Interface",
  args = {    
    ["REPUTATION"] = {
    name = "Better Reputation",
    type = "toggle",
    desc = "Display Reputation Amounts Numerically and Detailed Information in the Chat Frame",
    get = function() return Minimalist.db.char.REPUTATION end,
    set = function(switch)
      Minimalist.db.char.REPUTATION = switch
    if (switch) then
      Minimalist:MinRepOn()
    else
      Minimalist:MinRepOff()
    end
  end
    }, 
    ["GRYPH"] = {
    name = "Disable Gryphons",
    type = "toggle",
    desc = "Toggle Display of Gryphons on Main Toolbar",
    get = function() return Minimalist.db.char.GRYPH end,
    set = function(switch)
      Minimalist.db.char.GRYPH = switch
    if (switch) then
      Minimalist:GryphOn()
    else
      Minimalist:GryphOff()
    end
  end
    }, 
    ["BUFFTIMER"] = {
    name = "Detailed Buff Timers",
    type = "toggle",
    desc = "Show Detailed Buff Timers",
    get = function() return Minimalist.db.char.BUFFTIMER end,
    set = function(switch)
      Minimalist.db.char.BUFFTIMER = switch
    if (switch) then
      --Minimalist:SecureHook('SecondsToTimeAbbrev')
    else
      --Minimalist:Unhook("SecondsToTimeAbbrev")
    end
  end
    },
    ["QUESTLEVEL"] = {
    name = "Display Quest Levels",
    type = "toggle",
    desc = "Display Numeric Quest Level in the Quest Frame, Quest Completion Frame, and NPC Quest Window",
    get = function() return Minimalist.db.char.QUESTLEVEL end,
    set = function(switch)
      Minimalist.db.char.QUESTLEVEL = switch
    if (switch) then
      Minimalist:MinQLOn()
    else
      Minimalist:MinQLOff()
    end
  end
  },
  }
}

Minimalist_Chat = {
  type = "group",
  desc = "Chat",
  args = {    
    ["CHATNOFADE"] = {
    name = "Disable Chat Fading",
    type = "toggle",
    desc = "Disable Chat Frames Fading Chat After Inactivity",
    get = function() return Minimalist.db.char.CHATNOFADE end,
    set = function(switch)
    Minimalist.db.char.CHATNOFADE = switch
    if (switch) then
      Minimalist:ChatNoFadeOn()
    else
      Minimalist:ChatNoFadeOff()
    end
  end

    },
    ["CHATARROWS"] = {
    name = "Fix Arrow Keys",
    type = "toggle",
    desc = "Make Arrow Keys Move the Cursor in the Input Box",
    get = function() return Minimalist.db.char.CHATARROWS end,
    set = function(switch)
    Minimalist.db.char.CHATARROWS = switch
    if (switch) then
      Minimalist:ChatArrowsOn()
    else
      Minimalist:ChatArrowsOff()
    end
  end

    }, 
    ["CHATBUTTONS"] = {
    name = "Hide Buttons",
    type = "toggle",
    desc = "Hide the Chat Frame Buttons",
    get = function() return Minimalist.db.char.CHATBUTTONS end,
    set = function(switch)
    Minimalist.db.char.CHATBUTTONS = switch
    if (switch) then
      Minimalist:ChatButtonsOff()
    else
      Minimalist:ChatButtonsOn()
    end
  end

    }, 
    ["CHATEDIT"] = {
    name = "Move Input Box",
    type = "toggle",
    desc = "Move the Input Box to the Top of the Chat Frame",
    get = function() return Minimalist.db.char.CHATEDIT end,
    set = function(switch)
      Minimalist.db.char.CHATEDIT = switch
    if (switch) then
      Minimalist:ChatMoveEditBox()
    else
      Minimalist:ChatRestoreEditBox()
    end
  end
    },
    ["CHATSCROLL"] = {
    name = "Mouse Scrolling",
    type = "toggle",
    desc = "Move the Input Box to the Top of the Chat Frame",
    get = function() return Minimalist.db.char.CHATSCROLL end,
    set = function(switch)
      Minimalist.db.char.CHATSCROLL = switch
    if (switch) then
      Minimalist:ChatScrollOn()
    else
      Minimalist:ChatScrollOff()
    end
  end
  },
    ["CHATCLEAN"] = {
    name = "Reduce Chat Clutter",
    type = "toggle",
    desc = "Shorten Channel Names to Reduce Chat Window Clutter",
    get = function() return Minimalist.db.char.CHATCLEAN end,
    set = function(switch)
      Minimalist.db.char.CHATCLEAN = switch
    if (switch) then
     Minimalist:ChatParseOn() 
    else
     Minimalist:ChatParseOff()
    end
  end
  },
    ["CHATTIME"] = {
    name = "Time Stamps",
    type = "toggle",
    desc = "Add Time Stamps to Chat Messages",
    get = function() return Minimalist.db.char.CHATTIME end,
    set = function(switch)
      Minimalist.db.char.CHATTIME = switch
    if (switch) then
      Minimalist:ChatParseOn()
    else
      Minimalist:ChatParseOff()
    end
  end
    }     
  }
}

Minimalist_Minimap = {
  type = "group",
  desc = "Minimap",
  args = {    
    ["MAPHIDE"] = {
    name = "Hide Clutter",
    type = "toggle",
    desc = "Hide Minimap Clock, Scroll Buttons, and Location Frame",
    get = function() return Minimalist.db.char.MAPHIDE end,
    set = function(switch)
      Minimalist.db.char.MAPHIDE = switch
    if (switch) then
      Minimalist:MinMapHide()
    else
      Minimalist:MinMapShow()
    end
  end

    },
    ["MAPLOC"] = {
    name = "Map X,Y Coords",
    type = "toggle",
    desc = "Adds Numeric X,Y Coordinates to the Minimap",
    get = function() return Minimalist.db.char.MAPLOC end,
    set = function(switch)
      Minimalist.db.char.MAPLOC = switch
    if (switch) then
      Minimalist:MapLocOn()
    else
      Minimalist:MapLocOff()
    end
  end

    },
    ["MAPSCROLL"] = {
    name = "MouseWheel Zoom",
    type = "toggle",
    desc = "Enables MouseWheel Zooming of the Minimap",
    get = function() return Minimalist.db.char.MAPSCROLL end,
    set = function(switch)
      Minimalist.db.char.MAPSCROLL = switch
    if (switch) then
      Minimalist:MapScrollOn()
    else
      Minimalist:MapScrollOff()
    end
  end

    },
    ["MAPHIDEWORLDMAPBTN"] = {
    name = "World Map Button",
    type = "toggle",
    desc = "Hide the World Map button on the Minimap",
    get = function() return Minimalist.db.char.MAPHIDEWORLDMAPBTN end,
    set = function(switch)
      Minimalist.db.char.MAPHIDEWORLDMAPBTN = switch
    if (switch) then
      MiniMapWorldMapButton:Hide();
    else
      MiniMapWorldMapButton:Show();
    end
  end

    }
}
}
