Minimalist = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceHook-2.1", "AceDB-2.0", "AceConsole-2.0")
local abacus = AceLibrary("LibAbacus-3.0")

Minimalist:RegisterDB("MinimalistDB")
Minimalist.menu = AceLibrary("Dewdrop-2.0")

--# Misc Locals for Cross Functional Options
local Minimalist_Gossip_Show = false
local Minimalist_Merchant_Show = false
local Minimalist_Chat_Parse = false

Minimalist:RegisterDefaults('char', {

IGNOREDUELS = false,
AUTOREPAIR = true,
AUTOREZ = true,
AUTOSELL = false,
GOSSIPSKIP = true,
SMARTTAXI = true,

REPUTATION = true,
BUFFTIMER = false,
GRYPH = true,
QUESTLEVEL = true,
PVPPERCENT = true,

CHATNOFADE = false,
CHATARROWS = true,
CHATBUTTONS = false,
CHATEDIT = false,
CHATSCROLL = false,
CHATCLEAN = false,
CHATTIME = false,

MAPHIDE = false,
MAPLOC = false,
MAPSCROLL = false,
MAPHIDEWORLDMAPBTN = false,

} )

function Minimalist:OnInitialize()
  self.opt = self.db.char
end

function Minimalist:OnEnable()

  self.Minimap = CreateFrame('Frame', Minimalist_Map, Minimap)
  self.Minimap:SetAllPoints(Minimap)

  self.Minimap.loc = self.Minimap:CreateFontString(nil, 'OVERLAY')
  self.Minimap.loc:SetWidth(60)
  self.Minimap.loc:SetHeight(16)
  self.Minimap.loc:SetPoint('CENTER', self.Minimap, 'BOTTOM', 0, -7)
  self.Minimap.loc:SetJustifyH('CENTER')
  self.Minimap.loc:SetFontObject(GameFontNormal)

  for varname, val in pairs(Minimalist_Automatic.args) do
     if self.opt[varname] then  Minimalist_Automatic.args[varname].set(true) end
  end
  for varname, val in pairs(Minimalist_Chat.args) do
     if self.opt[varname] then  Minimalist_Chat.args[varname].set(true) end
  end
  for varname, val in pairs(Minimalist_Interface.args) do
     if self.opt[varname] then  Minimalist_Interface.args[varname].set(true) end
  end
  for varname, val in pairs(Minimalist_Minimap.args) do
     if self.opt[varname] then  Minimalist_Minimap.args[varname].set(true) end
  end

  Minimalist.menu:Register(UIParent,
    'children', function(level, value) Minimalist:Populate(level, value) end,
    'point', function(parent) return "CENTER", "CENTER" end,
    'dontHook', true )

  SlashCmdList["MINIMALIST"] = function() Minimalist.menu:Open(UIParent) end
  SLASH_MINIMALIST1 = "/minimalist"
  SLASH_MINIMALIST2 = "/min"

end

function Minimalist:Populate(level, value)
  if level == 1 then
    Minimalist.menu:AddLine('text', "Minimalist", 'isTitle', true)
    Minimalist.menu:AddLine('text', "")
    Minimalist.menu:AddLine( 'text', "Automatic", 'hasArrow', true, 'value', "Automatic" )
    Minimalist.menu:AddLine( 'text', "Chat", 'hasArrow', true, 'value', "Chat" )
    Minimalist.menu:AddLine( 'text', "Interface", 'hasArrow', true, 'value', "Interface" )
    Minimalist.menu:AddLine( 'text', "Minimap", 'hasArrow', true, 'value', "Minimap" )
    Minimalist.menu:AddLine('text', "")
    Minimalist.menu:AddLine('text', "Close", 'func', function() Minimalist.menu:Close(1) end)
  elseif level == 2 then
    if value == "Automatic" then
      Minimalist.menu:FeedAceOptionsTable(Minimalist_Automatic, 1)
    elseif value == "Chat" then
      Minimalist.menu:FeedAceOptionsTable(Minimalist_Chat, 1)
    elseif value == "Interface" then
      Minimalist.menu:FeedAceOptionsTable(Minimalist_Interface, 1)
    elseif value == "Minimap" then
      Minimalist.menu:FeedAceOptionsTable(Minimalist_Minimap, 1)
    end
  end
end

-- Merchant Handlers
function Minimalist:MHOn()
  if (not Minimalist_Merchant_Show) then
    self:RegisterEvent("MERCHANT_SHOW")
    Minimalist_Merchant_Show = true
  end
end

function Minimalist:MHOff()
  if self.opt.AUTOSELL or self.opt.AUTOREPAIR or not Minimalist_Merchant_Show then return end
  self:UnregisterEvent("MERCHANT_SHOW")
  Minimalist_Merchant_Show = false
end

function Minimalist:MERCHANT_SHOW()
  if self.opt.AUTOSELL then self:MinSellJunk() end
  if CanMerchantRepair() and self.opt.AUTOREPAIR then self:RepairHandler() end
end

-- Gossip Handlers
function Minimalist:GHOn()
  if (not Minimalist_Gossip_Show) then
    self:RegisterEvent("GOSSIP_SHOW")
    Minimalist_Gossip_Show = true
  end
end

function Minimalist:GHOff()
  if self.opt.GOSSIPSKIP or self.opt.QUESTLEVEL or not Minimalist_Gossip_Show then return end
  self:UnregisterEvent("GOSSIP_SHOW")
  Minimalist_Gossip_Show = false
end

function Minimalist:GOSSIP_SHOW()
  if self.opt.QUESTLEVEL then self:GossipQuestLevelShow() end
  if self.opt.GOSSIPSKIP then self:SkipGossip() end
end

-- Gossip Skips Inspired by AutoSelect and Denial
function Minimalist:SkipGossip()
  local bwl = "The orb's markings match the brand on your hand."
  local mc = "You see large cavernous tunnels"
  local t = GetGossipText()
  if (t == bwl or (strsub(t,1,31) == mc)) then
    SelectGossipOption(1)
    return
  end
  local list = {GetGossipOptions()}
  for i = 2,getn(list),2 do
    if(list[i]=="taxi" or list[i]=="battlemaster" or list[i]=="banker") then SelectGossipOption(i/2) return end
  end
end

-- Smart Taxi Functions
function Minimalist:TAXIMAP_OPENED()
  Dismount()
  if (UnitClass("player") == "Druid") then
    for i=1, GetNumShapeshiftForms() do
      _, name, active = GetShapeshiftFormInfo(i);
      if (active ~= nil) then
        CancelPlayerBuff(name)
	break
      end
    end
  end
end

-- Hide Gryphons
function Minimalist:GryphOn()
  MainMenuBarLeftEndCap:Hide()
  MainMenuBarRightEndCap:Hide()
end

function Minimalist:GryphOff()
  MainMenuBarLeftEndCap:Show()
  MainMenuBarRightEndCap:Show()
end

-- Quest Levels
function Minimalist:MinQLOn()
  self:SecureHook('QuestLog_Update')
  self:RegisterEvent("QUEST_GREETING")
  self:GHOn()
end

function Minimalist:MinQLOff()
  self:Unhook('QuestLog_Update')
  self:UnregisterEvent("QUEST_GREETING")
  self:GHOff()
end

-- Display Quest Levels in the Quest Log, based on Toast in the Machine's method
function Minimalist:QuestLog_Update()
  local numEntries = GetNumQuestLogEntries()
  for i=1, QUESTS_DISPLAYED, 1 do
    local questLogTitle = getglobal("QuestLogTitle"..i)
    if i <= numEntries then
      local questTitle, level, _, isHeader, _, _, _ = GetQuestLogTitle(i + FauxScrollFrame_GetOffset(QuestLogListScrollFrame))
      if level > 0 and questTitle then
        questLogTitle:SetText("["..level.."]"..questTitle)
      end
    end
  end
end


-- Display Quest Levels in a Gossip Window
function Minimalist:GossipQuestLevelShow()
  local buttonindex = 1
  local list,button
  local qcols = 3
  local listmax = 24
  if (GetGossipAvailableQuests()) then
    list = {GetGossipAvailableQuests()}
    for i = 1,listmax,qcols do
      if not list[i] then break end
      button = getglobal("GossipTitleButton"..(buttonindex))
      button:SetText(format('[%d] %s',list[i+1],list[i]))
      buttonindex = buttonindex + 1
    end
    buttonindex = buttonindex + 1
  end
  if (GetGossipActiveQuests()) then
    list = {GetGossipActiveQuests()}
    for i = 1,listmax,qcols do
      if not list[i] then break end
      button = getglobal("GossipTitleButton"..(buttonindex))
      button:SetText(format('[%d] %s',list[i+1],list[i]))
      buttonindex = buttonindex + 1
    end
    buttonindex = buttonindex + 1
  end
end

-- Display Quest Levels in a Quest Detail Window, Based on AutoSelect
function Minimalist:QUEST_GREETING()
    local nact,navl = GetNumActiveQuests(), GetNumAvailableQuests()
    local title,level,button
    local o,GetTitle,GetLevel = 0,GetActiveTitle,GetActiveLevel
    for i = 1,nact+navl do
      if(i==nact+1) then
        o,GetTitle,GetLevel = nact,GetAvailableTitle,GetAvailableLevel
      end
      title,level = GetTitle(i-o), GetLevel(i-o)
      button = getglobal("QuestTitleButton"..i)
      button:SetText(format('[%d] %s',level,title))
    end
end

-- Auto-Repair Function
function Minimalist:RepairHandler()
  local equipcost = GetRepairAllCost()
  local funds = GetMoney()
  if (funds < equipcost) then self:Print("Insufficient Funds to Repair") end
  if (funds > equipcost and equipcost > 0) then
    self:Print("Total Repair Costs: "..abacus:FormatMoneyExtended(equipcost))
    if (equipcost > 0) then RepairAllItems() end
  end
end

-- Auto-Sell Grey Junk, Adapted from AutoProfit
function Minimalist:MinSellJunk()
  local bag, slot
  for bag = 0, 4 do
    if GetContainerNumSlots(bag) > 0 then
      for slot = 1, GetContainerNumSlots(bag) do
        local _, _, _, quality = GetContainerItemInfo(bag, slot)
        if (quality == 0 or quality == -1) then
          if (self:ProcessLink(GetContainerItemLink(bag, slot))) then
            UseContainerItem(bag, slot)
	  end
        end
      end
    end
  end
end

function Minimalist:ProcessLink(link)
  for color, name in string.gmatch(link, "(|c%x+)|Hitem:.+|h%[(.-)%]|h|r") do
    if color == ITEM_QUALITY_COLORS[0].hex then
      return true
    end
      return false
  end
end

-- Improved Repututation Handlers and Functions
function Minimalist:MinRepOn()
  self:PLAYER_ENTERING_WORLD()
  self:RegisterEvent("PLAYER_ENTERING_WORLD")
  self:RegisterEvent("UPDATE_FACTION")
  for i=1, 15 do
    self:HookScript(getglobal("ReputationBar"..i), "OnEnter", function() end)
    self:HookScript(getglobal("ReputationBar"..i), "OnLeave", function() end)
  end
  self:SecureHook("ReputationFrame_Update")
end

function Minimalist:MinRepOff()
  ReputationWatchBar.cvarLocked = nil
  ReputationWatchBar.textLocked = nil
  ReputationWatchStatusBarText:Hide()
  self:UnregisterEvent("UPDATE_FACTION")
  for i=1, 15 do
    self:Unhook(getglobal("ReputationBar"..i), "OnEnter")
    self:Unhook(getglobal("ReputationBar"..i), "OnLeave")
  end
  self:Unhook("ReputationFrame_Update")
  self:UnregisterEvent("PLAYER_ENTERING_WORLD")
  ReputationFrame_Update()
end

function Minimalist:PLAYER_ENTERING_WORLD()
  ReputationWatchBar.cvarLocked = 1
  ReputationWatchBar.textLocked = 1
  ReputationWatchStatusBarText:Show()
end

--  Reputation Functions Based on Reputation Mod
function Minimalist:ReputationFrame_Update()
  local numFactions = GetNumFactions()
  local factionOffset = FauxScrollFrame_GetOffset(ReputationListScrollFrame)
  local factionIndex, factionStanding
  for i=1, NUM_FACTIONS_DISPLAYED, 1 do
    factionIndex = factionOffset + i
    if ( factionIndex <= numFactions ) then
      local name, description, standingID, bottomValue, topValue, earnedValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex)
      if ( not isHeader ) then
        factionStanding = getglobal("FACTION_STANDING_LABEL"..standingID)
        getglobal("ReputationBar"..i.."FactionStanding"):SetText( factionStanding.." - "..earnedValue-bottomValue.."/"..topValue-bottomValue)
      end
    end
  end
end

local MinReps = { }
function Minimalist:UPDATE_FACTION()
  self:PLAYER_ENTERING_WORLD()
  local RepRemains
  for factionIndex=1, GetNumFactions(), 1 do
    local name, description, standingID, bottomValue, topValue, earnedValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex)
    if ( not isHeader ) then
    if (MinReps[name]) then
      local difference = earnedValue - MinReps[name].Value
      if (difference > 0 and standingID ~= 8) then
        RepRemains = topValue-earnedValue
        self:Print(format("%d faction needed until %s with %s.",RepRemains,getglobal("FACTION_STANDING_LABEL"..standingID+1),name))
      elseif (difference < 0 and standingID ~= 1) then
        difference=abs(difference)
        RepRemains = earnedValue-bottomValue
	self:Print(format("%d faction left until %s with %s.",RepRemains,getglobal("FACTION_STANDING_LABEL"..standingID-1),name))
      end
      MinReps[name].Value = earnedValue
    else
      MinReps[name] = { }
      MinReps[name].Value = earnedValue
    end
    end
  end
end

-- Autorez Based on AutoRez
function Minimalist:RESURRECT_REQUEST()
  if (arg1 == "Chained Spirit") then return end
  if (GetCorpseRecoveryDelay() ~= 0) then return end
  HideUIPanel(StaticPopup1)
  AcceptResurrect()
end

-- Ignore Duel Function
function Minimalist:DUEL_REQUESTED()
  HideUIPanel(StaticPopup1)
  CancelDuel()
end

-- Minimap Functions Based on idMinimap
function Minimalist:MapLocOn()
  self.Minimap:Show()
  self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
  self:ScheduleRepeatingEvent("UpdateLoc", self.UpdateLoc, 0.5, self)
end

function Minimalist:ZONE_CHANGED_NEW_AREA()
local x, y = GetPlayerMapPosition("player")
if x == 0 and y == 0 then
  SetMapToCurrentZone()
end
end

function Minimalist:MapLocOff()
  self.Minimap.loc:SetText('')
  self:CancelScheduledEvent("UpdateLoc")
  if not self:IsEventRegistered("ZONE_CHANGED_NEW_AREA") then self:UnregisterEvent("ZONE_CHANGED_NEW_AREA") end
  if not self.opt.MAPSCROLL then self.Minimap:Hide() end
end

function Minimalist:UpdateLoc()
  local x, y = GetPlayerMapPosition("player")
  self.Minimap.loc:SetText(string.format('%s,%s', floor(x*100) or '', floor(y*100) or ''))
end

function Minimalist:MapScrollOn()
  self.Minimap:Show()
  self.Minimap:SetScript("OnMouseWheel", function() self:Zoom() end)
  self.Minimap:EnableMouseWheel(true)
end

function Minimalist:MapScrollOff()
  self.Minimap:SetScript("OnMouseWheel", nil)
  self.Minimap:EnableMouseWheel(false)
  if not self.opt.MAPLOC then self.Minimap:Hide() end
end

function Minimalist:Zoom()
    if not arg1 then return end
    if arg1 > 0 and Minimap:GetZoom() < 5 then
        Minimap:SetZoom(Minimap:GetZoom() + 1)
    elseif arg1 < 0 and Minimap:GetZoom() > 0 then
        Minimap:SetZoom(Minimap:GetZoom() - 1)
    end
end

function Minimalist:MinMapHide()
  MinimapZoomIn:Hide()
  MinimapZoomOut:Hide()
  GameTimeFrame:Hide()
  MinimapToggleButton:Hide()
  MinimapZoneTextButton:Hide()
  MinimapBorderTop:Hide()
end

function Minimalist:MinMapShow()
  MinimapZoomIn:Show()
  MinimapZoomOut:Show()
  GameTimeFrame:Show()
  MinimapToggleButton:Show()
  MinimapZoneTextButton:Show()
  MinimapBorderTop:Show()
end

-- Chat Functions, Disable Fade

function Minimalist:ChatNoFadeOn()
 for i = 1, 7 do
   getglobal('ChatFrame'..i):SetFading(false)
 end
end

function Minimalist:ChatNoFadeOff(switch)
 for i = 1, 7 do
   getglobal('ChatFrame'..i):SetFading(true)
 end
end

-- Chat Functions, Based on idChat and Random's ChatScroll
function Minimalist:ChatScrollOn()
  for i = 1, 7 do
    local cf = getglobal('ChatFrame'..i)
    self:HookScript(cf, "OnMouseWheel")
    cf:EnableMouseWheel(1)
  end
end

function Minimalist:ChatScrollOff()
  for i = 1, 7 do
    local cf = getglobal('ChatFrame'..i)
    self:Unhook(cf, "OnMouseWheel")
    cf:EnableMouseWheel(FALSE)
  end
end

function Minimalist:OnMouseWheel()
  self.hooks[this]["OnMouseWheel"]()
  if arg1 > 0 then
    if IsShiftKeyDown() then this:ScrollToTop() else this:ScrollUp() end
  elseif arg1 < 0 then
    if IsShiftKeyDown() then this:ScrollToBottom() else this:ScrollDown() end
  end
end

function Minimalist:ChatButtonsOn()
  if (ChatFrameMenuButton:IsVisible()) then return end
  local cf
  ChatFrameMenuButton:Show()
  for i = 1, 7 do
    cf=getglobal('ChatFrame'..i..'UpButton')
    self:Unhook(cf, "OnShow")
    cf:Show()
    cf=getglobal('ChatFrame'..i..'DownButton')
    self:Unhook(cf, "OnShow")
    cf:Show()
    cf=getglobal('ChatFrame'..i..'BottomButton')
    self:Unhook(cf, "OnShow")
    cf:Show()
  end
end

function Minimalist:ChatButtonsOff()
  if (not ChatFrameMenuButton:IsVisible()) then return end
  local cf
  ChatFrameMenuButton:Hide()
  for i = 1, 7 do
    cf=getglobal('ChatFrame'..i..'UpButton')
    cf:Hide()
    self:HookScript(cf, "OnShow")
    cf=getglobal('ChatFrame'..i..'DownButton')
    cf:Hide()
    self:HookScript(cf, "OnShow")
    cf=getglobal('ChatFrame'..i..'BottomButton')
    cf:Hide()
    self:HookScript(cf, "OnShow")
  end
end

function Minimalist:OnShow()
  this:Hide()
end

function Minimalist:ChatMoveEditBox()
  local eb = VisorEditBox or ChatFrameEditBox
  eb:ClearAllPoints()
  eb:SetPoint('BOTTOMLEFT',  'ChatFrame1', 'TOPLEFT',  -5, 0)
  eb:SetPoint('BOTTOMRIGHT', 'ChatFrame1', 'TOPRIGHT', 5, 0)
end

function Minimalist:ChatRestoreEditBox()
  local eb = VisorEditBox or ChatFrameEditBox
  eb:ClearAllPoints()
  eb:SetPoint('TOPLEFT',  'ChatFrame1', 'BOTTOMLEFT',  -5, 0)
  eb:SetPoint('TOPRIGHT', 'ChatFrame1', 'BOTTOMRIGHT', 5, 0)
end

function Minimalist:ChatArrowsOn()
  local eb = VisorEditBox or ChatFrameEditBox
  eb:SetAltArrowKeyMode(false)
end

function Minimalist:ChatArrowsOff()
  local eb = VisorEditBox or ChatFrameEditBox
  eb:SetAltArrowKeyMode(enabled)
end

function Minimalist:ChatParseOn()
  if Minimalist_Chat_Parse then return end
  for i = 1, 7 do
    local cf = getglobal("ChatFrame"..i)
    self:Hook(cf, "AddMessage", true)
  end
  Minimalist_Chat_Parse = true
end

function Minimalist:AddMessage(cf, msg, r, g, b, id)
      msg = msg or ''
      r = r or ''
      g = g or ''
      b = b or ''
      id = id or nil
      if self.opt.CHATTIME then msg = date("%H:%M:%S").."| "..msg end
      if self.opt.CHATCLEAN then
        msg = string.gsub(msg, '%[(%d)%..-%]', '(%1)')

        msg = string.gsub(msg, '%[Guild%]', '(G)')
        msg = string.gsub(msg, '%[Officer%]', '(O)')

        msg = string.gsub(msg, '%[Battleground%]', '(BG)')
        msg = string.gsub(msg, '%[Battleground Leader%]', '(BGL)')

        msg = string.gsub(msg, '%[Party%]', '(P)')
        msg = string.gsub(msg, '%[Raid%]', '(R)')
        msg = string.gsub(msg, '%[Raid Leader%]', '(R)')
        msg = string.gsub(msg, '%[Raid Warning%]', '(!)')
      end
      self.hooks[cf]["AddMessage"](cf, msg, r, g, b, id)
end

function Minimalist:ChatParseOff()
  if self.opt.CHATCLEAN or self.opt.CHATTIME or not Minimalist_Chat_Parse then return end
  for i=1,7 do self:Unhook(getglobal('ChatFrame'..i), "AddMessage") end
  Minimalist_Chat_Parse = false
end

function Minimalist:FormatDurationBuff(duration)
  if not duration or duration < 0 or duration >= 7200 then
    return
  elseif duration >= 3600 then
    return format("%.2fh", duration/3600)
  elseif duration > 60 then
    return abacus:FormatDurationCondensed(duration)
  else
    return format("%ds", duration)
  end
end
