--[[
	Zone Functions
	v1.8
]]

-- IsFlyableArea() seems to return if an area can fly!
-- Find a way to incorperate it!

-- Return the Special Zone mount mode. This is used for areas that don't allow flying in certain spots like Dalaran & Wintergrasp.
function MiniMount_ZoneSmart(cmt)
	local mode,_ = MiniMount_ZoneGetData(cmt);

	return mode;
end

-- Determine if a new mount must be called.
function MiniMount_ZoneSmartNewMount(cmt)
	local _, newmount = MiniMount_ZoneGetData(cmt);

	if newmount == true then
		MiniMount_GetNextMount();
	end
end


-- Main Zone Data Function
function MiniMount_ZoneGetData(CurrentMountType)
	local newmount = nil;
	local mode = "Ground";
	local zone, subzone = GetZoneText(), GetSubZoneText();

	if (zone == MINIMOUNT_ZONE_WINTERGRASP) and (GetWintergraspWaitTime() == nil) then
		mode = "Ground";
	elseif (IsFlyableArea() == 1) then
		mode = "Fly";
	end

--[[
	SetMapToCurrentZone();
	MiniMount_DetermineNorthrendFly();
	local zone, subzone = GetZoneText(), GetSubZoneText();
	local continent = GetCurrentMapContinent();


	if (continent == 3) and (MiniMount_RidingSkill >= 225) then
		mode = "Fly";
	elseif (continent == 4) and (MiniMount_CanNorthrendFly == true) then
		mode = "Fly"
	end

	if (zone == MINIMOUNT_ZONE_DALARAN) then
		if (MiniMount_CanNorthrendFly == true) then
			if subzone == MINIMOUNT_SUBZONE_DALARAN_KRASUSLANDING or subzone == MINIMOUNT_SUBZONE_DALARAN_THEVIOLETCITADEL then
				mode = "Fly";
			else
				mode = "Ground";
			end
		else
			mode = "Ground";
		end
	elseif (zone == MINIMOUNT_ZONE_WINTERGRASP) and (GetWintergraspWaitTime() == nil) then
		mode = "Ground";
	elseif (zone == MINIMOUNT_INSTANCE_THEOCULUS) then
		mode = "Ground";
	elseif (zone == MINIMOUNT_RAID_THEOBSIDIANSANCTUM) then
		mode = "Ground";
	elseif (zone == MINIMOUNT_RAID_THEEYEOFETERNITY) then
		mode = "Ground";
	end
]]
	if (mode ~= nil) and (mode ~= CurrentMountType) then
		newmount = true;
	end
	return mode, newmount;

end