--[[
	MiniMount
	Version 1.8

]]

MiniMount_Version = "1.8";

MiniMount_Mounts_Slow = {};
MiniMount_Mounts_Regular = {};
MiniMount_Mounts_Epic = {};
MiniMount_Mounts_FlyRegular = {};
MiniMount_Mounts_FlyEpic = {};
MiniMount_Mounts_FlyEpicFast = {};
MiniMount_Mounts_SwimRegular = {};
MiniMount_Mounts_Unknown = {};
MiniMount_Mounts_AQ = {};
MiniMount_ReportedMounts = {};

MiniMount_RidingSkill = 1;
MiniMount_CanNorthrendFly = false;
local MiniMount_IsLoaded = nil;
local Reported = false;
local CurrentMount = nil;
local NextMount = nil;
local CurrentContinent = GetCurrentMapContinent();
local CurrentMountType = nil;

local MinRidingLevel = 20;

-- Defaults
MiniMount_Defaults = {
	["Options"] = {
		["Version"] = MiniMount_Version,
		["DefaultMode"] = "Auto", -- Other values: "Regular", "Epic", "FlyRegular", FlyEpic"
		["PerferFlight"] = 1, -- When you are able to, do you perfer to fly or ride a ground mount?
		["Use Mount List"] = 1, -- Use Mount Lists (if any) by default
		["Default Mount List"] = "Default"; -- Reference the name of the "default" mount list. If set to Default, then use all mounts.
		["MountLists"] = {},
		["Perfered_Ground_Normal"] = "0";
		["Perfered_Ground_Epic"] = "0";
		["Perfered_Fly_Normal"] = "0";
		["Perfered_Fly_Epic"] = "0";
	},
	["Mount List"] = {
		["Name"] = "New Mount List",
		["Desc"] = "A New List of Mounts to use",
		["Enabled"] = true,
		["Zones"] = {},	-- If no Zones not listed, then this mount list will not auto-activate. User must select this list as the default.
		["Mounts"] = {},
	},
	["Mount Data"] = {
		["Enabled"] = 1,
		["Ratio"] = 1,
		["SpellID"] = "458", -- Default to Brown Horse, just in case...
	}
}

-- Message zones
function MiniMount_Msg(msg, channel, debug)
	if (msg == nil) then
		return;
	end
	if debug == nil then
		debug = 10;
	end
	if channel ~= nil then
		channel = strlower(channel);
	end

	if (channel == "error") then
		DEFAULT_CHAT_FRAME:AddMessage(RED_FONT_COLOR_CODE..MINIMOUNT_TITLE.." "..MINIMOUNT_ERROR..": |r"..msg);
	elseif (channel == "debug") then
		DEFAULT_CHAT_FRAME:AddMessage(LIGHTYELLOW_FONT_COLOR_CODE..MINIMOUNT_TITLE.." "..MINIMOUNT_DEBUG..": |r"..msg);
	else
		DEFAULT_CHAT_FRAME:AddMessage(GREEN_FONT_COLOR_CODE..MINIMOUNT_TITLE..": |r"..msg);
	end
end

-- Loading Function
function MiniMount_Load(self)
	self:RegisterEvent("VARIABLES_LOADED");
	self:RegisterEvent("COMPANION_LEARNED");
	self:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA");
	self:RegisterEvent("ZONE_CHANGED");
	self:RegisterEvent("KNOWLEDGE_BASE_SYSTEM_MOTD_UPDATE");
	self:RegisterEvent("TIME_PLAYED_MSG");
	


	-- Slash Commands
	SlashCmdList["MiniMount"] = MiniMount_CommandLine;
	SLASH_MiniMount1 = "/minimount";
	SLASH_MiniMount2 = "/mount";
	SLASH_MiniMount3 = "/mm";
end

function MiniMount_OnEvent(self,event, ...)
	local arg1, _ = ...;

	if (MiniMount_IsLoaded ~= 1) and (event ~= "VARIABLES_LOADED") then
		return;
	end

	if event == "VARIABLES_LOADED" then
		MiniMount_Loaded();
		MiniMount_IsLoaded = 1;
		self: UnregisterEvent("VARIABLES_LOADED");
	elseif event == "KNOWLEDGE_BASE_SYSTEM_MOTD_UPDATE" or event == "TIME_PLAYED_MSG" then
		MiniMount_ZoneSmartNewMount(CurrentMountType);
		MiniMount_GetNextMount();
		MiniMount_Macro();
		MiniMount_IsLoaded = 1;
		self: UnregisterEvent("KNOWLEDGE_BASE_SYSTEM_MOTD_UPDATE");
		self: UnregisterEvent("TIME_PLAYED_MSG");
	elseif (event == "COMPANION_LEARNED") then
		MiniMount_ReportedMounts = {};
		MiniMount_BuildMountArrays();
		MiniMount_GetNextMount();
	elseif event == "CHAT_MSG_CHANNEL_NOTICE" then
		if GetCurrentMapContinent() ~= CurrentContinent then
			CurrentContinent = GetCurrentMapContinent();
			MiniMount_GetNextMount();
		end
	elseif (event == "ZONE_CHANGED") or (event == "ZONE_CHANGED_NEW_AREA") or (event == "ZONE_CHANGED_INDOORS") then
		MiniMount_ZoneSmartNewMount(CurrentMountType);
	end
end

function MiniMount_BuildDatabase(database, defaults)
	if (not database) then
		database = defaults;
	end
end

function MiniMount_UpdateDatabase(database, defaults)
	local temp = defaults;

	if (not MiniMount_Options["Version"]) or (MiniMount_Options["Version"] < "1.6") then
		MiniMount_Options = {};
		MiniMount_Options = MiniMount_Defaults["Options"];
	else
		local CharDB = database;
		for k,v in pairs(CharDB) do
			if (temp[k]) then
				if (type(temp[k])=="table") and (type(CharDB[k]) == "table") then
					for k2,v2 in pairs(CharDB[k]) do
						if (temp[k][k2]) then
							if (type(temp[k][k2])=="table") and (type(CharDB[k][k2]) == "table") then
								for k3,v3 in pairs(CharDB[k][k2]) do
									if (temp[k][k2][k3]) then
										if (type(temp[k][k2][k3])=="table") and (type(CharDB[k][k2][k3]) == "table") then
											for k4,v4 in pairs(CharDB[k][k2][k3]) do
												if (temp[k][k2][k3][k4]) then
													if (type(temp[k][k2][k3][k4])=="table") and (type(CharDB[k][k2][k3][k4]) == "table") then
														for k5,v5 in pairs(CharDB[k][k2][k3][k5]) do
															if (temp[k][k2][k3][k4][k5]) then
																if ((CharDB[k][k2][k3][k4][k5]) and (v5 ~= nil)) then
																	temp[k][k2][k3][k4][k5] = v5;
																end
															end
														end
													elseif ((CharDB[k][k2][k3][k4]) and (v4 ~= nil)) then
														temp[k][k2][k3][k4] = v4;
													end
												end
											end
										elseif ((CharDB[k][k2][k3]) and (v3 ~= nil)) then
											temp[k][k2][k3] = v3;
										end
									end
								end
							elseif ((CharDB[k][k2]) and (v2 ~= nil)) then
								temp[k][k2] = v2;
							end
						end
					end
				elseif ((CharDB[k]) and (v ~= nil)) then
					temp[k] = v;
				end
			end
		end
		temp["Version"] = MiniMount_Version;
		MiniMount_Options = {}; -- Just in case, erase all previous settings.
		MiniMount_Options = temp;
	end
end

function MiniMount_Loaded()
	if (not MiniMount_Options) then
		MiniMount_Options = MiniMount_Defaults["Options"];
	end
	if (not MiniMount_Options["Version"]) or (MiniMount_Options["Version"] < MiniMount_Version) then
		MiniMount_UpdateDatabase(MiniMount_Options, MiniMount_Defaults["Options"]);
	end

	MiniMount_RidingSkill = MiniMount_GetRidingSkill();

	MiniMount_DetermineNorthrendFly();

	MiniMount_Msg(MINIMOUNT_VERSION.." "..MiniMount_Version.." "..MINIMOUNT_NOWLOADED);
end

function MiniMount_CommandLine(incmd)
	-- Parse command-line Macro options!
	local cmd = SecureCmdOptionParse(incmd);
	if not cmd then return; end

	-- Force lowercase so we don't have to double-up our options! Also makes it more user-proof.
	if cmd == nil then cmd = ""; end
	cmd = strlower(cmd);

	if (cmd == "new") or (cmd == "newmount") or (cmd == "new mount") then
		MiniMount_GetNextMount(nil,1);
	elseif (cmd == "reg") or (cmd == "regular") or (cmd == "ground reg") or (cmd == "ground regular") then
		MiniMount_Mount("Regular",1);
	elseif (cmd == "epic") or (cmd == "ground epic") then
		MiniMount_Mount("Epic",1);
	elseif (cmd == "fly reg") or (cmd == "fly regular") then
		MiniMount_Mount("FlyRegular",1);
	elseif (cmd == "fly epic") then
		MiniMount_Mount("FlyEpic",1);
	elseif (cmd == "fly epic fast") then
		MiniMount_Mount("FlyEpicFast",1);
	elseif (cmd == "fly") then
		MiniMount_Mount("Fly",1);
	elseif (cmd == "swim reg") or (cmd == "swim regular") then
		MiniMount_Mount("SwimRegular",1);
	elseif (cmd == "swim") then
		MiniMount_Mount("Swim",1);
	elseif (cmd == "ground") then
		MiniMount_Mount("Ground",1);
	elseif (cmd == "random") then
		MiniMount_Mount("Random",1);
	elseif (cmd == nil) or (cmd == "") then
		MiniMount_Mount(nil,1);
	else
		MiniMount_Msg(MINIMOUNT_ERROR_WRONGOPTION,"error")
	end
end

function MiniMount_Mount(mode,iscmd)
	-- Fail if the player is not high enough to have a mount.
	if UnitLevel("player") < MinRidingLevel then
		MiniMount_Msg(MINIMOUNT_ERROR_LEVELNOTHIGHENOUGH,"error");
		return;
	end

	-- Fail if there are no mounts.
	if GetNumCompanions("MOUNT") < 1 then
		MiniMount_Msg(MINIMOUNT_NOMOUNTS_ANY,"error");
		return;
	end

	if ((mode ~= nil) and (mode ~= "")) or (NextMount == nil) or (NextMount == "error") then
		MiniMount_GetNextMount(mode,iscmd);
	end

	if (NextMount == "error") then
		return;
	end

	MiniMount_CallMount(NextMount);
end

function MiniMount_CallMount(mount)
	if (not IsFlying()) then
		-- local _, MountName = GetCompanionInfo("MOUNT",mount);
		-- MiniMount_Msg("Summoning "..MountName.."...");
		CurrentMount = mount;
		CallCompanion("MOUNT", CurrentMount);
		MiniMount_GetNextMount();
	else
		if IsFlying() then
			MiniMount_Msg(MINIMOUNT_ERROR_ISFLYING,"error");
		end
	end
end

function MiniMount_GetNextMount(mode,iscmd)
	-- Silently fail is the player is not high enough to have a mount.
	if UnitLevel("player") < MinRidingLevel then
		return;
	end

	MiniMount_BuildMountArrays();
	local MountNum = GetNumCompanions("MOUNT");
	local MountList = {};
	SetMapToCurrentZone();
	CurrentContinent = GetCurrentMapContinent();
	local czone = GetRealZoneText();
	MiniMount_RidingSkill = MiniMount_GetRidingSkill();
	MiniMount_DetermineNorthrendFly();

	if MountNum == 0 then
		if (iscmd ~= nil) then
			MiniMount_Msg(MINIMOUNT_NOMOUNTS_ANY,"error");
		end
		NextMount = "error";
		return;
	end

	if MiniMount_RidingSkill < 75 then
		-- MiniMount_Msg(MINIMOUNT_ERROR_SKILLNOTHIGHENOUGH,"error");
		NextMount = "error";
		return;
	end

	if (not mode) then
		mode = MiniMount_Options["DefaultMode"];
	end

	if (not mode) then
		mode = "Auto";
	end

	local rand = {
		[1] = "Auto",
	}
	if #MiniMount_Mounts_Slow > 0 then
		tinsert(rand, (#rand + 1), "Slow");
	end
	if #MiniMount_Mounts_Regular > 0 then
		tinsert(rand, (#rand + 1), "Regular");
	end
	if #MiniMount_Mounts_Epic > 0 then
		tinsert(rand, (#rand + 1), "Epic");
	end
	if (MiniMount_FlyZone(CurrentContinent, MiniMount_CanNorthrendFly) == true) then
		if #MiniMount_Mounts_FlyRegular > 0 then
			tinsert(rand, (#rand + 1), "FlyRegular");
		end
		if #MiniMount_Mounts_FlyEpic > 0 then
			tinsert(rand, (#rand + 1), "FlyEpic");
		end
		if #MiniMount_Mounts_FlyEpicFast > 0 then
			tinsert(rand, (#rand + 1), "FlyEpicFast");
		end
	end
--[[
	if #MiniMount_Mounts_Unknown > 0 then
		tinsert(rand, (#rand + 1), "Unknown");
	end
]]

	if mode == "Random" then
		mode = rand[random(1,#rand)];
	end

	if mode == "Auto" then
		mode = "Ground";
		if (MiniMount_FlyZone(CurrentContinent, MiniMount_CanNorthrendFly) == true) then
			if MiniMount_RidingSkill >= 225 then
				mode = "Fly";
			end
		end

		if IsSwimming() == true and #MiniMount_Mounts_SwimRegular > 0 then
			mode = "Swim";
		end

		local newmode = MiniMount_ZoneSmart(CurrentMountType);
		if newmode ~= nil then
			mode = newmode;
		end
	end

	if (mode == "Ground") then
		if (MiniMount_RidingSkill == 75) then
			mode = "Regular";
		elseif (MiniMount_RidingSkill >= 150) then
			mode = "Epic";
		else
			MiniMount_Msg(MINIMOUNT_ERROR_SKILLNOTHIGHENOUGH,"error");
			NextMount = "error";
			return;
		end
	end
	if (mode == "Fly") then
		if (MiniMount_FlyZone(CurrentContinent, MiniMount_CanNorthrendFly) == nil) then
			-- MiniMount_Msg(MINIMOUNT_ERROR_NOFLYZONE,"error");
			NextMount = "error";
			return;
		end

		if (MiniMount_RidingSkill == 225) then
			mode = "FlyRegular";
		elseif (MiniMount_RidingSkill == 300) then
			if #MiniMount_Mounts_FlyEpicFast > 0 then
				mode = "FlyEpicFast";
			else
				mode = "FlyEpic";
			end
		else
			--MiniMount_Msg(MINIMOUNT_ERROR_SKILLNOTHIGHENOUGHFLY,"error");
			if MiniMount_RidingSkill == 75 then
				mode = "Regular";
			elseif MiniMount_RidingSkill >= 150 then
				mode = "Epic";
			end
		end
	end

	if (mode == "Swim") then
		-- At the moment, we don't need this, so change to Swim Reg, and be done with it.
		mode = "SwimRegular";
	end

	if (mode == "FlyEpicFast") and (#MiniMount_Mounts_FlyEpicFast == 0) then
		mode = "FlyEpic";
	end
	if (mode == "FlyEpic") and (#MiniMount_Mounts_FlyEpic == 0) then
		mode = "FlyRegular";
	end
	if (mode == "FlyRegular") and (#MiniMount_Mounts_FlyRegular == 0) then
		mode = "Epic";
	end
	if (mode == "Epic") and (#MiniMount_Mounts_Epic == 0) then
		mode = "Regular";
	end
	if (mode == "Regular") and (#MiniMount_Mounts_Regular == 0) then
		MiniMount_Msg(MINIMOUNT_NOMOUNTS_USABLE,"error");
		NextMount = "error";
		return;
	end

	if (mode == "SwimRegular") then
		CurrentMountType = "Swim";
	end

	if (mode == "Regular") or (mode == "Epic") then
		CurrentMountType = "Ground";
	else
		CurrentMountType = "Fly";
	end

--[[
	for type, v in pairs(MiniMount_MountZones) do
		for mountid,v2 in pairs(MiniMount_MountZones[type]) do
			local cdb = getglobal("MiniMount_Mounts_"..type);
			local hasvar = false;
			for x=1,#cdb do
				local _, _, MountSID = GetCompanionInfo("MOUNT",cdb[x]);
				if tostring(MountSID) == mountid then
					hasvar = x;
				end
			end
			if hasvar ~= false then	
				local iszone = false;
				for x=1,#v2 do
					if v2[x] == czone then
						iszone = true;
					end
				end
				if iszone == false then
					tremove(cdb, hasvar);
				end
			end
		end
	end
]]

	MountList = getglobal("MiniMount_Mounts_"..mode);
	local chk_flyef, chk_flye, chk_flys, chk_ge, chk_gs = nil, nil, nil, nil, nil;
	while (type(MountList) == nil) do
		if (MiniMount_FlyZone(CurrentContinent, MiniMount_CanNorthrendFly) == true) then
			if chk_flyef == nil then
				if (#MiniMount_Mounts_FlyEpicFast > 0) then
					MountList = MiniMount_Mounts_FlyEpicFast;
				else
					chk_flyef = 1;
				end
			elseif chk_flye == nil then
				if (#MiniMount_Mounts_FlyEpic > 0) then
					MountList = MiniMount_Mounts_FlyEpic;
				else
					chk_flye = 1;
				end
			elseif chk_flys == nil then
				if (#MiniMount_Mounts_FlyRegular > 0) then
					MountList = MiniMount_Mounts_FlyRegular;
				else
					chk_flys = 1;
				end
			elseif chk_ge == nil then
				if (#MiniMount_Mounts_Epic > 0) then
					MountList = MiniMount_Mounts_Epic;
				else
					chk_ge = 1;
				end
			else
				if (#MiniMount_Mounts_Regular > 0) then
					MountList = MiniMount_Mounts_Regular;
				else
					chk_gs = 1;
				end
			end
		else
			if chk_ge == nil then
				if (#MiniMount_Mounts_Epic > 0) then
					MountList = MiniMount_Mounts_Epic;
				else
					chk_ge = 1;
				end
			elseif chk_gs == nil then
				if (#MiniMount_Mounts_Regular > 0) then
					MountList = MiniMount_Mounts_Regular;
				else
					chk_ge = 1;
				end
			end
		end
		if chk_flye == 1 and chk_flys == 1 and chk_ge == 1 and chk_gs == 1 then
			MiniMount_Msg(MINIMOUNT_ERROR_MOUNTDATABASEEMPTY,"error");
			return;
		end
	end
--[[
	if #MiniMount_Mounts_Unknown > 0 then
		for k,v in pairs(MiniMount_Mounts_Unknown) do
			tinsert(MountList, MiniMount_Mounts_Unknown[k]);
		end
	end
]]

	local randnum = random(1,#MountList);
	NextMount = MountList[randnum];
	MiniMount_Timer("Macro",1,MiniMount_Macro);
end

function MiniMount_BuildMountArrays()
	local num = GetNumCompanions("MOUNT");
	if MiniMount_RidingSkill == nil then
		MiniMount_RidingSkill = MiniMount_GetRidingSkill();
	end
	local czone = GetRealZoneText();

	if num == 0 then
		return;
	end

	local mymounts = {};

	for x=1, num do
		local _, MountName, MountSID = GetCompanionInfo("MOUNT",x);
		
		for y=1,#MiniMount_Mounts["Slow"] do
			if MiniMount_Mounts["Slow"][y] == tostring(MountSID) then
				tinsert(MiniMount_Mounts_Slow, (#MiniMount_Mounts_Slow+1), x);
			end
		end
		for y=1,#MiniMount_Mounts["Regular"] do
			if MiniMount_Mounts["Regular"][y] == tostring(MountSID) then
				tinsert(MiniMount_Mounts_Regular, (#MiniMount_Mounts_Regular+1), x);
			end
		end
		for y=1,#MiniMount_Mounts["Epic"] do
			if MiniMount_Mounts["Epic"][y] == tostring(MountSID) then
				tinsert(MiniMount_Mounts_Epic, (#MiniMount_Mounts_Epic+1), x);
			end
		end
		for y=1,#MiniMount_Mounts["FlyRegular"] do
			if MiniMount_Mounts["FlyRegular"][y] == tostring(MountSID) then
				tinsert(MiniMount_Mounts_FlyRegular, (#MiniMount_Mounts_FlyRegular+1), x);
			end
		end
		for y=1,#MiniMount_Mounts["FlyEpic"] do
			if MiniMount_Mounts["FlyEpic"][y] == tostring(MountSID) then
				tinsert(MiniMount_Mounts_FlyEpic, (#MiniMount_Mounts_FlyEpic+1), x);
			end
		end
		for y=1,#MiniMount_Mounts["FlyEpicFast"] do
			if MiniMount_Mounts["FlyEpicFast"][y] == tostring(MountSID) then
				tinsert(MiniMount_Mounts_FlyEpicFast, (#MiniMount_Mounts_FlyEpicFast+1), x);
			end
		end
		for y=1,#MiniMount_Mounts["Shifting"] do
			if MiniMount_Mounts["Shifting"][y] == tostring(MountSID) then
				tinsert(MiniMount_Mounts_Regular, (#MiniMount_Mounts_Regular+1), x);
				tinsert(MiniMount_Mounts_Epic, (#MiniMount_Mounts_Epic+1), x);
			end
		end
		for y=1,#MiniMount_Mounts["FlyShifting"] do
			if MiniMount_Mounts["FlyShifting"][y] == tostring(MountSID) then
				tinsert(MiniMount_Mounts_FlyRegular, (#MiniMount_Mounts_FlyRegular+1), x);
				tinsert(MiniMount_Mounts_FlyEpic, (#MiniMount_Mounts_FlyEpic+1), x);
				if (#MiniMount_Mounts_FlyEpicFast>0) then
					tinsert(MiniMount_Mounts_FlyEpicFast, (#MiniMount_Mounts_FlyEpicFast+1), x);
				end
			end
		end
		for y=1,#MiniMount_Mounts["FullShifting"] do
			if MiniMount_Mounts["FullShifting"][y] == tostring(MountSID) then
				tinsert(MiniMount_Mounts_Regular, (#MiniMount_Mounts_Regular+1), x);
				tinsert(MiniMount_Mounts_Epic, (#MiniMount_Mounts_Epic+1), x);
				tinsert(MiniMount_Mounts_FlyRegular, (#MiniMount_Mounts_FlyRegular+1), x);
				tinsert(MiniMount_Mounts_FlyEpic, (#MiniMount_Mounts_FlyEpic+1), x);
				if (#MiniMount_Mounts_FlyEpicFast>0) then
					tinsert(MiniMount_Mounts_FlyEpicFast, (#MiniMount_Mounts_FlyEpicFast+1), x);
				end
			end
		end
		for y=1,#MiniMount_Mounts["SwimRegular"] do
			if MiniMount_Mounts["SwimRegular"][y] == tostring(MountSID) then
				tinsert(MiniMount_Mounts_SwimRegular, (#MiniMount_Mounts_SwimRegular+1), x);
			end
		end

		if (tostring(MountSID) == 25953) then
			tinsert(MiniMount_Mounts_AQ, (#MiniMount_Mounts_AQ+1), x);
		end
		if (tostring(MountSID) == 26054) then
			tinsert(MiniMount_Mounts_AQ, (#MiniMount_Mounts_AQ+1), x);
		end
		if (tostring(MountSID) == 26055) then
			tinsert(MiniMount_Mounts_AQ, (#MiniMount_Mounts_AQ+1), x);
		end
		if (tostring(MountSID) == 26056) then
			tinsert(MiniMount_Mounts_AQ, (#MiniMount_Mounts_AQ+1), x);
		end

		if MiniMount_MountZones[czone] then
			for type, v in pairs(MiniMount_MountZones[czone]) do
				for x=1, #MiniMount_MountZones[czone][type] do
					if MiniMount_MountZones[czone][type][x] == tostring(MountSID) then
						local db = getglobal("MiniMount_Mounts_"..type);
						tinsert(db, (#db+1), MiniMount_MountZones[czone][type][x]);
					end
				end
			end
		end

--[[
		for type, v in pairs(MiniMount_MountZones) do
			for mountid, v2 in pairs(MiniMount_MountZones[type]) do
				if mountid == tostring(MountSID) then
					local db = getglobal("MiniMount_Mounts_"..type);
					tinsert(db, (#db+1), x);
					-- MiniMount_Msg("Inserting Mount #"..x..", the "..MountName..", MountSID: "..mountid..", into MiniMount_Mounts_"..type)
				end
			end
		end
]]

		local count1, count2, count3, count4, count5, count6, count7, count8 = 0,0,0,0,0,0,0,0;

		for z=1,#MiniMount_Mounts_Slow do
			if MiniMount_Mounts_Slow[z] == x then
				count1 = count1 + 1;
			end
		end
		for z=1,#MiniMount_Mounts_Regular do
			if MiniMount_Mounts_Regular[z] == x then
				count2 = count2 + 1;
			end
		end
		for z=1,#MiniMount_Mounts_Epic do
			if MiniMount_Mounts_Epic[z] == x then
				count3 = count3 + 1;
			end
		end
		for z=1,#MiniMount_Mounts_FlyRegular do
			if MiniMount_Mounts_FlyRegular[z] == x then
				count4 = count4 + 1;
			end
		end
		for z=1,#MiniMount_Mounts_FlyEpic do
			if MiniMount_Mounts_FlyEpic[z] == x then
				count5 = count5 + 1;
			end
		end
		for z=1,#MiniMount_Mounts_FlyEpicFast do
			if MiniMount_Mounts_FlyEpicFast[z] == x then
				count6 = count6 + 1;
			end
		end
		for z=1,#MiniMount_Mounts_SwimRegular do
			if MiniMount_Mounts_SwimRegular[z] == x then
				count7 = count7 + 1;
			end
		end
		for z=1,#MiniMount_Mounts_AQ do
			if MiniMount_Mounts_AQ[z] == x then
				count8 = count8 + 1;
			end
		end

		if (count1==0) and (count2==0) and (count3==0) and (count4==0) and (count5==0) and (count6==0) and (count7==0) and (count8==0) then
			tinsert(MiniMount_Mounts_Unknown, x);
		end
	end

	-- Now for item mounts
	-- ItemID for Magic Broom: 37011

--[[
	-- Error Reporting
	if #MiniMount_Mounts_Unknown > 0 then
		for y=1, #MiniMount_Mounts_Unknown do
			local _, MountName, MountSID = GetCompanionInfo("MOUNT",MiniMount_Mounts_Unknown[y]);
			if not MiniMount_ReportedMounts[MountSID] then
				Reported = false;
			end
		end
		if Reported == false then
			MiniMount_Msg(MINIMOUNT_UNKNOWNMOUNTSFOUND,"error");
			Reported = true;
		end
		for y=1, #MiniMount_Mounts_Unknown do
			local _, MountName, MountSID = GetCompanionInfo("MOUNT",MiniMount_Mounts_Unknown[y]);
			if not MiniMount_ReportedMounts[MountSID] then
				tinsert(MiniMount_ReportedMounts, MountSID, MountName);
				MiniMount_Msg(MINIMOUNT_REPORTMOUNT.."SpellID: "..MountSID.." = "..MountName,"error");
			end
		end
	end

]]
end

function MiniMount_Macro()
	if GetNumCompanions("MOUNT") == 0 then
		return;
	end
	if NextMount == nil then return end
	local _, MountName = GetCompanionInfo("MOUNT",NextMount);

	if MiniMount_NameAdjustment[MountName] then
		MountName = MiniMount_NameAdjustment[MountName];
	end

	local Prepare = MiniMount_MountPrepare();

	local text = "#showtooltip "..tostring(MountName).."\n/dismount [btn:2,nomod,noflying][mod:ctrl]\n/stopmacro [btn:2][mod:ctrl]"..Prepare.."\n/mm [btn:3] new\n/mm [btn:1]";

	-- Special Macro Setup if we're in Oculus!
	local zone = GetZoneText();
	if (zone == MINIMOUNT_INSTANCE_THEOCULUS) then
		local item;
		if (GetItemCount(37815)>0) then
			item = 37815; -- Emerald Essence
		elseif (GetItemCount(37859)>0) then
			item = 37859; -- Amber Essence
		elseif (GetItemCount(37860)>0) then
			item = 37860; -- Ruby Essence
		else
			item = NULL;
		end
		if (item ~= NULL) then
			local itemname = GetItemInfo(item);
			text = "#showtooltip\n/use "..itemname;
		end
	end

	local index = GetMacroIndexByName(MINIMOUNT_TITLE);
	if index == 0 then
		CreateMacro(MINIMOUNT_TITLE, 1, text, 0);
		-- MiniMount_Msg(MINIMOUNT_MACROCREATED);
	else
		EditMacro(index,MINIMOUNT_TITLE,1,text);
	end
end

--== Helper Functions ==--

function MiniMount_DetermineNorthrendFly()
	if UnitLevel("player") < 68 then
		return;
	end

	-- Get the link for Cold-Weather (Northrend) Flying
	local link = GetSpellLink(54197);

	local _, _, offset, numSpells = GetSpellTabInfo(1);
   
	for s = offset + 1, offset + numSpells do
		local spelllink = GetSpellLink(s, BOOKTYPE_SPELL);

		if spelllink == link then
			MiniMount_CanNorthrendFly = true;
			break;
		end
	end
end