--[[
	Helper Functions
	v1.8
]]

-- Let's us sort tables!
function MiniMount_pairsByKeys (t, f)
	local a = {}
		for n in pairs(t) do table.insert(a, n) end
		table.sort(a, f)
		local i = 0      -- iterator variable
		local iter = function ()   -- iterator function
			i = i + 1
			if a[i] == nil then return nil
			else return a[i], t[a[i]]
			end
		end
	return iter
end

-- Get the current Riding Skill Level
function MiniMount_GetRidingSkill()
	local num = GetNumSkillLines();
	local skill = 1;

	-- Localization (Required part)
	local mm_riding = "Riding";
	if GetLocale() == "deDE" then		-- German
		mm_riding = "Reiten";
	elseif GetLocale() == "frFR" then	-- French
		mm_riding = "Equitation";
	elseif GetLocale() == "esES" then	-- Spanish
		mm_riding = "Equitacin";
	elseif GetLocale() == "esMX" then	-- Mexican
		mm_riding = "Equitacin";
	elseif GetLocale() == "koKR" then	-- Korean
		mm_riding = "??";
	elseif GetLocale() == "zhCN" then	-- Chinese (Standard)
		mm_riding = "??";
	elseif GetLocale() == "zhTW" then	-- Chinese (Traditional)
		mm_riding = "??";
	elseif GetLocale() == "ruRU" then	-- Russian
		mm_riding = "???????";
	end

	for x=1,num do
		local skillName, isHeader, _, skillRank = GetSkillLineInfo(x);
		if isHeader == nil then
			if skillName == mm_riding then
				skill = tonumber(skillRank);
			end
		end
	end

	if (type(skill) ~= "number") then
		return 1;
	end
	return skill;
end

-- Do Preperations for Classes (If possible)
function MiniMount_MountPrepare()
	local _, Class = UnitClass("player");

	-- Remove a Druid's Shapeshift
	if Class == "DRUID" then
		return "\n/cancelform [noswimming]";
	-- Remove a Shaman's Shapeshift
	elseif Class == "SHAMAN" then
		return "\n/cancelform [noswimming]";
	end

	return "";
end

-- Is it possible to fly at all in this zone?
function MiniMount_FlyZone(cc,cnf)
	local output = nil;
	local mode = MiniMount_ZoneSmart();
	local zone = GetZoneText();

	if (cc == 3) or ((cc == 4) and (cnf == true)) then
		local d = false;
		if (cc == 4) and (zone == MINIMOUNT_ZONE_WINTERGRASP) and (GetWintergraspWaitTime() == nil) then
			return nil;
		else 
			output = true;
			if mode == "ground" then
				output = nil;
			end
		end
	end

	return output;
end

-- Timer function
function MiniMount_Timer(name,targettime,functiontodo, ...)
	local framename = "MiniMountFrame"..name;
	if getglobal(framename) and (getglobal(framename):GetScript("OnUpdate") ~= nil) then
		return;
	end

	local funcvar1, funcvar2, funcvar3, funcvar4 = ...;

	local frame = CreateFrame("Frame", framename);
	
	local totalElapsed = 0.0;
	local tickcount = 0;

	local function QuestReward_onUpdate(self, elapsed)
		totalElapsed = totalElapsed + elapsed;
		if (totalElapsed < 1) then return; end
		totalElapsed = totalElapsed - floor(totalElapsed);
		tickcount = tickcount + 1;

		if (tickcount == targettime) then
			local result = functiontodo(funcvar1, funcvar2, funcvar3, funcvar4);
			frame:SetScript("OnUpdate", nil);
			return result;
		end
		-- Enable for timing debugging
		-- ChatFrame1:AddMessage("tick... "..tickcount);
	end
	frame:SetScript("OnUpdate", QuestReward_onUpdate);
	frame:Show();
end

-- ItemID info
function MiniMount_GetItemID(itemlink)
	if (itemlink == nil) or (strfind(itemlink,":") == nil) then
		return;
	end

	local justItemId = string.gsub(itemlink,".-\124H([^\124]*)\124h.*", "%1");
	local type, itemid, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = strsplit(":",justItemId);

	return itemid;
end