--MageGate--
-- Written by: Endar_Ren
-- 
-- 
--  
-- Version 1.1 Changes 8/25/2010
-- *  Fixed use of addon when a target or a group member is casting a portal.
-- *  Corrected GateGroup function so that the Party channel is used outside of an instance.
-- *  Corrected spelling error:  "Dailing".
--
-- Version 1.2 Changes 10/5/10
-- *  Fixed the nothing happening in Party group type. (I think)

local frame = CreateFrame("Frame", nil, UIParent);



channeling =false;

--This function is used to determine which kind of group,
--if any, the player is in.  It returns the channel name
--needed to reach all the players in that group.
--The return value is a String.

function GateGroup ()

	if (UnitInParty("player") ~= nil) then
		if (UnitInRaid("player") ~= nil) then
			return "RAID"
		end
		return "PARTY"
	end
	return "SAY"
end

function GateEvent (self, event, unitID,spell,...)

	if (event == "ADDON_LOADED") then
		if (unitID =="Gate") then
			print ("Mage Gate loaded.  Version 1.0.");
		end
	end
	if (channeling == false) then
		if (event == "UNIT_SPELLCAST_START") then

			
			local beg, last = string.find(spell,"Portal: ");

			if (beg~=nil) then
				if (unitID == "player") then
					local chann = GateGroup();
					channeling = true;
					SendChatMessage("Dialing ".. string.sub(spell,last+1) ..".", chann);

				end
				
			end

		end

	
	elseif (channeling == true) then

		if (event == "UNIT_SPELLCAST_SUCCEEDED") then

	
			local beg, last = string.find(spell,"Portal: ");
			if (beg~=nil) then
				if (unitID == "player") then
					local chann = GateGroup();
					channeling = false;
					SendChatMessage("Chevron 7 locked!", chann);

				end
			end

	
		elseif (event == "UNIT_SPELLCAST_FAILED_QUIET") then


		
			local beg, last = string.find(spell,"Portal: ");
			if (beg~=nil) then
				if (unitID == "player") then
					local chann = GateGroup();
					channeling = false;
					SendChatMessage("Dialing sequence aborted!", chann);

				end
			end
		

	
		elseif (event == "UNIT_SPELLCAST_INTERRUPTED") then


			local beg, last = string.find(spell,"Portal: ");
			if (beg~=nil) then
				if (unitID == "player") then
					local chann = GateGroup();
					channeling = false;
					SendChatMessage("Dialing sequence aborted!", chann);

				end
			end
		

		end
	end
end



frame:SetScript("OnEvent", GateEvent)
frame:RegisterEvent("ADDON_LOADED")
frame:RegisterEvent("UNIT_SPELLCAST_START")
frame:RegisterEvent("UNIT_SPELLCAST_STOP")
frame:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
frame:RegisterEvent("UNIT_SPELLCAST_FAILED_QUIET")
frame:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED") 