_, class = UnitClass("player")
if class == "MAGE" then

local ADDON_NAME, namespace = ...
local L = namespace.L

MCStolenSpells = {}

MCspellstealbuffer, MCspellstealtime, MCspellstealcounter = 1, 0, 0
MCstealing = nil
MCtimerbypass = 0


-- Expanding icon display after stealing spell
function MageCandy_MCSpellStealNotificationOnUpdate(elapsed)
MCspellstealtime = MCspellstealtime + elapsed
MCspellstealcounter = MCspellstealcounter + elapsed
if MCspellstealtime >= MCspellstealbuffer then
MCSpellStealNotification:Hide()
MCSpellStealNotification:SetScale(1)
MCSpellStealNotification:SetAlpha(1)
MCspellstealtime = 0
MCspellstealcounter = 0
end
if MCspellstealcounter >= 0.01 then
MCSpellStealNotification:SetScale(MCSpellStealNotification:GetScale() + 0.11)
MCSpellStealNotification:SetAlpha(MCSpellStealNotification:GetAlpha() - 0.01)
MCspellstealcounter = MCspellstealcounter - 0.01
end
end

function MageCandy_UpdateSpellStealAuras(unit)
if unit == "player" then
MageCandy_UpdateStolenInfo()
end

local frame, framename, frameicon, framecount, framecooldown
local bufftable = {}

-- Scan for stealable buffs
for idx = 1, 40 do
local name, rank, icon, count, debufftype, duration, expirationtime, caster, stealable, _ , spellid = UnitBuff(unit, idx)
if name ~= nil then
if #bufftable ~= 12 then
if debufftype == "Magic" then
table.insert(bufftable, {name = name, icon = icon, count = count, debufftype = debufftype, duration = duration, expirationtime = expirationtime, 
caster = caster, stealable = stealable, spellid = spellid, buffindex = idx})
end
else
break
end
else 
break
end
end

-- Hide Unused Frames
if #bufftable == nil or #bufftable == 0 then 
if unit == "target" then
MCTargetSpellStealFrame:Hide()
elseif unit == "focus" then
MCFocusSpellStealFrame:Hide()
end
if unit ~= "player" then 
return 
end
else
if unit == "target" and UnitIsEnemy("player", "target") then
MCTargetSpellStealFrame:Show()
elseif unit == "focus" and UnitIsEnemy("player","focus") then
MCFocusSpellStealFrame:Show()
end
end

if unit == "player" and (#MCStolenSpells == nil or #MCStolenSpells == 0) then
MCStolenSpellsFrame:Hide()
elseif unit == "player" then
MCStolenSpellsFrame:Show()
end

if #bufftable ~= nil and #bufftable ~= 0 then
if unit == "target" then

-- Create Target Buff Frames
for idx = 1, #bufftable do
if (not _G["MCTargetSpellStealFrameBuff"..idx]) then
CreateFrame("Button", "MCTargetSpellStealFrameBuff"..idx, MCTargetSpellStealFrame, "TargetBuffFrameTemplate");
frame = _G["MCTargetSpellStealFrameBuff"..idx]
frame:SetWidth(21)
frame:SetHeight(21)

if MageCandy_Profiles[MageCandy_ActiveProfile].options.flipbuffs == 1 then
if idx == 1 then 
frame:SetPoint("BOTTOMLEFT", MCTargetSpellStealFrame, "BOTTOMLEFT", 5.5, 5.5)
elseif idx == 7 then
frame:SetPoint("BOTTOMLEFT", MCTargetSpellStealFrameBuff1, "TOPLEFT", 0, 3)
else
frame:SetPoint("LEFT", _G["MCTargetSpellStealFrameBuff"..idx-1], "RIGHT", 3, 0)
end
else
if idx == 1 then 
frame:SetPoint("TOPLEFT", MCTargetSpellStealFrame, "TOPLEFT", 5.5, -5.5)
elseif idx == 7 then
frame:SetPoint("TOPLEFT", MCTargetSpellStealFrameBuff1, "BOTTOMLEFT", 0, -3)
else
frame:SetPoint("LEFT", _G["MCTargetSpellStealFrameBuff"..idx-1], "RIGHT", 3, 0)
end
end

end

frame = _G["MCTargetSpellStealFrameBuff"..idx]
framename = "MCTargetSpellStealFrameBuff"..idx

frame:SetScript("OnEnter", function(self) 
-- Anchor to the parent frame because the games code does what it wants with tooltips on numbered buff frames regardless of the buff index you put in
GameTooltip:SetOwner(MCTargetSpellStealFrame)  
GameTooltip:SetUnitBuff(unit, bufftable[idx].buffindex)
GameTooltip:Show()
end)
frame:SetScript("OnLeave", function() 
GameTooltip:Hide() 
end)

frame.unit = unit

frame:SetID(idx)

frameicon = _G[framename.."Icon"]
frameicon:SetAllPoints()
frameicon:SetTexture(bufftable[idx].icon)

framecount = _G[framename.."Count"]

if (bufftable[idx].count > 1) then
framecount:SetText(bufftable[idx].count)
framecount:Show()
else
framecount:Hide()
end

framecooldown = _G[framename.."Cooldown"]

if (bufftable[idx].duration > 0) then
framecooldown:Show()
CooldownFrame_SetTimer(framecooldown, bufftable[idx].expirationtime - bufftable[idx].duration, bufftable[idx].duration, 1)
else 
framecooldown:Hide()
end
_G["MCTargetSpellStealFrameBuff"..idx]:Show()
end
if #bufftable < 12 then
for idx = #bufftable + 1, 12 do
if _G["MCTargetSpellStealFrameBuff"..idx] then
_G["MCTargetSpellStealFrameBuff"..idx]:Hide()
end
end
end
end
end

-- Create Focus Buff Frames
if #bufftable ~= nil and #bufftable ~= 0 then
if unit == "focus" then

for idx = 1, #bufftable do
if (not _G["MCFocusSpellStealFrameBuff"..idx]) then
CreateFrame("Button", "MCFocusSpellStealFrameBuff"..idx, MCFocusSpellStealFrame, "TargetBuffFrameTemplate");
frame = _G["MCFocusSpellStealFrameBuff"..idx]
frame:SetWidth(21)
frame:SetHeight(21)

if MageCandy_Profiles[MageCandy_ActiveProfile].options.flipbuffs == 1 then
if idx == 1 then 
frame:SetPoint("BOTTOMLEFT", MCFocusSpellStealFrame, "BOTTOMLEFT", 5.5, 5.5)
elseif idx == 7 then
frame:SetPoint("BOTTOMLEFT", MCFocusSpellStealFrameBuff1, "TOPLEFT", 0, 3)
else
frame:SetPoint("LEFT", _G["MCFocusSpellStealFrameBuff"..idx-1], "RIGHT", 3, 0)
end
else
if idx == 1 then 
frame:SetPoint("TOPLEFT", MCFocusSpellStealFrame, "TOPLEFT", 5.5, -5.5)
elseif idx == 7 then
frame:SetPoint("TOPLEFT", MCFocusSpellStealFrameBuff1, "BOTTOMLEFT", 0, -3)
else
frame:SetPoint("LEFT", _G["MCFocusSpellStealFrameBuff"..idx-1], "RIGHT", 3, 0)
end
end

end

frame = _G["MCFocusSpellStealFrameBuff"..idx]
framename = "MCFocusSpellStealFrameBuff"..idx

frame:SetScript("OnEnter", function(self) 
GameTooltip:SetOwner(MCFocusSpellStealFrame)  
GameTooltip:SetUnitBuff(unit, bufftable[idx].buffindex)
GameTooltip:Show()
end)
frame:SetScript("OnLeave", function() 
GameTooltip:Hide() 
end)

frame.unit = unit

frame:SetID(idx)

frameicon = _G[framename.."Icon"]
frameicon:SetAllPoints()
frameicon:SetTexture(bufftable[idx].icon)

framecount = _G[framename.."Count"]

if (bufftable[idx].count > 1) then
framecount:SetText(bufftable[idx].count)
framecount:Show()
else
framecount:Hide()
end

framecooldown = _G[framename.."Cooldown"]

if (bufftable[idx].duration > 0) then
framecooldown:Show()
CooldownFrame_SetTimer(framecooldown, bufftable[idx].expirationtime - bufftable[idx].duration, bufftable[idx].duration, 1)
else 
framecooldown:Hide()
end
_G["MCFocusSpellStealFrameBuff"..idx]:Show()
end
if #bufftable < 12 then
for idx = #bufftable + 1, 12 do
if _G["MCFocusSpellStealFrameBuff"..idx] then
_G["MCFocusSpellStealFrameBuff"..idx]:Hide()
end
end
end
end
end
if unit == "player" then
if #MCStolenSpells ~= nil and #MCStolenSpells ~= 0 then

for idx = 1, #MCStolenSpells do

if (not _G["MCStolenSpellsFrameBuff"..idx]) then
CreateFrame("Button", "MCStolenSpellsFrameBuff"..idx, MCStolenSpellsFrame, "TargetBuffFrameTemplate");
frame = _G["MCStolenSpellsFrameBuff"..idx]
frame:SetWidth(21)
frame:SetHeight(21)

if MageCandy_Profiles[MageCandy_ActiveProfile].options.flipbuffs == 1 then
if idx == 1 then 
frame:SetPoint("BOTTOMLEFT", MCStolenSpellsFrame, "BOTTOMLEFT", 5.5, 5.5)
elseif idx == 7 then
frame:SetPoint("BOTTOMLEFT", MCStolenSpellsFrameBuff1, "TOPLEFT", 0, 3)
else
frame:SetPoint("LEFT", _G["MCStolenSpellsFrameBuff"..idx-1], "RIGHT", 3, 0)
end
else
if idx == 1 then 
frame:SetPoint("TOPLEFT", MCStolenSpellsFrame, "TOPLEFT", 5.5, -5.5)
elseif idx == 7 then
frame:SetPoint("TOPLEFT", MCStolenSpellsFrameBuff1, "BOTTOMLEFT", 0, -3)
else
frame:SetPoint("LEFT", _G["MCStolenSpellsFrameBuff"..idx-1], "RIGHT", 3, 0)
end
end
end

frame = _G["MCStolenSpellsFrameBuff"..idx]
framename = "MCStolenSpellsFrameBuff"..idx

frame:SetScript("OnEnter", function(self) 
GameTooltip:SetOwner(MCStolenSpellsFrame)  
GameTooltip:SetUnitBuff(unit, MCStolenSpells[idx].buffindex)
GameTooltip:Show()
end)
frame:SetScript("OnLeave", function() 
GameTooltip:Hide() 
end)

frame.unit = unit

frame:SetID(idx)

frameicon = _G[framename.."Icon"]
frameicon:SetAllPoints()
frameicon:SetTexture(MCStolenSpells[idx].icon)

framecount = _G[framename.."Count"]

if (MCStolenSpells[idx].count > 1) then
framecount:SetText(MCStolenSpells[idx].count)
framecount:Show()
else
framecount:Hide()
end

framecooldown = _G[framename.."Cooldown"]

if (MCStolenSpells[idx].duration > 0) then
framecooldown:Show()
CooldownFrame_SetTimer(framecooldown, MCStolenSpells[idx].expirationtime - MCStolenSpells[idx].duration, MCStolenSpells[idx].duration, 1)
else 
framecooldown:Hide()
end
_G["MCStolenSpellsFrameBuff"..idx]:Show()
end

if #MCStolenSpells < 12 then
for idx = #MCStolenSpells + 1, 12 do
if _G["MCStolenSpellsFrameBuff"..idx] then
_G["MCStolenSpellsFrameBuff"..idx]:Hide()
end
end
end

end
end
end

function MageCandy_UpdateStolenSpells(event, spellname, triggertime)
local name, rank, icon, count, debufftype, duration, expirationtime, caster, stealable, _ , spellid, buffindex
if count == nil then count = 0 end
local update = false
for idx = 1, 40 do 
name, rank, icon, count, debufftype, duration, expirationtime, caster, stealable, _ , spellid = UnitBuff("player", idx)
buffindex = idx

if name == nil then 
update = true 
break 
end
if name == spellname and abs(triggertime - (expirationtime - duration)) < 0.2 then 
break 
end
end

if event == "SPELL_AURA_REFRESH" then


if MCstealing == spellname then
MCstealing = nil
end
-- scan to see if it is already stolen, and if it is, update the values
local index = MageCandy_GetStolenSpell(spellname)
if MCStolenSpells[MageCandy_GetStolenSpell(spellname)].name == spellname then
MCStolenSpells[index].name = name
MCStolenSpells[index].icon = icon
MCStolenSpells[index].count = count
MCStolenSpells[index].debufftype = debufftype
MCStolenSpells[index].duration = duration
MCStolenSpells[index].expirationtime = expirationtime 
MCStolenSpells[index].caster = caster
MCStolenSpells[index].stealable = stealable
MCStolenSpells[index].spellid = spellid
MCStolenSpells[index].buffindex = buffindex
update = true
end
-- if its not already recorded as stolen, do it now
if update == false then
if MCstealing == spellname then
MCstealing = nil
table.insert(MCStolenSpells, {name = name, icon = icon, count = count, debufftype = debufftype, duration = duration, expirationtime = expirationtime, 
caster = caster, stealable = stealable, spellid = spellid, buffindex = buffindex})
update = true
end
end

elseif event == "SPELL_AURA_APPLIED" or event == nil then
if MCstealing == spellname then
MCstealing = nil
table.insert(MCStolenSpells, {name = name, icon = icon, count = count, debufftype = debufftype, duration = duration, expirationtime = expirationtime, 
caster = caster, stealable = stealable, spellid = spellid, buffindex = buffindex})
update = true
end

elseif event == "SPELL_AURA_APPLIED_DOSE" then

if MCstealing == spellname then
MCstealing = nil
if MCStolenSpells[MageCandy_GetStolenSpell(spellname)].name == spellname then
MCStolenSpells[MageCandy_GetStolenSpell(spellname)].count = count
update = true
end
end

elseif event == "SPELL_AURA_REMOVED" then

if MCStolenSpells[MageCandy_GetStolenSpell(spellname)].name == spellname then
table.remove(MCStolenSpells, MageCandy_GetStolenSpell(spellname, triggertime, true))
update = true
end

elseif event == "SPELL_AURA_REMOVED_DOSE" then

if MCStolenSpells[MageCandy_GetStolenSpell(spellname)].name == spellname then
MCStolenSpells[MageCandy_GetStolenSpell(spellname)].count = count
if MCStolenSpells[MageCandy_GetStolenSpell(spellname)].count <= 0 then
table.remove(MCStolenSpells, MageCandy_GetStolenSpell(spellname))
update = true
end
end

end

if update then
update = false
MageCandy_UpdateSpellStealAuras("player")
end
end

function MageCandy_GetStolenSpell(spellname, triggertime, expired)
local index = nil
local tbl = {}

if expired == true then
for idx = 1, #MCStolenSpells do
if MCStolenSpells[idx].name == spellname then
table.insert(tbl, {index = idx, difference = abs(triggertime - MCStolenSpells[idx].expirationtime)})
end
end
table.sort(tbl, MageCandy_SortByDifference)
if tbl[1].index then return tbl[1].index end
else
for idx = 1, #MCStolenSpells do
if MCStolenSpells[idx].name == spellname then
index = idx
end
end
if index ~= nil then return index end
end

-- Create dummy entry for easy glitch fix
table.insert(MCStolenSpells, 13, {name = "dummy"})
return 13
end

function MageCandy_SortByDifference(a, b)
return a.difference < b.difference
end

function MageCandy_UpdateStolenInfo()
local removals = {}
-- Check for dummy entry and clear if it exists
if MCStolenSpells[13] then
if MCStolenSpells[13].name == "dummy" then
table.remove(MCStolenSpells, 13)
end
end

-- dump any extra spells, 12 is the max that will be displayed

if #MCStolenSpells > 12 then 
for idx = 13, #MCStolenSpells do
MCStolenSpells[idx] = nil
end
end
if #MCStolenSpells ~= 0 and #MCStolenSpells ~= nil then

for idx = 1, #MCStolenSpells do 
local index = idx

for idx = 1, 40 do
local name, rank, icon, count, debufftype, duration, expirationtime, caster, stealable, _ , spellid = UnitBuff("player", idx)
-- spell wasn't found, remove it. Somehow it was lost without an event triggering the removal.
if name == nil then table.insert(removals, {index = index}) break end
if MCStolenSpells[index].name == name and MCStolenSpells[index].expirationtime == expirationtime and MCStolenSpells[index].duration == duration then
MCStolenSpells[index].buffindex = idx
break
end
end
end

end

if #removals ~= 0 and #removals ~= nil then
for idx = 1, #removals do
table.remove(MCStolenSpells, removals[idx].index)
end
end

end

-- Put aside for overlay glow on buffs(a little bigger than the default so it doesnt hide the texture)
function MageCandy_ShowOverlayGlow(self)

if ( self.overlay ) then
if ( self.overlay.animOut:IsPlaying() ) then
self.overlay.animOut:Stop();
self.overlay.animIn:Play();
end
else
self.overlay = ActionButton_GetOverlayGlow();
----------
self.overlay.outerGlow:SetVertexColor(1,1,1)
self.overlay.ants:SetVertexColor(1,1,1)
----------
local frameWidth, frameHeight = self:GetSize();
self.overlay:SetParent(self);
self.overlay:ClearAllPoints();
--Make the height/width available before the next frame:
self.overlay:SetSize(frameWidth * 1.4, frameHeight * 1.4);
self.overlay:SetPoint("TOPLEFT", self, "TOPLEFT", -frameWidth * 0.3, frameHeight * 0.3);
self.overlay:SetPoint("BOTTOMRIGHT", self, "BOTTOMRIGHT", frameWidth * 0.3, -frameHeight * 0.3);
self.overlay.animIn:Play();
end

end

function MageCandy_SpellStolen(spellid, spellname)
local name, dummy2, texture, stack, dummy5, duration, exptime, player = UnitBuff("player", spellname)
MCSpellStealIcon:SetTexture(GetSpellTexture(spellid))
if MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcspellstealnotification == 1 then
MCSpellStealNotification:Show()
end
spelllink = GetSpellLink(spellid)
if MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcspellstealmessage == 1 then
print(L["STOLE"].." "..spelllink)
end
MCstealing = spellname
end

-- Currently not used but kept here for safe keeping(glowing stealable buffs)
function MageCandy_UpdateStealable(self)
local framename = self:GetName()
local unit
if framename == "TargetFrame" then unit = "target" elseif framename == "FocusFrame" then unit = "focus" else return end
for idx = 1, MAX_TARGET_BUFFS do
local buff = _G[framename.."Buff"..idx]
local glow = _G[framename.."Buff"..idx.."Stealable"]
local name,_2,_3,_4,_5,_6,_7,_8, stealable = UnitBuff(unit, idx)
if name == nil then break end
if debufftype == "Magic" then
glow:Hide()
MageCandy_ShowOverlayGlow(buff)
else
ActionButton_HideOverlayGlow(buff)
end
end
end

function MageCandy_CreateSpellStealMonitorUI()
local backdrop = {edgeFile = "Interface/Tooltips/UI-Tooltip-Border", edgeSize = 12}
local backdropthick = {edgeFile = "Interface/DialogFrame/UI-DialogBox-Border", edgeSize = 12}

-- Spellsteal Monitor -------------------------------------------------------------------

CreateFrame("Frame", "MCSpellStealNotification", UIParent)

MCSpellStealNotification:SetScript("OnEvent", function(self, event, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16)
if MCtimerbypass == 0 then

if event == "PLAYER_TARGET_CHANGED" then
if MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mctargetspellstealframe ~= 0 and MageCandy_Profiles[MageCandy_ActiveProfile].options.enablespellstealmonitor ~= 0 then
MageCandy_UpdateSpellStealAuras("target")
end
end

if event == "PLAYER_FOCUS_CHANGED" then
if MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcfocusspellstealframe ~= 0 and MageCandy_Profiles[MageCandy_ActiveProfile].options.enablespellstealmonitor ~= 0 then
MageCandy_UpdateSpellStealAuras("focus")
end
end

if event == "UNIT_AURA" then
if arg1 == "target" or arg1 == "focus" or arg1 == "player" then
if #MCStolenSpells ~= 0 and #MCStolenSpells ~= nil and MCstealing ~= nil and (arg1 == "player" and MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcstolenspellsframe ~= 0) and MageCandy_Profiles[MageCandy_ActiveProfile].options.enablespellstealmonitor ~= 0 then
MageCandy_UpdateSpellStealAuras(arg1)
elseif ((arg1 == "target" and MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mctargetspellstealframe ~= 0) or (arg1 == "focus" and MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcfocusspellstealframe ~= 0)) and MageCandy_Profiles[MageCandy_ActiveProfile].options.enablespellstealmonitor ~= 0 then
MageCandy_UpdateSpellStealAuras(arg1)
elseif arg1 == "player" then
MageCandy_UpdateStolenInfo(arg1)
end
end
end

if event == "COMBAT_LOG_EVENT_UNFILTERED" then
if arg2 == "SPELL_STOLEN" and arg4 == UnitGUID("player") and MageCandy_Profiles[MageCandy_ActiveProfile].options.enablespellstealmonitor ~= 0 then
MageCandy_SpellStolen(arg15, arg16)
elseif MCAuraEvents[arg2] then 
if arg8 == UnitGUID("player") and MageCandy_Profiles[MageCandy_ActiveProfile].options.enablespellstealmonitor ~= 0 and MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcstolenspellsframe ~= 0 then
MageCandy_UpdateStolenSpells(arg2, arg13, GetTime())
end
end
end

end
end)

MCSpellStealNotification:RegisterEvent("PLAYER_TARGET_CHANGED")
MCSpellStealNotification:RegisterEvent("PLAYER_FOCUS_CHANGED")
MCSpellStealNotification:RegisterEvent("UNIT_AURA")
MCSpellStealNotification:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")

MCSpellStealNotification:SetWidth(32)
MCSpellStealNotification:SetHeight(32)
MCSpellStealNotification:SetPoint("CENTER", UIParent, "CENTER")
MCSpellStealNotification:CreateTexture("MCSpellStealIcon")
MCSpellStealIcon:SetAllPoints()
MCSpellStealIcon:SetTexture("Interface\\Icons\\Spell_Arcane_Arcane02")
MCSpellStealNotification:Hide()

CreateFrame("Frame", "MCTargetSpellStealFrame", UIParent)
MCTargetSpellStealFrame:SetPoint("CENTER", UIParent, "CENTER", -250, 0)
MCTargetSpellStealFrame:SetHeight(56)
MCTargetSpellStealFrame:SetWidth(152)
CreateFrame("Frame", "MCTargetSpellStealFrameBackground", MCTargetSpellStealFrame)
MCTargetSpellStealFrameBackground:SetAllPoints()
MCTargetSpellStealFrameBackground:SetPoint("CENTER")
MCTargetSpellStealFrameBackground:CreateTexture("MCTargetSpellStealFrameBG", "BACKGROUND")
MCTargetSpellStealFrameBackground:SetFrameLevel(1)
MCTargetSpellStealFrameBG:SetWidth(MCTargetSpellStealFrame:GetWidth() - 5)
MCTargetSpellStealFrameBG:SetHeight(MCTargetSpellStealFrame:GetHeight() - 5)
MCTargetSpellStealFrameBG:SetPoint("CENTER")
MCTargetSpellStealFrameBG:SetTexture(0,0,0,.5)
MCTargetSpellStealFrameBackground:SetBackdrop(backdrop)
MCTargetSpellStealFrame:Hide()
MCTargetSpellStealFrame:CreateFontString("MCTargetSpellStealFrameHeader", "OVERLAY", "GameFontNormal")
MCTargetSpellStealFrameHeader:SetText(L["SPELLSTEAL_TARGET"])
MCTargetSpellStealFrameHeader:SetPoint("BOTTOM", MCTargetSpellStealFrame, "TOP", 0, 1)
MCTargetSpellStealFrameHeader:SetTextColor(0,1,1)


CreateFrame("Frame", "MCFocusSpellStealFrame", UIParent)
MCFocusSpellStealFrame:SetPoint("CENTER", UIParent, "CENTER", 250, 0)
MCFocusSpellStealFrame:SetHeight(56)
MCFocusSpellStealFrame:SetWidth(152)
CreateFrame("Frame", "MCFocusSpellStealFrameBackground", MCFocusSpellStealFrame)
MCFocusSpellStealFrameBackground:SetAllPoints()
MCFocusSpellStealFrameBackground:SetPoint("CENTER")
MCFocusSpellStealFrameBackground:CreateTexture("MCFocusSpellStealFrameBG", "BACKGROUND")
MCFocusSpellStealFrameBackground:SetFrameLevel(1)
MCFocusSpellStealFrameBG:SetWidth(MCFocusSpellStealFrame:GetWidth() - 5)
MCFocusSpellStealFrameBG:SetHeight(MCFocusSpellStealFrame:GetHeight() - 5)
MCFocusSpellStealFrameBG:SetPoint("CENTER")
MCFocusSpellStealFrameBG:SetTexture(0,0,0,.5)
MCFocusSpellStealFrame:Hide()
MCFocusSpellStealFrameBackground:SetBackdrop(backdrop)
MCFocusSpellStealFrame:CreateFontString("MCFocusSpellStealFrameHeader", "OVERLAY", "GameFontNormal")
MCFocusSpellStealFrameHeader:SetText(L["SPELLSTEAL_FOCUS"])
MCFocusSpellStealFrameHeader:SetPoint("BOTTOM", MCFocusSpellStealFrame, "TOP", 0, 1)
MCFocusSpellStealFrameHeader:SetTextColor(0,1,1)


CreateFrame("Frame", "MCStolenSpellsFrame", UIParent)
MCStolenSpellsFrame:SetPoint("CENTER", UIParent, "CENTER", 0, -150)
MCStolenSpellsFrame:SetHeight(56)
MCStolenSpellsFrame:SetWidth(152)
CreateFrame("Frame", "MCStolenSpellsFrameBackground", MCStolenSpellsFrame)
MCStolenSpellsFrameBackground:SetAllPoints()
MCStolenSpellsFrameBackground:SetPoint("CENTER")
MCStolenSpellsFrameBackground:CreateTexture("MCStolenSpellsFrameBG", "BACKGROUND")
MCStolenSpellsFrameBackground:SetFrameLevel(1)
MCStolenSpellsFrameBG:SetWidth(MCStolenSpellsFrame:GetWidth() - 5)
MCStolenSpellsFrameBG:SetHeight(MCStolenSpellsFrame:GetHeight() - 5)
MCStolenSpellsFrameBG:SetPoint("CENTER")
MCStolenSpellsFrameBG:SetTexture(0,0,0,.5)
MCStolenSpellsFrame:Hide()
MCStolenSpellsFrameBackground:SetBackdrop(backdrop)
MCStolenSpellsFrame:CreateFontString("MCStolenSpellsFrameHeader", "OVERLAY", "GameFontNormal")
MCStolenSpellsFrameHeader:SetText(L["STOLEN_SPELLS"])
MCStolenSpellsFrameHeader:SetPoint("BOTTOM", MCStolenSpellsFrame, "TOP", 0, 1)
MCStolenSpellsFrameHeader:SetTextColor(0,1,1)

-- Finish Setting Up Frames --
MCSpellStealNotification:EnableMouse(false)
MageCandy_SetupFrame(MCTargetSpellStealFrame)
MageCandy_SetupFrame(MCFocusSpellStealFrame)
MageCandy_SetupFrame(MCStolenSpellsFrame)
end

function MageCandy_CreatePolymorphMonitorOptionsMenu()
local x, y, xoff, yoff = 0, 0, 15, -20
-- Spellsteal Monitor --------------------------------------------------
MageCandy.ssmonitor = CreateFrame("Frame", "MCSpellStealMonitorOptions", MCOptionsFrame)
MageCandy.ssmonitor:SetWidth(625)
MageCandy.ssmonitor:SetHeight(570)
MageCandy.ssmonitor:SetPoint("LEFT", MCOptionsFrameButtons, "RIGHT", 5, 0)
MageCandy.ssmonitor.name = L["SPELLSTEAL_MONITOR"]

MCTestSSAnimation = CreateFrame("Button", "MCTestSSAnimation", MageCandy.ssmonitor, "UIPanelButtonTemplate")
MCTestSSAnimation:SetHeight(30)
MCTestSSAnimation:SetWidth(120)
MCTestSSAnimation:SetText(L["PLAY_ANIMATION"])
MCTestSSAnimation:ClearAllPoints()
MCTestSSAnimation:SetPoint("CENTER", MageCandy.ssmonitor, "CENTER", 0, -150)
MCTestSSAnimation:SetScript("OnClick", function () MCSpellStealNotification:Show() end)

------------------------------------------------------------------------
y = 0
y = y + yoff
MCSpellStealMonitorBackgroundShow = CreateFrame("CheckButton", "MCSpellStealMonitorBackgroundShow", MageCandy.ssmonitor, "ChatConfigCheckButtonTemplate")
MCSpellStealMonitorBackgroundShow:SetPoint("TOP", 15, y)
MCSpellStealMonitorBackgroundShowText:SetText(L["SPELLSTEAL_MONITOR_BACKGROUND_SHOW"])
MCSpellStealMonitorBackgroundShow:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcspellstealmonitorbackground)
------------------------------------------------------------------------
------------------------------------------------------------------------
y = y + yoff
MCSpellStealMonitorHeaderShow = CreateFrame("CheckButton", "MCSpellStealMonitorHeaderShow", MageCandy.ssmonitor, "ChatConfigCheckButtonTemplate")
MCSpellStealMonitorHeaderShow:SetPoint("TOP", 15, y)
MCSpellStealMonitorHeaderShowText:SetText(L["SPELLSTEAL_MONITOR_HEADER_SHOW"])
MCSpellStealMonitorHeaderShow:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcspellstealmonitorheader)
------------------------------------------------------------------------
y = y + yoff
MCSpellStealMonitorFlipBuffs = CreateFrame("CheckButton", "MCSpellStealMonitorFlipBuffs", MageCandy.ssmonitor, "ChatConfigCheckButtonTemplate")
MCSpellStealMonitorFlipBuffs:SetPoint("TOP", 15, y)
MCSpellStealMonitorFlipBuffsText:SetText(L["SPELLSTEAL_MONITOR_FLIP_BUFFS"])
MCSpellStealMonitorFlipBuffs:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.flipbuffs)
------------------------------------------------------------------------
y = y + yoff
MCSpellStealMessageShow = CreateFrame("CheckButton", "MCSpellStealMessageShow", MageCandy.ssmonitor, "ChatConfigCheckButtonTemplate")
MCSpellStealMessageShow:SetPoint("TOP", 15, y)
MCSpellStealMessageShowText:SetText(L["SPELLSTEAL_MESSAGE_SHOW"])
MCSpellStealMessageShow:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcspellstealmessage)
------------------------------------------------------------------------

------------------------------------------------------------------------
y = 0
y = y + yoff
MCEnableSpellStealMonitor = CreateFrame("CheckButton", "MCEnableSpellStealMonitor", MageCandy.ssmonitor, "ChatConfigCheckButtonTemplate")
MCEnableSpellStealMonitor:SetPoint("TOPLEFT", 15, y)
MCEnableSpellStealMonitorText:SetText(L["SPELLSTEAL_MONITOR_ENABLE"])
MCEnableSpellStealMonitor:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.enablespellstealmonitor)
------------------------------------------------------------------------
y = y + yoff
MCSpellStealNotificationShow = CreateFrame("CheckButton", "MCSpellStealNotificationShow", MageCandy.ssmonitor, "ChatConfigCheckButtonTemplate")
MCSpellStealNotificationShow:SetPoint("TOPLEFT", 15, y)
MCSpellStealNotificationShowText:SetText(L["SPELLSTEAL_NOTIFICATION_SHOW"])
MCSpellStealNotificationShow:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcspellstealnotification)
------------------------------------------------------------------------
y = y + yoff
MCTargetSpellStealFrameShow = CreateFrame("CheckButton", "MCTargetSpellStealFrameShow", MageCandy.ssmonitor, "ChatConfigCheckButtonTemplate")
MCTargetSpellStealFrameShow:SetPoint("TOPLEFT", 15, y)
MCTargetSpellStealFrameShowText:SetText(L["SPELLSTEAL_MONITOR_SHOW_TARGET"])
MCTargetSpellStealFrameShow:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mctargetspellstealframe)
------------------------------------------------------------------------
y = y + yoff
MCFocusSpellStealFrameShow = CreateFrame("CheckButton", "MCFocusSpellStealFrameShow", MageCandy.ssmonitor, "ChatConfigCheckButtonTemplate")
MCFocusSpellStealFrameShow:SetPoint("TOPLEFT", 15, y)
MCFocusSpellStealFrameShowText:SetText(L["SPELLSTEAL_MONITOR_SHOW_FOCUS"])
MCFocusSpellStealFrameShow:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcfocusspellstealframe)
------------------------------------------------------------------------
y = y + yoff
MCStolenSpellsFrameShow = CreateFrame("CheckButton", "MCStolenSpellsFrameShow", MageCandy.ssmonitor, "ChatConfigCheckButtonTemplate")
MCStolenSpellsFrameShow:SetPoint("TOPLEFT", 15, y)
MCStolenSpellsFrameShowText:SetText(L["SPELLSTEAL_MONITOR_SHOW_STOLEN"])
MCStolenSpellsFrameShow:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcstolenspellsframe)
-----------------------------------------------------------------------
y = y + (yoff * 4)
CreateFrame("Slider","MCTargetSpellStealFrameScale", MageCandy.ssmonitor)
MCTargetSpellStealFrameScale:SetPoint("TOPLEFT", 15, y)
MCTargetSpellStealFrameScale:SetWidth(600)
MCTargetSpellStealFrameScale:SetHeight(20)
MCTargetSpellStealFrameScale:SetOrientation("HORIZONTAL")
MCTargetSpellStealFrameScale:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCTargetSpellStealFrameScale:SetMinMaxValues(0.5,5)
MCTargetSpellStealFrameScale:SetValue(0.5151)
MCTargetSpellStealFrameScale:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCTargetSpellStealFrameScale:SetScript("OnValueChanged", function (self, value) MCTargetSpellStealFrameScaleText:SetText(string.sub(value, 1, 4)) MCTargetSpellStealFrame:SetScale(value) end)
MageCandy.ssmonitor:CreateFontString("MCTargetSpellStealFrameScaleHeader", "OVERLAY", "GameFontNormal")
MCTargetSpellStealFrameScaleHeader:SetPoint("BOTTOMLEFT", MCTargetSpellStealFrameScale, "TOPLEFT")
MCTargetSpellStealFrameScaleHeader:SetText(L["SPELLSTEAL_MONITOR_TARGET_SCALE"])
MageCandy.ssmonitor:CreateFontString("MCTargetSpellStealFrameScaleText", "OVERLAY", "GameFontNormal")
MCTargetSpellStealFrameScaleText:SetPoint("BOTTOMRIGHT", MCTargetSpellStealFrameScale, "TOPRIGHT")
MCTargetSpellStealFrameScaleText:SetText(string.sub(MageCandy_Profiles[MageCandy_ActiveProfile].options.scale.mctargetspellstealframe, 1, 4))
-----------------------------------------------------------------------
y = y + (yoff * 2)
CreateFrame("Slider","MCFocusSpellStealFrameScale", MageCandy.ssmonitor)
MCFocusSpellStealFrameScale:SetPoint("TOPLEFT", 15, y)
MCFocusSpellStealFrameScale:SetWidth(600)
MCFocusSpellStealFrameScale:SetHeight(20)
MCFocusSpellStealFrameScale:SetOrientation("HORIZONTAL")
MCFocusSpellStealFrameScale:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCFocusSpellStealFrameScale:SetMinMaxValues(0.5,5)
MCFocusSpellStealFrameScale:SetValue(0.5151)
MCFocusSpellStealFrameScale:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCFocusSpellStealFrameScale:SetScript("OnValueChanged", function (self, value) MCFocusSpellStealFrameScaleText:SetText(string.sub(value, 1, 4)) MCFocusSpellStealFrame:SetScale(value) end)
MageCandy.ssmonitor:CreateFontString("MCFocusSpellStealFrameScaleHeader", "OVERLAY", "GameFontNormal")
MCFocusSpellStealFrameScaleHeader:SetPoint("BOTTOMLEFT", MCFocusSpellStealFrameScale, "TOPLEFT")
MCFocusSpellStealFrameScaleHeader:SetText(L["SPELLSTEAL_MONITOR_FOCUS_SCALE"])
MageCandy.ssmonitor:CreateFontString("MCFocusSpellStealFrameScaleText", "OVERLAY", "GameFontNormal")
MCFocusSpellStealFrameScaleText:SetPoint("BOTTOMRIGHT", MCFocusSpellStealFrameScale, "TOPRIGHT")
MCFocusSpellStealFrameScaleText:SetText(string.sub(MageCandy_Profiles[MageCandy_ActiveProfile].options.scale.mcfocusspellstealframe, 1, 4))
-----------------------------------------------------------------------
y = y + (yoff * 2)
CreateFrame("Slider","MCStolenSpellsFrameScale", MageCandy.ssmonitor)
MCStolenSpellsFrameScale:SetPoint("TOPLEFT", 15, y)
MCStolenSpellsFrameScale:SetWidth(600)
MCStolenSpellsFrameScale:SetHeight(20)
MCStolenSpellsFrameScale:SetOrientation("HORIZONTAL")
MCStolenSpellsFrameScale:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCStolenSpellsFrameScale:SetMinMaxValues(0.5,5)
MCStolenSpellsFrameScale:SetValue(0.5151)
MCStolenSpellsFrameScale:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCStolenSpellsFrameScale:SetScript("OnValueChanged", function (self, value) MCStolenSpellsFrameScaleText:SetText(string.sub(value, 1, 4)) MCStolenSpellsFrame:SetScale(value) end)
MageCandy.ssmonitor:CreateFontString("MCStolenSpellsFrameScaleHeader", "OVERLAY", "GameFontNormal")
MCStolenSpellsFrameScaleHeader:SetPoint("BOTTOMLEFT", MCStolenSpellsFrameScale, "TOPLEFT")
MCStolenSpellsFrameScaleHeader:SetText(L["SPELLSTEAL_MONITOR_STOLEN_SCALE"])
MageCandy.ssmonitor:CreateFontString("MCStolenSpellsFrameScaleText", "OVERLAY", "GameFontNormal")
MCStolenSpellsFrameScaleText:SetPoint("BOTTOMRIGHT", MCStolenSpellsFrameScale, "TOPRIGHT")
MCStolenSpellsFrameScaleText:SetText(string.sub(MageCandy_Profiles[MageCandy_ActiveProfile].options.scale.mcstolenspellsframe, 1, 4))
-----------------------------------------------------------------------
y = y + (yoff * 2)
CreateFrame("Slider","MCSpellStealNotificationScale", MageCandy.ssmonitor)
MCSpellStealNotificationScale:SetPoint("TOPLEFT", 15, y)
MCSpellStealNotificationScale:SetWidth(600)
MCSpellStealNotificationScale:SetHeight(20)
MCSpellStealNotificationScale:SetOrientation("HORIZONTAL")
MCSpellStealNotificationScale:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCSpellStealNotificationScale:SetMinMaxValues(0.5,5)
MCSpellStealNotificationScale:SetValue(0.5151)
MCSpellStealNotificationScale:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCSpellStealNotificationScale:SetScript("OnValueChanged", function (self, value) 
MCSpellStealNotificationScaleText:SetText(string.sub(value, 1, 4)) 
MCSpellStealNotification:SetWidth(32 * value)
MCSpellStealNotification:SetHeight(32 * value)
end)
MageCandy.ssmonitor:CreateFontString("MCSpellStealNotificationScaleHeader", "OVERLAY", "GameFontNormal")
MCSpellStealNotificationScaleHeader:SetPoint("BOTTOMLEFT", MCSpellStealNotificationScale, "TOPLEFT")
MCSpellStealNotificationScaleHeader:SetText(L["SPELLSTEAL_MONITOR_NOTIFICATION_SCALE"])
MageCandy.ssmonitor:CreateFontString("MCSpellStealNotificationScaleText", "OVERLAY", "GameFontNormal")
MCSpellStealNotificationScaleText:SetPoint("BOTTOMRIGHT", MCSpellStealNotificationScale, "TOPRIGHT")
MCSpellStealNotificationScaleText:SetText(string.sub(MageCandy_Profiles[MageCandy_ActiveProfile].options.scale.mcspellstealnotification, 1, 4))

MageCandy.ssmonitor:Hide()
-------------------------------------------------------------------
end

end