_, class = UnitClass("player")
if class == "MAGE" then

local ADDON_NAME, namespace = ...
local L = namespace.L

local MCmanabarflash = false
local oldmana = 0
local changecolor = 0
local arcanepowermod, arcanechargemod = 1.1, 1.5 -- mana cost modifiers for arcane blast when under effects of arcane charge or arcane power
local calculatortimer, combatdelay, calculatorupdate = 0, 5, true

function MageCandy_ManaBarOnUpdate(elapsed)

if calculatorupdate == true then
calculatortimer = calculatortimer + elapsed
if calculatortimer >= 0.1 then
calculatortimer = calculatortimer - 0.1
MageCandy_UpdateSpellCalculator()
end
end

if combatdelay > 0 then
combatdelay = combatdelay - elapsed
if combatdelay <= 0 then
combatdelay = 0
calculatorupdate = false
end
end

if MCmanabarflash == true then
changecolor = changecolor + elapsed
if changecolor >= 1 then
changecolor = 0
MCManaBar:SetStatusBarColor(0.8, 0, 0)
elseif changecolor > 0.5 and changecolor < 1 then
MCManaBar:SetStatusBarColor(0, 0, 1)
elseif changecolor <= 0.5 then
MCManaBar:SetStatusBarColor(0.8, 0, 0)
end
else
changecolor = 0
MCManaBar:SetStatusBarColor(0, 0, 1)
end
end

function MageCandy_UpdateSpellCalculator()
local num, instant = 0, false
local mana, manamax = UnitMana("player"), UnitManaMax("player")
if mana > ((MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarreserve * 0.01) * manamax) then
if MageCandy_Profiles[MageCandy_ActiveProfile].options.input.calculatorspell ~= "" then
local _, combatregen = GetPowerRegen()
if combatregen == nil then combatregen = 0 end
local name, rank, icon, cost, isfunnel, powertype, casttime, minrange, maxrange = GetSpellInfo(MageCandy_Profiles[MageCandy_ActiveProfile].options.input.calculatorspell)
if casttime == nil then casttime = 0 else casttime = casttime / 1000 end
if casttime == 0 then
instant = true
end
local gcd = 1.5 / ((UnitSpellHaste("player") * 0.01) + 1)
if gcd < 1 then gcd = 1 end
if casttime < gcd then 
casttime = gcd 
end
if name == GetSpellInfo(44457) then casttime = 1 end --  living bomb has 1s gcd by default
local regen = combatregen * casttime

if tonumber(cost) == nil then cost = 0 end
if name == GetSpellInfo(30451) then -- arcane blast

local duration, expirationtime = MageCandy_ScanUnit("player", "buff", nil, 12042) -- arcane power
local arcanepower = 0
if expirationtime > 0 then
arcanepower = expirationtime - GetTime()
end

local charges, basecost, newcost

_, _, _, charges = UnitDebuff("player", GetSpellInfo(114664))
if charges == nil then charges = 0 end

if arcanepower > 0 then
basecost = cost / ((1 + (charges * arcanechargemod)) * arcanepowermod)
else
basecost = cost / (1 + (charges * arcanechargemod)) -- base cost of arcane blast via formula
end

local pool, poolmax = mana - (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarreserve * 0.01 * manamax), manamax - (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarreserve * 0.01 * manamax)

local manaleft = true

local spell, _, _, _, starttime, endtime = UnitCastingInfo("player")
if starttime == nil then starttime = 0 end
if endtime == nil then 
endtime = 0 
else
endtime = endtime / 1000
end
local castleft = endtime - GetTime()
if castleft > duration and spell == name then 
castleft = castleft - duration
else
castleft = 0
end
local checkcast = false

if charges ~= 4 then
charges = charges + 1
num = num + 1
if castleft > 0 then
pool = pool + (castleft * combatregen)
else
pool = pool + regen -- factor in regen based on cast time of the spell for uber accuracy
end
if pool > poolmax then
pool = poolmax
end 
if castleft > 0 then
arcanepower = arcanepower - castleft
else
arcanepower = arcanepower - casttime
end
if arcanepower < 0 then arcanepower = 0 end
if arcanepower > 0 then
pool = pool - ((basecost + (basecost * ((charges - 1) * arcanechargemod))) * arcanepowermod)
newcost = (basecost + (basecost * (charges * arcanechargemod))) * arcanepowermod -- 1.5 is stack multiplier and 1.1 is arcane power mana cost modifier
else
pool = pool - (basecost + (basecost * ((charges - 1) * arcanechargemod)))
newcost = basecost + (basecost * (charges * arcanechargemod)) -- 1.5 is stack multiplier
end
if pool < 0 then
num = num - 1
manaleft = false
end

if charges ~= 4 and manaleft == true then
pool = pool + regen
if pool > poolmax then
pool = poolmax
end
pool = pool - newcost
if pool > 0 then
num = 2
charges = charges + 1
arcanepower = arcanepower - casttime
if arcanepower < 0 then arcanepower = 0 end
if arcanepower > 0 then
newcost = (basecost + (basecost * (charges * arcanechargemod))) * arcanepowermod -- 1.5 is stack multiplier and 1.1 is arcane power mana cost modifier
else
newcost = basecost + (basecost * (charges * arcanechargemod)) -- 1.5 is stack multiplier
end
else
num = 1
manaleft = false
end
end

if charges ~= 4 and manaleft == true then
pool = pool + regen
if pool > poolmax then
pool = poolmax
end
pool = pool - newcost
if pool > 0 then
num = 3
charges = charges + 1
arcanepower = arcanepower - casttime
if arcanepower < 0 then arcanepower = 0 end
if arcanepower > 0 then
newcost = (basecost + (basecost * (charges * arcanechargemod))) * arcanepowermod -- 1.5 is stack multiplier and 1.1 is arcane power mana cost modifier
else
newcost = basecost + (basecost * (charges * arcanechargemod)) -- 1.5 is stack multiplier
end
else
num = 2
manaleft = false
end
end

if charges ~= 4 and manaleft == true then
pool = pool + regen
if pool > poolmax then
pool = poolmax
end
pool = pool - newcost
if pool > 0 then
num = 4
charges = charges + 1
arcanepower = arcanepower - casttime
if arcanepower < 0 then arcanepower = 0 end
if arcanepower > 0 then
newcost = (basecost + (basecost * (charges * arcanechargemod))) * arcanepowermod -- 1.5 is stack multiplier and 1.1 is arcane power mana cost modifier
else
newcost = basecost + (basecost * (charges * arcanechargemod)) -- 1.5 is stack multiplier
end
else
num = 3
manaleft = false
end
end
else
if castleft > 0 then
checkcast = true
end
end

cost = basecost + (basecost * (charges * arcanechargemod))
if manaleft == true then
while pool >= 0 do
if num == 0 then
if checkcast == true then
pool = pool + (castleft * combatregen) -- casting a spell. predict how much mana will generate until finished casting
else
pool = pool + regen -- predicted regen while casting the calculator spell
end
else
pool = pool + regen
end
if pool > poolmax then
pool = poolmax
end
if num == 0 then
if checkcast == true then
arcanepower = arcanepower - castleft
else
arcanepower = arcanepower - casttime
end
else
arcanepower = arcanepower - casttime
end
if arcanepower < 0 then arcanepower = 0 end
if arcanepower > 0 then
pool = pool - (cost * arcanepowermod) -- arcane power mana cost modifier
else
pool = pool - cost
end

num = num + 1
if num == 7 then break end
end
num = num - 1
MageCandy_ManaBarExtrasUpdate(num, icon)
else
MageCandy_ManaBarExtrasUpdate(num, icon)
end


else
local pool, poolmax = mana - (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarreserve * 0.01 * manamax), manamax - (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarreserve * 0.01 * manamax)
local start, duration = GetSpellCooldown(MageCandy_Profiles[MageCandy_ActiveProfile].options.input.calculatorspell)
if start ~= 0 and duration ~= 0 and start ~= nil and duration ~= nil and instant == true then
duration = (start + duration) - GetTime()
pool = pool + (duration * combatregen) -- factor in regen while the gcd is ticking
if pool > poolmax then
pool = poolmax
end
else 
duration = 0
end

local spell, _, _, _, starttime, endtime = UnitCastingInfo("player")
if starttime == nil then
spell, _, _, _, starttime, endtime = UnitChannelInfo("player")
end
local castleft = 0
if starttime == nil then starttime = 0 end
if endtime == nil then 
endtime = 0 
else
endtime = endtime / 1000
end
local castleft = endtime - GetTime()
if castleft > duration and spell == name then 
castleft = castleft - duration
pool = pool + (castleft * combatregen)
pool = pool - cost
num = num + 1
else
castleft = 0
end

while pool >= 0 do
if instant == false then
pool = pool + regen
if pool > poolmax then
pool = poolmax
end
pool = pool - cost
num = num + 1
else
pool = pool - cost
if pool >= 0 then
pool = pool + regen
num = num + 1
if pool > poolmax then
pool = poolmax
end
end
end
if num == 6 then break end
end

if pool < 0 and instant == false then
num = num - 1
end
MageCandy_ManaBarExtrasUpdate(num, icon)
end
end
else
MageCandy_ManaBarExtrasUpdate(0)
end
end

function MageCandy_ManaBarUpdate()
local num = 0
local text = ""
local mana, manamax = UnitMana("player"), UnitManaMax("player")
if mana == 0 then mana = 1 end
if manamax == 0 then manamax = 1 end
if MageCandy_Profiles[MageCandy_ActiveProfile].options.enablemanabar == 1 then
if MageCandy_Profiles[MageCandy_ActiveProfile].options.show.manabarnumber == 1 then
text = text..MageCandy_CondenseNumber(mana).." "
end
if MageCandy_Profiles[MageCandy_ActiveProfile].options.show.manabarpercent == 1 then
text = text.."("..MageCandy_ShortNumber(mana/manamax).."%) "
end
if MageCandy_Profiles[MageCandy_ActiveProfile].options.show.manabarmax == 1 then
text = text.."/ "..MageCandy_CondenseNumber(manamax)
else
text = string.sub(text, 1, string.len(text) - 1)
end
MCManaBar:SetMinMaxValues(0, manamax)
MCManaBarCost:SetMinMaxValues(0, manamax)
MCManaBar:SetValue(mana)
MCManaBarCost:SetValue(mana)
MCManaBarText:SetText(text)
local _, _, _, cost = GetSpellInfo(UnitCastingInfo("player"))
if cost == nil then cost = 0 end
MCManaBar:SetValue(mana - cost)
end
if oldmana > (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarreserve * 0.01 * manamax) and mana <= (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarreserve * 0.01 * manamax) then
MCmanabarflash = true
if MageCandy_Profiles[MageCandy_ActiveProfile].options.sound.lowmana == 1 then
PlaySoundFile("Interface\\AddOns\\MageCandy\\Sounds\\lowmana.mp3", "MASTER")
end
if CombatText_AddMessage ~= nil then
CombatText_AddMessage(L["LOW_MANA"], CombatText_StandardScroll, 0, 0.7, 1, nil, nil)
end
elseif oldmana <= (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarreserve * 0.01 * manamax) and mana > (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarreserve * 0.01 * manamax) then
MCmanabarflash = false
end
oldmana = mana
end

function MageCandy_ManaBarExtrasUpdate(num, icon)
if num > 6 then num = 6 end
for idx = 1, 6 do
_G["MCSpellCalculatorSpell"..idx]:Hide()
end
if num > 0 then
for idx = 1, num do
local frame = _G["MCSpellCalculatorSpell"..idx]
local frameicon = _G["MCSpellCalculatorSpell"..idx.."Icon"]

frame:ClearAllPoints()

if idx == 1 then
frame:SetPoint("CENTER", MCSpellCalculator, "CENTER", -1 * ((num - 1)/2 * (frame:GetWidth() + 2)), 0)
else
frame:SetPoint("LEFT", _G["MCSpellCalculatorSpell"..idx - 1], "RIGHT", 2, 0)
end
frameicon:SetTexture(icon)
frame:Show()
end
end
end

function MageCandy_HealthBarUpdate()
local text = ""
local health, healthmax = UnitHealth("player"), UnitHealthMax("player")
if MageCandy_Profiles[MageCandy_ActiveProfile].options.show.healthbarnumber == 1 then
text = text..MageCandy_CondenseNumber(health).." "
end
if MageCandy_Profiles[MageCandy_ActiveProfile].options.show.healthbarpercent == 1 then
text = text.."("..MageCandy_ShortNumber(health/healthmax).."%) "
end
if MageCandy_Profiles[MageCandy_ActiveProfile].options.show.healthbarmax == 1 then
text = text.."/ "..MageCandy_CondenseNumber(healthmax)
else
text = string.sub(text, 1, string.len(text) - 1)
end
MCHealthBar:SetMinMaxValues(0, healthmax)
MCHealthBar:SetValue(health)
MCHealthBarText:SetText(text)
end

function MageCandy_ManaBarMarkersUpdate()
MCManaBarReserve:ClearAllPoints()
MCManaBarMarker1:ClearAllPoints()
MCManaBarMarker2:ClearAllPoints()
MCManaBarMarker3:ClearAllPoints()
MCManaBarReserve:SetHeight(MCManaBar:GetHeight())
MCManaBarMarker1:SetHeight(MCManaBar:GetHeight())
MCManaBarMarker2:SetHeight(MCManaBar:GetHeight())
MCManaBarMarker3:SetHeight(MCManaBar:GetHeight())
MCManaBarReserve:SetPoint("CENTER", MCManaBar, "LEFT", MCManaBar:GetWidth() * (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarreserve * 0.01), 0)
MCManaBarMarker1:SetPoint("CENTER", MCManaBar, "LEFT", MCManaBar:GetWidth() * (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarmarker1 * 0.01), 0)
MCManaBarMarker2:SetPoint("CENTER", MCManaBar, "LEFT", MCManaBar:GetWidth() * (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarmarker2 * 0.01), 0)
MCManaBarMarker3:SetPoint("CENTER", MCManaBar, "LEFT", MCManaBar:GetWidth() * (MageCandy_Profiles[MageCandy_ActiveProfile].options.input.mcmanabarmarker3 * 0.01), 0)
end

function MageCandy_SetManaBarPoints()
MCManaBarBackground:ClearAllPoints()
MCManaBarBackground:SetWidth(MCManaBar:GetWidth())
MCManaBarBackground:SetHeight(MCManaBar:GetHeight())
MCManaBarBackground:SetPoint("CENTER")
MCManaBarBG:ClearAllPoints()
MCManaBarBG:SetWidth(MCManaBar:GetWidth() + 5)
MCManaBarBG:SetHeight(MCManaBar:GetHeight() + 5)
MCManaBarBG:SetPoint("CENTER", MCManaBar, "CENTER")
MCHealthBarBackground:ClearAllPoints()
MCHealthBarBackground:SetWidth(MCHealthBar:GetWidth())
MCHealthBarBackground:SetHeight(MCHealthBar:GetHeight())
MCHealthBarBackground:SetPoint("CENTER")
MCHealthBarBG:ClearAllPoints()
MCHealthBarBG:SetWidth(MCHealthBar:GetWidth() + 5)
MCHealthBarBG:SetHeight(MCHealthBar:GetHeight() + 5)
MCHealthBarBG:SetPoint("CENTER", MCHealthBar, "CENTER")
MageCandy_ManaBarMarkersUpdate()
end

function MageCandy_CreateManaBarUI()
local backdrop = {edgeFile = "Interface/Tooltips/UI-Tooltip-Border", edgeSize = 12}
local backdropthick = {edgeFile = "Interface/DialogFrame/UI-DialogBox-Border", edgeSize = 12}

-- Create Mana Bar
CreateFrame("StatusBar", "MCManaBar", UIParent)
MCManaBar:SetScript("OnEvent", function(self, event, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16)
if MCtimerbypass == 0 and MageCandy_Profiles[MageCandy_ActiveProfile].options.enablemanabar == 1 then

if event == "UNIT_POWER_FREQUENT" and arg1 == "player" then
if arg2 == "MANA" then
MageCandy_ManaBarUpdate()
end

elseif event == "UNIT_AURA" and arg1 == "player" then
MageCandy_ManaBarUpdate()

elseif event == "UNIT_SPELLCAST_START" and arg1 == "player" then
MageCandy_ManaBarUpdate()

elseif event == "UNIT_SPELLCAST_STOP" and arg1 == "player" then
MageCandy_ManaBarUpdate()

end

end
end)

MCManaBar:RegisterEvent("UNIT_SPELLCAST_START")
MCManaBar:RegisterEvent("UNIT_SPELLCAST_STOP")
MCManaBar:RegisterEvent("UNIT_AURA")
MCManaBar:RegisterEvent("UNIT_POWER_FREQUENT")

MCManaBar:SetWidth(192)
MCManaBar:SetHeight(24)
MCManaBar:SetPoint("CENTER", UIParent, "CENTER")
MCManaBar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
MCManaBar:SetStatusBarColor(0, 0, 0)
MCManaBar:SetFrameLevel(2)

CreateFrame("StatusBar", "MCManaBarCost", MCManaBar)
MCManaBarCost:SetWidth(192)
MCManaBarCost:SetHeight(24)
MCManaBarCost:SetPoint("CENTER")
MCManaBarCost:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
MCManaBarCost:SetStatusBarColor(0.1, 0.4, 1)
MCManaBarCost:SetFrameLevel(1)

MCManaBar:CreateTexture("$parentBackground", "BACKGROUND")
MCManaBarBackground:SetWidth(MCManaBar:GetWidth())
MCManaBarBackground:SetHeight(MCManaBar:GetHeight())
MCManaBarBackground:SetPoint("CENTER")
MCManaBarBackground:SetTexture("Interface\\TargetingFrame\\UI-StatusBar")
MCManaBarBackground:SetVertexColor(0.1, 0.3, 1, 0.3)
CreateFrame("Frame", "$parentBG", MCManaBar)
MCManaBarBG:SetWidth(MCManaBar:GetWidth() + 5)
MCManaBarBG:SetHeight(MCManaBar:GetHeight() + 5)
MCManaBarBG:SetPoint("CENTER", MCManaBar, "CENTER")
MCManaBarBG:SetBackdrop(backdrop)
MCManaBar:CreateFontString("MCManaBarText", "OVERLAY", "GameFontNormal")
MCManaBarText:SetPoint("CENTER", MCManaBar, "CENTER")
MCManaBarText:SetTextColor(1, 1, 1)
MCManaBarText:SetTextHeight(12)
MCManaBar:CreateTexture("$parentReserve")
MCManaBarReserve:SetWidth(1)
MCManaBarReserve:SetHeight(MCManaBar:GetHeight())
MCManaBarReserve:SetTexture(0.85, 0.65, 0.13)
MCManaBarReserve:SetDrawLayer("ARTWORK", 4)


CreateFrame("Frame", "MCSpellCalculator", UIParent)

MCSpellCalculator:SetScript("OnEvent", function(self, event, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16)
if MCtimerbypass == 0 and MageCandy_Profiles[MageCandy_ActiveProfile].options.input.calculatorspell ~= "" then

if event == "UNIT_POWER_FREQUENT" and arg1 == "player" then
if arg2 == "MANA" then
if UnitAffectingCombat("player") == nil then
MageCandy_UpdateSpellCalculator()
end
end

elseif event == "UNIT_AURA" and arg1 == "player" then
if UnitAffectingCombat("player") == nil then
MageCandy_UpdateSpellCalculator()
end

elseif event == "PLAYER_REGEN_DISABLED" then
calculatorupdate = true
combatdelay = 0

elseif event == "PLAYER_REGEN_ENABLED" then
combatdelay = 5

end

end
end)

MCSpellCalculator:RegisterEvent("PLAYER_REGEN_ENABLED")
MCSpellCalculator:RegisterEvent("PLAYER_REGEN_DISABLED")
MCSpellCalculator:RegisterEvent("UNIT_AURA")
MCSpellCalculator:RegisterEvent("UNIT_POWER_FREQUENT")

MCSpellCalculator:SetWidth(139)
MCSpellCalculator:SetHeight(29)
MCSpellCalculator:SetPoint("TOP", MCManaBar, "BOTTOM", 0, 2)
MCSpellCalculator:CreateTexture("$parentBackground", "Background")
MCSpellCalculatorBackground:SetTexture(0, 0, 0, 0.6)
MCSpellCalculatorBackground:SetWidth(MCSpellCalculator:GetWidth() - 5)
MCSpellCalculatorBackground:SetHeight(MCSpellCalculator:GetHeight() - 5)
MCSpellCalculatorBackground:SetPoint("CENTER")
MCSpellCalculator:SetBackdrop(backdrop)

MCSpellCalculator:CreateFontString("$parentHeader", "OVERLAY", "GameFontNormal")
MCSpellCalculatorHeader:SetPoint("BOTTOM", MCSpellCalculator, "TOP", 0, 1)
MCSpellCalculatorHeader:SetTextColor(0, 1, 1)
MCSpellCalculatorHeader:SetText(L["SPELL_CALCULATOR"])
MCSpellCalculatorHeader:Hide()

MCManaBar:SetFrameLevel(7)
for idx = 1, 6 do 
local frame = CreateFrame("Button", "$parentSpell"..idx, MCSpellCalculator, "TargetBuffFrameTemplate")
frame:SetWidth(20)
frame:SetHeight(20)
if idx == 1 then
frame:SetPoint("LEFT", MCSpellCalculator, "LEFT", 8, 0)
else
frame:SetPoint("LEFT", _G["MCSpellCalculatorSpell"..idx - 1], "RIGHT", 4, 0)
end
_G["MCSpellCalculatorSpell"..idx.."Icon"]:SetAllPoints()
_G["MCSpellCalculatorSpell"..idx.."Icon"]:SetTexture("Interface\\Icons\\Spell_Arcane_Arcane02")
frame:SetScript("OnEnter", nil)
frame:SetScript("OnClick", nil)
frame:EnableMouse(false)
frame:Hide()
end

-------------------------------------------------------------
for idx = 1, 3 do
local marker = MCManaBar:CreateTexture("$parentMarker"..idx)
marker:SetWidth(1)
marker:SetHeight(MCManaBar:GetHeight())
marker:SetTexture(0.85, 0.65, 0.13)
marker:SetDrawLayer("ARTWORK", 4)
end
--Create Health Bar
CreateFrame("StatusBar", "MCHealthBar", MCManaBar)
MCHealthBar:SetScript("OnEvent", function(self, event, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16)
if MCtimerbypass == 0 and MageCandy_Profiles[MageCandy_ActiveProfile].options.enablehealthbar == 1 then

if event == "UNIT_HEALTH_FREQUENT" and arg1 == "player" then
if MageCandy_Profiles[MageCandy_ActiveProfile].options.enablehealthbar == 1 then
MageCandy_HealthBarUpdate()
end
end

end
end)

MCHealthBar:RegisterEvent("UNIT_HEALTH_FREQUENT")

MCHealthBar:SetWidth(200)
MCHealthBar:SetHeight(12)
MCHealthBar:SetPoint("BOTTOM", MCManaBar, "TOP", 0, 1)
MCHealthBar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
MCHealthBar:SetStatusBarColor(0, 1, 0)
MCHealthBar:CreateTexture("$parentBackground", "BACKGROUND")
MCHealthBarBackground:SetWidth(MCHealthBar:GetWidth())
MCHealthBarBackground:SetHeight(MCHealthBar:GetHeight())
MCHealthBarBackground:SetPoint("CENTER")
MCHealthBarBackground:SetTexture("Interface\\TargetingFrame\\UI-StatusBar")
MCHealthBarBackground:SetVertexColor(1, 0, 0, 0.4)
CreateFrame("Frame", "$parentBG", MCHealthBar)
MCHealthBarBG:SetWidth(MCHealthBar:GetWidth() + 5)
MCHealthBarBG:SetHeight(MCHealthBar:GetHeight() + 5)
MCHealthBarBG:SetPoint("CENTER", MCHealthBar, "CENTER")
MCHealthBarBG:SetBackdrop(backdrop)
MCHealthBar:CreateFontString("$parentText", "OVERLAY", "GameFontNormal")
MCHealthBarText:SetPoint("CENTER", MCHealthBar, "CENTER")
MCHealthBarText:SetTextColor(1, 1, 1)
MCHealthBarText:SetTextHeight(12)

-- Finish Setting Up Frames --
MageCandy_SetupFrame(MCManaBar)
MageCandy_SetupFrame(MCSpellCalculator)
end

function MageCandy_CreateManaBarOptionsMenu()
local x, y, xoff, yoff = 0, 0, 15, -20
--Mana Bar---------------------------------------------------------------
MageCandy.manabar = CreateFrame("Frame", "MCManaBarOptions", MCOptionsFrame)
MageCandy.manabar:SetWidth(625)
MageCandy.manabar:SetHeight(570)
MageCandy.manabar:SetPoint("LEFT", MCOptionsFrameButtons, "RIGHT", 5, 0)
MageCandy.manabar.name = L["MANA_BAR"]
MageCandy.manabar:SetFrameLevel(4)

MCManaBarScrollFrame = CreateFrame("ScrollFrame", "MCManaBarScrollFrame", MageCandy.manabar)
MCManaBarScrollFrame:SetPoint("TOPLEFT", 10, -10) 
MCManaBarScrollFrame:SetPoint("BOTTOMRIGHT", -15, 15) 

MCManaBarContent = CreateFrame("Frame", "MCManaBarContent", MCManaBarScrollFrame)
MCManaBarContent:SetPoint("CENTER")
MCManaBarContent:SetWidth(580)
MCManaBarContent:SetHeight(2000)
MCManaBarScrollFrame:SetScrollChild(MCManaBarContent)

MCManaBarScroll = CreateFrame("Slider", "MCManaBarScroll", MCManaBarScrollFrame, "UIPanelScrollBarTemplate")
MCManaBarScroll:CreateTexture("$parentBG")
MCManaBarScrollBG:SetWidth(16)
MCManaBarScrollBG:SetHeight(445)
MCManaBarScrollBG:SetPoint("CENTER", -0.5, 0)
MCManaBarScrollBG:SetTexture(0.2, 0.2, 0.2, 0.5)
MCManaBarScroll:SetOrientation("VERTICAL")
MCManaBarScroll:SetWidth(20)
MCManaBarScroll:SetHeight(450)
MCManaBarScroll:SetPoint("RIGHT", MageCandy.manabar, "RIGHT", -5, 0)
MCManaBarScroll:SetThumbTexture("Interface\\Buttons\\UI-ScrollBar-Knob")
MCManaBarScroll:SetValueStep(20)
MCManaBarScroll:SetValue(0)
MCManaBarContent:SetScript("OnMouseWheel", function(self, delta)
local scroll = MCManaBarScroll:GetValue()
if delta > 0  then
MCManaBarScroll:SetValue(scroll - MCManaBarScroll:GetValueStep())
elseif delta < 0 then
MCManaBarScroll:SetValue(scroll + MCManaBarScroll:GetValueStep())
end
end)

MageCandy.manabar:Hide()
------------------------------------------------------------------
x = 15
y = 0
local spacey, scaley = 20, 45
y = y - 20
MCEnableHealthBar = CreateFrame("CheckButton", "MCEnableHealthBar", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCEnableHealthBar:SetPoint("TOPLEFT", MCManaBarContent, "TOP", x, y)
MCEnableHealthBarText:SetText(L["ENABLE_HEALTH_BAR"])
MCEnableHealthBar:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.enablehealthbar)
MCEnableHealthBar:SetScript("OnEnter", function(self) 
GameTooltip:SetOwner(self)
GameTooltip:SetText(L["ENABLE_HEALTH_BAR_TOOLTIP"])
GameTooltip:Show()
end)
MCEnableHealthBar:SetScript("OnLeave", function(self)
GameTooltip:Hide()
end)
------------------------------------------------------------------
y = y - spacey
MCHealthBarPercent = CreateFrame("CheckButton", "MCHealthBarPercent", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCHealthBarPercent:SetPoint("TOPLEFT", MCManaBarContent, "TOP", x, y)
MCHealthBarPercentText:SetText(L["HEALTH_BAR_PERCENT"])
MCHealthBarPercent:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.healthbarpercent)
------------------------------------------------------------------
y = y - spacey
MCHealthBarNumber = CreateFrame("CheckButton", "MCHealthBarNumber", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCHealthBarNumber:SetPoint("TOPLEFT", MCManaBarContent, "TOP", x, y)
MCHealthBarNumberText:SetText(L["HEALTH_BAR_NUMBER"])
MCHealthBarNumber:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.healthbarnumber)
------------------------------------------------------------------
y = y - spacey
MCHealthBarMax = CreateFrame("CheckButton", "MCHealthBarMax", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCHealthBarMax:SetPoint("TOPLEFT", MCManaBarContent, "TOP", x, y)
MCHealthBarMaxText:SetText(L["HEALTH_BAR_MAX"])
MCHealthBarMax:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.healthbarmax)
------------------------------------------------------------------
x = 15
y = 0
local spacey, scaley = 20, 45
y = y - 20
MCEnableManaBar = CreateFrame("CheckButton", "MCEnableManaBar", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCEnableManaBar:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCEnableManaBarText:SetText(L["ENABLE_MANA_BAR"])
MCEnableManaBar:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.enablemanabar)
-----------------------------------------------------------------
y = y - spacey
MCManaBarPercent = CreateFrame("CheckButton", "MCManaBarPercent", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCManaBarPercent:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarPercentText:SetText(L["MANA_BAR_PERCENT"])
MCManaBarPercent:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.manabarpercent)
------------------------------------------------------------------
y = y - spacey
MCManaBarNumber = CreateFrame("CheckButton", "MCManaBarNumber", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCManaBarNumber:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarNumberText:SetText(L["MANA_BAR_NUMBER"])
MCManaBarNumber:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.manabarnumber)
------------------------------------------------------------------
y = y - spacey
MCManaBarMax = CreateFrame("CheckButton", "MCManaBarMax", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCManaBarMax:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarMaxText:SetText(L["MANA_BAR_MAX"])
MCManaBarMax:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.manabarmax)
------------------------------------------------------------------
y = y - spacey - 40
MCManaBarReserveShow = CreateFrame("CheckButton", "MCManaBarReserveShow", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCManaBarReserveShow:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarReserveShowText:SetText(L["MANA_BAR_RESERVE_SHOW"])
MCManaBarReserveShow:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcmanabarreserve)
MCManaBarReserveShow:SetScript("OnEnter", function(self) 
GameTooltip:SetOwner(self)
GameTooltip:SetText(L["MANA_BAR_RESERVE_SHOW_TOOLTIP"])
GameTooltip:Show()
end)
MCManaBarReserveShow:SetScript("OnLeave", function(self)
GameTooltip:Hide()
end)
MCManaBarReserveInput = CreateFrame("EditBox", "MCManaBarReserveInput", MCManaBarContent, "InputBoxTemplate")
MCManaBarReserveInput:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x + 300, y)
MCManaBarReserveInput:SetWidth(100)
MCManaBarReserveInput:SetHeight(20)
MCManaBarReserveInput:SetAutoFocus(false)
MCManaBarContent:CreateFontString("MCManaBarReserveInputText", "OVERLAY", "GameFontNormal")
MCManaBarReserveInputText:SetText("%")
MCManaBarReserveInputText:SetJustifyH("LEFT")
MCManaBarReserveInputText:SetPoint("LEFT", MCManaBarReserveInput, "RIGHT", 1, 0)
y = y - 20
MCLowManaSound = CreateFrame("CheckButton", "MCLowManaSound", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCLowManaSound:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCLowManaSoundText:SetText(L["ENABLE_LOW_MANA_SOUND_EFFECT"])
MCLowManaSound:SetScript("OnEnter", function(self)
GameTooltip:SetOwner(self)
GameTooltip:SetText(L["SOUND_EFFECT_TOOLTIP"])
GameTooltip:Show()
end)
MCLowManaSound:SetScript("OnLeave", function(self)
GameTooltip:Hide()
end)
----------------------------------------------------------------------------------
y = y - spacey - 10
MCManaBarMarker1Show = CreateFrame("CheckButton", "MCManaBarMarker1Show", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCManaBarMarker1Show:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarMarker1ShowText:SetText(L["MANA_BAR_MARKER_SHOW"].." 1")
MCManaBarMarker1Show:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcmanabarmarker1)
MCManaBarMarker1Input = CreateFrame("EditBox", "MCManaBarMarker1Input", MCManaBarContent, "InputBoxTemplate")
MCManaBarMarker1Input:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x + 300, y)
MCManaBarMarker1Input:SetWidth(100)
MCManaBarMarker1Input:SetHeight(20)
MCManaBarMarker1Input:SetAutoFocus(false)
MCManaBarContent:CreateFontString("MCManaBarMarker1InputText", "OVERLAY", "GameFontNormal")
MCManaBarMarker1InputText:SetText("%")
MCManaBarMarker1InputText:SetJustifyH("LEFT")
MCManaBarMarker1InputText:SetPoint("LEFT", MCManaBarMarker1Input, "RIGHT", 1, 0)
------------------------------------------------------------------------------------
y = y - spacey - 10
MCManaBarMarker2Show = CreateFrame("CheckButton", "MCManaBarMarker2Show", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCManaBarMarker2Show:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarMarker2ShowText:SetText(L["MANA_BAR_MARKER_SHOW"].." 2")
MCManaBarMarker2Show:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcmanabarmarker2)
MCManaBarMarker2Input = CreateFrame("EditBox", "MCManaBarMarker2Input", MCManaBarContent, "InputBoxTemplate")
MCManaBarMarker2Input:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x + 300, y)
MCManaBarMarker2Input:SetWidth(100)
MCManaBarMarker2Input:SetHeight(20)
MCManaBarMarker2Input:SetAutoFocus(false)
MCManaBarContent:CreateFontString("MCManaBarMarker2InputText", "OVERLAY", "GameFontNormal")
MCManaBarMarker2InputText:SetText("%")
MCManaBarMarker2InputText:SetJustifyH("LEFT")
MCManaBarMarker2InputText:SetPoint("LEFT", MCManaBarMarker2Input, "RIGHT", 1, 0)
----------------------------------------------------------------------------------
y = y - spacey - 10
MCManaBarMarker3Show = CreateFrame("CheckButton", "MCManaBarMarker3Show", MCManaBarContent, "ChatConfigCheckButtonTemplate")
MCManaBarMarker3Show:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarMarker3ShowText:SetText(L["MANA_BAR_MARKER_SHOW"].." 3")
MCManaBarMarker3Show:SetChecked(MageCandy_Profiles[MageCandy_ActiveProfile].options.show.mcmanabarmarker3)
MCManaBarMarker3Input = CreateFrame("EditBox", "MCManaBarMarker3Input", MCManaBarContent, "InputBoxTemplate")
MCManaBarMarker3Input:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x + 300, y)
MCManaBarMarker3Input:SetWidth(100)
MCManaBarMarker3Input:SetHeight(20)
MCManaBarMarker3Input:SetAutoFocus(false)
MCManaBarContent:CreateFontString("MCManaBarMarker3InputText", "OVERLAY", "GameFontNormal")
MCManaBarMarker3InputText:SetText("%")
MCManaBarMarker3InputText:SetJustifyH("LEFT")
MCManaBarMarker3InputText:SetPoint("LEFT", MCManaBarMarker3Input, "RIGHT", 1, 0)
-----------------------------------------------------------------------------------
y = y - spacey - 40
MCManaBarContent:CreateFontString("MCCalculatorSpellText", "OVERLAY", "GameFontNormal")
MCCalculatorSpellText:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCCalculatorSpellText:SetJustifyH("LEFT")
MCCalculatorSpellText:SetText(L["CALCULATOR_SPELL_INPUT"])
MCCalculatorSpellInput = CreateFrame("EditBox", "MCCalculatorSpellInput", MCManaBarContent, "InputBoxTemplate")
MCCalculatorSpellInput:SetPoint("LEFT", MCCalculatorSpellText, "RIGHT", 10, 0)
MCCalculatorSpellInput:SetWidth(100)
MCCalculatorSpellInput:SetHeight(20)
MCCalculatorSpellInput:SetFrameLevel(2)
MCCalculatorSpellInput:SetAutoFocus(false)
MCCalculatorSpellInput:SetScript("OnEnter", function(self) 
GameTooltip:SetOwner(self)
GameTooltip:SetText(L["CALCULATOR_SPELL_INPUT_TOOLTIP"])
GameTooltip:Show()
end)
MCCalculatorSpellInput:SetScript("OnLeave", function(self)
GameTooltip:Hide()
end)
--------------------------------------------------------------------------------
y = y - scaley * 2
MCSpellCalculatorScale = CreateFrame("Slider","MCSpellCalculatorScale", MCManaBarContent)
MCSpellCalculatorScale:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCSpellCalculatorScale:SetWidth(550)
MCSpellCalculatorScale:SetHeight(20)
MCSpellCalculatorScale:SetOrientation("HORIZONTAL")
MCSpellCalculatorScale:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCSpellCalculatorScale:SetMinMaxValues(0.5, 3)
MCSpellCalculatorScale:SetValueStep(0.1)
MCSpellCalculatorScale:SetValue(0)
MCSpellCalculatorScale:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCSpellCalculatorScale:SetScript("OnValueChanged", function (self, value) 
MCSpellCalculatorScaleValue:SetText(string.sub(value, 1, 4))
MCSpellCalculator:SetScale(value)
end)
MCSpellCalculatorScaleHeader = MCManaBarContent:CreateFontString("MCSpellCalculatorScaleHeader", "OVERLAY", "GameFontNormal")
MCSpellCalculatorScaleHeader:SetPoint("BOTTOMLEFT", MCSpellCalculatorScale, "TOPLEFT")
MCSpellCalculatorScaleHeader:SetText(L["SPELL_CALCULATOR_SCALE"])
MCSpellCalculatorScaleValue = MCManaBarContent:CreateFontString("MCSpellCalculatorScaleValue", "OVERLAY", "GameFontNormal")
MCSpellCalculatorScaleValue:SetPoint("BOTTOMRIGHT", MCSpellCalculatorScale, "TOPRIGHT")
MCSpellCalculatorScaleValue:SetText(MageCandy_Profiles[MageCandy_ActiveProfile].options.scale.mcspellcalculator)
--------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
y = y - scaley
MCManaBarWidth = CreateFrame("Slider","MCManaBarWidth", MCManaBarContent)
MCManaBarWidth:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarWidth:SetWidth(550)
MCManaBarWidth:SetHeight(20)
MCManaBarWidth:SetOrientation("HORIZONTAL")
MCManaBarWidth:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCManaBarWidth:SetMinMaxValues(100, 1200)
MCManaBarWidth:SetValueStep(1)
MCManaBarWidth:SetValue(0)
MCManaBarWidth:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCManaBarWidth:SetScript("OnValueChanged", function (self, value) 
MCManaBarWidthValue:SetText(MageCandy_Round(value))
MCManaBar:SetWidth(value) 
MCHealthBar:SetWidth(value) 
MCManaBarCost:SetWidth(value) 
MageCandy_SetManaBarPoints()
end)
MCManaBarWidthHeader = MCManaBarContent:CreateFontString("MCManaBarWidthHeader", "OVERLAY", "GameFontNormal")
MCManaBarWidthHeader:SetPoint("BOTTOMLEFT", MCManaBarWidth, "TOPLEFT")
MCManaBarWidthHeader:SetText(L["MANA_BAR_WIDTH"])
MCManaBarWidthValue = MCManaBarContent:CreateFontString("MCManaBarWidthValue", "OVERLAY", "GameFontNormal")
MCManaBarWidthValue:SetPoint("BOTTOMRIGHT", MCManaBarWidth, "TOPRIGHT")
MCManaBarWidthValue:SetText(MageCandy_Profiles[MageCandy_ActiveProfile].options.manabarwidth)
--------------------------------------------------------------------------------
y = y - scaley
MCManaBarHeight = CreateFrame("Slider","MCManaBarHeight", MCManaBarContent)
MCManaBarHeight:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarHeight:SetWidth(550)
MCManaBarHeight:SetHeight(20)
MCManaBarHeight:SetOrientation("HORIZONTAL")
MCManaBarHeight:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCManaBarHeight:SetMinMaxValues(12, 300)
MCManaBarHeight:SetValueStep(1)
MCManaBarHeight:SetValue(0)
MCManaBarHeight:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCManaBarHeight:SetScript("OnValueChanged", function (self, value) 
MCManaBarHeightValue:SetText(MageCandy_Round(value))
MCManaBar:SetHeight(value) 
MCManaBarCost:SetHeight(value) 
MageCandy_SetManaBarPoints()
end)
MCManaBarHeightHeader = MCManaBarContent:CreateFontString("MCManaBarHeightHeader", "OVERLAY", "GameFontNormal")
MCManaBarHeightHeader:SetPoint("BOTTOMLEFT", MCManaBarHeight, "TOPLEFT")
MCManaBarHeightHeader:SetText(L["MANA_BAR_HEIGHT"])
MCManaBarHeightValue = MCManaBarContent:CreateFontString("MCManaBarHeightValue", "OVERLAY", "GameFontNormal")
MCManaBarHeightValue:SetPoint("BOTTOMRIGHT", MCManaBarHeight, "TOPRIGHT")
MCManaBarHeightValue:SetText(MageCandy_Profiles[MageCandy_ActiveProfile].options.manabarheight)
--------------------------------------------------------------------------------
y = y - scaley
MCManaBarTextHeight = CreateFrame("Slider","MCManaBarTextHeight", MCManaBarContent)
MCManaBarTextHeight:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarTextHeight:SetWidth(550)
MCManaBarTextHeight:SetHeight(20)
MCManaBarTextHeight:SetOrientation("HORIZONTAL")
MCManaBarTextHeight:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCManaBarTextHeight:SetMinMaxValues(6, 150)
MCManaBarTextHeight:SetValueStep(1)
MCManaBarTextHeight:SetValue(0)
MCManaBarTextHeight:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCManaBarTextHeight:SetScript("OnValueChanged", function (self, value) 
MCManaBarTextHeightValue:SetText(MageCandy_Round(value))
MCManaBarText:SetTextHeight(value) 
end)
MCManaBarTextHeightHeader = MCManaBarContent:CreateFontString("MCManaBarTextHeightHeader", "OVERLAY", "GameFontNormal")
MCManaBarTextHeightHeader:SetPoint("BOTTOMLEFT", MCManaBarTextHeight, "TOPLEFT")
MCManaBarTextHeightHeader:SetText(L["MANA_BAR_TEXT_HEIGHT"])
MCManaBarTextHeightValue = MCManaBarContent:CreateFontString("MCManaBarTextHeightValue", "OVERLAY", "GameFontNormal")
MCManaBarTextHeightValue:SetPoint("BOTTOMRIGHT", MCManaBarTextHeight, "TOPRIGHT")
MCManaBarTextHeightValue:SetText(MageCandy_Profiles[MageCandy_ActiveProfile].options.manabartextheight)
--------------------------------------------------------------------------------
y = y - scaley
MCHealthBarHeight = CreateFrame("Slider","MCHealthBarHeight", MCManaBarContent)
MCHealthBarHeight:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCHealthBarHeight:SetWidth(550)
MCHealthBarHeight:SetHeight(20)
MCHealthBarHeight:SetOrientation("HORIZONTAL")
MCHealthBarHeight:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCHealthBarHeight:SetMinMaxValues(12, 300)
MCHealthBarHeight:SetValue(0)
MCHealthBarHeight:SetValueStep(1)
MCHealthBarHeight:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCHealthBarHeight:SetScript("OnValueChanged", function (self, value) 
MCHealthBarHeightValue:SetText(MageCandy_Round(value))
MCHealthBar:SetHeight(value) 
MageCandy_SetManaBarPoints()
end)
MCHealthBarHeightHeader = MCManaBarContent:CreateFontString("MCHealthBarHeightHeader", "OVERLAY", "GameFontNormal")
MCHealthBarHeightHeader:SetPoint("BOTTOMLEFT", MCHealthBarHeight, "TOPLEFT")
MCHealthBarHeightHeader:SetText(L["HEALTH_BAR_HEIGHT"])
MCHealthBarHeightValue = MCManaBarContent:CreateFontString("MCHealthBarHeightValue", "OVERLAY", "GameFontNormal")
MCHealthBarHeightValue:SetPoint("BOTTOMRIGHT", MCHealthBarHeight, "TOPRIGHT")
MCHealthBarHeightValue:SetText(MageCandy_Profiles[MageCandy_ActiveProfile].options.healthbarheight)
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
y = y - scaley
MCHealthBarTextHeight = CreateFrame("Slider","MCHealthBarTextHeight", MCManaBarContent)
MCHealthBarTextHeight:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCHealthBarTextHeight:SetWidth(550)
MCHealthBarTextHeight:SetHeight(20)
MCHealthBarTextHeight:SetOrientation("HORIZONTAL")
MCHealthBarTextHeight:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCHealthBarTextHeight:SetMinMaxValues(6, 150)
MCHealthBarTextHeight:SetValueStep(1)
MCHealthBarTextHeight:SetValue(0)
MCHealthBarTextHeight:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCHealthBarTextHeight:SetScript("OnValueChanged", function (self, value) 
MCHealthBarTextHeightValue:SetText(MageCandy_Round(value))
MCHealthBarText:SetTextHeight(value) 
end)
MCHealthBarTextHeightHeader = MCManaBarContent:CreateFontString("MCHealthBarTextHeightHeader", "OVERLAY", "GameFontNormal")
MCHealthBarTextHeightHeader:SetPoint("BOTTOMLEFT", MCHealthBarTextHeight, "TOPLEFT")
MCHealthBarTextHeightHeader:SetText(L["HEALTH_BAR_TEXT_HEIGHT"])
MCHealthBarTextHeightValue = MCManaBarContent:CreateFontString("MCHealthBarTextHeightValue", "OVERLAY", "GameFontNormal")
MCHealthBarTextHeightValue:SetPoint("BOTTOMRIGHT", MCHealthBarTextHeight, "TOPRIGHT")
MCHealthBarTextHeightValue:SetText(MageCandy_Profiles[MageCandy_ActiveProfile].options.healthbartextheight)
--------------------------------------------------------------------------------
y = y - scaley
MCManaBarScale = CreateFrame("Slider","MCManaBarScale", MCManaBarContent)
MCManaBarScale:SetPoint("TOPLEFT", MCManaBarContent, "TOPLEFT", x, y)
MCManaBarScale:SetWidth(550)
MCManaBarScale:SetHeight(20)
MCManaBarScale:SetOrientation("HORIZONTAL")
MCManaBarScale:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
MCManaBarScale:SetMinMaxValues(0.5, 5)
MCManaBarScale:SetValue(0.5151)
MCManaBarScale:SetBackdrop({
      bgFile ="Interface\\Buttons\\UI-SliderBar-Background",
      edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
      tile = true, tileSize = 8, edgeSize = 8,
      insets = { left = 3, right = 3, top = 6, bottom = 6 }})
	 
MCManaBarScale:SetScript("OnValueChanged", function (self, value) 
MCManaBarScaleValue:SetText(string.sub(value, 1, 4))
MCManaBar:SetScale(value) 
end)
MCManaBarScaleHeader = MCManaBarContent:CreateFontString("MCManaBarScaleHeader", "OVERLAY", "GameFontNormal")
MCManaBarScaleHeader:SetPoint("BOTTOMLEFT", MCManaBarScale, "TOPLEFT")
MCManaBarScaleHeader:SetText(L["MANA_BAR_SCALE"])
MCManaBarScaleValue = MCManaBarContent:CreateFontString("MCManaBarScaleValue", "OVERLAY", "GameFontNormal")
MCManaBarScaleValue:SetPoint("BOTTOMRIGHT", MCManaBarScale, "TOPRIGHT")
MCManaBarScaleValue:SetText(string.sub(MageCandy_Profiles[MageCandy_ActiveProfile].options.scale.mcmanabar, 1, 4))
--------------------------------------------------------------------------------

MCManaBarScroll:SetMinMaxValues(0, (abs(y)/60)*40)
MCManaBarScroll:SetValue(0)
--------------------------------------------------------------------------------------------
end

end