
-- If you aren't familiar with lua, the \n means the start of a new line.

local _, namespace = ...

local L = setmetatable({
["SHOW_MINIMAP_BUTTON"] = "Show Minimap Button",
["MOVE_CASTING_BAR"] = "Move Casting Bar",
["CASTING_BAR_FRAME_MOVER"] = "Casting Bar Frame Mover",
["UNKNOWN"] = "Unknown",
["STOLE"] = "Stole:",
["PERIODIC"] = "(Periodic)",
["MELEE_SWING"] = "Melee Swing",
["AUTO_SHOT"] = "Auto Shot",
["POLYMORPH_BROKEN_MESSAGE"] = "Polymorph broken by",
["POLYMORPH_EXPIRED_MESSAGE"] = "Polymorph expired on",
["POLYMORPH_APPLIED_MESSAGE"] = "Polymorph casted on",
["POLYMORPH_TIMER"] = "Polymorph Timer",
["WITH"] = "with",
["SPELLSTEAL_TARGET"] = "Spellsteal Target", 
["SPELLSTEAL_FOCUS"] = "Spellsteal Focus", 
["STOLEN_SPELLS"] = "Stolen Spells",
["RELOADUI"] = "Mage Candy Needs To Reload \nThe UI To Finish Making Changes.",
["SLASH"] = "Mage Candy Slash Commands:\n/mc => Options Menu \n/magecandy => Options Menu",


--Mana Bar
["SPELL_CALCULATOR_SCALE"] = "Spell Calculator Scale", 
["ENABLE_HEALTH_BAR_TOOLTIP"] = "Requires Mana Bar to be enabled.", 
["MANA_BAR"] = "Mana Bar",
["ENABLE_MANA_BAR"] = "Enable Mana Bar",
["ENABLE_HEALTH_BAR"] = "Enable Health Bar",
["MANA_BAR_MARKER_SHOW"] = "Show Mana Bar Marker",
["HEALTH_BAR_PERCENT"] = "Show Health Bar Text As A Percent",
["HEALTH_BAR_NUMBER"] = "Show Health Bar Text As A Number",
["MANA_BAR_PERCENT"] = "Show Mana Bar Text As A Percent",
["MANA_BAR_NUMBER"] = "Show Mana Bar Text As A Number",
["MANA_BAR_WIDTH"] = "Mana Bar & Health Bar Width",
["MANA_BAR_HEIGHT"] = "Mana Bar Height",
["HEALTH_BAR_HEIGHT"] = "Health Bar Height",
["MANA_BAR_SCALE"] = "Mana Bar & Health Bar Scale",
["MANA_BAR_RESERVE_SHOW"] = "Show Mana Bar Reserve Marker",
["MANA_BAR_RESERVE_SHOW_TOOLTIP"] = "This value also lets the mana bar know how much mana \nyou want to put aside for other spells, if you plan \non running it low. (Like spamming spellsteal in PVP)\n\nThe mana bar will flash red when below this value. \n(Doesn't have to be shown for the reserve function to work)",
["HEALTH_BAR_MAX"] = "Show Maximum Health",
["MANA_BAR_MAX"] = "Show Maximum Mana",
["MANA_BAR_TEXT_HEIGHT"] = "Mana Bar Text Size",
["HEALTH_BAR_TEXT_HEIGHT"] = "Health Bar Text Size",
["LOW_MANA"] = "Low Mana!",
["CALCULATOR_SPELL_INPUT"] = "Spell Calculator Spell ",
["CALCULATOR_SPELL_INPUT_TOOLTIP"] = "The Spell Calculator will display how many times you can cast \nthis spell without going below your reserve mana amount.\nThis is an excellent tool for PVP (spellstealing without using\ntoo much mana) and for Arcane spec (Arcane Blast).\n\nLeave this field blank if you don't want anything tracked,\nand the frame will be hidden.\n\nWorks even if Mana Bar is disabled.",
["SPELL_CALCULATOR"] = "Spell Calculator",

--Trackers--
["ARCANE_CHARGE_TRACKER"] = "Arcane Charge Tracker",
["CURSE_TRACKER"] = "Curse Tracker",
["PERSEC"] = "/s", -- stands for per second for mana per second in stat meter
["STATHEADERS"] = "Power:\nHaste:\nCritical:\nMastery:\nRegen:",
["REMOVED"] = "Removed: ",

--Notifications--
["LAZY_MAGE"] = "Lazy Mage",
["CAUTERIZE_TEXT"] = "Cauterize!",
["MISSING"] = "Missing",
["CHARGES"] = "Charges",
["NOT_SUMMONED"] = "Not Summoned",
["DEAD"] = "Dead",

--Timer Labels--
["ARCANE_CHARGE"] = "Arcane Charge",
["ARCANE_MISSILES"] = "Arcane Missiles!",
["ARCANE_POWER"] = "Arcane Power",
["ICY_VEINS"] = "Icy Veins",
["FINGERS_OF_FROST"] = "Fingers of Frost!",
["BRAIN_FREEZE"] = "Brain Freeze!",
["PYROBLAST"] = "Pyroblast!",
["ALTER_TIME"] = "Alter Time",
["HYPOTHERMIA"] = "Hypothermia",
["CAUTERIZE_COOLDOWN"] = "Cauterize CD",
["RUNE_OF_POWER"] = "Rune of Power",
["FROZEN_ORB"] = "Frozen Orb",
["MIRROR_IMAGE"] = "Mirror Image",
["RING_OF_FROST"] = "Ring of Frost",

--Trackers Menu--
["TRACKERS"] = "Trackers",
["STATS_SHOW"] = "Live Stat Tracker",
["STATS_SCALE"] = "Live Stat Tracker Scale",
["COMBUSTION_TRACKER_SHOW"] = "Combustion Tracker",
["CURSE_TRACKER_SHOW"] = "Curse Tracker",
["COMBUSTION_TRACKER_SCALE"] = "Combustion Tracker Scale",
["BOMB_TRACKER_SHOW"] = "Bomb Tracker",
["BOMB_TRACKER_SCALE"] = "Bomb Tracker Scale",
["MIRROR_IMAGE_TRACKER_SHOW"] = "Mirror Image Tracker",
["MIRROR_IMAGE_TRACKER_SCALE"] = "Mirror Image Tracker Scale",
["BOMB_TRACKER_TOOLTIP"] = "Displays timers for the bombs you have applied \nand who they are applied on. The tracker will \ndisplay the 5 most recent bomb applications.",
["COMBUSTION_TRACKER_TOOLTIP"] = "Displays the duration of your ignite on your \ncurrent target, with markers on the bar indicating\nwhere the next ignite tick will occur. It also displays \nan estimate on the total damage that combustion will \ndo if you apply it. (Just the base damage without crits)",
["MIRROR_IMAGE_TRACKER_TOOLTIP"] = "Displays the health of all of your images and \ntracks their health for their duration, so you \nknow exactly when to worry about aggro.",
["WATER_ELEMENTAL_TRACKER_SHOW"] = "Water Elemental Tracker",
["WATER_ELEMENTAL_TRACKER_SCALE"] = "Water Elemental Tracker Scale",
["WATER_ELEMENTAL_TRACKER_TOOLTIP"] = "Displays your water elementals health, \nstance, target, target health and cast bar \nall in a nice and compact frame.",
["CURSE_TRACKER_TOOLTIP"] = "Displays a class icon for each player in your group \nthat will be outlined in purple when someone is \ncursed. Simply click the icon to dispel that person.\n\nThe units can only be safely loaded out of combat \ndue to the way taint works. Any units that fail to \nload in combat will be loaded upon leaving combat.\nThe same goes for changing the size or turning it on/off.\n\nHold CTRL to click through the units and drag \nthe frame easier.",
["CURSE_TRACKER_SCALE"] = "Curse Tracker Scale",
["ARCANE_CHARGE_TRACKER_SHOW"] = "Arcane Charge Tracker",
["ARCANE_CHARGE_TRACKER_SCALE"] = "Arcane Charge Tracker Scale",
["ARCANE_CHARGE_TRACKER_TOOLTIP"] = "A simple combo bar type tracker that shows\nhow many arcane charges you have.",

--Options Menu--
["MINIMAP_BUTTON_SHOW"] = "Show Minimap Button",
["LOCK_FRAMES"] = "Lock Frames",
["HIDE_FRAMES"] = "Hide Frames When Not In Combat",
["SHOW_ALL_FRAMES"] = "Show All Frames",
["LOCK_FRAMES"] = "Lock Frames",
["OKAY"] = "Okay",
["CANCEL"] = "Cancel",
["DEFAULTS"] = "Defaults",
["APPLY"] = "Apply",
["TEST"] = "Test",
["NEW"] = "New",
["LOAD"] = "Load",
["DELETE"] = "Delete",
["DELETE_WARNING"] = "Are You Sure You Want To Delete \n This Profile? \n\n ",
["PROFILE"] = "Profile - ",
["PROFILE_NOT_FOUND"] = "Profile Not Found: ",
["PROFILE_LOADED"] = "Profile Loaded: ",
["PROFILE_CREATED"] = "Profile Created: ",
["PROFILE_SAVED"] = "Profile Saved: ",
["PROFILE_DELETED"] = "Profile Deleted: ",
["PROFILE_ALREADY_EXISTS"] = "A Profile With That Name Already Exists",
["BAD_PROFILE_NAME"] = "Please Enter A Profile Name",
["DEFAULTS_WARNING"] = "Warning!!! This Will Reset All \nSettings In The Loaded Profile \nBack To The Defaults. \nAre You Sure?",
["BAR_STYLE"] = "Bar Style",
["SMALL_BAR_STYLE"] = "Small Bar Style",
["COOLDOWN_STYLE"] = "Cooldown Style",
["ENABLE_SOUND_EFFECT"] = "Enable Sound",
["SOUND_EFFECT_TOOLTIP"] = "If you want to change the sound effect, simply \nreplace the sound file of equal name in the \nsounds folder with the sound effect you prefer.\n(The new sound file must have the same name \nas the old one, and you will need to restart the game)",
["ENABLE_LOW_MANA_SOUND_EFFECT"] = "Enable Low Mana Sound",
["ENABLE_WATER_ELEMENTAL_DEATH_SOUND_EFFECT"] = "Enable Water Elemental Death Sound",
["ENABLE_RUNE_OF_POWER_SOUND_EFFECT"] = "Enable Sound Notification For When Rune of Power Expires.",
["ENABLE_RUNE_OF_POWER_SOUND_EFFECT_TOOLTIP"] = "If you want to change the sound effect, simply \nreplace the sound file of equal name in the \nsounds folder with the sound effect you prefer.\n(The new sound file must have the same name \nas the old one, and you will need to restart the game)\n\nFor Rune of Power, the sound will replay every \n3 seconds while in combat if you have no \nRune Of Power summoned.",

--Notifications Menu--
["NOTIFICATIONS"] = "Notifications",
["CAUTERIZE_NOTIFICATION_SHOW"] = "Enable Cauterize Notification",
["CAUTERIZE_NOTIFICATION_SCALE"] = "Cauterize Notification Scale",
["LAZY_MAGE_SHOW"] = "Enable Lazy Mage Notifications (Missing Buffs Etc) <- Doesn't Show In Combat",
["LAZY_MAGE_SCALE"] = "Lazy Mage Scale",
["LAZY_MAGE_NOT_FULL_CHARGES_SHOW"] = "Show Notification When Mana Gem Is Missing Charges (Out Of Combat Only)",
["SLOW_FALL_MESSAGE"] = "Slow Fall Message",
["ICE_WARD_MESSAGE"] = "Ice Ward Message",
["CAUTERIZE_MESSAGE"] = "Cauterize Message (Yell)", 

--Polymorph Menu--
["POLYMORPH_MONITOR"] = "Polymorph Monitor",
["ENABLE_POLYMORPH_MONITOR"] = "Enable Polymorph Monitor",
["SHOW_POLYMORPH_TIMER"] = "Show Polymorph Timer",
["POLYMORPH_APPLY_SHOW"] = "Display Notification When Polymorph Is Applied",
["POLYMORPH_REMOVE_SHOW"] = "Display Notification When Polymorph Is Removed",
["POLYMORPH_TIMER_SCALE"] = "Polymorph Timer Scale",
["POLYMORPH_ANNOUNCE_SHOW"] = "Announce Enabled Notifications When In A Group",

--Spellsteal Menu--
["SPELLSTEAL_MONITOR"] = "Spellsteal Monitor",
["PLAY_ANIMATION"] = "Play Animation",
["SPELLSTEAL_MESSAGE_SHOW"] = "Show Spellsteal Message",
["SPELLSTEAL_MONITOR_BACKGROUND_SHOW"] = "Show Spellsteal Monitor Frame Backgrounds",
["SPELLSTEAL_MONITOR_HEADER_SHOW"] = "Show Spellsteal Monitor Frame Headers",
["SPELLSTEAL_MONITOR_FLIP_BUFFS"] = "Start Buffs On Bottom",
["SPELLSTEAL_MONITOR_ENABLE"] = "Enable Spellsteal Monitor",
["SPELLSTEAL_NOTIFICATION_SHOW"] = "Show Spellsteal Notification (Animation)",
["SPELLSTEAL_MONITOR_SHOW_TARGET"] = "Show Target Spellsteal Frame",
["SPELLSTEAL_MONITOR_SHOW_FOCUS"] = "Show Focus Spellsteal Frame",
["SPELLSTEAL_MONITOR_SHOW_STOLEN"] = "Show Stolen Spells Frame",
["SPELLSTEAL_MONITOR_TARGET_SCALE"] = "Target Spellsteal Frame Scale",
["SPELLSTEAL_MONITOR_FOCUS_SCALE"] = "Focus Spellsteal Frame Scale",
["SPELLSTEAL_MONITOR_STOLEN_SCALE"] = "Stolen Spells Frame Scale",
["SPELLSTEAL_MONITOR_NOTIFICATION_SCALE"] = "Spellsteal Notification Scale (Animated Icon)",

--Timers Menu--
["TIMERS"] = "Timers",
["ARCANE_CHARGE_TIMER_SHOW"] = "Arcane Charge Timer",
["ARCANE_CHARGE_TIMER_SCALE"] = "Arcane Charge Timer Scale",
["ARCANE_MISSILES_TIMER_SHOW"] = "Arcane Missiles Timer",
["ARCANE_MISSILES_TIMER_SCALE"] = "Arcane Missiles Timer Scale",
["ARCANE_POWER_TIMER_SHOW"] = "Arcane Power Timer",
["ARCANE_POWER_TIMER_SCALE"] = "Arcane Power Timer Scale",
["FINGERS_OF_FROST_TIMER_SHOW"] = "Fingers of Frost Timer",
["FINGERS_OF_FROST_TIMER_SCALE"] = "Fingers of Frost Timer Scale",
["BRAIN_FREEZE_TIMER_SHOW"] = "Brain Freeze Timer",
["BRAIN_FREEZE_TIMER_SCALE"] = "Brain Freeze Timer Scale",
["ICY_VEINS_TIMER_SHOW"] = "Icy Veins Timer",
["ICY_VEINS_TIMER_SCALE"] = "Icy Veins Timer Scale",
["FROZEN_ORB_TIMER_SHOW"] = "Frozen Orb Timer",
["FROZEN_ORB_TIMER_SCALE"] = "Frozen Orb Timer Scale",
["RING_OF_FROST_TIMER_SHOW"] = "Ring of Frost Timer",
["RING_OF_FROST_TIMER_SCALE"] = "Ring of Frost Timer Scale",
["PYROBLAST_TIMER_SHOW"] = "Pyroblast Timer",
["PYROBLAST_TIMER_SCALE"] = "Pyroblast Timer Scale",
["MIRROR_IMAGE_TIMER_SHOW"] = "Mirror Image Timer",
["MIRROR_IMAGE_TIMER_SCALE"] = "Mirror Image Timer Scale",
["ALTER_TIME_TIMER_SHOW"] = "Alter Time Timer",
["ALTER_TIME_TIMER_SCALE"] = "Alter Time Timer Scale",
["HYPOTHERMIA_TIMER_SHOW"] = "Hypothermia Timer",
["HYPOTHERMIA_TIMER_SCALE"] = "Hypothermia Timer Scale",
["CAUTERIZE_TIMER_SHOW"] = "Cauterize Timer",
["CAUTERIZE_TIMER_SCALE"] = "Cauterize Timer Scale",
["RUNE_OF_POWER_TIMER_SHOW"] = "Rune of Power Timer (2 Separate Timers)",
["RUNE_OF_POWER_TIMER_SCALE"] = "Rune of Power Timer Scale",

}, { __index = function(t, k)
	local v = tostring(k)
	rawset(t, k, v)
	return v
end })

namespace.L = L

local LOCALE = GetLocale()

if LOCALE:match("^en") then
return end

if LOCALE == "deDE" then
	-- German translations go here

return end

if LOCALE == "frFR" then
	-- French translations go here

return end

if LOCALE == "esES" or LOCALE == "esMX" then
	-- Spanish translations go here

return end

if LOCALE == "ptBR" then
	-- Brazilian Portuguese translations go here

return end

if LOCALE == "ruRU" then
	-- Russian translations go here

return end

if LOCALE == "koKR" then
	-- Korean translations go here

return end

if LOCALE == "zhCN" then
	-- Simplified Chinese translations go here

return end

if LOCALE == "zhTW" then
	-- Traditional Chinese translations go here

return end