--~ Consumable
--~    - Bandage (Consumable.Bandage)
--~    - Potions (Consumable.Cooldown.Potion)
--~    - Health- & Manastones (Consumable.Cooldown.Stone)
--~    - Food (Consumable.Food)
--~    - Buff Food (Consumable.Food.Buff)
--~    - Water (Consumable.Water)
--~    - Weapon Buffs (Consumable.Weapon Buff)

--~ Reputation Turnins (Reputation.Turnins)
--~    - Factions?

--~ Gathered by
--~ 	Tradeskill.Gather.Disenchant
--~ 	Tradeskill.Gather.Fishing
--~ 	Tradeskill.Gather.Herbalism
--~ 	Tradeskill.Gather.Milling
--~ 	Tradeskill.Gather.Mining
--~ 	Tradeskill.Gather.Pickpocketing
--~ 	Tradeskill.Gather.Prospecting
--~ 	Tradeskill.Gather.Skinning

local L = LibStub("AceLocale-3.0"):GetLocale("Luggage")
local silent = true
local pt = LibStub("LibPeriodicTable-3.1", silent)
if not pt then return end

local overrideExistingFilters = true
local consumableSets = {
"Consumable.Bandage",
"Consumable.Cooldown.Potion",
"Consumable.Cooldown.Stone",
"Consumable.Food",
"Consumable.Water",
"Consumable.Weapon Buffs",
}
Luggage:RegisterFilter("Consumable (PT)", {
   name = L["Consumable (PT)"],
   tooltipText = L["Just like the Conumables filter, but with Periodic Table support."],
   values = {
      {
         name = L["Bandage"],
         tooltipText = L["For when you cut yourself"],
      },
      {
         name = L["Potion"],
         tooltipText = L["Potions of all kinds. (Those with 2 minute cooldown)"],
      },
      {
         name = L["Health- and Manastones"],
         tooltipText = L["A bit crunchy, but healthy and refreshing"],
      },
      {
         name = L["Food"],
         tooltipText = L["Yummy."],
      },
      {
         name = L["Buff Food"],
         tooltipText = L["Food is fuel. And this is high octane."],
      },
      {
         name = L["Water"],
         tooltipText = L["Mahna, Mahna. Do doo be-do-do."],
      },
      {
         name = L["Weapon Buffs"],
         tooltipText = L["Sharpening stones, poisons, etc."],
      },
   },
   func = function(bag, item, ptSet)
      local set = consumableSets[ptSet]
      if not set then return end
      return pt:ItemInSet(item.itemID, set)
   end,
})

Luggage:RegisterFilter("Reputation Turnins", {
   name = L["Repuation Turnins"],
   tooltipText = L["Faction bribes"],
   func = function(bag, item)
      return pt:ItemInSet(item.itemID, "Reputation.Turnin")
   end,
})

Luggage:RegisterFilter("Gathered by", {
   name = L["Gathered by"],
   tooltipText = L["Picked flowers, mined ore, etc."],
   values = {
      ["Tradeskill.Gather.Disenchant"] = {
         name = L["Disenchanting"],
         tooltipText = L["Oohh, shiny armor. *Pling* and now it's dust."],
      },
      ["Tradeskill.Gather.Fishing"] = {
         name = L["Fishing"],
         tooltipText = L["Tight lines!"],
      },
      ["Tradeskill.Gather.Herbalism"] = {
         name = L["Herbalism"],
         tooltipText = L["I like grass"],
      },
      ["Tradeskill.Gather.Milling"] = {
         name = L["Milling"],
         tooltipText = L["It's easier to smoke that way"],
      },
      ["Tradeskill.Gather.Mining"] = {
         name = L["Mining"],
         tooltipText = L["Hard work for shiny stones"],
      },
      ["Tradeskill.Gather.Pickpocketing"] = {
         name = L["Pickpocketing"],
         tooltipText = L["Where do ogres hide lockboxes?"],
      },
      ["Tradeskill.Gather.Prospecting"] = {
         name = L["Prospecting"],
         tooltipText = L["Ore to dust"],
      },
      ["Tradeskill.Gather.Skinning"] = {
         name = L["Skinning"],
         tooltipText = L["Use every part of an animal, not just the loot"],
      },
   },
   func = function(bag, item, ptSet)
      return pt:ItemInSet(item.itemID, ptSet)
   end,
})

--~ Tradeskills
--~    * Tradeskill.Mat.ByProfession
--~    * Tradeskill.Tool
--~    * Tradeskill.Recipe
--~    - Alchemy
--~    - Blacksmithing 
--~    - Cooking 
--~    - Enchanting 
--~    - Engineering
--~    - Fishing
--~    - First Aid 
--~    - Inscription 
--~    - Jewelcrafting 
--~    - Leatherworking
--~    - Poisons 
--~    - Smelting
--~    - Tailoring       
--~ ["m,Tradeskill.Mat.ByProfession.Alchemy,Tradeskill.Tool.Alchemy,Tradeskill.Recipe.Alchemy"]
pt:AddData("Luggage_Alchemy", "m,Tradeskill.Mat.ByProfession.Alchemy,Tradeskill.Tool.Alchemy,Tradeskill.Recipe.Alchemy")
pt:AddData("Luggage_Blacksmithing", "m,Tradeskill.Mat.ByProfession.Blacksmithing,Tradeskill.Tool.Blacksmithing,Tradeskill.Recipe.Blacksmithing")
pt:AddData("Luggage_Cooking", "m,Tradeskill.Mat.ByProfession.Cooking,Tradeskill.Tool.Cooking,Tradeskill.Recipe.Cooking")
pt:AddData("Luggage_Enchanting", "m,Tradeskill.Mat.ByProfession.Enchanting,Tradeskill.Tool.Enchanting,Tradeskill.Recipe.Enchanting")
pt:AddData("Luggage_Engineering", "m,Tradeskill.Mat.ByProfession.Engineering,Tradeskill.Tool.Engineering,Tradeskill.Recipe.Engineering")
pt:AddData("Luggage_First Aid", "m,Tradeskill.Mat.ByProfession.First Aid,Tradeskill.Tool.First Aid,Tradeskill.Recipe.First Aid")
pt:AddData("Luggage_Fishing", "m,Tradeskill.Mat.ByProfession.Fishing,Tradeskill.Tool.Fishing,Tradeskill.Recipe.Fishing")
pt:AddData("Luggage_Inscription", "m,Tradeskill.Mat.ByProfession.Inscription,Tradeskill.Tool.Inscription,Tradeskill.Recipe.Inscription")
pt:AddData("Luggage_Jewelcrafting", "m,Tradeskill.Mat.ByProfession.Jewelcrafting,Tradeskill.Tool.Jewelcrafting,Tradeskill.Recipe.Jewelcrafting")
pt:AddData("Luggage_Leatherworking", "m,Tradeskill.Mat.ByProfession.Leatherworking,Tradeskill.Tool.Leatherworking,Tradeskill.Recipe.Leatherworking")
pt:AddData("Luggage_Poisons", "m,Tradeskill.Mat.ByProfession.Poisons,Tradeskill.Tool.Poisons,Tradeskill.Recipe.Poisons")
pt:AddData("Luggage_Smelting", "m,Tradeskill.Mat.ByProfession.Smelting,Tradeskill.Tool.Smelting,Tradeskill.Recipe.Smelting")
pt:AddData("Luggage_Tailoring", "m,Tradeskill.Mat.ByProfession.Tailoring,Tradeskill.Tool.Tailoring,Tradeskill.Recipe.Tailoring")

local tradeSkillSets = {
"Luggage_Alchemy",
"Luggage_Blacksmithing", 
"Luggage_Cooking",
"Luggage_Enchanting",
"Luggage_Engineering",
"Luggage_First Aid",
"Luggage_Fishing",
"Luggage_Inscription",
"Luggage_Jewelcrafting", 
"Luggage_Leatherworking",
"Luggage_Poisons",
"Luggage_Smelting",
"Luggage_Tailoring",
}

Luggage:RegisterFilter("Tradeskill(PT)", {
   name = L["Tradeskill (PT)"],
   tooltipText = L["Just like the Tradeskill filter, but with Periodic Table support"],
   values = {
      {
         name = L["Alchemy"],
         tooltipText = L["Mixing colorful liquids"],
      },
      {
         name = L["Blacksmithing"],
         tooltipText = L["Making sharp and hard things"],
      },
      {
         name = L["Cooking"],
         tooltipText = L["Baking powder, flour, a bit of battery acid and a few giant raptor eggs. Bake in dragon fire for 3 minutes."],
      },
      {
         name = L["Enchanting"],
         tooltipText = L["Making things glow"],
      },
      {
         name = L["Engineering"],
         tooltipText = L["Of course this will work! Oh, you mean that black spot over there? That was nothing, just my last assistant."],
      },
      {
         name = L["First Aid"],
         tooltipText = L["Ouch!"],
      },
      {
         name = L["Fishing"],
         tooltipText = L["What is that shadow under the boat?"],
      },
      {
         name = L["Inscription"],
         tooltipText = L["Paperwork all day long"],
      },
      {
         name = L["Jewelcrafting"],
         tooltipText = L["Making shiny things shinier"],
      },
      {
         name = L["Leatherworking"],
         tooltipText = L["Awww, hell, there goes another needle. I hate dragon scales."],
      },
      {
         name = L["Poisons"],
         tooltipText = L["I love making tea for someone else!"],
      },
      {
         name = L["Smelting"],
         tooltipText = L["Has someone seen my wedding ring?"],
      },
      {
         name = L["Tailoring"],
         tooltipText = L["Shirts of all colors (some unspeakable)"],
      },
   },
   func = function(bag, item, ptSet)
      return pt:ItemInSet(item.itemID, tradeSkillSets[ptSet])
   end,   
})