local L = LibStub("AceLocale-3.0"):GetLocale("Luggage")
local Sets = {}

Luggage:RegisterFilter("EquipmentManager", {
   name = "Equipment Sets",
   tooltipText = L["Filter by Equipment Set"],
   values = function()
      local numSets = GetNumEquipmentSets()
      for i=1,numSets do
         local setName = GetEquipmentSetInfo(i)
         Sets[setName] = {name = setName}
      end
      return Sets
   end,
   func = function(bag, itemTable, setName)
      local itemIDs = GetEquipmentSetItemIDs(setName)
      if not itemIDs then return end
      for i=1,#itemIDs do
         if itemIDs[i] == itemTable.itemID then
            return true
         end
      end
   end,
})