local L = LibStub("AceLocale-3.0"):GetLocale("Luggage")

local function callOnAllBagBars(func, ...)
   for index, bagbar in pairs(Luggage.bagbars) do
      bagbar[func](bagbar, ...)
   end
end

local function callOnAllBagsInBagBar(bagbar, func, ...)
   for index, bag in pairs(bagbar.bags) do
      bag[func](bag, ...)
   end
end

local function callOnAllBags(func, ...)
   for bag in pairs(Luggage.bags) do
      bag[func](bag, ...)
   end
end

local newBarName = ""
Luggage.GetOptionsTable = function()
   local self = Luggage
   local options = self.options
   local globalBagBarsSVs = self.db.profile.global.bagbars
   local globalBagSVs = self.db.profile.global.bags
   if not Luggage.globalBag then
      Luggage.globalBag = Luggage.MultiBag:New(globalBagSVs, Luggage.bags)
      Luggage.globalBag.savedVars.name = L["Global bag options"]
   end
   local globalBagOptions = Luggage.globalBag:GetOptions()
   globalBagOptions.name = ""
   globalBagOptions.desc = L["These settings are applied to all Luggage bags"]
   globalBagOptions.inline = true
   globalBagOptions.order = 90
   if not options then
      options = {
         type = "group",
         childGroups = "tree",
         args = {
            options = {
               name = L["Options"],
               desc = L["General settings"],
               type = "group",
               order = 10,
               args = {
                  placement = {
                     type = "execute",
                     name = L["Adjust Bag Placement"],
                     desc = L["Shows a frame where you can make various settings for automatic bag placement."],
                     order = 10,
                     func = function() Luggage:ShowPlacementFrame() end,
                  },
                  break1 = {
                     order = 20,
                     type = "description",
                     name = "\n",
                  },
                  blizzardBank = {
                     type = "toggle",
                     name = L["Show Default Bank"],
                     desc = L["If checked, the default bank frame will still be displayed alongside Luggage bag bars. Useful if you want to swap out bags."],
                     order = 30,
                     get = function() return Luggage.db.profile.blizzardBankEnabled end,
                     set = function(info, value) Luggage:SetBlizzardBankEnabled(value) end,
                  },
                  blizzardBags = {
                     type = "toggle",
                     name = L["Show Default Bags"],
                     desc = L["If checked, the default bag frames will still be displayed alongside Luggage bags."],
                     order = 40,
                     get = function() return Luggage.db.profile.blizzardBagsEnabled end,
                     set = function(info, value) Luggage:SetBlizzardBagsEnabled(value) end,
                  },
               },
            },
            bars = {
               type = "group",
               name = L["Bagbars"],
               desc = "",
               childGroups = "tree",
               args = {
                  newBarHeader = {
                     type = "header",
                     name = L["New Bar"],
                     order = 10,
                  },
                  barName = {
                     type = "input",
                     name = L["New Bar Name"],
                     desc = L["The name of the new bar"],
                     order = 20,
                     get = function() return newBarName end,
                     set = function(info, value) newBarName = value end,
                     validate = function(info, name)
                        local bagbarSV = self.db.profile.bagbars[name]
                        for i, bagbar in pairs(Luggage.bagbars) do
                           if bagbar.savedVars == bagbarSV then
                              return false
                           end
                           return true
                        end
                     end,
                     usage = string.format(L["There already is a bag bar with this name. Please choose another name."]),
                  },
                  newBar = {
                     name = L["New Bag Bar"],
                     desc = L["Create a new bag bar"],
                     order = 30,
                     type = "execute",
                     func = function()
                        local bagbarSV = self.db.profile.bagbars[newBarName]
                        table.insert(self.bagbars, Luggage.BagBar:New(newBarName, bagbarSV))
                     end,
                  },
                  break2 = {
                     order = 40,
                     type = "description",
                     name = "\n",
                  },                  
                  globalBarOptionsHeader = {
                     type = "header",
                     name = L["Global bag bar options"],
                     order = 50,
                  },
                  globalBagbars = {
                     type = "group",
                     inline = true,
                     name = L["Global Bar Layout"],
                     desc = "",
                     order = 60,
                     args = {
                        inset = {
                           type = "range",
                           name = L["Bag Button Inset"],
                           desc = L["The distance between the bag buttons and the edge of the bag bar frame."],
                           min = 0,
                           max = 20,
                           step = 1,
                           get = function() return globalBagBarsSVs.bagInset end,
                           set = function(info, value) 
                              globalBagBarsSVs.bagInset = value
                              callOnAllBagBars("SetBagInset", value) 
                           end,
                        },
                        padding = {
                           type = "range",
                           name = L["Bag Button Padding"],
                           desc = L["The distance between two bag buttons in this bar."],
                           min = 0,
                           max = 20,
                           step = 1,
                           get = function() return globalBagBarsSVs.bagPadding end,
                           set = function(info, value)
                              globalBagBarsSVs.bagPadding = value
                              callOnAllBagBars("SetBagPadding",value) 
                           end,
                        },
                        size = {
                           type = "range",
                           name = L["Bag Button Size"],
                           desc = L["The size of this bar's bag buttons."],
                           min = 10,
                           max = 50,
                           step = 1,
                           get = function() return globalBagBarsSVs.bagButtonSize end,
                           set = function(info, value) 
                              globalBagBarsSVs.bagButtonSize = value
                              callOnAllBagBars("SetBagButtonSize", value) 
                           end,
                        },
                     },
                  },
                  break3 = {
                     order = 70,
                     type = "description",
                     name = "\n",
                  },                  
                  globalBarOptionsHeader = {
                     type = "header",
                     name = L["Global Bag Options"],
                     order = 80,
                  },
                  globalBags = globalBagOptions,
               },
            },
         },
      }
      self.options = options
   end
   local bagbarOptions = options.args.bars.args
   for index, bagbar in pairs(self.bagbars) do
      local barName = bagbar.name
      local globalBagSVs = bagbar.savedVars.global.bags
      if not bagbarOptions[barName] then
         bagbarOptions[barName] = bagbar:GetOptions()
      end
   end
   options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(Luggage.db)
   return options
end


function Luggage:UpdateOptions()
   self.options = nil
   self:GetOptionsTable()
   LibStub("AceConfigRegistry-3.0"):NotifyChange("Luggage")
end
