local L = LibStub("AceLocale-3.0"):GetLocale("Luggage")

---------------------------------------
-- Multi Bag --------------------------
---------------------------------------
local MultiBag = {}
local GetMultiBag, DepositMultiBag = Luggage:GetCompost()

function MultiBag:New(savedVars, bagList)
   local newBag = GetMultiBag()
   if not newBag then
      newBag = {
      }
      setmetatable(newBag, {__index = self})
   end
   newBag.bagList = bagList
   newBag.savedVars = savedVars
   return newBag
end

function MultiBag:Release()
   self.bagList = nil
   self.savedVars = nil
   DepositMultiBag(self)
end

MultiBag.GetOptions = Luggage.Bag.GetOptions

local options = {
   "ItemButtonSize",
   "Inset",
   "Padding",
   "Columns",
   "GrowUpwards",
   "GrowLeft",
   "ShowAt",
   "Color",
}

function MultiBag:CallOnAllBags(func, ...)
   for bag in pairs(self.bagList) do
      bag[func](bag, ...)
   end
end

function MultiBag:GetItemButtonSize()
   return self.savedVars.itemSize
end

function MultiBag:SetItemButtonSize(value)
   self:CallOnAllBags("SetItemButtonSize", value)
   self.savedVars.itemSize = value
end

function MultiBag:GetInset()
   return self.savedVars.inset
end

function MultiBag:SetInset(value)
   self:CallOnAllBags("SetInset", value)
   self.savedVars.inset = value
end

function MultiBag:GetPadding()
   return self.savedVars.padding
end

function MultiBag:SetPadding(value)
   self:CallOnAllBags("SetPadding", value)
   self.savedVars.padding = value
end

function MultiBag:GetColumns()
   return self.savedVars.columns
end

function MultiBag:SetColumns(value)
   self:CallOnAllBags("SetColumns", value)
   self.savedVars.columns = value
end

function MultiBag:GetGrowUpwards()
   return self.savedVars.growUpwards
end

function MultiBag:SetGrowUpwards(value)
   self:CallOnAllBags("SetGrowUpwards", value)
   self.savedVars.growUpwards = value
end

function MultiBag:GetGrowLeft()
   return self.savedVars.growLeft
end

function MultiBag:SetGrowLeft(value)
   self:CallOnAllBags("SetGrowLeft", value)
   self.savedVars.growLeft = value
end

function MultiBag:GetShowAt(key)
   return self.savedVars[key]
end

function MultiBag:SetShowAt(key, value)
   self:CallOnAllBags("SetShowAt", key, value)
   self.savedVars[key] = value
end

function MultiBag:GetColor()
   local color = self.savedVars.color
   return color.r, color.g, color.b, color.a
end

function MultiBag:SetColor(r,g,b,a)
   self:CallOnAllBags("SetColor", r,g,b,a)
   local color = self.savedVars.color
   color.r = r
   color.g = g
   color.b = b
   color.a = a
end

function MultiBag:GetHideWhenEmpty()
   return self.savedVars.hideWhenEmpty
end

function MultiBag:SetHideWhenEmpty(value)
   self:CallOnAllBags("SetHideWhenEmpty", value)
   self.savedVars.hideWhenEmpty = value
end

function MultiBag:GetHideAnimation()
   return self.savedVars.hideAnimation
end

function MultiBag:SetHideAnimation(value)
   self:CallOnAllBags("SetHideAnimation", value)
   self.savedVars.hideAnimation = value
end

Luggage.MultiBag = MultiBag