Luggage = LibStub("AceAddon-3.0"):NewAddon("Luggage", "AceEvent-3.0", "AceHook-3.0")
--Luggage.db = LibStub:GetLibrary("AceDB-3.0"):New("LuggageDB")
local libBaggage = LibStub:GetLibrary("LibBaggage-1.0")


local L = LibStub("AceLocale-3.0"):GetLocale("Luggage")

Luggage.bags = {}
Luggage.filters = {}

local function CreateDummyBagFrames()
   local dummyBagFrames = {}
   local frame
   for i=0,NUM_BAG_SLOTS+NUM_BANKBAGSLOTS do
      frame = CreateFrame("Frame", "Luggage_DummyBag_"..i, UIParent)
      frame:SetID(i)
      frame:SetFrameStrata("High")
      dummyBagFrames[i] = frame
   end
   -- Bank (28 slot window)
   frame = CreateFrame("Frame", "Luggage_DummyBag_Bank", UIParent)
   frame:SetID(-1)
   frame:SetFrameStrata("High")
   dummyBagFrames[-1] = frame
   -- Keyring
   frame = CreateFrame("Frame", "Luggage_DummyBag_KeyRing", UIParent)
   frame:SetID(KEYRING_CONTAINER)
   frame:SetFrameStrata("High")
   dummyBagFrames[KEYRING_CONTAINER] = frame
   Luggage.dummyBagFrames = dummyBagFrames
end

function Luggage:OnInitialize() 
   Luggage.db = LibStub("AceDB-3.0"):New("LuggageDB", Luggage.defaultOptions, "char")
   --Luggage.db:RegisterDefaults()
   CreateDummyBagFrames()
	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("Luggage", Luggage.GetOptionsTable)
	LibStub("AceConfigDialog-3.0"):AddToBlizOptions("Luggage", "Luggage", nil)
   self.tooltip = CreateFrame("GameTooltip", "Luggage_Tooltip", UIParent, "GameTooltipTemplate")
   self.bagbars = {}
end

function Luggage:OnEnable()
   libBaggage.RegisterCallback(Luggage, "LibBaggage_ItemAdded")
   libBaggage.RegisterCallback(Luggage, "LibBaggage_ItemRemoved")
   libBaggage.RegisterCallback(Luggage, "LibBaggage_FullRescanDone")
   libBaggage.RegisterCallback(Luggage, "LibBaggage_ItemLockChanged")
   self.db.RegisterCallback(Luggage, "OnProfileChanged")
   self:RegisterEvent("BANKFRAME_OPENED")
   self:RegisterEvent("BANKFRAME_CLOSED")
   self:RegisterEvent("GUILDBANKFRAME_OPENED")
   self:RegisterEvent("GUILDBANKFRAME_CLOSED")
   self:RegisterEvent("MAIL_SHOW")
   self:RegisterEvent("MAIL_CLOSED")
   self:RegisterEvent("AUCTION_HOUSE_SHOW")
   self:RegisterEvent("AUCTION_HOUSE_CLOSED")
   self:RegisterEvent("MERCHANT_SHOW")
   self:RegisterEvent("MERCHANT_CLOSED")
   self:AssertDefaults()
   self:SetBlizzardBankEnabled(Luggage.db.profile.blizzardBankEnabled)
   self:SetBlizzardBagsEnabled(Luggage.db.profile.blizzardBagsEnabled)
   self:BuildBagBars()
   self:LocalizeBindings()
   SlashCmdList["LUGGAGE"] = function() LibStub("AceConfigDialog-3.0"):Open("Luggage") end
   SLASH_LUGGAGE1 = "/luggage";
end

function Luggage:OnDisable()
   libBaggage.UnregisterCallback(Luggage, "LibBaggage_ItemAdded")
   libBaggage.UnregisterCallback(Luggage, "LibBaggage_ItemRemoved")
   libBaggage.UnregisterCallback(Luggage, "LibBaggage_FullRescanDone")
end

-- Source: http://lua-users.org/wiki/CopyTable
local function deepcopy(object)
    local lookup_table = {}
    local function _copy(object)
        if type(object) ~= "table" then
            return object
        elseif lookup_table[object] then
            return lookup_table[object]
        end
        local new_table = {}
        lookup_table[object] = new_table
        for index, value in pairs(object) do
            new_table[_copy(index)] = _copy(value)
        end
        return new_table
    end
    return _copy(object)
end

function Luggage:AssertDefaults()
   -- Do we have to import default bags?
   local hasBagbars
   for key, options in pairs(self.db.profile.bagbars) do
      hasBagbars = true
      break
   end
   if not hasBagbars then
      for name, bagBarDefaults in pairs(Luggage.defaultBagbars) do
         self.db.profile.bagbars[name] = deepcopy(bagBarDefaults)
      end
      self.db:RegisterDefaults(Luggage.defaultOptions)
   end
   for i, bagbar in pairs(self.bagbars) do
      bagbar:Release()
      self.bagbars[i] = nil
   end
end

function Luggage:OnProfileChanged(event, db, newKey)
   self:AssertDefaults()
   self:BuildBagBars()
   self:FullUpdate()
end

function Luggage:LocalizeBindings()
   BINDING_HEADER_Luggage = "Luggage"
   BINDING_NAME_LUGGAGE_TOGGLE_ALL_BAGS = L["Toggle all bags"]
   for i=1,5 do
      _G[("BINDING_NAME_LUGGAGE_TOGGLE_SET_%d"):format(i)] = L["Toggle bag set %s"]:format(i)
   end
end

function Luggage:BANKFRAME_OPENED()
   for index, bagbar in ipairs(self.bagbars) do
      if bagbar.savedVars.showAtBank then
         bagbar:Show()
      end
   end
   self:ToggleBags("showAtBank", true)
end

function Luggage:BANKFRAME_CLOSED()
   for index, bagbar in ipairs(self.bagbars) do
      if bagbar.savedVars.showAtBank then
         bagbar:Hide()
      end
   end
   self:ToggleBags("showAtBank", false)
end

function Luggage:GUILDBANKFRAME_OPENED()
   for index, bagbar in ipairs(self.bagbars) do
      if bagbar.savedVars.showAtGuildBank then
         bagbar:Show()
      end
   end
   self:ToggleBags("showAtGuildbank", true)
end

function Luggage:GUILDBANKFRAME_CLOSED()
   for index, bagbar in ipairs(self.bagbars) do
      if bagbar.savedVars.showAtGuildbank then
         bagbar:Hide()
      end
   end
   self:ToggleBags("showAtGuildbank", false)
end

function Luggage:MAIL_SHOW()
   self:ToggleBags("showAtMailbox", true)
end

function Luggage:MAIL_CLOSED()
   self:ToggleBags("showAtMailbox", false)
end

function Luggage:AUCTION_HOUSE_SHOW()
   self:ToggleBags("showAtAuctionHouse", true)
end

function Luggage:AUCTION_HOUSE_CLOSED()
   self:ToggleBags("showAtAuctionHouse", false)
end

function Luggage:MERCHANT_SHOW()
   self:ToggleBags("showAtVendor", true)
end

function Luggage:MERCHANT_CLOSED()
   self:ToggleBags("showAtVendor", false)
end

function Luggage:ToggleBags(key, forceOpen)
   local open
   if forceOpen ~= nil then 
      open = forceOpen
   else
      open = not self:IsBagSetOpen(key)
   end
   for bag in pairs(self.bags) do
      if bag.savedVars[key] then
         if open then
            bag:Show()
         else
            bag:Hide()
         end
      end
   end
end

function Luggage:IsBagSetOpen(key)
   for bag in pairs(self.bags) do
      if bag.savedVars[key] then
         local itemList = bag:GetItemList()
         if not bag:IsShown() and not (bag.savedVars.hideWhenEmpty and #itemList == 0) then
            return false
         end
      end
   end
   return true
end

function Luggage:ToggleAllBags()
   local key = "showOnToggleAll"
   Luggage:ToggleBags(key)
end

function Luggage:ToggleBagSet(setNumber)
   local key = ("showOnToggleSet%d"):format(setNumber)
   Luggage:ToggleBags(key)
end

function Luggage:LibBaggage_ItemLockChanged(event, bagID, slotID)
   for bag in pairs(self.bags) do
      bag:UpdateItemLock(bagID, slotID)
   end
end

function Luggage:NewBagBar()
   StaticPopupDialogs["Luggage_NewBagBar"] = {
      text = L["Please enter a name for the new bag bar:"],
      button1 = L["Accept"],
      button2 = L["Cancel"],
      OnShow = function()
         getglobal(this:GetName().."EditBox"):SetText("")
      end,
      OnAccept = function()
         local name = getglobal(this:GetParent():GetName().."EditBox"):GetText()
         if name ~= "" then
         end
      end,
      hasEditBox = 1,
      timeout = 0,
      whileDead = 1,
      hideOnEscape = 1
   }
   StaticPopup_Show ("Luggage_NewBagBar")
end

function Luggage:BuildBagBars()
   local bagbars = self.db.profile.bagbars
   local savedBagBars = self.db.profile.bagbars
   if not self.bagbars then
      self.bagbars = {}
   end
   for name, bagBarSV in pairs(savedBagBars) do
      table.insert(self.bagbars, Luggage.BagBar:New(name, bagBarSV))
   end
end

function Luggage:RegisterBagForEvents(bag)
   self.bags[bag] = true
   for item in libBaggage:AllItems() do
      if bag:ContainsItem(item) then
         bag:AddItem(item)
      end
   end
end

function Luggage:UnregisterBagForEvents(bag)
   self.bags[bag] = nil
end

Luggage.emptySlot = {}
function Luggage:GetEmptySlotTable(bag)
   local empty = self.emptySlot
   empty.bagID, empty.slotID = libBaggage:GetFreeSlot(bank)
   local locationFilter = bag.savedVars.filters.Location
   if not locationFilter then return end
   if locationFilter[2] == false and locationFilter[1] ~= false then
      empty.stackCount = libBaggage:GetTotalFreeBankSpace()
   elseif locationFilter[2] ~= false and locationFilter[1] == false then
      empty.stackCount = libBaggage:GetTotalFreeMainBagSpace()
   end
   if empty.stackCount == 0 then
      return nil
   else
      return empty
   end
end

function Luggage:RegisterFilter(id, filterTable, override)
   local filters = self.filters
   if filters[id] and not override then
      return false
   end
   assert(type(filterTable) == "table")
   filters[id] = filterTable
end


function Luggage:OnIconChosen(icon, name)
   if icon then
      self.iconCallback(icon, name)
   end
   self.iconCallback = nil
   self.iconCallBackArgs = nil
end

function Luggage:AskUserForIconAndName(callback, name, icon)
   self.iconCallback = callback
   local dialog = self.dialog
   if not dialog then
      self:CreateDialog()
      dialog = self.dialog
   end
   self.dialogMatrix.status.selectedButtonValue = icon
   self.dialogNameBox:SetText(name)
   self.dialogMatrix:SetButtonTable({})
   dialog:Show()
end

function Luggage:SetBlizzardBankEnabled(value)
   Luggage.db.profile.blizzardBankEnabled = value
   if value then
      self:EnableBlizzardBank()
   else
      self:DisableBlizzardBank()
   end
end

function Luggage:EnableBlizzardBank()
   UIPanelWindows["BankFrame"] = { area = "left", pushable = 6, width = 425 };
   BankFrame:ClearAllPoints()
   BankFrame:Hide()
end

function Luggage:DisableBlizzardBank()
   UIPanelWindows["BankFrame"] =	nil
   BankFrame:ClearAllPoints()
   BankFrame:SetPoint("BOTTOMRIGHT", UIParent, "TOPLEFT", -100, 100)
end

function Luggage:SetBlizzardBagsEnabled(value)
   Luggage.db.profile.blizzardBagsEnabled = value
   if value then
      self:EnableBlizzardBags()
   else
      self:DisableBlizzardBags()
   end
end

function Luggage:EnableBlizzardBags()
   self:Unhook("OpenBackpack")
   self:Unhook("ToggleBackpack")
   self:Unhook("OpenBag")
   self:Unhook("ToggleBag")
   self:Unhook("OpenAllBags")
end

function Luggage:DisableBlizzardBags()
   self:RawHook("OpenBackpack", "DevNull", true )
   self:RawHook("ToggleBackpack", "DevNull", true )
   self:RawHook("OpenBag", "DevNull", true )
   self:RawHook("ToggleBag", "DevNull", true )
   self:RawHook("OpenAllBags", "DevNull", true )
   for i=1, NUM_CONTAINER_FRAMES, 1 do
      local frame = getglobal("ContainerFrame"..i);
      frame:Hide()
   end
end

function Luggage:DevNull()
end

function Luggage:UpdateOptions()
   LibStub("AceConfigDialog-3.0"):ConfigTableChanged(nil, "Luggage")
end

function Luggage:FullUpdate()
   for bag in pairs(self.bags) do
      bag:Clear()
   end
   for item in libBaggage:AllItems() do
      self:SortItem(item)
   end
   for bag in pairs(self.bags) do
      bag:UpdateItemButtons()
   end
end

local bagsInNeedOfUpdate = {}
function Luggage:SortItem(item)
   for bag in pairs(self.bags) do
      if bag:ContainsItem(item) then
         bag:AddItem(item)
         bagsInNeedOfUpdate[bag] = true
      end
      if bag.savedVars.showEmptySlot then
         bag:UpdateEmptySlot()
      end
      bag:UpdateBagSpace()
   end
   for bag in pairs(bagsInNeedOfUpdate) do
      bag:UpdateItemButtons()
      bagsInNeedOfUpdate[bag] = nil
   end
end

function Luggage:UnsortItem(item)
   for bag in pairs(self.bags) do
      bag:RemoveItem(item)
      bag:UpdateBagSpace()
   end
end

function Luggage:LibBaggage_ItemAdded(event, bagID, slotID)
   local item = libBaggage:GetItem(bagID, slotID)
   if type(slotID) ~= "number" then return end
   self:SortItem(item)
end

function Luggage:LibBaggage_ItemRemoved(event, item)
   if type(item.slotID) ~= "number" then return end
   self:UnsortItem(item)
end

function Luggage:LibBaggage_FullRescanDone(event)
   self:FullUpdate()
end
