local L = LibStub("AceLocale-3.0"):GetLocale("Luggage")

-- A layout that allocates 10% of the height for the first object and
-- 90% for the second
LibStub("AceGUI-3.0"):RegisterLayout("10-90-Height",
   function(content, children)
      local child1 = children[1]
      local child2 = children[2]
      if child1 and child2 then
         child1:SetWidth(content:GetWidth() or 0)
         child1:SetHeight(0.1*content:GetHeight() or 0)
         child1.frame:ClearAllPoints()
         child1.frame:SetPoint("TOPLEFT", content, "TOPLEFT")
         child1.frame:SetPoint("TOPRIGHT", content, "TOPRIGHT")
         child1.frame:Show()

         child2:SetWidth(content:GetWidth() or 0)
         -- Only 88%, otherwise it causes overlap in the outer frame
         child2:SetHeight(0.88*content:GetHeight() or 0)
         child2.frame:ClearAllPoints()
         child2.frame:SetPoint("TOPLEFT", child1.frame, "BOTTOMLEFT")
         child2.frame:SetPoint("TOPRIGHT", child1.frame, "BOTTOMRIGHT")
         child2.frame:Show()
		end      
   end
)

-- Source: http://lua-users.org/wiki/StringRecipes
-- Compatibility: Lua-5.0
local function Split(str, delim, maxNb)
    -- Eliminate bad cases...
    if string.find(str, delim) == nil then
        return { str }
    end
    if maxNb == nil or maxNb < 1 then
        maxNb = 0    -- No limit
    end
    local result = {}
    local pat = "(.-)" .. delim .. "()"
    local nb = 0
    local lastPos
    for part, pos in string.gmatch(str, pat) do
        nb = nb + 1
        result[nb] = part
        lastPos = pos
        if nb == maxNb then break end
    end
    -- Handle the last field
    if nb ~= maxNb then
        result[nb + 1] = string.sub(str, lastPos)
    end
    return result
end

function Luggage:CreateDialog()
   local iconTree = self.IconTree
   self.IconTree:Create()
   local acegui = LibStub("AceGUI-3.0")
   local dialog = acegui:Create("OptionsFrame")
   local tree = acegui:Create("TreeGroup")
   local scroll = acegui:Create("ScrollFrame")
   local matrix = acegui:Create("ButtonMatrix")
   local nameBox =acegui:Create("EditBox")
   local searchBox =acegui:Create("EditBox")
   local treeTable = iconTree:GetTableForTreeView()
   dialog:SetLayout("10-90-Height")
   tree:SetLayout("10-90-Height")
   scroll:SetLayout("Fill")
   tree:SetTree(treeTable)
   nameBox:SetLabel(L["Enter Name:"])
   searchBox:SetLabel(L["Search Icon List:"])
   matrix.userdata.tree = tree
   tree:SetCallback("OnGroupSelected", 
      function(self, event, value) 
         local buttonTable = iconTree:GetButtonTableForPath(Split(self.localstatus.selected, "\001"))
         matrix:SetButtonTable(buttonTable)
      end
   )
   dialog:SetCallback("OnOK", 
      function()
         Luggage:OnIconChosen(matrix.status.selectedButtonValue, nameBox.lasttext)
      end
   )
   searchBox:SetCallback("OnEnterPressed",
      function(editBox, event, searchText)
         if string.len(searchText) == 0 then return end
         local buttonTable = iconTree:SearchAndConvertToButtonTable(searchText)
         matrix:SetButtonTable(buttonTable)
      end
   )
   scroll:AddChild(matrix)
   tree:AddChild(searchBox)
   tree:AddChild(scroll)
   dialog:AddChild(nameBox)
   dialog:AddChild(tree)
   self.dialog = dialog
   self.dialogNameBox = nameBox
   self.dialogMatrix = matrix
end
