local libBaggage = LibStub:GetLibrary("LibBaggage-1.0")
local L = LibStub("AceLocale-3.0"):GetLocale("Luggage")

local ItemButton = {}

-- Itembutton Frames --
local GetItemButtonFrame, DepositItemButtonFrame = Luggage:GetCompost()

-- Itembutton Objects --
local GetItemButton, DepositItemButton = Luggage:GetCompost()

local itemButtonNumber = 0
function ItemButton:New()
   local newButton = GetItemButton()
   if not newButton then 
      newButton = setmetatable({}, {__index = self})
   end
   local frame = GetItemButtonFrame()
   if not frame then
      frame = CreateFrame("Button", "Luggage_ItemButton_"..itemButtonNumber, nil, "ContainerFrameItemButtonTemplate")
      frame:SetFrameStrata("HIGH")
      itemButtonNumber = itemButtonNumber + 1
--~       frame.countText = getglobal(frame:GetName().."Count")
--~       frame.frameTexture = getglobal(frame:GetName().."IconTexture")
      frame.normalOnEnter = frame:GetScript("OnEnter")
   end
   newButton:SetFrame(frame)
   frame.obj = newButton
   return newButton
end

function ItemButton:Release()
   local frame = self.frame
   frame:SetParent(UIParent)
   frame:ClearAllPoints()
   frame:Hide()
   DepositItemButtonFrame(frame)
   self:SetItem(nil)
   self.frame = nil
   DepositItemButton(self)
end

function ItemButton:SetFrame(frame)
   self.frame = frame
   frame.obj = self
end

function ItemButton:SetItem(item)
   local frame = self.frame
   if not item then
      frame:ClearAllPoints()
      frame:SetParent(UIParent)
      frame:Hide()
      return
   end
   self.itemID = item.itemID
   self.itemLink = item.link
   if item.bagID == "bank" then
      self.bagID = -1
   elseif item.bagID == "keyring" then
      self.bagID = KEYRING_CONTAINER
   else
      self.bagID = item.bagID
   end
   self.slotID = item.slotID
   self:SetSlot(self.bagID, self.slotID)
   SetItemButtonTexture(frame, item.icon);
   SetItemButtonCount(frame, item.stackCount);
   self:SetLocked(item.locked)
   
   if ( item.icon) then
      ContainerFrame_UpdateCooldown(self.bagID, frame);
      frame.hasItem = 1;
      frame.locked = locked;
      frame.readable = readable;
   else
      getglobal(frame:GetName().."Cooldown"):Hide();
      frame.hasItem = nil;
   end
   self.frame:Show()
end

function ItemButton:UseNormalOnEnter(bagID, slotID)
   if getglobal("BankFrame"):IsShown() then
      return true
   end
   if type(bagID) == "number" and bagID >= 0 and bagID <= NUM_BAG_SLOTS then
      return true
   end
end

local function newOnEnter(self)
   local x;
   x = self:GetRight();
   if ( x >= ( GetScreenWidth() / 2 ) ) then
      GameTooltip:SetOwner(self, "ANCHOR_LEFT");
   else
      GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
   end
   GameTooltip:SetHyperlink(self.obj.itemLink)
   GameTooltip:AddLine(L["Item is in bank"])
   GameTooltip:Show()
end

local function bankOnEnter(self)
   local x;
   x = self:GetRight();
   if ( x >= ( GetScreenWidth() / 2 ) ) then
      GameTooltip:SetOwner(self, "ANCHOR_LEFT");
   else
      GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
   end
   GameTooltip:SetInventoryItem("player", BankButtonIDToInvSlotID(self.obj.slotID))
   GameTooltip:Show()
end

function ItemButton:SetSlot(bagID, slotID)
   local frame = self.frame
   if self:UseNormalOnEnter(bagID, slotID) then
      frame:SetID(slotID)
      frame:SetParent(Luggage.dummyBagFrames[bagID])
      if bagID == -1 then
         frame:SetScript("OnEnter", bankOnEnter)
         frame.UpdateTooltip = bankOnEnter
      else
         frame:SetScript("OnEnter", frame.normalOnEnter)
         frame.UpdateTooltip = frame.normalOnEnter
      end
   else
      frame:SetID(slotID)
      frame:SetParent(Luggage.dummyBagFrames[bagID])
      frame:SetScript("OnEnter", newOnEnter)
      frame.UpdateTooltip = newOnEnter
   end
end

local texFactor = 64/37
function ItemButton:SetSize(size)
   local frame = self.frame
   local tex = _G[frame:GetName().."NormalTexture"]
   frame:SetHeight(size)
   frame:SetWidth(size)
   local texSize = size*texFactor
   tex:SetHeight(texSize)
   tex:SetWidth(texSize)
end

function ItemButton:UpdateCooldown()
   ContainerFrame_UpdateCooldown(self.bagID, self.frame);
end

function ItemButton:SetLocked(locked)
   SetItemButtonDesaturated(self.frame, locked, 0.5, 0.5, 0.5);
end

Luggage.ItemButton = ItemButton