local L = LibStub("AceLocale-3.0"):GetLocale("Luggage")

local bankR, bankG, bankB, bankA = 0.3, 0.3, 0.8, 0.9
local defaults = {
   profile = {
      blizzardBagsEnabled = false,
      placement = {
         xOffs = -100,
         yOffs = 100,
         width = 200,
         height = 200,
         anchor = "BOTTOMRIGHT",
         primaryExpansion = "TOP",
         secondaryExpansion = "LEFT",
      },
      global = {
         bagbars = {
            bagInset = 5,
            bagPadding = 3,
            bagButtonSize = 30,
         },
         bags = {
            itemSize = 30,
            padding = 5,
            inset = 10,
            columns = 5,
            growLeft = nil,
            growUpwards = nil,
            color = {r = 0, g = 0, b = 0, a = 0.9},
            showOnToggleAll = true,
            playAnim = true,
            hideWhenEmpty = true,
         }
      },
      bagbars = {
         ["**"] = {
            bagInset = 5,
            bagPadding = 3,
            bagButtonSize = 30,
            point = "BOTTOMLEFT",
            x = 500,
            y = 500,
            showAlways = true,
            global = {
               bags = {
                  itemSize = 30,
                  padding = 5,
                  inset = 10,
                  columns = 5,
                  growLeft = nil,
                  growUpwards = nil,
                  color = {r = 0, g = 0, b = 0, a = 0.9},
               }
            },
            tabs = {
               ["**"] = {
                  icon = "Interface\\Icons\\INV_Misc_QuestionMark",
                  name = L["New Tab"],
                  bags = {
                     ["**"] = {
                        x = 400,
                        y = 400,
                        point = "BOTTOMLEFT",
                        itemSize = 30,
                        padding = 5,
                        inset = 10,
                        columns = 5,
                        growLeft = nil,
                        growUpwards = nil,
                        isUserPlaced = nil,
                        combineStacks = true,
                        itemIDs = {},
                        name = L["New Bag"],
                        icon = "Interface\\Icons\\INV_Misc_QuestionMark",
                        filters = {
                        },
                        showFreeSpace = 0,
                        showOnToggleAll = true,
                        color = {r = 0, g = 0, b = 0, a = 0.9},
                     },
                     {}, -- We need this empty table so that new tabs are properly populated with a "**" bag
                  },
               },
               {}, -- We need this empty table so that new bagbars are properly populated with a "**" tab
            },
         },
      },
   }
}

local defaultBagbars = {
   Inventory = {
      name = L["Inventory"],
      tabs = {
         {
            icon = "Interface\\Icons\\INV_Crate_02",
            name = L["Inventory"],
            bags = {
               {
                  name = L["Unsorted"],
                  icon = "Interface\\Icons\\INV_Box_01",
                  filters = {
                     Unsorted = true,
                     Location = {
                        false,
                        [3] = false,
                        [4] = false,
                     },
                  },
                  showAtBank = true,
                  showAtMailbox = true,
                  showAtVendor = true,
                  showAtAuctionHouse = true,
                  showAtGuildbank = true,
                  showEmptySlot = true,
                  showFreeSpace = 1,
               },
               {
                  name = L["Quest Items"],
                  icon = "Interface\\Icons\\INV_Scroll_08",
                  filters = {
                     Quest_Item = true,
                     Location = {
                        false,
                        [3] = false,
                        [4] = false,
                     },
                  },
               },
               {
                  name = L["Loot"],
                  icon = "Interface\\Icons\\INV_Misc_OrnateBox",
                  filters = {
                     Rarity = {
                        false,
                        false,
                        true,
                        true,
                        true,
                     },
                     Binding = {
                        ["BoP"] = false,
                        ["Soulbound"] = false,
                     },
                     Location = {
                        false,
                        [3] = false,
                        [4] = false,
                     },
                  },
                  showAtBank = true,
                  showAtMailbox = true,
                  showAtVendor = true,
                  showAtAuctionHouse = true,
                  showAtGuildbank = true,                  
               },
               {
                  name = L["Tradeskills"],
                  icon = "Interface\\Icons\\INV_Misc_Wrench_01",
                  filters = {
                     Tradeskill = {
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                     },
                     Location = {
                        false,
                        [3] = false,
                        [4] = false,
                     },
                  },
                  showAtBank = true,
                  showAtMailbox = true,
                  showAtVendor = true,
                  showAtAuctionHouse = true,
                  showAtGuildbank = true,                  
               },
               {
                  name = L["Trash"],
                  icon = "Interface\\Icons\\INV_Misc_Gear_08",
                  filters = {
                     Rarity = {
                        true,
                     },
                     Location = {
                        false,
                        [3] = false,
                        [4] = false,
                     },
                  },
                  showAtVendor = true,
               },
            },
         },
         {
            icon = "Interface\\Icons\\INV_Summerfest_Smorc",
            name = L["Consumables"],
            bags = {
               {
                  name = L["Potions"],
                  icon = "Interface\\Icons\\INV_Potion_142",
                  filters = {
                     Location = {
                        false,
                        [3] = false,
                        [4] = false,
                     },
                     Consumable = {
                        [2] = true,
                     },
                  },
                  showAtBank = true,
                  showAtAuctionHouse = true,
                  showAtGuildbank = true,                  
               },
               {
                  name = L["Flasks & Elixirs"],
                  icon = "Interface\\Icons\\INV_Potion_76",
                  filters = {
                     Location = {
                        false,
                        [3] = false,
                        [4] = false,
                     },
                     Consumable = {
                        [3] = true,
                        [4] = true,
                     },
                  },
                  showAtBank = true,
                  showAtAuctionHouse = true,
                  showAtGuildbank = true,                  
               },
               {
                  name = L["Food & Drink"],
                  icon = "Interface\\Icons\\INV_Misc_Food_100",
                  filters = {
                     Location = {
                        false,
                        [3] = false,
                        [4] = false,
                     },
                     Consumable = {
                        true,
                     },
                  },
                  showAtBank = true,
                  showAtVendor = true,
               },
               {
                  name = L["Reagents"],
                  icon = "Interface\\Icons\\INV_Misc_SymbolofKings_01",
                  filters = {
                     Location = {
                        false,
                        [3] = false,
                        [4] = false,
                     },
                     Type = {
                        [7] = true,
                     },
                  },
                  showAtBank = true,
                  showAtVendor = true,
               },
            }
         },
      },
   },
   Bank = {
      name = L["Bank"],
      showAtBank = true,
      showAlways = false,
      y = 300,
      tabs = {
         {
            icon = "Interface\\Icons\\INV_Crate_02",
            name = L["Bank"],
            bags = {
               {
                  name = L["Bank"].." "..L["Unsorted"],
                  icon = "Interface\\Icons\\INV_Box_01",
                  color = {r = bankR, g = bankG, b = bankB, a = bankA},
                  filters = {
                     Unsorted = true,
                     Location = {
                        [2] = false,
                        [3] = false,
                        [4] = false,
                     },
                  },
                  showFreeSpace = 1,
               },
               {
                  name = L["Bank"].." "..L["Quest Items"],
                  icon = "Interface\\Icons\\INV_Scroll_08",
                  color = {r = bankR, g = bankG, b = bankB, a = bankA},
                  filters = {
                     Quest_Item = true,
                     Location = {
                        [2] = false,
                        [3] = false,
                        [4] = false,
                     },
                  },
               },
               {
                  name = L["Bank"].." "..L["Loot"],
                  icon = "Interface\\Icons\\INV_Misc_OrnateBox",
                  color = {r = bankR, g = bankG, b = bankB, a = bankA},
                  filters = {
                     Rarity = {
                        false,
                        false,
                        true,
                        true,
                        true,
                     },
                     Binding = {
                        ["BoP"] = false,
                        ["Soulbound"] = false,
                     },
                     Location = {
                        [2] = false,
                        [3] = false,
                        [4] = false,
                     },
                  },
               },
               {
                  name = L["Bank"].." "..L["Tradeskills"],
                  icon = "Interface\\Icons\\INV_Misc_Wrench_01",
                  color = {r = bankR, g = bankG, b = bankB, a = bankA},
                  filters = {
                     Tradeskill = {
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                        true,
                     },
                     Location = {
                        [2] = false,
                        [3] = false,
                        [4] = false,
                     },
                  },
               },
               {
                  name = L["Bank"].." "..L["Trash"],
                  icon = "Interface\\Icons\\INV_Misc_Gear_08",
                  color = {r = bankR, g = bankG, b = bankB, a = bankA},
                  filters = {
                     Rarity = {
                        true,
                     },
                     Location = {
                        [2] = false,
                        [3] = false,
                        [4] = false,
                     },
                  },
               },
            },
         },
         {
            icon = "Interface\\Icons\\INV_Summerfest_Smorc",
            name = L["Consumables"],
            bags = {
               {
                  name = L["Bank"].." "..L["Potions"],
                  icon = "Interface\\Icons\\INV_Potion_142",
                  color = {r = bankR, g = bankG, b = bankB, a = bankA},
                  filters = {
                     Location = {
                        [2] = false,
                        [3] = false,
                        [4] = false,
                     },
                     Consumable = {
                        [2] = true,
                     },
                  },
               },
               {
                  name = L["Bank"].." "..L["Flasks & Elixirs"],
                  icon = "Interface\\Icons\\INV_Potion_76",
                  color = {r = bankR, g = bankG, b = bankB, a = bankA},
                  filters = {
                     Location = {
                        [2] = false,
                        [3] = false,
                        [4] = false,
                     },
                     Consumable = {
                        [3] = true,
                        [4] = true,
                     },
                  },
               },
               {
                  name = L["Bank"].." "..L["Food & Drink"],
                  icon = "Interface\\Icons\\INV_Misc_Food_100",
                  color = {r = bankR, g = bankG, b = bankB, a = bankA},
                  filters = {
                     Location = {
                        [2] = false,
                        [3] = false,
                        [4] = false,
                     },
                     Consumable = {
                        true,
                     },
                  },
               },
               {
                  name = L["Bank"].." "..L["Reagents"],
                  icon = "Interface\\Icons\\INV_Misc_SymbolofKings_01",
                  color = {r = bankR, g = bankG, b = bankB, a = bankA},
                  filters = {
                     Location = {
                        [2] = false,
                        [3] = false,
                        [4] = false,
                     },
                     Type = {
                        [7] = true,
                     },
                  },
               },
            }
         },
      },
   },
}
Luggage.defaultBagbars = defaultBagbars
Luggage.defaultOptions = defaults