local _G = _G
local white = "|cffffffff"
local L = Loremaster.L

local function mouseEnter(this)

	local parent = this:GetParent()
	
	if this.id ~= parent.selected then
	
		this:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background"})
		this:SetBackdropColor(0, 0, 0, 0.4)
		
	end
	
	if parent.name == "LoremasterQuestFrame" then
	
		if this.desc then
		
			Loremaster.ttscale = GameTooltip:GetScale()
			GameTooltip:SetScale(0.8)
			GameTooltip:SetOwner(this, "ANCHOR_TOP")
			GameTooltip:ClearLines()
			GameTooltip:SetText(this.c .. this.desc)
			GameTooltip:Show()
			
		end
		
	end
	
end

local function mouseClick(this)

	this:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background"})
	this:SetBackdropColor(0, 0, 0, 0.7)

end

local function mouseLeave(this)

	local parent = this:GetParent()
	
	if this.id ~= parent.selected then
	
		this:SetBackdrop(nil)
		
	end
	
	if this.desc then 
	
		GameTooltip:Hide()
		GameTooltip:SetScale(Loremaster.ttscale or 1)
		
	end
		
end

local function sortQuests(a, b)

	local weighta, weightb = "z", "z"
	local ca, cb, c, sa, sb
	
	if (a[3] or 0) == 1 then weighta = "a" end
	if (a[3] or 0) == 0 and (a[4] or 0) == 0 and (a[5] or 0) == 0 then weighta = "b" end
	if (a[5] or 0) == 1 then weighta = "c" end
	if (b[3] or 0) == 1 then weightb = "a" end
	if (b[3] or 0) == 0 and (b[4] or 0) == 0 and (b[5] or 0) == 0 then weightb = "b" end
	if (b[5] or 0) == 1 then weightb = "c" end
	
	sa = string.lower(string.sub(a[1], 11))
	sb = string.lower(string.sub(b[1], 11))
	ca = weighta .. sa
	cb = weightb .. sb
	
	return ca < cb

end

function Loremaster:clickResponder(this)

	local parent = this:GetParent()
	local row, zones, z, c, k, v, detail, q
	local data, qdata, dat = {}, {}, {}
	local item, series, first, other = "|cffffd200", "|cff668b8b", "|cff70db93", "|cffffffff"
	local ach, det, t, desc
	
	if parent.selected then
	
		self:resetLines(parent)
		
	end
	
	mouseClick(this)
	parent.selected = this.id

	if parent.name == "LoremasterContinentFrame" then
	
		self.currentcontinent = this.id
		LoremasterContinentFrame.currentline = this	
		
		if self.db.profile.hideach then

			for ach, det in pairs(LoremasterDB.Achievements[this.id] or {}) do
			
				if det[3] == false then
				
					table.insert(dat, LoremasterDB.Achievements[this.id][ach])
					
				end
				
			end
			
		else
		
			dat = (LoremasterDB.Achievements[this.id] or {})
			
		end

		LoremasterZoneFrame.data = dat
		table.sort(LoremasterZoneFrame.data, function(a, b) return string.lower(string.sub(a[1], 11)) < string.lower(string.sub(b[1], 11)) end)
		self:updateScroll(LoremasterZoneFramescroll)
		LoremasterQuestFrame.data = {}
		LoremasterQuestFrame.qdata = {}
		self:updateQuestCount(-1)
		self:updateZoneCount(#dat)
		self:updateScroll(LoremasterQuestFramescroll)
		LoremasterZoneFrame.selected = nil
		LoremasterZoneFrame.currentline = nil
		LoremasterQuestFrame.selected = nil
		LoremasterInfoFrame.qid = nil
		LoremasterInfoFrame.x = nil
		LoremasterInfoFrame.y = nil
		LoremasterInfoFrame.z = nil
		LoremasterInfoFrame.target = nil
		LoremasterInfoBox:SetText("")
		
	elseif parent.name == "LoremasterZoneFrame" then
	
		zones = self.AchZones[this.id]
		self.currentzone = this.id
		LoremasterZoneFrame.currentline = this
		
		if #zones > 0 and LoremasterDB.available then
		
			for _, z in ipairs(zones) do

				t = LoremasterDB.available[tostring(self.currentcontinent)][z] or {}
				
				for k, v in pairs(t) do
				
					if v[10] == 1 then
					
						c = item
						desc = L["Starts from an item drop"]
						
					elseif v[9] == 1 then
					
						c = first
						desc = L["Starts a series"]
						
					elseif v[8] == 1 then
					
						c = series
						desc = L["Part of a series"]
						
					else
					
						c = other
						desc = L["Standalone quest"]

					end
					
					table.insert(data, {c .. v[7], k, v[9], v[8], v[10], c, desc})
					table.insert(qdata, {
					qid = k, z = v[1], l = v[2], x = v[4], y = v[5], npc = v[6], 
					s = v[8], f = v[9], i = v[10], dup = v[11], drop = v[12]})
					
				end
				
			end
			
		else
		
			return
		
		end
		
		LoremasterQuestFrame.data = data
		LoremasterQuestFrame.qdata = qdata
		LoremasterQuestFrame.selected = nil
		LoremasterInfoFrame.qid = nil
		LoremasterInfoFrame.x = nil
		LoremasterInfoFrame.y = nil
		LoremasterInfoFrame.z = nil
		LoremasterInfoFrame.target = nil
		self:updateQuestCount(#data)
		LoremasterInfoBox:SetText("")
		table.sort(LoremasterQuestFrame.data, sortQuests)
		self:updateScroll(LoremasterQuestFramescroll)
			
	elseif parent.name == "LoremasterQuestFrame" then
	
		for k, v in pairs(LoremasterQuestFrame.qdata) do
		
			if v.qid == this.id then
			
				detail = v
				break
				
			end
			
		end
		
		self:setNotes(detail)
		
		if self.LH then
		
			LightHeadedFrame:Hide()
			
		end
		
	end
		
end

function Loremaster:updateScroll(frame)

	local valueStep = 16
	local line, linePlusOffset, fLine
	local numItems
	local parent = frame:GetParent()
	local numToDisplay = parent.displaylines
	local text, id, c, desc
	
	GameTooltip:Hide()

	if parent.data then
	
		numItems = #parent.data

		FauxScrollFrame_Update(frame, numItems, numToDisplay, valueStep)

		if numItems == 0 then

			for line = 1, numToDisplay do

				fLine = _G[parent.name .. line]
				fLine:Hide()

			end
	
		else

			for line = 1, numToDisplay do

				linePlusOffset = line + FauxScrollFrame_GetOffset(frame)
				fLine = _G[parent.name .. line]

				if linePlusOffset <= numItems then

					pretmp = parent.name .. line .. "_"
					text = parent.data[linePlusOffset][1] or ""
					id = parent.data[linePlusOffset][2]
					c = parent.data[linePlusOffset][6]
					desc = parent.data[linePlusOffset][7]
					_G[pretmp .. "f1"]:SetWidth(0)
					_G[pretmp .. "f1"]:SetText(white .. text)
					
					if _G[pretmp .. "f1"]:GetWidth() > fLine:GetWidth() then
					
						self:Truncate(_G[pretmp .. "f1"], fLine:GetWidth())

					end
					
					fLine.id = id
					fLine.c = c
					fLine.desc = desc
					fLine:SetScript("OnMouseDown", function(this) self:clickResponder(this) end)
					fLine:SetScript("OnEnter", mouseEnter)
					fLine:SetScript("OnLeave", mouseLeave)
					
					if id == parent.selected then
					
						mouseClick(fLine)
						
					else
					
						fLine:SetBackdrop(nil)
						
					end
					
					fLine:Show()

				else

					fLine:Hide()

				end

			end

		end
	
	end
	
end

function Loremaster:createLine(parent, linename)

	local frame= CreateFrame("Frame", linename, parent)
	local f1 = frame:CreateFontString("$parent_f1", "ARTWORK", "GameFontNormal")

	frame:SetHeight(16)
	frame:SetWidth(parent:GetWidth() - 38)

	f1:SetPoint("LEFT", frame, "LEFT")
	f1:SetWidth(frame:GetWidth())
	f1:SetJustifyH("LEFT")
	f1:SetJustifyV("TOP")
	f1:Show()

	return frame

end

function Loremaster:placeLines(frame, lines)

	local c, ypos, pre, tmp

	pre = frame.name
	ypos = -14
	
	for c = 1, lines do

		tmp = self:createLine(frame, pre .. c)
		tmp:SetPoint("TOPLEFT", frame, "TOPLEFT", 10, ypos)
		tmp:Hide()
		ypos = ypos - 20

	end

end

function Loremaster:createScrollFrame(parent, name)

	local frame = CreateFrame("ScrollFrame", name, parent, "FauxScrollFrameTemplate")
	local itemHeight = 16

	frame:SetScript("OnVerticalScroll", function(this, offset) FauxScrollFrame_OnVerticalScroll(this, offset, itemHeight, function() self:updateScroll(frame) end) end)
	frame:EnableMouseWheel(true)
	frame:SetScript("OnMouseWheel", ScrollFrameTemplate_OnMouseWheel)
	frame.name = name
	
	return frame

end

function Loremaster:createDisplayFrame(parent, framename, lines, height, width, data)

	local frame = CreateFrame("Frame", framename, parent)
	local sframe = Loremaster:createScrollFrame(frame, framename .. "scroll")

	frame:SetMovable(false)
	frame:EnableMouse(true)
	frame:EnableKeyboard(true)
	frame:SetHeight(height)
	frame:SetWidth(width)
	frame:SetBackdrop({bgFile = self[framename].bgfile, edgeFile = self[framename].edgefile, edgeSize = 16, insets = {left = 4, right = 4, top = 4, bottom = 4}})
	frame.data = data
	frame.name = framename
	frame.displaylines = lines
	
	sframe:SetPoint("TOPLEFT", frame, "TOPLEFT", 0, -10)
	sframe:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT", -32, 10)

	self:placeLines(frame, lines)

	local function frameOnShow()

		self:updateScroll(sframe)

	end

	frame:SetScript("OnShow", frameOnShow)

	return frame

end