Loremaster.L = LibStub("AceLocale-3.0"):GetLocale("Loremaster")
Loremaster.Z = LibStub("LibBabble-Zone-3.0"):GetUnstrictLookupTable()
Loremaster.frame:RegisterEvent("ADDON_LOADED")
Loremaster.frame:RegisterEvent("PLAYER_LOGIN")
Loremaster.frame:RegisterEvent("QUEST_QUERY_COMPLETE")
Loremaster.frame:RegisterEvent("QUEST_AUTOCOMPLETE")
Loremaster.frame:RegisterEvent("ACHIEVEMENT_EARNED")
Loremaster.frame:RegisterEvent("CRITERIA_UPDATE")
Loremaster.frame:RegisterEvent("PLAYER_REGEN_DISABLED")
Loremaster.frame:RegisterEvent("PLAYER_REGEN_ENABLED")

Loremaster.frame:SetScript("OnEvent", function(...) Loremaster:eventHandler(...) end)

local Z = Loremaster.Z
local L = Loremaster.L

Loremaster.LoremasterContinentFrame = {}
Loremaster.LoremasterContinentFrame.bgfile = "Interface\\ACHIEVEMENTFRAME\\UI-Achievement-Parchment-Horizontal-Desaturated"
Loremaster.LoremasterContinentFrame.edgefile = "Interface\\LFGFrame\\LFGBorder"
Loremaster.LoremasterZoneFrame = {}
Loremaster.LoremasterZoneFrame.bgfile = "Interface\\ACHIEVEMENTFRAME\\UI-Achievement-Parchment-Horizontal-Desaturated"
Loremaster.LoremasterZoneFrame.edgefile = "Interface\\LFGFrame\\LFGBorder"
Loremaster.LoremasterQuestFrame = {}
Loremaster.LoremasterQuestFrame.bgfile = "Interface\\ACHIEVEMENTFRAME\\UI-Achievement-Parchment-Horizontal-Desaturated"
Loremaster.LoremasterQuestFrame.edgefile = "Interface\\LFGFrame\\LFGBorder"

Loremaster.npcicon = "Interface\\TUTORIALFRAME\\UI-TutorialFrame-QuestGiver"
Loremaster.itemicon = "Interface\\ContainerFrame\\UI-Icon-QuestBang"

Loremaster.Alliance = {
	[1] = {4925,4928,4931,4934,4937,4938,4940,4926,4929,4932,4936,4935,4939,4930,4870,4872},
	[2] = {4896,4909,4905,4892,4899,4902,4904,4903,4900,4901,4907,4897,4906,4910,4893,4898,4873,4869},
	[3] = {1189,1190,1191,1192,1193,1194,1195},
	[4] = {33,34,35,36,37,38,39,40},
	[5] = {4871},
	[6] = {1681},
}

Loremaster.Horde = {
	[1] = {4976,4978,4931,4934,4981,4938,4940,4979,4980,4935,4939,4930,4927,4933,4870,4872},
	[2] = {4896,4909,4905,4892,4904,4900,4901,4897,4906,4910,4893,4908,4895,4894,5501,4982},
	[3] = {1190,1193,1194,1195,1271,1272,1273},
	[4] = {36,38,39,40,1356,1357,1358,1359},
	[5] = {4871},
	[6] = {1682},
}

Loremaster.Classes = {"HUNTER", "WARLOCK", "PRIEST", "PALADIN", "MAGE", "ROGUE", "DRUID", "SHAMAN", "WARRIOR", "DEATHKNIGHT"}
Loremaster.Races = {"BloodElf", "Draenei", "Dwarf", "Gilnean", "Gnome", "Goblin", "Human", "NightElf", "Orc", "Scourge", "Tauren", "Troll", "Worgen"}

Loremaster.continents = {
	[1] = {Z["Kalimdor"], 1},
	[2] = {Z["Eastern Kingdoms"], 2},
	[3] = {Z["Outland"], 3},
	[4] = {Z["Northrend"], 4},
	[5] = {Z["The Maelstrom"], 5},
}

Loremaster.tcoords = {
	[1] = {0, 32, 0, 32},
	[2] = {32, 64, 0, 32},
	[3] = {64, 96, 0, 32},
	[4] = {96, 128, 0, 32},
	[5] = {128, 160, 0, 32},
	[6] = {160, 192, 0, 32},
	[7] = {192, 224, 0, 32},
	[8] = {224, 256, 0, 32},
	[9] = {0, 32, 32, 64},
	[10] = {32, 64, 32 , 64},
	[11] = {64, 96, 32, 64},
	[12] = {96, 128, 32, 64},
	[13] = {128, 160, 32, 64},
	[14] = {160, 192, 32, 64},
}

Loremaster.icons = {
	[1] = {0, 0.125, 0, 0.5},
	[2] = {0.125, 0.25, 0, 0.5},
	[3] = {0.25, 0.375, 0, 0.5},
	[4] = {0.375, 0.5, 0, 0.5},
	[5] = {0.5, 0.675, 0, 0.5},
	[6] = {0.675, 0.75, 0, 0.5},
	[7] = {0.75, 0.875, 0, 0.5},
	[8] = {0.875, 1, 0, 0.5},
	[9] = {0, 0.125, 0.5, 1},
	[10] = {0.125, 0.25, 0.5 , 1},
	[11] = {0.25, 0.375, 0.5, 1},
	[12] = {0.375, 0.5, 0.5, 1},
	[13] = {0.5, 0.675, 0.5, 1},
	[14] = {0.675, 0.75, 0.5, 1},
}

StaticPopupDialogs["LOREMASTER_FAILED"] = {
	text = L["Failed loading the Loremaster data addon"],
	button1 = _G.OKAY,
	timeout = 0,
	hideOnEscape = 0,
	whileDead = 1
}

StaticPopupDialogs["LOREMASTER_BUILD"] = {
	text = L["Loremaster needs to build the available quest list. Would you like to do that now?"],
	button1 = _G.YES,
	button2 = _G.NO,
	OnAccept = 
			function()
	
				Loremaster.query = true
				--Loremaster:ClearMarker(nil, true)
				QueryQuestsCompleted()

				if Loremaster.db.profile.showinconmap then
			
					Loremaster:ShowZoneMarkers()
				
				end

			end,
	timeout = 0,
	hideOnEscape = 0,
	whileDead = 1
}

StaticPopupDialogs["LOREMASTER_SUCCESS"] = {
	text = L["Quest list successfully built"],
	button1 = _G.OKAY,
	timeout = 0,
	hideOnEscape = 0,
	whileDead = 1
}

StaticPopupDialogs["LOREMASTER_RESET"] = {
	text = L["Rebuild the available quest list. Are you sure?"],
	button1 = _G.YES,
	button2 = _G.NO,
	OnAccept = 
		function()

			Loremaster.query = true
			Loremaster.rescan = true
			
			if LoremasterMainFrame:IsVisible() then
			
				LoremasterMainFrame:Hide()
				
			end
			
			Loremaster:ClearMarker(nil, true)
			QueryQuestsCompleted()

			if Loremaster.db.profile.showinconmap then
			
				Loremaster:ShowZoneMarkers()
				
			end

		end,
	timeout = 0,
	hideOnEscape = 0,
	whileDead = 1
}

--Hijacked from Powerauras
StaticPopupDialogs["LOREMASTER_WOWHEAD"] = {
	text = L["Copy and paste into your web browser"],
	button1 = _G.DONE,
	hasEditBox = 1,
	maxLetters = 35,
	hasWideEditBox = 1,
	editBoxWidth = 250,
	OnShow = function(this)
				this.editBox:SetText(Loremaster.WHtext);
				this.editBox:SetFocus();
				this.editBox:HighlightText();
			end,
	OnHide = function(this)
				ChatEdit_FocusActiveWindow(); 
				this.editBox:SetText("");
			end,
	EditBoxOnEnterPressed = function(this) this:GetParent():Hide();	end,
	EditBoxOnEscapePressed = function(this) this:GetParent():Hide(); end,
	timeout = 0,
	exclusive = 1,
	whileDead = 1,
	hideOnEscape = 1
}