local GetAchievementInfo = GetAchievementInfo
local GetAchievementCriteriaInfo = GetAchievementCriteriaInfo
local L = Loremaster.L
local continents = {"Kalimdor", "EasternKingdoms", "Outland", "Northrend", "Maelstrom"}
local locale = GetLocale()

function Loremaster:resetLines(frame)

	local row
	
	for row = 1, frame.displaylines do
		
		_G[frame.name .. row]:SetBackdrop(nil)
			
	end
		
end

function Loremaster:getContinents()

	local cn, c, ach, det
	local dat = {}
	
	if self.db.profile.hideach then

		for cn, c in ipairs(self.continents) do
		
			for ach, det in pairs((LoremasterDB.Achievements[cn] or {})) do
			
				if det[3] == false then
				
					table.insert(dat, self.continents[cn])
					break
					
				end
				
			end
				
		end
			
	else
		
		dat = self.continents
			
	end
	
	return dat
	
end

function Loremaster:removeQuest(qid)

	local c, zone, qs
	local found, q, d
	local same, s
	
	if not LoremasterDB.available then return end
	
	for c = 1, 5 do
	
		for zone, qs in pairs((LoremasterDB.available[tostring(c)]) or {}) do
		
			--remove the quest if it exists
			for q, d in pairs(qs) do
			
				if q == qid then
				
					same = d[11]
					
					if same then
					
						--remove 'same as' quests
						for _, s in ipairs(same) do
						
							LoremasterDB.available[tostring(c)][zone][same] = nil
								
						end
							
					end	
						
					LoremasterDB.available[tostring(c)][zone][qid] = nil
					found = true
					break
					
				end
				
			end
			
			if found then
			
				break
				
			end
		
		end
		
	end
	
	if self.db.profile.showinconmap then
			
		Loremaster:ShowZoneMarkers()
				
	end

end

function Loremaster:updateQuestCount(count)

	local texture = "Interface\\OPTIONSFRAME\\UI-OptionsFrame-NewFeatureIcon"
	local size = 16
	local qcount
	
	if (count or -1) == -1 then
	
		qcount = ""
		
	else
	
		qcount = "  |cffbebebe(" .. count .. " " .. L["available"] .. ")"
		
	end
	
	LoremasterQuestTitle:SetFormattedText("|T%s:%d|t%s",texture , size, L["Quests"] .. qcount)

end

function Loremaster:updateZoneCount(count)

	local texture = self.factiontexture
	local size = 32
	local zcount
	
	if (count or -1) == -1 then
	
		zcount = ""
		
	else
	
		zcount = "  |cffbebebe(" .. count .. " " .. L["available"] .. ")"
		
	end
	
	LoremasterZoneTitle:SetFormattedText("|T%s:%d|t%s",texture , size, L["Achievement"] .. zcount)

end

local function trim(s)

	return (string.gsub(s, "^%s*(.-)%s*$", "%1"))
    
end
	
function Loremaster:setNotes(detail)

	local N = LoremasterInfoFrame
	local white, gold, green, blue = "|cffffffff", "|cffffd200", "|cff22ee55", "|cff00bfff"
	local text, sp1, npc, item, zone, target, article, z, i
	
	text = "|T"
	
	if locale == "enUS" then
	
		if detail.i == 1 then
	
			text = text .. self.itemicon
			target = detail.drop
			item = L["an item dropped by"] .. " " .. green .. target .. white
			sp1 = " "

		else
	
			text = text .. self.npcicon
			item = L["an NPC"]
			sp1 = ""
			target = detail.npc
		
		end
	
		npc = detail.npc
		text = text .. ":32|t" .. sp1 .. npc .. "\r\r" .. white	
		text = text .. L["This level"] .. " " .. detail.l .. " " .. L["quest"] .. " "
	
		if detail.f == 1 then
	
			text = text .. L["starts a series with"]
		
		elseif detail.s == 1 then
	
			text = text .. L["is part of a series from"]
		
		else
	
			text = text .. L["starts with"]
		
		end

		zone = self.Zones[tostring(detail.z)]
		text = text .. " " .. item .. " "	
		text = text .. L["in"] .. " " .. zone
		text = text .. " " .. L["at"] .. " " .. blue .. detail.x .. white .. ", " .. blue .. detail.y .. white .. "."
		
	else
	
		if detail.i == 1 then
	
			text = text .. self.itemicon
			item = L["Dropped by"] .. ": " .. white .. detail.drop .. "\r"

		else
	
			text = text .. self.npcicon
			item = L["NPC"] .. ": " .. white .. detail.npc .. "\r"
		
		end

		text = text .. ":32|t" .. "\r" .. green .. item
		text = text .. green .. L["Level"] .. ": " .. white .. detail.l .. "\r\r"
	
		if detail.f == 1 then
	
			text = text .. white .. L["Starts a series"] .. "\r\r"
		
		elseif detail.s == 1 then
	
			text = text .. white .. L["Part of a series"] .. "\r\r"
		
		end

		zone = self.Zones[tostring(detail.z)]
		text = text .. green .. L["Zone"] .. ": " .. white .. zone .. "\r"	
		text = text .. green .. L["Co-ords"] .. ": " .. blue .. detail.x .. white .. ", " .. blue .. detail.y .. white

	end
	
	LoremasterInfoFrame.qid = detail.qid
	LoremasterInfoFrame.x = detail.x
	LoremasterInfoFrame.y = detail.y
	LoremasterInfoFrame.z = zone
	LoremasterInfoFrame.target = target
	LoremasterInfoBox:SetText(text)
	
end

function Loremaster:scanAchievements()

	local achlist = self[self.faction]
	local continent, ach, name, complete
	local achievements, c = {[1]={},[2]={},[3]={},[4]={},[5]={}}, ""
	local grey, white = "|cff778899", "|cffffffff"
	
	if not achlist then return end
	
	for continent = 1, 5 do
	
		for _, ach in pairs(achlist[continent]) do
		
			_, name, _, complete = GetAchievementInfo(ach)
			_, _, _, qty, req = GetAchievementCriteriaInfo(ach, 1)
			
			if complete then
			
				c = grey
				
			else
			
				c = white
				
			end
			
			table.insert(achievements[continent], {c .. name .. grey .. " (" .. (qty or 0) .. " / " .. (req or 0) .. ")", ach, complete})
			
		end
		
	end

	LoremasterDB.Achievements = achievements
	self.rescan = nil
	
end

function Loremaster:resetInterface()

	--reset the interface
	LoremasterQuestFrame.data = {}
	LoremasterQuestFrame.qdata = {}
	LoremasterZoneFrame.data = {}
	LoremasterContinentFrame.data = self:getContinents()
	self:updateQuestCount(-1)
	self:updateZoneCount(-1)
	LoremasterZoneFrame.selected = nil
	LoremasterZoneFrame.currentline = nil
	LoremasterQuestFrame.selected = nil
	LoremasterContinentFrame.selected = nil
	self:updateScroll(LoremasterContinentFramescroll)
	self:updateScroll(LoremasterQuestFramescroll)
	self:updateScroll(LoremasterZoneFramescroll)
	LoremasterInfoFrame.qid = nil
	LoremasterInfoFrame.x = nil
	LoremasterInfoFrame.y = nil
	LoremasterInfoFrame.z = nil
	LoremasterInfoFrame.target = nil
	LoremasterInfoBox:SetText("")
	self:resetLines(LoremasterContinentFrame)
	
end

function Loremaster:buildQuestList()

	local completed = GetQuestsCompleted()
	LoremasterDB.available = {["1"]={},["2"]={},["3"]={},["4"]={},["5"]={}}
	local qid, loaded, reason, c, zone, qs, faction, details, k, v, same, f
	local dups = {}

	
	--reset the interface
	self:resetInterface()
		
	--Try loading the data addon
	loaded, reason = LoadAddOn("Loremaster_Data")
	
	if not loaded then
        
		--load failed
		StaticPopup_Show("LOREMASTER_FAILED")
		return
		
	end
	
	if self.faction == "Alliance" then
	
		faction = 2
		
	else
	
		faction = 1
		
	end
	
	for c = 1, 5 do

		LoremasterDB.available[tostring(c)] = (self[continents[c]] or {})
	
		for zone, qs in pairs(LoremasterDB.available[tostring(c)]) do

			for qid, details in pairs(qs) do

				setmetatable(LoremasterDB.available[tostring(c)][zone], {__index = {0,0,3,0,0,"","",0,0,0,nil,nil,nil,nil}})
				--get rid of any quests for the opposite faction only
				if details[3] == faction then
				
					LoremasterDB.available[tostring(c)][zone][qid] = nil
					
				end
				
				--remove completed quests
				for k, v in pairs(completed) do
				
					if qid == k then

						--remove 'same as' quests
						if details[11] then
						
							for _, same in ipairs(details[11]) do
						
								LoremasterDB.available[tostring(c)][zone][same] = nil
								table.insert(dups, same)
								
							end
							
						end
						
						--remove completed quest
						LoremasterDB.available[tostring(c)][zone][k] = nil
						break
						
					end
					
				end
				
				--remove class specific quests
				if details[14] then
						
					f = nil
							
					for _, same in ipairs(details[14]) do
							
						if self.class == same then
								
							f = true
							break
									
						end
								
					end
							
					if not f then
							
						LoremasterDB.available[tostring(c)][zone][qid] = nil
						f = nil
						
					end
					
				end
				
				--remove race specific quests
				if details[13] then
						
					f = nil
							
					for _, same in ipairs(details[13]) do
							
						if self.race == same then
								
							f = true
							break
									
						end
								
					end
							
					if not f then
							
						LoremasterDB.available[tostring(c)][zone][qid] = nil
						f = nil
						
					end
					
				end
				
			end
		
		end

		self[continents[c]] = nil
		
	end
	
	--remove any duplicates from other zones
	for _, same in ipairs(dups) do
	
		self:removeQuest(same)
		
	end
	
	collectgarbage("collect")
	StaticPopup_Show("LOREMASTER_SUCCESS")
	
end

function Loremaster:Truncate(fs, size)

	local chars
	local text = fs:GetText()
	
	for chars = 1, string.len(text) do
	
		fs:SetText(string.sub(text, 1, chars) .. "...")
		
		if fs:GetWidth() > size then
		
			fs:SetText(string.sub(text, 1, chars - 1) .. "...")
			break
			
		end
		
	end
	
end

function Loremaster:GetZone(zonetext)

	local zn, z
	local zone
	
	for zn, z in pairs(self.Zones) do
	
		if z == zonetext then
		
			zone = zn
			break
			
		end
		
	end
	
	return zone or 0
	
end