-- LearningAid v1.04 by Jamash (Kil'jaeden-US)

LearningAid = {}

-- Copied from SpellBookFrame.lua
function LearningAid.UpdateButton(self)
  local id = self:GetID();
    
  local name = self:GetName();
  local iconTexture = getglobal(name.."IconTexture");
  local spellString = getglobal(name.."SpellName");
  local subSpellString = getglobal(name.."SubSpellName");
  local cooldown = getglobal(name.."Cooldown");
  local autoCastableTexture = getglobal(name.."AutoCastable");
  local highlightTexture = getglobal(name.."Highlight");
  local normalTexture = getglobal(name.."NormalTexture");
  self:Enable();

  if self.kind == "SPELL" then 

    local texture = GetSpellTexture(id, BOOKTYPE_SPELL);

  -- If no spell, hide everything and return
    if ( not texture or (strlen(texture) == 0) ) then
      iconTexture:Hide();
      spellString:Hide();
      subSpellString:Hide();
      cooldown:Hide();
      autoCastableTexture:Hide();
      SpellBook_ReleaseAutoCastShine(self.shine)
      self.shine = nil;
      highlightTexture:SetTexture("Interface\\Buttons\\ButtonHilight-Square");
      self:SetChecked(0);
      normalTexture:SetVertexColor(1.0, 1.0, 1.0);
      return;
    end

    local start, duration, enable = GetSpellCooldown(id, BOOKTYPE_SPELL);
    CooldownFrame_SetTimer(cooldown, start, duration, enable);
    cooldown.start = start
    cooldown.duration = duration
    cooldown.enable = enable
    if ( enable == 1 ) then
      iconTexture:SetVertexColor(1.0, 1.0, 1.0);
    else
      iconTexture:SetVertexColor(0.4, 0.4, 0.4);
    end

    local spellName, subSpellName = GetSpellName(id, BOOKTYPE_SPELL);

    normalTexture:SetVertexColor(1.0, 1.0, 1.0);
    highlightTexture:SetTexture("Interface\\Buttons\\ButtonHilight-Square");
    spellString:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b);

  -- Set Secure Action Button attribute
    self:SetAttribute("spell*", spellName)

    iconTexture:SetTexture(texture);
    spellString:SetText(spellName);
    subSpellString:SetText(subSpellName);
    if ( subSpellName ~= "" ) then
      spellString:SetPoint("LEFT", self, "RIGHT", 4, 4);
    else
      spellString:SetPoint("LEFT", self, "RIGHT", 4, 2);
    end
  elseif self.kind == "MOUNT" or self.kind == "CRITTER" then

    -- Some companions have two names, the display name and the spell name
    -- Make sure to use the spell name for casting
    local creatureID, creatureName, creatureSpellID, icon, isSummoned = GetCompanionInfo(self.kind, id)
    local spellName = GetSpellInfo(creatureSpellID);
    iconTexture:SetTexture(icon)
    spellString:SetText(creatureName)
    subSpellString:SetText("")
    self:SetAttribute("spell*", spellName)
  end
  iconTexture:Show();
  spellString:Show();
  subSpellString:Show();
  --SpellButton_UpdateSelection(self);
end

-- Copied from SpellBookFrame.lua
function LearningAid.SpellButton_OnDrag(self) 
  local id = self:GetID();
  if self.kind == "SPELL" then
    PickupSpell(id, self.kind);
  elseif self.kind == "MOUNT" or self.kind == "CRITTER" then
    PickupCompanion(self.kind, id)
  end
end

-- Copied from SpellBookFrame.lua
function LearningAid.SpellButton_OnEnter(self)
  local id = self:GetID();
  GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
  if self.kind == "SPELL" then
    if GameTooltip:SetSpell(id, BOOKTYPE_SPELL) then
      self.UpdateTooltip = LearningAid.SpellButton_OnEnter
    else
      self.UpdateTooltip = nil
    end
  elseif self.kind == "MOUNT" or self.kind == "CRITTER" then
    local creatureID, creatureName, creatureSpellID, icon, isSummoned = GetCompanionInfo(self.kind, id)
    if GameTooltip:SetHyperlink("spell:"..creatureSpellID) then
      self.UpdateTooltip = LearningAid.SpellButton_OnEnter;
    else
      self.UpdateTooltip = nil;
    end
  else
    DEFAULT_CHAT_FRAME:AddMessage("Invalid button type in LearningAid.SpellButton_OnEnter: "..self.kind)
  end
end

-- Copied from SpellBookFrame.lua
function LearningAid.SpellButton_UpdateSelection(self)
  local id = self:GetID()
  if IsSelectedSpell(id, BOOKTYPE_SPELL) then
    self:SetChecked("true");
  else
    self:SetChecked("false");
  end
end

-- Copied from SpellBookFrame.lua
function LearningAid.SpellButton_OnModifiedClick(self, button) 
  local id = self:GetID()
  local spellName, subSpellName
  if self.kind == "SPELL" then
    if ( id > MAX_SPELLS ) then
      return;
    end

    if ( IsModifiedClick("CHATLINK") ) then
      if ( MacroFrame and MacroFrame:IsShown() ) then
        spellName, subSpellName = GetSpellName(id, BOOKTYPE_SPELL);
          if ( spellName and not IsPassiveSpell(id, BOOKTYPE_SPELL) ) then
            if ( subSpellName and (strlen(subSpellName) > 0) ) then
              ChatEdit_InsertLink(spellName.."("..subSpellName..")");
            else
              ChatEdit_InsertLink(spellName);
            end
          end
        return;
      else
        local spellLink = GetSpellLink(id, BOOKTYPE_SPELL);
          if(spellLink) then
            ChatEdit_InsertLink(spellLink);
          end
        return;
      end
    end
    if ( IsModifiedClick("PICKUPACTION") ) then
      PickupSpell(id, BOOKTYPE_SPELL);
      return;
    end
  elseif self.kind == "MOUNT" or self.kind == "CRITTER" then
    local creatureID, creatureName, creatureSpellID, icon, isSummoned = GetCompanionInfo(self.kind, id)
    if ( IsModifiedClick("CHATLINK") ) then
      if ( MacroFrame and MacroFrame:IsShown() ) then
        local spellName = GetSpellInfo(creatureSpellID);
        ChatEdit_InsertLink(spellName);
      else
        local spellLink = GetSpellLink(creatureSpellID)
        ChatEdit_InsertLink(spellLink);
      end
    elseif ( IsModifiedClick("PICKUPACTION") ) then
      LearningAid.SpellButton_OnDrag(self);
    end
  end
end

function LearningAid.OnLoad(self)
  self:RegisterEvent("SPELLS_CHANGED")
  --self:RegisterEvent("LEARNED_SPELL_IN_TAB")
  self:RegisterEvent("PLAYER_LOGIN")
  if LearningAid.tocVersion >= 30000 then
    self:RegisterEvent("COMPANION_LEARNED")
    self:RegisterEvent("COMPANION_UPDATE")
  end
  self:RegisterEvent("TRADE_SKILL_SHOW")
  self:RegisterEvent("TRADE_SKILL_CLOSE")
  self:RegisterEvent("SPELL_UPDATE_COOLDOWN")
  self:RegisterEvent("CURRENT_SPELL_CAST_CHANGED")
  self:RegisterEvent("VARIABLES_LOADED")
end

function LearningAid.OnEvent(self, event, ...)
  local buttons = self.buttons
  if event == "PLAYER_LOGIN" then
    LearningAid.UpdateSpellBook()
    if LearningAid.tocVersion >= 30000 then
      LearningAid.UpdateCompanions()
    end
  elseif (event == "SPELLS_CHANGED" or event == "LEARNED_SPELL_IN_TAB") and LearningAid.SpellBookCache ~= nil then
    local updated = LearningAid.DiffSpellBook()
    if updated then
      LearningAid.UpdateSpellBook()
    else
      --DEFAULT_CHAT_FRAME:AddMessage("Event "..event.." fired without spell changes")
    end
  elseif event == "COMPANION_LEARNED" then
    --DEFAULT_CHAT_FRAME:AddMessage("Event "..event)
    LearningAid.DiffCompanions()
    LearningAid.UpdateCompanions()
  elseif event == "COMPANION_UPDATE" then
    for i = 1, self.visible do
      local button = buttons[i]
      local kind = button.kind
      if kind == "MOUNT" or kind == "CRITTER" then
        local creatureID, creatureName, creatureSpellID, icon, isSummoned = GetCompanionInfo(kind, button:GetID())
        if isSummoned then
          button:SetChecked(true)
        else
          button:SetChecked(false)
        end
      end
    end
  elseif event == "TRADE_SKILL_SHOW" or event == "TRADE_SKILL_CLOSE" then
    for i = 1, self.visible do
      local button = buttons[i]
      if button.kind == "SPELL" then
        if IsSelectedSpell(button:GetID(), button.kind) then
          button:SetChecked(true)
        else
          button:SetChecked(false)
        end
      end
    end
  elseif event == "SPELL_UPDATE_COOLDOWN" then
    for i = 1, self.visible do
      local button = buttons[i]
      if button.kind == "SPELL" then
        LearningAid.UpdateButton(button)
      elseif button.kind == "MOUNT" or button.kind == "CRITTER" then
        local start, duration, enable = GetCompanionCooldown(button.kind, button:GetID())
        CooldownFrame_SetTimer(button.cooldown, start, duration, enable);
      end
    end
  elseif event == "CURRENT_SPELL_CAST_CHANGED" then
    for i = 1, self.visible do
      local button = buttons[i]
      if button.kind == "SPELL" then
        LearningAid.SpellButton_UpdateSelection(button)
      end
    end
  elseif event == "VARIABLES_LOADED" then
    if not LearningAid_Saved then LearningAid_Saved = {} end
    if LearningAid_Saved.locked then
      LearningAid.menuTable[1].text = LearningAid.unlockText
    else
      LearningAid_Saved.locked = false
    end
    if LearningAid_Saved.x and LearningAid_Saved.y then
      LearningAid.frame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", LearningAid_Saved.x, LearningAid_Saved.y)
    end
  end
end

function LearningAid.UpdateCompanions()
  LearningAid.UpdateCompanionType("MOUNT")
  LearningAid.UpdateCompanionType("CRITTER")
end

function LearningAid.UpdateCompanionType(kind)
  LearningAid.companionCache[kind] = {}
  local cache = LearningAid.companionCache[kind]
  local i = 1
  local creatureID, creatureName, creatureSpellID, icon, isSummoned = GetCompanionInfo(kind, i)
  while creatureName do
    cache[i] = creatureName
    i = i + 1
    creatureID, creatureName, creatureSpellID, icon, isSummoned = GetCompanionInfo(kind, i)
  end
end

function LearningAid.DiffCompanions()
  local updated
  updated = LearningAid.DiffCompanionType("MOUNT")
  if updated then
    LearningAid.UpdateCompanionType("MOUNT")
  else
    updated = LearningAid.DiffCompanionType("CRITTER")
    if updated then
      LearningAid.UpdateCompanionType("CRITTER")
    end
  end
end

function LearningAid.DiffCompanionType(kind)
  local i = 1
  local creatureID, creatureName, creatureSpellID, icon, isSummoned = GetCompanionInfo(kind, i)
  local cache = LearningAid.companionCache[kind]
  local updated = false
  while creatureName do 
    if cache[i] == nil or
       cache[i] ~= creatureName then
      LearningAid.AddButton(LearningAid.frame, kind, i)
      updated = true
      break
    end
    i = i + 1
    creatureID, creatureName, creatureSpellID, icon, isSummoned = GetCompanionInfo(kind, i)
  end
  return updated
end

function LearningAid.UpdateSpellBook()
  LearningAid.SpellBookCache = {}
  local i = 1
  local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
  while spellName do
    LearningAid.SpellBookCache[i] = { name = spellName, rank = spellRank }
    i = i + 1
    spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
  end
  --DEFAULT_CHAT_FRAME:AddMessage("Updated Spellbook, "..i.." spells found")
end

function LearningAid.DiffSpellBook()
  local i = 1
--  local offset = 0
  local cache = LearningAid.SpellBookCache
  local updated = false
  local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
  while spellName do
    if cache[i] == nil or
       cache[i].name ~= spellName or
       cache[i].rank ~= spellRank then
      -- if spell removed
      if cache[i + 1] ~= nil and
         cache[i + 1].name == spellName and
         cache[i + 1].rank == spellRank then
        --DEFAULT_CHAT_FRAME:AddMessage("Old spell removed: "..cache[i].name.." ("..cache[i].rank..") id "..(i))
        LearningAid.ClearButtonID(LearningAid.frame, i)
        LearningAid.RemoveAbility(LearningAid.frame, i)
      else
        LearningAid.AddAbility(LearningAid.frame, i)
        if not IsPassiveSpell(i, BOOKTYPE_SPELL) then -- if spell added that isn't passive
          -- Display button with dragable spell icon
          --DEFAULT_CHAT_FRAME:AddMessage("New spell found: "..spellName.." ("..spellRank..")") -- Old spell: "..cache[i + offset].name.." ("..cache[i + offset].rank..")")
          LearningAid.AddButton(LearningAid.frame, "SPELL", i)
        end
      end
      -- remember to update cache
      updated = true
      break
    end
    i = i + 1
    spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
  end
  -- if the last spell in the spellbook is removed
  if i == #cache and not updated then
    LearningAid.ClearButtonID(LearningAid.frame, i)
    LearningAid.RemoveAbility(LearningAid.frame, i)
    --DEFAULT_CHAT_FRAME:AddMessage("Last spell removed: "..cache[i].name.." ("..cache[i].rank..") id "..i)
    updated = true
    --LearningAid.Button:Hide()
  end
  return updated
end

function LearningAid.AddAbility(parent, id)
  local buttons = parent.buttons
  for i = 1, parent.visible do
    if buttons[i].kind == "SPELL" and buttons[i]:GetID() >= id then
      buttons[i]:SetID(buttons[i]:GetID() + 1)
      LearningAid.UpdateButton(buttons[i])
    end
  end
end

function LearningAid.RemoveAbility(parent, id)
  local buttons = parent.buttons
  for i = 1, parent.visible do
    if buttons[i].kind == "SPELL" and buttons[i]:GetID() > id then
      buttons[i]:SetID(buttons[i]:GetID() - 1)
      LearningAid.UpdateButton(buttons[i])
    end
  end
end

function LearningAid.CreateButton(parent)
  local count = #parent.buttons
  local name = "SpellButton_LearningAid_"..(count + 1)
  local button = CreateFrame("CheckButton", name, parent, "LearningAidSpellButtonTemplate")
  local subSpellName = getglobal(name.."SubSpellName")
  subSpellName:SetTextColor(NORMAL_FONT_COLOR.r - 0.1, NORMAL_FONT_COLOR.g - 0.1, NORMAL_FONT_COLOR.b - 0.1)
  parent.buttons[count + 1] = button
  button.Index = count + 1
  if count > 0 then
    -- position relative to button above
    button:SetPoint("TOP", parent.buttons[count], "BOTTOM", 0, -LearningAid.buttonSpacing)
  else
    -- position relative to header
    button:SetPoint("TOPLEFT", parent.titleBar, "BOTTOMLEFT", 16, 0)
  end
  button:SetAttribute("type*", "spell")
  button:SetAttribute("type3", "hideButton")
  button:SetAttribute("alt-type*", "hideButton")
  button:SetAttribute("shift-type1", "linkSpell")
  button.hideButton = function(self, button, down) LearningAid.ClearButtonIndex(LearningAid.frame, self.Index) end
  button.linkSpell = LearningAid.SpellButton_OnModifiedClick
  button.iconTexture = _G[name.."IconTexture"]
  button.cooldown = _G[name.."Cooldown"]
  return button
end

function LearningAid.SpellButton_OnHide(self)
  --DEFAULT_CHAT_FRAME:AddMessage("Hiding button "..self.Index)
  --LearningAid.ClearButtonIndex(LearningAid.frame, self.Index)]
  self:SetChecked(false)
  self.iconTexture:SetVertexColor(1, 1, 1)
  self.cooldown:Hide()
end

function LearningAid.AddButton(frame, kind, id)
  local buttons = frame.buttons
  local button
  -- if bar is full
  if frame.visible == #buttons then
    button = LearningAid.CreateButton(frame)
    --DEFAULT_CHAT_FRAME:AddMessage("Adding button id "..id.." index "..button.Index)
  else
  -- if bar has free buttons
    button = buttons[frame.visible + 1]
    --DEFAULT_CHAT_FRAME:AddMessage("Changing button index "..(frame.visible + 1).." from id "..button:GetID().." to "..id)
    button:Show()
  end

  button.kind = kind
  LearningAid.SetVisible(frame, frame.visible + 1)
  button:SetID(id)
  button:SetChecked(false)
  if kind == "SPELL" then

    if id > 1 then
      local name, rank = GetSpellName(id, BOOKTYPE_SPELL)
      local prevName, prevRank = GetSpellName(id - 1, BOOKTYPE_SPELL)
      if name == prevName then
        --DEFAULT_CHAT_FRAME:AddMessage("Found new rank of existing ability "..name.." "..prevRank)
        LearningAid.ClearButtonID(frame, id - 1)
      --else 
        --DEFAULT_CHAT_FRAME:AddMessage(name.." ~= "..prevName)
      end
      if IsSelectedSpell(id, kind) then
        button:SetChecked(true)
      end
    end
  elseif kind == "MOUNT" or kind == "CRITTER" then
    -- button.Companion = name
    local creatureID, creatureName, creatureSpellID, icon, isSummoned = GetCompanionInfo(kind, id)
    if isSummoned then
      button:SetChecked(true)
    end
  else
    DEFAULT_CHAT_FRAME:AddMessage("Invalid action type "..kind.." in LearningAid.AddButton()")
  end
  
  LearningAid.UpdateButton(button)
  frame:Show()
end

function LearningAid.ClearButtonID(frame, id)
  local buttons = frame.buttons
  local i = 1
  while i <= frame.visible do
    if buttons[i]:GetID() == id then
      --DEFAULT_CHAT_FRAME:AddMessage("Clearing button "..i.." with ID "..buttons[i]:GetID())
      LearningAid.ClearButtonIndex(frame, i)
    else
      --DEFAULT_CHAT_FRAME:AddMessage("Button "..i.." has id "..buttons[i]:GetID().." which does not match "..id)
      i = i + 1
    end
  end
end

-- I have buttons 1 2 3 (4 5)
-- I remove button 2
-- I want 1 3 (3 4 5)
-- before, Visible = 3
-- after, Visible = 2
function LearningAid.ClearButtonIndex(frame, index)
  local buttons = frame.buttons
  for i = index, frame.visible - 1 do
    local button = buttons[i]
    local next = buttons[i + 1]
    button:SetID(next:GetID())
    button:SetChecked(next:GetChecked())
    button.kind = next.kind
    button.iconTexture:SetVertexColor(next.iconTexture:GetVertexColor())
    local cooldown = button.cooldown
    cooldown.start = next.cooldown.start
    cooldown.duration = next.cooldown.duration
    cooldown.enable = next.cooldown.enable
    if cooldown.start and cooldown.duration and cooldown.enable then 
      CooldownFrame_SetTimer(button.cooldown, cooldown.start, cooldown.duration, cooldown.enable)
    else
      button.cooldown:Hide()
    end
    --if buttons[i]:IsShown() then
    LearningAid.UpdateButton(button)
    --end
  end
  buttons[frame.visible]:Hide()
  LearningAid.SetVisible(frame, frame.visible - 1)
  if frame.visible == 0 then
    frame:Hide()
  end
end

function LearningAid.SetVisible(frame, visible)
  frame.visible = visible
  local top, left = frame:GetTop(), frame:GetLeft()
  frame:SetHeight(LearningAid.titleHeight + 10 + (LearningAid.buttonSize + LearningAid.buttonSpacing) * visible)
  frame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", left, top)
end

function LearningAid.Hide(frame)
  for i = 1, frame.visible do
    frame.buttons[i]:SetChecked(false)
    frame.buttons[i]:Hide()
  end
  frame.visible = 0
  frame:Hide()
end

function LearningAid.TestAdd(kind, ...)
  DEFAULT_CHAT_FRAME:AddMessage("Testing!")
  local t = {...}
  for i = 1, #t do
    local id = t[i]
    if kind == "SPELL" then
      if GetSpellInfo(id, kind) and not IsPassiveSpell(id, kind) then
        DEFAULT_CHAT_FRAME:AddMessage("Test: Adding spell id "..id)
        LearningAid.AddButton(LearningAid.frame, kind, id)
      else
        DEFAULT_CHAT_FRAME:AddMessage("Test: Spell id "..id.." is passive or does not exist")
      end
    elseif kind == "CRITTER" or kind == "MOUNT" then
      if GetCompanionInfo(kind, id) then
        DEFAULT_CHAT_FRAME:AddMessage("Test: Adding companion type "..kind.." id "..id)
        LearningAid.AddButton(LearningAid.frame, kind, id)
      end
    end
  end
end

function LearningAid.TestRemove(...)
  DEFAULT_CHAT_FRAME:AddMessage("Testing!")
  local t = {...}
  for i = 1, #t do
    local id = t[i]
    DEFAULT_CHAT_FRAME:AddMessage("Test: Removing spell id "..id)
    LearningAid.ClearButtonID(LearningAid.frame, id)
  end
end

function LearningAid.OnShow(self)
  if LearningAid.tocVersion >= 30000 then
    self:RegisterEvent("COMPANION_UPDATE")
  end
  self:RegisterEvent("TRADE_SKILL_SHOW")
  self:RegisterEvent("TRADE_SKILL_CLOSE")
  self:RegisterEvent("SPELL_UPDATE_COOLDOWN")
  self:RegisterEvent("CURRENT_SPELL_CAST_CHANGED")
end

function LearningAid.OnHide(self)
  if LearningAid.tocVersion >= 30000 then
    self:UnregisterEvent("COMPANION_UPDATE")
  end
  self:UnregisterEvent("TRADE_SKILL_SHOW")
  self:UnregisterEvent("TRADE_SKILL_CLOSE")
  self:UnregisterEvent("SPELL_UPDATE_COOLDOWN")
  self:UnregisterEvent("CURRENT_SPELL_CAST_CHANGED")
end

function LearningAid.ToggleLock(frame)
  if LearningAid_Saved.locked then
    LearningAid_Saved.locked = false
  else
    LearningAid_Saved.locked = true
  end    
end

LearningAid.titleHeight = 40
LearningAid.width = 170
LearningAid.buttonSpacing = 5
LearningAid.buttonSize = 37
LearningAid.titleText = "Learning Aid"
LearningAid.lockText = "Lock Position"
LearningAid.unlockText = "Unlock Position"
LearningAid.closeText = "Close"
local version, build, date, tocversion = GetBuildInfo()
LearningAid.tocVersion = tocversion
LearningAid.companionCache = {}
LearningAid.menuHideDelay = 5

local frame = CreateFrame("Frame", "LearningAid_Frame", UIParent)
LearningAid.frame = frame
frame:SetPoint("TOPLEFT", UIParent, "CENTER", 200, 100)
frame:SetWidth(LearningAid.width)
frame:SetHeight(LearningAid.titleHeight)
frame:SetMovable(true)
frame:SetClampedToScreen(true)
frame:SetScript("OnEvent", LearningAid.OnEvent)
frame:SetScript("OnShow", LearningAid.OnShow)
frame:SetScript("OnHide", LearningAid.OnHide)
frame.buttons = {}
frame.visible = 0
frame:Hide()
local backdrop = {
  bgFile = "Interface/DialogFrame/UI-DialogBox-Background",
  edgeFile = "Interface/DialogFrame/UI-DialogBox-Gold-Border",
  tile = false, tileSize = 16, edgeSize = 16,
  insets = { left = 4, right = 4, top = 4, bottom = 4 }
}
frame:SetBackdrop(backdrop)

local titleBar = CreateFrame("Frame", "LearningAid_Frame_TitleBar", frame)
frame.titleBar = titleBar
titleBar:SetPoint("TOPLEFT")
titleBar:SetPoint("TOPRIGHT")
titleBar:SetHeight(LearningAid.titleHeight)
titleBar:RegisterForDrag("LeftButton")
titleBar:EnableMouse()
titleBar.Text = titleBar:CreateFontString("LearningAid_Frame_Title_Text", "OVERLAY", "GameFontNormalLarge")
titleBar.Text:SetText(LearningAid.titleText)
titleBar.Text:SetPoint("CENTER", titleBar, "CENTER", 0, 0)

LearningAid.menuTable = {
  {
    text = LearningAid.lockText, 
    func = function () LearningAid.ToggleLock(frame)
      if LearningAid.menuTable[1].text == LearningAid.lockText then
        LearningAid.menuTable[1].text = LearningAid.unlockText
      else
        LearningAid.menuTable[1].text = LearningAid.lockText
      end
    end
  },
  {  text = LearningAid.closeText, func = function () LearningAid.Hide(frame) end }
}

local Menu = CreateFrame("Frame", "LearningAid_Menu", titleBar, "UIDropDownMenuTemplate")
titleBar:SetScript(
  "OnDragStart",
  function (self, button)
    if not LearningAid_Saved.locked then
      self:GetParent():StartMoving()
    end
  end
)

titleBar:SetScript(
  "OnDragStop",
  function (self)
    self:GetParent():StopMovingOrSizing()
    LearningAid_Saved.x = self:GetParent():GetLeft()
    LearningAid_Saved.y = self:GetParent():GetTop()
  end
)

titleBar:SetScript(
  "OnMouseUp",
  function (self, button)
    if button == "MiddleButton" then
      LearningAid.Hide(self:GetParent())
    elseif button == "RightButton" then
      EasyMenu(LearningAid.menuTable, Menu, titleBar, 0, 8, "MENU", LearningAid.menuHideDelay)
    end
  end
)

LearningAid.OnLoad(frame)
