--[[

	JS' Hunter Bar Options
	
	... "Load on Demand" module for configuring JS' Hunter Bar.
	
]]

--Create JSHB Options LOD addon under JSHB's Global addon table.
JSHunterBarOptions = LibStub("AceAddon-3.0"):NewAddon("JSHunterBarOptions", "AceConsole-3.0", "AceEvent-3.0")

local fontFlagTable = {}
local DB
local L = JSHB.L -- Locally reference the JSHB Localizations

local function SetupFontFlags(db, keyname, state)
	local t = { strsplit(",", db[3]) }	
	if tContains(t, keyname) and (state == false) then
		tremove(t, JSHB.GetMatchTableValSimple(t, keyname, true) )
	elseif (not tContains(t, keyname) ) and (state == true) then
		t[#t+1] = keyname
	end	
	db[3] = strtrim(strjoin(",", unpack(t) ),",")
end

local function GetPlayerFocusSpells()
	local spellTable = {}
	local i = 1
	while true do
		local spellName, spellSubName = GetSpellBookItemName(i, BOOKTYPE_SPELL)
		if not spellName then do break end end	   
		local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(spellName)
		if cost and (cost > 0) then
			spellTable[name] = name .. " (" .. cost .. ")"
		end
		i = i + 1
	end
	return spellTable
end

local function LockDown(func)
	if (not JSHB.moversLocked) then
		JSHB.moversLocked = not JSHB.moversLocked
		JSHB.LockAllMovers() 
	end	
	func()
end

local function SetTimerSetCollapsed(which)
	local i
	for i=1,#which do
		which[i][17] = nil
	end
end

-- Collapse all expanded options areas
local function CollapseAll()

	local function recurseTree(tree)
		local k, v
		for k,v in pairs(tree) do
			if (type(v) == "table") then
				recurseTree(tree[k])
			elseif ( (k == "showsettings") or (k == "showsettings2") or (k == "showsettings3") ) then
				tree[k] = nil
			end
		end
	end
	-- This function sets all "showsettings" database entries to nil to collapse all expanded options areas
	recurseTree(DB)
	-- Also collapse the timer sets
	SetTimerSetCollapsed(DB.timers.timerbar1.timers)
	SetTimerSetCollapsed(DB.timers.timerbar2.timers)
	SetTimerSetCollapsed(DB.timers.timerbar3.timers)
end

-- This is a sort function for timers in a set.  It only sorts, changes need to be notified and reconfigured separatly
local function SortTimerList(which)
	table.sort(DB.timers["timerbar"..which].timers, function(a,b)
		local aComp = (a[1] ~= nil) and (tonumber(a[1]) and (select(1, GetSpellInfo(a[1]) ) ) or a[1]) or (tonumber(a[2]) and (select(1, GetItemInfo(a[2]) ) ) or a[2])
		local bComp = (b[1] ~= nil) and (tonumber(b[1]) and (select(1, GetSpellInfo(b[1]) ) ) or b[1]) or (tonumber(b[2]) and (select(1, GetItemInfo(b[2]) ) ) or b[2])
		return(aComp < bComp)
	end)
end

function JSHunterBarOptions:PopulateDB()
	DB = JSHB.db.profile
	-- Sort timers
	SortTimerList(1)
	SortTimerList(2)
	SortTimerList(3)
end

function JSHunterBarOptions:OnInitialize()

	-- Populate the local DB upvalue variable
	JSHunterBarOptions:PopulateDB()
	
	-- Collapse all expanded option frames on load
	CollapseAll()
	
	-- Flag the options as being loaded
	JSHB.optionsAreLoaded = true

	-- Local tables for use in options
	fontFlagTable["OUTLINE"] = L["OUTLINE"]
	fontFlagTable["THICKOUTLINE"] = L["THICKOUTLINE"]
	fontFlagTable["MONOCHROME"] = L["MONOCHROME"]
	
	-- Remove any JSHB options panels before making new ones.
	JSHB.RemoveInterfaceOptions("JSHunterBarProfiles", nil, "JS' Hunter Bar", L["Profiles"])
	JSHB.RemoveInterfaceOptions("JSHunterBarOptions", nil, nil, "JS' Hunter Bar")

	-- The LOD button has a gametooltip, if we don't hide it, it lingers.
	GameTooltip:Hide()
	
	-- Register the options table
	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("JSHunterBarOptions", JSHunterBarOptions.SetupOptions)
	
	-- Create a profiles table
	JSHB.profileOptions = LibStub("AceDBOptions-3.0"):GetOptionsTable(JSHB.db)
	LibStub("AceConfig-3.0"):RegisterOptionsTable("JSHunterBarProfiles", JSHB.profileOptions)

	-- Setup the actual options panels
	local AceConfigDialog3 = LibStub("AceConfigDialog-3.0")
	JSHB.optionsFrames = {}
	JSHB.optionsFrames.JSHunterBarOptions = AceConfigDialog3:AddToBlizOptions("JSHunterBarOptions", "JS' Hunter Bar", nil, "main")
	JSHB.optionsFrames.JSHunterBarOptions.energybar = AceConfigDialog3:AddToBlizOptions("JSHunterBarOptions", L["Focus Bar"], "JS' Hunter Bar", "energybar")
	JSHB.optionsFrames.JSHunterBarOptions.enrage = AceConfigDialog3:AddToBlizOptions("JSHunterBarOptions", L["Tranq Alert"], "JS' Hunter Bar", "enrage")
	JSHB.optionsFrames.JSHunterBarOptions.timers1 = AceConfigDialog3:AddToBlizOptions("JSHunterBarOptions", L["Timer Bar 1"], "JS' Hunter Bar", "timers1")
	JSHB.optionsFrames.JSHunterBarOptions.timers1 = AceConfigDialog3:AddToBlizOptions("JSHunterBarOptions", L["Timer Bar 2"], "JS' Hunter Bar", "timers2")
	JSHB.optionsFrames.JSHunterBarOptions.timers1 = AceConfigDialog3:AddToBlizOptions("JSHunterBarOptions", L["Timer Bar 3"], "JS' Hunter Bar", "timers3")
	JSHB.optionsFrames.JSHunterBarOptions.alerts = AceConfigDialog3:AddToBlizOptions("JSHunterBarOptions", L["Alerts"], "JS' Hunter Bar", "alerts")
	JSHB.optionsFrames.JSHunterBarOptions.profiles = AceConfigDialog3:AddToBlizOptions("JSHunterBarProfiles", L["Profiles"], "JS' Hunter Bar")	

	JSHunterBarOptions.OnInitialize = nil
	
	-- Make the Blizzard Interface Options screen movable, why it's not by default is baffling.
	_G["InterfaceOptionsFrame"]:SetMovable()
	_G["InterfaceOptionsFrame"]:SetClampedToScreen()
	_G["InterfaceOptionsFrame"]:RegisterForDrag("LeftButton","RightButton")
	_G["InterfaceOptionsFrame"]:SetScript("OnDragStart", function() _G["InterfaceOptionsFrame"]:StartMoving() end)
	_G["InterfaceOptionsFrame"]:SetScript("OnDragStop", function() _G["InterfaceOptionsFrame"]:StopMovingOrSizing() end)
	
	collectgarbage("collect")
end

function JSHunterBarOptions:CreateTimerSet(setNum)

	-- Have to be sure someone does not try to create a timer by the same name as a hard-coded key.  Probably will never happen, but people do dumb shit.
	local timersetsitemtableblacklist = { "intro", "movers", "timers", "cooldowns", "energybar" }
	local k,v
	for k,v in pairs(JSHB.timersetDefaults) do
		timersetsitemtableblacklist[#timersetsitemtableblacklist + 1] = k
	end	
	for k,v in pairs(DB.timers) do
		timersetsitemtableblacklist[#timersetsitemtableblacklist + 1] = k
	end
	
	local timersetstable = {
		intro = {
			order = 1,
			type = "description",
			fontSize = "medium",
			name = L["TIMERS_DESC"..setNum].."\n",
		},
		spacer2 = { order = 2, type = "description", name = " ", desc = "", },
		genstuff = {
			order = 4,
			type = "group",
			name = L["Bar Style Settings"],
			guiInline = true,
			args = {
				enabled = {
					type = "toggle",
					order = 2,
					name = L["Enable this timer bar"],
					desc = L["TIMERDESC_ENABLE"],
					get = function(info) return DB.timers["timerbar"..setNum][info[#info] ] end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
				},
				spacer4 = { order = 4, type = "description", name = " ", desc = "", width = "half" },--, hidden = function(info) return (DB.timers["timerbar"..setNum].showsettings) end },
				spacer5 = { order = 5, type = "description", name = " ", desc = "", width = "half" },
				showsettings ={
					type = "execute",
					order = 6,
					name = L["Expand"],
					hidden = function(info) return (DB.timers["timerbar"..setNum].showsettings) end,
					func = function(info) CollapseAll(); DB.timers["timerbar"..setNum].showsettings = true;LockDown(JSHB.SetupTimersModule) end,
				},
				hidesettings ={
					type = "execute",
					order = 7,
					name = L["Collapse"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					func = function(info) CollapseAll();LockDown(JSHB.SetupTimersModule) end,
				},
				spacer9 = { order = 9, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end },
				width = {
					type = "range", 
					order = 12,
					name = L["Width"],
					--min = 20, max = 2000, step = 1,
					min = 6, softMax = 600, max = 1000, step = 1,
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info] ]) end,
					set = function(info, size) DB.frames.timers["timerbar"..setNum][info[#info] ] = (size);LockDown(JSHB.SetupTimersModule) end,
				},
				height = {
					type = "range", 
					order = 14,
					name = L["Height"],
					--min = 10, max = 400, step = 1,
					min = 6, softMax = 600, max = 1000, step = 1,
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info] ]) end,
					set = function(info, size) DB.frames.timers["timerbar"..setNum][info[#info] ] = (size);LockDown(JSHB.SetupTimersModule) end,
				},
				reverse = {
					type = "toggle",
					order = 16,
					name = L["Reverse movement"],
					desc = L["REVERSEDESC_ENABLE"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					disabled = function(info) return not DB.timers["timerbar"..setNum]["enabled"] end,
					--width = "full",
					get = function(info) return DB.timers["timerbar"..setNum][info[#info] ] end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
				},
				spacer18 = { order = 18, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end },
				activealpha = {
					type = "range",
					order = 20,
					name = L["Active alpha"],
					desc = L["ACTIVEALPHA_DESC"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					min = 0, max = 1, step = .1,
					isPercent = true,
					disabled = function(info) return not DB.timers["timerbar"..setNum]["enabled"] end,
					get = function(info) return (DB.timers["timerbar"..setNum][info[#info] ]) end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = (value);LockDown(JSHB.SetupTimersModule) end,
				},
				inactivealpha = {
					type = "range",
					order = 22,
					name = L["Inactive alpha"],
					desc = L["INACTIVEALPHA_DESC"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					min = 0, max = 1, step = .1,
					isPercent = true,
					disabled = function(info) return not DB.timers["timerbar"..setNum]["enabled"] end,
					get = function(info) return (DB.timers["timerbar"..setNum][info[#info] ]) end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = (value);LockDown(JSHB.SetupTimersModule) end,
				},
				layout = {
					order = 24,
					type = "select",
					name = L["Layout"],
					desc = L["TIMERORIENTATION_DESC"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					disabled = function(info) return not DB.timers["timerbar"..setNum]["enabled"] end,
					style = "dropdown",
					values = function() 
							local t = {	["horizontal"] = L["Horizontal"], ["vertical"] = L["Vertical"], }
							return(t)
						end,
					get = function(info) return(DB.timers["timerbar"..setNum][info[#info] ]) end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
				},
				oocoverride = {
					type = "toggle",
					order = 26,
					name = L["OOC override"],
					desc = L["ENABLEOOCOVERRIDE_DESC"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					disabled = function(info) return not DB.timers["timerbar"..setNum]["enabled"] end,
					get = function(info) return DB.timers["timerbar"..setNum][info[#info] ] end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
				},
				oocoverridealpha = {
					type = "range",
					order = 28,
					name = L["OOC alpha"],
					desc = L["OOCALPHA_DESC"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					min = 0, max = 1, step = .1,
					isPercent = true,
					disabled = function(info) 
						if not DB.timers["timerbar"..setNum]["oocoverride"] then return true end
						if not DB.timers["timerbar"..setNum]["enabled"] then return true end
						return false end,
					get = function(info) return (DB.timers["timerbar"..setNum][info[#info] ]) end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = (value);LockDown(JSHB.SetupTimersModule) end,
				},
				spacer30 = { order = 30, hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end, type = "description", name = " ", desc = "", },
				mountoverride = {
					type = "toggle",
					order = 32,
					name = L["Mounted override"],
					desc = L["ENABLEMOUNTOVERRIDE_DESC"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					disabled = function(info) return not DB.timers["timerbar"..setNum]["enabled"] end,
					get = function(info) return DB.timers["timerbar"..setNum][info[#info] ] end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
				},
				mountoverridealpha = {
					type = "range",
					order = 34,
					name = L["Mounted alpha"],
					desc = L["MOUNTALPHA_DESC"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					min = 0, max = 1, step = .1,
					isPercent = true,
					disabled = function(info) 
						if not DB.timers["timerbar"..setNum]["mountoverride"] then return true end
						if not DB.timers["timerbar"..setNum]["enabled"] then return true end
						return false end,
					get = function(info) return (DB.timers["timerbar"..setNum][info[#info] ]) end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = (value);LockDown(JSHB.SetupTimersModule) end,
				},
				spacer36 = { order = 36, hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end, type = "description", name = " ", desc = "", },
				deadoverride = {
					type = "toggle",
					order = 38,
					name = L["Dead override"],
					desc = L["ENABLEDEADOVERRIDE_DESC"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					disabled = function(info) return not DB.timers["timerbar"..setNum]["enabled"] end,
					get = function(info) return DB.timers["timerbar"..setNum][info[#info] ] end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
				},
				deadoverridealpha = {
					type = "range",
					order = 40,
					name = L["Dead alpha"],
					desc = L["DEADALPHA_DESC"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					min = 0, max = 1, step = .1,
					isPercent = true,
					disabled = function(info) 
						if not DB.timers["timerbar"..setNum]["deadoverride"] then return true end
						if not DB.timers["timerbar"..setNum]["enabled"] then return true end
						return false end,
					get = function(info) return (DB.timers["timerbar"..setNum][info[#info] ]) end,
					set = function(info, value) DB.timers["timerbar"..setNum][info[#info] ] = (value);LockDown(JSHB.SetupTimersModule) end,
				},
				spacer42 = { order = 42, hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end, type = "description", name = " ", desc = "", },
				backdrop = {
					type = "group",
					order = 44,
					name = L["Backdrop"],
					guiInline = true,
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					args = {
						enablebackdrop = {
							type = "toggle",
							order = 4,
							name = L["Enable"],
							desc = L["DESCBACKDROP_ENABLE"],
							width = "double",
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						backdroptexture = {
							type = "select",
							dialogControl = 'LSM30_Background',
							order = 12,
							name = L["Backdrop texture"],
							desc = L["Texture that gets used for the bar's background."],
							values = AceGUIWidgetLSMlists.background,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enablebackdrop"] end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						colorbackdrop = {
							type = "toggle",
							order = 14,
							name = L["Color the backdrop"],
							desc = L["DESCBACKDROPCOLOR_ENABLE"],
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enablebackdrop"] end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						backdropcolor = {
							type = "color",
							order = 16,
							name = L["Backdrop color"],
							hasAlpha = true,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enablebackdrop"] end,
							hidden = function(info) return not DB.frames.timers["timerbar"..setNum].colorbackdrop end,
							get = function(info) return unpack(DB.frames.timers["timerbar"..setNum][info[#info] ]) end,
							set = function(info, r, g, b, a) DB.frames.timers["timerbar"..setNum][info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupTimersModule) end,
						},
						spacer18 = { order = 18, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return not DB.frames.timers["timerbar"..setNum].colorbackdrop end },
						tile = {
							type = "toggle",
							order = 20,
							name = L["Tile the backdrop"],
							desc = L["DESCBACKDROPTILE_ENABLE"],
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enablebackdrop"] end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						tilesize = {
							type = "range",
							order = 22,
							name = L["Tile size"],
							desc = L["DESCTILESIZE_ENABLE"],
							min = -100, softMin = -30, softMax = 30, max = 100, step = 1,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enablebackdrop"] end,
							hidden = function(info) return not DB.frames.timers["timerbar"..setNum].tile end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						spacer24 = { order = 24, type = "description", name = "", desc = "", width = "full"},
						backdropoffsets = {
							type = "group",
							order = 28,
							name = L["Offsets"],
							guiInline = true,
							args = {
								offsetX1 = {
									type = "range",
									order = 1,
									name = L["Top-left X"],
									desc = L["This sets the 'X offset' value."],
									min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enablebackdrop"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][1]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][1] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								offsetY1 = {
									type = "range", 
									order = 2,
									name = L["Top-left Y"],
									desc = L["This sets the 'Y offset' value."],
									min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enablebackdrop"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][2]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][2] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								spacer8 = { order = 8, type = "description", name = "", desc = "", width = "full"},
								offsetX2 = {
									type = "range", 
									order = 13,
									name = L["Bottom-right X"],
									desc = L["This sets the 'X offset' value."],
									min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enablebackdrop"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][3]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][3] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								offsetY2 = {
									type = "range", 
									order = 14,
									name = L["Bottom-right Y"],
									desc = L["This sets the 'Y offset' value."],
									min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enablebackdrop"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][4]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][4] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},										
							},
						},
					},
				},
				--spacer46 = { order = 46, hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end, type = "description", name = " ", desc = "", },
				border = {
					type = "group",
					order = 48,
					name = L["Border"],
					guiInline = true,
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings) end,
					args = {
						enableborder = {
							type = "toggle",
							order = 1,
							name = L["Enable"],
							desc = L["DESCBORDER_ENABLE"],
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						bordercolor = {
							type = "color",
							order = 2,
							name = L["Border color"],
							hasAlpha = true,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enableborder"] end,
							get = function(info) return unpack(DB.frames.timers["timerbar"..setNum][info[#info] ]) end,
							set = function(info, r, g, b, a) DB.frames.timers["timerbar"..setNum][info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupTimersModule) end,
						},
						bordertexture = {
							type = "select",
							dialogControl = 'LSM30_Border',
							order = 3,
							name = L["Border texture"],
							desc = L["Texture that gets used for the bar's background."],
							values = AceGUIWidgetLSMlists.border,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enableborder"] end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						edgesize = {
							type = "range",
							order = 4,
							name = L["Edge size"],
							desc = L["DESCEDGESIZE_ENABLE"],
							min = -100, softMin = -16, softMax = 16, max = 100, step = 1,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enableborder"] end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						spacer7 = { order = 7, type = "description", name = "", desc = "", width = "full"},
						backdropinsets = {
							type = "group",
							order = 10,
							name = L["Insets"],
							guiInline = true,
							args = {
								left = {
									type = "range",
									order = 1,
									name = L["Left"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enableborder"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][1]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][1] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								right = {
									type = "range", 
									order = 2,
									name = L["Right"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enableborder"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][2]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][2] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								spacer8 = { order = 8, type = "description", name = "", desc = "", width = "full"},
								top = {
									type = "range", 
									order = 13,
									name = L["Top"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enableborder"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][3]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][3] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								bottom = {
									type = "range", 
									order = 18,
									name = L["Bottom"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enableborder"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][4]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][4] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},										
							},
						},
					},
				},
			},
		},
		spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "full" },
		genstuff2 = {
			order = 8,
			type = "group",
			name = L["Timer Style Settings"],
			guiInline = true,
			args = {
				iconsize = {
					type = "range", 
					order = 2,
					name = L["Timer icon size"],
					min = 10, max = 100, step = 1,
					get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info] ]) end,
					set = function(info, size) DB.frames.timers["timerbar"..setNum][info[#info] ] = (size);LockDown(JSHB.SetupTimersModule) end,
				},
				spacer4 = { order = 4, type = "description", name = " ", desc = "", width = "half" },
				spacer5 = { order = 5, type = "description", name = " ", desc = "", width = "half" },
				showsettings2 ={
					type = "execute",
					order = 6,
					name = L["Expand"],
					hidden = function(info) return (DB.timers["timerbar"..setNum].showsettings2) end,
					func = function(info) CollapseAll(); DB.timers["timerbar"..setNum].showsettings2 = true;LockDown(JSHB.SetupTimersModule) end,
				},
				hidesettings2 ={
					type = "execute",
					order = 8,
					name = L["Collapse"],
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings2) end,
					func = function(info) CollapseAll();LockDown(JSHB.SetupTimersModule) end,
				},
				spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings2) end },
				timefont = {
					type = "group",
					order = 14,
					name = L["Timer font"],
					guiInline = true,
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings2) end,
					args = {
						font = {
							type = "select", 
							dialogControl = 'LSM30_Font',
							order = 2,
							name = L["Font face"],
							desc = L["This is the font used for cooldown or duration timers."],
							values = AceGUIWidgetLSMlists.font,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info-1] ][1] end,
							set = function(info, font) DB.frames.timers["timerbar"..setNum][info[#info-1] ][1] = font;LockDown(JSHB.SetupTimersModule) end,
						},
						spacer4 = { order = 4, type = "description", name = " ", desc = "", width = "half" },
						size = {
							type = "range", 
							order = 6,
							name = L["Font size"],
							min = 6, max = 40, step = 1,
							get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][2]) end,
							set = function(info, size) DB.frames.timers["timerbar"..setNum][info[#info-1] ][2] = (size);LockDown(JSHB.SetupTimersModule) end,
						},
						timerfontcolorstatic = {
							type = "toggle",
							order = 10,
							name = L["Static time color"],
							desc = L["STATICTIMERCOLOR_DESC"],
							--width = "full",
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						timerfontcolor = {
							type = "color",
							order = 12,
							name = L["Static color"],
							desc = L["Color used for the time font if set to static"],
							hasAlpha = false,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum].timerfontcolorstatic end,
							get = function(info) return unpack(DB.frames.timers["timerbar"..setNum][info[#info] ]) end,
							set = function(info, r, g, b, a) DB.frames.timers["timerbar"..setNum][info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupTimersModule) end,
						},
						spacer14 = { order = 14, type = "description", name = " ", desc = "", width = "half" },
						spacer15 = { order = 15, type = "description", name = " ", desc = "", width = "full" },
						flags = {
							type = "multiselect", 
							order = 16,
							name = L["Font flags"],
							values = fontFlagTable,
							get = function(info, key) return(tContains({strsplit(",", DB.frames.timers["timerbar"..setNum][info[#info-1] ][3])}, key) and true or false) end,
							set = function(info, keyname, state) setFontFlags(DB.frames.timers["timerbar"..setNum][info[#info-1] ], keyname, state);LockDown(JSHB.SetupTimersModule) end,
						},
						timefont = {
							type = "group",
							order = 18,
							name = L["Font shadow"],
							guiInline = true,
							hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings2) end,
							args = {
								enabletimershadow = {
									type = "toggle",
									order = 20,
									name = L["Enable"],
									desc = L["ENABLESHADOW_DESC"],
									width = "double",
									get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
									set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
								},
								timershadowcolor = {
									type = "color",
									order = 22,
									name = L["Font shadow color"],
									desc = L["Color used for the text font shadow"],
									hasAlpha = true,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum].enabletimershadow end,
									get = function(info) return unpack(DB.frames.timers["timerbar"..setNum][info[#info] ]) end,
									set = function(info, r, g, b, a) DB.frames.timers["timerbar"..setNum][info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupTimersModule) end,
								},
								offsetX = {
									type = "input", 
									order = 24,
									name = L["X offset"],
									desc = L["This sets the 'X offset' value."],
									width = "half",
									pattern = "%d",
									usage = L["Only valid numeric offsets are allowed."],
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum].enabletimershadow end,
									get = function(info) return tostring(DB.frames.timers["timerbar"..setNum].timershadowoffset[1]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum].timershadowoffset[1] = tonumber(offset);LockDown(JSHB.SetupTimersModule) end,
								},
								offsetY = {
									type = "input", 
									order = 26,
									name = L["Y offset"],
									desc = L["This sets the 'Y offset' value."],
									width = "half",
									pattern = "%d",
									usage = L["Only valid numeric offsets are allowed."],
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum].enabletimershadow end,
									get = function(info) return tostring(DB.frames.timers["timerbar"..setNum].timershadowoffset[2]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum].timershadowoffset[2] = tonumber(offset);LockDown(JSHB.SetupTimersModule) end,
								},
							},
						},
					},
				},
				stackfont = {
					type = "group",
					order = 28,
					name = L["Stacks font"],
					guiInline = true,
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings2) end,
					args = {
						font = {
							type = "select", 
							dialogControl = 'LSM30_Font',
							order = 2,
							name = L["Font face"],
							desc = L["Font used for stacks on the timers."],
							values = AceGUIWidgetLSMlists.font,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info-1] ][1] end,
							set = function(info, font) DB.frames.timers["timerbar"..setNum][info[#info-1] ][1] = font;LockDown(JSHB.SetupTimersModule) end,
						},
						size = {
							type = "range", 
							order = 4,
							name = L["Font size"],
							min = 6, max = 40, step = 1,
							get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][2]) end,
							set = function(info, size) DB.frames.timers["timerbar"..setNum][info[#info-1] ][2] = (size);LockDown(JSHB.SetupTimersModule) end,
						},
						stackfontcolor = {
							type = "color",
							order = 6,
							name = L["Stacks font color"],
							desc = L["Color used for the timer's stacks font."],
							hasAlpha = false,
							get = function(info) return unpack(DB.frames.timers["timerbar"..setNum][info[#info] ]) end,
							set = function(info, r, g, b, a) DB.frames.timers["timerbar"..setNum][info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupTimersModule) end,
						},
						flags = {
							type = "multiselect", 
							order = 8,
							name = L["Font flags"],
							values = fontFlagTable,
							get = function(info, key) return(tContains({strsplit(",", DB.frames.timers["timerbar"..setNum][info[#info-1] ][3])}, key) and true or false) end,
							set = function(info, keyname, state) setFontFlags(DB.frames.timers["timerbar"..setNum][info[#info-1] ], keyname, state);LockDown(JSHB.SetupTimersModule) end,
						},
					},
				},
				texcoords = {
					type = "group",
					order = 30,
					name = L["Texture coords"],
					guiInline = true,
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings2) end,
					args = {						
						enabletexcoords = {
							type = "toggle",
							order = 5,
							name = L["Enable TexCoords"],
							desc = L["DESCTEXCOORDS_ENABLE"],
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						texcoords = {
							type = "group",
							order = 6,
							name = L["Texture coords"],
							guiInline = true,
							args = {
								left = {
									type = "range",
									order = 1,
									name = L["Left"],
									min = 0, max = 1, step = .01,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enabletexcoords"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][1]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][1] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								right = {
									type = "range", 
									order = 2,
									name = L["Right"],
									min = 0, max = 1, step = .01,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enabletexcoords"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][2]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][2] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								spacer4 = { order = 4, type = "description", name = " ", desc = "", width = "half" },
								top = {
									type = "range", 
									order = 6,
									name = L["Top"],
									min = 0, max = 1, step = .01,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enabletexcoords"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][3]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][3] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								bottom = {
									type = "range", 
									order = 8,
									name = L["Bottom"],
									min = 0, max = 1, step = .01,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["enabletexcoords"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][4]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][4] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},										
							},
						},
					},
				},
				timerbackdrop = {
					type = "group",
					order = 32,
					name = L["Backdrop"],
					guiInline = true,
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings2) end,
					args = {
						timerenablebackdrop = {
							type = "toggle",
							order = 1,
							name = L["Enable"],
							desc = L["DESCBACKDROP_ENABLE"],
							width = "double",
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						timerbackdroptexture = {
							type = "select",
							dialogControl = 'LSM30_Background',
							order = 2,
							name = L["Backdrop texture"],
							desc = L["Texture that gets used for the bar's background."],
							values = AceGUIWidgetLSMlists.background,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenablebackdrop"] end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						timercolorbackdrop = {
							type = "toggle",
							order = 3,
							name = L["Color the backdrop"],
							desc = L["DESCBACKDROPCOLOR_ENABLE"],
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenablebackdrop"] end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						timerbackdropcolor = {
							type = "color",
							order = 4,
							name = L["Backdrop color"],
							width = "double",
							hasAlpha = true,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenablebackdrop"] end,
							hidden = function(info) return not DB.frames.timers["timerbar"..setNum].timercolorbackdrop end,
							get = function(info) return unpack(DB.frames.timers["timerbar"..setNum][info[#info] ]) end,
							set = function(info, r, g, b, a) DB.frames.timers["timerbar"..setNum][info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupTimersModule) end,
						},
						timertile = {
							type = "toggle",
							order = 5,
							name = L["Tile the backdrop"],
							desc = L["DESCBACKDROPTILE_ENABLE"],
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenablebackdrop"] end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						timertilesize = {
							type = "range",
							order = 6,
							name = L["Tile size"],
							desc = L["DESCTILESIZE_ENABLE"],
							min = -100, softMin = -30, softMax = 30, max = 100, step = 1,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenablebackdrop"] end,
							hidden = function(info) return not DB.frames.timers["timerbar"..setNum].timertile end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						spacer7 = { order = 7, type = "description", name = "", desc = "", width = "full"},
						timerbackdropoffsets = {
							type = "group",
							order = 8,
							name = L["Offsets"],
							guiInline = true,
							args = {
								offsetX1 = {
									type = "range",
									order = 2,
									name = L["Top-left X"],
									desc = L["This sets the 'X offset' value."],
									min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenablebackdrop"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][1]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][1] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								offsetY1 = {
									type = "range", 
									order = 4,
									name = L["Top-left Y"],
									desc = L["This sets the 'Y offset' value."],
									min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenablebackdrop"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][2]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][2] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								spacer6 = { order = 6, type = "description", name = "", desc = "", width = "half"},
								offsetX2 = {
									type = "range", 
									order = 8,
									name = L["Bottom-right X"],
									desc = L["This sets the 'X offset' value."],
									min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenablebackdrop"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][3]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][3] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								offsetY2 = {
									type = "range", 
									order = 10,
									name = L["Bottom-right Y"],
									desc = L["This sets the 'Y offset' value."],
									min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenablebackdrop"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][4]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][4] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},										
							},
						},
					},
				},
				timerborder = {
					type = "group",
					order = 34,
					name = L["Border"],
					guiInline = true,
					hidden = function(info) return (not DB.timers["timerbar"..setNum].showsettings2) end,
					args = {
						timerenableborder = {
							type = "toggle",
							order = 1,
							name = L["Enable"],
							desc = L["DESCBORDER_ENABLE"],
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						timerbordercolor = {
							type = "color",
							order = 2,
							name = L["Border color"],
							hasAlpha = true,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenableborder"] end,
							get = function(info) return unpack(DB.frames.timers["timerbar"..setNum][info[#info] ]) end,
							set = function(info, r, g, b, a) DB.frames.timers["timerbar"..setNum][info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupTimersModule) end,
						},
						timerbordertexture = {
							type = "select",
							dialogControl = 'LSM30_Border',
							order = 3,
							name = L["Border texture"],
							desc = L["Texture that gets used for an individual timer's background."],
							values = AceGUIWidgetLSMlists.border,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenableborder"] end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						timeredgesize = {
							type = "range",
							order = 4,
							name = L["Edge size"],
							desc = L["DESCEDGESIZE_ENABLE"],
							min = -100, softMin = -16, softMax = 16, max = 100, step = 1,
							disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenableborder"] end,
							get = function(info) return DB.frames.timers["timerbar"..setNum][info[#info] ] end,
							set = function(info, value) DB.frames.timers["timerbar"..setNum][info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
						},
						spacer9 = { order = 9, type = "description", name = "", desc = "", width = "full"},
						timerbackdropinsets = {
							type = "group",
							order = 10,
							name = L["Insets"],
							guiInline = true,
							args = {
								left = {
									type = "range",
									order = 2,
									name = L["Left"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenableborder"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][1]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][1] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								right = {
									type = "range", 
									order = 4,
									name = L["Right"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenableborder"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][2]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][2] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								spacer6 = { order = 6, type = "description", name = "", desc = "", width = "half"},
								top = {
									type = "range", 
									order = 8,
									name = L["Top"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenableborder"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][3]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][3] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},
								bottom = {
									type = "range", 
									order = 10,
									name = L["Bottom"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.timers["timerbar"..setNum]["timerenableborder"] end,
									get = function(info) return (DB.frames.timers["timerbar"..setNum][info[#info-1] ][4]) end,
									set = function(info, offset) DB.frames.timers["timerbar"..setNum][info[#info-1] ][4] = (offset);LockDown(JSHB.SetupTimersModule) end,
								},										
							},
						},
					},
				},
			},
		},
		--spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return (not DB.timers["timerbar"..setNum].enabled) end },
		headerstuff = {
			order = 14,
			type = "group",
			name = " ",
			guiInline = true,
			hidden = function(info) return (not DB.timers["timerbar"..setNum].enabled) end,
			args = {
				headerstuff = {
					order = 8,
					type = "group",
					name = L["Timer Configuration"],
					guiInline = true,
					args = {
						timercount = {
							order = 8,
							type = "description",
							fontSize = "large",
							width = "double",
							name = "  "..(#DB.timers["timerbar"..setNum].timers).." "..L["TIMERCOUNTFORSET"],
						},
						newtimer = {
							order = 10,
							type = "execute",
							name = L["Add new timer"],
							hidden = function(info) return (not DB.timers["timerbar"..setNum].enabled) end,
							confirm = function() return(L["ADDTIMER_CONFIRM"]) end,
							func = function(info)
									DB.timers["timerbar"..setNum].timers[#DB.timers["timerbar"..setNum].timers + 1] = JSHB.DeepCopy(JSHB.newTimerDefaults)
									SortTimerList(setNum)
									LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
									LockDown(JSHB.SetupTimersModule)
								end,
						},
					},
				},
				spacer12 = { order = 12, type = "description", name = " ", desc = "", width = "full" },
			},
		},
	}

	-- Add the timers for this bar below the general bar settings
	local i
	local ord2 = 100
	for i=1,#DB.timers["timerbar"..setNum].timers do
		if DB.timers["timerbar"..setNum].timers[i][17] then -- Expanded view
			timersetstable.headerstuff.args["timer" .. i] = {
				order = ord2,
				type = "group",
				name = function(info)
						local t
						if DB.timers["timerbar"..setNum].timers[i][2] == nil then
							t = DB.timers["timerbar"..setNum].timers[i][1]
							if tonumber(t) then
								return strupper(select(1, GetSpellInfo(tonumber(t) ) ) or t)
							end
							return strupper(t)
						end
						
						t = DB.timers["timerbar"..setNum].timers[i][2]							
						if tonumber(t) then
							return strupper(select(1, GetItemInfo(tonumber(t) ) ) or t)
						end
						return strupper(t)
					end,
				guiInline = true,
				hidden = function(info) return (not DB.timers["timerbar"..setNum].enabled) end,
				args = {
					spellicon = {
						order = 1,
						type = "execute",
						name = function(info)
								local t
								if DB.timers["timerbar"..setNum].timers[i][2] == nil then
									t = DB.timers["timerbar"..setNum].timers[i][1]
									if tonumber(t) then
										return(select(1, GetSpellInfo(tonumber(t) )) or t)
									end
									return(t)
								end
								
								t = DB.timers["timerbar"..setNum].timers[i][2]							
								if tonumber(t) then
									return(select(1, GetItemInfo(tonumber(t) )) or t)
								end
								return(t)
							end,
						desc = L["SPELLLICON_DESC"],
						func = function() return end,
						image = function(info)
								local t
								local q = "Interface\\ICONS\\INV_Misc_QuestionMark"
								if DB.timers["timerbar"..setNum].timers[i][2] == nil then
									t = DB.timers["timerbar"..setNum].timers[i][1]
									if tonumber(t) then
										return(select(3, GetSpellInfo(tonumber(t) )) or q)
									end
									if GetSpellInfo(t) then
										return(select(3, GetSpellInfo(t) ) or q)
									end
									return(q)
								end
								
								t = DB.timers["timerbar"..setNum].timers[i][2]							
								if tonumber(t) then
									return(select(10, GetItemInfo(tonumber(t) )) or q)
								end
								if GetItemInfo(t) then
									return(select(10, GetItemInfo(t) ) or q)
								end
								return(q)
							end,
					},
					a = { -- Spell name or ID.
						order = 2,
						type = "input",
						name = L["Enter a Spell Name or ID..."],
						desc = L["SPELL_DESC"],
						confirm = function(info)
								if DB.timers["timerbar"..setNum].timers[i][2] ~= nil then
									return(L["CHANGETOSPELL_CONFIRM"])
								end							
								return(false)
							end,
						validate = function(info, val)
								if GetSpellInfo(tonumber(val) and tonumber(val) or val) then return(true) end
								if tonumber(val) then -- If it's a Spell ID number we CAN verify it.
									print(JSHB.L["JSHB_PRE"].."|cffff0000"..L["TIMERSPELL_INVALID"].."|r")
									return(false) 
								end
								-- If it's not a Spell ID number we can only verify it if the player HAS that spell in his book.
								if not (GetSpellInfo(val) ) then -- Try to verify, if it does then we don't need to show the unverified warning.
									print(JSHB.L["JSHB_PRE"].."|cffff0000"..L["TIMERSPELL_UNVERIFIED"].."|r")
								end
								return(true)
							end,
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][1] ~= nil and 
								tostring(DB.timers["timerbar"..setNum].timers[i][1]) or "") end,
						set = function(info, val)
								DB.timers["timerbar"..setNum].timers[i][2] = nil
								DB.timers["timerbar"..setNum].timers[i][1] = (tonumber(val) and tonumber(val) or val)
								
								table.sort(DB.timers["timerbar"..setNum].timers, function(a,b)
									local aComp = (a[1] ~= nil) and (tonumber(a[1]) and (select(1, GetSpellInfo(a[1]) )) or a[1]) or (tonumber(a[2]) and (select(1, GetItemInfo(a[2]) )) or a[2])
									local bComp = (b[1] ~= nil) and (tonumber(b[1]) and (select(1, GetSpellInfo(b[1]) )) or b[1]) or (tonumber(b[2]) and (select(1, GetItemInfo(b[2]) )) or b[2])
									return(aComp < bComp)
								end)
								
								LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
								collectgarbage("collect")
								LockDown(JSHB.SetupTimersModule)
							end,
					},
					b = { -- Item name or ID.
						order = 3,
						type = "input",
						name = L["...or an Item Name or ID"],
						desc = L["ITEM_DESC"],
						confirm = function(info)
								if DB.timers["timerbar"..setNum].timers[i][1] ~= nil then
									return(L["CHANGETOITEM_CONFIRM"])
								end							
								return(false)
							end,
						validate = function(info, val)
								if GetItemInfo(tonumber(val) and tonumber(val) or val) then return(true) end
								if tonumber(val) then -- If it's an Item ID number we CAN verify it.
									print(JSHB.L["JSHB_PRE"].."|cffff0000"..L["TIMERITEM_INVALID"].."|r")
									return(false) 
								end
								-- If it's not an Item ID number we can only verify it if the player HAS that item.
								if not (GetItemInfo(val) ) then -- Try to verify, if it does then we don't need to show the unverified warning.
									print(JSHB.L["JSHB_PRE"].."|cffff0000"..L["TIMERITEM_UNVERIFIED"].."|r")
								end
								return(true)
							end,
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][2] ~= nil and
								tostring(DB.timers["timerbar"..setNum].timers[i][2]) or "") end,
						set = function(info, val)
								DB.timers["timerbar"..setNum].timers[i][1] = nil
								DB.timers["timerbar"..setNum].timers[i][2] = (tonumber(val) and tonumber(val) or val)
								
								table.sort(DB.timers["timerbar"..setNum].timers, function(a,b)
									local aComp = (a[1] ~= nil) and (tonumber(a[1]) and (select(1, GetSpellInfo(a[1]) )) or a[1]) or (tonumber(a[2]) and (select(1, GetItemInfo(a[2]) )) or a[2])
									local bComp = (b[1] ~= nil) and (tonumber(b[1]) and (select(1, GetSpellInfo(b[1]) )) or b[1]) or (tonumber(b[2]) and (select(1, GetItemInfo(b[2]) )) or b[2])
									return(aComp < bComp)
								end)
								
								LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
								collectgarbage("collect")
								LockDown(JSHB.SetupTimersModule)
							end,
					},
					c = { -- Target to check for the spell.
						order = 4,
						type = "select",
						name = L["Check target"],
						desc = L["CHECKTARGET_DESC"],
						hidden = function(info) return( (DB.timers["timerbar"..setNum].timers[i][2] ~= nil) and true or false) end,
						style = "dropdown",
						values = function() return JSHB.targets end,
						get = function(info) return DB.timers["timerbar"..setNum].timers[i][3] end,
						set = function(info, value) DB.timers["timerbar"..setNum].timers[i][3] = value;LockDown(JSHB.SetupTimersModule) end,
					},
					d = { -- Duration, cooldown or internal cooldown
						order = 5,
						type = "select",
						name = L["Check type"],
						desc = L["CHECKTYPE_DESC"],
						hidden = function(info) return( (DB.timers["timerbar"..setNum].timers[i][2] ~= nil) and true or false) end,
						style = "dropdown",
						values = function() 
								local t = {	["DURATION"] = L["Duration"], ["COOLDOWN"] = L["Cooldown"], ["ICOOLDOWN"] = L["Internal Cooldown"], }
								return(t)
							end,
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][4]) end,
						set = function(info, value) DB.timers["timerbar"..setNum].timers[i][4] = (value);LockDown(JSHB.SetupTimersModule) end,
					},
					e = { -- Owner
						order = 6,
						type = "select",
						name = L["Owner of spell"],
						desc = L["SPELLOWNER_DESC"],
						hidden = function(info) return( (DB.timers["timerbar"..setNum].timers[i][2] ~= nil) and true or false) end,
						style = "dropdown",
						values = function() return JSHB.timerOwners end,
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][5]) end,
						set = function(info, value) DB.timers["timerbar"..setNum].timers[i][5] = (value);LockDown(JSHB.SetupTimersModule) end,
					},
					f = { -- Spec
						order = 7,
						type = "select",
						name = L["Talent spec"],
						desc = L["TALENTSPEC_DESC"],
						style = "dropdown",
						values = function()
								local t = {
									["0"] = L["Any Spec"],
									["1"] = select(2, GetTalentTabInfo(1) ),
									["2"] = select(2, GetTalentTabInfo(2) ),
									["3"] = select(2, GetTalentTabInfo(3) ),
								}
								return(t)
							end,
						get = function(info) return(tostring(DB.timers["timerbar"..setNum].timers[i][6]) ) end,
						set = function(info, value) DB.timers["timerbar"..setNum].timers[i][6] = tonumber(value);LockDown(JSHB.SetupTimersModule) end,
					},
					g = { -- Timer text position
						order = 8,
						type = "select",
						name = L["Positon of timer text"],
						desc = L["TIMERTEXTPOS_DESC"],
						style = "dropdown",
						values = function()
								local t = JSHB.DeepCopy(JSHB.timerPositions)
								t["NONE"] = L["NONE"]
								return(t) 
							end,
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][7]) end,
						set = function(info, value) DB.timers["timerbar"..setNum].timers[i][7] = (value);LockDown(JSHB.SetupTimersModule) end,
					},
					spacer9 = { order = 9, type = "description", name = "", desc = "" },
					h = { -- Flash
						type = "toggle",
						order = 10,
						name = L["Flash when expiring"],
						desc = L["EXPIREFLASH_ENABLE"],
						--width = "full",
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][8]) end,
						set = function(info, value) DB.timers["timerbar"..setNum].timers[i][8] = value;LockDown(JSHB.SetupTimersModule) end,
					},
					i = { -- Spin
						type = "toggle",
						order = 11,
						name = L["Spin when expiring"],
						desc = L["EXPIRESPIN_ENABLE"],
						--width = "full",
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][9]) end,
						set = function(info, value) DB.timers["timerbar"..setNum].timers[i][9] = value;LockDown(JSHB.SetupTimersModule) end,
					},
					spacer12 = { order = 12, type = "description", name = "", desc = "" },
					j = { -- Grow
						type = "toggle",
						order = 13,
						name = L["Grow when expiring"],
						desc = L["EXPIREGROW_ENABLE"],
						--width = "full",
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][10]) end,
						set = function(info, value) DB.timers["timerbar"..setNum].timers[i][10] = value;LockDown(JSHB.SetupTimersModule) end,
					},
					k = { -- Grow Start
						type = "range", 
						order = 14,
						name = L["Grow start %"],
						desc = L["GROWSTART_DESC"],
						hidden = function(info) return(not DB.timers["timerbar"..setNum].timers[i][10]) end,
						isPercent = true,
						min = .1, max = 1, step = .1,
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][11]) end,
						set = function(info, size) DB.timers["timerbar"..setNum].timers[i][11] = (size);LockDown(JSHB.SetupTimersModule) end,
					},
					l = { -- Grow Size
						type = "range", 
						order = 16,
						name = L["Grow size %"],
						desc = L["GROWSIZE_DESC"],
						hidden = function(info) return(not DB.timers["timerbar"..setNum].timers[i][10]) end,
						isPercent = true,
						min = 1.1, max = 3, step = .1,
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][12]) end,
						set = function(info, size) DB.timers["timerbar"..setNum].timers[i][12] = (size);LockDown(JSHB.SetupTimersModule) end,
					},
					spacer17 = { order = 17, type = "description", name = "", desc = "", hidden = function(info) return(not DB.timers["timerbar"..setNum].timers[i][13]) end },
					spacer18 = { order = 18, type = "description", name = "", desc = "", hidden = function(info) return(not DB.timers["timerbar"..setNum].timers[i][13]) end },
					m = { -- Alpha Change
						type = "toggle",
						order = 19,
						name = L["Alpha change"],
						desc = L["EXPIREALPHA_ENABLE"],
						--width = "full",
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][13]) end,
						set = function(info, value) DB.timers["timerbar"..setNum].timers[i][13] = value;LockDown(JSHB.SetupTimersModule) end,
					},
					n = { -- Alpha Change - Start
						type = "range", 
						order = 20,
						name = L["Alpha start %"],
						desc = L["ALPHASTART_DESC"],
						hidden = function(info) return(not DB.timers["timerbar"..setNum].timers[i][13]) end,
						isPercent = true,
						min = 0, max = 1, step = .1,
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][14]) end,
						set = function(info, size) DB.timers["timerbar"..setNum].timers[i][14] = (size);LockDown(JSHB.SetupTimersModule) end,
					},
					o = { -- Alpha Change - End
						type = "range", 
						order = 21,
						name = L["Alpha end %"],
						desc = L["ALPHAEND_DESC"],
						hidden = function(info) return(not DB.timers["timerbar"..setNum].timers[i][13]) end,
						isPercent = true,
						min = 0, max = 1, step = .1,
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][15]) end,
						set = function(info, size) DB.timers["timerbar"..setNum].timers[i][15] = (size);LockDown(JSHB.SetupTimersModule) end,
					},
					p = { -- Internal Cooldown (code added by Hugus)
						order = 22,
						type = "input",
						name = L["Internal cooldown"],
						desc = L["ICOOLDOWN_DESC"],
						hidden = function(info) return ( (DB.timers["timerbar"..setNum].timers[i][4] == nil) or (DB.timers["timerbar"..setNum].timers[i][4] ~= "ICOOLDOWN") ) end,
						validate = function(info, val)
								if tonumber(val) then return(true) end
								print(JSHB.L["JSHB_PRE"].."|cffff0000"..L2["TIMERTEXT_INVALID"].."|r")
								return(false) 
							end,
						get = function(info) return(DB.timers["timerbar"..setNum].timers[i][16] ~= nil and
								tostring(DB.timers["timerbar"..setNum].timers[i][16]) or "") end,
						set = function(info, val)
								DB.timers["timerbar"..setNum].timers[i][16] = val

								LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
								collectgarbage("collect")
								LockDown(JSHB.SetupTimersModule)
							end,
					},
					spacer50 = { order = 50, type = "description", name = "\n", desc = "", width = "full" },
					delete = {
						order = 52,
						type = "execute",
						name = L["Delete timer"],
						--image = "Interface\\Icons\\Spell_ChargeNegative",
						confirm = function(info) return(L["DELETETIMER_CONFIRM"]) end,
						func = function(info)
								tremove(DB.timers["timerbar"..setNum].timers, tonumber(strsub(info[#info-1],6) ))
								LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
								LockDown(JSHB.SetupTimersModule)
							end,							
					},
					spacer54 = { order = 54, type = "description", name = "", width = "half" },
					spacer56 = { order = 56, type = "description", name = "", width = "half" },
					hidesettings = {
						type = "execute",
						order = 58,
						name = L["Collapse"],
						func = function(info) CollapseAll()	end,
					},
				},					
			}
		else -- Collapsed view
			timersetstable.headerstuff.args["timer" .. i] = {
				order = ord2,
				type = "group",
				name = L["Timer"].." "..i,
				guiInline = true,
				inline = true,
				hidden = function(info) return (not DB.timers["timerbar"..setNum].enabled) end,
				args = {
					spellicon = {
						order = 1,
						type = "description",
						name = function(info)
							local t
							if DB.timers["timerbar"..setNum].timers[i][2] == nil then
								t = DB.timers["timerbar"..setNum].timers[i][1]
								if tonumber(t) then
									return(select(1, GetSpellInfo(tonumber(t) ) ) or t)
								end
								return(t)
							end
							
							t = DB.timers["timerbar"..setNum].timers[i][2]							
							if tonumber(t) then
								return(select(1, GetItemInfo(tonumber(t) ) ) or t)
							end
							return(t)
						end,
						width = "double",
						fontSize = "medium",
						func = function() return end,
						image = function(info)
								local t
								local q = "Interface\\ICONS\\INV_Misc_QuestionMark"
								if DB.timers["timerbar"..setNum].timers[i][2] == nil then
									t = DB.timers["timerbar"..setNum].timers[i][1]
									if tonumber(t) then
										return(select(3, GetSpellInfo(tonumber(t) )) or q)
									end
									if GetSpellInfo(t) then
										return(select(3, GetSpellInfo(t) ) or q)
									end
									return(q)
								end
								
								t = DB.timers["timerbar"..setNum].timers[i][2]							
								if tonumber(t) then
									return(select(10, GetItemInfo(tonumber(t) )) or q)
								end
								if GetItemInfo(t) then
									return(select(10, GetItemInfo(t) ) or q)
								end
								return(q)
							end,
					},
					showsettings = {
						type = "execute",
						order = 10,
						--width = "half",
						name = L["Expand"],
						func = function(info) CollapseAll(); DB.timers["timerbar"..setNum].timers[i][17] = true;LockDown(JSHB.SetupTimersModule) end,
					},
				},
			}
		end
		ord2 = ord2 + 1
	end
	
	return timersetstable
end

function JSHunterBarOptions:CreateAlerts()

	-- Have to be sure someone does not try to create an alert by the same name as a hard-coded key.  Probably will never happen, but people do dumb shit.
	local alertstableblacklist = { "intro", "movers", "icons", "cooldowns", "energybar", "alerts" }
	local k,v
	for k,v in pairs(JSHB.alertDefaults) do
		alertstableblacklist[#alertstableblacklist + 1] = k
	end	
	for k,v in pairs(DB.alerts) do
		alertstableblacklist[#alertstableblacklist + 1] = k
	end	
	
	-- table.sort does not work for named keys, so we need to sort it another way
	JSHB.sortedKeysTable = {}
	local key, value
	for key,value in pairs(DB.alerts) do table.insert(JSHB.sortedKeysTable, key) end
	table.sort(JSHB.sortedKeysTable, function(a,b) return (strupper(a) < strupper(b) ) end)

	local alertstable = {
		intro = {
			order = 1,
			type = "description",
			name = L["ALERTS_DESC"].."\n",
			fontSize = "medium",
		},
		spacer2 = { order = 2, type = "description", name = " ", desc = "", width = "full" },
		genstuff = {
			order = 4,
			type = "group",
			name = L["Alert Settings"],
			guiInline = true,
			args = {
				iconsize = {
					type = "range", 
					order = 2,
					name = L["Icon size"],
					min = 10, max = 100, step = 1,
					get = function(info) return (DB.frames.alerts.icons[info[#info] ]) end,
					set = function(info, size) DB.frames.alerts.icons[info[#info] ] = (size);LockDown(JSHB.SetupAlertsModule) end,
				},
				spacer4 = { order = 4, type = "description", name = " ", desc = "", width = "half" },
				spacer5 = { order = 5, type = "description", name = " ", desc = "", width = "half" },
				showsettings = {
					type = "execute",
					order = 6,
					name = L["Expand"],
					hidden = function(info) return (DB.frames.alerts.icons.showsettings) end,
					func = function(info) CollapseAll(); DB.frames.alerts.icons.showsettings = true;LockDown(JSHB.SetupAlertsModule) end,
				},
				hidesettings ={
					type = "execute",
					order = 8,
					name = L["Collapse"],
					hidden = function(info) return (not DB.frames.alerts.icons.showsettings) end,
					func = function(info) CollapseAll();LockDown(JSHB.SetupAlertsModule) end,
				},
				spacer9 = { order = 10, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return (not DB.frames.alerts.icons.showsettings) end },
				stackfont = {
					type = "group",
					order = 12,
					name = L["Stacks font"],
					guiInline = true,
					hidden = function(info) return (not DB.frames.alerts.icons.showsettings) end,
					args = {
						font = {
							type = "select", 
							dialogControl = 'LSM30_Font',
							order = 2,
							name = L["Font face"],
							desc = L["This is the font used for stacks on the alert."],
							values = AceGUIWidgetLSMlists.font,
							get = function(info) return DB.frames.alerts.icons[info[#info-1] ][1] end,
							set = function(info, font) DB.frames.alerts.icons[info[#info-1] ][1] = font;LockDown(JSHB.SetupAlertsModule) end,
						},
						stackfontcolor = {
							type = "color",
							order = 4,
							name = L["Stacks font color"],
							desc = L["Color used for the stacks font."],
							hasAlpha = false,
							get = function(info) return unpack(DB.frames.alerts.icons[info[#info] ]) end,
							set = function(info, r, g, b, a) DB.frames.alerts.icons[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupAlertsModule) end,
						},
						size = {
							type = "range", 
							order = 6,
							name = L["Font size"],
							min = 6, max = 40, step = 1,
							get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][2]) end,
							set = function(info, size) DB.frames.alerts.icons[info[#info-1] ][2] = (size);LockDown(JSHB.SetupAlertsModule) end,
						},
						flags = {
							type = "multiselect", 
							order = 8,
							name = L["Font flags"],
							values = fontFlagTable,
							get = function(info, key) return(tContains({strsplit(",", DB.frames.alerts.icons[info[#info-1] ][3])}, key) and true or false) end,
							set = function(info, keyname, state) setFontFlags(DB.frames.alerts.icons[info[#info-1] ], keyname, state);LockDown(JSHB.SetupAlertsModule) end,
						},
					},
				},
				texcoords = {
					type = "group",
					order = 18,
					name = L["Texture coords"],
					guiInline = false,
					hidden = function(info) return(not DB.frames.alerts.icons.showsettings) end,
					args = {						
						enabletexcoords = {
							type = "toggle",
							order = 5,
							name = L["Enable TexCoords"],
							desc = L["DESCTEXCOORDS_ENABLE"],
							get = function(info) return DB.frames.alerts.icons[info[#info] ] end,
							set = function(info, value) DB.frames.alerts.icons[info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
						},
						texcoords = {
							type = "group",
							order = 6,
							name = L["Texture coords"],
							guiInline = true,
							args = {
								left = {
									type = "range",
									order = 1,
									name = L["Left"],
									min = 0, max = 1, step = .01,
									disabled = function(info) return not DB.frames.alerts.icons["enabletexcoords"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][1]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},
								right = {
									type = "range", 
									order = 2,
									name = L["Right"],
									min = 0, max = 1, step = .01,
									disabled = function(info) return not DB.frames.alerts.icons["enabletexcoords"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][2]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},
								spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half" },
								top = {
									type = "range", 
									order = 12,
									name = L["Top"],
									min = 0, max = 1, step = .01,
									disabled = function(info) return not DB.frames.alerts.icons["enabletexcoords"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][3]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},
								bottom = {
									type = "range", 
									order = 14,
									name = L["Bottom"],
									min = 0, max = 1, step = .01,
									disabled = function(info) return not DB.frames.alerts.icons["enabletexcoords"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][4]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},										
							},
						},
					},
				},
				backdrop = {
					type = "group",
					order = 20,
					name = L["Icon Backdrop"],
					guiInline = false,
					hidden = function(info) return(not DB.frames.alerts.icons.showsettings) end,
					args = {
						enablebackdrop = {
							type = "toggle",
							order = 1,
							name = L["Enable"],
							desc = L["DESCBACKDROP_ENABLE"],
							width = "double",
							get = function(info) return DB.frames.alerts.icons[info[#info] ] end,
							set = function(info, value) DB.frames.alerts.icons[info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
						},
						backdroptexture = {
							type = "select",
							dialogControl = 'LSM30_Background',
							order = 2,
							name = L["Backdrop texture"],
							desc = L["Texture that gets used for the background."],
							values = AceGUIWidgetLSMlists.background,
							disabled = function(info) return not DB.frames.alerts.icons["enablebackdrop"] end,
							get = function(info) return DB.frames.alerts.icons[info[#info] ] end,
							set = function(info, value) DB.frames.alerts.icons[info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
						},
						colorbackdrop = {
							type = "toggle",
							order = 3,
							name = L["Color the backdrop"],
							desc = L["DESCBACKDROPCOLOR_ENABLE"],
							disabled = function(info) return not DB.frames.alerts.icons["enablebackdrop"] end,
							get = function(info) return DB.frames.alerts.icons[info[#info] ] end,
							set = function(info, value) DB.frames.alerts.icons[info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
						},
						backdropcolor = {
							type = "color",
							order = 4,
							name = L["Backdrop color"],
							hasAlpha = true,
							disabled = function(info) return not DB.frames.alerts.icons["enablebackdrop"] end,
							hidden = function(info) return not DB.frames.alerts.icons.colorbackdrop end,
							get = function(info) return unpack(DB.frames.alerts.icons[info[#info] ]) end,
							set = function(info, r, g, b, a) DB.frames.alerts.icons[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupAlertsModule) end,
						},
						spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return not DB.frames.alerts.icons.colorbackdrop end },
						tile = {
							type = "toggle",
							order = 15,
							name = L["Tile the backdrop"],
							desc = L["DESCBACKDROPTILE_ENABLE"],
							disabled = function(info) return not DB.frames.alerts.icons["enablebackdrop"] end,
							get = function(info) return DB.frames.alerts.icons[info[#info] ] end,
							set = function(info, value) DB.frames.alerts.icons[info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
						},
						tilesize = {
							type = "range",
							order = 16,
							name = L["Tile size"],
							desc = L["DESCTILESIZE_ENABLE"],
							min = -100, softMin = -30, softMax = 30, max = 100, step = 1,
							disabled = function(info) return not DB.frames.alerts.icons["enablebackdrop"] end,
							hidden = function(info) return not DB.frames.alerts.icons.tile end,
							get = function(info) return DB.frames.alerts.icons[info[#info] ] end,
							set = function(info, value) DB.frames.alerts.icons[info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
						},
						spacer27 = { order = 27, type = "description", name = " ", desc = "", width = "full"},
						backdropoffsets = {
							type = "group",
							order = 28,
							name = L["Offsets"],
							guiInline = true,
							args = {
								offsetX1 = {
									type = "range",
									order = 1,
									name = L["Top-left X"],
									desc = L["This sets the 'X offset' value."],
									min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
									disabled = function(info) return not DB.frames.alerts.icons["enablebackdrop"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][1]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},
								offsetY1 = {
									type = "range", 
									order = 2,
									name = L["Top-left Y"],
									desc = L["This sets the 'Y offset' value."],
									min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
									disabled = function(info) return not DB.frames.alerts.icons["enablebackdrop"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][2]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},
								spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half" },
								offsetX2 = {
									type = "range", 
									order = 13,
									name = L["Bottom-right X"],
									desc = L["This sets the 'X offset' value."],
									min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
									disabled = function(info) return not DB.frames.alerts.icons["enablebackdrop"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][3]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},
								offsetY2 = {
									type = "range", 
									order = 14,
									name = L["Bottom-right Y"],
									desc = L["This sets the 'Y offset' value."],
									min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
									disabled = function(info) return not DB.frames.alerts.icons["enablebackdrop"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][4]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},										
							},
						},
						spacer32 = { order = 32, type = "description", name = " ", desc = "", width = "full"},
					},
				},
				border = {
					type = "group",
					order = 24,
					name = L["Icon's Border"],
					guiInline = false,
					hidden = function(info) return(not DB.frames.alerts.icons.showsettings) end,
					args = {
						enableborder = {
							type = "toggle",
							order = 1,
							name = L["Enable"],
							desc = L["DESCBORDER_ENABLE"],
							get = function(info) return DB.frames.alerts.icons[info[#info] ] end,
							set = function(info, value) DB.frames.alerts.icons[info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
						},
						bordercolor = {
							type = "color",
							order = 2,
							name = L["Border color"],
							hasAlpha = true,
							disabled = function(info) return not DB.frames.alerts.icons["enableborder"] end,
							get = function(info) return unpack(DB.frames.alerts.icons[info[#info] ]) end,
							set = function(info, r, g, b, a) DB.frames.alerts.icons[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupAlertsModule) end,
						},
						bordertexture = {
							type = "select",
							dialogControl = 'LSM30_Border',
							order = 3,
							name = L["Border texture"],
							desc = L["Texture that gets used for the background."],
							values = AceGUIWidgetLSMlists.border,
							disabled = function(info) return not DB.frames.alerts.icons["enableborder"] end,
							get = function(info) return DB.frames.alerts.icons[info[#info] ] end,
							set = function(info, value) DB.frames.alerts.icons[info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
						},
						edgesize = {
							type = "range",
							order = 4,
							name = L["Edge size"],
							desc = L["DESCEDGESIZE_ENABLE"],
							min = -100, softMin = -16, softMax = 16, max = 100, step = 1,
							disabled = function(info) return not DB.frames.alerts.icons["enableborder"] end,
							get = function(info) return DB.frames.alerts.icons[info[#info] ] end,
							set = function(info, value) DB.frames.alerts.icons[info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
						},
						spacer1 = { order = 7, type = "description", name = " ", desc = "", width = "full"},
						backdropinsets = {
							type = "group",
							order = 10,
							name = L["Insets"],
							guiInline = true,
							args = {
								left = {
									type = "range",
									order = 1,
									name = L["Left"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.alerts.icons["enableborder"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][1]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},
								right = {
									type = "range", 
									order = 2,
									name = L["Right"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.alerts.icons["enableborder"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][2]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},
								spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half" },
								top = {
									type = "range", 
									order = 13,
									name = L["Top"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.alerts.icons["enableborder"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][3]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},
								bottom = {
									type = "range", 
									order = 14,
									name = L["Bottom"],
									min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
									disabled = function(info) return not DB.frames.alerts.icons["enableborder"] end,
									get = function(info) return (DB.frames.alerts.icons[info[#info-1] ][4]) end,
									set = function(info, offset) DB.frames.alerts.icons[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupAlertsModule) end,
								},										
							},
						},
					},
				},
			},
		},
		spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "full" },
		alertgroup = {
			order = 10,
			type = "group",
			name = L["Alerts"],
			guiInline = true,
			args = {
				newalert = {
					order = 10,
					type = "group",
					name = L["Create an Alert"],
					guiInline = true,
					args = {
						newalert = {
							order = 10,
							type = 'input',
							name = L["What do you want to call this alert?"],
							desc = L["Creates an alert."],
							width = "full",
							confirm = function(info, value)
									return( ((strtrim(value) == "") or tContains(alertstableblacklist, value) or (DB.alerts[value] ~= nil) ) and false or format(L["CONFIRM_NEWALERT"], value) ) 
								end,
							get = function(info) return("") end,
							set = function(info, value)
									value = strtrim(value)
									if (value == "") or tContains(alertstableblacklist, value) then
										print(L["JSHB_PRE"]..format(L["Invalid alert name!"], value) )
										return
									elseif DB.alerts[value] ~= nil then
										print(L["JSHB_PRE"]..format(L["You already have an alert with that name!"], value) )							
										return
									end
									local alert = {}
									-- Alert defaults
									alert = JSHB.DeepCopy(JSHB.alertDefaults)					
									-- Frame styling defaults					
									--DB.frames.alerts[value] = JSHB.DeepCopy(JSHB.alertFrameDefaults)
									DB.alerts[value] = alert
									
									--table.sort(DB.alerts, function(a,b) return(strupper(a) < strupper(b) ) end)					
									
									local jshbOptionsTable = LibStub("AceConfigRegistry-3.0"):GetOptionsTable("JSHunterBarOptions", "dialog", "JSHunterBarNullLib-1.0")
									
									-- Re-Inject the new alert
									LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
									
									print(L["JSHB_PRE"]..format(L["New alert '%s' created."], value) )
									JSHunterBarOptions:UpdateAlerts()
								end,
						},
					},
				},
				spacer12 = { order = 12, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return not ( (JSHB.sortedKeysTable == nil) or (#JSHB.sortedKeysTable > 0) ) end },
			},
		},
		spacer24 = { order = 24, type = "description", name = " ", desc = "", width = "full" },
		spacer26 = { order = 26, type = "description", name = " ", desc = "", width = "half" },
		import_alerts_BWD = {
			order = 28,
			type = "execute",
			name = L["Import BWD"],
			desc = L["Imports a default set of alerts for \"Blackwing Descent\""],
			confirm = function(info) return(L["IMPORTALERTSET_CONFIRM"]) end,
			func = function(info)
					JSHB.ImportAlerts("alerts_BWD")
					--table.sort(DB.alerts, function(a,b) return(strupper(a) < strupper(b) ) end)
					LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
					LockDown(JSHB.SetupAlertsModule)
				end,
		},
		import_alerts_BOT = {
			order = 30,
			type = "execute",
			name = L["Import BOT"],
			desc = L["Imports a default set of alerts for \"Bastion of Twilight\""],
			confirm = function(info) return(L["IMPORTALERTSET_CONFIRM"]) end,
			func = function(info)
					JSHB.ImportAlerts("alerts_BOT")
					--table.sort(DB.alerts, function(a,b) return(strupper(a) < strupper(b) ) end)
					LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
					LockDown(JSHB.SetupAlertsModule)
				end,							
		},
	}
	
	local ord = 50
	for key,value in ipairs(JSHB.sortedKeysTable) do
		if (DB.alerts[value] ~= nil) then -- Technically, should never be nil!
			alertstable.alertgroup.args[value] = {
				order = ord,
				type = "group",
				name = (ord-49).." - \""..value.."\"",
				guiInline = true,
				inline = true,
				args = {
					enabled = {
						type = "toggle",
						order = 1,
						name = L["Enable this alert"],
						desc = L["ALERTDESC_ENABLE"],
						width = "double",
						get = function(info) return DB.alerts[info[#info-1] ][info[#info] ] end,
						set = function(info, value) DB.alerts[info[#info-1] ][info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
					},
					showsettings2 = {
						type = "execute",
						order = 2,
						name = L["Expand"],
						func = function(info) CollapseAll(); DB.alerts[info[#info-1] ].showsettings2 = true end,
						hidden = function(info) return(DB.alerts[info[#info-1] ].showsettings2) end,
					},
					hidesettings2 = {
						type = "execute",
						order = 8,
						name = L["Collapse"],
						func = function(info) CollapseAll()	end,
						hidden = function(info) return(not DB.alerts[info[#info-1] ].showsettings2) end,
					},
					enablesound = {
						type = "toggle",
						order = 16,
						name = L["Enable sound"],
						hidden = function(info) return(not DB.alerts[info[#info-1] ].showsettings2) end,
						disabled = function(info) return not DB.alerts[info[#info-1] ].enabled end,
						get = function(info) return DB.alerts[info[#info-1] ][info[#info] ] end,
						set = function(info, value) DB.alerts[info[#info-1] ][info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
					},
					sound = {
						type = "select",
						dialogControl = 'LSM30_Sound',
						order = 18,
						name = L["Alert sound"],
						values = AceGUIWidgetLSMlists.sound,
						hidden = function(info) return(not DB.alerts[info[#info-1] ].showsettings2) end,
						disabled = function(info)
								if (not DB.alerts[info[#info-1] ].enabled) or (not DB.alerts[info[#info-1] ].enablesound) then
									return true
								end
								return false
							end,
						get = function(info) return DB.alerts[info[#info-1] ][info[#info] ] end,
						set = function(info, value) DB.alerts[info[#info-1] ][info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,								
					},
					tooltips = {
						type = "toggle",
						order = 20,
						name = L["Show tooltip"],
						hidden = function(info) return(not DB.alerts[info[#info-1] ].showsettings2) end,
						disabled = function(info) return not DB.alerts[info[#info-1] ].enabled end,
						get = function(info) return DB.alerts[info[#info-1] ][info[#info] ] end,
						set = function(info, value) DB.alerts[info[#info-1] ][info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
					},
					alerttype = {
						order = 24,
						type = "select",
						style = "dropdown",
						name = L["Alert trigger"],
						desc = L["ALERTTRIGGER_DESC"],
						hidden = function(info) return(not DB.alerts[info[#info-1] ].showsettings2) end,
						values = function() return JSHB.alertTypes end,
						get = function(info) return DB.alerts[info[#info-1] ][info[#info] ] end,
						set = function(info, value) DB.alerts[info[#info-1] ][info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
					},
					target = { -- Target to check for the spell.
						order = 26,
						type = "select",
						name = L["Check target"],
						desc = L["CHECKTARGET_DESC"],
						disabled = function(info) return not DB.alerts[info[#info-1] ].enabled end,
						hidden = function(info) 
								if (tContains({ "BUFF", "DEBUFF", "CAST" }, DB.alerts[info[#info-1] ].alerttype) and (DB.alerts[info[#info-1] ].showsettings2) ) then
									return false
								end							
								return true
							end,
						style = "dropdown",
						values = function() return JSHB.targets end,
						get = function(info) return DB.alerts[info[#info-1] ][info[#info] ] end,
						set = function(info, value) DB.alerts[info[#info-1] ][info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
					},
					sparkles = {
						type = "toggle",
						order = 28,
						name = L["Add sparkles"],
						hidden = function(info) return(not DB.alerts[info[#info-1] ].showsettings2) end,
						disabled = function(info) return not DB.alerts[info[#info-1] ].enabled end,
						get = function(info) return DB.alerts[info[#info-1] ][info[#info] ] end,
						set = function(info, value) DB.alerts[info[#info-1] ][info[#info] ] = value;LockDown(JSHB.SetupAlertsModule) end,
					},
					aura = { -- Spell name or ID.
						order =32,
						type = "input",
						name = L["Enter a Spell Name or ID..."],
						desc = L["SPELL_DESC"],
						width = "double",
						disabled = function(info) return not DB.alerts[info[#info-1] ].enabled end,
						hidden = function(info) 
								if (tContains({ "BUFF", "DEBUFF", "CAST" }, DB.alerts[info[#info-1] ].alerttype) and (DB.alerts[info[#info-1] ].showsettings2) ) then
									return false
								end							
								return true
							end,
						validate = function(info, val)
								if GetSpellInfo(tonumber(val) and tonumber(val) or val) then return(true) end
								if tonumber(val) then -- If it's a Spell ID number we CAN verify it.
									print(L["JSHB_PRE"].."|cffff0000"..L["TIMERSPELL_INVALID"].."|r")
									return(false) 
								end
								-- If it's not a Spell ID number we can only verify it if the player HAS that spell in his book.
								if not (GetSpellInfo(val) ) then -- Try to verify, if it does then we don't need to show the unverified warning.
									print(L["JSHB_PRE"].."|cffff0000"..L["TIMERSPELL_UNVERIFIED"].."|r")
								end
								return(true)
							end,
						get = function(info) return(tonumber(DB.alerts[info[#info-1] ][info[#info] ]) and tostring(DB.alerts[info[#info-1] ][info[#info] ]) or DB.alerts[info[#info-1] ][info[#info] ]) end,
						set = function(info, val)
								DB.alerts[info[#info-1] ][info[#info] ] = (tonumber(val) and tonumber(val) or val)
								
								--[[table.sort(DB.alerts, function(a,b)
									local aComp = (tonumber(a) and (select(1, GetSpellInfo(a) )) or a)
									local bComp = (tonumber(b) and (select(1, GetSpellInfo(b) )) or b)
									return(aComp < bComp)
								end)]]
								
								LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
								collectgarbage("collect")
								LockDown(JSHB.SetupAlertsModule)
							end,
					},
					delete = {
						order = 34,
						type = "execute",
						name = L["Delete alert"],
						hidden = function(info) return(not DB.alerts[info[#info-1] ].showsettings2) end,
						confirm = function(info) return(L["DELETEALERT_CONFIRM"]) end,
						func = function(info)
								DB.alerts[info[#info-1] ] = nil
								LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
								LockDown(JSHB.SetupAlertsModule)
							end,							
					},
				},
			}
			ord = ord + 1
		end
	end
	
	-- Show a message if there are no alerts in the set
	if (ord == 50) then
		alertstable.alertgroup.args.noalerts = {
			order = ord,
			type = "group",
			name = " ",
			guiInline = true,
			hidden = function(info) return ( (JSHB.sortedKeysTable == nil) or (#JSHB.sortedKeysTable > 0) ) end,
			args = {
				noalerts = {
					order = 18,
					type = "description",
					name = "|cffff0000"..L["You do not have any alerts set."].."|r",
					fontSize = "large",
				},
			},
		}
	end
	
	return alertstable
end

function JSHunterBarOptions:UpdateAlerts()
	local jshbOptionsTable = LibStub("AceConfigRegistry-3.0"):GetOptionsTable("JSHunterBarOptions", "dialog", "JSHunterBarNullLib-1.0")		
	jshbOptionsTable.args.alerts.args = JSHunterBarOptions:CreateAlerts()
	LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
	collectgarbage("collect")
end

function JSHunterBarOptions:SetupOptions()

	local jshbOptionsTable = {
		type = "group",
		name = "JS' Hunter Bar "..JSHB.myVersion,
		args = {
			main = {
				order = 2,
				type = "group",
				name = L["General Settings"],
				args = {
					intro = {
						order = 1,
						type = "description",
						fontSize = "medium",
						name = L["JSHBMAIN_DESC"].."\n",
					},
					spacer1 = { order = 4, type = "description", name = " ", desc = "", width = "full"},
					genstuff = {
						order = 6,
						type = "group",
						name = L["Miscellaneous"],
						guiInline = true,
						args = {
							masteraudio = {
								type = "toggle",
								order = 6,
								name = L["Master audio"],
								desc = L["MASTERAUDIO_DESC"],
								--width = "full",
								get = function(info) return DB[info[#info] ] end,
								set = function(info, value) DB[info[#info] ] = value end,
							},
						},
					},
					spacer7 = { order = 7, type = "description", name = " ", desc = "", width = "full"},
					cooldownstuff = {
						order = 8,
						type = "group",
						name = L["Cooldown Text"],
						guiInline = true,
						args = {
							minfortenths = {
								type = "range", 
								order = 1,
								name = L["Timer decimals"],
								desc = L["MINFORTENTHS_DESC"],
								min = 1, max = 9, step = 1,
								get = function(info) return (DB[info[#info] ]) end,
								set = function(info, val) DB[info[#info] ] = (val) end,
							},
							spacer2 = { order = 2, type = "description", name = " ", desc = "", width = "half"},
							spacer3 = { order = 3, type = "description", name = " ", desc = "", width = "half"},
							showsettings = {
								type = "execute",
								order = 4,
								name = L["Expand"],
								hidden = function(info) return(DB.frames.cooldowns.showsettings) end,
								func = function(info) CollapseAll(); DB.frames.cooldowns.showsettings = true end,
							},
							hidesettings = {
								type = "execute",
								order = 5,
								name = L["Collapse"],
								func = function(info) CollapseAll()	end,
								hidden = function(info) return(not DB.frames.cooldowns.showsettings) end,
							},
							spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return(not DB.frames.cooldowns.showsettings) end },
							font = {
								type = "group",
								order = 8,
								name = L["Cooldown font"],
								guiInline = false,
								hidden = function(info) return(not DB.frames.cooldowns.showsettings) end,
								args = {
									font = {
										type = "select", 
										dialogControl = 'LSM30_Font',
										order = 1,
										name = L["Font face"],
										desc = L["This is the font used for cooldown or duration timers."],
										values = AceGUIWidgetLSMlists.font,
										get = function(info) return DB.frames.cooldowns[info[#info-1] ][1] end,
										set = function(info, font) DB.frames.cooldowns[info[#info-1] ][1] = font end,
									},
									size = {
										type = "range", 
										order = 2,
										name = L["Font size"],
										min = 6, max = 40, step = 1,
										get = function(info) return (DB.frames.cooldowns[info[#info-1] ][2]) end,
										set = function(info, size) DB.frames.cooldowns[info[#info-1] ][2] = (size) end,
									},
									flags = {
										type = "multiselect", 
										order = 3,
										name = L["Font flags"],
										values = fontFlagTable,
										get = function(info, key) return(tContains({strsplit(",", DB.frames.cooldowns[info[#info-1] ][3])}, key) and true or false) end,
										set = function(info, keyname, state) SetupFontFlags(DB.frames.cooldowns[info[#info-1] ], keyname, state) end,
									},
									fontshadowoffset = {
										type = "group",
										order = 12,
										name = L["Font shadow"],
										guiInline = false,
										hidden = function(info) return(not DB.frames.cooldowns.showsettings) end,
										args = {
											enableshadow = {
												type = "toggle",
												order = 2,
												name = L["Enable"],
												desc = L["ENABLESHADOW_DESC"],
												width = "double",
												get = function(info) return DB.frames.cooldowns[info[#info] ] end,
												set = function(info, value) DB.frames.cooldowns[info[#info] ] = value;LockDown(JSHB.SetupTimersModule) end,
											},
											shadowcolor = {
												type = "color",
												order = 4,
												name = L["Font shadow color"],
												desc = L["Color used for the cooldown's font shadow"],
												hasAlpha = true,
												disabled = function(info) return not DB.frames.cooldowns.enableshadow end,
											},
											offsetX = {
												type = "input", 
												order = 6,
												name = L["X offset"],
												desc = L["This sets the 'X offset' value."],
												width = "half",
												pattern = "%d",
												usage = L["Only valid numeric offsets are allowed."],
												disabled = function(info) return not DB.frames.cooldowns.enableshadow end,
												get = function(info) return tostring(DB.frames.cooldowns[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.cooldowns[info[#info-1] ][1] = tonumber(offset) end,
											},
											offsetY = {
												type = "input", 
												order = 8,
												name = L["Y offset"],
												desc = L["This sets the 'Y offset' value."],
												width = "half",
												pattern = "%d",
												usage = L["Only valid numeric offsets are allowed."],
												disabled = function(info) return not DB.frames.cooldowns.enableshadow end,
												get = function(info) return tostring(DB.frames.cooldowns[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.cooldowns[info[#info-1] ][2] = tonumber(offset) end,
											},
										},
									},
									colors = {
										type = "group",
										order = 16,
										name = L["Colors"],
										guiInline = false,
										hidden = function(info) return(not DB.frames.cooldowns.showsettings) end,
										get = function(info) return unpack(DB.frames.cooldowns[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.cooldowns[info[#info] ] = {r, g, b, a} end,
										args = {
											dayscolor = {
												type = "color",
												order = 1,
												name = L["Days"],
												desc = L["Color when a cooldown is at least a day"],
												hasAlpha = false,
											},
											hourscolor = {
												type = "color",
												order = 2,
												name = L["Hours"],
												desc = L["Color when a cooldown is at least an hour"],
												hasAlpha = false,
											},
											minutescolor = {
												type = "color",
												order = 3,
												name = L["Minutes"],
												desc = L["Color when a cooldown is at least a minute"],
												hasAlpha = false,
											},
											secondscolor = {
												type = "color",
												order = 4,
												name = L["Seconds"],
												desc = L["Color when a cooldown is only seconds"],
												hasAlpha = false,
											},
											expiringcolor = {
												type = "color",
												order = 5,
												name = L["Expiring"],
												desc = L["Color when a cooldown is about to expire"],
												hasAlpha = false,
											},
										},
									},
								},
							},
						},
					},
					spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "full"},
					crowdcontrolstuff = {
						order = 12,
						type = "group",
						name = L["Crowd Control"],
						guiInline = true,
						args = {
							enabled = {
								type = "toggle",
								order = 8,
								name = L["Track crowd control"],
								desc = L["CCDESC_ENABLE"],
								width = "double",
								get = function(info) return DB.crowdcontrol[info[#info] ] end,
								set = function(info, value) CollapseAll(); DB.crowdcontrol[info[#info] ] = value;LockDown(JSHB.SetupCrowdControlModule) end,
							},
							iconsize = {
								type = "range", 
								order = 14,
								name = L["Icon size"],
								min = 10, max = 100, step = 1,
								hidden = function(info) return (not DB.crowdcontrol.enabled) end,
								get = function(info) return (DB.frames.crowdcontrol[info[#info] ]) end,
								set = function(info, size) DB.frames.crowdcontrol[info[#info] ] = (size);LockDown(JSHB.SetupCrowdControlModule) end,
							},
							spacer16 = { order = 16, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return DB.crowdcontrol.enabled end },
							spacer17 = { order = 17, type = "description", name = " ", desc = "", width = "double", hidden = function(info) return (not DB.crowdcontrol.enabled) end },
							showsettings = {
								type = "execute",
								order = 18,
								name = L["Expand"],
								hidden = function(info) return(DB.crowdcontrol.showsettings or (not DB.crowdcontrol.enabled) ) end,
								func = function(info) CollapseAll(); DB.crowdcontrol.showsettings = true end,
							},
							hidesettings = {
								type = "execute",
								order = 20,
								name = L["Collapse"],
								func = function(info) CollapseAll()	end,
								hidden = function(info) return(not DB.crowdcontrol.showsettings) end,
							},
							--spacer22 = { order = 22, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return( (not DB.crowdcontrol.showsettings) or (not DB.crowdcontrol.enabled) ) end },
							texcoords = {
								type = "group",
								order = 28,
								name = L["Texture coords"],
								guiInline = false,
								hidden = function(info) return(not DB.crowdcontrol.showsettings) end,
								args = {						
									enabletexcoords = {
										type = "toggle",
										order = 5,
										name = L["Enable TexCoords"],
										desc = L["DESCTEXCOORDS_ENABLE"],
										get = function(info) return DB.frames.crowdcontrol[info[#info] ] end,
										set = function(info, value) DB.frames.crowdcontrol[info[#info] ] = value;LockDown(JSHB.SetupCrowdControlModule) end,
									},
									texcoords = {
										type = "group",
										order = 6,
										name = L["Texture coords"],
										guiInline = true,
										args = {
											left = {
												type = "range",
												order = 1,
												name = L["Left"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.crowdcontrol["enabletexcoords"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},
											right = {
												type = "range", 
												order = 2,
												name = L["Right"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.crowdcontrol["enabletexcoords"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},
											spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half" },
											top = {
												type = "range", 
												order = 12,
												name = L["Top"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.crowdcontrol["enabletexcoords"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},
											bottom = {
												type = "range", 
												order = 14,
												name = L["Bottom"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.crowdcontrol["enabletexcoords"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},										
										},
									},
								},
							},
							backdrop = {
								type = "group",
								order = 30,
								name = L["Icon Backdrop"],
								guiInline = false,
								hidden = function(info) return(not DB.crowdcontrol.showsettings) end,
								args = {
									enablebackdrop = {
										type = "toggle",
										order = 1,
										name = L["Enable"],
										desc = L["DESCBACKDROP_ENABLE"],
										width = "double",
										get = function(info) return DB.frames.crowdcontrol[info[#info] ] end,
										set = function(info, value) DB.frames.crowdcontrol[info[#info] ] = value;LockDown(JSHB.SetupCrowdControlModule) end,
									},
									backdroptexture = {
										type = "select",
										dialogControl = 'LSM30_Background',
										order = 2,
										name = L["Backdrop texture"],
										desc = L["Texture that gets used for the background."],
										values = AceGUIWidgetLSMlists.background,
										disabled = function(info) return not DB.frames.crowdcontrol["enablebackdrop"] end,
										get = function(info) return DB.frames.crowdcontrol[info[#info] ] end,
										set = function(info, value) DB.frames.crowdcontrol[info[#info] ] = value;LockDown(JSHB.SetupCrowdControlModule) end,
									},
									colorbackdrop = {
										type = "toggle",
										order = 3,
										name = L["Color the backdrop"],
										desc = L["DESCBACKDROPCOLOR_ENABLE"],
										disabled = function(info) return not DB.frames.crowdcontrol["enablebackdrop"] end,
										get = function(info) return DB.frames.crowdcontrol[info[#info] ] end,
										set = function(info, value) DB.frames.crowdcontrol[info[#info] ] = value;LockDown(JSHB.SetupCrowdControlModule) end,
									},
									backdropcolor = {
										type = "color",
										order = 4,
										name = L["Backdrop color"],
										hasAlpha = true,
										disabled = function(info) return not DB.frames.crowdcontrol["enablebackdrop"] end,
										hidden = function(info) return not DB.frames.crowdcontrol.colorbackdrop end,
										get = function(info) return unpack(DB.frames.crowdcontrol[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.crowdcontrol[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupCrowdControlModule) end,
									},
									spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return not DB.frames.crowdcontrol.colorbackdrop end },
									tile = {
										type = "toggle",
										order = 15,
										name = L["Tile the backdrop"],
										desc = L["DESCBACKDROPTILE_ENABLE"],
										disabled = function(info) return not DB.frames.crowdcontrol["enablebackdrop"] end,
										get = function(info) return DB.frames.crowdcontrol[info[#info] ] end,
										set = function(info, value) DB.frames.crowdcontrol[info[#info] ] = value;LockDown(JSHB.SetupCrowdControlModule) end,
									},
									tilesize = {
										type = "range",
										order = 16,
										name = L["Tile size"],
										desc = L["DESCTILESIZE_ENABLE"],
										min = -100, softMin = -30, softMax = 30, max = 100, step = 1,
										disabled = function(info) return not DB.frames.crowdcontrol["enablebackdrop"] end,
										hidden = function(info) return not DB.frames.crowdcontrol.tile end,
										get = function(info) return DB.frames.crowdcontrol[info[#info] ] end,
										set = function(info, value) DB.frames.crowdcontrol[info[#info] ] = value;LockDown(JSHB.SetupCrowdControlModule) end,
									},
									spacer27 = { order = 27, type = "description", name = " ", desc = "", width = "full"},
									backdropoffsets = {
										type = "group",
										order = 28,
										name = L["Offsets"],
										guiInline = true,
										args = {
											offsetX1 = {
												type = "range",
												order = 1,
												name = L["Top-left X"],
												desc = L["This sets the 'X offset' value."],
												min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
												disabled = function(info) return not DB.frames.crowdcontrol["enablebackdrop"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},
											offsetY1 = {
												type = "range", 
												order = 2,
												name = L["Top-left Y"],
												desc = L["This sets the 'Y offset' value."],
												min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
												disabled = function(info) return not DB.frames.crowdcontrol["enablebackdrop"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},
											spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half" },
											offsetX2 = {
												type = "range", 
												order = 13,
												name = L["Bottom-right X"],
												desc = L["This sets the 'X offset' value."],
												min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
												disabled = function(info) return not DB.frames.crowdcontrol["enablebackdrop"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},
											offsetY2 = {
												type = "range", 
												order = 14,
												name = L["Bottom-right Y"],
												desc = L["This sets the 'Y offset' value."],
												min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
												disabled = function(info) return not DB.frames.crowdcontrol["enablebackdrop"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},										
										},
									},
									spacer32 = { order = 32, type = "description", name = " ", desc = "", width = "full"},
								},
							},
							border = {
								type = "group",
								order = 34,
								name = L["Icon's Border"],
								guiInline = false,
								hidden = function(info) return(not DB.crowdcontrol.showsettings) end,
								args = {
									enableborder = {
										type = "toggle",
										order = 1,
										name = L["Enable"],
										desc = L["DESCBORDER_ENABLE"],
										get = function(info) return DB.frames.crowdcontrol[info[#info] ] end,
										set = function(info, value) DB.frames.crowdcontrol[info[#info] ] = value;LockDown(JSHB.SetupCrowdControlModule) end,
									},
									bordercolor = {
										type = "color",
										order = 2,
										name = L["Border color"],
										hasAlpha = true,
										disabled = function(info) return not DB.frames.crowdcontrol["enableborder"] end,
										get = function(info) return unpack(DB.frames.crowdcontrol[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.crowdcontrol[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupCrowdControlModule) end,
									},
									bordertexture = {
										type = "select",
										dialogControl = 'LSM30_Border',
										order = 3,
										name = L["Border texture"],
										desc = L["Texture that gets used for the background."],
										values = AceGUIWidgetLSMlists.border,
										disabled = function(info) return not DB.frames.crowdcontrol["enableborder"] end,
										get = function(info) return DB.frames.crowdcontrol[info[#info] ] end,
										set = function(info, value) DB.frames.crowdcontrol[info[#info] ] = value;LockDown(JSHB.SetupCrowdControlModule) end,
									},
									edgesize = {
										type = "range",
										order = 4,
										name = L["Edge size"],
										desc = L["DESCEDGESIZE_ENABLE"],
										min = -100, softMin = -16, softMax = 16, max = 100, step = 1,
										disabled = function(info) return not DB.frames.crowdcontrol["enableborder"] end,
										get = function(info) return DB.frames.crowdcontrol[info[#info] ] end,
										set = function(info, value) DB.frames.crowdcontrol[info[#info] ] = value;LockDown(JSHB.SetupCrowdControlModule) end,
									},
									spacer1 = { order = 7, type = "description", name = " ", desc = "", width = "full"},
									backdropinsets = {
										type = "group",
										order = 10,
										name = L["Insets"],
										guiInline = true,
										args = {
											left = {
												type = "range",
												order = 1,
												name = L["Left"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.crowdcontrol["enableborder"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},
											right = {
												type = "range", 
												order = 2,
												name = L["Right"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.crowdcontrol["enableborder"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},
											spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half" },
											top = {
												type = "range", 
												order = 13,
												name = L["Top"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.crowdcontrol["enableborder"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},
											bottom = {
												type = "range", 
												order = 14,
												name = L["Bottom"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.crowdcontrol["enableborder"] end,
												get = function(info) return (DB.frames.crowdcontrol[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.crowdcontrol[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupCrowdControlModule) end,
											},										
										},
									},
								},
							},
						},
					},
					spacer14 = { order = 14, type = "description", name = " ", desc = "", width = "full"},
					indicators = {
						order = 20,
						type = "group",
						name = L["Indicators"],
						guiInline = true,
						--childGroups = "tree",
						args = {
							enabled = {
								type = "toggle",
								order = 4,
								name = L["Enable indicators"],
								desc = L["INDICATORS_ENABLE"],
								width = "full",
								get = function(info) return DB.indicators[info[#info] ] end,
								set = function(info, value) CollapseAll(); DB.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
							},
							spacer1 = { order = 6, type = "description", name = " ", desc = "", width = "full"},
							hm = {
								order = 10,
								type = "group",
								name = L["Hunter's Mark Indicator"],
								guiInline = true,
								args = {
									huntersmark_enable = {
										type = "toggle",
										order = 2,
										name = L["Enable"],
										desc = L["HM_INDICATOR_ENABLE"],
										width = "full",
										disabled = function(info) return (not DB.indicators.enabled) end,
										get = function(info) return DB.indicators[info[#info] ] end,
										set = function(info, value) DB.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
									},
									huntersmark_mfd = {
										type = "toggle",
										order = 2,
										name = L["Ignore Marked for Death"],
										desc = L["HM_MFD_INDICATOR_ENABLE"],
										width = "full",
										disabled = function(info) if (not DB.indicators.enabled) or (not DB.indicators.huntersmark_enable) then	return true	else return false end end,
										get = function(info) return DB.indicators[info[#info] ] end,
										set = function(info, value) DB.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
									},
								},
							},
							--spacer2 = { order = 12, type = "description", name = " ", desc = "", width = "full"},
							aspect = {
								order = 14,
								type = "group",
								name = L["Aspect Indicator"],
								guiInline = true,
								args = {
									aspect_enable = {
										type = "toggle",
										order = 2,
										name = L["Enable"],
										desc = L["ASPECT_INDICATOR_ENABLE"],
										width = "full",
										disabled = function(info) return (not DB.indicators.enabled) end,
										get = function(info) return DB.indicators[info[#info] ] end,
										set = function(info, value) DB.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
									},
									aspect_onlymissing = {
										type = "toggle",
										order = 2,
										name = L["Only show for no aspect"],
										desc = L["ASPECT_ONLYMISSING_DESC"],
										width = "full",
										disabled = function(info) if ( (DB.indicators.enabled) and (DB.indicators.aspect_enable) ) then return(false) else return(true) end end,
										get = function(info) return DB.indicators[info[#info] ] end,
										set = function(info, value) DB.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
									},
									aspect_onlycombat = {
										type = "toggle",
										order = 2,
										name = L["Only show in combat"],
										desc = L["ASPECT_ONLYCOMBAT_DESC"],
										width = "full",
										disabled = function(info) if ( (DB.indicators.enabled) and (DB.indicators.aspect_enable) ) then return(false) else return(true) end end,
										get = function(info) return DB.indicators[info[#info] ] end,
										set = function(info, value) DB.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
									},
								},
							},
							--spacer16 = { order = 16, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return DB.crowdcontrol.enabled end },
							spacer17 = { order = 17, type = "description", name = " ", desc = "", width = "double", hidden = function(info) return (not DB.indicators.enabled) end },
							showsettings = {
								type = "execute",
								order = 18,
								name = L["Expand"],
								hidden = function(info) return(DB.indicators.showsettings or (not DB.indicators.enabled) ) end,
								func = function(info) CollapseAll(); DB.indicators.showsettings = true end,
							},
							hidesettings = {
								type = "execute",
								order = 20,
								name = L["Collapse"],
								func = function(info) CollapseAll()	end,
								hidden = function(info) return(not DB.indicators.showsettings) end,
							},
							sizes = {
								type = "group",
								order = 22,
								name = L["Sizes"],
								guiInline = false,
								hidden = function(info) return(not DB.indicators.showsettings) end,
								args = {
									huntersmark_iconsize = {
										type = "range", 
										order = 2,
										name = L["Hunter's Mark size"],
										min = 10, max = 100, step = 1,
										get = function(info) return (DB.frames.indicators[info[#info] ]) end,
										set = function(info, size) DB.frames.indicators[info[#info] ] = (size);LockDown(JSHB.SetupIndicatorsModule) end,
									},
									spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "half" },
									aspect_iconsize = {
										type = "range", 
										order = 12,
										name = L["Aspect size"],
										min = 10, max = 100, step = 1,
										get = function(info) return (DB.frames.indicators[info[#info] ]) end,
										set = function(info, size) DB.frames.indicators[info[#info] ] = (size);LockDown(JSHB.SetupIndicatorsModule) end,
									},
								},
							},
							spacer24 = { order = 24, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return(not DB.indicators.showsettings) end },
							hmextras = {
								type = "group",
								order = 26,
								name = L["Hunter's Mark Indicator"],
								guiInline = true,
								hidden = function(info) return(not DB.indicators.showsettings) end,
								args = {
									huntersmark_texcoords = {
										type = "group",
										order = 28,
										name = L["Texture coords"],
										guiInline = true,
										args = {						
											huntersmark_enabletexcoords = {
												type = "toggle",
												order = 5,
												name = L["Enable TexCoords"],
												desc = L["DESCTEXCOORDS_ENABLE"],
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											huntersmark_texcoords = {
												type = "group",
												order = 6,
												name = L["Texture coords"],
												guiInline = true,
												args = {
													left = {
														type = "range",
														order = 1,
														name = L["Left"],
														min = 0, max = 1, step = .01,
														disabled = function(info) return not DB.frames.indicators.huntersmark_enabletexcoords end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][1]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													right = {
														type = "range", 
														order = 2,
														name = L["Right"],
														min = 0, max = 1, step = .01,
														disabled = function(info) return not DB.frames.indicators.huntersmark_enabletexcoords end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][2]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half" },
													top = {
														type = "range", 
														order = 13,
														name = L["Top"],
														min = 0, max = 1, step = .01,
														disabled = function(info) return not DB.frames.indicators.huntersmark_enabletexcoords end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][3]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													bottom = {
														type = "range", 
														order = 14,
														name = L["Bottom"],
														min = 0, max = 1, step = .01,
														disabled = function(info) return not DB.frames.indicators.huntersmark_enabletexcoords end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][4]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},										
												},
											},
										},
									},
									huntersmark_backdrop = {
										type = "group",
										order = 30,
										name = L["Backdrop"],
										guiInline = true,
										args = {
											huntersmark_enablebackdrop = {
												type = "toggle",
												order = 1,
												name = L["Enable"],
												desc = L["DESCBACKDROP_ENABLE"],
												width = "double",
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											huntersmark_backdroptexture = {
												type = "select",
												dialogControl = 'LSM30_Background',
												order = 2,
												name = L["Backdrop texture"],
												desc = L["Texture that gets used for the background."],
												values = AceGUIWidgetLSMlists.background,
												disabled = function(info) return not DB.frames.indicators["huntersmark_enablebackdrop"] end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											huntersmark_colorbackdrop = {
												type = "toggle",
												order = 3,
												name = L["Color the backdrop"],
												desc = L["DESCBACKDROPCOLOR_ENABLE"],
												disabled = function(info) return not DB.frames.indicators["huntersmark_enablebackdrop"] end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											huntersmark_backdropcolor = {
												type = "color",
												order = 4,
												name = L["Backdrop color"],
												hasAlpha = true,
												disabled = function(info) return not DB.frames.indicators["huntersmark_enablebackdrop"] end,
												hidden = function(info) return not DB.frames.indicators.huntersmark_colorbackdrop end,
												get = function(info) return unpack(DB.frames.indicators[info[#info] ]) end,
												set = function(info, r, g, b, a) DB.frames.indicators[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupIndicatorsModule) end,
											},
											spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return not DB.frames.indicators.huntersmark_colorbackdrop end },
											huntersmark_tile = {
												type = "toggle",
												order = 15,
												name = L["Tile the backdrop"],
												desc = L["DESCBACKDROPTILE_ENABLE"],
												disabled = function(info) return not DB.frames.indicators["huntersmark_enablebackdrop"] end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											huntersmark_tilesize = {
												type = "range",
												order = 16,
												name = L["Tile size"],
												desc = L["DESCTILESIZE_ENABLE"],
												min = -100, softMin = -30, softMax = 30, max = 100, step = 1,
												disabled = function(info) return not DB.frames.indicators["huntersmark_enablebackdrop"] end,
												hidden = function(info) return not DB.frames.indicators.huntersmark_tile end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											spacer1 = { order = 17, type = "description", name = " ", desc = "", width = "full"},
											huntersmark_backdropoffsets = {
												type = "group",
												order = 18,
												name = L["Offsets"],
												guiInline = true,
												args = {
													offsetX1 = {
														type = "range",
														order = 2,
														name = L["Top-left X"],
														desc = L["This sets the 'X offset' value."],
														min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["huntersmark_enablebackdrop"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][1]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													offsetY1 = {
														type = "range", 
														order = 6,
														name = L["Top-left Y"],
														desc = L["This sets the 'Y offset' value."],
														min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["huntersmark_enablebackdrop"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][2]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half"},
													offsetX2 = {
														type = "range", 
														order = 13,
														name = L["Bottom-right X"],
														desc = L["This sets the 'X offset' value."],
														min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["huntersmark_enablebackdrop"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][3]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													offsetY2 = {
														type = "range", 
														order = 24,
														name = L["Bottom-right Y"],
														desc = L["This sets the 'Y offset' value."],
														min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["huntersmark_enablebackdrop"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][4]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},										
												},
											},
										},
									},
									huntersmark_border = {
										type = "group",
										order = 32,
										name = L["Border"],
										guiInline = true,
										args = {
											huntersmark_enableborder = {
												type = "toggle",
												order = 1,
												name = L["Enable"],
												desc = L["DESCBORDER_ENABLE"],
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											huntersmark_bordercolor = {
												type = "color",
												order = 2,
												name = L["Border color"],
												hasAlpha = true,
												disabled = function(info) return not DB.frames.indicators["huntersmark_enableborder"] end,
												get = function(info) return unpack(DB.frames.indicators[info[#info] ]) end,
												set = function(info, r, g, b, a) DB.frames.indicators[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupIndicatorsModule) end,
											},
											huntersmark_bordertexture = {
												type = "select",
												dialogControl = 'LSM30_Border',
												order = 3,
												name = L["Border texture"],
												desc = L["Texture that gets used for the background."],
												values = AceGUIWidgetLSMlists.border,
												disabled = function(info) return not DB.frames.indicators["huntersmark_enableborder"] end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											huntersmark_edgesize = {
												type = "range",
												order = 4,
												name = L["Edge size"],
												desc = L["DESCEDGESIZE_ENABLE"],
												min = -100, softMin = -16, softMax = 16, max = 100, step = 1,
												disabled = function(info) return not DB.frames.indicators["huntersmark_enableborder"] end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											spacer1 = { order = 7, type = "description", name = " ", desc = "", width = "full"},
											huntersmark_backdropinsets = {
												type = "group",
												order = 10,
												name = L["Insets"],
												guiInline = true,
												args = {
													left = {
														type = "range",
														order = 1,
														name = L["Left"],
														min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["huntersmark_enableborder"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][1]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													right = {
														type = "range", 
														order = 2,
														name = L["Right"],
														min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["huntersmark_enableborder"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][2]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half" },
													top = {
														type = "range", 
														order = 23,
														name = L["Top"],
														min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["huntersmark_enableborder"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][3]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													bottom = {
														type = "range", 
														order = 24,
														name = L["Bottom"],
														min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["huntersmark_enableborder"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][4]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},										
												},
											},
										},
									},
								},
							},
							spacer28 = { order = 28, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return(not DB.indicators.showsettings) end },
							aspectextras = {
								type = "group",
								order = 36,
								name = L["Aspect Indicator"],
								guiInline = true,
								hidden = function(info) return(not DB.indicators.showsettings) end,
								args = {
									aspect_texcoords = {
										type = "group",
										order = 28,
										name = L["Texture coords"],
										guiInline = true,
										args = {						
											aspect_enabletexcoords = {
												type = "toggle",
												order = 5,
												name = L["Enable TexCoords"],
												desc = L["DESCTEXCOORDS_ENABLE"],
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											aspect_texcoords = {
												type = "group",
												order = 6,
												name = L["Texture coords"],
												guiInline = true,
												args = {
													left = {
														type = "range",
														order = 1,
														name = L["Left"],
														min = 0, max = 1, step = .01,
														disabled = function(info) return not DB.frames.indicators.aspect_enabletexcoords end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][1]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													right = {
														type = "range", 
														order = 2,
														name = L["Right"],
														min = 0, max = 1, step = .01,
														disabled = function(info) return not DB.frames.indicators.aspect_enabletexcoords end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][2]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half" },
													top = {
														type = "range", 
														order = 13,
														name = L["Top"],
														min = 0, max = 1, step = .01,
														disabled = function(info) return not DB.frames.indicators.aspect_enabletexcoords end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][3]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													bottom = {
														type = "range", 
														order = 14,
														name = L["Bottom"],
														min = 0, max = 1, step = .01,
														disabled = function(info) return not DB.frames.indicators.aspect_enabletexcoords end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][4]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},										
												},
											},
										},
									},
									aspect_backdrop = {
										type = "group",
										order = 30,
										name = L["Backdrop"],
										guiInline = true,
										args = {
											aspect_enablebackdrop = {
												type = "toggle",
												order = 1,
												name = L["Enable"],
												desc = L["DESCBACKDROP_ENABLE"],
												width = "double",
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											aspect_backdroptexture = {
												type = "select",
												dialogControl = 'LSM30_Background',
												order = 2,
												name = L["Backdrop texture"],
												desc = L["Texture that gets used for the background."],
												values = AceGUIWidgetLSMlists.background,
												disabled = function(info) return not DB.frames.indicators["aspect_enablebackdrop"] end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											aspect_colorbackdrop = {
												type = "toggle",
												order = 3,
												name = L["Color the backdrop"],
												desc = L["DESCBACKDROPCOLOR_ENABLE"],
												disabled = function(info) return not DB.frames.indicators["aspect_enablebackdrop"] end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											aspect_backdropcolor = {
												type = "color",
												order = 4,
												name = L["Backdrop color"],
												hasAlpha = true,
												disabled = function(info) return not DB.frames.indicators["aspect_enablebackdrop"] end,
												hidden = function(info) return not DB.frames.indicators.aspect_colorbackdrop end,
												get = function(info) return unpack(DB.frames.indicators[info[#info] ]) end,
												set = function(info, r, g, b, a) DB.frames.indicators[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupIndicatorsModule) end,
											},
											spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return not DB.frames.indicators.aspect_colorbackdrop end },
											aspect_tile = {
												type = "toggle",
												order = 15,
												name = L["Tile the backdrop"],
												desc = L["DESCBACKDROPTILE_ENABLE"],
												disabled = function(info) return not DB.frames.indicators["aspect_enablebackdrop"] end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											aspect_tilesize = {
												type = "range",
												order = 16,
												name = L["Tile size"],
												desc = L["DESCTILESIZE_ENABLE"],
												min = -100, softMin = -30, softMax = 30, max = 100, step = 1,
												disabled = function(info) return not DB.frames.indicators["aspect_enablebackdrop"] end,
												hidden = function(info) return not DB.frames.indicators.aspect_tile end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											spacer1 = { order = 17, type = "description", name = " ", desc = "", width = "full"},
											aspect_backdropoffsets = {
												type = "group",
												order = 18,
												name = L["Offsets"],
												guiInline = true,
												args = {
													offsetX1 = {
														type = "range",
														order = 2,
														name = L["Top-left X"],
														desc = L["This sets the 'X offset' value."],
														min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["aspect_enablebackdrop"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][1]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													offsetY1 = {
														type = "range", 
														order = 6,
														name = L["Top-left Y"],
														desc = L["This sets the 'Y offset' value."],
														min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["aspect_enablebackdrop"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][2]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half"},
													offsetX2 = {
														type = "range", 
														order = 13,
														name = L["Bottom-right X"],
														desc = L["This sets the 'X offset' value."],
														min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["aspect_enablebackdrop"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][3]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													offsetY2 = {
														type = "range", 
														order = 24,
														name = L["Bottom-right Y"],
														desc = L["This sets the 'Y offset' value."],
														min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["aspect_enablebackdrop"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][4]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},										
												},
											},
										},
									},
									aspect_border = {
										type = "group",
										order = 32,
										name = L["Border"],
										guiInline = true,
										args = {
											aspect_enableborder = {
												type = "toggle",
												order = 1,
												name = L["Enable"],
												desc = L["DESCBORDER_ENABLE"],
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											aspect_bordercolor = {
												type = "color",
												order = 2,
												name = L["Border color"],
												hasAlpha = true,
												disabled = function(info) return not DB.frames.indicators["aspect_enableborder"] end,
												get = function(info) return unpack(DB.frames.indicators[info[#info] ]) end,
												set = function(info, r, g, b, a) DB.frames.indicators[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupIndicatorsModule) end,
											},
											aspect_bordertexture = {
												type = "select",
												dialogControl = 'LSM30_Border',
												order = 3,
												name = L["Border texture"],
												desc = L["Texture that gets used for the background."],
												values = AceGUIWidgetLSMlists.border,
												disabled = function(info) return not DB.frames.indicators["aspect_enableborder"] end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											aspect_edgesize = {
												type = "range",
												order = 4,
												name = L["Edge size"],
												desc = L["DESCEDGESIZE_ENABLE"],
												min = -100, softMin = -16, softMax = 16, max = 100, step = 1,
												disabled = function(info) return not DB.frames.indicators["aspect_enableborder"] end,
												get = function(info) return DB.frames.indicators[info[#info] ] end,
												set = function(info, value) DB.frames.indicators[info[#info] ] = value;LockDown(JSHB.SetupIndicatorsModule) end,
											},
											spacer1 = { order = 7, type = "description", name = " ", desc = "", width = "full"},
											aspect_backdropinsets = {
												type = "group",
												order = 10,
												name = L["Insets"],
												guiInline = true,
												args = {
													left = {
														type = "range",
														order = 1,
														name = L["Left"],
														min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["aspect_enableborder"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][1]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													right = {
														type = "range", 
														order = 2,
														name = L["Right"],
														min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["aspect_enableborder"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][2]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													spacer10 = { order = 10, type = "description", name = " ", desc = "", width = "half" },
													top = {
														type = "range", 
														order = 23,
														name = L["Top"],
														min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["aspect_enableborder"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][3]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},
													bottom = {
														type = "range", 
														order = 24,
														name = L["Bottom"],
														min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
														disabled = function(info) return not DB.frames.indicators["aspect_enableborder"] end,
														get = function(info) return (DB.frames.indicators[info[#info-1] ][4]) end,
														set = function(info, offset) DB.frames.indicators[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupIndicatorsModule) end,
													},										
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
			energybar = {
				order = 6,
				type = "group",
				name = L["Focus Bar"],
				guiInline = true,
				childGroups = "tree",
				args = {
					intro = {
						order = 1,
						type = "description",
						fontSize = "medium",
						name = L["FOCUSBAR_DESC"].."\n",
					},
					spacer2 = { order = 2, type = "description", name = " ", desc = "", width = "full"},
					genstuff = {
						order = 8,
						type = "group",
						name = L["General Bar Settings"],
						guiInline = true,
						args = {
							enabled = {
								type = "toggle",
								order = 2,
								name = L["Enable Focus Bar"],
								desc = L["FOCUSBARDESC_ENABLE"],
								width = "double",
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) CollapseAll(); DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							smoothbar = {
								type = "toggle",
								order = 6,
								name = L["Bar smoothing"],
								desc = L["FOCUSBARSMOOTHBARDESC_ENABLE"],
								--width = "half",
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							energynumber = {
								type = "toggle",
								order = 8,
								name = L["Current energy number"],
								desc = L["FOCUSBARNUMBERDESC_ENABLE"],
								width = "double",
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							enableprediction = {
								type = "toggle",
								order = 9,
								name = L["Focus prediction"],
								desc = L["FOCUSBARPREDICTIONDESC_ENABLE"],
								--width = "double",
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							targethealth = {
								type = "toggle",
								order = 10,
								name = L["Target health percentage"],
								desc = L["FOCUSBARHEALTHDESC_ENABLE"],
								width = "full",
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							shottimer = {
								type = "toggle",
								order = 11,
								name = L["Numeric autoshot timer"],
								desc = L["FOCUSBARAUTOSHOTDESC_ENABLE"],
								width = "full",
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							shotbar = {
								type = "toggle",
								order = 12,
								name = L["Autoshot bar"],
								desc = L["FOCUSBARAUTOSHOTBARDESC_ENABLE"],
								--width = "double",
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							smoothbarshotbar = {
								type = "toggle",
								order = 14,
								name = L["Bar smoothing"],
								desc = L["FOCUSBARSMOOTHBARDESC_ENABLE"],
								--width = "half",
								hidden = function(info) return not DB.energybar["shotbar"] end,
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							shotbarcolor = {
								type = "color",
								order = 15,
								name = L["Shot bar color"],
								desc = L["Color of the bar showing auto shot/attack timer."],
								hasAlpha = true,
								hidden = function(info) return not DB.energybar["shotbar"] end,
								get = function(info) return unpack(DB.frames.energybar[info[#info] ]) end,
								set = function(info, r, g, b, a) DB.frames.energybar[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spacer16 = { order = 16, type = "description", name = " ", desc = "", width = "double", hidden = function(info) return DB.energybar["shotbar"] end },
							spacer17 = { order = 17, type = "description", name = " ", desc = "", width = "double"},
							showsettings = {
								type = "execute",
								order = 18,
								name = L["Expand"],
								hidden = function(info) return(DB.energybar.showsettings or (not DB.energybar.enabled) ) end,
								func = function(info) CollapseAll(); DB.energybar.showsettings = true end,
							},
							hidesettings = {
								type = "execute",
								order = 20,
								name = L["Collapse"],
								func = function(info) CollapseAll()	end,
								hidden = function(info) return(not DB.energybar.showsettings) end,
							},
							--spacer22 = { order = 22, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return( (not DB.energybar.showsettings) or (not DB.energybar.enabled) ) end },
							size = {
								type = "group",
								order = 24,
								name = L["Focus bar style"],
								guiInline = false,
								hidden = function(info) return(not DB.energybar.showsettings) end,
								args = {
									width = {
										type = "range", 
										order = 2,
										name = L["Width"],
										min = 6, softMax = 600, max = 1000, step = 1,
										get = function(info) return (DB.frames.energybar[info[#info] ]) end,
										set = function(info, size) DB.frames.energybar[info[#info] ] = (size);LockDown(JSHB.SetupEnergyBarModule) end,
									},
									spacer4 = { order = 4, type = "description", name = " ", desc = "", width = "half" },
									height = {
										type = "range", 
										order = 6,
										name = L["Height"],
										min = 6, softMax = 600, max = 1000, step = 1,
										get = function(info) return (DB.frames.energybar[info[#info] ]) end,
										set = function(info, size) DB.frames.energybar[info[#info] ] = (size);LockDown(JSHB.SetupEnergyBarModule) end,
									},
									classcolored = {
										type = "toggle",
										order = 8,
										name = L["Use class colors for the bar"],
										desc = L["DESCENERGYBARCLASSCOLOR_ENABLE"],
										width = "double",
										get = function(info) return DB.frames.energybar[info[#info] ] end,
										set = function(info, value) DB.frames.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									bartexture = {
										type = "select",
										dialogControl = 'LSM30_Statusbar',
										order = 10,
										name = L["Focus bar texture"],
										desc = L["Texture that gets used on the moving status bar."],
										values = AceGUIWidgetLSMlists.statusbar,
										get = function(info) return DB.frames.energybar[info[#info] ] end,
										set = function(info, value) DB.frames.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									spacer12 = { order = 12, type = "description", name = " ", desc = "", width = "double", hidden = function(info) return DB.frames.energybar.classcolored end },
									barcolor = {
										type = "color",
										order = 14,
										name = L["Normal color"],
										desc = L["ENERGYBARCOLORNORM_DESC"],
										hasAlpha = true,
										--width = "full",
										hidden = function(info) return DB.frames.energybar.classcolored end,
										get = function(info) return unpack(DB.frames.energybar[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.energybar[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
									},
									lowwarn = {
										type = "toggle",
										order = 16,
										name = L["Low focus change"],
										desc = L["FOCUSBARLOWWARNDESC_ENABLE"],
										width = "double",
										disabled = function(info) return not DB.energybar["enabled"] end,
										get = function(info) return DB.energybar[info[#info] ] end,
										set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									spacer8 = { order = 8, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return(DB.energybar.lowwarn) end },
									barcolorlow = {
										type = "color",
										order = 20,
										name = L["Low color"],
										desc = L["ENERGYBARCOLORNORM_DESC"],
										hasAlpha = true,
										hidden = function(info) return not DB.energybar.lowwarn end,
										get = function(info) return unpack(DB.frames.energybar[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.energybar[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
									},
									highwarn = {
										type = "toggle",
										order = 28,
										name = L["High focus change"],
										desc = L["FOCUSBARHIGHWARNDESC_ENABLE"],
										--width = "full",
										disabled = function(info) return not DB.energybar["enabled"] end,
										get = function(info) return DB.energybar[info[#info] ] end,
										set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									highwarnthreshold = {
										type = "range", 
										order = 32,
										name = L["High warning %"],
										desc = L["FOCUSBARHIGHWARNTHRESHOLD_DESC"],
										disabled = function(info) return not DB.energybar["enabled"] end,
										hidden = function(info) return(not DB.energybar.highwarn) end,
										isPercent = true,
										min = .1, max = 1, step = .05,
										get = function(info) return(DB.energybar[info[#info] ]) end,
										set = function(info, size) DB.energybar[info[#info] ] = (size);LockDown(JSHB.SetupEnergyBarModule) end,
									},
									barcolorhigh = {
										type = "color",
										order = 36,
										name = L["High color"],
										desc = L["ENERGYBARCOLORNORM_DESC"],
										hasAlpha = true,
										hidden = function(info) return not DB.energybar.highwarn end,
										get = function(info) return unpack(DB.frames.energybar[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.energybar[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
									},
								},
							},									
							energyfont = {
								type = "group",
								order = 26,
								name = L["Energy font"],
								guiInline = false,
								hidden = function(info) return(not DB.energybar.showsettings) end,
								args = {
									energyfontcolor = {
										type = "color",
										order = 2,
										name = L["Color"],
										desc = L["Color of the text showing your current energy."],
										hasAlpha = true,
										get = function(info) return unpack(DB.frames.energybar[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.energybar[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
									},
									energyfontoffset = {
										type = "range", 
										order = 4,
										name = L["Energy offset"],
										desc = L["DESC_ENERGYBARFONTOFFSET"],
										min = -900, softMin = -100, softMax = 100, max = 900, step = 1,
										get = function(info) return (DB.frames.energybar[info[#info] ]) end,
										set = function(info, size) DB.frames.energybar[info[#info] ] = (size);LockDown(JSHB.SetupEnergyBarModule) end,
									},
									spacer5 = { order = 5, type = "description", name = " ", desc = "", width = "half" },
									font = {
										type = "select", 
										dialogControl = "LSM30_Font",
										order = 6,
										name = L["Font face"],
										desc = L["This is the font used for your current focus."],
										values = AceGUIWidgetLSMlists.font,
										get = function(info) return DB.frames.energybar[info[#info-1] ][1] end,
										set = function(info, font) DB.frames.energybar[info[#info-1] ][1] = font;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									size = {
										type = "range", 
										order = 8,
										name = L["Font size"],
										min = 6, max = 40, step = 1,
										get = function(info) return (DB.frames.energybar[info[#info-1] ][2]) end,
										set = function(info, size) DB.frames.energybar[info[#info-1] ][2] = (size);LockDown(JSHB.SetupEnergyBarModule) end,
									},
									flags = {
										type = "multiselect", 
										order = 12,
										name = L["Font flags"],
										values = fontFlagTable,
										get = function(info, key) return(tContains({strsplit(",", DB.frames.energybar[info[#info-1] ][3])}, key) and true or false) end,
										set = function(info, keyname, state) setFontFlags(DB.frames.energybar[info[#info-1] ], keyname, state);LockDown(JSHB.SetupEnergyBarModule) end,
									},
								},
							},
							healthfont = {
								type = "group",
								order = 32,
								name = L["Target's health font"],
								guiInline = false,
								hidden = function(info) return(not DB.energybar.showsettings) end,
								args = {
									healthfontoffset = {
										type = "range", 
										order = 2,
										name = L["Health offset"],
										desc = L["DESC_ENERGYBARFONTOFFSET"],
										min = -900, softMin = -100, softMax = 100, max = 900, step = 1,
										get = function(info) return (DB.frames.energybar[info[#info] ]) end,
										set = function(info, size) DB.frames.energybar[info[#info] ] = (size);LockDown(JSHB.SetupEnergyBarModule) end,
									},
									font = {
										type = "select", 
										dialogControl = 'LSM30_Font',
										order = 6,
										name = L["Font face"],
										desc = L["This is the font used for showing your target's current health percent."],
										values = AceGUIWidgetLSMlists.font,
										get = function(info) return DB.frames.energybar[info[#info-1] ][1] end,
										set = function(info, font) DB.frames.energybar[info[#info-1] ][1] = font;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									size = {
										type = "range", 
										order = 8,
										name = L["Font size"],
										min = 6, max = 40, step = 1,
										get = function(info) return (DB.frames.energybar[info[#info-1] ][2]) end,
										set = function(info, size) DB.frames.energybar[info[#info-1] ][2] = (size);LockDown(JSHB.SetupEnergyBarModule) end,
									},
									flags = {
										type = "multiselect", 
										order = 10,
										name = L["Font flags"],
										values = fontFlagTable,
										get = function(info, key) return(tContains({strsplit(",", DB.frames.energybar[info[#info-1] ][3])}, key) and true or false) end,
										set = function(info, keyname, state) setFontFlags(DB.frames.energybar[info[#info-1] ], keyname, state);LockDown(JSHB.SetupEnergyBarModule) end,
									},
								},
							},
							shottimerfont = {
								type = "group",
								order = 36,
								name = L["Shot timer font"],
								guiInline = false,
								hidden = function(info) return(not DB.energybar.showsettings) end,
								args = {
									shottimerfontcolor = {
										type = "color",
										order = 2,
										name = L["Shot timer text color"],
										desc = L["Color of the text showing autoshot timer."],
										hasAlpha = true,
										get = function(info) return unpack(DB.frames.energybar[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.energybar[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
									},
									shottimerfontoffset = {
										type = "range", 
										order = 4,
										name = L["Shot timer offset"],
										desc = L["DESC_ENERGYBARFONTOFFSET"],
										min = -900, softMin = -100, softMax = 100, max = 900, step = 1,
										get = function(info) return (DB.frames.energybar[info[#info] ]) end,
										set = function(info, size) DB.frames.energybar[info[#info] ] = (size);LockDown(JSHB.SetupEnergyBarModule) end,
									},
									spacer8 = { order = 8, type = "description", name = " ", desc = "", width = "half" },
									font = {
										type = "select", 
										dialogControl = 'LSM30_Font',
										order = 10,
										name = L["Font face"],
										desc = L["This is the font used for the autoshot timer."],
										values = AceGUIWidgetLSMlists.font,
										get = function(info) return DB.frames.energybar[info[#info-1] ][1] end,
										set = function(info, font) DB.frames.energybar[info[#info-1] ][1] = font;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									size = {
										type = "range", 
										order = 12,
										name = L["Font size"],
										min = 6, max = 40, step = 1,
										get = function(info) return (DB.frames.energybar[info[#info-1] ][2]) end,
										set = function(info, size) DB.frames.energybar[info[#info-1] ][2] = (size);LockDown(JSHB.SetupEnergyBarModule) end,
									},
									flags = {
										type = "multiselect", 
										order = 14,
										name = L["Font flags"],
										values = fontFlagTable,
										get = function(info, key) return(tContains({strsplit(",", DB.frames.energybar[info[#info-1] ][3])}, key) and true or false) end,
										set = function(info, keyname, state) setFontFlags(DB.frames.energybar[info[#info-1] ], keyname, state);LockDown(JSHB.SetupEnergyBarModule) end,
									},
								},
							},
							backdrop = {
								type = "group",
								order = 42,
								name = L["Backdrop"],
								guiInline = false,
								hidden = function(info) return(not DB.energybar.showsettings) end,
								args = {
									enablebackdrop = {
										type = "toggle",
										order = 1,
										name = L["Enable"],
										desc = L["DESCBACKDROP_ENABLE"],
										width = "double",
										get = function(info) return DB.frames.energybar[info[#info] ] end,
										set = function(info, value) DB.frames.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									backdroptexture = {
										type = "select",
										dialogControl = 'LSM30_Background',
										order = 2,
										name = L["Backdrop texture"],
										desc = L["Texture that gets used for the bar's background."],
										values = AceGUIWidgetLSMlists.background,
										disabled = function(info) return not DB.frames.energybar["enablebackdrop"] end,
										get = function(info) return DB.frames.energybar[info[#info] ] end,
										set = function(info, value) DB.frames.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									colorbackdrop = {
										type = "toggle",
										order = 3,
										name = L["Color the backdrop"],
										desc = L["DESCBACKDROPCOLOR_ENABLE"],
										disabled = function(info) return not DB.frames.energybar["enablebackdrop"] end,
										get = function(info) return DB.frames.energybar[info[#info] ] end,
										set = function(info, value) DB.frames.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									backdropcolor = {
										type = "color",
										order = 5,
										name = L["Backdrop color"],
										hasAlpha = true,
										disabled = function(info) return not DB.frames.energybar["enablebackdrop"] end,
										hidden = function(info) return not DB.frames.energybar.colorbackdrop end,
										get = function(info) return unpack(DB.frames.energybar[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.energybar[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
									},
									spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return not DB.frames.energybar.colorbackdrop end },
									tile = {
										type = "toggle",
										order = 7,
										name = L["Tile the backdrop"],
										desc = L["DESCBACKDROPTILE_ENABLE"],
										disabled = function(info) return not DB.frames.energybar["enablebackdrop"] end,
										get = function(info) return DB.frames.energybar[info[#info] ] end,
										set = function(info, value) DB.frames.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									tilesize = {
										type = "range",
										order = 8,
										name = L["Tile size"],
										desc = L["DESCTILESIZE_ENABLE"],
										min = -100, softMin = -30, softMax = 30, max = 100, step = 1,
										disabled = function(info) return not DB.frames.energybar["enablebackdrop"] end,
										hidden = function(info) return not DB.frames.energybar.tile end,
										get = function(info) return DB.frames.energybar[info[#info] ] end,
										set = function(info, value) DB.frames.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									spacer = { order = 11, type = "description", name = "", desc = "", width = "full"},
									backdropoffsets = {
										type = "group",
										order = 14,
										name = L["Offsets"],
										guiInline = true,
										args = {
											offsetX1 = {
												type = "range",
												order = 1,
												name = L["Top-left X"],
												desc = L["This sets the 'X offset' value."],
												min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
												disabled = function(info) return not DB.frames.energybar["enablebackdrop"] end,
												get = function(info) return (DB.frames.energybar[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.energybar[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupEnergyBarModule) end,
											},
											offsetY1 = {
												type = "range", 
												order = 2,
												name = L["Top-left Y"],
												desc = L["This sets the 'Y offset' value."],
												min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
												disabled = function(info) return not DB.frames.energybar["enablebackdrop"] end,
												get = function(info) return (DB.frames.energybar[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.energybar[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupEnergyBarModule) end,
											},
											spacer6 = { order = 6, type = "description", name = "", desc = "", width = "half"},
											offsetX2 = {
												type = "range", 
												order = 8,
												name = L["Bottom-right X"],
												desc = L["This sets the 'X offset' value."],
												min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
												disabled = function(info) return not DB.frames.energybar["enablebackdrop"] end,
												get = function(info) return (DB.frames.energybar[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.energybar[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupEnergyBarModule) end,
											},
											offsetY2 = {
												type = "range", 
												order = 10,
												name = L["Bottom-right Y"],
												desc = L["This sets the 'Y offset' value."],
												min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
												disabled = function(info) return not DB.frames.energybar["enablebackdrop"] end,
												get = function(info) return (DB.frames.energybar[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.energybar[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupEnergyBarModule) end,
											},										
										},
									},
									spacer = { order = 16, type = "description", name = "", desc = "", width = "full"},
								},
							},
							border = {
								type = "group",
								order = 44,
								name = L["Border"],
								guiInline = false,
								hidden = function(info) return(not DB.energybar.showsettings) end,
								args = {
									enableborder = {
										type = "toggle",
										order = 1,
										name = L["Enable"],
										desc = L["DESCBORDER_ENABLE"],
										get = function(info) return DB.frames.energybar[info[#info] ] end,
										set = function(info, value) DB.frames.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									bordercolor = {
										type = "color",
										order = 2,
										name = L["Border color"],
										hasAlpha = true,
										disabled = function(info) return not DB.frames.energybar["enableborder"] end,
										get = function(info) return unpack(DB.frames.energybar[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.energybar[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
									},
									bordertexture = {
										type = "select",
										dialogControl = 'LSM30_Border',
										order = 3,
										name = L["Border texture"],
										desc = L["Texture that gets used for the bar's background."],
										values = AceGUIWidgetLSMlists.border,
										disabled = function(info) return not DB.frames.energybar["enableborder"] end,
										get = function(info) return DB.frames.energybar[info[#info] ] end,
										set = function(info, value) DB.frames.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									edgesize = {
										type = "range",
										order = 4,
										name = L["Edge size"],
										desc = L["DESCEDGESIZE_ENABLE"],
										min = -100, softMin = -16, softMax = 16, max = 100, step = 1,
										disabled = function(info) return not DB.frames.energybar["enableborder"] end,
										get = function(info) return DB.frames.energybar[info[#info] ] end,
										set = function(info, value) DB.frames.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
									},
									spacer = { order = 7, type = "description", name = "", desc = "", width = "full"},
									backdropinsets = {
										type = "group",
										order = 10,
										name = L["Insets"],
										guiInline = true,
										args = {
											left = {
												type = "range",
												order = 1,
												name = L["Left"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.energybar["enableborder"] end,
												get = function(info) return (DB.frames.energybar[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.energybar[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupEnergyBarModule) end,
											},
											right = {
												type = "range", 
												order = 2,
												name = L["Right"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.energybar["enableborder"] end,
												get = function(info) return (DB.frames.energybar[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.energybar[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupEnergyBarModule) end,
											},
											top = {
												type = "range", 
												order = 3,
												name = L["Top"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.energybar["enableborder"] end,
												get = function(info) return (DB.frames.energybar[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.energybar[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupEnergyBarModule) end,
											},
											bottom = {
												type = "range", 
												order = 4,
												name = L["Bottom"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.energybar["enableborder"] end,
												get = function(info) return (DB.frames.energybar[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.energybar[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupEnergyBarModule) end,
											},										
										},
									},
								},
							},
						},
					},
					spacer17 = { order = 17, type = "description", name = " ", desc = "", width = "full"},
					alphastuff = {
						order = 18,
						type = "group",
						name = L["Bar Alpha Settings"],
						guiInline = true,
						args = {
							activealpha = {
								type = "range",
								order = 24,
								name = L["Active alpha"],
								desc = L["FOCUSBARACTIVEALPHA_DESC"],
								min = 0, max = 1, step = .1,
								isPercent = true,
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return (DB.energybar[info[#info] ]) end,
								set = function(info, value) DB.energybar[info[#info] ] = (value);LockDown(JSHB.SetupEnergyBarModule) end,
							},
							inactivealpha = {
								type = "range",
								order = 26,
								name = L["Inactive alpha"],
								desc = L["FOCUSBARINACTIVEALPHA_DESC"],
								min = 0, max = 1, step = .1,
								isPercent = true,
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return (DB.energybar[info[#info] ]) end,
								set = function(info, value) DB.energybar[info[#info] ] = (value);LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spacer1 = { order = 27, type = "description", name = " ", desc = "", width = "full"},
							oocoverride = {
								type = "toggle",
								order = 28,
								name = L["OOC override"],
								desc = L["FOCUSBARENABLEOOCOVERRIDE_DESC"],
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							oocoverridealpha = {
								type = "range",
								order = 30,
								name = L["OOC alpha"],
								desc = L["FOCUSBAROOCALPHA_DESC"],
								min = 0, max = 1, step = .1,
								isPercent = true,
								disabled = function(info) 
									if not DB.energybar["oocoverride"] then return true end
									if not DB.energybar["enabled"] then return true end
									return false end,
								get = function(info) return (DB.energybar[info[#info] ]) end,
								set = function(info, value) DB.energybar[info[#info] ] = (value);LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spacer2 = { order = 31, type = "description", name = " ", desc = "", width = "full"},
							mountoverride = {
								type = "toggle",
								order = 32,
								name = L["Mounted override"],
								desc = L["FOCUSBARENABLEMOUNTOVERRIDE_DESC"],
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							mountoverridealpha = {
								type = "range",
								order = 34,
								name = L["Mounted alpha"],
								desc = L["FOCUSBARMOUNTALPHA_DESC"],
								min = 0, max = 1, step = .1,
								isPercent = true,
								disabled = function(info) 
									if not DB.energybar["mountoverride"] then return true end
									if not DB.energybar["enabled"] then return true end
									return false end,
								get = function(info) return (DB.energybar[info[#info] ]) end,
								set = function(info, value) DB.energybar[info[#info] ] = (value);LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spacer3 = { order = 35, type = "description", name = " ", desc = "", width = "full"},
							deadoverride = {
								type = "toggle",
								order = 36,
								name = L["Dead override"],
								desc = L["FOCUSBARENABLEDEADOVERRIDE_DESC"],
								disabled = function(info) return not DB.energybar["enabled"] end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							deadoverridealpha = {
								type = "range",
								order = 38,
								name = L["Dead alpha"],
								desc = L["FOCUSBARDEADALPHA_DESC"],
								min = 0, max = 1, step = .1,
								isPercent = true,
								disabled = function(info) 
									if not DB.energybar["deadoverride"] then return true end
									if not DB.energybar["enabled"] then return true end
									return false end,
								get = function(info) return (DB.energybar[info[#info] ]) end,
								set = function(info, value) DB.energybar[info[#info] ] = (value);LockDown(JSHB.SetupEnergyBarModule) end,
							},
						},
					},
					spacer19 = { order = 19, type = "description", name = " ", desc = "", width = "full"},
					stackstuff = {
						order = 20,
						type = "group",
						name = L["Stack Indicators"],
						guiInline = true,
						args = {
							enablestacks = {
								type = "toggle",
								order = 4,
								name = L["Enable stack indicators"],
								desc = L["FOCUSBARSTACKSDESC_ENABLE"],
								width = "full",
								get = function(info) return DB.energybar.enablestacks end,
								set = function(info, value) DB.energybar.enablestacks = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							embedstacks = {
								type = "toggle",
								order = 8,
								name = L["Embed on bar"],
								desc = L["FOCUSBARSTACKSEMBEDDESC_ENABLE"],
								disabled = function(info) return (not DB.energybar["enablestacks"]) end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							stackssize = {
								type = "range",
								order = 12,
								name = L["Stack size"],
								desc = L["FOCUSBARSTACKSIZE_DESC"],
								min = 10, softMax = 100, max = 600, step = 1,
								disabled = function(info) return (DB.energybar["embedstacks"] and DB.energybar["enablestacks"]) end,
								get = function(info) return (DB.energybar[info[#info] ]) end,
								set = function(info, value) DB.energybar[info[#info] ] = (value);LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spacer1 = { order = 15, type = "description", name = " ", desc = "", width = "full"},
							stacksreverse = {
								type = "toggle",
								order = 18,
								name = L["Reverse stacks"],
								desc = L["FOCUSBARSTACKSREVERSEDESC_ENABLE"],
								--disabled = function(info) return (not DB.energybar["enablestacks"]) end,
								disabled = function(info) return ( (not DB.energybar["enablestacks"]) or ( (DB.energybar["embedstacks"]) and (not DB.energybar["enabled"]) ) ) end,
								get = function(info) return DB.energybar[info[#info] ] end,
								set = function(info, value) DB.energybar[info[#info] ] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							stackscolor = {
								type = "color",
								order = 28,
								name = L["Stacks color"],
								hasAlpha = false,
								disabled = function(info) return ( (not DB.energybar["enablestacks"]) or ( (DB.energybar["embedstacks"]) and (not DB.energybar["enabled"]) ) ) end,
								get = function(info) return unpack(DB.energybar[info[#info] ]) end,
								set = function(info, r, g, b, a) DB.energybar[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
							},
						},
					},
					spacer22 = { order = 22, type = "description", name = " ", desc = "", width = "full"},
					tickstuff1 = {
						order = 24,
						type = "group",
						name = L["Tick Mark 1 (Main Spell)"],
						guiInline = true,
						disabled = function(info) return not DB.energybar["enabled"] end,
						args = {
							enabled = {
								type = "toggle",
								order = 4,
								name = L["Enable"],
								desc = L["FOCUSBARTICKDESC_ENABLE"],
								width = "full",
								get = function(info) return DB.energybar.ticks[1][1] end,
								set = function(info, value) DB.energybar.ticks[1][1] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},							
							colorbar = {
								type = "toggle",
								order = 14,
								name = L["Change bar color"],
								desc = L["TICKCOLOR_DESC"],
								hidden = function(info) return not DB.energybar.ticks[1][1] end,
								get = function(info) return DB.energybar.ticks[1][4] end,
								set = function(info, value) DB.energybar.ticks[1][4] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							color = {
								type = "color",
								order = 18,
								name = L["Color"],
								desc = L["Color to change to."],
								disabled = function(info) return not DB.energybar.ticks[1][4] end,
								hidden = function(info) return not DB.energybar.ticks[1][1] end,
								hasAlpha = true,
								get = function(info) return unpack(DB.energybar.ticks[1][5]) end,
								set = function(info, r, g, b, a) DB.energybar.ticks[1][5] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
							},
						},
					},
					spacer25 = { order = 25, type = "description", name = " ", desc = "", width = "full"},
					tickstuff2 = {
						order = 26,
						type = "group",
						name = L["Tick Mark 2"],
						hidden = function(info) return not DB.energybar.ticks[1][1] end,
						guiInline = true,
						disabled = function(info) return not DB.energybar["enabled"] end,
						args = {
							enabled = {
								type = "toggle",
								order = 4,
								name = L["Enable"],
								desc = L["FOCUSBARTICKDESC_ENABLE"],
								width = "full",
								get = function(info) return DB.energybar.ticks[2][1] end,
								set = function(info, value) DB.energybar.ticks[2][1] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spell = {
								order = 7,
								type = "select",
								name = L["Spell"],
								desc = L["TICKSPELL_DESC"],
								hidden = function(info) return not DB.energybar.ticks[2][1] end,
								style = "dropdown",
								values = function() return GetPlayerFocusSpells() end,
								get = function(info) return DB.energybar.ticks[2][2] end,
								set = function(info, value) DB.energybar.ticks[2][2] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spec = {
								order = 8,
								type = "select",
								name = L["Talent spec"],
								desc = L["TICKSPEC_DESC"],
								hidden = function(info) return not DB.energybar.ticks[2][1] end,
								style = "dropdown",
								values = function()
										local t = {
											["0"] = L["Any Spec"],
											["1"] = select(2, GetTalentTabInfo(1) ),
											["2"] = select(2, GetTalentTabInfo(2) ),
											["3"] = select(2, GetTalentTabInfo(3) ),
										}
										return(t)
									end,
								get = function(info) return(tostring(DB.energybar.ticks[2][6]) ) end,
								set = function(info, value) DB.energybar.ticks[2][6] = tonumber(value);LockDown(JSHB.SetupEnergyBarModule) end,
							},
							offset = {
								type = "toggle",
								order = 10,
								name = L["Offset from main spell"],
								desc = L["TICKOFFSET_DESC"],
								hidden = function(info) return not DB.energybar.ticks[2][1] end,
								get = function(info) return DB.energybar.ticks[2][3] end,
								set = function(info, value) DB.energybar.ticks[2][3] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							colorbar = {
								type = "toggle",
								order = 14,
								name = L["Change bar color"],
								desc = L["TICKCOLOR_DESC"],
								hidden = function(info) return not DB.energybar.ticks[2][1] end,
								get = function(info) return DB.energybar.ticks[2][4] end,
								set = function(info, value) DB.energybar.ticks[2][4] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							color = {
								type = "color",
								order = 18,
								name = L["Color"],
								desc = L["Color to change to."],
								disabled = function(info) return not DB.energybar.ticks[2][4] end,
								hidden = function(info) return not DB.energybar.ticks[2][1] end,
								hasAlpha = true,
								get = function(info) return unpack(DB.energybar.ticks[2][5]) end,
								set = function(info, r, g, b, a) DB.energybar.ticks[2][5] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
							},
						},
					},
					spacer27 = { order = 27, type = "description", name = " ", desc = "", width = "full"},
					tickstuff3 = {
						order = 29,
						type = "group",
						name = L["Tick Mark 3"],
						hidden = function(info) return not DB.energybar.ticks[1][1] end,
						guiInline = true,
						disabled = function(info) return not DB.energybar["enabled"] end,
						args = {
							enabled = {
								type = "toggle",
								order = 4,
								name = L["Enable"],
								desc = L["FOCUSBARTICKDESC_ENABLE"],
								width = "full",
								get = function(info) return DB.energybar.ticks[3][1] end,
								set = function(info, value) DB.energybar.ticks[3][1] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spell = {
								order = 7,
								type = "select",
								name = L["Spell"],
								desc = L["TICKSPELL_DESC"],
								hidden = function(info) return not DB.energybar.ticks[3][1] end,
								style = "dropdown",
								values = function() return GetPlayerFocusSpells() end,
								get = function(info) return DB.energybar.ticks[3][2] end,
								set = function(info, value) DB.energybar.ticks[3][2] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spec = {
								order = 8,
								type = "select",
								name = L["Talent spec"],
								desc = L["TICKSPEC_DESC"],
								hidden = function(info) return not DB.energybar.ticks[3][1] end,
								style = "dropdown",
								values = function()
										local t = {
											["0"] = L["Any Spec"],
											["1"] = select(2, GetTalentTabInfo(1) ),
											["2"] = select(2, GetTalentTabInfo(2) ),
											["3"] = select(2, GetTalentTabInfo(3) ),
										}
										return(t)
									end,
								get = function(info) return(tostring(DB.energybar.ticks[3][6]) ) end,
								set = function(info, value) DB.energybar.ticks[3][6] = tonumber(value);LockDown(JSHB.SetupEnergyBarModule) end,
							},
							offset = {
								type = "toggle",
								order = 10,
								name = L["Offset from main spell"],
								desc = L["TICKOFFSET_DESC"],
								hidden = function(info) return not DB.energybar.ticks[3][1] end,
								get = function(info) return DB.energybar.ticks[3][3] end,
								set = function(info, value) DB.energybar.ticks[3][3] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							colorbar = {
								type = "toggle",
								order = 14,
								name = L["Change bar color"],
								desc = L["TICKCOLOR_DESC"],
								hidden = function(info) return not DB.energybar.ticks[3][1] end,
								get = function(info) return DB.energybar.ticks[3][4] end,
								set = function(info, value) DB.energybar.ticks[3][4] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							color = {
								type = "color",
								order = 18,
								name = L["Color"],
								desc = L["Color to change to."],
								disabled = function(info) return not DB.energybar.ticks[3][4] end,
								hidden = function(info) return not DB.energybar.ticks[3][1] end,
								hasAlpha = true,
								get = function(info) return unpack(DB.energybar.ticks[3][5]) end,
								set = function(info, r, g, b, a) DB.energybar.ticks[3][5] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
							},
						},
					},
					spacer30 = { order = 30, type = "description", name = " ", desc = "", width = "full"},
					tickstuff4 = {
						order = 32,
						type = "group",
						name = L["Tick Mark 4"],
						hidden = function(info) return not DB.energybar.ticks[1][1] end,
						guiInline = true,
						disabled = function(info) return not DB.energybar["enabled"] end,
						args = {
							enabled = {
								type = "toggle",
								order = 4,
								name = L["Enable"],
								desc = L["FOCUSBARTICKDESC_ENABLE"],
								width = "full",
								get = function(info) return DB.energybar.ticks[4][1] end,
								set = function(info, value) DB.energybar.ticks[4][1] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spell = {
								order = 7,
								type = "select",
								name = L["Spell"],
								desc = L["TICKSPELL_DESC"],
								hidden = function(info) return not DB.energybar.ticks[4][1] end,
								style = "dropdown",
								values = function() return GetPlayerFocusSpells() end,
								get = function(info) return DB.energybar.ticks[4][2] end,
								set = function(info, value) DB.energybar.ticks[4][2] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spec = {
								order = 8,
								type = "select",
								name = L["Talent spec"],
								desc = L["TICKSPEC_DESC"],
								hidden = function(info) return not DB.energybar.ticks[4][1] end,
								style = "dropdown",
								values = function()
										local t = {
											["0"] = L["Any Spec"],
											["1"] = select(2, GetTalentTabInfo(1) ),
											["2"] = select(2, GetTalentTabInfo(2) ),
											["3"] = select(2, GetTalentTabInfo(3) ),
										}
										return(t)
									end,
								get = function(info) return(tostring(DB.energybar.ticks[4][6]) ) end,
								set = function(info, value) DB.energybar.ticks[4][6] = tonumber(value);LockDown(JSHB.SetupEnergyBarModule) end,
							},
							offset = {
								type = "toggle",
								order = 10,
								name = L["Offset from main spell"],
								desc = L["TICKOFFSET_DESC"],
								hidden = function(info) return not DB.energybar.ticks[4][1] end,
								get = function(info) return DB.energybar.ticks[4][3] end,
								set = function(info, value) DB.energybar.ticks[4][3] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							colorbar = {
								type = "toggle",
								order = 14,
								name = L["Change bar color"],
								desc = L["TICKCOLOR_DESC"],
								hidden = function(info) return not DB.energybar.ticks[4][1] end,
								get = function(info) return DB.energybar.ticks[4][4] end,
								set = function(info, value) DB.energybar.ticks[4][4] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							color = {
								type = "color",
								order = 18,
								name = L["Color"],
								desc = L["Color to change to."],
								disabled = function(info) return not DB.energybar.ticks[4][4] end,
								hidden = function(info) return not DB.energybar.ticks[4][1] end,
								hasAlpha = true,
								get = function(info) return unpack(DB.energybar.ticks[4][5]) end,
								set = function(info, r, g, b, a) DB.energybar.ticks[4][5] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
							},
						},
					},
					spacer33 = { order = 33, type = "description", name = " ", desc = "", width = "full"},
					tickstuff5 = {
						order = 35,
						type = "group",
						name = L["Tick Mark 5"],
						hidden = function(info) return not DB.energybar.ticks[1][1] end,
						guiInline = true,
						disabled = function(info) return not DB.energybar["enabled"] end,
						args = {
							enabled = {
								type = "toggle",
								order = 4,
								name = L["Enable"],
								desc = L["FOCUSBARTICKDESC_ENABLE"],
								width = "full",
								get = function(info) return DB.energybar.ticks[5][1] end,
								set = function(info, value) DB.energybar.ticks[5][1] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spell = {
								order = 7,
								type = "select",
								name = L["Spell"],
								desc = L["TICKSPELL_DESC"],
								hidden = function(info) return not DB.energybar.ticks[5][1] end,
								style = "dropdown",
								values = function() return GetPlayerFocusSpells() end,
								get = function(info) return DB.energybar.ticks[5][2] end,
								set = function(info, value) DB.energybar.ticks[5][2] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							spec = {
								order = 8,
								type = "select",
								name = L["Talent spec"],
								desc = L["TICKSPEC_DESC"],
								hidden = function(info) return not DB.energybar.ticks[5][1] end,
								style = "dropdown",
								values = function()
										local t = {
											["0"] = L["Any Spec"],
											["1"] = select(2, GetTalentTabInfo(1) ),
											["2"] = select(2, GetTalentTabInfo(2) ),
											["3"] = select(2, GetTalentTabInfo(3) ),
										}
										return(t)
									end,
								get = function(info) return(tostring(DB.energybar.ticks[5][6]) ) end,
								set = function(info, value) DB.energybar.ticks[5][6] = tonumber(value);LockDown(JSHB.SetupEnergyBarModule) end,
							},
							offset = {
								type = "toggle",
								order = 10,
								name = L["Offset from main spell"],
								desc = L["TICKOFFSET_DESC"],
								hidden = function(info) return not DB.energybar.ticks[5][1] end,
								get = function(info) return DB.energybar.ticks[5][3] end,
								set = function(info, value) DB.energybar.ticks[5][3] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							colorbar = {
								type = "toggle",
								order = 14,
								name = L["Change bar color"],
								desc = L["TICKCOLOR_DESC"],
								hidden = function(info) return not DB.energybar.ticks[5][1] end,
								get = function(info) return DB.energybar.ticks[5][4] end,
								set = function(info, value) DB.energybar.ticks[5][4] = value;LockDown(JSHB.SetupEnergyBarModule) end,
							},
							color = {
								type = "color",
								order = 18,
								name = L["Color"],
								desc = L["Color to change to."],
								disabled = function(info) return not DB.energybar.ticks[5][4] end,
								hidden = function(info) return not DB.energybar.ticks[5][1] end,
								hasAlpha = true,
								get = function(info) return unpack(DB.energybar.ticks[5][5]) end,
								set = function(info, r, g, b, a) DB.energybar.ticks[5][5] = {r, g, b, a};LockDown(JSHB.SetupEnergyBarModule) end,
							},
						},
					},
				},
			},
			enrage = {
				order = 6,
				type = "group",
				name = " ",
				guiInline = true,
				childGroups = "tree",
				args = {
					intro = {
						order = 1,
						type = "description",
						name = L["ENRAGE_DESC"].."\n",
						fontSize = "medium",
					},
					spacer4 = { order = 4, type = "description", name = " ", desc = "", width = "full"},
					genstuff = {
						order = 6,
						type = "group",
						name = L["General Tranq Alert Settings"],
						guiInline = true,
						args = {
							enabled = {
								type = "toggle",
								order = 4,
								name = L["Enable Tranquilizing Shot Alert"],
								desc = L["ENRAGEDESC_ENABLE"],
								width = "double",
								get = function(info) return DB.enrage[info[#info] ] end,
								set = function(info, value) CollapseAll();DB.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
							},
							iconsize = {
								type = "range", 
								order = 6,
								name = L["Alert icon size"],
								min = 10, max = 100, step = 1,
								disabled = function(info) return not DB.enrage.enabled end,
								get = function(info) return (DB.frames.enrage[info[#info] ]) end,
								set = function(info, size) DB.frames.enrage[info[#info] ] = (size);LockDown(JSHB.SetupEnrageModule) end,
							},
							--spacer8 = { order = 8, type = "description", name = " ", desc = "", width = "full"},
							enablesound = {
								type = "toggle",
								order = 12,
								name = L["Enable sound"],
								desc = L["ENRAGESOUNDDESC_ENABLE"],
								width = "double",
								disabled = function(info) return not DB.enrage.enabled end,
								get = function(info) return DB.enrage[info[#info] ] end,
								set = function(info, value) DB.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
							},
							sound = {
								type = "select",
								dialogControl = 'LSM30_Sound',
								order = 14,
								name = L["Alert Sound"],
								desc = L["ENRAGESOUND_DESC"],
								values = AceGUIWidgetLSMlists.sound,
								disabled = function(info) return not DB.enrage.enabled end,
								hidden = function(info) return not DB.enrage.enablesound end,
								get = function(info) return DB.enrage[ info[#info] ] end,
								set = function(info, value) DB.enrage[ info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,								
							},
							spacer16 = { order = 16, type = "description", name = " ", desc = "", width = "double", hidden = function(info) return DB.enrage["enablesound"] end },
							spacer17 = { order = 17, type = "description", name = " ", desc = "", width = "double"},
							showsettings = {
								type = "execute",
								order = 18,
								name = L["Expand"],
								hidden = function(info) return(DB.enrage.showsettings or (not DB.enrage.enabled) ) end,
								func = function(info) CollapseAll(); DB.enrage.showsettings = true end,
							},
							hidesettings = {
								type = "execute",
								order = 20,
								name = L["Collapse"],
								func = function(info) CollapseAll()	end,
								hidden = function(info) return(not DB.enrage.showsettings) end,
							},
							backdrop = {
								type = "group",
								order = 22,
								name = L["Backdrop"],
								guiInline = true,
								hidden = function(info) return(not DB.enrage.showsettings) end,
								args = {
									enablebackdrop = {
										type = "toggle",
										order = 1,
										name = L["Enable"],
										desc = L["DESCBACKDROP_ENABLE"],
										width = "double",
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									backdroptexture = {
										type = "select",
										dialogControl = 'LSM30_Background',
										order = 2,
										name = L["Backdrop texture"],
										desc = L["Texture that gets used for the background."],
										values = AceGUIWidgetLSMlists.background,
										disabled = function(info) return not DB.frames.enrage["enablebackdrop"] end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									colorbackdrop = {
										type = "toggle",
										order = 3,
										name = L["Color the backdrop"],
										desc = L["DESCBACKDROPCOLOR_ENABLE"],
										disabled = function(info) return not DB.frames.enrage["enablebackdrop"] end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									backdropcolor = {
										type = "color",
										order = 5,
										name = L["Backdrop color"],
										hasAlpha = true,
										disabled = function(info) return not DB.frames.enrage["enablebackdrop"] end,
										hidden = function(info) return not DB.frames.enrage.colorbackdrop end,
										get = function(info) return unpack(DB.frames.enrage[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.enrage[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnrageModule) end,
									},
									spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return not DB.frames.enrage.colorbackdrop end },
									tile = {
										type = "toggle",
										order = 7,
										name = L["Tile the backdrop"],
										desc = L["DESCBACKDROPTILE_ENABLE"],
										disabled = function(info) return not DB.frames.enrage["enablebackdrop"] end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									tilesize = {
										type = "range",
										order = 8,
										name = L["Tile size"],
										desc = L["DESCTILESIZE_ENABLE"],
										min = -100, softMin = -30, softMax = 30, max = 100, step = 1,
										disabled = function(info) return not DB.frames.enrage["enablebackdrop"] end,
										hidden = function(info) return not DB.frames.enrage.tile end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									spacer11 = { order = 11, type = "description", name = "", desc = "", width = "full"},
									backdropoffsets = {
										type = "group",
										order = 14,
										name = L["Offsets"],
										guiInline = true,
										args = {
											offsetX1 = {
												type = "range",
												order = 2,
												name = L["Top-left X"],
												desc = L["This sets the 'X offset' value."],
												min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["enablebackdrop"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											offsetY1 = {
												type = "range", 
												order = 4,
												name = L["Top-left Y"],
												desc = L["This sets the 'Y offset' value."],
												min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["enablebackdrop"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											spacer6 = { order = 6, type = "description", name = "", desc = "", width = "half"},
											offsetX2 = {
												type = "range", 
												order = 8,
												name = L["Bottom-right X"],
												desc = L["This sets the 'X offset' value."],
												min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["enablebackdrop"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											offsetY2 = {
												type = "range", 
												order = 10,
												name = L["Bottom-right Y"],
												desc = L["This sets the 'Y offset' value."],
												min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["enablebackdrop"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},										
										},
									},
									spacer16 = { order = 16, type = "description", name = "", desc = "", width = "full"},
								},
							},
							spacer23 = { order = 23, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return(not DB.enrage.showsettings) end },
							border = {
								type = "group",
								order = 24,
								name = L["Border"],
								guiInline = true,
								hidden = function(info) return(not DB.enrage.showsettings) end,
								args = {
									enableborder = {
										type = "toggle",
										order = 1,
										name = L["Enable"],
										desc = L["DESCBORDER_ENABLE"],
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									bordercolor = {
										type = "color",
										order = 2,
										name = L["Border color"],
										hasAlpha = true,
										disabled = function(info) return not DB.frames.enrage["enableborder"] end,
										get = function(info) return unpack(DB.frames.enrage[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.enrage[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnrageModule) end,
									},
									bordertexture = {
										type = "select",
										dialogControl = 'LSM30_Border',
										order = 3,
										name = L["Border texture"],
										desc = L["Texture that gets used for the border."],
										values = AceGUIWidgetLSMlists.border,
										disabled = function(info) return not DB.frames.enrage["enableborder"] end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									edgesize = {
										type = "range",
										order = 4,
										name = L["Edge size"],
										desc = L["DESCEDGESIZE_ENABLE"],
										min = -100, softMin = -16, softMax = 16, max = 100, step = 1,
										disabled = function(info) return not DB.frames.enrage["enableborder"] end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									spacer7 = { order = 7, type = "description", name = "", desc = "", width = "full"},
									backdropinsets = {
										type = "group",
										order = 10,
										name = L["Insets"],
										guiInline = true,
										args = {
											left = {
												type = "range",
												order = 1,
												name = L["Left"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["enableborder"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											right = {
												type = "range", 
												order = 2,
												name = L["Right"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["enableborder"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											spacer6 = { order = 6, type = "description", name = "", desc = "", width = "half"},
											top = {
												type = "range", 
												order = 10,
												name = L["Top"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["enableborder"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											bottom = {
												type = "range", 
												order = 12,
												name = L["Bottom"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["enableborder"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},										
										},
									},
								},
							},
							spacer25 = { order = 25, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return(not DB.enrage.showsettings) end },
							texcoords = {
								type = "group",
								order = 26,
								name = L["Alert Texture Coords"],
								guiInline = true,
								hidden = function(info) return(not DB.enrage.showsettings) end,
								args = {						
									enabletexcoords = {
										type = "toggle",
										order = 5,
										name = L["Enable TexCoords"],
										desc = L["DESCTEXCOORDS_ENABLE"],
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									texcoords = {
										type = "group",
										order = 6,
										name = L["Texture coords"],
										guiInline = true,
										args = {
											left = {
												type = "range",
												order = 2,
												name = L["Left"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.enrage["enabletexcoords"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											right = {
												type = "range", 
												order = 4,
												name = L["Right"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.enrage["enabletexcoords"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "half"},
											top = {
												type = "range", 
												order = 10,
												name = L["Top"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.enrage["enabletexcoords"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											bottom = {
												type = "range", 
												order = 12,
												name = L["Bottom"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.enrage["enabletexcoords"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},										
										},
									},
								},
							},
						},
					},
					spacer8 = { order = 8, type = "description", name = " ", desc = "", width = "full"},
					removablesstuff = {
						order = 16,
						type = "group",
						name = L["Removable buffs display"],
						guiInline = true,
						args = {
							enableremovables = {
								type = "toggle",
								order = 2,
								name = L["Display removable buffs"],
								desc = L["ENRAGEREMOVABLESDESC_ENABLE"],
								width = "double",
								disabled = function(info) return not DB.enrage.enabled end,
								get = function(info) return DB.enrage[info[#info] ] end,
								set = function(info, value) CollapseAll();DB.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
							},
							iconsizeremovables = {
								type = "range", 
								order = 4,
								name = L["Removables icon size"],
								desc = L["ENRAGEREOMVABLESSIZE_DESC"],
								min = 10, max = 100, step = 1,
								disabled = function(info) return ( (not DB.enrage.enableremovables) or (not DB.enrage.enabled) ) end,
								get = function(info) return (DB.frames.enrage[info[#info] ]) end,
								set = function(info, size) DB.frames.enrage[info[#info] ] = (size);LockDown(JSHB.SetupEnrageModule) end,
							},
							removablespvponly = {
								type = "toggle",
								order = 6,
								name = L["PvP zone only"],
								desc = L["ENRAGEREMOVABLESPVP_DESC"],
								width = "full",
								disabled = function(info) return ( (not DB.enrage.enableremovables) or (not DB.enrage.enabled) ) end,
								get = function(info) return DB.enrage[info[#info] ] end,
								set = function(info, value) DB.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
							},
							removablestips = {
								type = "toggle",
								order = 10,
								name = L["Show tips when hovering removable buffs"],
								desc = L["ENRAGEREMOVABLESTIPS_DESC"],
								width = "full",
								disabled = function(info) return ( (not DB.enrage.enableremovables) or (not DB.enrage.enabled) ) end,
								get = function(info) return DB.enrage[info[#info] ] end,
								set = function(info, value) DB.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
							},
							--spacer16 = { order = 16, type = "description", name = " ", desc = "", width = "double", hidden = function(info) return DB.energybar["shotbar"] end },
							spacer17 = { order = 17, type = "description", name = " ", desc = "", width = "double"},
							showsettings2 = {
								type = "execute",
								order = 18,
								name = L["Expand"],
								hidden = function(info) return(DB.enrage.showsettings2 or (not DB.enrage.enabled) or (not DB.enrage.enableremovables) ) end,
								func = function(info) CollapseAll(); DB.enrage.showsettings2 = true end,
							},
							hidesettings = {
								type = "execute",
								order = 20,
								name = L["Collapse"],
								func = function(info) CollapseAll()	end,
								hidden = function(info) return(not DB.enrage.showsettings2) end,
							},
							removablesbackdrop = {
								type = "group",
								order = 28,
								name = L["Removable buffs backdrop"],
								guiInline = true,
								hidden = function(info) return(not DB.enrage.showsettings2) end,
								args = {
									removablesenablebackdrop = {
										type = "toggle",
										order = 1,
										name = L["Enable"],
										desc = L["DESCBACKDROP_ENABLE"],
										width = "double",
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									removablesbackdroptexture = {
										type = "select",
										dialogControl = 'LSM30_Background',
										order = 2,
										name = L["Backdrop texture"],
										desc = L["Texture that gets used for the bar's background."],
										values = AceGUIWidgetLSMlists.background,
										disabled = function(info) return not DB.frames.enrage["removablesenablebackdrop"] end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									removablescolorbackdrop = {
										type = "toggle",
										order = 3,
										name = L["Color the backdrop"],
										desc = L["DESCBACKDROPCOLOR_ENABLE"],
										disabled = function(info) return not DB.frames.enrage["removablesenablebackdrop"] end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									removablesbackdropcolor = {
										type = "color",
										order = 5,
										name = L["Backdrop color"],
										hasAlpha = true,
										disabled = function(info) return not DB.frames.enrage["removablesenablebackdrop"] end,
										hidden = function(info) return not DB.frames.enrage.removablescolorbackdrop end,
										get = function(info) return unpack(DB.frames.enrage[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.enrage[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnrageModule) end,
									},
									spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "half", hidden = function(info) return not DB.frames.enrage.removablescolorbackdrop end },
									removablestile = {
										type = "toggle",
										order = 7,
										name = L["Tile the backdrop"],
										desc = L["DESCBACKDROPTILE_ENABLE"],
										disabled = function(info) return not DB.frames.enrage["removablesenablebackdrop"] end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									removablestilesize = {
										type = "range",
										order = 8,
										name = L["Tile size"],
										desc = L["DESCTILESIZE_ENABLE"],
										min = -100, softMin = -30, softMax = 30, max = 100, step = 1,
										disabled = function(info) return not DB.frames.enrage["removablesenablebackdrop"] end,
										hidden = function(info) return not DB.frames.enrage.removablestile end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									spacer11 = { order = 11, type = "description", name = "", desc = "", width = "full"},
									removablesbackdropoffsets = {
										type = "group",
										order = 14,
										name = L["Offsets"],
										guiInline = true,
										args = {
											offsetX1 = {
												type = "range",
												order = 1,
												name = L["Top-left X"],
												desc = L["This sets the 'X offset' value."],
												min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["removablesenablebackdrop"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											offsetY1 = {
												type = "range", 
												order = 2,
												name = L["Top-left Y"],
												desc = L["This sets the 'Y offset' value."],
												min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["removablesenablebackdrop"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											spacer6 = { order = 6, type = "description", name = "", desc = "", width = "half"},
											offsetX2 = {
												type = "range", 
												order = 8,
												name = L["Bottom-right X"],
												desc = L["This sets the 'X offset' value."],
												min = -50, softMin = 0, softMax = 10, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["removablesenablebackdrop"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											offsetY2 = {
												type = "range", 
												order = 14,
												name = L["Bottom-right Y"],
												desc = L["This sets the 'Y offset' value."],
												min = -50, softMin = -10, softMax = 0, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["removablesenablebackdrop"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},										
										},
									},
									spacer2 = { order = 16, type = "description", name = "", desc = "", width = "full"},
								},
							},
							spacer29 = { order = 29, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return(not DB.enrage.showsettings2) end },
							removablesborder = {
								type = "group",
								order = 30,
								name = L["Removable buffs border"],
								guiInline = true,
								hidden = function(info) return(not DB.enrage.showsettings2) end,
								args = {
									removablesenableborder = {
										type = "toggle",
										order = 1,
										name = L["Enable"],
										desc = L["DESCBORDER_ENABLE"],
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									removablesbordercolor = {
										type = "color",
										order = 2,
										name = L["Border color"],
										hasAlpha = true,
										disabled = function(info) return not DB.frames.enrage["removablesenableborder"] end,
										get = function(info) return unpack(DB.frames.enrage[info[#info] ]) end,
										set = function(info, r, g, b, a) DB.frames.enrage[info[#info] ] = {r, g, b, a};LockDown(JSHB.SetupEnrageModule) end,
									},
									removablesbordertexture = {
										type = "select",
										dialogControl = 'LSM30_Border',
										order = 3,
										name = L["Border texture"],
										desc = L["Texture that gets used for the bar's background."],
										values = AceGUIWidgetLSMlists.border,
										disabled = function(info) return not DB.frames.enrage["removablesenableborder"] end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									removablesedgesize = {
										type = "range",
										order = 4,
										name = L["Edge size"],
										desc = L["DESCEDGESIZE_ENABLE"],
										min = -100, softMin = -16, softMax = 16, max = 100, step = 1,
										disabled = function(info) return not DB.frames.enrage["removablesenableborder"] end,
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									spacer7 = { order = 7, type = "description", name = "", desc = "", width = "full"},
									removablesbackdropinsets = {
										type = "group",
										order = 10,
										name = L["Insets"],
										guiInline = true,
										args = {
											left = {
												type = "range",
												order = 1,
												name = L["Left"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["removablesenableborder"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											right = {
												type = "range", 
												order = 2,
												name = L["Right"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["removablesenableborder"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											spacer6 = { order = 6, type = "description", name = "", desc = "", width = "half"},
											top = {
												type = "range", 
												order = 8,
												name = L["Top"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["removablesenableborder"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											bottom = {
												type = "range", 
												order = 14,
												name = L["Bottom"],
												min = -50, softMin = -16, softMax = 16, max = 50, step = 1,
												disabled = function(info) return not DB.frames.enrage["removablesenableborder"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},										
										},
									},
								},
							},
							spacer31 = { order = 31, type = "description", name = " ", desc = "", width = "full", hidden = function(info) return(not DB.enrage.showsettings2) end },
							removablestexcoords = {
								type = "group",
								order = 32,
								name = L["Removable Buffs Texture Coords"],
								guiInline = true,
								hidden = function(info) return(not DB.enrage.showsettings2) end,
								args = {						
									removablesenabletexcoords = {
										type = "toggle",
										order = 5,
										name = L["Enable TexCoords"],
										desc = L["DESCTEXCOORDS_ENABLE"],
										get = function(info) return DB.frames.enrage[info[#info] ] end,
										set = function(info, value) DB.frames.enrage[info[#info] ] = value;LockDown(JSHB.SetupEnrageModule) end,
									},
									removablestexcoords = {
										type = "group",
										order = 6,
										name = L["Texture coords"],
										guiInline = true,
										args = {
											left = {
												type = "range",
												order = 2,
												name = L["Left"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.enrage["removablesenabletexcoords"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][1]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][1] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											right = {
												type = "range", 
												order = 4,
												name = L["Right"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.enrage["removablesenabletexcoords"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][2]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][2] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											spacer6 = { order = 6, type = "description", name = " ", desc = "", width = "half"},
											top = {
												type = "range", 
												order = 8,
												name = L["Top"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.enrage["removablesenabletexcoords"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][3]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][3] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},
											bottom = {
												type = "range", 
												order = 10,
												name = L["Bottom"],
												min = 0, max = 1, step = .01,
												disabled = function(info) return not DB.frames.enrage["removablesenabletexcoords"] end,
												get = function(info) return (DB.frames.enrage[info[#info-1] ][4]) end,
												set = function(info, offset) DB.frames.enrage[info[#info-1] ][4] = (offset);LockDown(JSHB.SetupEnrageModule) end,
											},										
										},
									},
								},
							},
						},
					},
					spacer18 = { order = 18, type = "description", name = " ", desc = "", width = "full"},
				},	
			},
			timers1 = {
				order = 8,
				type = "group",
				name = L["Timer Bar 1"],
				guiInline = true,
				childGroups = "tree",
				args = JSHunterBarOptions:CreateTimerSet(1),
			},
			timers2 = {
				order = 10,
				type = "group",
				name = L["Timer Bar 2"],
				guiInline = true,
				childGroups = "tree",
				args = JSHunterBarOptions:CreateTimerSet(2),
			},
			timers3 = {
				order = 12,
				type = "group",
				name = L["Timer Bar 3"],
				guiInline = true,
				childGroups = "tree",
				args = JSHunterBarOptions:CreateTimerSet(3),
			},
			alerts = {
				order = 20,
				type = "group",
				name = L["Alerts"],
				childGroups = "select",
				args = JSHunterBarOptions:CreateAlerts(),
			},
		},
	}
	
	-- Inject the timer set / icon block frames
	--JSHunterBarOptions:CreateFrameTimerSets(jshbOptionsTable.args.frames.args)
	LibStub("AceConfigRegistry-3.0"):NotifyChange("JSHunterBarOptions")
	collectgarbage("collect")
	
	return jshbOptionsTable
end
