--[[

	JS' Hunter Bar LibSharedMedia interface
	
]]

if (not JSHB) then return end

JSHB.defaultFonts = {
	{ text = "Arial Narrow", 		value = "Fonts\\ARIALN.TTF", font = "Fonts\\ARIALN.TTF" },
	{ text = "Big Noodle", 			value = "Interface\\AddOns\\JSHunterBar\\media\\fonts\\BigNoodle.ttf", font = "Interface\\AddOns\\JSHunterBar\\media\\fonts\\BigNoodle.ttf" },
	{ text = "Friz Quadrata TT", 	value = "Fonts\\FRIZQT__.TTF", font = "Fonts\\FRIZQT__.TTF" },
	{ text = "Morpheus", 			value = "Fonts\\MORPHEUS.ttf", font = "Fonts\\MORPHEUS.ttf" },
	{ text = "Skurri", 				value = "Fonts\\skurri.ttf", font = "Fonts\\skurri.ttf" },
}

JSHB.defaultTextures = {
	{ text = "Blank", 				value = "Interface\\AddOns\\JSHunterBar\\media\\textures\\blank.tga", texture = "Interface\\AddOns\\JSHunterBar\\media\\textures\\blank.tga" },
	{ text = "Blizzard",			value = "Interface\\TargetingFrame\\UI-StatusBar", texture = "Interface\\TargetingFrame\\UI-StatusBar" },
	{ text = "Solid", 				value = "Interface\\AddOns\\JSHunterBar\\media\\textures\\solid.tga", texture = "Interface\\AddOns\\JSHunterBar\\media\\textures\\solid.tga"},
}

JSHB.defaultBorders = {
	{ text = "Solid", 				value = "Interface\\AddOns\\JSHunterBar\\media\\textures\\solid.tga", border = "Interface\\AddOns\\JSHunterBar\\media\\textures\\solidborder.tga"},
}

JSHB.defaultSounds = {
	{ text = "Raid Warning",	value = "Sound\\interface\\RaidWarning.wav", sound = "Sound\\interface\\RaidWarning.wav" },
	{ text = "Alliance Bell", 	value = "Sound\\Doodad\\BellTollAlliance.wav", sound = "Sound\\Doodad\\BellTollAlliance.wav" },
	{ text = "Cannon Blast", 	value = "Sound\\Doodad\\Cannon01_BlastA.wav", sound = "Sound\\Doodad\\Cannon01_BlastA.wav" },
	{ text = "Dynamite", 		value = "Sound\\Spells\\DynamiteExplode.wav", sound = "Sound\\Spells\\DynamiteExplode.wav" },
	{ text = "Gong", 			value = "Sound\\Doodad\\G_GongTroll01.wav", sound = "Sound\\Doodad\\G_GongTroll01.wav" },
	{ text = "Horde Bell", 		value = "Sound\\Doodad\\BellTollHorde.wav",	sound = "Sound\\Doodad\\BellTollHorde.wav" },
	{ text = "Serpent", 		value = "Sound\\Creature\\TotemAll\\SerpentTotemAttackA.wav", sound = "Sound\\Creature\\TotemAll\\SerpentTotemAttackA.wav" },
	{ text = "Tribal Bell", 	value = "Sound\\Doodad\\BellTollTribal.wav", sound = "Sound\\Doodad\\BellTollTribal.wav" },	
	{ text = "Classic", 		value = "Sound\\Doodad\\BellTollNightElf.wav", sound = "Sound\\Doodad\\BellTollNightElf.wav" },
	{ text = "Ding", 			value = "Sound\\interface\\AlarmClockWarning3.wav", sound = "Sound\\interface\\AlarmClockWarning3.wav" },
}

function JSHB.GetLibSharedMedia3()

	if (LibStub) and LibStub("LibSharedMedia-3.0", true) then
		return(LibStub("LibSharedMedia-3.0", true) )
	end
	return false
end

function JSHB.updateSharedMedia(mediatype)
	-- Nothing to do.
end

-- Register our media to the global SharedMedia library
if JSHB.GetLibSharedMedia3() then

	for i=1,#JSHB.defaultFonts do
		JSHB.GetLibSharedMedia3():Register("font", JSHB.defaultFonts[i].text, JSHB.defaultFonts[i].font)
	end
	
	for i=1,#JSHB.defaultTextures do
		JSHB.GetLibSharedMedia3():Register("statusbar", JSHB.defaultTextures[i].text, JSHB.defaultTextures[i].texture)
	end
	
	for i=1,#JSHB.defaultBorders do
		JSHB.GetLibSharedMedia3():Register("border", JSHB.defaultBorders[i].text, JSHB.defaultBorders[i].border)
	end
	
	for i=1,#JSHB.defaultSounds do
		JSHB.GetLibSharedMedia3():Register("sound", JSHB.defaultSounds[i].text, JSHB.defaultSounds[i].sound)
	end
	JSHB.GetLibSharedMedia3().RegisterCallback(JSHB, "LibSharedMedia_Registered", "updateSharedMedia")
end
