--[[

	JS' Hunter Bar Global Variables
	
]]

if not JSHB then return end

-- Static variables and simple settings, keeping everything in the JSHB namespace of the addon
JSHB.myAddonName = select(1, ...)
JSHB.myVersion = GetAddOnMetadata( ..., "Version" ):match( "^([%d.]+)" )
JSHB.playerClass = select(2, UnitClass("player") )
JSHB.wowBuild = tonumber(select(4, GetBuildInfo() ), 10)


JSHB.timerPositions = {
	["TOP"] = JSHB.L["TOP"],
	["CENTER"] = JSHB.L["CENTER"],
	["BOTTOM"] = JSHB.L["BOTTOM"],
	["LEFT"] = JSHB.L["LEFT"],
	["RIGHT"] = JSHB.L["RIGHT"],
}

JSHB.chatChannels = {
	["AUTO"] = JSHB.L["Automatic"],
	["RAID"] = JSHB.L["Raid"],
	["YELL"] = JSHB.L["Yell"],
	["OFFICER"] = JSHB.L["Officer"],
	["GUILD"] = JSHB.L["Guild"],
	["BATTLEGROUND"] = JSHB.L["Battleground"],
	["PARTY"] = JSHB.L["Party"],
	["EMOTE"] = JSHB.L["Emote"],
	["SAY"] = JSHB.L["Say"],
	["SELFWHISPER"] = JSHB.L["Self Whisper"],
	["NONE"] = JSHB.L["No Announce"],
}

JSHB.timerOwners = {
	["PLAYERS"] = JSHB.L["Yours"],
	["ANY"] = JSHB.L["Any"],
}

JSHB.alertTypes = {
	["BUFF"] = JSHB.L["Buff"],
	["DEBUFF"] = JSHB.L["Debuff"],
--	["HEALTH"] = JSHB.L["Health"],
	["CAST"] = JSHB.L["Spell Cast Start"],
}

JSHB.classColors = { .67, .84, .45 }

JSHB.targets = {
	["target"] = JSHB.L["Target"],
	["player"] = JSHB.L["Player"],
	["pet"] = JSHB.L["Pet"],
	["focus"] = JSHB.L["Focus"],
	["boss"] = JSHB.L["Any Boss"],
	["boss1"] = JSHB.L["Boss 1"],
	["boss2"] = JSHB.L["Boss 2"],
	["boss3"] = JSHB.L["Boss 3"],
	["boss4"] = JSHB.L["Boss 4"],
	["arena"] = JSHB.L["Any Arena Enemy"],
	["arena1"] = JSHB.L["Arena Enemy 1"],
	["arena2"] = JSHB.L["Arena Enemy 2"],
	["arena3"] = JSHB.L["Arena Enemy 3"],
	["arena4"] = JSHB.L["Arena Enemy 4"],
	["arena5"] = JSHB.L["Arena Enemy 5"],
	["party"] = JSHB.L["Any Party Member"],
	["partypet"] = JSHB.L["Any Party Pet"],
	["raid"] = JSHB.L["Any Raid Member"],
	["raidpet"] = JSHB.L["Any Raid Pet"],
	["vehicle"] = JSHB.L["Vehicle"],
}
