--[[

	JS' Hunter Bar options load on demand
	
	Sets up a main options panel with a "Load on Demand" button to load in the options.
	This allows memory to stay low when options are not being used.
	
]]

if (not JSHB) then return end

function JSHB.LoadOptionsAddon()

	PlaySound("igMainMenuOptionCheckBoxOn")
	
	if JSHB.optionsAreLoaded then return end

	local loaded, reason = LoadAddOn("JSHunterBarOptions")

	if not loaded then
		print(JSHB.L["JSHB_PRE"]..JSHB.L["OPT_LOD_ERR"].."\""..reason.."\"")
	else
		print(JSHB.L["JSHB_PRE"]..JSHB.L["OPT_LOD_OK"])

		JSHB.optionsAreLoaded = true
	end
end

--[[
	Sets up a single, main page for JSHB Options.
	This consists of nothing more than a button to call the function to load in
	the JSHunterBarOptions addon which is Load on Demand.
	Also creates a profile page for easy access to profile changing.
]]
function JSHB.SetupOptionsLOD()

	local lodOptionsTable = {
		type = "group",
		name = "JS' Hunter Bar",		
		args = {
			main = {
				order = 1,
				type = "group",
				name = JSHB.L["General Settings"],
				desc = JSHB.L["General Settings"],
				args = {
					intro = {
						order = 1,
						type = "description",
						name = JSHB.L["JSHB_DESC"].."\n\n\n\n",
					},
					LoD = {
						order = 2,
						type = "group",						
						name = JSHB.L["Load on Demand Options"],
						guiInline = true,
						args = {
							lod = {
								order = 3,
								type = "execute",
								name = JSHB.L["OPT_LOD_BUTTON_TEXT"],
								func = function(info) PlaySound("igMainMenuOptionCheckBoxOn"); JSHB.LoadOptionsAddon(); end,
							},
							loddesc = {
								order = 4,
								type = "description",
								fontSize = "large",
								name = "\n\n"..JSHB.L["OPT_LOD_BUTTON_DESC"],
							},
						},
					},
				},
			},			
		},
	}
	
	-- Register the options table
	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("JSHunterBarOptions", lodOptionsTable)
	
	-- Create a profiles table
	JSHB.profileOptions = LibStub("AceDBOptions-3.0"):GetOptionsTable(JSHB.db)
	LibStub("AceConfig-3.0"):RegisterOptionsTable("JSHunterBarProfiles", JSHB.profileOptions)
	
	-- Setup the actual options panels
	local AceConfigDialog3 = LibStub("AceConfigDialog-3.0")
	JSHB.optionsFrames = {}
	JSHB.optionsFrames.JSHunterBarOptions = AceConfigDialog3:AddToBlizOptions("JSHunterBarOptions", "JS' Hunter Bar", nil, "main")
	JSHB.optionsFrames.Profiles = AceConfigDialog3:AddToBlizOptions("JSHunterBarProfiles", JSHB.L["Profiles"], "JS' Hunter Bar")	

	--[[
		After this function is initially called, it should never be called again.
		
		This will have to be removed later when the options LoD is made to Unload on Demand.
	]]	
	JSHB.SetupOptionsLOD = nil
	collectgarbage("collect") -- Frees up "garbage" memory.
end
