﻿--[[

	JS' Hunter Bar AddOn by TheJS - US-Blackhand
	
]]

-- Make sure we are good with existing global variables
if (not JSHB) then return end

function JSHB:SlashProcessor_JSHB(input)

	local v1, v2 = input:match("^(%S*)%s*(.-)$")
	v1 = v1:lower()

	if (v1 == "") then	
		if (not JSHB.debug) then
			print(format(JSHB.L["SLASHDESC1"], JSHB.myVersion) )
			print("/jsb config - " .. JSHB.L["SLASHDESC2"])
			print("/jsb lock - " .. JSHB.L["SLASHDESC3"])
			print("/jsb reset - " .. JSHB.L["SLASHDESC4"])
		else
			print(JSHB.L["JSHB_PRE"].."Debug Info:")
		end		
	elseif (v1 == "options") or (v1 == "config") or (v1 == "opt") or (v1 == "o") then
		JSHB.LoadOptionsAddon()
		if (JSHB.optionsAreLoaded == true) then
			InterfaceOptionsFrame_OpenToCategory(JSHB.optionsFrames.JSHunterBarOptions)
		end
	elseif (v1 == "reset") then
		if (not InCombatLockdown() ) then
			print(JSHB.L["JSHB_PRE"]..JSHB.L["MOVERSSETTODEFAULT"])
			JSHB.SetDefaultMoversPositions()
		else
			print(JSHB.L["JSHB_PRE"]..JSHB.L["INCOMBATLOCKDOWN"])
		end
	elseif (v1 == "lock") or (v1 == "unlock") or (v1 == "drag") or (v1 == "move") or (v1 == "l") then
		JSHB.ToggleMoversLock()		
	elseif (v1 == "id") or (v1 == "frameid") then
		if GetMouseFocus():GetName() then
			print(format(JSHB.L["JSHB_PRE"]..JSHB.L["SLASHFRAMEID"], GetMouseFocus():GetName() or "nil") )
		end
	elseif (v1 == "tableid") or (v1 == "table") then
		if GetMouseFocus():GetName() then
			print("Table for frame name:", GetMouseFocus():GetName() )
			local key, val
			for key,val in pairs(_G[GetMouseFocus():GetName()]) do
				print("Key: ", key, " Val: ", val)
			end
		end
	else
		print(JSHB.L["JSHB_PRE"]..JSHB.L["INVALIDSLASH"])
	end
end

function JSHB:VARIABLES_LOADED()
	--[[
		Register module configuration functions.
		
		Every module is responsible for destruction before construction
		and de-registering / registering it's own Frame Mover.
	]]	
	JSHB.RegisterConfigFunction("MOD_ENERGYBAR", JSHB.SetupEnergyBarModule) 		-- Energy bar Module	
	JSHB.RegisterConfigFunction("MOD_TIMERS", JSHB.SetupTimersModule) 				-- Timers Module
	JSHB.RegisterConfigFunction("MOD_ENRAGE", JSHB.SetupEnrageModule) 				-- Enrage Module	
	JSHB.RegisterConfigFunction("MOD_CROWDCONTROL", JSHB.SetupCrowdControlModule) 	-- Crowd Control Module	
	JSHB.RegisterConfigFunction("MOD_INDICATORS",JSHB.SetupIndicatorsModule) 		-- Indicators Module
	JSHB.RegisterConfigFunction("MOD_ALERTS", JSHB.SetupAlertsModule) 				-- Alerts Module
	
	--[[
		Globally configure all modules.
	]]
	JSHB.ReconfigureJSHB()
	
	-- Clean up
	JSHB:RegisterEvent("PLAYER_ENTERING_WORLD")
	JSHB:UnregisterEvent("VARIABLES_LOADED")
	JSHB.VARIABLES_LOADED = nil
	collectgarbage("collect")
end

function JSHB:UI_SCALE_CHANGED()
	JSHB.ReconfigureJSHB()
end

function JSHB:ACTIVE_TALENT_GROUP_CHANGED()
	JSHB.ReconfigureJSHB()
end

function JSHB:PLAYER_ENTERING_WORLD()
	JSHB.ReconfigureJSHB()
end

function JSHB:PLAYER_LEVEL_UP()
	JSHB.ReconfigureJSHB()
end

function JSHB:SKILL_LINES_CHANGED()
	JSHB.ReconfigureJSHB()
end

function JSHB:PostChangeProfile()
	if JSHunterBarOptions and JSHB.OptionsAddOnLoaded then 
		JSHunterBarOptions:PopulateDB()
	end
	JSHB.ReconfigureJSHB()
end

function JSHB:OnInitialize()
	-- Code that you want to run when the addon is first loaded goes here.
  
	--[[
		Display the welcome greeting on startup
	]]
	print(format(JSHB.L["GREETING"], JSHB.myVersion) )
	
	--[[
		Register Slash commands for JS' Hunter Bar.
	]]
	JSHB:RegisterChatCommand("jshb", "SlashProcessor_JSHB")
	JSHB:RegisterChatCommand("jsb", "SlashProcessor_JSHB")
	JSHB:RegisterChatCommand("js", "SlashProcessor_JSHB")

	--[[
		JS' Hunter Bar tries to wait for all variables to be loaded before configuring itself.
	]]
	JSHB:RegisterEvent("VARIABLES_LOADED")
	
	--[[
		Setup Saved Variables
	]]
	JSHB.db = LibStub("AceDB-3.0"):New("JSHunterBarDB", JSHB.defaults, true)
	
	--[[
		After the defaults have been fed into AceDB, now we can create defaults for
		things like the timers.  These entries can be totally deleted from the options,
		so they can not be saved as AceDB does when you feed it a default options table
		because it will create 'nil' table entries.
	]]
	JSHB.CheckForNewInstallSetup()
	
	--[[
		Register a reconfigure call for when the user changes profiles.
	]]
	JSHB.db.RegisterCallback(JSHB, "OnProfileChanged", "PostChangeProfile")
	JSHB.db.RegisterCallback(JSHB, "OnProfileCopied", "PostChangeProfile")
	JSHB.db.RegisterCallback(JSHB, "OnProfileReset", "PostChangeProfile")
	
	--[[
		Setup the initial options panels.  This consists of a LoD button and profiles tab.
	]]
	JSHB.SetupOptionsLOD()
	
	--[[
		Register an event to notify JSHB when the addon needs to be reconfigured based on events.
	]]
	JSHB:RegisterEvent("UI_SCALE_CHANGED")
	JSHB:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
	JSHB:RegisterEvent("PLAYER_LEVEL_UP")
	JSHB:RegisterEvent("SKILL_LINES_CHANGED")
	
	collectgarbage("collect") -- Frees up "garbage" memory.
end

--[[function JSHB:OnEnable()
    -- Called when the addon is enabled	
	JSHB.addonDisabled = nil
end

function JSHB:OnDisable()
    -- Called when the addon is disabled
	JSHB.addonDisabled = true
end]]
