--[[

	JS' Hunter Bar indicator frames
	
]]

if (not JSHB) then return end

-- No need to have the hunter mark reminder show if the target has minimal health or low health
local function DoNotShowHuntersMark()

	if (UnitHealthMax("player") * 2) > (UnitHealth("target") ) then
		return true
	end
	return false
end

function JSHB.SetupIndicatorsModule(lockName)

	-- Deconstruction
	if JSHB.F.Indicators then
		-- Hunter's Mark
		if (not lockName) or (lockName == "MOVER_INDICATORS_HUNTERSMARK") then 
			JSHB.DeregisterMovableFrame("MOVER_INDICATORS_HUNTERSMARK")
			if JSHB.F.Indicators.HuntersMark then 
				JSHB.F.Indicators.HuntersMark:Hide()			
				JSHB.F.Indicators.HuntersMark:SetParent(nil)
				JSHB.F.Indicators.HuntersMark = nil
			end
		end
		-- Aspect
		if (not lockName) or (lockName == "MOVER_INDICATORS_ASPECT") then
			JSHB.DeregisterMovableFrame("MOVER_INDICATORS_ASPECT")
			if JSHB.F.Indicators.Aspect then 
				JSHB.F.Indicators.Aspect:Hide()
				JSHB.F.Indicators.Aspect:UnregisterAllEvents()
				JSHB.F.Indicators.Aspect:SetParent(nil)
				JSHB.F.Indicators.Aspect = nil
			end
		end
	end

	if not JSHB.db.profile.indicators.enabled then return end
	
	if (not JSHB.F.Indicators) then JSHB.F.Indicators = {} end
	
	-- Construction
	local INDICATORS_UPDATEINTERVAL = 0.125
	
	-- Hunter's Mark
	if JSHB.db.profile.indicators.huntersmark_enable and ( (not lockName) or (lockName == "MOVER_INDICATORS_HUNTERSMARK") ) --[[and (not MoP glyphed)]] then
	
		-- Create the Frame
		JSHB.F.Indicators.HuntersMark = JSHB.MakeFrame("Frame", "JSHB_INDICATORS_HUNTERSMARK", JSHB.db.profile.indicators.anchor_huntersmark[2] or UIParent)
		JSHB.F.Indicators.HuntersMark:SetSize(JSHB.db.profile.frames.indicators.huntersmark_iconsize, JSHB.db.profile.frames.indicators.huntersmark_iconsize)
		JSHB.F.Indicators.HuntersMark:SetPoint(JSHB.GetActiveAnchor(JSHB.db.profile.indicators.anchor_huntersmark) )

		JSHB.F.Indicators.HuntersMark.Icon = JSHB.F.Indicators.HuntersMark:CreateTexture(nil, "BACKGROUND")
		JSHB.F.Indicators.HuntersMark.Icon:SetTexture("Interface\\Icons\\Ability_Hunter_SniperShot") -- Hunter's Mark texture
		if JSHB.db.profile.frames.indicators.huntersmark_enabletexcoords then
			JSHB.F.Indicators.HuntersMark.Icon:SetTexCoord(unpack(JSHB.db.profile.frames.indicators.huntersmark_texcoords) )
		end
		JSHB.F.Indicators.HuntersMark.Icon:SetAllPoints(JSHB.F.Indicators.HuntersMark)

		JSHB.F.Indicators.HuntersMark.shine = SpellBook_GetAutoCastShine()
		JSHB.F.Indicators.HuntersMark.shine:Show()
		JSHB.F.Indicators.HuntersMark.shine:SetParent(JSHB.F.Indicators.HuntersMark)
		JSHB.F.Indicators.HuntersMark.shine:SetSize(JSHB.db.profile.frames.indicators.huntersmark_iconsize + 3, JSHB.db.profile.frames.indicators.huntersmark_iconsize + 3)
		JSHB.F.Indicators.HuntersMark.shine:SetPoint("CENTER", JSHB.F.Indicators.HuntersMark, "CENTER")	
		
		JSHB.F.Indicators.HuntersMark.background = JSHB.MakeBackground(JSHB.F.Indicators.HuntersMark, JSHB.db.profile.frames.indicators, "huntersmark_")
		JSHB.F.Indicators.HuntersMark:SetAlpha(0)
		JSHB.F.Indicators.HuntersMark:Show()
		
		JSHB.RegisterMovableFrame(
			"MOVER_INDICATORS_HUNTERSMARK",
			JSHB.F.Indicators.HuntersMark,
			JSHB.F.Indicators.HuntersMark,
			JSHB.L["Hunter's Mark Indicator"],
			JSHB.db.profile.indicators,
			JSHB.SetupIndicatorsModule,
			JSHB.defaults.profile.indicators, --JSHB.V.defaults.profile["indicators"],
			JSHB.db.profile.frames.indicators,
			"_huntersmark",
			"huntersmark_"
		)
	
		JSHB.F.Indicators.HuntersMark.updateTimer = 0
		JSHB.F.Indicators.HuntersMark:SetScript("OnUpdate", function(self, elapsed, ...)
	
			self.updateTimer = self.updateTimer + elapsed		
			if self.updateTimer < INDICATORS_UPDATEINTERVAL then return else self.updateTimer = 0 end
			if (not JSHB.moversLocked) then return end

			if (not UnitExists("target") ) or (not UnitReaction("player", "target") ) or (UnitReaction("player", "target") > 4) or UnitIsDeadOrGhost("target") or UnitIsDeadOrGhost("player") or UnitInVehicle("player") or DoNotShowHuntersMark() then
					AutoCastShine_AutoCastStop(JSHB.F.Indicators.HuntersMark.shine)
					JSHB.F.Indicators.HuntersMark:SetAlpha(0)
			else
				local name, _, _, _, _, duration, expirationTime = UnitAura("target", GetSpellInfo(56303), nil, "HARMFUL") -- Any hunter's mark, not just player!
				local nameMFD, _, _, _, _, durationMFD, expirationTimeMFD = UnitAura("target", GetSpellInfo(88691), nil, "HARMFUL") -- Any MFD, not just player!

				-- Mark present and time is above threshold of 15s (HM) / 5s (MFD)
				if (name and ( (expirationTime - GetTime() ) >= 15) ) or (nameMFD and ( (expirationTimeMFD - GetTime() ) >= 5) ) or (nameMFD and JSHB.db.profile.indicators.huntersmark_mfd) then

					-- Hunter's Mark / MFD present with 15s/5s or more remaining duration on target
					AutoCastShine_AutoCastStop(JSHB.F.Indicators.HuntersMark.shine)
					JSHB.F.Indicators.HuntersMark:SetAlpha(0)

				-- Hunter's Mark present, didn't meet above condition, must be under 30s duration remaining.
				elseif name and not (nameMFD and ( (expirationTimeMFD - GetTime() ) >= 5) ) then				
					if (JSHB.F.Indicators.HuntersMark.timer == nil) or (not JSHB.F.Indicators.HuntersMark.timer.enabled) then					
						local timer = JSHB.F.Indicators.HuntersMark.timer or JSHB.Timer_Create(JSHB.F.Indicators.HuntersMark)
						timer.start = GetTime()
						timer.duration = expirationTime - GetTime()
						timer.enabled = true
						timer.nextUpdate = 0
						timer:Show()
					end					
					if InCombatLockdown() then
						AutoCastShine_AutoCastStart(JSHB.F.Indicators.HuntersMark.shine)
					else
						AutoCastShine_AutoCastStop(JSHB.F.Indicators.HuntersMark.shine)
					end					
					JSHB.F.Indicators.HuntersMark:SetAlpha(1)

				-- Hunter's Mark not up but MFD present, didn't meet above conditions, must be under 5s duration remaining.
				elseif nameMFD then				
					if (JSHB.F.Indicators.HuntersMark.timer == nil) or (not JSHB.F.Indicators.HuntersMark.timer.enabled) then
						local timer = JSHB.F.Indicators.HuntersMark.timer or JSHB.Timer_Create(JSHB.F.Indicators.HuntersMark)
						timer.start = GetTime()
						timer.duration = expirationTimeMFD - GetTime()
						timer.enabled = true
						timer.nextUpdate = 0
						timer:Show()
					end					
					if InCombatLockdown() then
						AutoCastShine_AutoCastStart(JSHB.F.Indicators.HuntersMark.shine)
					else
						AutoCastShine_AutoCastStop(JSHB.F.Indicators.HuntersMark.shine)
					end					
					JSHB.F.Indicators.HuntersMark:SetAlpha(1)

				-- Mark is not present at all.
				else					
					if InCombatLockdown() then
						AutoCastShine_AutoCastStart(JSHB.F.Indicators.HuntersMark.shine)
					else
						AutoCastShine_AutoCastStop(JSHB.F.Indicators.HuntersMark.shine)
					end					
					JSHB.F.Indicators.HuntersMark:SetAlpha(1)					
					local timer = JSHB.F.Indicators.HuntersMark.timer or JSHB.Timer_Create(JSHB.F.Indicators.HuntersMark)
					timer.enabled = false
					timer:Hide()
				end
			end
		end)
	end
	
	-- Aspect
	if JSHB.db.profile.indicators.aspect_enable and ( (not lockName) or (lockName == "MOVER_INDICATORS_ASPECT") ) then
	
		-- Create the Frame
		JSHB.F.Indicators.Aspect = JSHB.MakeFrame("Frame", "JSHB_INDICATORS_ASPECT", JSHB.db.profile.indicators.anchor_aspect[2] or UIParent)
		JSHB.F.Indicators.Aspect:SetSize(JSHB.db.profile.frames.indicators.aspect_iconsize, JSHB.db.profile.frames.indicators.aspect_iconsize)
		JSHB.F.Indicators.Aspect:SetPoint(JSHB.GetActiveAnchor(JSHB.db.profile.indicators.anchor_aspect) )

		JSHB.F.Indicators.Aspect.Icon = JSHB.F.Indicators.Aspect:CreateTexture(nil, "BACKGROUND")
		JSHB.F.Indicators.Aspect.Icon:SetTexture("Interface\\Buttons\\UI-GroupLoot-Pass-Up")
		
		if JSHB.db.profile.frames.indicators.aspect_enabletexcoords then
			JSHB.F.Indicators.Aspect.Icon:SetTexCoord(unpack(JSHB.db.profile.frames.indicators.aspect_texcoords) )
		end
		JSHB.F.Indicators.Aspect.Icon:SetAllPoints(JSHB.F.Indicators.Aspect)
	
		JSHB.F.Indicators.Aspect.shine = SpellBook_GetAutoCastShine()
		JSHB.F.Indicators.Aspect.shine:Show()
		JSHB.F.Indicators.Aspect.shine:SetParent(JSHB.F.Indicators.Aspect)
		JSHB.F.Indicators.Aspect.shine:SetSize(JSHB.db.profile.frames.indicators.aspect_iconsize + 3, JSHB.db.profile.frames.indicators.aspect_iconsize + 3)
		JSHB.F.Indicators.Aspect.shine:SetPoint("CENTER", JSHB.F.Indicators.Aspect, "CENTER")
		
		-- Create the Background and border if the user wants one
		JSHB.F.Indicators.Aspect.background = JSHB.MakeBackground(JSHB.F.Indicators.Aspect, JSHB.db.profile.frames.indicators, "aspect_")
		JSHB.F.Indicators.Aspect:SetAlpha(1)
		JSHB.F.Indicators.Aspect:Show()
		
		JSHB.RegisterMovableFrame(
			"MOVER_INDICATORS_ASPECT",
			JSHB.F.Indicators.Aspect,
			JSHB.F.Indicators.Aspect,
			JSHB.L["Aspect Indicator"],
			JSHB.db.profile.indicators,
			JSHB.SetupIndicatorsModule,
			JSHB.defaults.profile.indicators, --JSHB.V.defaults.profile["indicators"],
			JSHB.db.profile.frames.indicators,
			"_aspect",
			"aspect_"
		)

		local function DoAspectUpdate(self)
			-- Set the proper texture for the current (or missing) aspect
			if (GetShapeshiftForm() > 0) then -- There is an aspect up
				local _, name = GetShapeshiftFormInfo(GetShapeshiftForm() )
				local _, _, tex = GetSpellInfo(name)
				if self.Icon:GetTexture() ~= tex then
					self.Icon:SetTexture(tex)
				end
			elseif self.Icon:GetTexture() ~= "Interface\\Buttons\\UI-GroupLoot-Pass-Up" then
				self.Icon:SetTexture("Interface\\Buttons\\UI-GroupLoot-Pass-Up")
			end
			
			if InCombatLockdown() then
				if ( (GetShapeshiftForm() == 0) or (GetShapeshiftForm() == 3) or (GetShapeshiftForm() == 4) ) and (not UnitInVehicle("player") ) then -- missing or cheetah/pack
					JSHB.F.Indicators.Aspect:SetAlpha(1)
					AutoCastShine_AutoCastStart(JSHB.F.Indicators.Aspect.shine)
				elseif (not JSHB.db.profile.indicators.aspect_onlymissing) and (not UnitInVehicle("player") ) then -- good aspect, only missing not set
					JSHB.F.Indicators.Aspect:SetAlpha(1)
					AutoCastShine_AutoCastStop(JSHB.F.Indicators.Aspect.shine)
				else
					JSHB.F.Indicators.Aspect:SetAlpha(0)
					AutoCastShine_AutoCastStop(JSHB.F.Indicators.Aspect.shine)
				end
			else -- Not in combat!
				if ( (GetShapeshiftForm() == 0) or (GetShapeshiftForm() == 3) or (GetShapeshiftForm() == 4) ) and (not JSHB.db.profile.indicators.aspect_onlycombat) and (not UnitInVehicle("player") ) then -- missing or cheetah/pack
					JSHB.F.Indicators.Aspect:SetAlpha(1)
					AutoCastShine_AutoCastStop(JSHB.F.Indicators.Aspect.shine)
				elseif (not JSHB.db.profile.indicators.aspect_onlymissing) and (not JSHB.db.profile.indicators.aspect_onlycombat) and (not UnitInVehicle("player") ) then -- good aspect, only missing not set
					JSHB.F.Indicators.Aspect:SetAlpha(1)
					AutoCastShine_AutoCastStop(JSHB.F.Indicators.Aspect.shine)
				else
					JSHB.F.Indicators.Aspect:SetAlpha(0)
					AutoCastShine_AutoCastStop(JSHB.F.Indicators.Aspect.shine)
				end			
			end
		end
		
		JSHB.F.Indicators.Aspect.updateTimer = 0
		JSHB.F.Indicators.Aspect:SetScript("OnUpdate", function(self, elapsed, ...)	
			self.updateTimer = self.updateTimer + elapsed		
			if self.updateTimer < INDICATORS_UPDATEINTERVAL then return else self.updateTimer = 0 end
			if (not JSHB.moversLocked) then return end			
			DoAspectUpdate(self)
		end)

	end
end
	