--[[

	JS' Hunter Bar enrage module (for tranquelizing shot alert)
	
]]

if (not JSHB) then return end

local enrageTexture = "Interface\\Icons\\Spell_Nature_Drowsy" -- 19801 (Tranq Shot)

local enrageAlerts = {
	92967, -- BWD: Maloriak 
	80084, -- BWD: Maimgor
	80158, --  SC: Warbringers
	91543, -- BWD: Arcanotron - Power Conversion
	81706, --  TV: Lockmaw - Venomous Rage
	36828, -- BOT: Crossfires
	
--	61573, -- Alliance banner to test dummy for horde side toon
}

function JSHB.SetupEnrageModule(lockName)

	-- Deconstruction
	if JSHB.F.EnrageAlert then
		if (not lockName) or (lockName == "MOVER_ENRAGEALERT") then
			JSHB.F.EnrageAlert:Hide()
			JSHB.F.EnrageAlert:UnregisterAllEvents()
			JSHB.DeregisterMovableFrame("MOVER_ENRAGEALERT")
			JSHB.F.EnrageAlert:SetParent(nil)
			JSHB.F.EnrageAlert = nil
		end
	end
	
	if JSHB.F.EnrageAlertRemovables then
		if (not lockName) or (lockName == "MOVER_ENRAGEREMOVABLES") then
			JSHB.F.EnrageAlertRemovables:Hide()
			JSHB.DeregisterMovableFrame("MOVER_ENRAGEREMOVABLES")
			JSHB.F.EnrageAlertRemovables:SetParent(nil)
			JSHB.F.EnrageAlertRemovables = nil
		end
	end
	
	if not JSHB.db.profile.enrage.enabled then return end
	
	-- Construction
	local ENRAGE_UPDATEINTERVAL = 0.1

	if ( (not lockName) or (lockName == "MOVER_ENRAGEALERT") ) then
		-- Create the Frame
		JSHB.F.EnrageAlert = JSHB.MakeFrame("Frame", "JSHB_ENRAGEALERT", JSHB.db.profile.enrage.anchor[2] or UIParent)
		JSHB.F.EnrageAlert:SetSize(JSHB.db.profile.frames.enrage.iconsize, JSHB.db.profile.frames.enrage.iconsize)
		JSHB.F.EnrageAlert:SetPoint(JSHB.GetActiveAnchor(JSHB.db.profile.enrage.anchor) )

		JSHB.F.EnrageAlert.Icon = JSHB.F.EnrageAlert:CreateTexture(nil, "BACKGROUND")
		JSHB.F.EnrageAlert.Icon:SetTexture(enrageTexture)
		if JSHB.db.profile.frames.enrage.enabletexcoords then
			JSHB.F.EnrageAlert.Icon:SetTexCoord(unpack(JSHB.db.profile.frames.enrage.texcoords) )
		end
		JSHB.F.EnrageAlert.Icon:SetAllPoints(JSHB.F.EnrageAlert)

		-- Add sparkle to make it more noticable
		JSHB.F.EnrageAlert.shine = SpellBook_GetAutoCastShine()
		JSHB.F.EnrageAlert.shine:Show()
		JSHB.F.EnrageAlert.shine:SetParent(JSHB.F.EnrageAlert)
		JSHB.F.EnrageAlert.shine:SetSize(JSHB.db.profile.frames.enrage.iconsize + 3, JSHB.db.profile.frames.enrage.iconsize + 3)
		JSHB.F.EnrageAlert.shine:SetPoint("CENTER", JSHB.F.EnrageAlert, "CENTER")
		
		-- Create the Background and border if the user wants one
		JSHB.F.EnrageAlert.background = JSHB.MakeBackground(JSHB.F.EnrageAlert, JSHB.db.profile.frames.enrage)

		JSHB.F.EnrageAlert:SetAlpha(0)
		JSHB.F.EnrageAlert:Show()
		
		JSHB.RegisterMovableFrame(
			"MOVER_ENRAGEALERT",
			JSHB.F.EnrageAlert,
			JSHB.F.EnrageAlert,
			JSHB.L["Tranq Alert"],
			JSHB.db.profile.enrage,
			JSHB.SetupEnrageModule,
			JSHB.defaults.profile.enrage, --JSHB.V["defaults"].profile.enrage,
			JSHB.db.profile.frames.enrage
		)
		
		JSHB.F.EnrageAlert.updateTimer = 0
		JSHB.F.EnrageAlert:SetScript("OnUpdate", function(self, elapsed)

			self.updateTimer = self.updateTimer + elapsed
		
			if self.updateTimer <= ENRAGE_UPDATEINTERVAL then return else self.updateTimer = 0 end
		
			if (not JSHB.moversLocked) then return end

			if (not UnitExists("target") ) or (UnitExists("target") and UnitIsFriend("player", "target") ) or UnitIsDeadOrGhost("player") then
				AutoCastShine_AutoCastStop(self.shine)
				self:SetAlpha(0)
				self.amShowing = nil
				return
			else
				local x
				for x=1,#enrageAlerts do
					if UnitAura("target", GetSpellInfo(enrageAlerts[x]), nil, "HELPFUL") then
						if not self.amShowing then
							AutoCastShine_AutoCastStart(self.shine)
							self:SetAlpha(1)
							if JSHB.db.profile.enrage.enablesound then
								PlaySoundFile(JSHB.GetLibSharedMedia3():Fetch("sound", JSHB.db.profile.enrage.sound), JSHB.db.profile.masteraudio and "Master" or nil)
							end
							self.amShowing = true
							return
						else
							return
						end
					end
				end
			end
			self:SetAlpha(0)
			self.amShowing = nil
		end)
	end

	if ( (not lockName) or (lockName == "MOVER_ENRAGEREMOVABLES") ) then
		--[[ Notification setup
		if JSHB.db.profile.enrage.removednotify == true then
			JSHB.F.EnrageAlert:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
			JSHB.F.EnrageAlert:SetScript("OnEvent", function(self, event, ...)
				-- 4.2 local timeStamp, subEvent, hideCaster, sourceGUID, sourceName, sourceFlags, sourceFlags2, destGUID, destName, destFlags, destFlags2, spellId, spellName, spellSchool, extraSpellID, extraSpellName, extraSchool, auraType = ...
				local subEvent, sourceGUID, destGUID, destName, spellId, spellName, extraSpellID, extraSpellName
				_, subEvent, _, sourceGUID, _, _, _, destGUID, destName, _, _, spellId, spellName, _, extraSpellID, extraSpellName = ...
				
				if (subEvent == "SPELL_DISPEL") and (sourceGUID == UnitGUID("player") ) and (destGUID ~= UnitGUID("pet") ) then
					if JSHB.GetChatChan(JSHB.db.profile.enrage[strlower(JSHB.GetGroupType() ).."chan"]) ~= "NONE" then
						SendChatMessage("\124cff71d5ff|Hspell:" .. spellId .. "\124h[" .. spellName .. "]\124h\124r" .. JSHB.L["ENRAGEREMOVED"] .. "\124cff71d5ff\124Hspell:" .. extraSpellID .. "\124h[" .. extraSpellName .. "]\124h\124r"
							.. JSHB.L["ENRAGEREMOVEDFROM"] .. destName .. ".", JSHB.GetChatChan(JSHB.db.profile.enrage[strlower(JSHB.GetGroupType() ).."chan"]), nil, GetUnitName("player") )
					end
				end
			end)
		end]]

		-- Removables setup
		if not JSHB.db.profile.enrage.enableremovables then return end
		
		JSHB.F.EnrageAlertRemovables = JSHB.MakeFrame("Frame", "JSHB_ENRAGEALERT_REMOVABLES", JSHB.db.profile.enrage.anchor_removables[2] or UIParent)
		JSHB.F.EnrageAlertRemovables:SetSize(50,50) -- Temp size, we'll re-set this after we create the buff frames to get proper offsets
		JSHB.F.EnrageAlertRemovables:SetPoint(JSHB.GetActiveAnchor(JSHB.db.profile.enrage.anchor_removables) )

		JSHB.F.EnrageAlertRemovables.buffFrames = {}
		
		local i
		for i=1,40 do
			JSHB.F.EnrageAlertRemovables.buffFrames[i] = JSHB.MakeFrame("Frame", nil, JSHB.F.EnrageAlertRemovables)
			JSHB.F.EnrageAlertRemovables.buffFrames[i]:SetSize(JSHB.db.profile.frames.enrage.iconsizeremovables, JSHB.db.profile.frames.enrage.iconsizeremovables)		
			JSHB.F.EnrageAlertRemovables.buffFrames[i]:SetPoint("CENTER", JSHB.F.EnrageAlertRemovables, "CENTER") -- Temporary

			JSHB.F.EnrageAlertRemovables.buffFrames[i].Icon = JSHB.F.EnrageAlertRemovables.buffFrames[i]:CreateTexture(nil, "BACKGROUND")
			JSHB.F.EnrageAlertRemovables.buffFrames[i].Icon:SetAllPoints(JSHB.F.EnrageAlertRemovables.buffFrames[i])
			JSHB.F.EnrageAlertRemovables.buffFrames[i].Icon:SetTexture("Interface\Icons\Spell_Nature_Drowsy") -- Temporary
			if JSHB.db.profile.frames.enrage.removablesenabletexcoords then
				JSHB.F.EnrageAlert.Icon:SetTexCoord(unpack(JSHB.db.profile.frames.enrage.removablestexcoords) )
			end

			JSHB.F.EnrageAlertRemovables.buffFrames[i].background = JSHB.MakeBackground(JSHB.F.EnrageAlertRemovables.buffFrames[i], JSHB.db.profile.frames.enrage, "removables")
			
			JSHB.F.EnrageAlertRemovables.buffFrames[i]:ClearAllPoints() -- Now that we made the backdrop/border we have offsets to use.

			-- Flip expanding left to right or right to left depending on anchor point X
			local xPos = ( (JSHB.db.profile.frames.enrage.iconsizeremovables +
						(JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[i], "LEFT", 1) + JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[i], "RIGHT", 1) + 2) )
							* mod(i-1, 8) )
			
			local yPos = (JSHB.db.profile.frames.enrage.iconsizeremovables +  -- Vertical Offset
						(JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[i], "TOP", 1) + JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[i], "BOTTOM", 1) + 2) )
							* floor( (i-1) / 8)

			if JSHB.db.profile.enrage.anchor_removables[4] >= 0 then
				JSHB.F.EnrageAlertRemovables.buffFrames[i]:SetPoint("TOPLEFT", JSHB.F.EnrageAlertRemovables, "TOPLEFT", xPos, -yPos)
			else
				JSHB.F.EnrageAlertRemovables.buffFrames[i]:SetPoint("TOPRIGHT", JSHB.F.EnrageAlertRemovables, "TOPRIGHT", -xPos, -yPos)
			end
							
			JSHB.F.EnrageAlertRemovables.buffFrames[i]:SetAlpha(1)
			JSHB.F.EnrageAlertRemovables.buffFrames[i]:Hide()
			JSHB.F.EnrageAlertRemovables.buffFrames[i].spellID = 0
			
			if JSHB.db.profile.enrage.removablestips then
				JSHB.F.EnrageAlertRemovables.buffFrames[i]:SetScript("OnEnter", function(self)
					if (self.spellID == 0) then return end
					local index
					for index=1,40 do
						if (select(11, UnitBuff("target", index) ) == self.spellID) then
							GameTooltip:SetOwner(self)
							GameTooltip:SetUnitBuff("target", index)
							GameTooltip:Show()
							return
						end
					end
				end)
				JSHB.F.EnrageAlertRemovables.buffFrames[i]:SetScript("OnLeave", function(self)
					if self.spellID == 0 then return end
					GameTooltip:Hide()
				end)
			end
		end
		
		-- Now we can properly set the size of the parent frame for the buff icons because we now have offsets.
		JSHB.F.EnrageAlertRemovables:SetSize(		
			( (JSHB.db.profile.frames.enrage.iconsizeremovables + -- WIDTH
				(JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[1], "LEFT", 1) + JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[1], "RIGHT", 1) + 2) ) * 8) 
				- JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[1], "LEFT", 1) - JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[1], "RIGHT", 1) - 2,
			( (JSHB.db.profile.frames.enrage.iconsizeremovables + -- HEIGHT
				(JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[1], "TOP", 1) + JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[1], "BOTTOM", 1) + 2) ) * 5) 
				- JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[1], "LEFT", 1) - JSHB.GetFrameOffset(JSHB.F.EnrageAlertRemovables.buffFrames[1], "RIGHT", 1) - 2)

		-- Register the mover frame
		JSHB.RegisterMovableFrame(
			"MOVER_ENRAGEREMOVABLES",
			JSHB.F.EnrageAlertRemovables,
			JSHB.F.EnrageAlertRemovables,
			JSHB.L["Tranq Alert Removable Buffs"],
			JSHB.db.profile.enrage,
			JSHB.SetupEnrageModule,
			JSHB.defaults.profile.enrage, --JSHB.V["defaults"].profile["enrage"],
			JSHB.db.profile.frames.enrage,
			"_removables"
		)
		
		JSHB.F.EnrageAlertRemovables.updateTimer = 0
		JSHB.F.EnrageAlertRemovables:SetScript("OnUpdate", function(self, elapsed, ...)
		
			self.updateTimer = self.updateTimer + elapsed		
			if self.updateTimer < ENRAGE_UPDATEINTERVAL then return else self.updateTimer = 0 end
			
			local i
			if (not UnitCanAttack("player", "target") ) or (JSHB.db.profile.frames.enrage.removablespvponly and (JSHB.GetGroupType() ~= "ARENA") and (JSHB.GetGroupType() ~= "BATTLEGROUND") ) then
				for i=1,40 do
					JSHB.F.EnrageAlertRemovables.buffFrames[i].spellID = 0
					JSHB.F.EnrageAlertRemovables.buffFrames[i]:Hide()
				end			
			else
				local j = 1
				for i=1,40 do			
					local name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellId  = UnitBuff("target", i)
					if debuffType == "Magic" then
						JSHB.F.EnrageAlertRemovables.buffFrames[j].spellID = spellId
						JSHB.F.EnrageAlertRemovables.buffFrames[j].Icon:SetTexture(select(3, GetSpellInfo(spellId) )) --"Interface\\Icons\\Spell_Nature_Drowsy")
						if JSHB.db.profile.frames.enrage.removablesenabletexcoords then
							JSHB.F.EnrageAlert.Icon:SetTexCoord(unpack(JSHB.db.profile.frames.enrage.removablestexcoords) )
						end
						JSHB.F.EnrageAlertRemovables.buffFrames[j]:Show()
						j = j + 1
					end
				end			
				for i=j,40 do
					JSHB.F.EnrageAlertRemovables.buffFrames[i]:Hide()
					JSHB.F.EnrageAlertRemovables.buffFrames[i].spellID = 0
				end
			end
		end)
	end
end
