--[[

	JS' Hunter Bar focus bar module
	
]]

if (not JSHB) then return end

local t13ItemsFound, t13ItemID, adjustment = 0
JSHB.predictionSpellBase = 9

--[[
	Check how many tier 13 items we have on
	
	This code was originally added by ???
]]
local function PlayerHasT13Bonus()
	t13ItemsFound = 0
	
	-- Tier 13 2 piece bonus
	-- Hands
	t13ItemID = GetInventoryItemID("player", 10)
	if (t13ItemID and ( (t13ItemID == 78769) or (t13ItemID == 77029) or (t13ItemID == 78674) ) ) then
		t13ItemsFound = t13ItemsFound + 1
	end
	-- Shoulders
	t13ItemID = GetInventoryItemID("player", 3)
	if (t13ItemID and ( (t13ItemID == 78832) or (t13ItemID == 77032) or (t13ItemID == 78737) ) ) then
		t13ItemsFound = t13ItemsFound + 1
	end
	-- Chest
	t13ItemID = GetInventoryItemID("player", 5)
	if (t13ItemID and ( (t13ItemID == 78756) or (t13ItemID == 77028) or (t13ItemID == 78661) ) ) then
		t13ItemsFound = t13ItemsFound + 1
	end
	-- Legs
	t13ItemID = GetInventoryItemID("player", 7)
	if (t13ItemID and ( (t13ItemID == 78804) or (t13ItemID == 77031) or (t13ItemID == 78709) ) ) then
		t13ItemsFound = t13ItemsFound + 1
	end
	-- Head
	t13ItemID = GetInventoryItemID("player", 1)
	if (t13ItemID and ( (t13ItemID == 78793) or (t13ItemID == 77030) or (t13ItemID == 78698) ) ) then
		t13ItemsFound = t13ItemsFound + 1
	end
	
	return ( (t13ItemsFound > 1) and true or false)
end

-- Prediction of new value for focus based on talents and items
local function getPredictionAdjustment()
	adjustment = 0
	-- Account for Termination talent extra focus
	if UnitHealth("target") / UnitHealthMax("target") <= 0.25 then 
		adjustment = adjustment + (select(5, GetTalentInfo(2, 12) ) * 3) -- Termination base per point = 3
	end
	-- Account for the T13 2-Piece bonus
	if PlayerHasT13Bonus() then
		adjustment = adjustment + JSHB.predictionSpellBase
	end	
	return (adjustment)
end

local function getBarColor(prediction)

	if not prediction then prediction = 0 end

	-- class colored is turned on
	if JSHB.db.profile.frames.energybar.classcolored then
		-- high warning conditions
		if JSHB.db.profile.energybar.highwarn and ( ( (UnitPower("player") + prediction) / UnitPowerMax("player") ) >= JSHB.db.profile.energybar.highwarnthreshold) then
			-- class colored but over high threshold
			return JSHB.db.profile.frames.energybar.barcolorhigh
		elseif JSHB.db.profile.energybar.lowwarn and ( (UnitPower("player") + prediction) < JSHB.GetMainSpellCost() ) then
			-- Focus is lower than main shot
			return JSHB.db.profile.frames.energybar.barcolorlow
		else
			-- Tick coloring overrides the norm bar color but not high/low warnings
			if (JSHB.db.profile.energybar.ticks[1][1] == true) and (JSHB.F.EnergyBar["indicatorTick1"]) then
			
				local i, name, cost
				local tColor, tCost = nil, 0
				for i=1,5 do
					if (JSHB.db.profile.energybar.ticks[i][1] == true) and (JSHB.F.EnergyBar["indicatorTick"..i]) and (JSHB.db.profile.energybar.ticks[i][4] == true) then
						if (i > 1) then
							name, _, _, cost = GetSpellInfo(JSHB.db.profile.energybar.ticks[i][2])
						end
						if (i == 1) or ( (i > 1) and name and cost and (cost > 0) ) then						
							if (i == 1) then
								if (UnitPower("player") >= JSHB.GetMainSpellCost() ) then							
									tCost = JSHB.GetMainSpellCost()
									tColor = JSHB.db.profile.energybar.ticks[i][5]
								end								
							elseif (JSHB.db.profile.energybar.ticks[i][3] == true) and (UnitPower("player") >= (JSHB.GetMainSpellCost() + cost) ) and ( (JSHB.GetMainSpellCost() + cost) > tCost) then							
								tCost = JSHB.GetMainSpellCost() + cost
								tColor = JSHB.db.profile.energybar.ticks[i][5]								
							elseif (UnitPower("player") >= cost) and (cost > tCost) and (cost > tCost) and (JSHB.db.profile.energybar.ticks[i][3] ~= true) then							
								tCost = cost
								tColor = JSHB.db.profile.energybar.ticks[i][5]
							end
						end					
					end
				end
				
				if tColor then
					return tColor
				else
					return { (unpack(JSHB.classColors) ), 1 }
				end
			else
				-- class colored not over high threshold or high threshold is turned off
				return { (unpack(JSHB.classColors) ), 1 }
			end
		end

	-- class colored is not turned on
	elseif JSHB.db.profile.energybar.highwarn and ( ( (UnitPower("player") + prediction) / UnitPowerMax("player") ) >= JSHB.db.profile.energybar.highwarnthreshold) then
		-- over the threshold enabled, set to the high warning color	
		return JSHB.db.profile.frames.energybar.barcolorhigh
	elseif JSHB.db.profile.energybar.lowwarn and ( (UnitPower("player") + prediction) < JSHB.GetMainSpellCost() ) then
		-- Focus is lower than main shot
		return JSHB.db.profile.frames.energybar.barcolorlow
	else
		-- Tick coloring overrides the norm bar color but not high/low warnings
		if (JSHB.db.profile.energybar.ticks[1][1] == true) and (JSHB.F.EnergyBar["indicatorTick1"]) then
			local i, name, cost
			local tColor, tCost = nil, 0
			for i=1,5 do
				if (JSHB.db.profile.energybar.ticks[i][1] == true) and (JSHB.F.EnergyBar["indicatorTick"..i]) and (JSHB.db.profile.energybar.ticks[i][4] == true) then
					if (i > 1) then
						name, _, _, cost = GetSpellInfo(JSHB.db.profile.energybar.ticks[i][2])
					end
					if (i == 1) or ( (i > 1) and name and cost and (cost > 0) ) then					
						if (i == 1) then
							if (UnitPower("player") >= JSHB.GetMainSpellCost() ) then						
								tCost = JSHB.GetMainSpellCost()
								tColor = JSHB.db.profile.energybar.ticks[i][5]
							end							
						elseif (JSHB.db.profile.energybar.ticks[i][3] == true) and (UnitPower("player") >= (JSHB.GetMainSpellCost() + cost) ) and ( (JSHB.GetMainSpellCost() + cost) > tCost) then						
							tCost = JSHB.GetMainSpellCost() + cost
							tColor = JSHB.db.profile.energybar.ticks[i][5]							
						elseif (UnitPower("player") >= cost) and (cost > tCost) and (JSHB.db.profile.energybar.ticks[i][3] ~= true) then						
							tCost = cost
							tColor = JSHB.db.profile.energybar.ticks[i][5]
						end
					end					
				end
			end
			
			if tColor then
				return tColor
			else
				return JSHB.db.profile.frames.energybar.barcolor
			end
		else
			-- class colored not over high threshold or high threshold is turned off
			return JSHB.db.profile.frames.energybar.barcolor
		end
	end
end

local function updatePrediction()

	if JSHB.db.profile.energybar.enableprediction and JSHB.F.EnergyBar.playerIsCasting then

		-- Add values if AotF active and talent points, and Termination points
		local prediction = JSHB.predictionSpellBase + getPredictionAdjustment()
		local barColor = getBarColor(prediction)
		
		JSHB.F.EnergyBar.PredictionFrame:SetSize(
			(JSHB.F.EnergyBar:GetWidth() / 100) * prediction, JSHB.F.EnergyBar:GetHeight() )

		JSHB.F.EnergyBar.PredictionFrame:ClearAllPoints()
		JSHB.F.EnergyBar.PredictionFrame:SetPoint("LEFT", JSHB.F.EnergyBar, "LEFT",
			JSHB.F.EnergyBar:GetWidth() / (select(2, JSHB.F.EnergyBar:GetMinMaxValues() ) / JSHB.F.EnergyBar:GetValue() ), 0)

		if (UnitPower("player") + prediction) > UnitPowerMax("player") then
			JSHB.F.EnergyBar.PredictionFrame:SetSize(
				(JSHB.F.EnergyBar:GetWidth() / 100) * (UnitPowerMax("player") - UnitPower("player") ), JSHB.F.EnergyBar:GetHeight() )			
		end
		
		JSHB.F.EnergyBar.PredictionFrame:SetStatusBarColor(barColor[1], barColor[2], barColor[3], 1)
		
		if ( (UnitPowerMax("player") - UnitPower("player") ) > 0) and (not UnitIsDeadOrGhost("player") ) then
			JSHB.F.EnergyBar.PredictionFrame:SetAlpha(JSHB.F.EnergyBar:GetAlpha() * 0.6)
			JSHB.F.EnergyBar.PredictionFrame:Show()
		else
			JSHB.F.EnergyBar.PredictionFrame:Hide()
		end
	end
end

function JSHB.SetupEnergyBarModule()

	-- Destruction
	local i = 1
	if JSHB.F.StackBars then
		while JSHB.F.StackBars[i] ~= nil do
			JSHB.F.StackBars[i]:Hide()
			JSHB.F.StackBars[i]:UnregisterAllEvents()
			JSHB.F.StackBars[i]:SetScript("OnUpdate", nil)
			JSHB.F.StackBars[i]:SetParent(nil)
			JSHB.F.StackBars[i] = nil
			i = i + 1
		end
		JSHB.F.StackBars = nil
	end
	
	if JSHB.F.StackBarsHost then
		JSHB.F.StackBarsHost:Hide()
		JSHB.DeregisterMovableFrame("MOVER_STACKBARS")
		JSHB.F.StackBarsHost:SetParent(nil)
		JSHB.F.StackBarsHost = nil
	end
	
	if JSHB.F.EnergyBar then
		JSHB.F.EnergyBar:Hide()
		if JSHB.F.EnergyBar.autoShotFrame and JSHB.F.EnergyBar.autoShotFrame.smoother then
			JSHB.RemoveSmooth(JSHB.F.EnergyBar.autoShotFrame)
		end
		if JSHB.F.EnergyBar.smoother then
			JSHB.RemoveSmooth(JSHB.F.EnergyBar)
		end
		if JSHB.F.EnergyBar.PredictionFrame then			
			JSHB.F.EnergyBar:UnregisterEvent("UNIT_SPELLCAST_START")
			JSHB.F.EnergyBar:UnregisterEvent("UNIT_SPELLCAST_STOP")
			JSHB.F.EnergyBar:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED")
			JSHB.F.EnergyBar:UnregisterEvent("UNIT_SPELLCAST_FAILED")
		end		
		JSHB.DeregisterMovableFrame("MOVER_ENERGYBAR")
		JSHB.F.EnergyBar:SetParent(nil)
		JSHB.F.EnergyBar = nil
	end
		
	-- Construction
	if JSHB.db.profile.energybar.enabled then

		local ENERGYBAR_UPDATEINTERVAL = 0.07

		-- Create the Frame
		JSHB.F.EnergyBar = JSHB.MakeFrame("StatusBar", "JSHB_ENERGYBAR", JSHB.db.profile.energybar.anchor[2] or UIParent)
		JSHB.F.EnergyBar:SetStatusBarTexture(JSHB.GetLibSharedMedia3():Fetch("statusbar", JSHB.db.profile.frames.energybar.bartexture) )
		JSHB.F.EnergyBar:SetMinMaxValues(0, (UnitPowerMax("player") > 0) and UnitPowerMax("player") or 100)	
		JSHB.F.EnergyBar:SetStatusBarColor(JSHB.db.profile.frames.energybar.classcolored and
			(unpack({ unpack(JSHB.classColors), 1})) or unpack(JSHB.db.profile.frames.energybar.barcolor) )
		JSHB.F.EnergyBar:SetSize(JSHB.db.profile.frames.energybar.width, JSHB.db.profile.frames.energybar.height)
		JSHB.F.EnergyBar:SetPoint(JSHB.GetActiveAnchor(JSHB.db.profile.energybar.anchor) )
		JSHB.F.EnergyBar:SetAlpha(0)
		JSHB.F.EnergyBar:SetValue(UnitPower("player") )
		
		-- Create the Background and border if the user wants one
		JSHB.F.EnergyBar.background = JSHB.MakeBackground(JSHB.F.EnergyBar, JSHB.db.profile.frames.energybar)

		JSHB.RegisterMovableFrame(
			"MOVER_ENERGYBAR",
			JSHB.F.EnergyBar,
			JSHB.F.EnergyBar,
			JSHB.L["Focus Bar"],
			JSHB.db.profile.energybar,
			JSHB.SetupEnergyBarModule,
			JSHB.defaults.profile.energybar, -- Serenity.V["classspecific_defaults"][Serenity.V["playerclass"] ]["energybar"], -- changed for JSHB
			JSHB.db.profile.frames.energybar
		)
		
		if JSHB.db.profile.energybar.smoothbar then
			JSHB.MakeSmooth(JSHB.F.EnergyBar)		
		end
		
		if JSHB.db.profile.energybar.energynumber then		
			JSHB.F.EnergyBar.value = JSHB.F.EnergyBar:CreateFontString(nil, "OVERLAY")
			JSHB.F.EnergyBar.value:SetJustifyH("CENTER")
			JSHB.F.EnergyBar.value:SetPoint("CENTER", JSHB.F.EnergyBar, "CENTER", JSHB.db.profile.frames.energybar.energyfontoffset,
				(JSHB.db.profile.energybar.shotbar == true) and 2 or 0)
			JSHB.F.EnergyBar.value:SetFont(JSHB.GetActiveFont(JSHB.db.profile.frames.energybar.energyfont) )
			JSHB.F.EnergyBar.value:SetTextColor(unpack(JSHB.db.profile.frames.energybar.energyfontcolor) )
			JSHB.F.EnergyBar.value:SetText(UnitPower("player") )
		end

		if JSHB.db.profile.energybar.targethealth then		
			JSHB.F.EnergyBar.targetHealthValue = JSHB.F.EnergyBar:CreateFontString(nil, "OVERLAY")
			JSHB.F.EnergyBar.targetHealthValue:SetJustifyH("LEFT")
			JSHB.F.EnergyBar.targetHealthValue:SetPoint("LEFT", JSHB.F.EnergyBar, "LEFT", 1 + JSHB.db.profile.frames.energybar.healthfontoffset,
				(JSHB.db.profile.energybar.shotbar == true) and 2 or 0)
			JSHB.F.EnergyBar.targetHealthValue:SetFont(JSHB.GetActiveFont(JSHB.db.profile.frames.energybar.healthfont) )
			JSHB.F.EnergyBar.targetHealthValue:SetText("")
		end
		
		-- Setup prediction bar
		if JSHB.db.profile.energybar.enableprediction then		
			JSHB.F.EnergyBar.PredictionFrame = CreateFrame("StatusBar", nil, JSHB.F.EnergyBar)			
			JSHB.F.EnergyBar.PredictionFrame:SetStatusBarTexture(JSHB.F.EnergyBar:GetStatusBarTexture():GetTexture() ) -- Use the main bar's texture
			JSHB.F.EnergyBar.PredictionFrame:SetMinMaxValues(0, 1)
			JSHB.F.EnergyBar.PredictionFrame:SetValue(1)
			JSHB.F.EnergyBar.PredictionFrame:SetFrameLevel(JSHB.F.EnergyBar:GetFrameLevel() )
			JSHB.F.EnergyBar.PredictionFrame:SetSize(
				(JSHB.F.EnergyBar:GetWidth() / 100) * (JSHB.predictionSpellBase + getPredictionAdjustment() ), JSHB.F.EnergyBar:GetHeight() )		   
			JSHB.F.EnergyBar.PredictionFrame:Hide()
		end
		
		-- Setup Auto shot bar
		if JSHB.db.profile.energybar.shotbar then
			JSHB.F.EnergyBar.autoShotFrame = CreateFrame("StatusBar", nil, JSHB.F.EnergyBar)
			JSHB.F.EnergyBar.autoShotFrame:SetStatusBarTexture(JSHB.F.EnergyBar:GetStatusBarTexture():GetTexture() ) -- Use the main bar's texture
			JSHB.F.EnergyBar.autoShotFrame:SetPoint("BOTTOMLEFT", JSHB.F.EnergyBar, "BOTTOMLEFT", 0, 0)
			JSHB.F.EnergyBar.autoShotFrame:SetMinMaxValues(0, UnitRangedDamage("player") * 100)
			JSHB.F.EnergyBar.autoShotFrame:SetSize(JSHB.F.EnergyBar:GetWidth(), 3)
			JSHB.F.EnergyBar.autoShotFrame:SetValue(UnitRangedDamage("player") )
			JSHB.F.EnergyBar.autoShotFrame:SetFrameLevel(JSHB.F.EnergyBar:GetFrameLevel() + 1)		
			JSHB.F.EnergyBar.autoShotFrame:SetStatusBarColor(unpack(JSHB.db.profile.frames.energybar.shotbarcolor) )
			
			if JSHB.db.profile.energybar.smoothbarshotbar then
				JSHB.MakeSmooth(JSHB.F.EnergyBar.autoShotFrame)		
			end
			
			JSHB.F.EnergyBar.autoShotFrame.updateTimer = 0
			JSHB.F.EnergyBar.autoShotFrame:SetScript("OnUpdate", function(self, elapsed)
				self.updateTimer = self.updateTimer + elapsed
				if self.updateTimer <= 0.015 then return else self.updateTimer = 0 end
				self.updateTimer = 0				
				if (GetTime() < self:GetParent().autoShotEndTime) then
					self:SetValue( (UnitRangedDamage("player") * 100) - ( (self:GetParent().autoShotEndTime * 100) - (GetTime() * 100) ) )
				else
					self:SetValue(0)
					self:Hide()
				end
			end)
		end
		
		-- Setup Auto shot time
		if JSHB.db.profile.energybar.shottimer then
			JSHB.F.EnergyBar.autoShotValue = JSHB.F.EnergyBar:CreateFontString(nil, "OVERLAY")
			JSHB.F.EnergyBar.autoShotValue:SetFont(JSHB.GetActiveFont(JSHB.db.profile.frames.energybar.shottimerfont) )
			JSHB.F.EnergyBar.autoShotValue:SetTextColor(unpack(JSHB.db.profile.frames.energybar.shottimerfontcolor) )
			JSHB.F.EnergyBar.autoShotValue:SetPoint("BOTTOMRIGHT", JSHB.F.EnergyBar, "BOTTOMRIGHT", 1  + JSHB.db.profile.frames.energybar.shottimerfontoffset, 1)
			JSHB.F.EnergyBar.autoShotValue:SetJustifyH("BOTTOM")
		end

		-- Setup Indicator marks
		local name, cost
		for i=1,5 do
			if (JSHB.db.profile.energybar.ticks[i][1] == true) and ((JSHB.db.profile.energybar.ticks[i][6] == 0)
				or (JSHB.db.profile.energybar.ticks[i][6] == GetPrimaryTalentTree() ) ) and (JSHB.db.profile.energybar.ticks[1][1] == true) then
				
				if i > 1 then
					name, _, _, cost = GetSpellInfo(JSHB.db.profile.energybar.ticks[i][2])
				end
				
				if (i == 1) or ( (i > 1) and name and cost and (cost > 0) ) then
					JSHB.F.EnergyBar["indicatorTick"..i] = JSHB.MakeFrame("Frame", "JSHB_ENERGYBAR_TICK"..i, JSHB.F.EnergyBar)
					JSHB.F.EnergyBar["indicatorTick"..i]:SetSize(10, JSHB.F.EnergyBar:GetHeight() * 1.6)
					JSHB.F.EnergyBar["indicatorTick"..i].tex = JSHB.F.EnergyBar["indicatorTick"..i]:CreateTexture(nil, "OVERLAY")
					JSHB.F.EnergyBar["indicatorTick"..i].tex:SetAllPoints(JSHB.F.EnergyBar["indicatorTick"..i])
					JSHB.F.EnergyBar["indicatorTick"..i].tex:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")	
					JSHB.F.EnergyBar["indicatorTick"..i].tex:SetBlendMode("ADD")
					JSHB.F.EnergyBar["indicatorTick"..i]:SetAlpha(1)
					JSHB.F.EnergyBar["indicatorTick"..i]:Hide()
				end
			end
		end
		
		-- Register Events to support the bar
		JSHB.F.EnergyBar:RegisterEvent("UNIT_SPELLCAST_START")
		JSHB.F.EnergyBar:RegisterEvent("UNIT_SPELLCAST_STOP")
		JSHB.F.EnergyBar:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
		JSHB.F.EnergyBar:RegisterEvent("UNIT_SPELLCAST_FAILED")
		JSHB.F.EnergyBar:RegisterEvent("UNIT_MAXPOWER")
		JSHB.F.EnergyBar.autoShotStartTime = 0
		JSHB.F.EnergyBar.autoShotEndTime = 0
		JSHB.F.EnergyBar:SetScript("OnEvent", function(self, event, ...)
			-- 4.2 local timeStamp, subEvent, hideCaster, sourceGUID, sourceName, sourceFlags, sourceFlags2, destGUID, destName, destFlags, destFlags2, spellId, spellName, spellSchool, extraSpellID, extraSpellName, extraSchool, auraType = ...
			local sourceUnit, spellName, spellId		
			sourceUnit, spellName, _, _, spellId = ...
			
			if (event == "UNIT_SPELLCAST_START") and JSHB.db.profile.energybar.enableprediction then
			
				if (sourceUnit == "player") then						
					if (spellId  == 56641) or (spellId == 77767) then -- HUNTER: Steady Shot / Cobra Shot
						self.playerIsCasting = true
						updatePrediction()
					end
				end
			
			elseif (event == "UNIT_SPELLCAST_SUCCEEDED") and (spellId == 75) and (JSHB.db.profile.energybar.shotbar or JSHB.db.profile.energybar.shottimer) then -- HUNTER: Auto shot
			
				self.autoShotStartTime = GetTime()
				self.autoShotEndTime = self.autoShotStartTime + UnitRangedDamage("player")

				if JSHB.db.profile.energybar.shotbar then
					self.autoShotFrame:Show()
				end

				if JSHB.db.profile.energybar.shottimer then
					self.autoShotValue:SetFormattedText("%.1f", self.autoShotEndTime - GetTime() ) -- "%.1f"
				end
			
			elseif (event == "UNIT_MAXPOWER") then
			
				self:SetMinMaxValues(0, UnitPowerMax("player"))
			
			elseif (event == "UNIT_SPELLCAST_STOP") or (event == "UNIT_SPELLCAST_FAILED") then
			
				if ( (spellId  == 56641) or (spellId == 77767) ) and JSHB.db.profile.energybar.enableprediction then -- HUNTER: Steady Shot / Cobra Shot			
					self.playerIsCasting = nil					
					self.PredictionFrame:Hide()
				end
			end
		end)
		
		-- Setup the script for handling the bar
		JSHB.F.EnergyBar.updateTimer = 0		
		JSHB.F.EnergyBar:SetScript("OnUpdate", function(self, elapsed)
		
			self.updateTimer = self.updateTimer + elapsed
			
			if self.updateTimer < ENERGYBAR_UPDATEINTERVAL then return else self.updateTimer = 0 end
		
			-- Overrides take precidence over normal alpha
			if JSHB.db.profile.energybar.deadoverride and UnitIsDeadOrGhost("player") then			
				self:SetAlpha(JSHB.db.profile.energybar.deadoverridealpha)				
			elseif JSHB.db.profile.energybar.mountoverride and (IsMounted() or UnitUsingVehicle("player") ) then			
				self:SetAlpha(JSHB.db.profile.energybar.mountoverridealpha)				
			elseif JSHB.db.profile.energybar.oocoverride and (not InCombatLockdown() ) then			
				self:SetAlpha(JSHB.db.profile.energybar.oocoverridealpha)				
			elseif UnitPower("player") ~= UnitPowerMax("player") then			
				self:SetAlpha(JSHB.db.profile.energybar.activealpha)			
			else			
				self:SetAlpha(JSHB.db.profile.energybar.inactivealpha)
			end
			
			-- Handle status bar updating
			self:SetValue(UnitPower("player"))
			
			if JSHB.db.profile.energybar.energynumber and (self.value ~= nil) then
				self.value:SetText(UnitPower("player"))
			end

			self:SetStatusBarColor(unpack(getBarColor() ) )

			-- Update the prediction bar, if enabled
			updatePrediction()			
			
			-- Update Shot time
			if JSHB.db.profile.energybar.shottimer then
				if (not UnitIsDeadOrGhost("player") ) and (GetTime() < self.autoShotEndTime) and InCombatLockdown() then
					self.autoShotValue:SetFormattedText("%.1f", self.autoShotEndTime - GetTime() )
				else
					self.autoShotValue:SetText("")
				end
			end
			
			-- Handle Target Health Percentage
			if JSHB.db.profile.energybar.targethealth then			
				if (not UnitExists("target") ) or (UnitIsDeadOrGhost("target") ) then 
					self.targetHealthValue:SetText("")
				else
					if UnitHealth("target") / UnitHealthMax("target") >= .9 then					
						self.targetHealthValue:SetFormattedText("|cffffff00%d %%|r", (UnitHealth("target") / UnitHealthMax("target")) * 100)						
					elseif UnitHealth("target") / UnitHealthMax("target") >= .2 then					
						self.targetHealthValue:SetFormattedText("|cffffffff%d %%|r", (UnitHealth("target") / UnitHealthMax("target")) * 100)						
					else
						self.targetHealthValue:SetFormattedText("|cffff0000%d %%|r", (UnitHealth("target") / UnitHealthMax("target")) * 100)
					end
				end			
			end
			
			-- Handle indicator tick marks
			local i, name, cost			
			for i=1,5 do
				if (JSHB.db.profile.energybar.ticks[i][1] == true) and (self["indicatorTick"..i] ~= nil) and (JSHB.db.profile.energybar.ticks[1][1] == true) then
				
					if (i > 1) then
						name, _, _, cost = GetSpellInfo(JSHB.db.profile.energybar.ticks[i][2])
					end
					
					if (i == 1) or ((i > 1) and name and cost and (cost > 0)) then
						if i == 1 then
							self["indicatorTick"..i]:ClearAllPoints()
							self["indicatorTick"..i]:SetPoint("LEFT", self, "LEFT", JSHB.GetMainSpellCost() * (self:GetWidth() / select(2, self:GetMinMaxValues() ) ) - 5, 0)
						else
							self["indicatorTick"..i]:ClearAllPoints()
							self["indicatorTick"..i]:SetPoint("LEFT", self, "LEFT", 
								( (JSHB.db.profile.energybar.ticks[i][3] == true) and (JSHB.GetMainSpellCost() + cost) or cost ) * 
								(self:GetWidth() / select(2, self:GetMinMaxValues() ) ) - 5, 0)
						end
						self["indicatorTick"..i]:Show()
					else
						self["indicatorTick"..i]:Hide()
					end
				end
			end
		end)
	end
	
	-- Construct the Stacks indicator
	if (not JSHB.db.profile.energybar.enablestacks) then return end
	if (not JSHB.db.profile.energybar.enabled) and (JSHB.db.profile.energybar.embedstacks) then return end -- if enable if not embedded if focus bar is off
	
	local STACKBARS_UPDATEINTERVAL = 0.15
	local numBars = 1
	local checkFunction = function(self) return end
	local stackSize = JSHB.db.profile.energybar.embedstacks and (JSHB.db.profile.frames.energybar.height * .85) or JSHB.db.profile.energybar.stackssize

	-- Setup the check functions for various specs
	if GetPrimaryTalentTree() == 1 then -- BM

		numBars = 5 -- Frenzy Stacks on pet for focus fire.		
		if (not select(5, GetTalentInfo(1, 6) ) ) then return end -- Frenzy		
		checkFunction = function(self)
			local stacks = select(4, UnitAura("pet", GetSpellInfo(19615), nil, "HELPFUL") ) or 0 -- 19615 = Frenzy Effect
			if stacks >= self.barIndex then
				self:SetAlpha((1 / self.totalBars) * self.barIndex)
				return true
			else
				self:SetAlpha(0)
			end
			return false
		end
	
	elseif GetPrimaryTalentTree() == 2 then -- MM
	
		numBars = 5 -- Ready, Set, Aim... on player		
		checkFunction = function(self)
			local proc = select(1, UnitAura("player", GetSpellInfo(82926), nil, "HELPFUL") ) or false -- 82926 = Fire! proc
			local stacks = select(4, UnitAura("player", GetSpellInfo(82925), nil, "HELPFUL") ) or 0 -- 82925 = Ready, Set, Aim...
			if proc or (stacks >= self.barIndex) then
				self:SetAlpha( (1 / self.totalBars) * self.barIndex)
			else
				self:SetAlpha(0)
			end
		end
		
	elseif GetPrimaryTalentTree() == 3 then -- SV
	
		numBars = 2 -- LnL Proc
		if (not select(5, GetTalentInfo(3, 10) ) ) then return end -- Lock n' Load		
		checkFunction = function(self)
			local stacks = select(4, UnitAura("player", GetSpellInfo(56342), nil, "HELPFUL") ) or 0 -- 56342 = Lock n' Load proc		
			if stacks >= self.barIndex then
				self:SetAlpha( (1 / self.totalBars) * self.barIndex)
			else
				self:SetAlpha(0)
			end
		end		
	end
	
	local gap = 0
	local totalWidth = ((stackSize + gap) * numBars) - gap
	
	-- Setup the host frame & mover if not embedded
	
	JSHB.F.StackBarsHost = JSHB.MakeFrame("Frame", "JSHB_STACKBARS_HOST", JSHB.db.profile.energybar.embedstacks and JSHB.F.EnergyBar or (JSHB.db.profile.energybar.anchor_stacks[2] or UIParent) )
	JSHB.F.StackBarsHost:SetSize(totalWidth, stackSize)
	JSHB.F.StackBarsHost:SetSize( (stackSize + gap) * numBars - gap, stackSize)
	if JSHB.db.profile.energybar.embedstacks then
		JSHB.F.StackBarsHost:SetPoint("RIGHT", JSHB.F.EnergyBar, "TOPRIGHT")
	else
		JSHB.F.StackBarsHost:SetPoint(JSHB.GetActiveAnchor(JSHB.db.profile.energybar.anchor_stacks) )
	end
	JSHB.F.StackBarsHost:SetAlpha(1)
	JSHB.F.StackBarsHost:Show()
		
	if not JSHB.db.profile.energybar.embedstacks then
		JSHB.RegisterMovableFrame(
			"MOVER_STACKBARS",
			JSHB.F.StackBarsHost,
			JSHB.F.StackBarsHost,
			JSHB.L["Stacks"],
			JSHB.db.profile.energybar,
			nil,
			JSHB.defaults.profile.energybar,-- Serenity.V["classspecific_defaults"][Serenity.V["playerclass"] ]["energybar"],
			nil,
			"_stacks"
		)
	end
	
	JSHB.F.StackBars = {}
	for i=1,numBars do
		JSHB.F.StackBars[i] = CreateFrame("Frame", nil, JSHB.F.StackBarsHost)
		JSHB.F.StackBars[i]:SetSize(stackSize, stackSize)
		
		if JSHB.db.profile.energybar.stacksreverse then
			JSHB.F.StackBars[i]:SetPoint("RIGHT", JSHB.F.StackBarsHost, "RIGHT", -( (stackSize + gap) * (i - 1) ), 0)
		else
			JSHB.F.StackBars[i]:SetPoint("LEFT", JSHB.F.StackBarsHost, "LEFT", ( (stackSize + gap) * (i - 1) ), 0)
		end

		JSHB.F.StackBars[i].stack = JSHB.F.StackBars[i]:CreateTexture(nil, "ARTWORK")
		JSHB.F.StackBars[i].stack:SetAllPoints(JSHB.F.StackBars[i])
		JSHB.F.StackBars[i].stack:SetTexture("Interface\\AddOns\\JSHunterBar\\media\\graphics\\stack1.tga")
		JSHB.F.StackBars[i].stack:SetVertexColor(unpack(JSHB.db.profile.energybar.stackscolor))
		JSHB.F.StackBars[i].stack:Show()
		
		JSHB.F.StackBars[i].barIndex = i
		JSHB.F.StackBars[i].totalBars = numBars
		JSHB.F.StackBars[i].checkFunction = checkFunction
		JSHB.F.StackBars[i].updateTimer = 0		

		JSHB.F.StackBars[i]:SetScript("OnUpdate", function(self, elapsed)
			self.updateTimer = self.updateTimer + elapsed
			if self.updateTimer < STACKBARS_UPDATEINTERVAL then return else self.updateTimer = 0 end
			
			self.checkFunction(self)				
		end)

		JSHB.F.StackBars[i]:SetAlpha(0)
		JSHB.F.StackBars[i]:Show()		
	end
end
