--[[

	JS' Hunter Bar Defaults
	
]]

if not JSHB then return end

-- Create a timer set defaults table to be used when a new timer set is made.
JSHB.timersetDefaults = {
	-- If these ever get changed, removed or added - update the blacklist in options!
	["enabled"] = true,
	["activealpha"] = .8,
	["inactivealpha"] = .5,
	["oocoverride"] = true,
	["oocoverridealpha"] = 0,
	["mountoverride"] = true,
	["mountoverridealpha"] = 0,
	["deadoverride"] = true,
	["deadoverridealpha"] = 0,
	["timers"] = {
		-- Spell name or ID, -- This field or the next MUST be nil (one or the other!)
		-- Item name or ID,
		-- Target (player, target, focus, pet, mouseover, raid, etc.)
		-- DURATION or COOLDOWN or ICOOLDOWN
		-- Owner (PLAYERS or ANY)
		-- Spec (0 for any, or 1, 2, 3 relative on talent panel)
		-- Timer text position
		-- Flash 0 / 1
		-- Spin 0 / 1
		-- Grow 0 / 1
		-- If Grow, % Remaining to start grow
		-- If Grow, Size to grow (100% - 200%) of size.
		-- Alpha 0 / 1 (if this is on, initial alpha value will be what the timer initially starts at, overriding default)
		-- If Alpha, Start value
		-- If Alpha, End value
		-- If ICOOLDOWN, the given duration
		-- If ICOOLDOWN, last time it was active (to calculate ICD)
	},
	["anchor"] = { "CENTER", nil, "CENTER", 0, -50 },
	["layout"] = "horizontal",
	["reverse"] = false,
}

-- New alert defaults
JSHB.alertDefaults = {
	["enabled"] = true,
	["alerttype"] = "DEBUFF",
	["enablesound"] = true,
	["sound"] = "Raid Warning",
	["aura"] = JSHB.L["ENTER NAME OR ID"],
	["target"] = "target",
	["sparkles"] = true,
	["tooltips"] = true,
}

-- Alert Frame (style) defaults
JSHB.alertFrameDefaults = {
	enablebackdrop = false,
	colorbackdrop = false,
	backdropcolor = { 0, 0, 0, .5 },
	backdroptexture = "Solid",
	backdropoffsets = { -2, 2, 2, -2 },
	enableborder = false,
	bordercolor = { 1, 1, 1, 1 },
	bordertexture = "None",
	backdropinsets = { -2, -2, -2, -2 },
	iconsize = 32,
	edgesize = 16,
	tile = false,
	tilesize = 16,
	stackfont = { "Arial Narrow", 12, "OUTLINE" },
	stackfontcolor = { .05, 1, .96 },
	enabletexcoords = false,
	texcoords = { 0.08, 0.92, 0.08, 0.92 },
}

-- New timer default
JSHB.newTimerDefaults = { "*NEW TIMER", nil, "player", "COOLDOWN", "PLAYERS", 0, "RIGHT", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, 0, nil }

-- Initial install defaults
JSHB.defaultDefaults = {
	["timers"] = {
		-- Durations Set 1
		["timerbar1"] = {
			["timers"] = { -- Explained above in the timer set defaults
				{ 1978, nil, "target", "DURATION", "PLAYERS", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Serpent Sting
				{ 82654, nil, "target", "DURATION", "ANY", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Widow Venom
				{ 3045, nil, "player", "DURATION", "PLAYERS", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Rapid Fire
				{ 34692, nil, "player", "DURATION", "PLAYERS", 1, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- The Beast Within
				{ 32182, nil, "player", "DURATION", "ANY", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Heroism
				{ 90355, nil, "player", "DURATION", "ANY", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Ancient Hysteria
				{ 80353, nil, "player", "DURATION", "ANY", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Time Warp
				{ 2825, nil, "player", "DURATION", "ANY", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Blood Lust
				{ 136, nil, "pet", "DURATION", "PLAYERS", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Mend Pet
				{ 53220, nil, "player", "DURATION", "PLAYERS", 2, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Improved Steady Shot
				{ 3674, nil, "target", "DURATION", "PLAYERS", 3, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Black Arrow
				{ 79633, nil, "player", "DURATION", "PLAYERS", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Tol'vir Agility
				{ 105919, nil, "player", "DURATION", "PLAYERS", 0, "CENTER", nil, nil, nil, 0.4, 1.4, nil, 0.4, 1, 98, nil }, -- Chronohunter
				{ 70893, nil, "player", "DURATION", "PLAYERS", 0, "CENTER", nil, nil, nil, 0.4, 1.4, nil, 0.4, 1, 0, nil }, -- Culling the Herd
				{ 96911, nil, "player", "DURATION", "PLAYERS", 0, "CENTER", nil, nil, nil, 0.4, 1.4, nil, 0.4, 1, 0, nil }, -- Devour
				{ 102659, nil, "player", "DURATION", "PLAYERS", 0, "CENTER", nil, nil, nil, 0.4, 1.4, nil, 0.4, 1, 0, nil }, -- Arrow of Time
				{ 99621, nil, "player", "DURATION", "PLAYERS", 0, "CENTER", nil, nil, nil, 0.4, 1.4, nil, 0.4, 1, 0, nil }, -- Flintlocke's Wookchucker
			},
		},
		-- Cooldowns Set 2
		["timerbar2"] = {
			["timers"] = { -- Explained above in the timer set defaults
				{ 82726, nil, "player", "COOLDOWN", "PLAYERS", 1, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Fervor
				{ 19574, nil, "pet", "COOLDOWN", "PLAYERS", 1, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Bestial Wrath
				{ 1499, nil, "player", "COOLDOWN", "PLAYERS", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Freezing Trap
				{ 90355, nil, "player", "COOLDOWN", "PLAYERS", 1, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Ancient Hysteria
				{ 90361, nil, "player", "COOLDOWN", "PLAYERS", 1, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Spirit Ment
				{ 3045, nil, "player", "COOLDOWN", "PLAYERS", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Rapid Fire
				{ 3674, nil, "player", "COOLDOWN", "PLAYERS", 3, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 0, nil }, -- Black Arrow
			},
		},
		-- Internal Cooldowns Set 3
		["timerbar3"] = {
			["timers"] = { -- Explained above in the timer set defaults
				{ 57345, nil, "player", "ICOOLDOWN", "PLAYERS", 1, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 105, nil }, -- DarkMoon Faery: Greatness
				{ 105919, nil, "player", "ICOOLDOWN", "PLAYERS", 1, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 98, nil }, -- Chronohunter
				{ 102659, nil, "player", "ICOOLDOWN", "PLAYERS", 1, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 30, nil }, -- Arrow of Time
				{ 67702, nil, "player", "ICOOLDOWN", "PLAYERS", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 45, nil }, -- Death's Veredict / Death's Choice
				{ 71519, nil, "player", "ICOOLDOWN", "PLAYERS", 1, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 105, nil }, -- Deathbringer's Will
				{ 99621, nil, "player", "ICOOLDOWN", "PLAYERS", 0, "CENTER", nil, nil, nil, .4, 1.4, nil, .4, 1, 40, nil }, -- Flintlocke's Woodchucker
			},
		},
	},
	["alerts_BWD"] = {
		["BWD: Parasitic Infection"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 94679,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Fixate (Toxitron)"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 80094,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Lightning Conductor"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 91433,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Shadow Conductor"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 92053,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Consuming Flames (Maloriak)"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 77786,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Fixate (Maloriak)"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 78617,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Dark Sludge"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 92987,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Sonic Breath"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 92407,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Roaring Flame"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 92485,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Searing Flame"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 92423,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Dominion"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 79318,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Stolen Power"] = {
			["enabled"] = true,
			["alerttype"] = "BUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 80627,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BWD: Explosive Cinders"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 79339,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
	},
	["alerts_BOT"] = {
		["BOT: Waterlogged"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 82762,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BOT: Heart of Ice"] = {
			["enabled"] = true,
			["alerttype"] = "BUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 82665,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BOT: Frost Beacon"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 93207,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BOT: Burning Blood"] = {
			["enabled"] = true,
			["alerttype"] = "BUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 82660,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BOT: Gravity Core"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 92075,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BOT: Lightning Rod (Arion)"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 83099,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BOT: Blackout"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 86788,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BOT: Engulfing Magic"] = {
			["enabled"] = true,
			["alerttype"] = "BUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 86622,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BOT: Twilight Meteorite"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 88518,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
		["BOT: Devouring Flames"] = {
			["enabled"] = true,
			["alerttype"] = "DEBUFF",
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["aura"] = 86840,
			["target"] = "player",
			["sparkles"] = true,
			["tooltips"] = true,
		},
	},
}

-- Create the defaults "profile" sub-key for AceDB
JSHB.defaults = {
	["profile"] = {
		["newinstall"] = true,
		["masteraudio"] = true,
		["minfortenths"] = 4,
		["template"] = "JSHB",
		["energybar"] = {
			["enabled"] = true,
			["activealpha"] = 1,
			["inactivealpha"] = .8,
			["oocoverride"] = true,
			["oocoverridealpha"] = 0.2,
			["mountoverride"] = true,
			["mountoverridealpha"] = 0.2,
			["deadoverride"] = true,
			["deadoverridealpha"] = 0,
			["anchor"] = { "CENTER", nil, "CENTER", 0, -170 },
			["energynumber"] = true,
			["targethealth"] = true,
			["shottimer"] = false,
			["shotbar"] = false,
			["smoothbar"] = false,
			["smoothbarshotbar"] = true,
			["lowwarn"] = true,			
			["highwarn"] = true,
			["highwarnthreshold"] = .8,
			["enableprediction"] = true,
			["anchor_stacks"] = { "CENTER", nil, "CENTER", 90, -100 },
			["enablestacks"] = true,
			["embedstacks"] = true,
			["stackssize"] = 40,
			["stackscolor"] = { 0.8, 0, 0 },
			["stacksreverse"] = false,
			["ticks"] = {
				{ true, "", true, false, {1,1,1,1}, 0 },
				{ false, "", true, false, {1,1,1,1}, 0 },
				{ false, "", true, false, {1,1,1,1}, 0 },
				{ false, "", true, false, {1,1,1,1}, 0 },
				{ false, "", true, false, {1,1,1,1}, 0 },
			},
		},
		["enrage"] = {
			["enabled"] = true,
			["enablesound"] = true,
			["sound"] = "Raid Warning",
			["removednotify"] = true,
			["solochan"] = "AUTO",
			["partychan"] = "AUTO",
			["raidchan"] = "AUTO",
			["arenachan"] = "AUTO",
			["pvpchan"] = "AUTO",
			["anchor"] = { "CENTER", nil, "CENTER", 0, 120 },
			["anchor_removables"] = { "CENTER", nil, "CENTER", 250, 250 },
			["enableremovables"] = true,
			["removablespvponly"] = true,
			["removablestips"] = true,
		},
		["crowdcontrol"] = {
			["enabled"] = true,
			["anchor"] = { "CENTER", nil, "CENTER", -190, -170 },
		},
		["indicators"] = {
			["enabled"] = true,
			["aspect_onlymissing"] = false,
			["aspect_onlycombat"] = false,
			["huntersmark_enable"] = true,
			["huntersmark_mfd"] = true,
			["anchor_huntersmark"] = { "CENTER", nil, "CENTER", 80, 100 },
			["aspect_enable"] = true,
			["anchor_aspect"] = { "CENTER", nil, "CENTER", 160, -170 },
			["scarebeast_enable"] = true,
			["anchor_scarebeast"] = { "CENTER", nil, "CENTER", 195, -170 },
		},
		["timers"] = {
			-- Durations Set 1
			["timerbar1"] = {
				["enabled"] = true,
				["activealpha"] = 1.0,
				["inactivealpha"] = .5,
				["oocoverride"] = true,
				["oocoverridealpha"] = 0,
				["mountoverride"] = true,
				["mountoverridealpha"] = 0,
				["deadoverride"] = true,
				["deadoverridealpha"] = 0,
				["timers"] = { -- Explained above in the timer set defaults
				},
				["anchor"] = { "CENTER", nil, "CENTER", 0, -142 },
				["layout"] = "horizontal",
				["reverse"] = false,
				["showsettings"] = nil,
			},
			-- Cooldowns Set 2
			["timerbar2"] = {
				["enabled"] = true,
				["activealpha"] = 1.0,
				["inactivealpha"] = .5,
				["oocoverride"] = true,
				["oocoverridealpha"] = 0,
				["mountoverride"] = true,
				["mountoverridealpha"] = 0,
				["deadoverride"] = true,
				["deadoverridealpha"] = 0,
				["timers"] = { -- Explained above in the timer set defaults
				},
				["anchor"] = { "CENTER", nil, "CENTER", 0, -198 },
				["layout"] = "horizontal",
				["reverse"] = false,
				["showsettings"] = nil,
			},
			-- Internal Cooldowns Set 3
			["timerbar3"] = {
				["enabled"] = false,
				["activealpha"] = 1.0,
				["inactivealpha"] = .5,
				["oocoverride"] = true,
				["oocoverridealpha"] = 0,
				["mountoverride"] = true,
				["mountoverridealpha"] = 0,
				["deadoverride"] = true,
				["deadoverridealpha"] = 0,
				["timers"] = { -- Explained above in the timer set defaults
				},
				["anchor"] = { "CENTER", nil, "CENTER", 0, -226 },
				["layout"] = "horizontal",
				["reverse"] = false,
				["showsettings"] = nil,
			},
		},
		["alerts"] = {
		},
		["alerticons"] = {
			["anchor"] = { "CENTER", nil, "CENTER", -120, 100 },
		},
		["frames"] = {
			["movers"] = {
				titlefont = { "Arial Narrow", 15, "OUTLINE" },
				titlefontcolor = { 1, 1, 1, 1 }, -- White
				foreground = { 0, .5, 0, .8 }, -- Green
			},
			["cooldowns"] = {
				font = { "Arial Narrow", 18, "OUTLINE" },
				expiringcolor = { 1, 0, 0 }, -- Red
				secondscolor = { 1, 1, 0 },
				minutescolor = { 1, 1, 1 }, -- White
				hourscolor = { 0.4, 1, 1 },
				dayscolor = { 0.4, 0.4, 1 },
				shadowcolor = { 0, 0, 0, 0.5 }, -- Black + 1/2 alpha
				enableshadow = true,
				fontshadowoffset = { 2, -2 },
			},
			["energybar"] = {
				width = 250,
				height = 19,
				energyfont = { "Big Noodle", 17, "OUTLINE" },
				energyfontoffset = 0,
				healthfont = { "Big Noodle", 14, "OUTLINE" },
				healthfontoffset = 0,
				energyfontcolor = { 1, 1, 1, 1 },
				shottimerfont = { "Arial Narrow", 12, "OUTLINE" },
				shottimerfontcolor = { 1, 1, 1, 1 },
				shottimerfontoffset = 0,
				bartexture = "Blizzard",
				classcolored = true,
				barcolor = { 0.6, 0.6, 0.6, 1},
				barcolorlow = { 1, 0, 0, 1},
				barcolorhigh = { 1, 0.55, 0, 1},
				shotbarcolor = { 1, 1, 1, 1},
				enablebackdrop = true,
				colorbackdrop = true,
				backdropcolor = { 0, 0, 0, .5 },
				backdroptexture = "Solid",
				backdropoffsets = { -2, 2, 2, -2 },
				enableborder = false,
				bordercolor = { 1, 1, 1, 1 },
				bordertexture = "None",
				backdropinsets = { -2, -2, -2, -2 },
				edgesize = 16,
				tile = false,
				tilesize = 16,
			},
			["enrage"] = {
				iconsize = 40,
				iconsizeremovables = 24,
				enablebackdrop = false,
				colorbackdrop = false,
				backdropcolor = { 0, 0, 0, .5 },
				backdroptexture = "Solid",
				backdropoffsets = { -2, 2, 2, -2 },
				enableborder = false,
				bordercolor = { 1, 1, 1, 1 },
				bordertexture = "None",
				backdropinsets = { -2, -2, -2, -2 },
				edgesize = 16,
				tile = false,
				tilesize = 16,
				enabletexcoords = false,
				texcoords = { 0.08, 0.92, 0.08, 0.92 },
				removablesenablebackdrop = false,
				removablescolorbackdrop = false,
				removablesbackdropcolor = { 0, 0, 0, .5 },
				removablesbackdroptexture = "Solid",
				removablesbackdropoffsets = { -2, 2, 2, -2 },
				removablesenableborder = false,
				removablesbordercolor = { 1, 1, 1, 1 },
				removablesbordertexture = "None",
				removablesbackdropinsets = { -2, -2, -2, -2 },
				removablesedgesize = 16,
				removablestile = false,
				removablestilesize = 16,
				removablesenabletexcoords = false,
				removablestexcoords = { 0.08, 0.92, 0.08, 0.92 },
			},
			["crowdcontrol"] = {
				iconsize = 30,
				enablebackdrop = false,
				colorbackdrop = false,
				backdropcolor = { 0, 0, 0, .5 },
				backdroptexture = "Solid",
				backdropoffsets = { -2, 2, 2, -2 },
				enableborder = false,
				bordercolor = { 1, 1, 1, 1 },
				bordertexture = "None",
				backdropinsets = { -2, -2, -2, -2 },
				edgesize = 16,
				tile = false,
				tilesize = 16,
				enabletexcoords = false,
				texcoords = { 0.08, 0.92, 0.08, 0.92 },
			},
			["indicators"] = {
				huntersmark_iconsize = 40,
				huntersmark_enablebackdrop = false,
				huntersmark_colorbackdrop = false,
				huntersmark_backdropcolor = { 0, 0, 0, .5 },
				huntersmark_backdroptexture = "Solid",
				huntersmark_backdropoffsets = { -2, 2, 2, -2 },
				huntersmark_enableborder = false,
				huntersmark_bordercolor = { 1, 1, 1, 1 },
				huntersmark_bordertexture = "None",
				huntersmark_backdropinsets = { -2, -2, -2, -2 },
				huntersmark_edgesize = 16,
				huntersmark_tile = false,
				huntersmark_tilesize = 16,
				huntersmark_enabletexcoords = false,
				huntersmark_texcoords = { 0.08, 0.92, 0.08, 0.92 },
				aspect_iconsize = 30,
				aspect_enablebackdrop = false,
				aspect_colorbackdrop = false,
				aspect_backdropcolor = { 0, 0, 0, .5 },
				aspect_backdroptexture = "Solid",
				aspect_backdropoffsets = { -2, 2, 2, -2 },
				aspect_enableborder = false,
				aspect_bordercolor = { 1, 1, 1, 1 },
				aspect_bordertexture = "None",
				aspect_backdropinsets = { -2, -2, -2, -2 },
				aspect_edgesize = 16,
				aspect_tile = false,
				aspect_tilesize = 16,
				aspect_enabletexcoords = false,
				aspect_texcoords = { 0.08, 0.92, 0.08, 0.92 },
			},
			["timers"] = {
				["timerbar1"] = {
					enablebackdrop = false,
					colorbackdrop = true,
					backdropcolor = { 0, 0, 0, .5 },
					backdroptexture = "Solid",
					backdropoffsets = { -2, 2, 2, -2 },
					enableborder = false,
					bordercolor = { 1, 1, 1, 1 },
					bordertexture = "None",
					backdropinsets = { -2, -2, -2, -2 },
					width = 250,
					height = 19,
					iconsize = 19,
					edgesize = 16,
					tile = false,
					tilesize = 16,
					timefont = { "Arial Narrow", 13, "OUTLINE" },
					timerfontcolorstatic = false,
					timerfontcolor = { 0.4, 0.4, 1 }, -- Yellow (Check this)
					enabletimershadow = false,
					timershadowcolor = { 0, 0, 0, 0.5 }, -- Black + 1/2 alpha
					timershadowoffset = { 2, -2 },
					stackfont = { "Arial Narrow", 12, "OUTLINE" },
					stackfontcolor = { .05, 1, .96 },					
					timerenablebackdrop = false,
					timercolorbackdrop = true,
					timerbackdropcolor = { 0, 0, 0, .5 },
					timerbackdroptexture = "Solid",
					timertile = false,
					timertilesize = 16,
					timerbackdropoffsets = { -2, 2, 2, -2 },
					timerbackdropinsets = { -2, -2, -2, -2 },
					timerenableborder = false,
					timerbordercolor = { 1, 1, 1, 1 },
					timerbordertexture = "None",
					timeredgesize = 16,
					enabletexcoords = false,
					texcoords = { 0.08, 0.92, 0.08, 0.92 },
				},
				["timerbar2"] = {
					enablebackdrop = false,
					colorbackdrop = true,
					backdropcolor = { 0, 0, 0, .5 },
					backdroptexture = "Solid",
					backdropoffsets = { -2, 2, 2, -2 },
					enableborder = false,
					bordercolor = { 1, 1, 1, 1 },
					bordertexture = "None",
					backdropinsets = { -2, -2, -2, -2 },
					width = 250,
					height = 19,
					iconsize = 19,
					edgesize = 16,
					tile = false,
					tilesize = 16,
					timefont = { "Arial Narrow", 13, "OUTLINE" },
					timerfontcolorstatic = false,
					timerfontcolor = { 0.4, 0.4, 1 }, -- Yellow (Check this)
					enabletimershadow = false,
					timershadowcolor = { 0, 0, 0, 0.5 }, -- Black + 1/2 alpha
					timershadowoffset = { 2, -2 },
					stackfont = { "Arial Narrow", 12, "OUTLINE" },
					stackfontcolor = { .05, 1, .96 },					
					timerenablebackdrop = false,
					timercolorbackdrop = true,
					timerbackdropcolor = { 0, 0, 0, .5 },
					timerbackdroptexture = "Solid",
					timertile = false,
					timertilesize = 16,
					timerbackdropoffsets = { -2, 2, 2, -2 },
					timerbackdropinsets = { -2, -2, -2, -2 },
					timerenableborder = false,
					timerbordercolor = { 1, 1, 1, 1 },
					timerbordertexture = "None",
					timeredgesize = 16,
					enabletexcoords = false,
					texcoords = { 0.08, 0.92, 0.08, 0.92 },
				},
				["timerbar3"] = {
					enablebackdrop = false,
					colorbackdrop = true,
					backdropcolor = { 0, 0, 0, .5 },
					backdroptexture = "Solid",
					backdropoffsets = { -2, 2, 2, -2 },
					enableborder = false,
					bordercolor = { 1, 1, 1, 1 },
					bordertexture = "None",
					backdropinsets = { -2, -2, -2, -2 },
					width = 250,
					height = 19,
					iconsize = 19,
					edgesize = 16,
					tile = false,
					tilesize = 16,
					timefont = { "Arial Narrow", 13, "OUTLINE" },
					timerfontcolorstatic = false,
					timerfontcolor = { 0.4, 0.4, 1 }, -- Yellow (Check this)
					enabletimershadow = false,
					timershadowcolor = { 0, 0, 0, 0.5 }, -- Black + 1/2 alpha
					timershadowoffset = { 2, -2 },
					stackfont = { "Arial Narrow", 12, "OUTLINE" },
					stackfontcolor = { .05, 1, .96 },					
					timerenablebackdrop = false,
					timercolorbackdrop = true,
					timerbackdropcolor = { 0, 0, 0, .5 },
					timerbackdroptexture = "Solid",
					timertile = false,
					timertilesize = 16,
					timerbackdropoffsets = { -2, 2, 2, -2 },
					timerbackdropinsets = { -2, -2, -2, -2 },
					timerenableborder = false,
					timerbordercolor = { 1, 1, 1, 1 },
					timerbordertexture = "None",
					timeredgesize = 16,
					enabletexcoords = false,
					texcoords = { 0.08, 0.92, 0.08, 0.92 },
				},
			},
			["alerts"] = {
				enablebackdrop = false,
				colorbackdrop = false,
				backdropcolor = { 0, 0, 0, .5 },
				backdroptexture = "Solid",
				backdropoffsets = { -2, 2, 2, -2 },
				enableborder = false,
				bordercolor = { 1, 1, 1, 1 },
				bordertexture = "None",
				backdropinsets = { -2, -2, -2, -2 },
				iconsize = 32,
				edgesize = 16,
				tile = false,
				tilesize = 16,
				stackfont = { "Arial Narrow", 12, "OUTLINE" },
				stackfontcolor = { .05, 1, .96 },
				enabletexcoords = false,
				texcoords = { 0.08, 0.92, 0.08, 0.92 },
				["icons"] = {
					enablebackdrop = false,
					colorbackdrop = false,
					backdropcolor = { 0, 0, 0, .5 },
					backdroptexture = "Solid",
					backdropoffsets = { -2, 2, 2, -2 },
					enableborder = false,
					bordercolor = { 1, 1, 1, 1 },
					bordertexture = "None",
					backdropinsets = { -2, -2, -2, -2 },
					iconsize = 32,
					edgesize = 16,
					tile = false,
					tilesize = 16,
					stackfont = { "Arial Narrow", 12, "OUTLINE" },
					stackfontcolor = { .05, 1, .96 },
					enabletexcoords = false,
					texcoords = { 0.08, 0.92, 0.08, 0.92 },
				},
			},
		},
		["alerts"] = {
		},
	},
}

function JSHB.ImportAlerts(importKey)
	for key,val in pairs(JSHB["defaultDefaults"][importKey]) do
		for key2,val2 in pairs(JSHB["defaultDefaults"][importKey][key]) do
			if not JSHB.db.profile.alerts[key] then JSHB.db.profile.alerts[key] = {} end
			JSHB.db.profile.alerts[key][key2] = JSHB.DeepCopy(JSHB["defaultDefaults"][importKey][key][key2])
		end
	end
end

--[[
	This function returns a deep copy of a given table.
	The function below also copies the metatable to the new table if there is one,
	so the behaviour of the copied table is the same as the original.
	*** But the 2 tables share the same metatable, you can avoid this by setting the
	"deepcopymeta" option to true to make a copy of the metatable, as well.
]]
function JSHB.DeepCopy(object, deepcopymeta)
    local lookup_table = {}
    local function _copy(object)
        if type(object) ~= "table" then
            return object
        elseif lookup_table[object] then
            return lookup_table[object]
        end
        local new_table = {}
        lookup_table[object] = new_table
        for index, value in pairs(object) do
            new_table[_copy(index)] = _copy(value)
        end
        return setmetatable(new_table, deepcopymeta and _copy(getmetatable(object) ) or getmetatable(object) )
    end
    return _copy(object)
end

--[[
	Defaults need to be setup after the options table is defined in Ace (defaults that may be totally removed).
	If not, when you remove an object (as in timers), it will create a 'nil' table entry and totally fuck things up.
]]
function JSHB.CheckForNewInstallSetup(forceIt)
	if (JSHB.db.profile["newinstall"] == false) and (not forceit) then return end
	
	local key, val, key2, val2
	
	-- Timer sets, merge default defaluts into the profile for new installs
	for key,val in pairs(JSHB["defaultDefaults"]["timers"]) do
		for key2,val2 in pairs(JSHB["defaultDefaults"]["timers"][key]) do
			if not JSHB.db.profile.timers[key] then JSHB.db.profile.timers[key] = {} end
			JSHB.db.profile.timers[key][key2] = JSHB.DeepCopy(JSHB["defaultDefaults"]["timers"][key][key2])
		end
	end
	-- TIMERS DONE!
	
	JSHB.db.profile["newinstall"] = false
end
