--[[

	JS' Hunter Bar alerts module
	
]]

if (not JSHB) then return end

JSHB.totalAlertIcons = 0

-- Compares GUID values of the selected target or target group for a match
local function checkGUIDMatch(target, destGUID)

	local i, maxPlayers, inInstance, instanceType
	if (target == "raid") or (target == "raidpet") then	
		if GetNumRaidMembers() ~= 0 then
			if IsInInstance() then 
				maxPlayers = select(5, GetInstanceInfo() ) 
			else
				maxPlayers = 40
			end

			for i=1,maxPlayers do
				if UnitExists(target..i) and (UnitGUID(target..i) == destGUID) then
					return(target..i)
				end
			end
		end
		return false

	elseif (target == "party") or (target == "partypet") then
		
		if (UnitGUID(target == "party" and "player" or "pet") == destGUID) then
			return(target == "party" and "player" or "pet")
		end
		for i=1,GetNumPartyMembers() do
			if UnitExists(target..i) and (UnitGUID(target..i) == destGUID) then
				return(target..i)
			end
		end
		return false
		
	elseif (target == "arena") then
	
		inInstance, instanceType = IsInInstance()
		if inInstance and instanceType == "arena" then
			for i=1,5 do
				if UnitExists(target..i) then
					return(target..i)
				end
			end
		end
		return false
		
	elseif (target == "boss") then
		for i=1,4 do
			if UnitExists(target..i) and (UnitGUID(target..i) == destGUID) then
				return(target..i)
			end
		end
		return false		
	end

	-- Last check is the exact target name
	if UnitExists(target) and (UnitGUID(target) == destGUID) then
		return(target)
	end
	return false -- No match
end

local function repositionFrames()
	local i
	local index = 1
	for i = 1, JSHB.totalAlertIcons do
		if JSHB.F.Alerts[i].active then
		
			JSHB.F.Alerts[i]:ClearAllPoints()

			-- Flip expanding left to right or right to left depending on anchor point X
			local xPos = ( (JSHB.db.profile.frames.alerts.icons.iconsize +
						(JSHB.GetFrameOffset(JSHB.F.Alerts[1], "LEFT", 1) + JSHB.GetFrameOffset(JSHB.F.Alerts[1], "RIGHT", 1) + 2) )
							* mod(index - 1, 5) )
			
			local yPos = (JSHB.db.profile.frames.alerts.icons.iconsize +  -- Vertical Offset
						(JSHB.GetFrameOffset(JSHB.F.Alerts[1], "TOP", 1) + JSHB.GetFrameOffset(JSHB.F.Alerts[1], "BOTTOM", 1) + 2) )
							* floor( (index - 1) / 5)

			if JSHB.db.profile.alerticons.anchor[4] >= 0 then
				JSHB.F.Alerts[i]:SetPoint("TOPLEFT", JSHB.F.AlertIconsHost, "TOPLEFT", xPos, -yPos)
			else
				JSHB.F.Alerts[i]:SetPoint("TOPRIGHT", JSHB.F.AlertIconsHost, "TOPRIGHT", -xPos, -yPos)
			end
			index = index + 1
		end	
	end
end

local function stopDebuffAlert(self, spellID)

	if (self.active == true) and (self.spellID == spellID) then
		if self.hasSparkles then
			AutoCastShine_AutoCastStop(self.shine)
			self.shine:Hide()
		end
		
		self.Icon:Hide()

		self.stacks:Hide()
		self:SetAlpha(0)
		self.spellID = 0
		self.active = false
		self.killtime = 0
		
		if self.noTimeCheckFunc then
			self.noTimeCheckFunc = nil
		end
		
		if self.hasTip then
			self:EnableMouse(nil)
		end
		if self.timer then
			self.timer.enabled = nil
			self.timer:Hide()
		end
		
		repositionFrames()
	end
end

local function addDebuffAlert(self, spellID, expireTime, stacks, noTimeCheckFunc)

	if (self.active == false) then
	
		if self.soundFile then
			PlaySoundFile(JSHB.GetLibSharedMedia3():Fetch("sound", self.soundFile), JSHB.db.profile.masteraudio and "Master" or nil)
		end
							
		self.Icon:SetTexture(select(3, GetSpellInfo(spellID) ))
		self.Icon:Show()

		if stacks and (stacks > 1) then 
			self.stacks:SetText(stacks)
			self.stacks:Show()
		else
			self.stacks:Hide()
		end

		if JSHB.moversLocked then
			self:SetAlpha(1)
		end

		if noTimeCheckFunc then
			self.noTimeCheckFunc = noTimeCheckFunc
		end
		
		self.killtime = GetTime() + expireTime + .2
		self.spellID = spellID
		self.active = true
		
		if self.hasTip then
			self:EnableMouse(true)
		end
		
		if self.hasSparkles then
			self.shine:Show()
			AutoCastShine_AutoCastStart(self.shine)
		end

		local timer = self.timer or JSHB.Timer_Create(self)
		timer.start = GetTime()
		timer.duration = expireTime
		timer.enabled = true
		timer.nextUpdate = 0
		timer:Show()
		
		repositionFrames()
	end
end

local function refreshDebuffAlert(self, spellID, expireTime, stacks, whatEvent)

	if (self.active == true) and (self.spellID == spellID) then

		self.killtime = GetTime() + expireTime + .2

		self.Icon:Show()

		if stacks and (stacks > 1) then
			self.stacks:SetText(stacks)
			self.stacks:Show()
		else
			self.stacks:Hide()
		end

		local timer = self.timer or JSHB.Timer_Create(self)
		timer.start = GetTime()
		timer.duration = expireTime
		timer.enabled = true
		timer.nextUpdate = 0
		timer:Show()
		
		repositionFrames()
	end
end

function JSHB.SetupAlertsModule()

	if not JSHB.F.Alerts then JSHB.F.Alerts = {} end

	-- Destruction
	local i = 1
	while JSHB.F.Alerts[i] ~= nil do
		JSHB.F.Alerts[i]:Hide()
		JSHB.F.Alerts[i]:UnregisterAllEvents()
		JSHB.F.Alerts[i]:SetParent(nil)
		JSHB.F.Alerts[i] = nil
		i = i + 1
	end
	
	-- Clean up the mover frame	
	if JSHB.F.AlertIconsHost then
		JSHB.F.AlertIconsHost:Hide()
		JSHB.DeregisterMovableFrame("MOVER_ALERT_ICONS")
		JSHB.F.AlertIconsHost:SetParent(nil)
		JSHB.F.AlertIconsHost = nil
	end
	
	JSHB.totalAlertIcons = 0

	-- Construction
	local ALERT_UPDATEINTERVAL = 0.15
	local key,val
	local index = 1
	for key,val in pairs(JSHB.db.profile.alerts) do

		if JSHB.db.profile.alerts[key] and JSHB.db.profile.alerts[key].enabled then
	
			-- Create the host frame
			if (index == 1) then
				JSHB.F.AlertIconsHost = JSHB.MakeFrame("Frame", "JSHB_ALERT_ICON_HOST", JSHB.db.profile.alerticons.anchor[2] or UIParent)
				JSHB.F.AlertIconsHost:SetSize(JSHB.db.profile.frames.alerts.icons.iconsize, JSHB.db.profile.frames.alerts.icons.iconsize) -- Temporary size
				JSHB.F.AlertIconsHost:SetPoint(JSHB.GetActiveAnchor(JSHB.db.profile.alerticons.anchor) )
				JSHB.F.AlertIconsHost:SetAlpha(1)
				JSHB.F.AlertIconsHost:Show()
			end
	
			-- Create this Alert's Frame
			JSHB.F.Alerts[index] = JSHB.MakeFrame("Frame", "JSHB_ALERT_ICON_"..key, JSHB.F.AlertIconsHost)
			JSHB.F.Alerts[index]:SetSize(JSHB.db.profile.frames.alerts.icons.iconsize, JSHB.db.profile.frames.alerts.icons.iconsize)
			JSHB.F.Alerts[index]:SetPoint("CENTER", JSHB.F.AlertIconsHost, "CENTER")
			JSHB.F.Alerts[index]:SetAlpha(0)
			
			JSHB.F.Alerts[index].Icon = JSHB.F.Alerts[index]:CreateTexture(nil, "BACKGROUND")
			JSHB.F.Alerts[index].Icon:SetTexture("Interface\\ICONS\\INV_Misc_QuestionMark") -- Just a place-holder
			if JSHB.db.profile.frames.alerts.icons.enabletexcoords then
				JSHB.F.Alerts[index].Icon:SetTexCoord(unpack(JSHB.db.profile.frames.alerts.icons.texcoords) )
			end
			JSHB.F.Alerts[index].Icon:SetAllPoints(JSHB.F.Alerts[index])
			
			-- Create the Background and border if the user wants one
			JSHB.F.Alerts[index].background = JSHB.MakeBackground(JSHB.F.Alerts[index], JSHB.db.profile.frames.alerts.icons)

			-- Now we can properly set the size of the host frame for the alert icons because we now have offsets.
			if (index == 1) then
				JSHB.F.AlertIconsHost:SetSize(		
					( (JSHB.db.profile.frames.alerts.icons.iconsize + -- WIDTH
						(JSHB.GetFrameOffset(JSHB.F.Alerts[1], "LEFT", 1) + JSHB.GetFrameOffset(JSHB.F.Alerts[1], "RIGHT", 1) + 2) ) * 5) 
						- JSHB.GetFrameOffset(JSHB.F.Alerts[1], "LEFT", 1) - JSHB.GetFrameOffset(JSHB.F.Alerts[1], "RIGHT", 1) - 2,
						
					( (JSHB.db.profile.frames.alerts.icons.iconsize + -- HEIGHT
						(JSHB.GetFrameOffset(JSHB.F.Alerts[1], "TOP", 1) + JSHB.GetFrameOffset(JSHB.F.Alerts[1], "BOTTOM", 1) + 2) ) * 4) 
						- JSHB.GetFrameOffset(JSHB.F.Alerts[1], "LEFT", 1) - JSHB.GetFrameOffset(JSHB.F.Alerts[1], "RIGHT", 1) - 2)

				JSHB.RegisterMovableFrame(
					"MOVER_ALERT_ICONS",
					JSHB.F.AlertIconsHost,
					JSHB.F.AlertIconsHost,
					JSHB.L["Alert Icons"],
					JSHB.db.profile.alerticons,
					index == 1 and JSHB.SetupAlertsModule or nil,
					JSHB.alertIconsDefaults, --JSHB.V["alerticons_defaults"],
					nil) -- No background / Border ever on the mover frame
			end
			
			-- Setup Stacks
			JSHB.F.Alerts[index].stacks = JSHB.F.Alerts[index]:CreateFontString(nil, "OVERLAY")			
			JSHB.F.Alerts[index].stacks:SetJustifyH("RIGHT")
			JSHB.F.Alerts[index].stacks:SetJustifyV("BOTTOM")
			JSHB.F.Alerts[index].stacks:SetPoint("BOTTOMRIGHT", JSHB.F.Alerts[index], "BOTTOMRIGHT", -1, -3)
			JSHB.F.Alerts[index].stacks:SetFont(JSHB.GetActiveFont(JSHB.db.profile.frames.alerts.icons.stackfont) )
			JSHB.F.Alerts[index].stacks:SetTextColor(unpack(JSHB.db.profile.frames.alerts.icons.stackfontcolor), 1)
			JSHB.F.Alerts[index].stacks:SetText("")
			JSHB.F.Alerts[index].stacks:SetAlpha(1)
			
			-- Setup the Sparkles if turned on for this Alert frame
			if JSHB.db.profile.alerts[key].sparkles then
				JSHB.F.Alerts[index].shine = SpellBook_GetAutoCastShine()
				JSHB.F.Alerts[index].shine:Hide()
				JSHB.F.Alerts[index].shine:SetParent(JSHB.F.Alerts[index])
				JSHB.F.Alerts[index].shine:SetSize(JSHB.db.profile.frames.alerts.icons.iconsize + 3, JSHB.db.profile.frames.alerts.icons.iconsize + 3)
				JSHB.F.Alerts[index].shine:SetPoint("CENTER", JSHB.F.Alerts[index], "CENTER")
			end
			
			-- Setup the script for handling the Alert
			JSHB.F.Alerts[index].updateTimer = 0
			JSHB.F.Alerts[index].active = false
			JSHB.F.Alerts[index].spellID = 0
			JSHB.F.Alerts[index].checkID = tonumber(JSHB.db.profile.alerts[key].aura) and JSHB.db.profile.alerts[key].aura or 0
			JSHB.F.Alerts[index].checkName = tonumber(JSHB.db.profile.alerts[key].aura) and "" or strupper(JSHB.db.profile.alerts[key].aura)
			JSHB.F.Alerts[index].hasTip = JSHB.db.profile.alerts[key].tooltips
			JSHB.F.Alerts[index].hasSparkles = JSHB.db.profile.alerts[key].sparkles
			JSHB.F.Alerts[index].soundFile = JSHB.db.profile.alerts[key].enablesound and JSHB.db.profile.alerts[key].sound or nil
			JSHB.F.Alerts[index].alertTrigger = JSHB.db.profile.alerts[key].alerttype
			JSHB.F.Alerts[index].target = JSHB.db.profile.alerts[key].target

			-- Setup Tooltips if turned on
			if JSHB.db.profile.alerts[key].tooltips then			
				JSHB.F.Alerts[index]:SetScript("OnEnter", function(self)
					if self.spellID == 0 then return end
					if (self.alertTrigger == "BUFF") or (self.alertTrigger == "DEBUFF") then
						local index
						for index=1,40 do
							if (select(11, UnitAura("player", index, "HARMFUL") ) == self.spellID) then						
								GameTooltip:SetOwner(self)
								GameTooltip:SetUnitAura("player", index, "HARMFUL")
								GameTooltip:Show()
								return							
							elseif (select(11, UnitAura("player", index, "HELPFUL") ) == self.spellID) then						
								GameTooltip:SetOwner(self)
								GameTooltip:SetUnitAura("player", index, "HELPFUL")
								GameTooltip:Show()
								return
							end
						end
					elseif (self.alertTrigger == "CAST") then
--						GameTooltip:SetOwner(self)
--						GameTooltip:SetSpell(self.spellID) 
--						GameTooltip:Show()
						return
					end
					self:EnableMouse(nil)
				end)
				JSHB.F.Alerts[index]:SetScript("OnLeave", function(self)
					if self.spellID == 0 then return end
					GameTooltip:Hide()
				end)
				JSHB.F.Alerts[index]:EnableMouse(nil)			
			end

			-- OnUpdate handler		
			JSHB.F.Alerts[index]:SetScript("OnUpdate", function(self, elapsed)			
				self.updateTimer = self.updateTimer + elapsed				
				if self.updateTimer < ALERT_UPDATEINTERVAL then return else self.updateTimer = 0 end			
				if self.active == true then
					if (self.killtime < GetTime() ) then
						if self.noTimeCheckFunc and (not self.noTimeCheckFunc() ) then						
							stopDebuffAlert(self, self.spellID)
						end
					else
						if JSHB.moversLocked then
							self:SetAlpha(1)
						end
					end
				end
			end)
			
			-- Setup the event handler
			JSHB.F.Alerts[index]:SetScript("OnEvent", function(self, event, ...)
				-- 4.2 local timeStamp, subEvent, hideCaster, sourceGUID, sourceName, sourceFlags, sourceFlags2, destGUID, destName, destFlags, destFlags2, spellId, spellName, spellSchool, extraSpellID, extraSpellName, extraSchool, auraType = ...
				
				if (self.alertTrigger == "BUFF") or (self.alertTrigger == "DEBUFF") then
				
					local timeStamp, subEvent, sourceName, destGUID, spellId, spellName
					timeStamp, subEvent, _, _, sourceName, _, _, destGUID, _, _, _, spellId, spellName = ...
					
					local retTarget = checkGUIDMatch(self.target, destGUID)

					if (subEvent == "SPELL_AURA_APPLIED") and (retTarget) then
						if (spellId == self.checkID) or (strupper(spellName) == self.checkName) then
							if select(11, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HARMFUL") ) == spellId then
								addDebuffAlert(self, spellId, select(6, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HARMFUL") ),
									select(4, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HARMFUL") ), 
									(select(6, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HARMFUL") ) > .1) and nil or (function(self) return(select(6, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HARMFUL") )) end)
								)
							else
								addDebuffAlert(self, spellId, select(6, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HELPFUL") ),
									select(4, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HELPFUL") ),
									(select(6, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HELPFUL") ) > .1) and nil or (function(self) return(select(6, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HELPFUL") )) end)
								)
							end
						end

					elseif ( (subEvent == "SPELL_AURA_REFRESH") or (subEvent == "SPELL_AURA_APPLIED_DOSE") ) and (retTarget) then
						if (spellId == self.checkID) or (strupper(spellName) == self.checkName) then
							if select(11, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HARMFUL") ) == spellId then						
								refreshDebuffAlert(self, spellId, select(6, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HARMFUL") ),
									select(4, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HARMFUL") ))
							else
								refreshDebuffAlert(self, spellId, select(6, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HELPFUL") ),
									select(4, UnitAura(retTarget, GetSpellInfo(spellId), nil, "HELPFUL") ))
							end
						end

					elseif (subEvent == "SPELL_AURA_REMOVED") and (retTarget) then
						if (spellId == self.checkID) or (strupper(spellName) == self.checkName) then
							stopDebuffAlert(self, spellId)
						end
					end
					
				elseif (self.alertTrigger == "CAST") then
				
					local unitID, spell, _, _, spellID = ...
					local retTarget = checkGUIDMatch(self.target, UnitGUID(unitID) )
					
					if (event == "UNIT_SPELLCAST_START") and (retTarget) then
						if (spellID == self.checkID) or (strupper(spell) == self.checkName) then
							addDebuffAlert(self, spellID, select(7, GetSpellInfo(spellID) ) / 1000 + .2, 0)
						end
					elseif (event == "UNIT_SPELLCAST_CHANNEL_START") and (retTarget) then
						if (spellID == self.checkID) or (strupper(spell) == self.checkName) then
							addDebuffAlert(self, spellID, select(7, GetSpellInfo(spellID) ) / 1000 + .2, 0)
						end
					elseif (event == "UNIT_SPELLCAST_STOP") and (retTarget) then
						if (spellID == self.checkID) or (strupper(spell) == self.checkName) then
							stopDebuffAlert(self, spellID)
						end
					elseif (event == "UNIT_SPELLCAST_INTERRUPTED") and (retTarget) then
						if (spellID == self.checkID) or (strupper(spell) == self.checkName) then
							stopDebuffAlert(self, spellID)
						end
					elseif (event == "UNIT_SPELLCAST_FAILED") and (retTarget) then
						if (spellID == self.checkID) or (strupper(spell) == self.checkName) then
							stopDebuffAlert(self, spellID)
						end
					elseif (event == "UNIT_SPELLCAST_CHANNEL_STOP") and (retTarget) then
						if (spellID == self.checkID) or (strupper(spell) == self.checkName) then
							stopDebuffAlert(self, spellID)
						end
					end
					--[[elseif (event == "UNIT_SPELLCAST_SUCCEEDED") and (retTarget) then
						if (spellID == self.checkID) or (strupper(spell) == self.checkName) then
							stopDebuffAlert(self, spellID)
						end
					end]]
				end
			end)
			
			if (JSHB.F.Alerts[index].alertTrigger == "BUFF") or (JSHB.F.Alerts[index].alertTrigger == "DEBUFF") then
				JSHB.F.Alerts[index]:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
			elseif (JSHB.F.Alerts[index].alertTrigger == "CAST") then
				JSHB.F.Alerts[index]:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START")
				JSHB.F.Alerts[index]:RegisterEvent("UNIT_SPELLCAST_START")
				--JSHB.F.Alerts[index]:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
				JSHB.F.Alerts[index]:RegisterEvent("UNIT_SPELLCAST_STOP")
				JSHB.F.Alerts[index]:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED")
				JSHB.F.Alerts[index]:RegisterEvent("UNIT_SPELLCAST_FAILED")
				JSHB.F.Alerts[index]:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP")
			end

			index = index + 1
		end
	end
	JSHB.totalAlertIcons = index - 1
end
